# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Statistical classes."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _statistics
else:
    import _statistics

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _statistics.delete_SwigPyIterator

    def value(self):
        return _statistics.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _statistics.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _statistics.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _statistics.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _statistics.SwigPyIterator_equal(self, x)

    def copy(self):
        return _statistics.SwigPyIterator_copy(self)

    def next(self):
        return _statistics.SwigPyIterator_next(self)

    def __next__(self):
        return _statistics.SwigPyIterator___next__(self)

    def previous(self):
        return _statistics.SwigPyIterator_previous(self)

    def advance(self, n):
        return _statistics.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _statistics.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _statistics.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _statistics.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _statistics.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _statistics.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _statistics.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _statistics:
_statistics.SwigPyIterator_swigregister(SwigPyIterator)


class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
import openturns.graph
import openturns.func
import openturns.geom
class Compact(openturns.typ.HistoryStrategyImplementation):
    r"""
    Compact history storage strategy.

    Available constructors:
        Compact(*N*)

    Parameters
    ----------
    N : integer
        minimum number of points to store.

    See also
    --------
    HistoryStrategy, Null, Full, Last

    Notes
    -----
    The compact strategy stores a regularly spaced sub-sample where the minimum size
    of the stored numerical sample is :math:`N`. OpenTURNS proceeds as follows :

    1. it stores the first :math:`2N` simulations : the size of the stored
       sample is :math:`2N`,
    2. it selects only 1 out of 2 of the stored simulations : then the size of
       the stored sample decreases to :math:`N` (this is the *compact* step),
    3. it stores the next :math:`N` simulations when selecting 1 out of 2 of the
       next simulations : the size of the stored sample is :math:`2N`,
    4. it selects only 1 out of 2 of the stored simulations : then the size of
       the stored sample decreases to :math:`N`,
    5. it stores the next :math:`N` simulations when selecting 1 out of 4 of the
       next simulations : the size of the stored sample is :math:`2N`,
    6. then it keeps on until reaching the stopping criteria.

    The stored numerical sample will have a size within :math:`N` and :math:`2N` if at least one cycle has been done, else it will be at most :math:`N`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Compact_getClassName(self)

    def store(self, *args):
        r"""
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _statistics.Compact_store(self, *args)

    def setDimension(self, dimension):
        r"""
        Set the dimension of points to store.

        This method must be called before calling the store method.

        Notes
        -----
        It erases the previously stored points

        Parameters
        ----------
        dimension: int
            Dimension of points to store
        """
        return _statistics.Compact_setDimension(self, dimension)

    def getSample(self):
        r"""
        Accessor to the stored sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _statistics.Compact_getSample(self)

    def getHalfMaximumSize(self):
        r"""
        Accessor to the half maximum number of points to store.

        Returns
        -------
        N : integer
            The half maximum number of points to store.
        """
        return _statistics.Compact_getHalfMaximumSize(self)

    def getIndex(self):
        r"""
        Accessor to the index.

        Returns
        -------
        index : integer
            The number of the stored points.
        """
        return _statistics.Compact_getIndex(self)

    def __repr__(self):
        return _statistics.Compact___repr__(self)

    def __init__(self, *args):
        _statistics.Compact_swiginit(self, _statistics.new_Compact(*args))
    __swig_destroy__ = _statistics.delete_Compact

# Register Compact in _statistics:
_statistics.Compact_swigregister(Compact)

class Full(openturns.typ.HistoryStrategyImplementation):
    r"""
    Full history storage strategy.

    Available constructors:
        Full()

    See also
    --------
    HistoryStrategy, Compact, Null, Last

    Notes
    -----
    The full strategy stores every points. Be careful! The memory will be exhausted
    for huge samples.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Full_getClassName(self)

    def store(self, *args):
        r"""
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _statistics.Full_store(self, *args)

    def __repr__(self):
        return _statistics.Full___repr__(self)

    def __init__(self, *args):
        _statistics.Full_swiginit(self, _statistics.new_Full(*args))
    __swig_destroy__ = _statistics.delete_Full

# Register Full in _statistics:
_statistics.Full_swigregister(Full)

class Last(openturns.typ.HistoryStrategyImplementation):
    r"""
    Last history storage strategy.

    Available constructors:
        Last(*N*)

    Parameters
    ----------
    N : integer
        Number of points to store.

    See also
    --------
    HistoryStrategy, Compact, Null, Full

    Notes
    -----
    The last strategy stores only the *N* last points.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Last_getClassName(self)

    def store(self, *args):
        r"""
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _statistics.Last_store(self, *args)

    def setDimension(self, dimension):
        r"""
        Set the dimension of points to store.

        This method must be called before calling the store method.

        Notes
        -----
        It erases the previously stored points

        Parameters
        ----------
        dimension: int
            Dimension of points to store
        """
        return _statistics.Last_setDimension(self, dimension)

    def getSample(self):
        r"""
        Accessor to the stored sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Numerical sample which is the collection of points stored by the history
            strategy.
        """
        return _statistics.Last_getSample(self)

    def getMaximumSize(self):
        r"""
        Accessor to the maximum size of the storage strategy.

        Returns
        -------
        N : integer
            The maximum number of points to store.
        """
        return _statistics.Last_getMaximumSize(self)

    def getIndex(self):
        r"""
        Accessor to the index.

        Returns
        -------
        index : integer
            The index of the storage position.
        """
        return _statistics.Last_getIndex(self)

    def getHasWrapped(self):
        r"""
        Accessor to a wrapped flag.

        Returns
        -------
        wrapped : bool
            Return *True* if the storage has been wrapped.
        """
        return _statistics.Last_getHasWrapped(self)

    def __repr__(self):
        return _statistics.Last___repr__(self)

    def __init__(self, *args):
        _statistics.Last_swiginit(self, _statistics.new_Last(*args))
    __swig_destroy__ = _statistics.delete_Last

# Register Last in _statistics:
_statistics.Last_swigregister(Last)

class Null(openturns.typ.HistoryStrategyImplementation):
    r"""
    Null history storage strategy.

    Available constructors:
        Null()

    See also
    --------
    HistoryStrategy, Compact, Full, Last

    Notes
    -----
    The null strategy does not store anything.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Null_getClassName(self)

    def store(self, *args):
        r"""
        Store points or samples.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            Point or sample to store. 

        Notes
        -----
        It adds a unique point or all the point of the sample in the natural order to
        the history.
        """
        return _statistics.Null_store(self, *args)

    def __repr__(self):
        return _statistics.Null___repr__(self)

    def __init__(self, *args):
        _statistics.Null_swiginit(self, _statistics.new_Null(*args))
    __swig_destroy__ = _statistics.delete_Null

# Register Null in _statistics:
_statistics.Null_swigregister(Null)

class HMatrixParameters(openturns.common.PersistentObject):
    r"""
    Parameters for HMatrix class.

    Notes
    -----
    This class regroups the parameters used by :class:`~openturns.HMatrix`

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HMatrixParameters_getClassName(self)

    def setAssemblyEpsilon(self, assemblyEpsilon):
        r"""
        Set the epsilon used for the assembly.

        Parameters
        ----------
        epsilon : float
            assembly epsilon for HMatrix.
        """
        return _statistics.HMatrixParameters_setAssemblyEpsilon(self, assemblyEpsilon)

    def getAssemblyEpsilon(self):
        r"""
        Return the epsilon used for the assembly.

        Returns
        -------
        epsilon : float
            assembly epsilon for HMatrix.
        """
        return _statistics.HMatrixParameters_getAssemblyEpsilon(self)

    def setRecompressionEpsilon(self, recompressionEpsilon):
        r"""
        Set the epsilon used for the recompression.

        Parameters
        ----------
        epsilon : float
            recompression epsilon for HMatrix.
        """
        return _statistics.HMatrixParameters_setRecompressionEpsilon(self, recompressionEpsilon)

    def getRecompressionEpsilon(self):
        r"""
        Return the epsilon used for the recompression.

        Returns
        -------
        epsilon : float
            recompression epsilon for HMatrix.
        """
        return _statistics.HMatrixParameters_getRecompressionEpsilon(self)

    def setAdmissibilityFactor(self, admissibilityFactor):
        r"""
        Set the admissibility factor used for cluster blocks.

        Parameters
        ----------
        epsilon : float
            admissibility factor for HMatrix.
        """
        return _statistics.HMatrixParameters_setAdmissibilityFactor(self, admissibilityFactor)

    def getAdmissibilityFactor(self):
        r"""
        Return the admissibility factor used for cluster blocks.

        Returns
        -------
        epsilon : float
            admissibility factor for HMatrix.
        """
        return _statistics.HMatrixParameters_getAdmissibilityFactor(self)

    def setClusteringAlgorithm(self, clusteringAlgorithm):
        r"""
        Set the clustering algorithm.

        Parameters
        ----------
        algorithm : str
            clustering algorithm (either 'median', 'geometric' or 'hybrid').
        """
        return _statistics.HMatrixParameters_setClusteringAlgorithm(self, clusteringAlgorithm)

    def getClusteringAlgorithm(self):
        r"""
        Return the clustering algorithm.

        Returns
        -------
        algorithm : str
            clustering algorithm (either 'median', 'geometric' or 'hybrid').
        """
        return _statistics.HMatrixParameters_getClusteringAlgorithm(self)

    def setCompressionMethod(self, compressionMethod):
        r"""
        Set the compression method.

        Parameters
        ----------
        method : str
            compression method (either Svd, AcaFull, AcaPartial, AcaPlus or AcaRandom.
        """
        return _statistics.HMatrixParameters_setCompressionMethod(self, compressionMethod)

    def getCompressionMethod(self):
        r"""
        Return the compression method.

        Returns
        -------
        method : str
            compression method (either Svd, AcaFull, AcaPartial, AcaPlus or AcaRandom.
        """
        return _statistics.HMatrixParameters_getCompressionMethod(self)

    def __repr__(self):
        return _statistics.HMatrixParameters___repr__(self)

    def __str__(self, *args):
        return _statistics.HMatrixParameters___str__(self, *args)

    def __init__(self, *args):
        _statistics.HMatrixParameters_swiginit(self, _statistics.new_HMatrixParameters(*args))
    __swig_destroy__ = _statistics.delete_HMatrixParameters

# Register HMatrixParameters in _statistics:
_statistics.HMatrixParameters_swigregister(HMatrixParameters)

class TestResultCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _statistics.delete_TestResultCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _statistics.TestResultCollection_clear(self)

    def __len__(self):
        return _statistics.TestResultCollection___len__(self)

    def __eq__(self, rhs):
        return _statistics.TestResultCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _statistics.TestResultCollection___contains__(self, val)

    def __getitem__(self, i):
        return _statistics.TestResultCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _statistics.TestResultCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _statistics.TestResultCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _statistics.TestResultCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _statistics.TestResultCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _statistics.TestResultCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _statistics.TestResultCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _statistics.TestResultCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _statistics.TestResultCollection_find(self, val)

    def __repr__(self):
        return _statistics.TestResultCollection___repr__(self)

    def __str__(self, *args):
        return _statistics.TestResultCollection___str__(self, *args)

    def __init__(self, *args):
        _statistics.TestResultCollection_swiginit(self, _statistics.new_TestResultCollection(*args))

# Register TestResultCollection in _statistics:
_statistics.TestResultCollection_swigregister(TestResultCollection)

class TestResult(openturns.common.PersistentObject):
    r"""
    Test result data structure.

    .. warning::

        Tests results are not intended to be created manually. They are returned
        by the statistical tests implemented in the :mod:`~openturns.stattests`
        subpackage. Constructor is therefore intentionally not documented.

    Notes
    -----
    The p-value of a test can be seen as the probability of observing a sample
    having a worst or equal statistic than the one that has been calculated on the
    tested sample, under the null hypothesis. This is the metric that is used for
    concluding the test with respect to the given accepted risk of committing a
    Type I error, that is an incorrect rejection of a true null hypothesis.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal()
    >>> sample = distribution.getSample(30)
    >>> dist, test_result = ot.FittingTest.Kolmogorov(sample, ot.NormalFactory(), 0.01)
    >>> print(test_result.getPValue())
    0.7...
    >>> print(test_result.getThreshold())
    0.01...
    >>> print(test_result.getBinaryQualityMeasure())
    True
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.TestResult_getClassName(self)

    def setDescription(self, description):
        return _statistics.TestResult_setDescription(self, description)

    def getDescription(self):
        return _statistics.TestResult_getDescription(self)

    def __repr__(self):
        return _statistics.TestResult___repr__(self)

    def getBinaryQualityMeasure(self):
        r"""
        Accessor to the test's binary conclusion.

        Returns
        -------
        binary_measure : bool, optional
            Test conclusion: `False` if it can reject the null hypothesis, `True` if
            it cannot.
        """
        return _statistics.TestResult_getBinaryQualityMeasure(self)

    def getPValue(self):
        r"""
        Accessor to the test's p-value.

        Returns
        -------
        p_value : float, :math:`0 \leq p \leq 1`
            The test's p-value.
        """
        return _statistics.TestResult_getPValue(self)

    def getThreshold(self):
        r"""
        Accessor to the accepted risk of committing a Type I error.

        Returns
        -------
        threshold : float, :math:`0 \leq \alpha \leq 1`
            Accepted risk of committing a Type I error.
        """
        return _statistics.TestResult_getThreshold(self)

    def getTestType(self):
        return _statistics.TestResult_getTestType(self)

    def getStatistic(self):
        r"""
        Accessor to the used statistic for decision.

        Returns
        -------
        statistic : float
            Measure used for the statistical test.
        """
        return _statistics.TestResult_getStatistic(self)

    def __eq__(self, other):
        return _statistics.TestResult___eq__(self, other)

    def __init__(self, *args):
        _statistics.TestResult_swiginit(self, _statistics.new_TestResult(*args))
    __swig_destroy__ = _statistics.delete_TestResult

# Register TestResult in _statistics:
_statistics.TestResult_swigregister(TestResult)

class RandomGeneratorState(openturns.common.PersistentObject):
    r"""
    Random generator state.

    Data structure used to save the internal state of the generator.

    Parameters
    ----------
    buffer : sequence of int
        The history buffer
    index : int
        The index into buffer
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.RandomGeneratorState_getClassName(self)

    def __repr__(self):
        return _statistics.RandomGeneratorState___repr__(self)

    def __str__(self, *args):
        return _statistics.RandomGeneratorState___str__(self, *args)

    def getBuffer(self):
        r"""
        Random generator state buffer accessor.

        Returns
        -------
        buffer : sequence of int
            The history buffer
        """
        return _statistics.RandomGeneratorState_getBuffer(self)

    def getIndex(self):
        r"""
        Random generator state index accessor.

        Returns
        -------
        index : int
            The index into buffer
        """
        return _statistics.RandomGeneratorState_getIndex(self)

    def __init__(self, *args):
        _statistics.RandomGeneratorState_swiginit(self, _statistics.new_RandomGeneratorState(*args))

    def __eq__(self, *args):
        return _statistics.RandomGeneratorState___eq__(self, *args)
    __swig_destroy__ = _statistics.delete_RandomGeneratorState

# Register RandomGeneratorState in _statistics:
_statistics.RandomGeneratorState_swigregister(RandomGeneratorState)

class RandomGenerator(object):
    r"""
    Uniform random generator.

    Refer to :ref:`uniform_random_generator`.

    The random generator of uniform(0,1) samples is based on the DSFTM
    (Double precision SIMD oriented Fast Mersenne Twister) algorithm.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def SetSeed(seed):
        r"""
        Set the seed of the random generator.

        Parameters
        ----------
        n : int :math:`\in [0, 2^{32}-1]`

        Notes
        -----
        This method fixes a particular state of the random generator algorithm
        thanks to the seed :math:`n`. The seed of the random generator is automatically
        initialized to 0 when a session is launched.
        """
        return _statistics.RandomGenerator_SetSeed(seed)

    @staticmethod
    def SetState(state):
        r"""
        Set the state of the random generator.

        Parameters
        ----------
        particularState : :class:`~openturns.RandomGeneratorState`
            State of the random generator.

        Notes
        -----
        This method fixes the entire state of the random generator algorithm
        thanks the specification of the entire state *particularState* usually
        previously obtained thanks to the :meth:`GetState` method.
        """
        return _statistics.RandomGenerator_SetState(state)

    @staticmethod
    def GetState():
        r"""
        Get the state of the random generator.

        Returns
        -------
        particularState : :class:`~openturns.RandomGeneratorState`
            State of the random generator.
        """
        return _statistics.RandomGenerator_GetState()

    @staticmethod
    def Generate(*args):
        r"""
        Generate a pseudo-random vector.

        Parameters
        ----------
        size : positive int
            Number of realizations required. When not given, by default it is equal to
            1.

        Returns
        -------
        numbers : float, :class:`~openturns.Point`
            Pseudo-random numbers uniformly distributed over :math:`[0, 1[`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print('%.6f' % ot.RandomGenerator.Generate())
        0.629877
        >>> print(ot.RandomGenerator.Generate(2))
        [0.882805,0.135276]
        """
        return _statistics.RandomGenerator_Generate(*args)

    @staticmethod
    def IntegerGenerate(*args):
        r"""
        Generate a pseudo-random integer.

        :Available usages:
            IntegerGenerate(*n*)

            IntegerGenerate(*size, n*)

        Parameters
        ----------
        n : positive int
            Upper bound of the interval where the pseudo-random integers are.
        size : positive int
            Number of integers to generate. When not given, by default it is equal to
            1.

        Returns
        -------
        integer : int, :class:`~openturns.UnsignedIntegerCollection`
            Pseudo-random integers uniformly distributed over :math:`[0,...,n-1]`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(ot.RandomGenerator.IntegerGenerate(30))
        24
        >>> print(ot.RandomGenerator.IntegerGenerate(5, 30))
        [26,21,21,22,26]
        """
        return _statistics.RandomGenerator_IntegerGenerate(*args)
    __swig_destroy__ = _statistics.delete_RandomGenerator

# Register RandomGenerator in _statistics:
_statistics.RandomGenerator_swigregister(RandomGenerator)

def RandomGenerator_SetSeed(seed):
    r"""
    Set the seed of the random generator.

    Parameters
    ----------
    n : int :math:`\in [0, 2^{32}-1]`

    Notes
    -----
    This method fixes a particular state of the random generator algorithm
    thanks to the seed :math:`n`. The seed of the random generator is automatically
    initialized to 0 when a session is launched.
    """
    return _statistics.RandomGenerator_SetSeed(seed)

def RandomGenerator_SetState(state):
    r"""
    Set the state of the random generator.

    Parameters
    ----------
    particularState : :class:`~openturns.RandomGeneratorState`
        State of the random generator.

    Notes
    -----
    This method fixes the entire state of the random generator algorithm
    thanks the specification of the entire state *particularState* usually
    previously obtained thanks to the :meth:`GetState` method.
    """
    return _statistics.RandomGenerator_SetState(state)

def RandomGenerator_GetState():
    r"""
    Get the state of the random generator.

    Returns
    -------
    particularState : :class:`~openturns.RandomGeneratorState`
        State of the random generator.
    """
    return _statistics.RandomGenerator_GetState()

def RandomGenerator_Generate(*args):
    r"""
    Generate a pseudo-random vector.

    Parameters
    ----------
    size : positive int
        Number of realizations required. When not given, by default it is equal to
        1.

    Returns
    -------
    numbers : float, :class:`~openturns.Point`
        Pseudo-random numbers uniformly distributed over :math:`[0, 1[`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> print('%.6f' % ot.RandomGenerator.Generate())
    0.629877
    >>> print(ot.RandomGenerator.Generate(2))
    [0.882805,0.135276]
    """
    return _statistics.RandomGenerator_Generate(*args)

def RandomGenerator_IntegerGenerate(*args):
    r"""
    Generate a pseudo-random integer.

    :Available usages:
        IntegerGenerate(*n*)

        IntegerGenerate(*size, n*)

    Parameters
    ----------
    n : positive int
        Upper bound of the interval where the pseudo-random integers are.
    size : positive int
        Number of integers to generate. When not given, by default it is equal to
        1.

    Returns
    -------
    integer : int, :class:`~openturns.UnsignedIntegerCollection`
        Pseudo-random integers uniformly distributed over :math:`[0,...,n-1]`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> print(ot.RandomGenerator.IntegerGenerate(30))
    24
    >>> print(ot.RandomGenerator.IntegerGenerate(5, 30))
    [26,21,21,22,26]
    """
    return _statistics.RandomGenerator_IntegerGenerate(*args)

class LowDiscrepancySequenceImplementation(openturns.common.PersistentObject):
    r"""
    Base class to generate low discrepancy sequences.

    Available constructors:
        LowDiscrepancySequence(*dimension=1*)

    Parameters
    ----------
    dimension : int
        Dimension of the points of the low discrepancy sequence.

    Notes
    -----
    The low discrepancy sequences, also called 'quasi-random' sequences, are a
    deterministic alternative to random sequences for use in Monte Carlo methods.
    These sequences are sets of equidistributed points which the error in uniformity
    is measured by its discrepancy.

    The **discrepancy** of a set :math:`P = \{x_1, \hdots, x_N\}` is defined,
    using Niederreiter's notation, as:

    .. math::

        D_N(P) = \sup_{B\in J} \left| \frac{A(B;P)}{N} - \lambda_s(B) \right|

    where :math:`\lambda_s` is the s-dimensional Lebesgue measure, :math:`A(B;P)`
    is the number of points in :math:`P` that fall into :math:`B`, and :math:`J` is
    the set of s-dimensional intervals or boxes of the form:

    .. math::

        \prod_{i=1}^s [a_i, b_i) = \{ \mathbf{x} \in \mathbf{R}^s : a_i \le x_i < b_i \} \,

    where :math:`0 \le a_i < b_i \le 1`.

    The star-discrepancy :math:`D_N^*(P)` is defined similarly, except that the
    supremum is taken over the set :math:`J^*` of intervals of the form:

    .. math::

        \prod_{i=1}^s [0, u_i)

    where :math:`u_i` is in the half-open interval :math:`[0, 1)`.

    A low-discrepancy sequence can be generated only through the derived classes of
    LowDiscrepancySequence. The sequences implemented are
    :class:`Faure <openturns.FaureSequence>`,
    :class:`Halton <openturns.HaltonSequence>`,
    :class:`Reverse Halton <openturns.ReverseHaltonSequence>`,
    :class:`Haselgrove <openturns.HaselgroveSequence>` and
    :class:`Sobol <openturns.SobolSequence>` sequences.

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a sequence of 3 points of 2 dimensions
    >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
    >>> print(sequence.generate(3))
    0 : [ 0.5  0.5  ]
    1 : [ 0.75 0.25 ]
    2 : [ 0.25 0.75 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.LowDiscrepancySequenceImplementation_getClassName(self)

    def initialize(self, dimension):
        r"""
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.LowDiscrepancySequenceImplementation_initialize(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension of the points of the low discrepancy sequence.

        Returns
        -------
        dimension : int
            Dimension of the points of the low discrepancy sequence.
        """
        return _statistics.LowDiscrepancySequenceImplementation_getDimension(self)

    def generate(self, *args):
        r"""
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.LowDiscrepancySequenceImplementation_generate(self, *args)

    @staticmethod
    def ComputeStarDiscrepancy(sample):
        r"""
        Compute the star discrepancy of a sample uniformly distributed over [0, 1).

        Parameters
        ----------
        sample : 2-d sequence of float

        Returns
        -------
        starDiscrepancy : float
            Star discrepancy of a sample uniformly distributed over [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> sample = sequence.generate(16)
        >>> print(sequence.computeStarDiscrepancy(sample))
        0.12890625
        >>> sample = sequence.generate(64)
        >>> print(sequence.computeStarDiscrepancy(sample))
        0.0537109375
        """
        return _statistics.LowDiscrepancySequenceImplementation_ComputeStarDiscrepancy(sample)

    def __repr__(self):
        return _statistics.LowDiscrepancySequenceImplementation___repr__(self)

    def __init__(self, *args):
        _statistics.LowDiscrepancySequenceImplementation_swiginit(self, _statistics.new_LowDiscrepancySequenceImplementation(*args))
    __swig_destroy__ = _statistics.delete_LowDiscrepancySequenceImplementation

# Register LowDiscrepancySequenceImplementation in _statistics:
_statistics.LowDiscrepancySequenceImplementation_swigregister(LowDiscrepancySequenceImplementation)

def LowDiscrepancySequenceImplementation_ComputeStarDiscrepancy(sample):
    r"""
    Compute the star discrepancy of a sample uniformly distributed over [0, 1).

    Parameters
    ----------
    sample : 2-d sequence of float

    Returns
    -------
    starDiscrepancy : float
        Star discrepancy of a sample uniformly distributed over [0, 1).

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a sequence of 3 points of 2 dimensions
    >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
    >>> sample = sequence.generate(16)
    >>> print(sequence.computeStarDiscrepancy(sample))
    0.12890625
    >>> sample = sequence.generate(64)
    >>> print(sequence.computeStarDiscrepancy(sample))
    0.0537109375
    """
    return _statistics.LowDiscrepancySequenceImplementation_ComputeStarDiscrepancy(sample)

class LowDiscrepancySequenceImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_swiginit(self, _statistics.new_LowDiscrepancySequenceImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _statistics.delete_LowDiscrepancySequenceImplementationTypedInterfaceObject

# Register LowDiscrepancySequenceImplementationTypedInterfaceObject in _statistics:
_statistics.LowDiscrepancySequenceImplementationTypedInterfaceObject_swigregister(LowDiscrepancySequenceImplementationTypedInterfaceObject)

class LowDiscrepancySequence(LowDiscrepancySequenceImplementationTypedInterfaceObject):
    r"""
    Base class to generate low discrepancy sequences.

    Available constructors:
        LowDiscrepancySequence(*dimension=1*)

    Parameters
    ----------
    dimension : int
        Dimension of the points of the low discrepancy sequence.

    Notes
    -----
    The low discrepancy sequences, also called 'quasi-random' sequences, are a
    deterministic alternative to random sequences for use in Monte Carlo methods.
    These sequences are sets of equidistributed points which the error in uniformity
    is measured by its discrepancy.

    The **discrepancy** of a set :math:`P = \{x_1, \hdots, x_N\}` is defined,
    using Niederreiter's notation, as:

    .. math::

        D_N(P) = \sup_{B\in J} \left| \frac{A(B;P)}{N} - \lambda_s(B) \right|

    where :math:`\lambda_s` is the s-dimensional Lebesgue measure, :math:`A(B;P)`
    is the number of points in :math:`P` that fall into :math:`B`, and :math:`J` is
    the set of s-dimensional intervals or boxes of the form:

    .. math::

        \prod_{i=1}^s [a_i, b_i) = \{ \mathbf{x} \in \mathbf{R}^s : a_i \le x_i < b_i \} \,

    where :math:`0 \le a_i < b_i \le 1`.

    The star-discrepancy :math:`D_N^*(P)` is defined similarly, except that the
    supremum is taken over the set :math:`J^*` of intervals of the form:

    .. math::

        \prod_{i=1}^s [0, u_i)

    where :math:`u_i` is in the half-open interval :math:`[0, 1)`.

    A low-discrepancy sequence can be generated only through the derived classes of
    LowDiscrepancySequence. The sequences implemented are
    :class:`Faure <openturns.FaureSequence>`,
    :class:`Halton <openturns.HaltonSequence>`,
    :class:`Reverse Halton <openturns.ReverseHaltonSequence>`,
    :class:`Haselgrove <openturns.HaselgroveSequence>` and
    :class:`Sobol <openturns.SobolSequence>` sequences.

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a sequence of 3 points of 2 dimensions
    >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
    >>> print(sequence.generate(3))
    0 : [ 0.5  0.5  ]
    1 : [ 0.75 0.25 ]
    2 : [ 0.25 0.75 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.LowDiscrepancySequence_getClassName(self)

    def initialize(self, dimension):
        r"""
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.LowDiscrepancySequence_initialize(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension of the points of the low discrepancy sequence.

        Returns
        -------
        dimension : int
            Dimension of the points of the low discrepancy sequence.
        """
        return _statistics.LowDiscrepancySequence_getDimension(self)

    def generate(self, *args):
        r"""
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.LowDiscrepancySequence_generate(self, *args)

    def computeStarDiscrepancy(self, sample):
        r"""
        Compute the star discrepancy of a sample uniformly distributed over [0, 1).

        Parameters
        ----------
        sample : 2-d sequence of float

        Returns
        -------
        starDiscrepancy : float
            Star discrepancy of a sample uniformly distributed over [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> sample = sequence.generate(16)
        >>> print(sequence.computeStarDiscrepancy(sample))
        0.12890625
        >>> sample = sequence.generate(64)
        >>> print(sequence.computeStarDiscrepancy(sample))
        0.0537109375
        """
        return _statistics.LowDiscrepancySequence_computeStarDiscrepancy(self, sample)

    def __repr__(self):
        return _statistics.LowDiscrepancySequence___repr__(self)

    def __init__(self, *args):
        _statistics.LowDiscrepancySequence_swiginit(self, _statistics.new_LowDiscrepancySequence(*args))
    __swig_destroy__ = _statistics.delete_LowDiscrepancySequence

# Register LowDiscrepancySequence in _statistics:
_statistics.LowDiscrepancySequence_swigregister(LowDiscrepancySequence)

class SobolSequence(LowDiscrepancySequenceImplementation):
    r"""
    Sobol sequence.

    Available constructors:
        SobolSequence(*dimension=1*)

    Parameters
    ----------
    dimension : positive int, :math:`1\leq d \leq 1111`
        Dimension of the points.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.SobolSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.5   0.5   ]
    1 : [ 0.75  0.25  ]
    2 : [ 0.25  0.75  ]
    3 : [ 0.375 0.375 ]
    4 : [ 0.875 0.875 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SobolSequence_getClassName(self)

    def initialize(self, dimension):
        r"""
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.SobolSequence_initialize(self, dimension)

    def generate(self, *args):
        r"""
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.SobolSequence_generate(self, *args)

    def __repr__(self):
        return _statistics.SobolSequence___repr__(self)

    def __init__(self, *args):
        _statistics.SobolSequence_swiginit(self, _statistics.new_SobolSequence(*args))
    __swig_destroy__ = _statistics.delete_SobolSequence

# Register SobolSequence in _statistics:
_statistics.SobolSequence_swigregister(SobolSequence)
cvar = _statistics.cvar
SobolSequence.MaximumNumberOfDimension = _statistics.cvar.SobolSequence_MaximumNumberOfDimension
SobolSequence.MaximumBase2Logarithm = _statistics.cvar.SobolSequence_MaximumBase2Logarithm
SobolSequence.Epsilon = _statistics.cvar.SobolSequence_Epsilon
SobolSequence.MaximumInitialDegree = _statistics.cvar.SobolSequence_MaximumInitialDegree
SobolSequence.InitialBase = _statistics.cvar.SobolSequence_InitialBase
SobolSequence.PrimitivePolynomial = _statistics.cvar.SobolSequence_PrimitivePolynomial

class FaureSequence(LowDiscrepancySequenceImplementation):
    r"""
    Faure sequence.

    Available constructors:
        FaureSequence(*dimension=1*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.FaureSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.5   0.5   ]
    1 : [ 0.25  0.75  ]
    2 : [ 0.75  0.25  ]
    3 : [ 0.125 0.625 ]
    4 : [ 0.625 0.125 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FaureSequence_getClassName(self)

    def initialize(self, dimension):
        r"""
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.FaureSequence_initialize(self, dimension)

    def generate(self, *args):
        r"""
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.FaureSequence_generate(self, *args)

    def __repr__(self):
        return _statistics.FaureSequence___repr__(self)

    def __init__(self, *args):
        _statistics.FaureSequence_swiginit(self, _statistics.new_FaureSequence(*args))
    __swig_destroy__ = _statistics.delete_FaureSequence

# Register FaureSequence in _statistics:
_statistics.FaureSequence_swigregister(FaureSequence)

class HaltonSequence(LowDiscrepancySequenceImplementation):
    r"""
    Halton sequence.

    Available constructors:
        HaltonSequence(*dimension=1*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.HaltonSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.5      0.333333 ]
    1 : [ 0.25     0.666667 ]
    2 : [ 0.75     0.111111 ]
    3 : [ 0.125    0.444444 ]
    4 : [ 0.625    0.777778 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HaltonSequence_getClassName(self)

    def initialize(self, dimension):
        r"""
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.HaltonSequence_initialize(self, dimension)

    def generate(self, *args):
        r"""
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.HaltonSequence_generate(self, *args)

    def __repr__(self):
        return _statistics.HaltonSequence___repr__(self)

    def __str__(self, *args):
        return _statistics.HaltonSequence___str__(self, *args)

    def __init__(self, *args):
        _statistics.HaltonSequence_swiginit(self, _statistics.new_HaltonSequence(*args))
    __swig_destroy__ = _statistics.delete_HaltonSequence

# Register HaltonSequence in _statistics:
_statistics.HaltonSequence_swigregister(HaltonSequence)

class HaselgroveSequence(LowDiscrepancySequenceImplementation):
    r"""
    Haselgrove sequence.

    Available constructors:
        HaselgroveSequence(*dimension=1*)

        HaselgroveSequence(*base*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.
    base : sequence of positive float
        Sequence of positive real values linearly independent over the integer
        ring, i.e. no linear combination with integer coefficients of these values
        can be zero excepted if all the coefficients are zero. The dimension of the
        sequence is given by the dimension of the base.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.HaselgroveSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.414214  0.732051  ]
    1 : [ 0.828427  0.464102  ]
    2 : [ 0.242641  0.196152  ]
    3 : [ 0.656854  0.928203  ]
    4 : [ 0.0710678 0.660254  ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HaselgroveSequence_getClassName(self)

    def initialize(self, dimension):
        r"""
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.HaselgroveSequence_initialize(self, dimension)

    def generate(self, *args):
        r"""
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.HaselgroveSequence_generate(self, *args)

    def __repr__(self):
        return _statistics.HaselgroveSequence___repr__(self)

    def __str__(self, *args):
        return _statistics.HaselgroveSequence___str__(self, *args)

    def __init__(self, *args):
        _statistics.HaselgroveSequence_swiginit(self, _statistics.new_HaselgroveSequence(*args))
    __swig_destroy__ = _statistics.delete_HaselgroveSequence

# Register HaselgroveSequence in _statistics:
_statistics.HaselgroveSequence_swigregister(HaselgroveSequence)

class ReverseHaltonSequence(LowDiscrepancySequenceImplementation):
    r"""
    Reverse Halton sequence.

    Available constructors:
        ReverseHaltonSequence(*dimension=1*)

    Parameters
    ----------
    dimension : positive int
        Dimension of the points.

    Examples
    --------
    >>> import openturns as ot
    >>> sequence = ot.ReverseHaltonSequence(2)
    >>> print(sequence.generate(5))
    0 : [ 0.5      0.666667 ]
    1 : [ 0.25     0.333333 ]
    2 : [ 0.75     0.222222 ]
    3 : [ 0.125    0.888889 ]
    4 : [ 0.625    0.555556 ]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ReverseHaltonSequence_getClassName(self)

    def initialize(self, dimension):
        r"""
        Initialize the sequence.

        Parameters
        ----------
        dimension : int
            Dimension of the points of the low discrepancy sequence.

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        >>> print(sequence.generate(3))
        0 : [ 0.375 0.375 ]
        1 : [ 0.875 0.875 ]
        2 : [ 0.625 0.125 ]
        >>> sequence.initialize(2)
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.ReverseHaltonSequence_initialize(self, dimension)

    def generate(self, *args):
        r"""
        Generate a sample of pseudo-random vectors of numbers uniformly distributed over [0, 1).

        Parameters
        ----------
        size : int
            Number of points to be generated. Default is 1.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Sample of pseudo-random vectors of numbers uniformly distributed over
            [0, 1).

        Examples
        --------
        >>> import openturns as ot
        >>> # Create a sequence of 3 points of 2 dimensions
        >>> sequence = ot.LowDiscrepancySequence(ot.SobolSequence(2))
        >>> print(sequence.generate(3))
        0 : [ 0.5  0.5  ]
        1 : [ 0.75 0.25 ]
        2 : [ 0.25 0.75 ]
        """
        return _statistics.ReverseHaltonSequence_generate(self, *args)

    def __repr__(self):
        return _statistics.ReverseHaltonSequence___repr__(self)

    def __init__(self, *args):
        _statistics.ReverseHaltonSequence_swiginit(self, _statistics.new_ReverseHaltonSequence(*args))
    __swig_destroy__ = _statistics.delete_ReverseHaltonSequence

# Register ReverseHaltonSequence in _statistics:
_statistics.ReverseHaltonSequence_swigregister(ReverseHaltonSequence)

class CorrelationAnalysis(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def PearsonCorrelation(inputSample, outputSample):
        r"""
        Correlation evaluation based on the Pearson correlation coefficient.

        Refer to :ref:`pearson_coefficient`.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.Point`
            The Pearson coefficients evaluated between the *sample2* and each coordinate of
            *sample1*.

        See Also
        --------
        CorrelationAnalysis_PCC, CorrelationAnalysis_SRC,
        CorrelationAnalysis_SpearmanCorrelation
        """
        return _statistics.CorrelationAnalysis_PearsonCorrelation(inputSample, outputSample)

    @staticmethod
    def SpearmanCorrelation(inputSample, outputSample):
        r"""
        Correlation evaluation based on the Spearman correlation coefficient.

        Refer to :ref:`spearman_coefficient`.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.Point`
            The Spearman coefficients evaluated between the *sample2* and each coordinate of
            *sample1* (based on the rank values).

        See Also
        --------
        CorrelationAnalysis_PRCC, CorrelationAnalysis_SRRC,
        CorrelationAnalysis_PearsonCorrelation
        """
        return _statistics.CorrelationAnalysis_SpearmanCorrelation(inputSample, outputSample)

    @staticmethod
    def SRC(inputSample, outputSample, normalize=False):
        r"""
        Correlation evaluation based on the Standard Regression Coefficient.

        Refer to :ref:`ranking_src`.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \geq 1`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.
        normalize : bool
            if True, coefficients sum to one.
            Otherwise it includes noise variance
            Default value is false.

        Returns
        -------
        coef : :class:`~openturns.Point`
            The SRC evaluated between the *sample2* and each coordinate of the *sample1*.

        See Also
        --------
        CorrelationAnalysis_PearsonCorrelation, CorrelationAnalysis_PCC,
        CorrelationAnalysis_SRRC
        """
        return _statistics.CorrelationAnalysis_SRC(inputSample, outputSample, normalize)

    @staticmethod
    def SignedSRC(inputSample, outputSample):
        r"""
        Correlation evaluation based on the Signed Standard Rank Regression Coefficient.

        It takes into account the linear coefficient sign.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \geq 1`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.Point`
            The SRC evaluated between the *sample2* and each coordinate of the
            *sample1* (based on the rank value).

        See Also
        --------
        CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_PRCC,
        CorrelationAnalysis_SRC, CorrelationAnalysis_SRRC
        """
        return _statistics.CorrelationAnalysis_SignedSRC(inputSample, outputSample)

    @staticmethod
    def PCC(inputSample, outputSample):
        r"""
        Correlation evaluation based on the Partial Correlation Coefficient.

        Refer to :ref:`ranking_pcc`.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \geq 2`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.Point`
            The PCC coefficients evaluated between the *sample2* and each coordinate of
            *sample1*.

        See Also
        --------
        CorrelationAnalysis_PearsonCorrelation, CorrelationAnalysis_SRC, 
        CorrelationAnalysis_PRCC
        """
        return _statistics.CorrelationAnalysis_PCC(inputSample, outputSample)

    @staticmethod
    def SRRC(inputSample, outputSample, normalize=False):
        r"""
        Correlation evaluation based on the Standard Rank Regression Coefficient.

        Similar as SRC evaluated on the ranked samples.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \geq 1`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.
        normalize : bool
            if True, coefficients sum to one.
            Otherwise it includes noise variance
            Default value is false.

        Returns
        -------
        coef : :class:`~openturns.Point`
            The SRRC evaluated between the *sample2* and each coordinate of the
            *sample1* (based on the rank value).

        See Also
        --------
        CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_PRCC,
        CorrelationAnalysis_SRC
        """
        return _statistics.CorrelationAnalysis_SRRC(inputSample, outputSample, normalize)

    @staticmethod
    def PRCC(inputSample, outputSample):
        r"""
        Correlation evaluation based on the Partial Rank Correlation Coefficient.

        Refer to :ref:`ranking_prcc`.

        Parameters
        ----------
        sample1 : 2-d sequence of float
            First sample, of dimension :math:`n \geq 2`.
        sample2 : 2-d sequence of float
            Second sample, of dimension = 1.

        Returns
        -------
        coef : :class:`~openturns.Point`
            The PRCC coefficients evaluated between the *sample2* and each coordinate of
            *sample1* (based on the rank values).

        See Also
        --------
        CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_SRRC,
        CorrelationAnalysis_PCC
        """
        return _statistics.CorrelationAnalysis_PRCC(inputSample, outputSample)
    __swig_destroy__ = _statistics.delete_CorrelationAnalysis

# Register CorrelationAnalysis in _statistics:
_statistics.CorrelationAnalysis_swigregister(CorrelationAnalysis)

def CorrelationAnalysis_PearsonCorrelation(inputSample, outputSample):
    r"""
    Correlation evaluation based on the Pearson correlation coefficient.

    Refer to :ref:`pearson_coefficient`.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.Point`
        The Pearson coefficients evaluated between the *sample2* and each coordinate of
        *sample1*.

    See Also
    --------
    CorrelationAnalysis_PCC, CorrelationAnalysis_SRC,
    CorrelationAnalysis_SpearmanCorrelation
    """
    return _statistics.CorrelationAnalysis_PearsonCorrelation(inputSample, outputSample)

def CorrelationAnalysis_SpearmanCorrelation(inputSample, outputSample):
    r"""
    Correlation evaluation based on the Spearman correlation coefficient.

    Refer to :ref:`spearman_coefficient`.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.Point`
        The Spearman coefficients evaluated between the *sample2* and each coordinate of
        *sample1* (based on the rank values).

    See Also
    --------
    CorrelationAnalysis_PRCC, CorrelationAnalysis_SRRC,
    CorrelationAnalysis_PearsonCorrelation
    """
    return _statistics.CorrelationAnalysis_SpearmanCorrelation(inputSample, outputSample)

def CorrelationAnalysis_SRC(inputSample, outputSample, normalize=False):
    r"""
    Correlation evaluation based on the Standard Regression Coefficient.

    Refer to :ref:`ranking_src`.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \geq 1`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.
    normalize : bool
        if True, coefficients sum to one.
        Otherwise it includes noise variance
        Default value is false.

    Returns
    -------
    coef : :class:`~openturns.Point`
        The SRC evaluated between the *sample2* and each coordinate of the *sample1*.

    See Also
    --------
    CorrelationAnalysis_PearsonCorrelation, CorrelationAnalysis_PCC,
    CorrelationAnalysis_SRRC
    """
    return _statistics.CorrelationAnalysis_SRC(inputSample, outputSample, normalize)

def CorrelationAnalysis_SignedSRC(inputSample, outputSample):
    r"""
    Correlation evaluation based on the Signed Standard Rank Regression Coefficient.

    It takes into account the linear coefficient sign.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \geq 1`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.Point`
        The SRC evaluated between the *sample2* and each coordinate of the
        *sample1* (based on the rank value).

    See Also
    --------
    CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_PRCC,
    CorrelationAnalysis_SRC, CorrelationAnalysis_SRRC
    """
    return _statistics.CorrelationAnalysis_SignedSRC(inputSample, outputSample)

def CorrelationAnalysis_PCC(inputSample, outputSample):
    r"""
    Correlation evaluation based on the Partial Correlation Coefficient.

    Refer to :ref:`ranking_pcc`.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \geq 2`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.Point`
        The PCC coefficients evaluated between the *sample2* and each coordinate of
        *sample1*.

    See Also
    --------
    CorrelationAnalysis_PearsonCorrelation, CorrelationAnalysis_SRC, 
    CorrelationAnalysis_PRCC
    """
    return _statistics.CorrelationAnalysis_PCC(inputSample, outputSample)

def CorrelationAnalysis_SRRC(inputSample, outputSample, normalize=False):
    r"""
    Correlation evaluation based on the Standard Rank Regression Coefficient.

    Similar as SRC evaluated on the ranked samples.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \geq 1`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.
    normalize : bool
        if True, coefficients sum to one.
        Otherwise it includes noise variance
        Default value is false.

    Returns
    -------
    coef : :class:`~openturns.Point`
        The SRRC evaluated between the *sample2* and each coordinate of the
        *sample1* (based on the rank value).

    See Also
    --------
    CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_PRCC,
    CorrelationAnalysis_SRC
    """
    return _statistics.CorrelationAnalysis_SRRC(inputSample, outputSample, normalize)

def CorrelationAnalysis_PRCC(inputSample, outputSample):
    r"""
    Correlation evaluation based on the Partial Rank Correlation Coefficient.

    Refer to :ref:`ranking_prcc`.

    Parameters
    ----------
    sample1 : 2-d sequence of float
        First sample, of dimension :math:`n \geq 2`.
    sample2 : 2-d sequence of float
        Second sample, of dimension = 1.

    Returns
    -------
    coef : :class:`~openturns.Point`
        The PRCC coefficients evaluated between the *sample2* and each coordinate of
        *sample1* (based on the rank values).

    See Also
    --------
    CorrelationAnalysis_SpearmanCorrelation, CorrelationAnalysis_SRRC,
    CorrelationAnalysis_PCC
    """
    return _statistics.CorrelationAnalysis_PRCC(inputSample, outputSample)

class FilteringWindowsImplementation(openturns.common.PersistentObject):
    r"""Base class for filtering windows."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FilteringWindowsImplementation_getClassName(self)

    def __call__(self, t):
        return _statistics.FilteringWindowsImplementation___call__(self, t)

    def __repr__(self):
        return _statistics.FilteringWindowsImplementation___repr__(self)

    def __str__(self, *args):
        return _statistics.FilteringWindowsImplementation___str__(self, *args)

    def __init__(self, *args):
        _statistics.FilteringWindowsImplementation_swiginit(self, _statistics.new_FilteringWindowsImplementation(*args))
    __swig_destroy__ = _statistics.delete_FilteringWindowsImplementation

# Register FilteringWindowsImplementation in _statistics:
_statistics.FilteringWindowsImplementation_swigregister(FilteringWindowsImplementation)

class FilteringWindowsImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.FilteringWindowsImplementationTypedInterfaceObject_swiginit(self, _statistics.new_FilteringWindowsImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.FilteringWindowsImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.FilteringWindowsImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.FilteringWindowsImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _statistics.FilteringWindowsImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _statistics.FilteringWindowsImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _statistics.delete_FilteringWindowsImplementationTypedInterfaceObject

# Register FilteringWindowsImplementationTypedInterfaceObject in _statistics:
_statistics.FilteringWindowsImplementationTypedInterfaceObject_swigregister(FilteringWindowsImplementationTypedInterfaceObject)

class FilteringWindows(FilteringWindowsImplementationTypedInterfaceObject):
    r"""Base class for filtering windows."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FilteringWindows_getClassName(self)

    def __repr__(self):
        return _statistics.FilteringWindows___repr__(self)

    def __str__(self, *args):
        return _statistics.FilteringWindows___str__(self, *args)

    def __call__(self, t):
        return _statistics.FilteringWindows___call__(self, t)

    def __init__(self, *args):
        _statistics.FilteringWindows_swiginit(self, _statistics.new_FilteringWindows(*args))
    __swig_destroy__ = _statistics.delete_FilteringWindows

# Register FilteringWindows in _statistics:
_statistics.FilteringWindows_swigregister(FilteringWindows)

class Hamming(FilteringWindowsImplementation):
    r"""
    Hamming filtering windows.

    Available constructors:
        Hamming()



    Notes
    -----
    The Hamming windows is implemented using the formula:

    .. math::

        w(t) =  C(\alpha - (1-\alpha)\cos(2\pi t))\fcar{[0,1]}{t}

    with :math:`C = \frac{1}{\alpha^2 + (1-\alpha)^2/2}` and :math:`\alpha=25/46`.

    The value of :math:`\alpha` minimizes the amplitude of the first side lobe of its Fourier transform.

    The normalization constant :math:`C` is such that :math:`\int_{0}^{1} w(t)^2\di{t} = 1`.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Hamming_getClassName(self)

    def __repr__(self):
        return _statistics.Hamming___repr__(self)

    def __str__(self, *args):
        return _statistics.Hamming___str__(self, *args)

    def __call__(self, t):
        return _statistics.Hamming___call__(self, t)

    def __init__(self, *args):
        _statistics.Hamming_swiginit(self, _statistics.new_Hamming(*args))
    __swig_destroy__ = _statistics.delete_Hamming

# Register Hamming in _statistics:
_statistics.Hamming_swigregister(Hamming)

class Hanning(FilteringWindowsImplementation):
    r"""
    Hanning filtering windows.

    Available constructors:
        Hanning()



    Notes
    -----
    The Hanning windows is implemented using the formula:

    .. math::

        w(t) =  \sqrt{\dfrac{8}{3}} \sin(\pi t)^2\fcar{[0,1]}{t}


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.Hanning_getClassName(self)

    def __repr__(self):
        return _statistics.Hanning___repr__(self)

    def __str__(self, *args):
        return _statistics.Hanning___str__(self, *args)

    def __call__(self, t):
        return _statistics.Hanning___call__(self, t)

    def __init__(self, *args):
        _statistics.Hanning_swiginit(self, _statistics.new_Hanning(*args))
    __swig_destroy__ = _statistics.delete_Hanning

# Register Hanning in _statistics:
_statistics.Hanning_swigregister(Hanning)

class FFTImplementation(openturns.common.PersistentObject):
    r"""
    Base class for Fast Fourier Transform (FFT) and Inverse Fast Fourier Transform (IFFT).

    Notes
    -----
    Perform FFT and IFFT with array of ndim=1,2,3

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FFTImplementation_getClassName(self)

    def transform(self, *args):
        r"""
        Perform Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.ComplexCollection` or :class:`~openturns.ScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.ComplexCollection`
          The data in Fourier domain.

        Notes
        -----
        The Fast Fourier Transform writes as following:

        .. math::

            {\rm y_k} = \sum_{n=0}^{N-1} x_n exp(-2 i \pi \frac{kn}{N})

        where :math:`x` denotes the data to be transformed, of size :math:`N`.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> result = fft.transform(ot.Normal(8).getRealization())

        """
        return _statistics.FFTImplementation_transform(self, *args)

    def inverseTransform(self, *args):
        r"""
        Perform Inverse Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.ComplexCollection` or :class:`~openturns.ScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.ComplexCollection`
            The transformed data.

        Notes
        -----
        The Inverse Fast Fourier Transform writes as following:

        .. math::

            {\rm y_k} = \sum_{n=0}^{N-1} \frac{1}{N} x_n exp(2 i \pi \frac{kn}{N})

        where :math:`x` denotes the data, of size :math:`N`, to be transformed.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> collection = ot.ComplexCollection([1+1j,2-0.3j,5-.3j,6+1j,9+8j,16+8j,0.3])
        >>> result = fft.inverseTransform(collection)

        """
        return _statistics.FFTImplementation_inverseTransform(self, *args)

    def transform2D(self, *args):
        r"""
        Perform 2D FFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data in fourier domain.

        Notes
        -----
        The 2D Fast Fourier Transform writes as following:

        .. math::

            {\rm Z_{k,l}} = \sum_{m=0}^{M-1}\sum_{n=0}^{N-1} X_{m,n} exp(-2 i \pi \frac{km}{M}) exp(-2 i \pi \frac{ln}{N})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.transform2D(x)

        """
        return _statistics.FFTImplementation_transform2D(self, *args)

    def inverseTransform2D(self, *args):
        r"""
        Perform 2D IFFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data transformed.

        Notes
        -----
        The 2D Fast Inverse Fourier Transform writes as following:

        .. math::

            {\rm Y_{k,l}} = \frac{1}{M\times N}\sum_{m=0}^{M-1}\sum_{n=0}^{N-1} Z_{m,n} exp(2 i \pi \frac{km}{M}) exp(2 i \pi \frac{ln}{N})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.inverseTransform2D(x)

        """
        return _statistics.FFTImplementation_inverseTransform2D(self, *args)

    def transform3D(self, *args):
        r"""
        Perform 3D FFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The data in fourier domain.

        Notes
        -----
        The 3D Fast Fourier Transform writes as following:

        .. math::

            {\rm Z_{k,l,r}} = \sum_{m=0}^{M-1}\sum_{n=0}^{N-1}\sum_{p=0}^{P-1} X_{m,n,p} exp(-2 i \pi \frac{km}{M}) exp(-2 i \pi \frac{ln}{N}) exp(-2 i \pi \frac{rp}{P})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0,fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1,fft.transform2D(z))
        >>> result = fft.transform3D(x)

        """
        return _statistics.FFTImplementation_transform3D(self, *args)

    def inverseTransform3D(self, *args):
        r"""
        Perform 3D IFFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          The data to be transformed.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The transformed data.

        Notes
        -----
        The 3D Inverse Fast Fourier Transform writes as following:

        .. math::

            {\rm Y_{k,l,r}} = \sum_{m=0}^{M-1}\sum_{n=0}^{N-1}\sum_{p=0}^{P-1} \frac{1}{M\times N \times P} Z_{m,n,p} exp(2 i \pi \frac{km}{M}) exp(2 i \pi \frac{ln}{N}) exp(2 i \pi \frac{rp}{P})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`, :math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0, fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1, fft.transform2D(z))
        >>> result = fft.inverseTransform3D(x)

        """
        return _statistics.FFTImplementation_inverseTransform3D(self, *args)

    def __repr__(self):
        return _statistics.FFTImplementation___repr__(self)

    def __str__(self, *args):
        return _statistics.FFTImplementation___str__(self, *args)

    def __init__(self, *args):
        _statistics.FFTImplementation_swiginit(self, _statistics.new_FFTImplementation(*args))
    __swig_destroy__ = _statistics.delete_FFTImplementation

# Register FFTImplementation in _statistics:
_statistics.FFTImplementation_swigregister(FFTImplementation)

class FFTImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.FFTImplementationTypedInterfaceObject_swiginit(self, _statistics.new_FFTImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.FFTImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.FFTImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.FFTImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _statistics.FFTImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _statistics.FFTImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _statistics.delete_FFTImplementationTypedInterfaceObject

# Register FFTImplementationTypedInterfaceObject in _statistics:
_statistics.FFTImplementationTypedInterfaceObject_swigregister(FFTImplementationTypedInterfaceObject)

class FFT(FFTImplementationTypedInterfaceObject):
    r"""
    Base class for Fast Fourier Transform (FFT) and Inverse Fast Fourier Transform (IFFT).

    Notes
    -----
    Perform FFT and IFFT with array of ndim=1,2,3

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FFT_getClassName(self)

    def transform(self, *args):
        r"""
        Perform Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.ComplexCollection` or :class:`~openturns.ScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.ComplexCollection`
          The data in Fourier domain.

        Notes
        -----
        The Fast Fourier Transform writes as following:

        .. math::

            {\rm y_k} = \sum_{n=0}^{N-1} x_n exp(-2 i \pi \frac{kn}{N})

        where :math:`x` denotes the data to be transformed, of size :math:`N`.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> result = fft.transform(ot.Normal(8).getRealization())

        """
        return _statistics.FFT_transform(self, *args)

    def transform2D(self, *args):
        r"""
        Perform 2D FFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data in fourier domain.

        Notes
        -----
        The 2D Fast Fourier Transform writes as following:

        .. math::

            {\rm Z_{k,l}} = \sum_{m=0}^{M-1}\sum_{n=0}^{N-1} X_{m,n} exp(-2 i \pi \frac{km}{M}) exp(-2 i \pi \frac{ln}{N})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.transform2D(x)

        """
        return _statistics.FFT_transform2D(self, *args)

    def transform3D(self, *args):
        r"""
        Perform 3D FFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The data in fourier domain.

        Notes
        -----
        The 3D Fast Fourier Transform writes as following:

        .. math::

            {\rm Z_{k,l,r}} = \sum_{m=0}^{M-1}\sum_{n=0}^{N-1}\sum_{p=0}^{P-1} X_{m,n,p} exp(-2 i \pi \frac{km}{M}) exp(-2 i \pi \frac{ln}{N}) exp(-2 i \pi \frac{rp}{P})

        where :math:`X` denotes the data to be transformed with shape (:math:`M`,:math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0,fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1,fft.transform2D(z))
        >>> result = fft.transform3D(x)

        """
        return _statistics.FFT_transform3D(self, *args)

    def inverseTransform(self, *args):
        r"""
        Perform Inverse Fast Fourier Transform (fft).

        Parameters
        ----------
        collection : :class:`~openturns.ComplexCollection` or :class:`~openturns.ScalarCollection`, sequence of float
          Data to transform.

        Returns
        -------
        collection : :class:`~openturns.ComplexCollection`
            The transformed data.

        Notes
        -----
        The Inverse Fast Fourier Transform writes as following:

        .. math::

            {\rm y_k} = \sum_{n=0}^{N-1} \frac{1}{N} x_n exp(2 i \pi \frac{kn}{N})

        where :math:`x` denotes the data, of size :math:`N`, to be transformed.


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> collection = ot.ComplexCollection([1+1j,2-0.3j,5-.3j,6+1j,9+8j,16+8j,0.3])
        >>> result = fft.inverseTransform(collection)

        """
        return _statistics.FFT_inverseTransform(self, *args)

    def inverseTransform2D(self, *args):
        r"""
        Perform 2D IFFT.

        Parameters
        ----------
        matrix : :class:`~openturns.ComplexMatrix`, :class:`~openturns.Matrix`, 2-d sequence of float
          Data to transform.

        Returns
        -------
        result : :class:`~openturns.ComplexMatrix`
          The data transformed.

        Notes
        -----
        The 2D Fast Inverse Fourier Transform writes as following:

        .. math::

            {\rm Y_{k,l}} = \frac{1}{M\times N}\sum_{m=0}^{M-1}\sum_{n=0}^{N-1} Z_{m,n} exp(2 i \pi \frac{km}{M}) exp(2 i \pi \frac{ln}{N})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`,:math:`N`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.Normal(8).getSample(16)
        >>> result = fft.inverseTransform2D(x)

        """
        return _statistics.FFT_inverseTransform2D(self, *args)

    def inverseTransform3D(self, *args):
        r"""
        Perform 3D IFFT.

        Parameters
        ----------
        tensor : :class:`~openturns.ComplexTensor` or :class:`~openturns.Tensor` or 3d array
          The data to be transformed.

        Returns
        -------
        result : :class:`~openturns.ComplexTensor`
          The transformed data.

        Notes
        -----
        The 3D Inverse Fast Fourier Transform writes as following:

        .. math::

            {\rm Y_{k,l,r}} = \sum_{m=0}^{M-1}\sum_{n=0}^{N-1}\sum_{p=0}^{P-1} \frac{1}{M\times N \times P} Z_{m,n,p} exp(2 i \pi \frac{km}{M}) exp(2 i \pi \frac{ln}{N}) exp(2 i \pi \frac{rp}{P})

        where :math:`Z` denotes the data to be transformed with shape (:math:`M`, :math:`N`, :math:`P`)


        Examples
        --------
        >>> import openturns as ot
        >>> fft = ot.FFT()
        >>> x = ot.ComplexTensor(8,8,2)
        >>> y = ot.Normal(8).getSample(8)
        >>> x.setSheet(0, fft.transform2D(y))
        >>> z = ot.Normal(8).getSample(8)
        >>> x.setSheet(1, fft.transform2D(z))
        >>> result = fft.inverseTransform3D(x)

        """
        return _statistics.FFT_inverseTransform3D(self, *args)

    def __repr__(self):
        return _statistics.FFT___repr__(self)

    def __str__(self, *args):
        return _statistics.FFT___str__(self, *args)

    def __init__(self, *args):
        _statistics.FFT_swiginit(self, _statistics.new_FFT(*args))
    __swig_destroy__ = _statistics.delete_FFT

# Register FFT in _statistics:
_statistics.FFT_swigregister(FFT)

class SpectralModelImplementation(openturns.common.PersistentObject):
    r"""
    Spectral density model.

    Notes
    -----
    We consider :math:`X: \Omega \times\cD \mapsto \Rset^d` a multivariate
    stochastic process of dimension :math:`d`, where :math:`\omega \in \Omega`
    is an event, :math:`\cD` is a domain of :math:`\Rset^n`,
    :math:`\vect{t}\in \cD` is a multivariate index and
    :math:`X(\omega, \vect{t}) \in \Rset^d`.

    We note :math:`X_{\vect{t}}: \Omega \rightarrow \Rset^d` the random variable at
    index :math:`\vect{t} \in \cD` defined by
    :math:`X_{\vect{t}}(\omega)=X(\omega, \vect{t})` and
    :math:`X(\omega): \cD  \mapsto \Rset^d` a realization of the process
    :math:`X`, for a given :math:`\omega \in \Omega` defined by
    :math:`X(\omega)(\vect{t})=X(\omega, \vect{t})`.

    If the process is a second order process, zero-mean and weakly **stationary**, we define its *bilateral spectral density function*
    :math:`S : \Rset^n \mapsto  \cH^+_{d}` with:

    - :math:`\cH^+(d) \in \cM^+(d)(\Cset)` is the set of *d-dimensional* positive hermitian matrices

    Using the *stationary covariance function* :math:`C^{stat}` with :math:`C^{stat} : \cD \mapsto  \cM_{d \times d}(\Rset)` and the Fourier transform, the spectral density writes:


    .. math::

       \forall \vect{f} \in \Rset^n, \cS(\vect{f}) = \int_{\Rset^n} \exp\left(-2i \pi <\vect{f}, \vect{\tau}>\right) C^{stat}(\vect{\tau})\di{\vect{\tau}}

    A SpectralModel object can be created only through its derived classes:
    :class:`~openturns.CauchyModel`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModelImplementation_getClassName(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the *SpectralModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SpectralModel*.
        """
        return _statistics.SpectralModelImplementation_getOutputDimension(self)

    def getInputDimension(self):
        r"""
        Get the input dimension of the spectral density function.

        Returns
        -------
        inputDimension : int
            SpatialDimension of the *SpectralModel*.
        """
        return _statistics.SpectralModelImplementation_getInputDimension(self)

    def __call__(self, frequency):
        r"""
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.
        """
        return _statistics.SpectralModelImplementation___call__(self, frequency)

    def computeStandardRepresentative(self, frequency):
        r"""
        Compute the standard representant of the spectral density function.

        Parameters
        ----------
        tau : float
            Frequency value.

        Returns
        -------
        rho : Complex
             Standard representant factor of the spectral density function.

        Notes
        -----
        According to definitions in :class:`~openturns.CovarianceModel`, as the spectral density function is the Fourier transform of the stationary covariance function and using the expression of the last one, the spectral density function writes as a matrix-complex product where the matrix is the constant spatial covariance structure and the complex represents the standard representative:

        Thus,

        .. math::

          \forall \vect{f} \in \Rset^n, \cS(\vect{f}) = \prod_{k=1}^{n} \vect{\theta}_k \mat{\Sigma} \rho(\vect{f} \odot \vect{\theta})

        where :math:`\mat{\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\vect{f} \odot \vect{\theta})_k = \vect{f}_k \vect{\theta}_k`
        """
        return _statistics.SpectralModelImplementation_computeStandardRepresentative(self, frequency)

    def getAmplitude(self):
        r"""
        Get the amplitude parameter of the spectral density function.

        Returns
        -------
        amplitude : :class:`~openturns.Point`
            The used amplitude parameter.
        """
        return _statistics.SpectralModelImplementation_getAmplitude(self)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter of the spectral density function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter to be used in the spectral density function.
        """
        return _statistics.SpectralModelImplementation_setAmplitude(self, amplitude)

    def getScale(self):
        r"""
        Get the scale parameter of the spectral density function.

        Returns
        -------
        scale : :class:`~openturns.Point`
            The used scale parameter.
        """
        return _statistics.SpectralModelImplementation_getScale(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter of the spectral density function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter to be used in the spectral density function.
            It should be of size dimension.
        """
        return _statistics.SpectralModelImplementation_setScale(self, scale)

    def getOutputCorrelation(self):
        r"""
        Get the spatial correlation matrix of the spectral density function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \mathcal{M}_{dimension \times dimension}([-1, 1])`.
        """
        return _statistics.SpectralModelImplementation_getOutputCorrelation(self)

    def __repr__(self):
        return _statistics.SpectralModelImplementation___repr__(self)

    def __str__(self, *args):
        return _statistics.SpectralModelImplementation___str__(self, *args)

    def draw(self, *args):
        r"""
        Draw a specific component of the spectral density function.

        Parameters
        ----------
        rowIndex : int, :math:`0 \leq rowIndex < dimension`
            The row index of the component to draw. Default value is 0.
        columnIndex: int, :math:`0 \leq columnIndex < dimension`
            The column index of the component to draw. Default value is 0.
        minimumFrequency : float
            The lower bound of the frequency range over which the model is plotted. Default value is *SpectralModel-DefaultMinimumFrequency* in :class:`~openturns.ResourceMap`.
        maximumFrequency : float
            The upper bound of the frequency range over which the model is plotted. Default value is *SpectralModel-DefaultMaximumFrequency* in :class:`~openturns.ResourceMap`.
        frequencyNumber : int, :math:`pointNumber \geq 2`
            The discretization of the frequency range :math:`[minimumFrequency, maximumFrequency]` over which the model is plotted. Default value is *SpectralModel-DefaultFrequencyNumber* in  class:`~openturns.ResourceMap`.
        module : bool
            Flag to tell if module has to be drawn (*True*) or if it is
            the argument to be drawn (*False*).
            Default value is *True*.

        Returns
        -------
        graph : Graph
             Graphic of the specified component

        """
        return _statistics.SpectralModelImplementation_draw(self, *args)

    def __init__(self, *args):
        _statistics.SpectralModelImplementation_swiginit(self, _statistics.new_SpectralModelImplementation(*args))
    __swig_destroy__ = _statistics.delete_SpectralModelImplementation

# Register SpectralModelImplementation in _statistics:
_statistics.SpectralModelImplementation_swigregister(SpectralModelImplementation)

class SpectralModelImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.SpectralModelImplementationTypedInterfaceObject_swiginit(self, _statistics.new_SpectralModelImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.SpectralModelImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _statistics.SpectralModelImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _statistics.SpectralModelImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _statistics.delete_SpectralModelImplementationTypedInterfaceObject

# Register SpectralModelImplementationTypedInterfaceObject in _statistics:
_statistics.SpectralModelImplementationTypedInterfaceObject_swigregister(SpectralModelImplementationTypedInterfaceObject)

class SpectralModel(SpectralModelImplementationTypedInterfaceObject):
    r"""
    Spectral density model.

    Notes
    -----
    We consider :math:`X: \Omega \times\cD \mapsto \Rset^d` a multivariate
    stochastic process of dimension :math:`d`, where :math:`\omega \in \Omega`
    is an event, :math:`\cD` is a domain of :math:`\Rset^n`,
    :math:`\vect{t}\in \cD` is a multivariate index and
    :math:`X(\omega, \vect{t}) \in \Rset^d`.

    We note :math:`X_{\vect{t}}: \Omega \rightarrow \Rset^d` the random variable at
    index :math:`\vect{t} \in \cD` defined by
    :math:`X_{\vect{t}}(\omega)=X(\omega, \vect{t})` and
    :math:`X(\omega): \cD  \mapsto \Rset^d` a realization of the process
    :math:`X`, for a given :math:`\omega \in \Omega` defined by
    :math:`X(\omega)(\vect{t})=X(\omega, \vect{t})`.

    If the process is a second order process, zero-mean and weakly **stationary**, we define its *bilateral spectral density function*
    :math:`S : \Rset^n \mapsto  \cH^+_{d}` with:

    - :math:`\cH^+(d) \in \cM^+(d)(\Cset)` is the set of *d-dimensional* positive hermitian matrices

    Using the *stationary covariance function* :math:`C^{stat}` with :math:`C^{stat} : \cD \mapsto  \cM_{d \times d}(\Rset)` and the Fourier transform, the spectral density writes:


    .. math::

       \forall \vect{f} \in \Rset^n, \cS(\vect{f}) = \int_{\Rset^n} \exp\left(-2i \pi <\vect{f}, \vect{\tau}>\right) C^{stat}(\vect{\tau})\di{\vect{\tau}}

    A SpectralModel object can be created only through its derived classes:
    :class:`~openturns.CauchyModel`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModel_getClassName(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the *SpectralModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SpectralModel*.
        """
        return _statistics.SpectralModel_getOutputDimension(self)

    def getInputDimension(self):
        r"""
        Get the input dimension of the spectral density function.

        Returns
        -------
        inputDimension : int
            SpatialDimension of the *SpectralModel*.
        """
        return _statistics.SpectralModel_getInputDimension(self)

    def __call__(self, frequency):
        r"""
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.
        """
        return _statistics.SpectralModel___call__(self, frequency)

    def computeStandardRepresentative(self, frequency):
        r"""
        Compute the standard representant of the spectral density function.

        Parameters
        ----------
        tau : float
            Frequency value.

        Returns
        -------
        rho : Complex
             Standard representant factor of the spectral density function.

        Notes
        -----
        According to definitions in :class:`~openturns.CovarianceModel`, as the spectral density function is the Fourier transform of the stationary covariance function and using the expression of the last one, the spectral density function writes as a matrix-complex product where the matrix is the constant spatial covariance structure and the complex represents the standard representative:

        Thus,

        .. math::

          \forall \vect{f} \in \Rset^n, \cS(\vect{f}) = \prod_{k=1}^{n} \vect{\theta}_k \mat{\Sigma} \rho(\vect{f} \odot \vect{\theta})

        where :math:`\mat{\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\vect{f} \odot \vect{\theta})_k = \vect{f}_k \vect{\theta}_k`
        """
        return _statistics.SpectralModel_computeStandardRepresentative(self, frequency)

    def draw(self, *args):
        r"""
        Draw a specific component of the spectral density function.

        Parameters
        ----------
        rowIndex : int, :math:`0 \leq rowIndex < dimension`
            The row index of the component to draw. Default value is 0.
        columnIndex: int, :math:`0 \leq columnIndex < dimension`
            The column index of the component to draw. Default value is 0.
        minimumFrequency : float
            The lower bound of the frequency range over which the model is plotted. Default value is *SpectralModel-DefaultMinimumFrequency* in :class:`~openturns.ResourceMap`.
        maximumFrequency : float
            The upper bound of the frequency range over which the model is plotted. Default value is *SpectralModel-DefaultMaximumFrequency* in :class:`~openturns.ResourceMap`.
        frequencyNumber : int, :math:`pointNumber \geq 2`
            The discretization of the frequency range :math:`[minimumFrequency, maximumFrequency]` over which the model is plotted. Default value is *SpectralModel-DefaultFrequencyNumber* in  class:`~openturns.ResourceMap`.
        module : bool
            Flag to tell if module has to be drawn (*True*) or if it is
            the argument to be drawn (*False*).
            Default value is *True*.

        Returns
        -------
        graph : Graph
             Graphic of the specified component

        """
        return _statistics.SpectralModel_draw(self, *args)

    def getAmplitude(self):
        r"""
        Get the amplitude parameter of the spectral density function.

        Returns
        -------
        amplitude : :class:`~openturns.Point`
            The used amplitude parameter.
        """
        return _statistics.SpectralModel_getAmplitude(self)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter of the spectral density function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter to be used in the spectral density function.
        """
        return _statistics.SpectralModel_setAmplitude(self, amplitude)

    def getScale(self):
        r"""
        Get the scale parameter of the spectral density function.

        Returns
        -------
        scale : :class:`~openturns.Point`
            The used scale parameter.
        """
        return _statistics.SpectralModel_getScale(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter of the spectral density function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter to be used in the spectral density function.
            It should be of size dimension.
        """
        return _statistics.SpectralModel_setScale(self, scale)

    def getOutputCorrelation(self):
        r"""
        Get the spatial correlation matrix of the spectral density function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \mathcal{M}_{dimension \times dimension}([-1, 1])`.
        """
        return _statistics.SpectralModel_getOutputCorrelation(self)

    def __repr__(self):
        return _statistics.SpectralModel___repr__(self)

    def __str__(self, *args):
        return _statistics.SpectralModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.SpectralModel_swiginit(self, _statistics.new_SpectralModel(*args))
    __swig_destroy__ = _statistics.delete_SpectralModel

# Register SpectralModel in _statistics:
_statistics.SpectralModel_swigregister(SpectralModel)

class CovarianceModelImplementation(openturns.common.PersistentObject):
    r"""
    Covariance model.

    Base class for covariance models.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModelImplementation_getClassName(self)

    def getInputDimension(self):
        r"""
        Get the input dimension :math:`n` of the covariance function.

        Returns
        -------
        inputDimension : int
            Spatial dimension :math:`n` of the covariance function.
        """
        return _statistics.CovarianceModelImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension :math:`d` of the covariance function.

        Returns
        -------
        d : int
            Dimension :math:`d` such that :math:`C : \cD \times \cD \mapsto \cS_d^+(\Rset).`
            This is the dimension of the process :math:`X`.
        """
        return _statistics.CovarianceModelImplementation_getOutputDimension(self)

    def computeStandardRepresentative(self, s, t):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.CovarianceModelImplementation_computeStandardRepresentative(self, s, t)

    def computeAsScalar(self, s, t):
        r"""
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(\vect{s}, \vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})` as
        this quantity does not depend on :math:`\vect{s}`.
        """
        return _statistics.CovarianceModelImplementation_computeAsScalar(self, s, t)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.CovarianceModelImplementation___call__(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.CovarianceModelImplementation_partialGradient(self, s, t)

    def parameterGradient(self, s, t):
        r"""
        Compute the gradient according to the parameters.

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the function according to the parameters.
        """
        return _statistics.CovarianceModelImplementation_parameterGradient(self, s, t)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.CovarianceModelImplementation_discretize(self, *args)

    def discretizeRow(self, vertices, p):
        r"""**(TODO)**"""
        return _statistics.CovarianceModelImplementation_discretizeRow(self, vertices, p)

    def discretizeAndFactorize(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\in \cM_{nd\times nd}(\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.CovarianceModelImplementation_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        r"""
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\in\cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.CovarianceModelImplementation_discretizeHMatrix(self, *args)

    def discretizeAndFactorizeHMatrix(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        This uses HMatrix.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Cholesk matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretizeAndFactorize* method. This method 
        requires that OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.CovarianceModelImplementation_discretizeAndFactorizeHMatrix(self, *args)

    def isStationary(self):
        r"""
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \forall(\vect{s},\vect{t},\vect{h}) \in \cD \times \cD, & \, \quad
            C(\vect{s}, \vect{s}+\vect{h}) = C(\vect{t}, \vect{t}+\vect{h})


        We note :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})`.
        """
        return _statistics.CovarianceModelImplementation_isStationary(self)

    def isDiagonal(self):
        r"""
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.CovarianceModelImplementation_isDiagonal(self)

    def getAmplitude(self):
        r"""
        Get the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Returns
        -------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance 
            function.
        """
        return _statistics.CovarianceModelImplementation_getAmplitude(self)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.CovarianceModelImplementation_setAmplitude(self, amplitude)

    def getScale(self):
        r"""
        Get the scale parameter :math:`\vect{\theta}` of the covariance function.

        Returns
        -------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` used in the 
            covariance function.
        """
        return _statistics.CovarianceModelImplementation_getScale(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _statistics.CovarianceModelImplementation_setScale(self, scale)

    def getOutputCorrelation(self):
        r"""
        Get the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+(\Rset)`.
        """
        return _statistics.CovarianceModelImplementation_getOutputCorrelation(self)

    def setOutputCorrelation(self, correlation):
        r"""
        Set the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+([-1,1])`.
        """
        return _statistics.CovarianceModelImplementation_setOutputCorrelation(self, correlation)

    def setNuggetFactor(self, nuggetFactor):
        r"""
        Set the nugget factor for the variance of the observation error.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used to model the variance of the observation error.
        """
        return _statistics.CovarianceModelImplementation_setNuggetFactor(self, nuggetFactor)

    def getNuggetFactor(self):
        r"""
        Accessor to the nugget factor.

        This parameter allows smooth predictions from noisy data.
        The nugget is added to the diagonal of the assumed training covariance
        (thanks to discretize) and acts as a Tikhonov regularization in the
        problem.

        Returns
        -------
        nuggetFactor : float
            Nugget factor used to model the observation error variance.
        """
        return _statistics.CovarianceModelImplementation_getNuggetFactor(self)

    def setParameter(self, parameter):
        r"""
        Set the parameters of the covariance function.

        Parameters
        ----------
        parameters : :class:`~openturns.Point`
            List of the scale parameter :math:`\vect{\theta} \in \Rset^n` and the
            amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance
            function.

            Must be of dimension :math:`n+d`.
        """
        return _statistics.CovarianceModelImplementation_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Get the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            List of the scale parameter :math:`\vect{\theta} \in \Rset^n` and the
            amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance
            function.

           The other specific parameters are not included.
        """
        return _statistics.CovarianceModelImplementation_getParameter(self)

    def getParameterDescription(self):
        r"""
        Get the description of the covariance function parameters.

        Returns
        -------
        descriptionParam : :class:`~openturns.Description`
            Description of the components of the parameters obtained with the
            *getParameter* method..
        """
        return _statistics.CovarianceModelImplementation_getParameterDescription(self)

    def setActiveParameter(self, active):
        r"""
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.CovarianceModelImplementation_setActiveParameter(self, active)

    def getActiveParameter(self):
        r"""
        Accessor to the active parameter set.

        Returns
        -------
        active : :class:`~openturns.Indices`
            Indices of the active parameters.
        """
        return _statistics.CovarianceModelImplementation_getActiveParameter(self)

    def setFullParameter(self, parameter):
        r"""
        Set the full parameters of the covariance function.

        Parameters
        ----------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

            Must be at least of dimension :math:`n+\frac{d(d+1)}{2}`.
        """
        return _statistics.CovarianceModelImplementation_setFullParameter(self, parameter)

    def getFullParameter(self):
        r"""
        Get the full parameters of the covariance function.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

        """
        return _statistics.CovarianceModelImplementation_getFullParameter(self)

    def getFullParameterDescription(self):
        r"""
        Get the description full parameters of the covariance function.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the full parameter of the covariance function.

        """
        return _statistics.CovarianceModelImplementation_getFullParameterDescription(self)

    def __repr__(self):
        return _statistics.CovarianceModelImplementation___repr__(self)

    def __str__(self, *args):
        return _statistics.CovarianceModelImplementation___str__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int or sequence of int
            index of marginal of the model.
        """
        return _statistics.CovarianceModelImplementation_getMarginal(self, *args)

    def draw(self, *args):
        r"""
        Draw a specific component of the covariance model with input dimension 1.

        Parameters
        ----------
        rowIndex : int, :math:`0 \leq rowIndex < dimension`
            The row index of the component to draw. Default value is 0.
        columnIndex: int, :math:`0 \leq columnIndex < dimension`
            The column index of the component to draw. Default value is 0.
        tMin : float
            The lower bound of the range over which the model is plotted. Default value is *CovarianceModel-DefaultTMin* in :class:`~openturns.ResourceMap`.
        tMax : float
            The upper bound of the range over which the model is plotted. Default value is *CovarianceModel-DefaultTMax* in :class:`~openturns.ResourceMap`.
        pointNumber : int, :math:`pointNumber \geq 2`
            The discretization of the range :math:`[tMin,tMax]` over which the model is plotted. Default value is *CovarianceModel-DefaultPointNumber* in  class:`~openturns.ResourceMap`.
        asStationary : bool
            Flag to tell if the model has to be plotted as a stationary model, ie as a function of the lag :math:`\tau=t-s` if equals to *True*, or as a non-stationary model, ie as a function of :math:`(s,t)` if equals to *False*. Default value is *True*.
        correlationFlag : bool
            Flag to tell if the model has to be plotted as a correlation function if equals to *True* or as a covariance function if equals to *False*. Default value is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a unique curve if *asStationary=True* and if the model is actually a stationary model, or containing the iso-values of the model if *asStationary=False* or if the model is nonstationary.


        """
        return _statistics.CovarianceModelImplementation_draw(self, *args)

    def __init__(self, *args):
        _statistics.CovarianceModelImplementation_swiginit(self, _statistics.new_CovarianceModelImplementation(*args))
    __swig_destroy__ = _statistics.delete_CovarianceModelImplementation

# Register CovarianceModelImplementation in _statistics:
_statistics.CovarianceModelImplementation_swigregister(CovarianceModelImplementation)

class CovarianceModelImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.CovarianceModelImplementationTypedInterfaceObject_swiginit(self, _statistics.new_CovarianceModelImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.CovarianceModelImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _statistics.CovarianceModelImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _statistics.CovarianceModelImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _statistics.delete_CovarianceModelImplementationTypedInterfaceObject

# Register CovarianceModelImplementationTypedInterfaceObject in _statistics:
_statistics.CovarianceModelImplementationTypedInterfaceObject_swigregister(CovarianceModelImplementationTypedInterfaceObject)

class CovarianceModelCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _statistics.delete_CovarianceModelCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _statistics.CovarianceModelCollection_clear(self)

    def __len__(self):
        return _statistics.CovarianceModelCollection___len__(self)

    def __eq__(self, rhs):
        return _statistics.CovarianceModelCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _statistics.CovarianceModelCollection___contains__(self, val)

    def __getitem__(self, i):
        return _statistics.CovarianceModelCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _statistics.CovarianceModelCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _statistics.CovarianceModelCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _statistics.CovarianceModelCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _statistics.CovarianceModelCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _statistics.CovarianceModelCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _statistics.CovarianceModelCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _statistics.CovarianceModelCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _statistics.CovarianceModelCollection_find(self, val)

    def __repr__(self):
        return _statistics.CovarianceModelCollection___repr__(self)

    def __str__(self, *args):
        return _statistics.CovarianceModelCollection___str__(self, *args)

    def __init__(self, *args):
        _statistics.CovarianceModelCollection_swiginit(self, _statistics.new_CovarianceModelCollection(*args))

# Register CovarianceModelCollection in _statistics:
_statistics.CovarianceModelCollection_swigregister(CovarianceModelCollection)

class CovarianceModel(CovarianceModelImplementationTypedInterfaceObject):
    r"""
    Covariance model.

    Base class for covariance models.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModel_getClassName(self)

    def getInputDimension(self):
        r"""
        Get the input dimension :math:`n` of the covariance function.

        Returns
        -------
        inputDimension : int
            Spatial dimension :math:`n` of the covariance function.
        """
        return _statistics.CovarianceModel_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension :math:`d` of the covariance function.

        Returns
        -------
        d : int
            Dimension :math:`d` such that :math:`C : \cD \times \cD \mapsto \cS_d^+(\Rset).`
            This is the dimension of the process :math:`X`.
        """
        return _statistics.CovarianceModel_getOutputDimension(self)

    def computeStandardRepresentative(self, s, t):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.CovarianceModel_computeStandardRepresentative(self, s, t)

    def computeAsScalar(self, s, t):
        r"""
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(\vect{s}, \vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})` as
        this quantity does not depend on :math:`\vect{s}`.
        """
        return _statistics.CovarianceModel_computeAsScalar(self, s, t)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.CovarianceModel___call__(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.CovarianceModel_partialGradient(self, s, t)

    def parameterGradient(self, s, t):
        r"""
        Compute the gradient according to the parameters.

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the function according to the parameters.
        """
        return _statistics.CovarianceModel_parameterGradient(self, s, t)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.CovarianceModel_discretize(self, *args)

    def discretizeRow(self, vertices, p):
        r"""**(TODO)**"""
        return _statistics.CovarianceModel_discretizeRow(self, vertices, p)

    def discretizeAndFactorize(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\in \cM_{nd\times nd}(\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.CovarianceModel_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        r"""
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\in\cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.CovarianceModel_discretizeHMatrix(self, *args)

    def discretizeAndFactorizeHMatrix(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        This uses HMatrix.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Cholesk matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretizeAndFactorize* method. This method 
        requires that OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.CovarianceModel_discretizeAndFactorizeHMatrix(self, *args)

    def getAmplitude(self):
        r"""
        Get the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Returns
        -------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance 
            function.
        """
        return _statistics.CovarianceModel_getAmplitude(self)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.CovarianceModel_setAmplitude(self, amplitude)

    def getScale(self):
        r"""
        Get the scale parameter :math:`\vect{\theta}` of the covariance function.

        Returns
        -------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` used in the 
            covariance function.
        """
        return _statistics.CovarianceModel_getScale(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _statistics.CovarianceModel_setScale(self, scale)

    def getOutputCorrelation(self):
        r"""
        Get the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+(\Rset)`.
        """
        return _statistics.CovarianceModel_getOutputCorrelation(self)

    def setOutputCorrelation(self, correlation):
        r"""
        Set the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+([-1,1])`.
        """
        return _statistics.CovarianceModel_setOutputCorrelation(self, correlation)

    def setNuggetFactor(self, nuggetFactor):
        r"""
        Set the nugget factor for the variance of the observation error.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used to model the variance of the observation error.
        """
        return _statistics.CovarianceModel_setNuggetFactor(self, nuggetFactor)

    def getNuggetFactor(self):
        r"""
        Accessor to the nugget factor.

        This parameter allows smooth predictions from noisy data.
        The nugget is added to the diagonal of the assumed training covariance
        (thanks to discretize) and acts as a Tikhonov regularization in the
        problem.

        Returns
        -------
        nuggetFactor : float
            Nugget factor used to model the observation error variance.
        """
        return _statistics.CovarianceModel_getNuggetFactor(self)

    def setParameter(self, parameter):
        r"""
        Set the parameters of the covariance function.

        Parameters
        ----------
        parameters : :class:`~openturns.Point`
            List of the scale parameter :math:`\vect{\theta} \in \Rset^n` and the
            amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance
            function.

            Must be of dimension :math:`n+d`.
        """
        return _statistics.CovarianceModel_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Get the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            List of the scale parameter :math:`\vect{\theta} \in \Rset^n` and the
            amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance
            function.

           The other specific parameters are not included.
        """
        return _statistics.CovarianceModel_getParameter(self)

    def getParameterDescription(self):
        r"""
        Get the description of the covariance function parameters.

        Returns
        -------
        descriptionParam : :class:`~openturns.Description`
            Description of the components of the parameters obtained with the
            *getParameter* method..
        """
        return _statistics.CovarianceModel_getParameterDescription(self)

    def setActiveParameter(self, active):
        r"""
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.CovarianceModel_setActiveParameter(self, active)

    def getActiveParameter(self):
        r"""
        Accessor to the active parameter set.

        Returns
        -------
        active : :class:`~openturns.Indices`
            Indices of the active parameters.
        """
        return _statistics.CovarianceModel_getActiveParameter(self)

    def setFullParameter(self, parameter):
        r"""
        Set the full parameters of the covariance function.

        Parameters
        ----------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

            Must be at least of dimension :math:`n+\frac{d(d+1)}{2}`.
        """
        return _statistics.CovarianceModel_setFullParameter(self, parameter)

    def getFullParameter(self):
        r"""
        Get the full parameters of the covariance function.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

        """
        return _statistics.CovarianceModel_getFullParameter(self)

    def getFullParameterDescription(self):
        r"""
        Get the description full parameters of the covariance function.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the full parameter of the covariance function.

        """
        return _statistics.CovarianceModel_getFullParameterDescription(self)

    def isStationary(self):
        r"""
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \forall(\vect{s},\vect{t},\vect{h}) \in \cD \times \cD, & \, \quad
            C(\vect{s}, \vect{s}+\vect{h}) = C(\vect{t}, \vect{t}+\vect{h})


        We note :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})`.
        """
        return _statistics.CovarianceModel_isStationary(self)

    def isDiagonal(self):
        r"""
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.CovarianceModel_isDiagonal(self)

    def draw(self, *args):
        r"""
        Draw a specific component of the covariance model with input dimension 1.

        Parameters
        ----------
        rowIndex : int, :math:`0 \leq rowIndex < dimension`
            The row index of the component to draw. Default value is 0.
        columnIndex: int, :math:`0 \leq columnIndex < dimension`
            The column index of the component to draw. Default value is 0.
        tMin : float
            The lower bound of the range over which the model is plotted. Default value is *CovarianceModel-DefaultTMin* in :class:`~openturns.ResourceMap`.
        tMax : float
            The upper bound of the range over which the model is plotted. Default value is *CovarianceModel-DefaultTMax* in :class:`~openturns.ResourceMap`.
        pointNumber : int, :math:`pointNumber \geq 2`
            The discretization of the range :math:`[tMin,tMax]` over which the model is plotted. Default value is *CovarianceModel-DefaultPointNumber* in  class:`~openturns.ResourceMap`.
        asStationary : bool
            Flag to tell if the model has to be plotted as a stationary model, ie as a function of the lag :math:`\tau=t-s` if equals to *True*, or as a non-stationary model, ie as a function of :math:`(s,t)` if equals to *False*. Default value is *True*.
        correlationFlag : bool
            Flag to tell if the model has to be plotted as a correlation function if equals to *True* or as a covariance function if equals to *False*. Default value is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a unique curve if *asStationary=True* and if the model is actually a stationary model, or containing the iso-values of the model if *asStationary=False* or if the model is nonstationary.


        """
        return _statistics.CovarianceModel_draw(self, *args)

    def __repr__(self):
        return _statistics.CovarianceModel___repr__(self)

    def __str__(self, *args):
        return _statistics.CovarianceModel___str__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int or sequence of int
            index of marginal of the model.
        """
        return _statistics.CovarianceModel_getMarginal(self, *args)

    def __init__(self, *args):
        _statistics.CovarianceModel_swiginit(self, _statistics.new_CovarianceModel(*args))
    __swig_destroy__ = _statistics.delete_CovarianceModel

# Register CovarianceModel in _statistics:
_statistics.CovarianceModel_swigregister(CovarianceModel)

class StationaryCovarianceModel(CovarianceModelImplementation):
    r"""Proxy of C++ OT::StationaryCovarianceModel."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.StationaryCovarianceModel_getClassName(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.StationaryCovarianceModel___call__(self, *args)

    def computeAsScalar(self, *args):
        r"""
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(\vect{s}, \vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})` as
        this quantity does not depend on :math:`\vect{s}`.
        """
        return _statistics.StationaryCovarianceModel_computeAsScalar(self, *args)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.StationaryCovarianceModel_computeStandardRepresentative(self, *args)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.StationaryCovarianceModel_discretize(self, *args)

    def isStationary(self):
        r"""
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \forall(\vect{s},\vect{t},\vect{h}) \in \cD \times \cD, & \, \quad
            C(\vect{s}, \vect{s}+\vect{h}) = C(\vect{t}, \vect{t}+\vect{h})


        We note :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})`.
        """
        return _statistics.StationaryCovarianceModel_isStationary(self)

    def __repr__(self):
        return _statistics.StationaryCovarianceModel___repr__(self)

    def __str__(self, *args):
        return _statistics.StationaryCovarianceModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.StationaryCovarianceModel_swiginit(self, _statistics.new_StationaryCovarianceModel(*args))
    __swig_destroy__ = _statistics.delete_StationaryCovarianceModel

# Register StationaryCovarianceModel in _statistics:
_statistics.StationaryCovarianceModel_swigregister(StationaryCovarianceModel)

class SpectralModelFactoryImplementation(openturns.common.PersistentObject):
    r"""
    Base class for spectral model factory.

    Parameters
    ----------
    mySpectralModelFactoryImplementation : :class:`~openturns.SpectralModelFactoryImplementation`
        One spectral factory algorithm.

        By default, the Welch factory algorithm :class:`~openturns.WelchFactory`.

    Notes
    -----
    Let :math:`X: \Omega \times \cD \rightarrow \Rset^d`  be a multivariate second order stationary process, with zero mean, where :math:`\cD \in \Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\cD \in \Rset` (*n=1*).

    If we note :math:`C(\vect{s}, \vect{t})=\Expect{(X_{\vect{s}}-m(\vect{s}))\Tr{(X_{\vect{t}}-m(\vect{t}))}}` its covariance function, then for all :math:`(i,j), C^{stat}_{i,j} : \Rset^n \rightarrow \Rset^n` is :math:`\cL^1(\Rset^n)` (ie :math:`\int_{\Rset^n} |C^{stat}_{i,j}(\vect{\tau})|\di{\vect{\tau}}\, < +\infty`), with :math:`C^{stat}(\vect{\tau}) = C(\vect{s}, \vect{s}+\vect{\tau})` as this quantity does not depend on :math:`\vect{s}`. 

    The bilateral spectral density function :math:`S : \Rset^n \rightarrow \mathcal{H}^+(d)` exists and is defined as the Fourier transform of the covariance function :math:`C^{stat}` :

    .. math::

        \forall \vect{f} \in \Rset^n, \,S(\vect{f}) = \int_{\Rset^n}\exp\left\{-2i\pi <\vect{f},\vect{\tau}> \right\} C^{stat}(\vect{\tau})\di{\vect{\tau}}


    where :math:`\mathcal{H}^+(d) \in \mathcal{M}_d(\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

    Depending on the available data, we proceed differently :

        -if the data correspond to  several independent  realizations of the  process, the estimation is done using the empirical estimator;

        - if the data correspond to one realization of the  process,  we suppose the process is ergodic to split the realization into several ones.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModelFactoryImplementation_getClassName(self)

    def getFFTAlgorithm(self):
        r"""
        Accessor to the FFT algorithm used for the Fourier transform.

        Returns
        -------
        fftAlgo : :class:`~openturns.FFT` 
             The FFT algorithm used for the Fourier transform.

        """
        return _statistics.SpectralModelFactoryImplementation_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        r"""
        Accessor to the FFT algorithm used for the Fourier transform.

        Parameters
        ----------
        fftAlgo : :class:`~openturns.FFT` 
             The FFT algorithm used for the Fourier transform.

        """
        return _statistics.SpectralModelFactoryImplementation_setFFTAlgorithm(self, fft)

    def __repr__(self):
        return _statistics.SpectralModelFactoryImplementation___repr__(self)

    def __str__(self, *args):
        return _statistics.SpectralModelFactoryImplementation___str__(self, *args)

    def build(self, *args):
        r"""
        Estimate the spectral model from data.

        Available constructors:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries` 
            The time series from which the spectral model is estimated.
        myProcessSample : :class:`~openturns.ProcessSample` 
            The sample of time series from which the spectral model is estimated.

        Returns
        -------
        mySpectralModel : :class:`~openturns.SpectralModel`
            The estimated spectral model.

        """
        return _statistics.SpectralModelFactoryImplementation_build(self, *args)

    def __init__(self, *args):
        _statistics.SpectralModelFactoryImplementation_swiginit(self, _statistics.new_SpectralModelFactoryImplementation(*args))
    __swig_destroy__ = _statistics.delete_SpectralModelFactoryImplementation

# Register SpectralModelFactoryImplementation in _statistics:
_statistics.SpectralModelFactoryImplementation_swigregister(SpectralModelFactoryImplementation)

class SpectralModelFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.SpectralModelFactoryImplementationTypedInterfaceObject_swiginit(self, _statistics.new_SpectralModelFactoryImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _statistics.SpectralModelFactoryImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _statistics.delete_SpectralModelFactoryImplementationTypedInterfaceObject

# Register SpectralModelFactoryImplementationTypedInterfaceObject in _statistics:
_statistics.SpectralModelFactoryImplementationTypedInterfaceObject_swigregister(SpectralModelFactoryImplementationTypedInterfaceObject)

class SpectralModelFactory(SpectralModelFactoryImplementationTypedInterfaceObject):
    r"""
    Base class for spectral model factory.

    Parameters
    ----------
    mySpectralModelFactoryImplementation : :class:`~openturns.SpectralModelFactoryImplementation`
        One spectral factory algorithm.

        By default, the Welch factory algorithm :class:`~openturns.WelchFactory`.

    Notes
    -----
    Let :math:`X: \Omega \times \cD \rightarrow \Rset^d`  be a multivariate second order stationary process, with zero mean, where :math:`\cD \in \Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\cD \in \Rset` (*n=1*).

    If we note :math:`C(\vect{s}, \vect{t})=\Expect{(X_{\vect{s}}-m(\vect{s}))\Tr{(X_{\vect{t}}-m(\vect{t}))}}` its covariance function, then for all :math:`(i,j), C^{stat}_{i,j} : \Rset^n \rightarrow \Rset^n` is :math:`\cL^1(\Rset^n)` (ie :math:`\int_{\Rset^n} |C^{stat}_{i,j}(\vect{\tau})|\di{\vect{\tau}}\, < +\infty`), with :math:`C^{stat}(\vect{\tau}) = C(\vect{s}, \vect{s}+\vect{\tau})` as this quantity does not depend on :math:`\vect{s}`. 

    The bilateral spectral density function :math:`S : \Rset^n \rightarrow \mathcal{H}^+(d)` exists and is defined as the Fourier transform of the covariance function :math:`C^{stat}` :

    .. math::

        \forall \vect{f} \in \Rset^n, \,S(\vect{f}) = \int_{\Rset^n}\exp\left\{-2i\pi <\vect{f},\vect{\tau}> \right\} C^{stat}(\vect{\tau})\di{\vect{\tau}}


    where :math:`\mathcal{H}^+(d) \in \mathcal{M}_d(\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

    Depending on the available data, we proceed differently :

        -if the data correspond to  several independent  realizations of the  process, the estimation is done using the empirical estimator;

        - if the data correspond to one realization of the  process,  we suppose the process is ergodic to split the realization into several ones.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModelFactory_getClassName(self)

    def getFFTAlgorithm(self):
        r"""
        Accessor to the FFT algorithm used for the Fourier transform.

        Returns
        -------
        fftAlgo : :class:`~openturns.FFT` 
             The FFT algorithm used for the Fourier transform.

        """
        return _statistics.SpectralModelFactory_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        r"""
        Accessor to the FFT algorithm used for the Fourier transform.

        Parameters
        ----------
        fftAlgo : :class:`~openturns.FFT` 
             The FFT algorithm used for the Fourier transform.

        """
        return _statistics.SpectralModelFactory_setFFTAlgorithm(self, fft)

    def __repr__(self):
        return _statistics.SpectralModelFactory___repr__(self)

    def __str__(self, *args):
        return _statistics.SpectralModelFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Estimate the spectral model from data.

        Available constructors:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries` 
            The time series from which the spectral model is estimated.
        myProcessSample : :class:`~openturns.ProcessSample` 
            The sample of time series from which the spectral model is estimated.

        Returns
        -------
        mySpectralModel : :class:`~openturns.SpectralModel`
            The estimated spectral model.

        """
        return _statistics.SpectralModelFactory_build(self, *args)

    def __init__(self, *args):
        _statistics.SpectralModelFactory_swiginit(self, _statistics.new_SpectralModelFactory(*args))
    __swig_destroy__ = _statistics.delete_SpectralModelFactory

# Register SpectralModelFactory in _statistics:
_statistics.SpectralModelFactory_swigregister(SpectralModelFactory)

class UserDefinedSpectralModel(SpectralModelImplementation):
    r"""
    Spectral model defined by the User.

    Parameters
    ----------
    frequency : :class:`~openturns.RegularGrid`
        The frequency grid :math:`(-f_c, \dots, f_c)` with step :math:`\delta f` on which the model is built.
    densityCollectionFunction : :class:`~openturns.HermitianMatrixCollection`
        Collection of hermitian matrices :math:`\in \mathbb{M}_d(\mathbb{C})` which are the images of each point of the frequency grid through the density spectral function.

    Notes
    -----
    We consider a multivariate process :math:`X: \Omega \times \cD \rightarrow \Rset^d` of dimension :math:`d` where :math:`\cD \in \Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\cD \in \Rset` (:math:`n=1`).

    We denote :math:`(\vect{t}_0, \dots, \vect{t}_{N-1})` the time stamps of the time grid.

    :math:`X` is supposed to be a stationary second order process and we suppose that its spectral density function :math:`S : \Rset \rightarrow \mathcal{H}^+(d)` defined by:

    .. math::
        :label: fourier_transform

        \forall \vect{f} \in \Rset^n, \,S(\vect{f}) = \int_{\Rset^n}\exp\left\{  -2i\pi <\vect{f},\vect{\tau}> \right\} C^{stat}(\vect{\tau})\di{\vect{\tau}}

    exists, where :math:`\mathcal{H}^+(d) \in \mathcal{M}_d(\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

    We get a piecewise constant function on :math:`[-f_c,f_c]`, where the intervals on which the density spectral function is constant are centered on the points of the frequency grid, of length :math:`\delta f`. 

    Then, it is  possible to evaluate the spectral density function for a given frequency thanks to the method *computeSpectralDensity*: if the frequency is not inside the interval :math:`[-f_c,f_c]`, OpenTURNS returns an exception. Otherwise, it returns the hermitian matrix of the subinterval of :math:`[-f_c,f_c]` that contains the given frequency.

    Examples
    --------
    Create the frequency grid:

    >>> import openturns as ot
    >>> from math import exp
    >>> fmin = 0.1
    >>> df = 0.5
    >>> N = int((10.0 - fmin)/ df)
    >>> myFrequencyGrid =  ot.RegularGrid(fmin, df, N)

    Define the spectral function:

    >>> def s(f):
    ...     if(f <= 5.0):
    ...         return 1.0
    ...     else:
    ...         x = f - 5.0
    ...         return exp(-2.0 * x * x)

    Create the collection of HermitianMatrix:

    >>> myCollection = ot.HermitianMatrixCollection()
    >>> for k in range(N):
    ...     frequency = myFrequencyGrid.getValue(k)
    ...     matrix = ot.HermitianMatrix(1)
    ...     matrix[0, 0] = s(frequency)
    ...     myCollection.add(matrix)

    Create the spectral model:

    >>> mySpectralModel = ot.UserDefinedSpectralModel(myFrequencyGrid, myCollection)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.UserDefinedSpectralModel_getClassName(self)

    def __call__(self, frequency):
        r"""
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.
        """
        return _statistics.UserDefinedSpectralModel___call__(self, frequency)

    def getFrequencyGrid(self):
        r"""
        Return the frequency grid associated to the model.

        Returns
        -------
        grid : :class:`~openturns.RegularGrid`
            The frequency grid of the model.
        """
        return _statistics.UserDefinedSpectralModel_getFrequencyGrid(self)

    def setFrequencyGrid(self, frequencyGrid):
        r"""
        Set the frequency grid associated to the model.

        Parameters
        ----------
        grid : :class:`~openturns.RegularGrid`
            The frequency grid of the model.
        """
        return _statistics.UserDefinedSpectralModel_setFrequencyGrid(self, frequencyGrid)

    def __repr__(self):
        return _statistics.UserDefinedSpectralModel___repr__(self)

    def __str__(self, *args):
        return _statistics.UserDefinedSpectralModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.UserDefinedSpectralModel_swiginit(self, _statistics.new_UserDefinedSpectralModel(*args))
    __swig_destroy__ = _statistics.delete_UserDefinedSpectralModel

# Register UserDefinedSpectralModel in _statistics:
_statistics.UserDefinedSpectralModel_swigregister(UserDefinedSpectralModel)

class WelchFactory(SpectralModelFactoryImplementation):
    r"""
    Welch estimator of the spectral model of a stationary process.

    Refer to :ref:`estimate_spectral_density_function`.

    Parameters
    ----------
    window : :class:`~openturns.FilteringWindows`
        The filtering window model.

        By default, the filtering window model is the Hanning model.
    blockNumber : int
        Number of blocks. 

        By default, *blockNumber=1*.
    overlap : float, :math:`0 \leq overlap \leq 0.5`.
        Overlap rate parameter of the segments of the time series.

        By default, *overlap=0.5*.

    Notes
    -----
    Let :math:`X: \Omega \times \cD \rightarrow \Rset^d`  be a multivariate second order stationary process, with zero mean, where :math:`\cD \in \Rset^n`. We only treat here the case where the domain is of dimension 1: :math:`\cD \in \Rset` (*n=1*).

    If we note :math:`C(\vect{s}, \vect{t})=\Expect{(X_{\vect{s}}-m(\vect{s}))\Tr{(X_{\vect{t}}-m(\vect{t}))}}` its covariance function, then for all :math:`(i,j), C^{stat}_{i,j} : \Rset^n \rightarrow \Rset^n` is :math:`\cL^1(\Rset^n)` (ie :math:`\int_{\Rset^n} |C^{stat}_{i,j}(\vect{\tau})|\di{\vect{\tau}}\, < +\infty`), with :math:`C^{stat}(\vect{\tau}) = C(\vect{s}, \vect{s}+\vect{\tau})` as this quantity does not depend on :math:`\vect{s}`. 

    The bilateral spectral density function :math:`S : \Rset^n \rightarrow \mathcal{H}^+(d)` exists and is defined as the Fourier transform of the covariance function :math:`C^{stat}` :

    .. math::

        \forall \vect{f} \in \Rset^n, \,S(\vect{f}) = \int_{\Rset^n}\exp\left\{  -2i\pi <\vect{f},\vect{\tau}> \right\} C^{stat}(\vect{\tau})\di{\vect{\tau}}


    where :math:`\mathcal{H}^+(d) \in \mathcal{M}_d(\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.


    The Welch estimator is a non parametric estimator based on the segmentation of the time series into *blockNumber* segments  possibly overlapping (size of overlap *overlap*). The length of each segment is deduced.


    Examples
    --------
    Create a time series from a stationary second order process:

    >>> import openturns as ot
    >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 2**8)
    >>> model = ot.CauchyModel([5.0], [3.0])
    >>> gp = ot.SpectralGaussianProcess(model, myTimeGrid)
    >>> myTimeSeries = gp.getRealization()

    Estimate the spectral model with WelchFactory:

    >>> mySegmentNumber = 10
    >>> myOverlapSize = 0.3
    >>> myFactory = ot.WelchFactory(ot.Hanning(), mySegmentNumber , myOverlapSize)
    >>> myEstimatedModel_TS = myFactory.build(myTimeSeries)

    Change the filtering window:

    >>> myFactory.setFilteringWindows(ot.Hamming())


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.WelchFactory_getClassName(self)

    def __repr__(self):
        return _statistics.WelchFactory___repr__(self)

    def __str__(self, *args):
        return _statistics.WelchFactory___str__(self, *args)

    def getFilteringWindows(self):
        r"""
        Accessor to the filtering window.

        Returns
        -------
        filteringWindow : :class:`~openturns.FilteringWindows`
            The filtering window used.

            By default, the :class:`~openturns.Hanning` one.

        """
        return _statistics.WelchFactory_getFilteringWindows(self)

    def setFilteringWindows(self, window):
        r"""
        Accessor to the filtering window.

        Parameters
        ----------
        filteringWindow : :class:`~openturns.FilteringWindows`
            The filtering window used.

        """
        return _statistics.WelchFactory_setFilteringWindows(self, window)

    def getBlockNumber(self):
        r"""
        Accessor to the block number.

        Returns
        -------
        blockNumber : int
            The number of blocks used in the Welch estimator.

            By default, *blockNumber = 1*.


        """
        return _statistics.WelchFactory_getBlockNumber(self)

    def setBlockNumber(self, blockNumber):
        r"""
        Accessor to the block number.

        Parameters
        ----------
        blockNumber : positive int
            The number of blocks used in the Welch estimator.

        """
        return _statistics.WelchFactory_setBlockNumber(self, blockNumber)

    def getOverlap(self):
        r"""
        Accessor to the overlap rate.

        Returns
        -------
        overlap : float, :math:`0 \leq overlap \leq 0.5`.
            The overlap rate of the time series.

            By default, *overlap = 0.5*.


        """
        return _statistics.WelchFactory_getOverlap(self)

    def setOverlap(self, overlap):
        r"""
        Accessor to the block number.

        Parameters
        ----------
        blockNumber : int, :math:`0 \leq overlap \leq 0.5`.
            The overlap rate of the times series.

        """
        return _statistics.WelchFactory_setOverlap(self, overlap)

    def build(self, *args):
        r"""
        Estimate the spetral model.

        Available usages:
            build(*myTimeSeries*)

            build(*myProcessSample*)

        Parameters
        ----------
        myTimeSeries : :class:`~openturns.TimeSeries`
            One realization of the  process.
        myProcessSample : :class:`~openturns.ProcessSample`
            Several realizations of the  process.

        Returns
        -------
        mySpectralModel : :class:`~openturns.UserDefinedSpectralModel`
            The  spectral model estimated with the Welch estimator.


        """
        return _statistics.WelchFactory_build(self, *args)

    def buildAsUserDefinedSpectralModel(self, *args):
        return _statistics.WelchFactory_buildAsUserDefinedSpectralModel(self, *args)

    def __init__(self, *args):
        _statistics.WelchFactory_swiginit(self, _statistics.new_WelchFactory(*args))
    __swig_destroy__ = _statistics.delete_WelchFactory

# Register WelchFactory in _statistics:
_statistics.WelchFactory_swigregister(WelchFactory)

class ExponentialModel(StationaryCovarianceModel):
    r"""
    Multivariate stationary exponential covariance function.

    Available constructors:
        ExponentialModel(*spatialDim=1*)

        ExponentialModel(*scale, amplitude*)

        ExponentialModel(*scale, amplitude, spatialCorrelation*)

        ExponentialModel(*scale, spatialCovariance*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        By default, the input dimension is deduced from the :math:`\vect{\theta}` parameter. If this one is not specified, then :math:`n=1`.
    scale : sequence of floats
         Scale coefficient :math:`\vect{\theta}\in \Rset^n`.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\vect{\sigma}\in \Rset^d`.    
    spatialCorrelation : :class:`~openturns.CorrelationMatrix`
        Correlation matrix :math:`\mat{R} \in \cS_d^+([-1, 1])`
        By default, :math:`\mat{R}= \mat{I}_d` where the dimension :math:`d` is deduced from the amplitude :math:`\vect{\sigma}`.
    spatialCovariance : :class:`~openturns.CovarianceMatrix`
        Covariance matrix :math:`C^{stat} \in \cS_d^+(\Rset)`.

    Notes
    -----
    The *exponential* function is a stationary covariance function with dimension :math:`d\geq1`.

    We consider the scalar stochastic process :math:`X: \Omega \times\cD \rightarrow \Rset^d`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The  *exponential* function is defined by:

    .. math::

        C(\vect{s}, \vect{t}) = \rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)\, \mbox{Diag}(\vect{\sigma}) \, \mat{R} \, \mbox{Diag}(\vect{\sigma}), \quad \forall (\vect{s}, \vect{t}) \in \cD

    where the spatial covariance function :math:`\rho` writes:

    .. math::
        \rho(\vect{s}, \vect{t} ) = e^{-\left\| \vect{s}- \vect{t} \right\|_2} \quad \forall (\vect{s}, \vect{t}) \in \cD

    The spatial covariance matrix  writes:

    .. math::
        C^{stat}(\vect{s}, \vect{t})= \mbox{Diag}(\vect{\sigma}) \, \mat{R} \,  \mbox{Diag}(\vect{\sigma}) 


    Examples
    --------
    Create an exponential model from the amplitude :math:`\vect{\sigma}` and the scale :math:`\vect{\theta}`:

    >>> import openturns as ot
    >>> amplitude = [1.0, 2.0]
    >>> scale = [4.0, 5.0]
    >>> myCovarianceModel = ot.ExponentialModel(scale, amplitude)

    Create an exponential model from the amplitude, scale and the correlation matrix:

    >>> amplitude = [1.0, 2.0]
    >>> scale = [4.0, 5.0]
    >>> spatialCorrelation = ot.CorrelationMatrix(2)
    >>> spatialCorrelation[0,1] = 0.8
    >>> myCovarianceModel = ot.ExponentialModel(scale, amplitude, spatialCorrelation)

    Create an exponential model from the scale and covariance matrix:

    >>> amplitude = [1.0, 2.0]
    >>> scale = [4.0, 5.0]
    >>> spatialCovariance = ot.CovarianceMatrix(2)
    >>> spatialCovariance[0,0] = 4.0
    >>> spatialCovariance[1,1] = 5.0
    >>> spatialCovariance[0,1] = 1.2
    >>> inputDimension = 2
    >>> myCovarianceModel = ot.ExponentialModel(scale, spatialCovariance)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ExponentialModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.ExponentialModel_computeStandardRepresentative(self, *args)

    def partialGradient(self, *args):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.ExponentialModel_partialGradient(self, *args)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.ExponentialModel_discretize(self, *args)

    def __repr__(self):
        return _statistics.ExponentialModel___repr__(self)

    def __str__(self, *args):
        return _statistics.ExponentialModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.ExponentialModel_swiginit(self, _statistics.new_ExponentialModel(*args))
    __swig_destroy__ = _statistics.delete_ExponentialModel

# Register ExponentialModel in _statistics:
_statistics.ExponentialModel_swigregister(ExponentialModel)

class ExponentiallyDampedCosineModel(StationaryCovarianceModel):
    r"""
    Exponentially damped cosine covariance function.

    Available constructors:
        ExponentiallyDampedCosineModel(*spatialDim=1*)

        ExponentiallyDampedCosineModel(*scale, amplitude, f*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\vect{\theta}\in \Rset^n`.
        The size of :math:`\vect{\theta}` is the input dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\vect{\sigma} \in \Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.
    f : positive float
        Frequency parameter.

    Notes
    -----
    The *exponentially damped cosine* function is a stationary covariance function with dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \Omega \times\cD \mapsto \Rset`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The  *exponentially damped cosine* covariance function is defined by:

    .. math::

        C(\vect{s}, \vect{t}) = \sigma^2 e^{\left(-\left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2\right)} \cos\left(2 \pi f \left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2 \right), \quad \forall (\vect{s}, \vect{t}) \in \cD

    The correlation function :math:`\rho` writes:

    .. math::

        \rho(\vect{s}, \vect{t}) = e^{\left(-\left\| \vect{s}- \vect{t}\right\|_2\right)} \cos\left(2 \pi f \left\| \vect{s}-\vect{t} \right\|_2 \right), \quad \forall (\vect{s}, \vect{t}) \in \cD




    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard exponentially damped cosine covariance function:

    >>> import openturns as ot
    >>> covModel = ot.ExponentiallyDampedCosineModel(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.5, 0.4]
    >>> print(covModel(s, t))
    [[ -0.564137 ]]
    >>> tau = [0.1, 0.1]
    >>> print(covModel(tau))
    [[ 0.547367 ]]

    Create a exponentially damped cosine  covariance function specifying the amplitude and the scale:

    >>> covModel2 = ot.ExponentiallyDampedCosineModel([3.3], [1.2], 5.0)

    Create a  exponentially damped cosine  covariance function specifying the amplitude and the scale:

    >>> covModel3 = ot.ExponentiallyDampedCosineModel([1.5, 2.5], [3.5], 5.0)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ExponentiallyDampedCosineModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.ExponentiallyDampedCosineModel_computeStandardRepresentative(self, *args)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.ExponentiallyDampedCosineModel___call__(self, *args)

    def computeAsScalar(self, tau):
        r"""
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(\vect{s}, \vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})` as
        this quantity does not depend on :math:`\vect{s}`.
        """
        return _statistics.ExponentiallyDampedCosineModel_computeAsScalar(self, tau)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.ExponentiallyDampedCosineModel_discretize(self, *args)

    def __repr__(self):
        return _statistics.ExponentiallyDampedCosineModel___repr__(self)

    def __str__(self, *args):
        return _statistics.ExponentiallyDampedCosineModel___str__(self, *args)

    def setFrequency(self, frequency):
        r"""
        Frequency accessor.

        Parameters
        ----------
        f : positive float
            Frequency parameter.
        """
        return _statistics.ExponentiallyDampedCosineModel_setFrequency(self, frequency)

    def getFrequency(self):
        r"""
        Frequency accessor.

        Returns
        -------
        f : positive float
            Frequency parameter.
        """
        return _statistics.ExponentiallyDampedCosineModel_getFrequency(self)

    def __init__(self, *args):
        _statistics.ExponentiallyDampedCosineModel_swiginit(self, _statistics.new_ExponentiallyDampedCosineModel(*args))
    __swig_destroy__ = _statistics.delete_ExponentiallyDampedCosineModel

# Register ExponentiallyDampedCosineModel in _statistics:
_statistics.ExponentiallyDampedCosineModel_swigregister(ExponentiallyDampedCosineModel)

class SphericalModel(StationaryCovarianceModel):
    r"""
    Spherical covariance function.

    Available constructors:
        SphericalModel(*spatialDim=1*)

        SphericalModel(*scale, amplitude*)

        SphericalModel(*scale, amplitude, radius*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        By default, equal to 1.
    scale : sequence of positive floats
        Scale coefficient :math:`\vect{\theta}\in \Rset^n`.
        The size of :math:`\vect{\theta}` is the input dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\vect{\sigma} \in \Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.
    radius : float, :math:`a > 0`
        Radius of the sphere on which the covariance model is not zero.
        By default, equal to 1.


    Notes
    -----
    The *spherical* function is a stationary covariance function with dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \Omega \times\cD \mapsto \Rset`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The  *spherical*  function is defined on the sphere which ray is :math:`a`:

    .. math::

        C(\vect{s}, \vect{t}) = \sigma^2  \left[1 - \frac{1}{2a} \left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2  \left(3 -  \frac{1}{a^2}\left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2^2\right) \right], \quad \forall (\vect{s}, \vect{t}), \left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2 \leq a

    The function is equal to zero outside the sphere.

    The correlation function :math:`\rho` writes:

    .. math::

        \rho(\vect{s}, \vect{t}) = 1 - \frac{1}{2a} \left\|\vect{s} - \vect{t}\right\|_2 \left(3 - \frac{1}{a^2}\left\| \vect{s} - \vect{t} \right\|_2^2\right), \quad \forall (\vect{s}, \vect{t}), \left\|  \vect{s} - \vect{t} \right\|_2 \leq a

    and is equal to zero outside the sphere.


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard spherical covariance function:

    >>> import openturns as ot
    >>> covModel = ot.SphericalModel(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.789282 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.54147 ]]

    Create a  spherical covariance function specifying the scale, amplitude vectors:

    >>> covarianceModel = ot.SphericalModel([0.2, 0.3], [2.5])

    Create a  squared exponential covariance function specifying the scale vector, the amplitude and radius:

    >>> covModel3 = ot.SphericalModel([0.2, 0.3], [2.5], 2.3)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SphericalModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.SphericalModel_computeStandardRepresentative(self, *args)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.SphericalModel___call__(self, *args)

    def computeAsScalar(self, tau):
        r"""
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(\vect{s}, \vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})` as
        this quantity does not depend on :math:`\vect{s}`.
        """
        return _statistics.SphericalModel_computeAsScalar(self, tau)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.SphericalModel_discretize(self, *args)

    def __repr__(self):
        return _statistics.SphericalModel___repr__(self)

    def __str__(self, *args):
        return _statistics.SphericalModel___str__(self, *args)

    def getRadius(self):
        r"""
        Accessor to the radius.

        Returns
        -------
        radius : float, :math:`a > 0`
            Radius of the sphere on which the covariance model is not zero.
        """
        return _statistics.SphericalModel_getRadius(self)

    def setRadius(self, radius):
        r"""
        Accessor to the radius.

        Parameters
        ----------
        radius : float, :math:`a > 0`
            Radius of the sphere on which the covariance model is not zero.
        """
        return _statistics.SphericalModel_setRadius(self, radius)

    def __init__(self, *args):
        _statistics.SphericalModel_swiginit(self, _statistics.new_SphericalModel(*args))
    __swig_destroy__ = _statistics.delete_SphericalModel

# Register SphericalModel in _statistics:
_statistics.SphericalModel_swigregister(SphericalModel)

class CauchyModel(SpectralModelImplementation):
    r"""
    Cauchy spectral model.

    Refer to :ref:`parametric_spectral_model`.

    Available constructors:
        CauchyModel(*theta, sigma*)

    Parameters
    ----------
    theta : sequence of float
        Scale coefficients :math:`\theta` of the spectral density function.
        Vector of size n
    sigma : sequence of float
        Amplitude coefficients :math:`\sigma` of the spectral density function.
        Vector of size p

    Notes
    -----
    The spectral density function of input dimension **n** and output dimension **p** writes:

    .. math::

       \forall (i,j) \in [0,p-1]^2, S(f)_{i,j} =  \Sigma_{i,j} \prod_{k=1}^{n} \frac{\theta_k}{1 + (2\pi \theta_k f)^2}


    Examples
    --------
    >>> import openturns as ot
    >>> spectralModel = ot.CauchyModel([3.0, 2.0], [2.0])
    >>> f = 0.3
    >>> print(spectralModel(f))
    [[ (0.191364,0) ]]
    >>> f = 10
    >>> print(spectralModel(f))
    [[ (1.71084e-07,0) ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CauchyModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representant of the spectral density function.

        Parameters
        ----------
        tau : float
            Frequency value.

        Returns
        -------
        rho : Complex
             Standard representant factor of the spectral density function.

        Notes
        -----
        Using definitions in :class:`~openturns.SpectralModel`: the standard representative function writes:

        .. math::

          \forall \vect{f} \in \Rset^n, \rho(\vect{f} \odot \vect{\theta}) =  \prod_{k=1}^{n} \frac{1}{1 + (2\pi \theta_k f)^2}

        where :math:`(\vect{f} \odot \vect{\theta})_k = \vect{f}_k \vect{\theta}_k`
        """
        return _statistics.CauchyModel_computeStandardRepresentative(self, *args)

    def __repr__(self):
        return _statistics.CauchyModel___repr__(self)

    def __str__(self, *args):
        return _statistics.CauchyModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.CauchyModel_swiginit(self, _statistics.new_CauchyModel(*args))
    __swig_destroy__ = _statistics.delete_CauchyModel

# Register CauchyModel in _statistics:
_statistics.CauchyModel_swigregister(CauchyModel)

class CovarianceModelFactoryImplementation(openturns.common.PersistentObject):
    r"""
    Estimation of the covariance model of a process.

    Notes
    -----
    This class is an interface class for all the classes that build covariance models. OpenTURNS provides two covariance model factories: :class:`~openturns.StationaryCovarianceModelFactory` for stationary processes and :class:`~openturns.NonStationaryCovarianceModelFactory` for all processes. This factory does not make any hypothesis on the stationarity of the process.

    See also
    --------
    StationaryCovarianceModelFactory, NonStationaryCovarianceModelFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModelFactoryImplementation_getClassName(self)

    def __repr__(self):
        return _statistics.CovarianceModelFactoryImplementation___repr__(self)

    def __str__(self, *args):
        return _statistics.CovarianceModelFactoryImplementation___str__(self, *args)

    def build(self, *args):
        return _statistics.CovarianceModelFactoryImplementation_build(self, *args)

    def __init__(self, *args):
        _statistics.CovarianceModelFactoryImplementation_swiginit(self, _statistics.new_CovarianceModelFactoryImplementation(*args))
    __swig_destroy__ = _statistics.delete_CovarianceModelFactoryImplementation

# Register CovarianceModelFactoryImplementation in _statistics:
_statistics.CovarianceModelFactoryImplementation_swigregister(CovarianceModelFactoryImplementation)

class CovarianceModelFactoryImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_swiginit(self, _statistics.new_CovarianceModelFactoryImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _statistics.CovarianceModelFactoryImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _statistics.delete_CovarianceModelFactoryImplementationTypedInterfaceObject

# Register CovarianceModelFactoryImplementationTypedInterfaceObject in _statistics:
_statistics.CovarianceModelFactoryImplementationTypedInterfaceObject_swigregister(CovarianceModelFactoryImplementationTypedInterfaceObject)

class CovarianceModelFactory(CovarianceModelFactoryImplementationTypedInterfaceObject):
    r"""
    Estimation of the covariance model of a process.

    Notes
    -----
    This class is an interface class for all the classes that build covariance models. OpenTURNS provides two covariance model factories: :class:`~openturns.StationaryCovarianceModelFactory` for stationary processes and :class:`~openturns.NonStationaryCovarianceModelFactory` for all processes. This factory does not make any hypothesis on the stationarity of the process.

    See also
    --------
    StationaryCovarianceModelFactory, NonStationaryCovarianceModelFactory
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModelFactory_getClassName(self)

    def __repr__(self):
        return _statistics.CovarianceModelFactory___repr__(self)

    def __str__(self, *args):
        return _statistics.CovarianceModelFactory___str__(self, *args)

    def build(self, *args):
        return _statistics.CovarianceModelFactory_build(self, *args)

    def __init__(self, *args):
        _statistics.CovarianceModelFactory_swiginit(self, _statistics.new_CovarianceModelFactory(*args))
    __swig_destroy__ = _statistics.delete_CovarianceModelFactory

# Register CovarianceModelFactory in _statistics:
_statistics.CovarianceModelFactory_swigregister(CovarianceModelFactory)

class UserDefinedCovarianceModel(CovarianceModelImplementation):
    r"""
    Covariance model defined by the User.

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        A mesh which contains `N` vertices.
    matrix : :class:`~openturns.CovarianceMatrix`
        A symmetric positive definite matrix of dimension :math:`Nd` corresponding to the discretization of the model over the given mesh.

    Notes
    -----
    Let :math:`\mat{\Sigma}` be the given covariance matrix, :math:`s_i` and :math:`s_j` be two vertices of the mesh, with :math:`i,j\in\{0,\dots,N-1\}`. The :math:`d\times d` sub-matrix :math:`\mat{S}=(\Sigma_{id+k,jd+\ell})_{k,\ell\in\{0,\dots,d-1}` is equal to :math:`C(s_i,s_j)`, where :math:`C` is the user defined covariance model.

    Examples
    --------
    >>> import openturns as ot
    >>> import math as m

    Create the covariance function at (s,t):

    >>> def C(s, t):
    ...     return m.exp( -4.0 * abs(s - t) / (1 + (s * s + t * t)))

    Create the time grid:

    >>> N = 32
    >>> a = 4.0
    >>> myMesh = ot.IntervalMesher([N]).build(ot.Interval(-a, a))

    Create the large covariance matrix:

    >>> myCovariance = ot.CovarianceMatrix(myMesh.getVerticesNumber())
    >>> for k in range(myMesh.getVerticesNumber()):
    ...     t = myMesh.getVertices()[k]
    ...     for l in range(k + 1):
    ...         s = myMesh.getVertices()[l]
    ...         myCovariance[k, l] = C(s[0], t[0])

    Create the covariance model:

    >>> myCovarianceModel = ot.UserDefinedCovarianceModel(myMesh, myCovariance)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.UserDefinedCovarianceModel_getClassName(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.UserDefinedCovarianceModel___call__(self, *args)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.UserDefinedCovarianceModel_discretize(self, *args)

    def discretizeRow(self, vertices, p):
        r"""**(TODO)**"""
        return _statistics.UserDefinedCovarianceModel_discretizeRow(self, vertices, p)

    def discretizeAndFactorize(self, vertices):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\in \cM_{nd\times nd}(\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.UserDefinedCovarianceModel_discretizeAndFactorize(self, vertices)

    def getMesh(self):
        r"""
        Accessor to the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh associated to the collection of covariance matrices.

        """
        return _statistics.UserDefinedCovarianceModel_getMesh(self)

    def getTimeGrid(self):
        r"""
        Accessor to the time grid.

        Returns
        -------
        mesh : :class:`~openturns.RegularGrid`
            The time grid associated to the collection of covariance matrices when the mesh can be interpreted as a regular time grid.

        """
        return _statistics.UserDefinedCovarianceModel_getTimeGrid(self)

    def __repr__(self):
        return _statistics.UserDefinedCovarianceModel___repr__(self)

    def __str__(self, *args):
        return _statistics.UserDefinedCovarianceModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.UserDefinedCovarianceModel_swiginit(self, _statistics.new_UserDefinedCovarianceModel(*args))
    __swig_destroy__ = _statistics.delete_UserDefinedCovarianceModel

# Register UserDefinedCovarianceModel in _statistics:
_statistics.UserDefinedCovarianceModel_swigregister(UserDefinedCovarianceModel)

class NonStationaryCovarianceModelFactory(CovarianceModelFactoryImplementation):
    r"""
    Estimation of a non stationary covariance model.

    Refer to :ref:`estimate_non_stationary_covariance_model`.

    Notes
    -----
    We consider :math:`X: \Omega \times \cD \rightarrow \Rset^d` be a multivariate process of dimension *d* where :math:`\cD \in \Rset^n`. 
    We denote :math:`(\vect{t}_0, \dots, \vect{t}_{N-1})` the vertices of the mesh :math:`\cM \in \cD`.

    *X* is supposed to be a second order process and we note :math:`C : \cD \times \cD \rightarrow \mathcal{M}_{d \times d}(\mathbb{R})` its covariance function. *X* may be stationary or non stationary as well.

    We suppose that we have *K* fields and we note :math:`(\vect{x}_0^k, \dots, \vect{x}_{N-1}^k)` the values of the field *k* on the mesh :math:`\cM`.

    We recall that the covariance function *C* writes:

    .. math::

        \forall (\vect{s}, \vect{t}) \in \cD \times \cD, \quad C(\vect{s}, \vect{t}) = \Expect{\left(X_{\vect{s}}-m(\vect{s})\right)\Tr{\left(X_{\vect{t}}-m(\vect{t})\right)}}


    where the mean function :math:`m: \cD \rightarrow \Rset^d` is defined by:

    .. math::

        \forall \vect{t}\in \cD , \quad m(\vect{t}) = \Expect{X_{\vect{t}}}


    First, we estimate the covariance function *C* on the vertices of the mesh :math:`\cM` using the empirical mean estimator:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            & \forall \vect{t}_i \in \cM, \quad m(\vect{t}_i) \simeq \frac{1}{K} \sum_{k=1}^{K} \vect{x}_i^k \\
            & \forall (\vect{t}_i, \vect{t}_j) \in \cD \times \cD, \quad C(\vect{t}_i, \vect{t}_j) \simeq \frac{1}{K} \sum_{k=1}^{K} \left( \vect{x}_i^k - m(\vect{t}_i) \right) \Tr{\left( \vect{x}_j^k - m(\vect{t}_j) \right)}
        \end{eqnarray*}


    Then, we build a covariance function defined on :math:`\cD \times \cD` which is a piecewise constant function defined on :math:`\cD \times \cD` by:

    .. math::

        \forall (\vect{s}, \vect{t}) \in \cD \times \cD, \, C(\vect{s}, \vect{t}) = C(\vect{t}_k, \vect{t}_l)

    where *k* is such that :math:`\vect{t}_k` is the vertex of :math:`\cM` the nearest to :math:`\vect{s}` and :math:`\vect{t}_l` the nearest to :math:`\vect{t}`.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.NonStationaryCovarianceModelFactory_getClassName(self)

    def __repr__(self):
        return _statistics.NonStationaryCovarianceModelFactory___repr__(self)

    def __str__(self, *args):
        return _statistics.NonStationaryCovarianceModelFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Estimate the covariance model.

        Parameters
        ----------
        sampleFields : :class:`~openturns.ProcessSample`
            The fields used to estimate the covariance model which is not supposed to be stationary.

        Returns
        -------
        covEst : :class:`~openturns.CovarianceModelImplementation`
            The estimated covariance model.

        Examples
        --------
        Create the covariance model, a mesh and a process:

        >>> import openturns as ot
        >>> myModel = ot.AbsoluteExponential([0.1]*2)
        >>> myMesh = ot.IntervalMesher([10]*2).build(ot.Interval([0.0]*2, [1.0]*2))
        >>> myProcess = ot.GaussianProcess(myModel, myMesh)

        Generate 10 fields:

        >>> mySample = myProcess.getSample(10)

        Estimate the covariance model without supposing the stationarity:

        >>> myEstCov = ot.NonStationaryCovarianceModelFactory().build(mySample)

        """
        return _statistics.NonStationaryCovarianceModelFactory_build(self, *args)

    def buildAsUserDefinedCovarianceModel(self, sample, isCentered=False):
        r"""
        Estimate the covariance model as a User defined covariance model.

        Parameters
        ----------
        sampleFields : :class:`~openturns.ProcessSample`
            The fields used to estimate the covariance model.
        isCentered : bool, optional
            Flag telling if the given sample is from a centered process or if it has to be centered by the empirical mean. Default value is *False*.

        Returns
        -------
        covEst : :class:`~openturns.UserDefinedCovarianceModel`
            The estimated covariance model that can be used as  a :class:`~openturns.UserDefinedCovarianceModel`.

        """
        return _statistics.NonStationaryCovarianceModelFactory_buildAsUserDefinedCovarianceModel(self, sample, isCentered)

    def buildAsCovarianceMatrix(self, sample, isCentered=False):
        r"""
        Estimate the covariance model as a covariance matrix.

        Parameters
        ----------
        sampleFields : :class:`~openturns.ProcessSample`
            The fields used to estimate the covariance model.
        isCentered : bool, optional
            Flag telling if the given sample is from a centered process or if it has to be centered by the empirical mean. Default value is *False*.

        Returns
        -------
        covEst : :class:`~openturns.CovarianceMatrix`
            The unbiased estimation of the discretization of the covariance function over the mesh defining the given sample.

        """
        return _statistics.NonStationaryCovarianceModelFactory_buildAsCovarianceMatrix(self, sample, isCentered)

    def __init__(self, *args):
        _statistics.NonStationaryCovarianceModelFactory_swiginit(self, _statistics.new_NonStationaryCovarianceModelFactory(*args))
    __swig_destroy__ = _statistics.delete_NonStationaryCovarianceModelFactory

# Register NonStationaryCovarianceModelFactory in _statistics:
_statistics.NonStationaryCovarianceModelFactory_swigregister(NonStationaryCovarianceModelFactory)

class UserDefinedStationaryCovarianceModel(StationaryCovarianceModel):
    r"""
    Stationary covariance model defined by the User.

    Parameters
    ----------
    mesh : :class:`~openturns.RegularGrid`
        Time grid of size :math:`N` associated with the process.
    sample : :class:`~openturns.CovarianceMatrixCollection`
        A collection of *N* covariance matrices.

    Notes
    -----
    The covariance model is built as follows.

    We consider a process :math:`X: \Omega \times\cD \mapsto \Rset^d` with :math:`\cD \in \Rset^n`. 

    We note :math:`(\vect{t}_0,\dots, \vect{t}_{N-1})` the vertices of :math:`\cM \in \cD` and :math:`(\mat{C}_{k})_{0 \leq  k \leq N-1}` where :math:`\mat{C}_{k} \in \cS_d^+(\Rset)` the collection of covariance matrices fixed by the User.

    Then we build a stationary covariance function :math:`C^{stat}` which is a  piecewise constant function defined on :math:`\cD \times \cD` by:

    .. math::

        \forall \vect{\tau} \in \cD, \, \quad C^{stat}(\vect{\tau}) =  \mat{C}_k


    where *k* is such that :math:`\vect{t}_k` is the  vertex of :math:`\cM` the nearest to :math:`\vect{\tau}`.

    Examples
    --------
    Create a mesh:

    >>> import openturns as ot
    >>> # Create the time grid
    >>> t0 = 0.0
    >>> dt = 0.5
    >>> N = int((20.0 - t0)/ dt)
    >>> myShiftMesh =  ot.RegularGrid(t0, dt, N)

    Create the stationary covariance function:

    >>> def gamma(tau):
    ...     return 1.0 / (1.0 + tau * tau)

    Create the collection of N covariance matrices:

    >>> myCovarianceCollection = ot.CovarianceMatrixCollection()
    >>> for k in range(N):
    ...     t = myShiftMesh.getValue(k)
    ...     matrix = ot.CovarianceMatrix(1)
    ...     matrix[0, 0] = gamma(t)
    ...     myCovarianceCollection.add(matrix)

    Create the User defined stationary covariance model:

    >>> myCovarianceModel = ot.UserDefinedStationaryCovarianceModel(myShiftMesh,myCovarianceCollection)

    Compute the covariance function at the vertex tau:

    >>> tau = 1.5
    >>> myCovModelMatrix = myCovarianceModel(tau)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.UserDefinedStationaryCovarianceModel_getClassName(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.UserDefinedStationaryCovarianceModel___call__(self, *args)

    def getTimeGrid(self):
        r"""
        Accessor to the time grid.

        Returns
        -------
        mesh : :class:`~openturns.RegularGrid`
            The time grid associated to the collection of covariance matrices.

        """
        return _statistics.UserDefinedStationaryCovarianceModel_getTimeGrid(self)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.UserDefinedStationaryCovarianceModel_discretize(self, *args)

    def __repr__(self):
        return _statistics.UserDefinedStationaryCovarianceModel___repr__(self)

    def __str__(self, *args):
        return _statistics.UserDefinedStationaryCovarianceModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.UserDefinedStationaryCovarianceModel_swiginit(self, _statistics.new_UserDefinedStationaryCovarianceModel(*args))
    __swig_destroy__ = _statistics.delete_UserDefinedStationaryCovarianceModel

# Register UserDefinedStationaryCovarianceModel in _statistics:
_statistics.UserDefinedStationaryCovarianceModel_swigregister(UserDefinedStationaryCovarianceModel)

class StationaryCovarianceModelFactory(CovarianceModelFactoryImplementation):
    r"""
    Estimation of the covariance model of a stationary process.

    Refer to :ref:`estimate_stationary_covariance_model`.

    Parameters
    ----------
    spectralModelFactory : :class:`~openturns.SpectralModelFactory`
        The spectral model factory. 

        By default, it is the Welch factory model.

    Notes
    -----
    We consider :math:`X: \Omega \times \cD \rightarrow \Rset^d`  be a multivariate   process of dimension *d* where :math:`\cD \in \Rset^n`.  We only treat here the case where the domain is of dimension 1: :math:`\cD \in \Rset` (:math:`n=1`). 
    We denote :math:`(\vect{t}_0, \dots, \vect{t}_{N-1})` the vertices of the  mesh :math:`\cM \in \cD` which is a time grid supposed regular.

    *X* is supposed to be a stationary second order process with zero mean. We note its covariance function :math:`C^{stat}:  \cD \rightarrow  \mathcal{M}_{d \times d}(\Rset)`, defined by :math:`C^{stat}(\tau)=\Expect{X_s\Tr{X_{s+\tau}}}` for all :math:`s\in \cD`.

    In addition, we suppose that its spectral density function :math:`S : \Rset \rightarrow \mathcal{H}^+(d)` is defined,  where :math:`\mathcal{H}^+(d) \in \mathcal{M}_d(\Cset)` is the set of *d*-dimensional positive definite hermitian matrices.

    OpenTURNS estimates  :math:`C^{stat}` from a field or a sample of fields of *X*, using first the estimation of the spectral density function and then mapping *S* into :math:`C^{stat}` using the inversion relation :

    .. math::

        C^{stat}(\vect{\tau})  = \int_{\Rset^n}\exp\left\{  2i\pi <\vect{f}, \vect{\tau}> \right\}S(\vect{f})\di{\vect{f}}

    when it is possible.

    As the mesh is a time grid (:math:`n=1`), the fields can be interpreted as time series.

    The estimation  algorithm is outlined hereafter.

    Let :math:`(\vect{X}^0, \dots, , \vect{X}^{M-1})` be *M* independent realizations of *X* or *M* segments of one realization of the process. 

    Using the relation between the covariance model end the spectral function, the covariance function writes:

    .. math::
        :label: eq2

        C_{i,j}^{stat}(\tau)  = \int_{\mathbb{R}}\exp\left\{  2i\pi f \tau \right\} S_{i,j}(f)\di{f}

    where :math:`C_{i,j}^{stat}` is the element *(i,j)* of the matrix :math:`C^{stat}(\tau)` and :math:`S_{i,j}(f)` the one of :math:`S(f)`. The integral :eq:`eq2` is approximated by its evaluation on the finite domain :math:`\Omega \in \Rset`:

    .. math::
        :label: eq3

        C_{i,j}^{stat}(\tau)  = \int_{\Omega}\exp\left\{  2i\pi f \tau \right\} S_{i,j}(f)\di{f}


    Let us consider the partition of the domain as follows:

        - :math:`\Omega =[-\Omega_c, \Omega_c]` is subdivised into *M* segments :math:`\Omega = \cup_{k=1}^{M} \mathcal{M}_k` with :math:`\mathcal{M}_k=[f_k - \frac{\Delta f}{2}, f_k + \frac{\Delta f}{2}]`

        - :math:`\Delta f` be the frequency step, :math:`\Delta f = \frac{2 \Omega_c}{M}`

        - :math:`f_k` be the frequences on which the spectral density is computed, :math:`f_k = -\Omega_c + \left(k - \frac{1}{2} \right) \Delta f = \left( 2 k - 1 - M \right) \frac{\Delta f}{2}` with :math:`k=1,\hdots,M`

    The equation :eq:`eq3` can be rewritten as:

    .. math::

        C_{i,j}^{stat}(\tau)  = \sum_{k=1}^{M}\int_{\mathcal{M}_k}\exp\left\{  2i\pi f \tau \right\} S_{i,j}(f)\di{f}

    We focus on the integral on each subdomain :math:`\mathcal{M}_k`. Using numerical approximation, we have:

    .. math::

        \int_{\mathcal{M}_k}\exp\left\{  2i\pi f \tau \right\} S_{i,j}(f)\di{f} \approx \Delta f S_{i,j}(f_k) \exp\left\{  2i\pi f_k \tau \right\}

    :math:`\tau` must be in correspondance with frequency values with respect to the Shannon criteria. Thus the temporal domain of estimation is the following:

        - :math:`\Delta t` is the time step, :math:`\Delta t = \frac{1}{2 \Omega_c}` such as :math:`\Delta f \Delta t = \frac{1}{M}`

        - :math:`\tilde{\mathcal{T}} = [-T, T]` is subdivised into *M* segments :math:`\tilde{{\mathcal{T}}} = \cup_{m=1}^{M} \mathcal{T}_m` with :math:`\mathcal{T}_m=[t_m - \frac{\Delta t}{2}, t_m + \frac{\Delta t}{2}]`

        - :math:`t_m` be the time values on which the covariance is estimated, :math:`t_m = -\frac{M}{2 \Omega_c} + \left(m - \frac{1}{2} \right) \Delta t = \left(2 m - 1 - M \right) \frac{\Delta t}{2}`

    The estimate of the covariance value at time value :math:`\tau_{m}` depends on the quantities of form:

    .. math::
        :label: eq4

        \int_{\mathcal{M}_k}\exp\left\{  2i\pi f \tau_{m} \right\} S_{i,j}(f)\di{f} \approx \Delta f S_{i,j}(f_k) \exp\left\{  2i\pi f_k \tau_{m} \right\}


    We develop the expression of :math:`f_k` and :math:`\tau_{m}` and we get:

    .. math::

        \left\{
         \begin{array}{l}
           2m - 1 - M = 2 (m-1) - (M-1) \\
           2k - 1 - M = 2 (k-1) - (M-1)
         \end{array}
         \right.

    Thus:

    .. math::

        (2m - 1 - M) (2k - 1 - M) = 4 (m-1)(k-1) - (M-1)(2m -1 -M) - 2 (k-1)(M-1)

    and:

    .. math::

        (2m - 1 - M) (2k - 1 - M)\frac{\Delta t}{2}\frac{\Delta f}{2} = \frac{(m-1)(k-1)}{M} - \frac{(M-1)(2m -1 -M)}{4M} - \frac{(k-1)(M-1)}{2M}


    We denote:

    .. math::

        \left\{
          \begin{array}{l}
            \delta(m) = \exp\left\{-i \frac{\pi}{2M} (M-1)(2m -1 -M) \right\}\\
            \phi_k = \exp\left\{-i \frac{\pi}{M} (k-1)(M-1) \right\} S_{i,j}(f_k)
          \end{array}
          \right.


    Finally, we get the followig expression for integral in :eq:`eq4`:

    .. math::

        \int_{\mathcal{M}_k}\exp\left\{  2i\pi f \tau_{m} \right\} S_{i,j}(f)\di{f} \approx \Delta f \exp\left\{2i \frac{\pi}{M} (m-1)(k-1)  \right\} \delta(m) \phi_k

    It follows that:

    .. math::
        :label: eq5

        C_{i,j}^{stat}(\tau_m)  = \Delta f \delta(m) \sum_{k=1}^{M} \phi_k \exp\left\{2i \frac{\pi}{M} (m-1)(k-1)  \right\}

    In the equation :eq:`eq5`, we notice a discrete inverse Fourier transform.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.StationaryCovarianceModelFactory_getClassName(self)

    def getSpectralModelFactory(self):
        r"""
        Accessor to the underlying Welch agorithm.

        Returns
        -------
        spectralModelFactory : :class:`~openturns.WelchFactory`
            The Welch algorithm used to estimate the stationary covariance model.

        """
        return _statistics.StationaryCovarianceModelFactory_getSpectralModelFactory(self)

    def setSpectralModelFactory(self, factory):
        r"""
        Accessor to the underlying Welch agorithm.

        Parameters
        ----------
        spectralModelFactory : :class:`~openturns.WelchFactory`
            The Welch algorithm to use to estimate the stationary covariance model.

        """
        return _statistics.StationaryCovarianceModelFactory_setSpectralModelFactory(self, factory)

    def __repr__(self):
        return _statistics.StationaryCovarianceModelFactory___repr__(self)

    def __str__(self, *args):
        return _statistics.StationaryCovarianceModelFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Estimate a stationary covariance model.

        Available usages:
            build(*processSample*)

            build(*field*)

        Parameters
        ----------
        processSample : :class:`~openturns.ProcessSample`
            The collection of fields used to estimate the covariance model.
        field : :class:`~openturns.Field`
            The field used to estimate the covariance model. 

        Returns
        -------
        covEst : :class:`~openturns.CovarianceModelImplementation`
            The estimated covariance model.

        Notes
        -----
        The fields must be time series, ie the underlying mesh must be a 1D lattice.

        The estimated :class:`~openturns.CovarianceModelImplementation` which is a :class:`~openturns.UserDefinedStationaryCovarianceModel` composed of a time grid and a collection of *K* square matrices of dimension *d* where *K* corresponds to the number of time steps of the final time grid on which the covariance is estimated.

        When estimated from a time series, the :class:`~openturns.UserDefinedStationaryCovarianceModel` may have a  time grid different from the initial time grid of the time series.

        Examples
        --------
        Create the stationary covariance model, a mesh and a process:

        >>> import openturns as ot
        >>> myModel = ot.AbsoluteExponential([0.1])
        >>> myTimeGrid = ot.RegularGrid(0.0, 0.1, 10)
        >>> myProcess = ot.GaussianProcess(myModel, myTimeGrid)

        Generate 20 fields:

        >>> mySample = myProcess.getSample(20)

        Estimate the covariance model  supposing the stationarity:

        >>> myEstCov = ot.StationaryCovarianceModelFactory().build(mySample)

        """
        return _statistics.StationaryCovarianceModelFactory_build(self, *args)

    def buildAsUserDefinedStationaryCovarianceModel(self, *args):
        r"""
        Estimate the covariance model as a User defined covariance model.

        Available usages:
            buildAsUserDefinedStationaryCovarianceModel(*processSample*)

            buildAsUserDefinedStationaryCovarianceModel(*field*)

            buildAsUserDefinedStationaryCovarianceModel(*spectralModel*)

            buildAsUserDefinedStationaryCovarianceModel(*spectralModel, frequencyGrid*)

        Parameters
        ----------
        processSample : :class:`~openturns.ProcessSample`
            The collection fields used to estimate the covariance model which is  supposed to be stationary.
        field : :class:`~openturns.Field`
            The field used to estimate the covariance model. 
        spectralModel : :class:`~openturns.UserDefinedSpectralModel` if alone, otherwise :class:`~openturns.SpectralModel`
            The spectral model to convert into a covariance model.
        frequencyGrid : :class:`~openturns.RegularGrid`
            The frequency grid over which the spectral model is discretized.

        Returns
        -------
        covEst : :class:`~openturns.UserDefinedStationaryCovarianceModel`
            The estimated covariance model that can be used as a :class:`~openturns.UserDefinedStationaryCovarianceModel`.

        """
        return _statistics.StationaryCovarianceModelFactory_buildAsUserDefinedStationaryCovarianceModel(self, *args)

    def __init__(self, *args):
        _statistics.StationaryCovarianceModelFactory_swiginit(self, _statistics.new_StationaryCovarianceModelFactory(*args))
    __swig_destroy__ = _statistics.delete_StationaryCovarianceModelFactory

# Register StationaryCovarianceModelFactory in _statistics:
_statistics.StationaryCovarianceModelFactory_swigregister(StationaryCovarianceModelFactory)

class SquaredExponential(StationaryCovarianceModel):
    r"""
    Squared exponential covariance function.

    Available constructors:
        SquaredExponential(*spatialDim=1*)

        SquaredExponential(*scale*)

        SquaredExponential(*scale, amplitude*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        When not fulfilled, the input dimension is equal to the  size of the parameter :math:`\vect{\theta}`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\vect{\theta}\in \Rset^n`.
        The size of :math:`\vect{\theta}` is the input dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\vect{\sigma}\in \Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.

    Notes
    -----
    The *squared exponential function* is a stationary covariance function with dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \Omega \times\cD \mapsto \Rset`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The  *squared exponential* function is defined by:

    .. math::

        C(\vect{s}, \vect{t}) = \sigma^2 e^{-\frac{1}{2}  \left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_{2}^{2}}, \quad \forall (\vect{s}, \vect{t}) \in \cD

    The correlation function :math:`\rho` writes:

    .. math::

        \rho(\vect{s}, \vect{t}) = e^{-\frac{1}{2}  \left\| \vect{s}- \vect{t} \right\|_{2}^{2}}, \quad \forall (\vect{s}, \vect{t}) \in \cD


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard squared exponential covariance function:

    >>> import openturns as ot
    >>> covModel = ot.SquaredExponential(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.99005 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.951229 ]]

    Create a squared exponential covariance function specifying the scale vector (amplitude is fixed to 1):

    >>> covModel2 = ot.SquaredExponential([1.5, 2.5])
    >>> covModel2bis = ot.SquaredExponential([1.5] * 3)

    Create a  squared exponential covariance function specifying the scale vector and the amplitude :

    >>> covModel3 = ot.SquaredExponential([1.5, 2.5], [3.5])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SquaredExponential_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.SquaredExponential_computeStandardRepresentative(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.SquaredExponential_partialGradient(self, s, t)

    def __repr__(self):
        return _statistics.SquaredExponential___repr__(self)

    def __str__(self, *args):
        return _statistics.SquaredExponential___str__(self, *args)

    def __init__(self, *args):
        _statistics.SquaredExponential_swiginit(self, _statistics.new_SquaredExponential(*args))
    __swig_destroy__ = _statistics.delete_SquaredExponential

# Register SquaredExponential in _statistics:
_statistics.SquaredExponential_swigregister(SquaredExponential)

class GeneralizedExponential(StationaryCovarianceModel):
    r"""
    Absolute exponential covariance function.

    Available constructors:
        GeneralizedExponential(*spatialDim=1*)

        GeneralizedExponential(*scale, p*)

        GeneralizedExponential(*scale, amplitude, p*)


    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        When not fulfilled, the input dimension is equal to the  size of the parameter :math:`\vect{\theta}`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\vect{\theta}\in \Rset^n`.
        The size of :math:`\vect{\theta}` is the input dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\vect{\sigma}\in \Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.
    p : float, :math:`0<p \leq 2`
        Define the exponent of the euclidean norm that is used within the model.

    Notes
    -----
    The *generalized exponential function* is a stationary covariance function with dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \Omega \times\cD \mapsto \Rset`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The  *generalized exponential* function is defined by:

    .. math::
        C(\vect{s}, \vect{t}) = \sigma^2 e^{-\left|\left|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right|\right|_{2}^p}, \quad \forall (\vect{s}, \vect{t}) \in \cD

    The correlation function :math:`\rho` writes:

    .. math::

        \rho(\vect{s}, \vect{t}) = e^{-\left\| \vect{s}-\vect{t} \right\||_{2}^p}, \quad \forall (\vect{s}, \vect{t}) \in \cD


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard generalized exponential covariance function:

    >>> import openturns as ot
    >>> covModel = ot.GeneralizedExponential(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.868123 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.728893 ]]

    Create a  generalized exponential covariance function specifying the scale vector and p:

    >>> covModel2 = ot.GeneralizedExponential([1.5, 2.5], 1.5)
    >>> covModel2bis = ot.GeneralizedExponential([1.5] * 2, 1.5)

    Create a  generalized exponential covariance function specifying the scale vector, the amplitude and p:

    >>> covModel3 = ot.GeneralizedExponential([1.5, 2.5], [3.5], 1.5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.GeneralizedExponential_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.GeneralizedExponential_computeStandardRepresentative(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.GeneralizedExponential_partialGradient(self, s, t)

    def getP(self):
        r"""
        P accessor.

        Returns
        -------
        p : int, :math:`p \geq 1`
            Define the norm that is used within the model.
        """
        return _statistics.GeneralizedExponential_getP(self)

    def setP(self, p):
        r"""
        P accessor.

        Parameters
        ----------
        p : int, :math:`p \geq 1`
            Define the norm that is used within the model.
        """
        return _statistics.GeneralizedExponential_setP(self, p)

    def __repr__(self):
        return _statistics.GeneralizedExponential___repr__(self)

    def __str__(self, *args):
        return _statistics.GeneralizedExponential___str__(self, *args)

    def __init__(self, *args):
        _statistics.GeneralizedExponential_swiginit(self, _statistics.new_GeneralizedExponential(*args))
    __swig_destroy__ = _statistics.delete_GeneralizedExponential

# Register GeneralizedExponential in _statistics:
_statistics.GeneralizedExponential_swigregister(GeneralizedExponential)

class AbsoluteExponential(StationaryCovarianceModel):
    r"""
    Absolute exponential covariance function.

    Available constructors:
        AbsoluteExponential(*spatialDim=1*)

        AbsoluteExponential(*scale*)

        AbsoluteExponential(*scale, amplitude*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        When not fulfilled, the input dimension is equal to the  size of the parameter :math:`\vect{\theta}`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\vect{\theta}\in \Rset^n`.
        The size of :math:`\vect{\theta}` is the input dimension.
    amplitude : sequence of positive floats
        Amplitude  :math:`\vect{\sigma}\in \Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.


    Notes
    -----
    The *absolute exponential* function is a stationary covariance function with dimension :math:`d=1`.

    We consider the scalar stochastic process :math:`X: \Omega \times\cD \mapsto \Rset`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The  *absolute exponential* function is defined by:

    .. math::

        C(\vect{s}, \vect{t}) = \sigma^2 e^{- \left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_{1}}, \quad \forall (\vect{s}, \vect{t}) \in \cD

    The correlation function :math:`\rho` writes:

    .. math::

        \rho(\vect{s}, \vect{t}) = e^{- \left\| \vect{s}- \vect{t} \right\|_{1}}, \quad \forall (\vect{s}, \vect{t}) \in \cD


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard absolute exponential covariance function:

    >>> import openturns as ot
    >>> covModel = ot.AbsoluteExponential(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.818731 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.67032 ]]

    Create an absolute exponential covariance function specifying only the scale vector (amplitude is fixed to 1):

    >>> covModel2 = ot.AbsoluteExponential([1.5, 2.5])
    >>> covModel2bis = ot.AbsoluteExponential([1.5]*3)

    Create an absolute exponential covariance function specifying the scale vector and the amplitude :

    >>> covModel3 = ot.AbsoluteExponential([1.5, 2.5], [3.5])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.AbsoluteExponential_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.AbsoluteExponential_computeStandardRepresentative(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.AbsoluteExponential_partialGradient(self, s, t)

    def __repr__(self):
        return _statistics.AbsoluteExponential___repr__(self)

    def __str__(self, *args):
        return _statistics.AbsoluteExponential___str__(self, *args)

    def __init__(self, *args):
        _statistics.AbsoluteExponential_swiginit(self, _statistics.new_AbsoluteExponential(*args))
    __swig_destroy__ = _statistics.delete_AbsoluteExponential

# Register AbsoluteExponential in _statistics:
_statistics.AbsoluteExponential_swigregister(AbsoluteExponential)

class MaternModel(StationaryCovarianceModel):
    r"""
    Matern covariance function.

    Available constructors:
        MaternModel(*spatialDim=1*)

        MaternModel(*scale, nu*)

        MaternModel(*scale, amplitude, nu*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        When not fulfilled, the input dimension is equal to the  size of the parameter :math:`\vect{\theta}`.
        By default, equal to 1.
    scale : sequence of floats
        Scale coefficient :math:`\vect{\theta}\in \Rset^n`.
        The size of :math:`\vect{\theta}` is the input dimension.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\vect{\sigma}\in \Rset^d`.
        Must be of size equal to 1.
        By default, equal to :math:`[1]`.
    nu : float, :math:`\nu \geq 0`
        Coefficient :math:`\nu`.

    Notes
    -----
    The *Matern* function is a stationary covariance function with dimension :math:`d=1`.


    We consider the scalar stochastic process :math:`X: \Omega \times\cD \mapsto \Rset`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The  *Matern* function is defined by:

    .. math::

        C(\vect{s}, \vect{t}) = \sigma^2 \dfrac{ 2^{1-\nu} }{\Gamma(\nu) } \left(\sqrt{2 \nu} \left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2\right)^{\nu} \mathrm{K}_{\nu} \left(\sqrt{2 \nu} \left\|\dfrac{\vect{s}-\vect{t}}{\vect{\theta}}\right\|_2\right), \quad \forall (\vect{s}, \vect{t}) \in \cD \times \cD

    The correlation function :math:`\rho` writes:

    .. math::

        \rho(\vect{s}, \vect{t}) = \dfrac{ 2^{1-\nu} }{\Gamma(\nu) } \left(\sqrt{2 \nu} \left\| \vect{s}- \vect{t}  \right\|_2\right)^{\nu} \mathrm{K}_{\nu} \left(\sqrt{2 \nu} \left\| \vect{s}- \vect{t}  \right\|_2\right), \quad \forall (\vect{s}, \vect{t}) \in \cD \times \cD



    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard Matern covariance function:

    >>> import openturns as ot
    >>> covModel = ot.MaternModel(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.2, 0.4]
    >>> print(covModel(s, t))
    [[ 0.974477 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0.894994 ]]

    Create a  Matern covariance function specifying the scale vector and :math:`\nu`:

    >>> covModel2 = ot.MaternModel([1.5, 2.5], 2.3)
    >>> covModel2bis = ot.MaternModel([1.5]*3, 2.3)

    Create a  Matern covariance function specifying the scale vector, the amplitude and :math:`\nu`:

    >>> covModel3 = ot.MaternModel([1.5, 2.5], [3.5], 4.5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.MaternModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.MaternModel_computeStandardRepresentative(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.MaternModel_partialGradient(self, s, t)

    def setScale(self, *args):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _statistics.MaternModel_setScale(self, *args)

    def getNu(self):
        r"""
        Nu accessor.

        Returns
        -------
        nu : float, :math:`\nu \geq 0`
            Coefficient :math:`\nu`.
        """
        return _statistics.MaternModel_getNu(self)

    def setNu(self, nu):
        r"""
        Nu accessor.

        Parameters
        ----------
        nu : float, :math:`\nu \geq 0`
            Coefficient :math:`\nu`.
        """
        return _statistics.MaternModel_setNu(self, nu)

    def __repr__(self):
        return _statistics.MaternModel___repr__(self)

    def __str__(self, *args):
        return _statistics.MaternModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.MaternModel_swiginit(self, _statistics.new_MaternModel(*args))
    __swig_destroy__ = _statistics.delete_MaternModel

# Register MaternModel in _statistics:
_statistics.MaternModel_swigregister(MaternModel)

class DiracCovarianceModel(StationaryCovarianceModel):
    r"""
    Dirac covariance function.

    Available constructors:
        DiracCovarianceModel(*spatialDim=1*)

        DiracCovarianceModel(*spatialDim, amplitude*)

        DiracCovarianceModel(*spatialDim, amplitude, spatialCorrelation*)

        DiracCovarianceModel(*spatialDim, spatialCovariance*)

    Parameters
    ----------
    spatialDim : int
        Spatial dimension :math:`n`.
        By default, equal to 1.
    amplitude : sequence of positive floats
        Amplitude of the process :math:`\vect{\sigma}\in \Rset^d`.
        Its size is the dimension :math:`d` of the process.
        By default, equal to :math:`[1]`.
    spatialCorrelation : :class:`~openturns.CorrelationMatrix`
        Correlation matrix :math:`\mat{R} \in \cS^+_d([-1, 1])`.
        By default, Identity matrix.
    spatialCovariance : :class:`~openturns.CovarianceMatrix`
        Covariance matrix :math:`\mat{C}^{stat} \in \cS_d^+(\Rset)`.
        By default, Identity matrix.

    Notes
    -----
    The *Dirac* covariance function is a stationary covariance function with dimension :math:`d \geq 1`.

    We consider the stochastic process :math:`X: \Omega \times\cD \mapsto \Rset^d`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The  *Dirac* covariance function is defined by:

    .. math::

        C(\vect{s}, \vect{t}) =  1_{\{\vect{s}=\vect{t}\}} \, \mbox{Diag}(\vect{\sigma}) \, \mat{R}\,  \mbox{Diag}(\vect{\sigma}), \quad \forall (\vect{s}, \vect{t}) \in \cD

    where :math:`\mat{R} \in \cS_d^+([-1,1])` is the spatial correlation matrix. We can define the spatial covariance matrix :math:`\mat{C}^{stat}` as:

    .. math::

        \mat{C}^{stat} = \mbox{Diag}(\vect{\sigma}) \, mat{R}\,  \mbox{Diag}(\vect{\sigma})

    The correlation function :math:`\rho` writes:

    .. math::

        \rho(\vect{s}, \vect{t}) = 1_{\{\vect{s}=\vect{t}\}}


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard Dirac covariance function:


    >>> import openturns as ot
    >>> covModel = ot.DiracCovarianceModel(2)
    >>> t = [0.1, 0.3]
    >>> s = [0.1, 0.3]
    >>> print(covModel(s, t))
    [[ 1 ]]
    >>> tau = [0.1, 0.3]
    >>> print(covModel(tau))
    [[ 0 ]]

    Create a  Dirac covariance function specifying the amplitude vector:

    >>> covModel2 = ot.DiracCovarianceModel(2, [1.5, 2.5])

    Create a  Dirac covariance function specifying the amplitude vector and the correlation matrix:

    >>> corrMat = ot.CorrelationMatrix(2)
    >>> corrMat[1,0] = 0.1
    >>> covModel3 =  ot.DiracCovarianceModel(2, [1.5, 2.5], corrMat)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.DiracCovarianceModel_getClassName(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.DiracCovarianceModel___call__(self, *args)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.DiracCovarianceModel_discretize(self, *args)

    def discretizeRow(self, vertices, p):
        r"""**(TODO)**"""
        return _statistics.DiracCovarianceModel_discretizeRow(self, vertices, p)

    def discretizeAndFactorize(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\in \cM_{nd\times nd}(\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.DiracCovarianceModel_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        r"""
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\in\cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.DiracCovarianceModel_discretizeHMatrix(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.DiracCovarianceModel_partialGradient(self, s, t)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _statistics.DiracCovarianceModel_setScale(self, scale)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.DiracCovarianceModel_setAmplitude(self, amplitude)

    def setOutputCorrelation(self, outputCorrelation):
        r"""
        Set the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+([-1,1])`.
        """
        return _statistics.DiracCovarianceModel_setOutputCorrelation(self, outputCorrelation)

    def __repr__(self):
        return _statistics.DiracCovarianceModel___repr__(self)

    def __str__(self, *args):
        return _statistics.DiracCovarianceModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.DiracCovarianceModel_swiginit(self, _statistics.new_DiracCovarianceModel(*args))
    __swig_destroy__ = _statistics.delete_DiracCovarianceModel

# Register DiracCovarianceModel in _statistics:
_statistics.DiracCovarianceModel_swigregister(DiracCovarianceModel)

class FractionalBrownianMotionModel(CovarianceModelImplementation):
    r"""
    Multivariate fractional Brownian motion covariance function.

    Available constructors:
        FractionalBrownianMotionModel()

        FractionalBrownianMotionModel(*scale, amplitude, exponent*)

        FractionalBrownianMotionModel(*scale, amplitude, exponent, eta, rho*)


    Parameters
    ----------
    scale : positive float
        Correlation scale between two locations.
    amplitude : sequence of positive floats
        Standard deviations of the model :math:`\vect{\sigma}\in \Rset^d`.
    exponent : sequence of float, :math:`0<exponent_i<1`
        Hurst exponents of the model, ie homogeneity degrees of the self-similarity
        property.
    eta : :class:`~openturns.SquareMatrix`
        Disymmetry matrix. This matrix expresses the antisymmetric part of the
        dependence between the components of the model. It is antisymmetric, only its
        strictly lower part is addressed.
    rho : :class:`~openturns.CorrelationMatrix`
        Correlation matrix. This matrix expresses the symmetric part of the dependence
        between the components of the model.

    Notes
    -----
    The *multivariate fractional Brownian motion model* is a nonstationary covariance
    function of input dimension 1 defined by:

    .. math::
        :nowrap:

        \begin{align*}
          \forall s, t\in \Rset, &\\
          C_{i,j}(s, t)=&\dfrac{\sigma_i\sigma_j}{2}\left\{\rho_{i,j}\left(\left|\dfrac{s}{\theta}\right|^{H_{ij}}+\left|\dfrac{t}{\theta}\right|^{H_{ij}}-\left|\dfrac{t-s}{\theta}\right|^{H_{ij}}\right)-\eta_{i,j}(H_{ij}-1)\left(\sgn(s)\left|\dfrac{s}{\theta}\right|^{H_{ij}}-\sgn(t)\left|\dfrac{t}{\theta}\right|^{H_{ij}}+\sgn(t-s)\left|\dfrac{t-s}{\theta}\right|^{H_{ij}}\right)\right\}
        \end{align*}

    for :math:`H_{ij}=H_i+H_j\neq 1` and:

    .. math::

        \forall s, t\in \Rset, C_{i,j}(s, t)=&\dfrac{\sigma_i\sigma_j}{2}\left\{\rho_{i,j}\left(\left|\dfrac{s}{\theta}\right|+\left|\dfrac{t}{\theta}\right|-\left|\dfrac{t-s}{\theta}\right|\right)-\dfrac{\eta_{i,j}}{\theta}\left(s\log|s|-t\log|t|+(t-s)\log|t-s|\right)\right\}

    for :math:`H_i + H_j=1`, where :math:`H_i` is the Hurst exponent of the
    :math:`i`-th component and :math:`\sigma_i` its amplitude. Not that the scale
    coefficient simplifies in the antisymmetric part when :math:`H_{ij}=1`. The
    compatibility conditions between the vector of exponents, the correlation matrix
    and the disymmetry matrix are quite evolved, see [amblard2012]_. 


    See Also
    --------
    CovarianceModel

    Examples
    --------
    Create a standard fractional Brownian motion covariance, corresponding to the
    univariate standard Brownian motion:

    >>> import openturns as ot
    >>> covModel = ot.FractionalBrownianMotionModel()
    >>> s = 0.1
    >>> t = 0.2
    >>> print(covModel(s, t))
    [[ 0.223607 ]]

    Create an univariate fractional Brownian motion covariance:

    >>> covModel2 = ot.FractionalBrownianMotionModel(0.5, 1.5, 0.25)

    Create a multivariate fractional Brownian motion covariance:

    >>> covModel3 = ot.FractionalBrownianMotionModel(0.5, [1.5, 1.0], [0.25, 0.6], ot.SquareMatrix([[0.0, 0.2], [-0.2, 0.0]]), ot.CorrelationMatrix([[1.0, 0.5], [0.5, 1.0]]))
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.FractionalBrownianMotionModel_getClassName(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.FractionalBrownianMotionModel___call__(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.FractionalBrownianMotionModel_partialGradient(self, s, t)

    def setExponentEtaRho(self, exponent, eta, rho):
        r"""
        Multivariate parameters accessor.

        Parameters
        ----------
        exponent : sequence of float, :math:`H_i\in(0,1)`
            Define the Hurst exponents of the components.
        eta : 2-d sequence of floats
            Disymmetry matrix. This matrix express the antisymmetric part of the
            dependence between the components of the model. It is antisymmetric, only its
            strictly lower part is addressed.
        rho : 2-d sequence of floats
            Correlation matrix. This matrix express the symmetric part of the dependence
            between the components of the model.

        """
        return _statistics.FractionalBrownianMotionModel_setExponentEtaRho(self, exponent, eta, rho)

    def getExponent(self):
        r"""
        Exponent accessor.

        Returns
        -------
        exponent : seqence of float, :math:`H_i\in(0,1)`
            Define the Hurst exponents of the components.
        """
        return _statistics.FractionalBrownianMotionModel_getExponent(self)

    def getEta(self):
        r"""
        Eta accessor.

        Returns
        -------
        eta : 2-d sequence of floats
            Disymmetry matrix. This matrix express the antisymmetric part of the dependence
            between the components of the model. It is antisymmetric, only its strictly
            lower part is addressed.
        """
        return _statistics.FractionalBrownianMotionModel_getEta(self)

    def getRho(self):
        r"""
        Rho accessor.

        Returns
        -------
        rho : 2-d sequence of floats
            Correlation matrix. This matrix express the symmetric part of the dependence
            between the components of the model.
        """
        return _statistics.FractionalBrownianMotionModel_getRho(self)

    def __repr__(self):
        return _statistics.FractionalBrownianMotionModel___repr__(self)

    def __str__(self, *args):
        return _statistics.FractionalBrownianMotionModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.FractionalBrownianMotionModel_swiginit(self, _statistics.new_FractionalBrownianMotionModel(*args))
    __swig_destroy__ = _statistics.delete_FractionalBrownianMotionModel

# Register FractionalBrownianMotionModel in _statistics:
_statistics.FractionalBrownianMotionModel_swigregister(FractionalBrownianMotionModel)

class ProductCovarianceModel(CovarianceModelImplementation):
    r"""
    Univariate covariance function defined as a product.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.CovarianceModel`
        Collection of covariance models :math:`(C_k)_{1 \leq k \leq K}` of dimension :math:`d=1`.

    Notes
    -----
    The *product* covariance function is a covariance function with 
    dimension :math:`d=1`. 
    This allows to create a higher input dimension covariance model 
    by combining models of smaller input dimensions. 
    The input dimension of each model in the collection does not necessarily have to be equal to 1. 
    It defines a covariance model from the given collection as follows.

    We consider the scalar stochastic process :math:`X: \Omega \times\cD \rightarrow \Rset`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    The product covariance function writes:

    .. math::

        C(\vect{s}, \vect{t}) = \prod_{k=1}^K  C_k(\vect{s}_k, \vect{t}_k), \quad \forall (\vect{s}, \vect{t}) \in \cD

    where :math:`C_k : \cD_k \times \cD_k \rightarrow  \cS_d^+(\Rset)`  with :math:`\cD_k \in \Rset^{d_k}`, :math:`\cD = \cD_1 \times \dots \times \cD_K`, :math:`\cD_k \subset \Rset^{n_k}` and :math:`n1 + \dots + n_K=n`.

    :math:`C` also writes:

    .. math::

        C(\vect{s}, \vect{t}) =  \sigma^2 \rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right), \quad \forall (\vect{s}, \vect{t}) \in \cD


    where the amplitude is:

    .. math::

        \sigma= \prod_{k=1}^K \sigma_k

    the scale is:

    .. math::

        \Tr{\vect{\theta}}= \left(\Tr{\vect{\theta}}_1, \dots, \Tr{\vect{\theta}}_K \right)

    and the correlation function :math:`\rho` is:

    .. math::

        \rho \left( \vect{s}, \vect{t} \right) = \prod_{k=1}^K \rho_k\left( \vect{s}_k, \vect{t}_k \right)


    Examples
    --------
    Create a product covariance function from two exponential functions, each one defined on :math:`\Rset \times \Rset \rightarrow \cS_1^+(\Rset)`:

    >>> import openturns as ot
    >>> amplitude = [1.0]
    >>> scale1 = [4.0]
    >>> scale2 = [4.0]
    >>> cov1 = ot.ExponentialModel(scale1, amplitude)
    >>> cov2 = ot.ExponentialModel(scale2, amplitude)
    >>> covarianceModel = ot.ProductCovarianceModel([cov1, cov2])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.ProductCovarianceModel_getClassName(self)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.ProductCovarianceModel_computeStandardRepresentative(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.ProductCovarianceModel_partialGradient(self, s, t)

    def getCollection(self):
        r"""
        Covariance model collection accessor.

        Returns
        -------
        coll : sequence of :class:`~openturns.CovarianceModel`
        """
        return _statistics.ProductCovarianceModel_getCollection(self)

    def getMarginal(self, index):
        r"""
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int or sequence of int
            index of marginal of the model.
        """
        return _statistics.ProductCovarianceModel_getMarginal(self, index)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _statistics.ProductCovarianceModel_setScale(self, scale)

    def isStationary(self):
        r"""
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \forall(\vect{s},\vect{t},\vect{h}) \in \cD \times \cD, & \, \quad
            C(\vect{s}, \vect{s}+\vect{h}) = C(\vect{t}, \vect{t}+\vect{h})


        We note :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})`.
        """
        return _statistics.ProductCovarianceModel_isStationary(self)

    def __repr__(self):
        return _statistics.ProductCovarianceModel___repr__(self)

    def __str__(self, *args):
        return _statistics.ProductCovarianceModel___str__(self, *args)

    def setFullParameter(self, parameter):
        r"""
        Set the full parameters of the covariance function.

        Parameters
        ----------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

            Must be at least of dimension :math:`n+\frac{d(d+1)}{2}`.
        """
        return _statistics.ProductCovarianceModel_setFullParameter(self, parameter)

    def getFullParameter(self):
        r"""
        Get the full parameters of the covariance function.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

        """
        return _statistics.ProductCovarianceModel_getFullParameter(self)

    def getFullParameterDescription(self):
        r"""
        Get the description full parameters of the covariance function.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the full parameter of the covariance function.

        """
        return _statistics.ProductCovarianceModel_getFullParameterDescription(self)

    def setActiveParameter(self, active):
        r"""
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.ProductCovarianceModel_setActiveParameter(self, active)

    def __init__(self, *args):
        _statistics.ProductCovarianceModel_swiginit(self, _statistics.new_ProductCovarianceModel(*args))
    __swig_destroy__ = _statistics.delete_ProductCovarianceModel

# Register ProductCovarianceModel in _statistics:
_statistics.ProductCovarianceModel_swigregister(ProductCovarianceModel)

class RankMCovarianceModel(CovarianceModelImplementation):
    r"""
    Covariance function of finite rank.

    Available constructors:
        RankMCovarianceModel(*inputDimension*)

        RankMCovarianceModel(*variance, basis*)

        RankMCovarianceModel(*covariance, basis*)

    Parameters
    ----------
    variance : sequence of float
        The marginal variances of the coefficients of the basis.
    covariance : :class:`~openturns.CovarianceMatrix`
        The covariance of the coefficients of the basis.

    Notes
    -----
    Let :math:`X` be a stochastic process defined by:

    .. math::

       X(\omega,\vect{t})=\sum_{i=1}^M\xi_i(\omega)\phi_i(\vect{t}), \quad \forall \omega \in \Omega, \vect{t} \in \cD

    where :math:`(\xi_1,\dots,\xi_M)` is a random vector of dimension :math:`M` and :math:`(\phi_i)_{i=1,\dots,M}` are the :math:`M` first elements of a given basis.

    Its covariance function, a *rank-M* covariance function, is given by:

    .. math::

        C(\vect{s}, \vect{t}) = \sum_{i=1}^M \sum_{j=1}^M \Sigma_{ij}\phi_i(\vect{s})\Tr{\phi_j(\vect{t})}, \quad \forall (\vect{s}, \vect{t}) \in \cD

    where :math:`\mat{\Sigma}` is the covariance matrix of :math:`(\xi_1,\dots,\xi_M)`.

    When :math:`\mat{\Sigma}` is diagonal, it reduces to:

    .. math::

        C(\vect{s}, \vect{t}) = \sum_{i=1}^M \sigma_i^2\phi_i(\vect{s})\Tr{\phi_i(\vect{t})}, \quad \forall (\vect{s}, \vect{t}) \in \cD

    where :math:`\sigma_i^2` is the variance of :math:`\xi_i`.

    The name *rank-M* is here to recall that the discretization of such a model will always lead to a covariance matrix of rank *at most* :math:`M`.

    Examples
    --------

    >>> import openturns as ot
    >>> variance = [1.0, 2.0]
    >>> basis = ot.LinearBasisFactory().build()
    >>> myCovarianceModel = ot.RankMCovarianceModel(variance, basis)
    >>> covariance = ot.CovarianceMatrix(2, [1.0, 0.5, 0.5, 2.0])
    >>> covarianceModel = ot.RankMCovarianceModel(covariance, basis)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.RankMCovarianceModel_getClassName(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.RankMCovarianceModel___call__(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.RankMCovarianceModel_partialGradient(self, s, t)

    def getCovariance(self):
        r"""
        Covariance accessor.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance matrix of :math:`(\xi_1,\dots,\xi_M)`. Its dimension is zero if the coefficients are uncorrelated, in which case the marginal variances are given by *getVariance()*.

        """
        return _statistics.RankMCovarianceModel_getCovariance(self)

    def getVariance(self):
        r"""
        Variance accessor.

        Returns
        -------
        variance : :class:`~openturns.Point`
            Vector of marginal variances of :math:`(\xi_1,\dots,\xi_M)`. Its dimension is zero if the coefficients are correlated, in which case the covariance matrix is given by *getCovariance()*.

        """
        return _statistics.RankMCovarianceModel_getVariance(self)

    def getBasis(self):
        r"""
        Accessor to the Basis.

        Returns
        -------
        basis : :class:`~openturns.Basis`
            Basis to which the functions :math:`(\phi_i)_{i=1,\dots,M}` belong.

        """
        return _statistics.RankMCovarianceModel_getBasis(self)

    def getFunctions(self):
        r"""
        Function collection accessor.

        Returns
        -------
        functions : :class:`~openturns.FunctionCollection`
            The collection of functions :math:`(\phi_i)_{i=1,\dots,M}` defining the covariance model.

        """
        return _statistics.RankMCovarianceModel_getFunctions(self)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.RankMCovarianceModel_discretize(self, *args)

    def __repr__(self):
        return _statistics.RankMCovarianceModel___repr__(self)

    def __str__(self, *args):
        return _statistics.RankMCovarianceModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.RankMCovarianceModel_swiginit(self, _statistics.new_RankMCovarianceModel(*args))
    __swig_destroy__ = _statistics.delete_RankMCovarianceModel

# Register RankMCovarianceModel in _statistics:
_statistics.RankMCovarianceModel_swigregister(RankMCovarianceModel)

class TensorizedCovarianceModel(CovarianceModelImplementation):
    r"""
    Multivariate covariance function defined as a tensorization of covariance models.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.CovarianceModel`
        Collection of covariance models :math:`(C_k)_{1 \leq k \leq K}` of dimension :math:`d_k`.

    Notes
    -----
    The tensorized covariance model defines a multivariate covariance model of dimension :math:`d\geq 1` 
    from the tensorization of a given collection of covariance models. 
    This allows to create a higher dimension covariance model by combining models of smaller dimensions. 
    The dimension of each model in the collection does not necessarily have to be equal to 1. 
    The input dimension of each covariance model in the collection must be the same. 

    We consider the stochastic process :math:`X: \Omega \times\cD \mapsto \Rset^d`, where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of :math:`\Rset^n`.

    Its covariance function :math:`C : \cD \times \cD \rightarrow  \cS_d^+(\Rset)` is defined from the collection of covariance functions :math:`C_k: \cD \times \cD \mapsto  \cS_{d_k}^+(\Rset)` where :math:`d_1+\dots+d_k=d`, as follows:

    .. math::
        C(\vect{s}, \vect{t}) =    \left(
            \begin{array}{cccc}
            C_1(\vect{s}, \vect{t}) & 0 & \dots & 0 \\
            0 & C_2(\vect{s}, \vect{t}) & 0 &  \\
            \dots & \dots & \ddots & \dots \\
            0 & \dots & \dots &  C_K(\vect{s}, \vect{t})
            \end{array} \right)

    The amplitude of the covariance function is :math:`\Tr{\sigma} =(\Tr{\sigma}_{1}, \dots, \Tr{\sigma}_{K})` and each model :math:`C_k` is parameterized by its scale :math:`\vect{\theta}_k \in \Rset^n`.

    The method :math:`setScale(\vect{\theta})` updates the scale the following way. Let :math:`\vect{\theta}_k^0=(\theta_{k,1}^0,\hdots,\theta_{k,n}^0)` be the initial scale of the covariance model :math:`C_k`. After the update, :math:`C_k` has the scale :math:`\vect{\theta}_k=\left(\theta_1\rho_{k,1}^0,\hdots,\theta_n\rho_{k,n}^0\right)` where :math:`\rho_{k,j}^0=\dfrac{\theta^0_{k,j}}{\theta^0_{1,j}}`.

    Examples
    --------

    Create a tensorized covariance function from the tensorization of an absolute exponential function, a squared exponential function and an exponential function:

    >>> import openturns as ot
    >>> inputDimension = 2

    Create the each covariance models:

    >>> myCov1 = ot.AbsoluteExponential([3.0] * inputDimension)
    >>> myCov2 = ot.SquaredExponential([2.0] * inputDimension)

    >>> amplitude= [4.0, 2.0]
    >>> scale = [1.0, 1.0]
    >>> spatialCorrelation = ot.CorrelationMatrix(inputDimension)
    >>> spatialCorrelation[1,0] = 0.3
    >>> myCov3 = ot.ExponentialModel(scale, amplitude, spatialCorrelation)

    Define the scale of the tensorized model:

    >>> scale = [0.3, 0.8]

    Create the tensorized model:

    >>> covarianceModel = ot.TensorizedCovarianceModel([myCov1, myCov2, myCov3], scale)

    Fix the same scale to each model:

    >>> covarianceModel.setScale([1.0]*inputDimension)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.TensorizedCovarianceModel_getClassName(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.TensorizedCovarianceModel___call__(self, *args)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.TensorizedCovarianceModel_partialGradient(self, s, t)

    def getCollection(self):
        return _statistics.TensorizedCovarianceModel_getCollection(self)

    def getMarginal(self, index):
        r"""
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int or sequence of int
            index of marginal of the model.
        """
        return _statistics.TensorizedCovarianceModel_getMarginal(self, index)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _statistics.TensorizedCovarianceModel_setScale(self, scale)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.TensorizedCovarianceModel_setAmplitude(self, amplitude)

    def isStationary(self):
        r"""
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \forall(\vect{s},\vect{t},\vect{h}) \in \cD \times \cD, & \, \quad
            C(\vect{s}, \vect{s}+\vect{h}) = C(\vect{t}, \vect{t}+\vect{h})


        We note :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})`.
        """
        return _statistics.TensorizedCovarianceModel_isStationary(self)

    def isDiagonal(self):
        r"""
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.TensorizedCovarianceModel_isDiagonal(self)

    def __repr__(self):
        return _statistics.TensorizedCovarianceModel___repr__(self)

    def __str__(self, *args):
        return _statistics.TensorizedCovarianceModel___str__(self, *args)

    def __init__(self, *args):
        _statistics.TensorizedCovarianceModel_swiginit(self, _statistics.new_TensorizedCovarianceModel(*args))
    __swig_destroy__ = _statistics.delete_TensorizedCovarianceModel

# Register TensorizedCovarianceModel in _statistics:
_statistics.TensorizedCovarianceModel_swigregister(TensorizedCovarianceModel)

class HMatrixFactory(openturns.common.PersistentObject):
    r"""
    Empty HMatrix builder.

    See also
    --------
    HMatrix
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HMatrixFactory_getClassName(self)

    def build(self, *args):
        r"""
        Create the compressed skeleton representation.

        Parameters
        ----------
        sample : 2-d sequence of float
            Vertex locations
        outputDimension : int
            Number of degrees of freedom by vertex location
        symmetric : bool
            Whether matrix is symmetric.
        parameters : :class:`~openturns.HMatrixParameters`
            User-defined settings for hmatrix

        Returns
        -------
        mat : :class:`~openturns.HMatrix`
            The compressed representation.
        """
        return _statistics.HMatrixFactory_build(self, *args)

    @staticmethod
    def IsAvailable():
        r"""
        Ask whether hmat support is available.

        Returns
        -------
        available : bool
            Whether hmat support is enabled.
        """
        return _statistics.HMatrixFactory_IsAvailable()

    def __repr__(self):
        return _statistics.HMatrixFactory___repr__(self)

    def __init__(self, *args):
        _statistics.HMatrixFactory_swiginit(self, _statistics.new_HMatrixFactory(*args))
    __swig_destroy__ = _statistics.delete_HMatrixFactory

# Register HMatrixFactory in _statistics:
_statistics.HMatrixFactory_swigregister(HMatrixFactory)

def HMatrixFactory_IsAvailable():
    r"""
    Ask whether hmat support is available.

    Returns
    -------
    available : bool
        Whether hmat support is enabled.
    """
    return _statistics.HMatrixFactory_IsAvailable()

class HMatrixRealAssemblyFunction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _statistics.delete_HMatrixRealAssemblyFunction

    def __call__(self, i, j):
        return _statistics.HMatrixRealAssemblyFunction___call__(self, i, j)

# Register HMatrixRealAssemblyFunction in _statistics:
_statistics.HMatrixRealAssemblyFunction_swigregister(HMatrixRealAssemblyFunction)

class HMatrixTensorRealAssemblyFunction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _statistics.delete_HMatrixTensorRealAssemblyFunction

    def getDimension(self):
        return _statistics.HMatrixTensorRealAssemblyFunction_getDimension(self)

    def compute(self, i, j, localValues):
        return _statistics.HMatrixTensorRealAssemblyFunction_compute(self, i, j, localValues)

# Register HMatrixTensorRealAssemblyFunction in _statistics:
_statistics.HMatrixTensorRealAssemblyFunction_swigregister(HMatrixTensorRealAssemblyFunction)

class HMatrixClusterTree(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, ptr_cluster_tree, size):
        _statistics.HMatrixClusterTree_swiginit(self, _statistics.new_HMatrixClusterTree(ptr_cluster_tree, size))

    def get(self):
        return _statistics.HMatrixClusterTree_get(self)

    def getSize(self):
        return _statistics.HMatrixClusterTree_getSize(self)
    __swig_destroy__ = _statistics.delete_HMatrixClusterTree

# Register HMatrixClusterTree in _statistics:
_statistics.HMatrixClusterTree_swigregister(HMatrixClusterTree)

class HMatrixImplementation(openturns.common.PersistentObject):
    r"""
    Hierarchical matrices.

    Hierarchical matrices (or HMatrix) are a compressed representation of dense
    matrices.  In many applications, matrix coefficients represent an interaction
    between two degrees of freedom; when these interactions are smooth, it is
    possible to approximate sub-blocks by a local low-rank approximation B =~ UV^T
    where B has dimension (m,n), U (m,k), and V (n,k).
    Of course, this is interesting only if k is much lower than m and n.

    In order to obtain this compressed representation, several different steps must
    be performed:

    1. Clustering: creation of rows and columns cluster trees
       Vertices where interactions are computed are reordered to improve locality.
       A binary space partition algorithm is used to recursively divide vertex set.
       Root cell contains all vertices.  At each recursion step, a cell is divided
       into two new cells until it contains less than a given number of vertices.
       Space partition is performed orthogonally to original axis, by cutting its
       longest dimension.

       * The 'median' clustering algorithm divides a cell into two cells containing
         the same number of degrees of freedom.
       * The 'geometric' clustering algorithm divides a cell into two cells of the
         same geometric size
       * The 'hybrid' clustering algorithm is a mix.  It first performs a 'median'
         bisection; if volumes of these new cells are very different, a 'geometric'
         clustering is performed instead.

    2. Admissibility: creation of an empty HMatrix structure
       The first step created a full binary tree for rows and columns degrees of
       freedom.  We will now create a hierarchical representation of our matrix by
       checking whether some blocks can be replaced by low-rank approximations.
       The whole matrix represents the interactions of all rows degrees of freedom
       against all columns degrees of freedom.  It can not be approximated by a
       low-rank approximation, and thus it is replaced by 4 blocks obtained by
       considering interactions between rows and columns children nodes.  This
       operation is performed recursively.  At each step, we compute axis aligned
       bounding boxes rows_bbox and cols_bbox: if
       min(diameter(rows_bbox), diameter(cols_bbox)) <= eta*distance(rows_bbox, cols_bbox)
       then we consider that interaction between rows and columns degrees of
       freedom can have a local low-rank approximation, and recursion is stopped.
       Otherwise, we recurse until bottom cluster tree is reached.
       The whole matrix is thus represented by a 4-tree where leaves will contain
       either low-rank approximation or full blocks.
       The eta parameter is called the admissibility factor, and it can be modified.

    3. Assembly: coefficients computations
       The hierarchical structure of the matrix has been computed during step 2.
       To compute coefficients, we call the assemble method and provide a callable
       to compute interaction between two nodes.  Full blocks are computed by
       calling this callable for the whole block.  If compression method is 'SVD',
       low-rank approximation is computed by first computing the whole block, then
       finding its singular value decomposition, and rank is truncated so that
       error does not exceed assemblyEpsilon.  This method is precise, but very
       costly.  If compression method is a variant of ACA, only few rows and
       columns are computed.  This is much more efficient, but error may be larger
       than expected on some problems.

    4. Matrix computations
       Once an HMatrix is computed, usual linear algebra operations can be
       performed.  Matrix can be factorized in-place, in order to solve systems.
       Or we can compute its product by a matrix or vector.  But keep in mind that
       rows and columns are reordered internally, and thus results may differ
       sensibly from standard dense representation (for instance when computing a
       Cholesky or LU decomposition).

    See also
    --------
    HMatrixFactory, HMatrixParameters
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HMatrixImplementation_getClassName(self)

    def __init__(self, *args):
        _statistics.HMatrixImplementation_swiginit(self, _statistics.new_HMatrixImplementation(*args))
    __swig_destroy__ = _statistics.delete_HMatrixImplementation

    def getNbRows(self):
        r"""
        Accessor to the number of rows.

        Returns
        -------
        nbRows : int
            Number of rows.
        """
        return _statistics.HMatrixImplementation_getNbRows(self)

    def getNbColumns(self):
        r"""
        Accessor to the number of columns.

        Returns
        -------
        nbColumns : int
            Number of columns.
        """
        return _statistics.HMatrixImplementation_getNbColumns(self)

    def assemble(self, *args):
        r"""
        Assemble matrix.

        Parameters
        ----------
        f : :class:`~openturns.HMatrixRealAssemblyFunction` or :class:`~openturns.HMatrixTensorRealAssemblyFunction`
            Assembly function.
        symmetry : str
            Symmetry flag, either N or L
        """
        return _statistics.HMatrixImplementation_assemble(self, *args)

    def factorize(self, method):
        r"""
        Factorize matrix.

        Parameters
        ----------
        method : str
            Factorization method, either one of: LDLt, LLt or LU
        """
        return _statistics.HMatrixImplementation_factorize(self, method)

    def scale(self, alpha):
        r"""
        Scale matrix in-place A=alpha*A.

        Parameters
        ----------
        alpha : float
            Coefficient.
        """
        return _statistics.HMatrixImplementation_scale(self, alpha)

    def gemv(self, trans, alpha, x, beta, y):
        r"""
        Multiply vector in-place y=alpha*op(A)*x+beta*y.

        Parameters
        ----------
        trans : str
            Whether to use A or A^t: either N or T.
        alpha : float
            Coefficient
        x : sequence of float
            Vector to multiply.
        beta : float
            Coefficient.
        y : :class:`~openturns.Point`
            Vector multiplied in-place.
        """
        return _statistics.HMatrixImplementation_gemv(self, trans, alpha, x, beta, y)

    def gemm(self, transA, transB, alpha, a, b, beta):
        r"""
        Multiply matrix in-place self=alpha*op(A)*op(B)+beta*self.

        Parameters
        ----------
        transA : str
            Whether to use A or A^t: either N or T.
        transB : str
            Whether to use B or B^t: either N or T.
        alpha : float
            Coefficient
        a : :class:`~openturns.HMatrix`
            Multiplied matrix A.
        b : :class:`~openturns.HMatrix`
            Multiplied matrix B.    
        beta : float
            Coefficient.
        """
        return _statistics.HMatrixImplementation_gemm(self, transA, transB, alpha, a, b, beta)

    def transpose(self):
        r"""Transpose matrix in-place."""
        return _statistics.HMatrixImplementation_transpose(self)

    def addIdentity(self, alpha):
        r"""
        Add alpha*Identity to the Matrix.

        Parameters
        ----------
        alpha : float
            Coefficient.
        """
        return _statistics.HMatrixImplementation_addIdentity(self, alpha)

    def norm(self):
        r"""
        Compute norm value.

        Returns
        -------
        norm : float
            Frobenius norm.
        """
        return _statistics.HMatrixImplementation_norm(self)

    def getDiagonal(self):
        r"""
        Diagonal values accessor.

        Returns
        -------
        diag : :class:`~openturns.Point`
            Diagonal values.
        """
        return _statistics.HMatrixImplementation_getDiagonal(self)

    def solve(self, *args):
        r"""
        Solve linear system op(A)*x=b, after A has been factorized.

        Parameters
        ----------
        b : sequence of float or :class:`~openturns.Matrix`
            Second term of the equation, vector or matrix.
        trans : bool
            Whether to solve the equation with A (False) or A^t (True).
            Defaults to False.

        Returns
        -------
        x : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            Equation solution, vector or matrix.
        """
        return _statistics.HMatrixImplementation_solve(self, *args)

    def solveLower(self, *args):
        r"""
        Solve lower linear system op(L)*x=b, after A has been factorized.

        Parameters
        ----------
        b : sequence of float or :class:`~openturns.Matrix`
            Second term of the equation, vector or matrix.
        trans : bool
            Whether to solve the equation with L (False) or L^t (True).
            Defaults to False.

        Returns
        -------
        x : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            Equation solution, vector or matrix.
        """
        return _statistics.HMatrixImplementation_solveLower(self, *args)

    def compressionRatio(self):
        r"""
        Compression ratio accessor.

        Returns
        -------
        ratio : 2-tuple of int
            Numbers of elements in the compressed and uncompressed forms.
        """
        return _statistics.HMatrixImplementation_compressionRatio(self)

    def fullrkRatio(self):
        r"""
        Block ratio accessor.

        Returns
        -------
        ratio : 2-tuple of int
            Numbers of elements in full blocks and low rank blocks.
        """
        return _statistics.HMatrixImplementation_fullrkRatio(self)

    def dump(self, name):
        r"""
        Save matrix to a file.

        Parameters
        ----------
        fileName : str
            File name to save to.
        """
        return _statistics.HMatrixImplementation_dump(self, name)

    def setKey(self, name, value):
        return _statistics.HMatrixImplementation_setKey(self, name, value)

    def __repr__(self):
        return _statistics.HMatrixImplementation___repr__(self)

    def __str__(self, *args):
        return _statistics.HMatrixImplementation___str__(self, *args)

# Register HMatrixImplementation in _statistics:
_statistics.HMatrixImplementation_swigregister(HMatrixImplementation)

class CovarianceAssemblyFunction(HMatrixRealAssemblyFunction):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, covarianceModel, vertices):
        _statistics.CovarianceAssemblyFunction_swiginit(self, _statistics.new_CovarianceAssemblyFunction(covarianceModel, vertices))

    def __call__(self, i, j):
        return _statistics.CovarianceAssemblyFunction___call__(self, i, j)
    __swig_destroy__ = _statistics.delete_CovarianceAssemblyFunction

# Register CovarianceAssemblyFunction in _statistics:
_statistics.CovarianceAssemblyFunction_swigregister(CovarianceAssemblyFunction)

class CovarianceBlockAssemblyFunction(HMatrixTensorRealAssemblyFunction):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, covarianceModel, vertices):
        _statistics.CovarianceBlockAssemblyFunction_swiginit(self, _statistics.new_CovarianceBlockAssemblyFunction(covarianceModel, vertices))

    def compute(self, i, j, localValues):
        return _statistics.CovarianceBlockAssemblyFunction_compute(self, i, j, localValues)
    __swig_destroy__ = _statistics.delete_CovarianceBlockAssemblyFunction

# Register CovarianceBlockAssemblyFunction in _statistics:
_statistics.CovarianceBlockAssemblyFunction_swigregister(CovarianceBlockAssemblyFunction)

class HMatrixImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.HMatrixImplementationTypedInterfaceObject_swiginit(self, _statistics.new_HMatrixImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _statistics.HMatrixImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.HMatrixImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.HMatrixImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _statistics.HMatrixImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _statistics.HMatrixImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _statistics.delete_HMatrixImplementationTypedInterfaceObject

# Register HMatrixImplementationTypedInterfaceObject in _statistics:
_statistics.HMatrixImplementationTypedInterfaceObject_swigregister(HMatrixImplementationTypedInterfaceObject)

class pairlonglong(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _statistics.pairlonglong_swiginit(self, _statistics.new_pairlonglong(*args))
    first = property(_statistics.pairlonglong_first_get, _statistics.pairlonglong_first_set)
    second = property(_statistics.pairlonglong_second_get, _statistics.pairlonglong_second_set)
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _statistics.delete_pairlonglong

# Register pairlonglong in _statistics:
_statistics.pairlonglong_swigregister(pairlonglong)

class HMatrix(HMatrixImplementationTypedInterfaceObject):
    r"""
    Hierarchical matrices.

    Hierarchical matrices (or HMatrix) are a compressed representation of dense
    matrices.  In many applications, matrix coefficients represent an interaction
    between two degrees of freedom; when these interactions are smooth, it is
    possible to approximate sub-blocks by a local low-rank approximation B =~ UV^T
    where B has dimension (m,n), U (m,k), and V (n,k).
    Of course, this is interesting only if k is much lower than m and n.

    In order to obtain this compressed representation, several different steps must
    be performed:

    1. Clustering: creation of rows and columns cluster trees
       Vertices where interactions are computed are reordered to improve locality.
       A binary space partition algorithm is used to recursively divide vertex set.
       Root cell contains all vertices.  At each recursion step, a cell is divided
       into two new cells until it contains less than a given number of vertices.
       Space partition is performed orthogonally to original axis, by cutting its
       longest dimension.

       * The 'median' clustering algorithm divides a cell into two cells containing
         the same number of degrees of freedom.
       * The 'geometric' clustering algorithm divides a cell into two cells of the
         same geometric size
       * The 'hybrid' clustering algorithm is a mix.  It first performs a 'median'
         bisection; if volumes of these new cells are very different, a 'geometric'
         clustering is performed instead.

    2. Admissibility: creation of an empty HMatrix structure
       The first step created a full binary tree for rows and columns degrees of
       freedom.  We will now create a hierarchical representation of our matrix by
       checking whether some blocks can be replaced by low-rank approximations.
       The whole matrix represents the interactions of all rows degrees of freedom
       against all columns degrees of freedom.  It can not be approximated by a
       low-rank approximation, and thus it is replaced by 4 blocks obtained by
       considering interactions between rows and columns children nodes.  This
       operation is performed recursively.  At each step, we compute axis aligned
       bounding boxes rows_bbox and cols_bbox: if
       min(diameter(rows_bbox), diameter(cols_bbox)) <= eta*distance(rows_bbox, cols_bbox)
       then we consider that interaction between rows and columns degrees of
       freedom can have a local low-rank approximation, and recursion is stopped.
       Otherwise, we recurse until bottom cluster tree is reached.
       The whole matrix is thus represented by a 4-tree where leaves will contain
       either low-rank approximation or full blocks.
       The eta parameter is called the admissibility factor, and it can be modified.

    3. Assembly: coefficients computations
       The hierarchical structure of the matrix has been computed during step 2.
       To compute coefficients, we call the assemble method and provide a callable
       to compute interaction between two nodes.  Full blocks are computed by
       calling this callable for the whole block.  If compression method is 'SVD',
       low-rank approximation is computed by first computing the whole block, then
       finding its singular value decomposition, and rank is truncated so that
       error does not exceed assemblyEpsilon.  This method is precise, but very
       costly.  If compression method is a variant of ACA, only few rows and
       columns are computed.  This is much more efficient, but error may be larger
       than expected on some problems.

    4. Matrix computations
       Once an HMatrix is computed, usual linear algebra operations can be
       performed.  Matrix can be factorized in-place, in order to solve systems.
       Or we can compute its product by a matrix or vector.  But keep in mind that
       rows and columns are reordered internally, and thus results may differ
       sensibly from standard dense representation (for instance when computing a
       Cholesky or LU decomposition).

    See also
    --------
    HMatrixFactory, HMatrixParameters
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.HMatrix_getClassName(self)

    def getNbRows(self):
        r"""
        Accessor to the number of rows.

        Returns
        -------
        nbRows : int
            Number of rows.
        """
        return _statistics.HMatrix_getNbRows(self)

    def getNbColumns(self):
        r"""
        Accessor to the number of columns.

        Returns
        -------
        nbColumns : int
            Number of columns.
        """
        return _statistics.HMatrix_getNbColumns(self)

    def copy(self):
        r"""
        Copy matrix.

        As factorization overwrites matrix contents, this method
        is useful to get a copy of assembled matrix before it is
        factorized.

        Returns
        -------
        matrix : :class:`~openturns.HMatrix`
            Matrix copy.
        """
        return _statistics.HMatrix_copy(self)

    def assemble(self, *args):
        r"""
        Assemble matrix.

        Parameters
        ----------
        f : :class:`~openturns.HMatrixRealAssemblyFunction` or :class:`~openturns.HMatrixTensorRealAssemblyFunction`
            Assembly function.
        symmetry : str
            Symmetry flag, either N or L
        """
        return _statistics.HMatrix_assemble(self, *args)

    def factorize(self, method):
        r"""
        Factorize matrix.

        Parameters
        ----------
        method : str
            Factorization method, either one of: LDLt, LLt or LU
        """
        return _statistics.HMatrix_factorize(self, method)

    def scale(self, alpha):
        r"""
        Scale matrix in-place A=alpha*A.

        Parameters
        ----------
        alpha : float
            Coefficient.
        """
        return _statistics.HMatrix_scale(self, alpha)

    def gemv(self, trans, alpha, x, beta, y):
        r"""
        Multiply vector in-place y=alpha*op(A)*x+beta*y.

        Parameters
        ----------
        trans : str
            Whether to use A or A^t: either N or T.
        alpha : float
            Coefficient
        x : sequence of float
            Vector to multiply.
        beta : float
            Coefficient.
        y : :class:`~openturns.Point`
            Vector multiplied in-place.
        """
        return _statistics.HMatrix_gemv(self, trans, alpha, x, beta, y)

    def gemm(self, transA, transB, alpha, a, b, beta):
        r"""
        Multiply matrix in-place self=alpha*op(A)*op(B)+beta*self.

        Parameters
        ----------
        transA : str
            Whether to use A or A^t: either N or T.
        transB : str
            Whether to use B or B^t: either N or T.
        alpha : float
            Coefficient
        a : :class:`~openturns.HMatrix`
            Multiplied matrix A.
        b : :class:`~openturns.HMatrix`
            Multiplied matrix B.    
        beta : float
            Coefficient.
        """
        return _statistics.HMatrix_gemm(self, transA, transB, alpha, a, b, beta)

    def transpose(self):
        r"""Transpose matrix in-place."""
        return _statistics.HMatrix_transpose(self)

    def norm(self):
        r"""
        Compute norm value.

        Returns
        -------
        norm : float
            Frobenius norm.
        """
        return _statistics.HMatrix_norm(self)

    def getDiagonal(self):
        r"""
        Diagonal values accessor.

        Returns
        -------
        diag : :class:`~openturns.Point`
            Diagonal values.
        """
        return _statistics.HMatrix_getDiagonal(self)

    def addIdentity(self, alpha):
        r"""
        Add alpha*Identity to the Matrix.

        Parameters
        ----------
        alpha : float
            Coefficient.
        """
        return _statistics.HMatrix_addIdentity(self, alpha)

    def solve(self, *args):
        r"""
        Solve linear system op(A)*x=b, after A has been factorized.

        Parameters
        ----------
        b : sequence of float or :class:`~openturns.Matrix`
            Second term of the equation, vector or matrix.
        trans : bool
            Whether to solve the equation with A (False) or A^t (True).
            Defaults to False.

        Returns
        -------
        x : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            Equation solution, vector or matrix.
        """
        return _statistics.HMatrix_solve(self, *args)

    def solveLower(self, *args):
        r"""
        Solve lower linear system op(L)*x=b, after A has been factorized.

        Parameters
        ----------
        b : sequence of float or :class:`~openturns.Matrix`
            Second term of the equation, vector or matrix.
        trans : bool
            Whether to solve the equation with L (False) or L^t (True).
            Defaults to False.

        Returns
        -------
        x : :class:`~openturns.Point` or :class:`~openturns.Matrix`
            Equation solution, vector or matrix.
        """
        return _statistics.HMatrix_solveLower(self, *args)

    def compressionRatio(self):
        r"""
        Compression ratio accessor.

        Returns
        -------
        ratio : 2-tuple of int
            Numbers of elements in the compressed and uncompressed forms.
        """
        return _statistics.HMatrix_compressionRatio(self)

    def fullrkRatio(self):
        r"""
        Block ratio accessor.

        Returns
        -------
        ratio : 2-tuple of int
            Numbers of elements in full blocks and low rank blocks.
        """
        return _statistics.HMatrix_fullrkRatio(self)

    def dump(self, name):
        r"""
        Save matrix to a file.

        Parameters
        ----------
        fileName : str
            File name to save to.
        """
        return _statistics.HMatrix_dump(self, name)

    def __repr__(self):
        return _statistics.HMatrix___repr__(self)

    def __str__(self, *args):
        return _statistics.HMatrix___str__(self, *args)

    def __eq__(self, rhs):
        return _statistics.HMatrix___eq__(self, rhs)

    def __init__(self, *args):
        _statistics.HMatrix_swiginit(self, _statistics.new_HMatrix(*args))

    def assembleReal(self, callable, symmetry):
        r"""
        Assemble matrix.

        Parameters
        ----------
        f : assembly function
            Callable that takes i,j int parameters and returns a float
        symmetry : str
            Symmetry flag, either N or L
        """
        return _statistics.HMatrix_assembleReal(self, callable, symmetry)

    def assembleTensor(self, callable, outputDimension, symmetry):
        r"""
        Assemble matrix by block.

        Parameters
        ----------
        f : assembly function
            Callable that takes i,j int parameters and returns a Matrix
        outputDimension : int
            Block dimension
        symmetry : str
            Symmetry flag, either N or L
        """
        return _statistics.HMatrix_assembleTensor(self, callable, outputDimension, symmetry)
    __swig_destroy__ = _statistics.delete_HMatrix

# Register HMatrix in _statistics:
_statistics.HMatrix_swigregister(HMatrix)

class CovarianceModelImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_statistics.CovarianceModelImplementationPointer_ptr__get, _statistics.CovarianceModelImplementationPointer_ptr__set)

    def __init__(self, *args):
        _statistics.CovarianceModelImplementationPointer_swiginit(self, _statistics.new_CovarianceModelImplementationPointer(*args))
    __swig_destroy__ = _statistics.delete_CovarianceModelImplementationPointer

    def reset(self):
        return _statistics.CovarianceModelImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _statistics.CovarianceModelImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _statistics.CovarianceModelImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _statistics.CovarianceModelImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _statistics.CovarianceModelImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _statistics.CovarianceModelImplementationPointer_get(self)

    def getImplementation(self):
        return _statistics.CovarianceModelImplementationPointer_getImplementation(self)

    def unique(self):
        return _statistics.CovarianceModelImplementationPointer_unique(self)

    def use_count(self):
        return _statistics.CovarianceModelImplementationPointer_use_count(self)

    def swap(self, other):
        return _statistics.CovarianceModelImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.CovarianceModelImplementationPointer_getClassName(self)

    def getInputDimension(self):
        r"""
        Get the input dimension :math:`n` of the covariance function.

        Returns
        -------
        inputDimension : int
            Spatial dimension :math:`n` of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension :math:`d` of the covariance function.

        Returns
        -------
        d : int
            Dimension :math:`d` such that :math:`C : \cD \times \cD \mapsto \cS_d^+(\Rset).`
            This is the dimension of the process :math:`X`.
        """
        return _statistics.CovarianceModelImplementationPointer_getOutputDimension(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer___call__(self, *args)

    def computeStandardRepresentative(self, s, t):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.CovarianceModelImplementationPointer_computeStandardRepresentative(self, s, t)

    def computeAsScalar(self, s, t):
        r"""
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(\vect{s}, \vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})` as
        this quantity does not depend on :math:`\vect{s}`.
        """
        return _statistics.CovarianceModelImplementationPointer_computeAsScalar(self, s, t)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_partialGradient(self, s, t)

    def parameterGradient(self, s, t):
        r"""
        Compute the gradient according to the parameters.

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the function according to the parameters.
        """
        return _statistics.CovarianceModelImplementationPointer_parameterGradient(self, s, t)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.CovarianceModelImplementationPointer_discretize(self, *args)

    def discretizeRow(self, vertices, p):
        r"""**(TODO)**"""
        return _statistics.CovarianceModelImplementationPointer_discretizeRow(self, vertices, p)

    def discretizeAndFactorize(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\in \cM_{nd\times nd}(\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.CovarianceModelImplementationPointer_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        r"""
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\in\cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.CovarianceModelImplementationPointer_discretizeHMatrix(self, *args)

    def discretizeAndFactorizeHMatrix(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        This uses HMatrix.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Cholesk matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretizeAndFactorize* method. This method 
        requires that OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.CovarianceModelImplementationPointer_discretizeAndFactorizeHMatrix(self, *args)

    def isStationary(self):
        r"""
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \forall(\vect{s},\vect{t},\vect{h}) \in \cD \times \cD, & \, \quad
            C(\vect{s}, \vect{s}+\vect{h}) = C(\vect{t}, \vect{t}+\vect{h})


        We note :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})`.
        """
        return _statistics.CovarianceModelImplementationPointer_isStationary(self)

    def isDiagonal(self):
        r"""
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.CovarianceModelImplementationPointer_isDiagonal(self)

    def getAmplitude(self):
        r"""
        Get the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Returns
        -------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance 
            function.
        """
        return _statistics.CovarianceModelImplementationPointer_getAmplitude(self)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_setAmplitude(self, amplitude)

    def getScale(self):
        r"""
        Get the scale parameter :math:`\vect{\theta}` of the covariance function.

        Returns
        -------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` used in the 
            covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_getScale(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _statistics.CovarianceModelImplementationPointer_setScale(self, scale)

    def getOutputCorrelation(self):
        r"""
        Get the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+(\Rset)`.
        """
        return _statistics.CovarianceModelImplementationPointer_getOutputCorrelation(self)

    def setOutputCorrelation(self, correlation):
        r"""
        Set the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+([-1,1])`.
        """
        return _statistics.CovarianceModelImplementationPointer_setOutputCorrelation(self, correlation)

    def setNuggetFactor(self, nuggetFactor):
        r"""
        Set the nugget factor for the variance of the observation error.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used to model the variance of the observation error.
        """
        return _statistics.CovarianceModelImplementationPointer_setNuggetFactor(self, nuggetFactor)

    def getNuggetFactor(self):
        r"""
        Accessor to the nugget factor.

        This parameter allows smooth predictions from noisy data.
        The nugget is added to the diagonal of the assumed training covariance
        (thanks to discretize) and acts as a Tikhonov regularization in the
        problem.

        Returns
        -------
        nuggetFactor : float
            Nugget factor used to model the observation error variance.
        """
        return _statistics.CovarianceModelImplementationPointer_getNuggetFactor(self)

    def setParameter(self, parameter):
        r"""
        Set the parameters of the covariance function.

        Parameters
        ----------
        parameters : :class:`~openturns.Point`
            List of the scale parameter :math:`\vect{\theta} \in \Rset^n` and the
            amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance
            function.

            Must be of dimension :math:`n+d`.
        """
        return _statistics.CovarianceModelImplementationPointer_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Get the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            List of the scale parameter :math:`\vect{\theta} \in \Rset^n` and the
            amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance
            function.

           The other specific parameters are not included.
        """
        return _statistics.CovarianceModelImplementationPointer_getParameter(self)

    def getParameterDescription(self):
        r"""
        Get the description of the covariance function parameters.

        Returns
        -------
        descriptionParam : :class:`~openturns.Description`
            Description of the components of the parameters obtained with the
            *getParameter* method..
        """
        return _statistics.CovarianceModelImplementationPointer_getParameterDescription(self)

    def setActiveParameter(self, active):
        r"""
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.CovarianceModelImplementationPointer_setActiveParameter(self, active)

    def getActiveParameter(self):
        r"""
        Accessor to the active parameter set.

        Returns
        -------
        active : :class:`~openturns.Indices`
            Indices of the active parameters.
        """
        return _statistics.CovarianceModelImplementationPointer_getActiveParameter(self)

    def setFullParameter(self, parameter):
        r"""
        Set the full parameters of the covariance function.

        Parameters
        ----------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

            Must be at least of dimension :math:`n+\frac{d(d+1)}{2}`.
        """
        return _statistics.CovarianceModelImplementationPointer_setFullParameter(self, parameter)

    def getFullParameter(self):
        r"""
        Get the full parameters of the covariance function.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

        """
        return _statistics.CovarianceModelImplementationPointer_getFullParameter(self)

    def getFullParameterDescription(self):
        r"""
        Get the description full parameters of the covariance function.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the full parameter of the covariance function.

        """
        return _statistics.CovarianceModelImplementationPointer_getFullParameterDescription(self)

    def __repr__(self):
        return _statistics.CovarianceModelImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _statistics.CovarianceModelImplementationPointer___str__(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int or sequence of int
            index of marginal of the model.
        """
        return _statistics.CovarianceModelImplementationPointer_getMarginal(self, *args)

    def draw(self, *args):
        r"""
        Draw a specific component of the covariance model with input dimension 1.

        Parameters
        ----------
        rowIndex : int, :math:`0 \leq rowIndex < dimension`
            The row index of the component to draw. Default value is 0.
        columnIndex: int, :math:`0 \leq columnIndex < dimension`
            The column index of the component to draw. Default value is 0.
        tMin : float
            The lower bound of the range over which the model is plotted. Default value is *CovarianceModel-DefaultTMin* in :class:`~openturns.ResourceMap`.
        tMax : float
            The upper bound of the range over which the model is plotted. Default value is *CovarianceModel-DefaultTMax* in :class:`~openturns.ResourceMap`.
        pointNumber : int, :math:`pointNumber \geq 2`
            The discretization of the range :math:`[tMin,tMax]` over which the model is plotted. Default value is *CovarianceModel-DefaultPointNumber* in  class:`~openturns.ResourceMap`.
        asStationary : bool
            Flag to tell if the model has to be plotted as a stationary model, ie as a function of the lag :math:`\tau=t-s` if equals to *True*, or as a non-stationary model, ie as a function of :math:`(s,t)` if equals to *False*. Default value is *True*.
        correlationFlag : bool
            Flag to tell if the model has to be plotted as a correlation function if equals to *True* or as a covariance function if equals to *False*. Default value is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a unique curve if *asStationary=True* and if the model is actually a stationary model, or containing the iso-values of the model if *asStationary=False* or if the model is nonstationary.


        """
        return _statistics.CovarianceModelImplementationPointer_draw(self, *args)

    def __eq__(self, arg2):
        return _statistics.CovarianceModelImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _statistics.CovarianceModelImplementationPointer___ne__(self, other)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _statistics.CovarianceModelImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _statistics.CovarianceModelImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _statistics.CovarianceModelImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _statistics.CovarianceModelImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _statistics.CovarianceModelImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _statistics.CovarianceModelImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _statistics.CovarianceModelImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.CovarianceModelImplementationPointer_setName(self, name)

# Register CovarianceModelImplementationPointer in _statistics:
_statistics.CovarianceModelImplementationPointer_swigregister(CovarianceModelImplementationPointer)

class SpectralModelImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_statistics.SpectralModelImplementationPointer_ptr__get, _statistics.SpectralModelImplementationPointer_ptr__set)

    def __init__(self, *args):
        _statistics.SpectralModelImplementationPointer_swiginit(self, _statistics.new_SpectralModelImplementationPointer(*args))
    __swig_destroy__ = _statistics.delete_SpectralModelImplementationPointer

    def reset(self):
        return _statistics.SpectralModelImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _statistics.SpectralModelImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _statistics.SpectralModelImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _statistics.SpectralModelImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _statistics.SpectralModelImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _statistics.SpectralModelImplementationPointer_get(self)

    def getImplementation(self):
        return _statistics.SpectralModelImplementationPointer_getImplementation(self)

    def unique(self):
        return _statistics.SpectralModelImplementationPointer_unique(self)

    def use_count(self):
        return _statistics.SpectralModelImplementationPointer_use_count(self)

    def swap(self, other):
        return _statistics.SpectralModelImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.SpectralModelImplementationPointer_getClassName(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the *SpectralModel*.

        Returns
        -------
        dimension : int
            Dimension of the *SpectralModel*.
        """
        return _statistics.SpectralModelImplementationPointer_getOutputDimension(self)

    def getInputDimension(self):
        r"""
        Get the input dimension of the spectral density function.

        Returns
        -------
        inputDimension : int
            SpatialDimension of the *SpectralModel*.
        """
        return _statistics.SpectralModelImplementationPointer_getInputDimension(self)

    def __call__(self, frequency):
        r"""
        Evaluate the spectral density function for a specific frequency.

        Parameters
        ----------
        f : float
            Frequency value.

        Returns
        -------
        spd : HermitianMatrixs
            The evaluation of spectral density function at frequency f.
        """
        return _statistics.SpectralModelImplementationPointer___call__(self, frequency)

    def computeStandardRepresentative(self, frequency):
        r"""
        Compute the standard representant of the spectral density function.

        Parameters
        ----------
        tau : float
            Frequency value.

        Returns
        -------
        rho : Complex
             Standard representant factor of the spectral density function.

        Notes
        -----
        According to definitions in :class:`~openturns.CovarianceModel`, as the spectral density function is the Fourier transform of the stationary covariance function and using the expression of the last one, the spectral density function writes as a matrix-complex product where the matrix is the constant spatial covariance structure and the complex represents the standard representative:

        Thus,

        .. math::

          \forall \vect{f} \in \Rset^n, \cS(\vect{f}) = \prod_{k=1}^{n} \vect{\theta}_k \mat{\Sigma} \rho(\vect{f} \odot \vect{\theta})

        where :math:`\mat{\Sigma}` is a covariance matrix that explains the covariance structure and
        :math:`(\vect{f} \odot \vect{\theta})_k = \vect{f}_k \vect{\theta}_k`
        """
        return _statistics.SpectralModelImplementationPointer_computeStandardRepresentative(self, frequency)

    def getAmplitude(self):
        r"""
        Get the amplitude parameter of the spectral density function.

        Returns
        -------
        amplitude : :class:`~openturns.Point`
            The used amplitude parameter.
        """
        return _statistics.SpectralModelImplementationPointer_getAmplitude(self)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter of the spectral density function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter to be used in the spectral density function.
        """
        return _statistics.SpectralModelImplementationPointer_setAmplitude(self, amplitude)

    def getScale(self):
        r"""
        Get the scale parameter of the spectral density function.

        Returns
        -------
        scale : :class:`~openturns.Point`
            The used scale parameter.
        """
        return _statistics.SpectralModelImplementationPointer_getScale(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter of the spectral density function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter to be used in the spectral density function.
            It should be of size dimension.
        """
        return _statistics.SpectralModelImplementationPointer_setScale(self, scale)

    def getOutputCorrelation(self):
        r"""
        Get the spatial correlation matrix of the spectral density function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \mathcal{M}_{dimension \times dimension}([-1, 1])`.
        """
        return _statistics.SpectralModelImplementationPointer_getOutputCorrelation(self)

    def __repr__(self):
        return _statistics.SpectralModelImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _statistics.SpectralModelImplementationPointer___str__(self, *args)

    def draw(self, *args):
        r"""
        Draw a specific component of the spectral density function.

        Parameters
        ----------
        rowIndex : int, :math:`0 \leq rowIndex < dimension`
            The row index of the component to draw. Default value is 0.
        columnIndex: int, :math:`0 \leq columnIndex < dimension`
            The column index of the component to draw. Default value is 0.
        minimumFrequency : float
            The lower bound of the frequency range over which the model is plotted. Default value is *SpectralModel-DefaultMinimumFrequency* in :class:`~openturns.ResourceMap`.
        maximumFrequency : float
            The upper bound of the frequency range over which the model is plotted. Default value is *SpectralModel-DefaultMaximumFrequency* in :class:`~openturns.ResourceMap`.
        frequencyNumber : int, :math:`pointNumber \geq 2`
            The discretization of the frequency range :math:`[minimumFrequency, maximumFrequency]` over which the model is plotted. Default value is *SpectralModel-DefaultFrequencyNumber* in  class:`~openturns.ResourceMap`.
        module : bool
            Flag to tell if module has to be drawn (*True*) or if it is
            the argument to be drawn (*False*).
            Default value is *True*.

        Returns
        -------
        graph : Graph
             Graphic of the specified component

        """
        return _statistics.SpectralModelImplementationPointer_draw(self, *args)

    def __eq__(self, arg2):
        return _statistics.SpectralModelImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _statistics.SpectralModelImplementationPointer___ne__(self, other)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _statistics.SpectralModelImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _statistics.SpectralModelImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _statistics.SpectralModelImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _statistics.SpectralModelImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _statistics.SpectralModelImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _statistics.SpectralModelImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _statistics.SpectralModelImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.SpectralModelImplementationPointer_setName(self, name)

# Register SpectralModelImplementationPointer in _statistics:
_statistics.SpectralModelImplementationPointer_swigregister(SpectralModelImplementationPointer)

class StationaryCovarianceModelPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_statistics.StationaryCovarianceModelPointer_ptr__get, _statistics.StationaryCovarianceModelPointer_ptr__set)

    def __init__(self, *args):
        _statistics.StationaryCovarianceModelPointer_swiginit(self, _statistics.new_StationaryCovarianceModelPointer(*args))
    __swig_destroy__ = _statistics.delete_StationaryCovarianceModelPointer

    def reset(self):
        return _statistics.StationaryCovarianceModelPointer_reset(self)

    def __ref__(self, *args):
        return _statistics.StationaryCovarianceModelPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _statistics.StationaryCovarianceModelPointer___deref__(self, *args)

    def isNull(self):
        return _statistics.StationaryCovarianceModelPointer_isNull(self)

    def __nonzero__(self):
        return _statistics.StationaryCovarianceModelPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _statistics.StationaryCovarianceModelPointer_get(self)

    def getImplementation(self):
        return _statistics.StationaryCovarianceModelPointer_getImplementation(self)

    def unique(self):
        return _statistics.StationaryCovarianceModelPointer_unique(self)

    def use_count(self):
        return _statistics.StationaryCovarianceModelPointer_use_count(self)

    def swap(self, other):
        return _statistics.StationaryCovarianceModelPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _statistics.StationaryCovarianceModelPointer_getClassName(self)

    def __call__(self, *args):
        r"""
        Evaluate the covariance function.

        Available usages:
            __call__(s, t)

            __call__(tau)

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`.

        Returns
        -------
        covariance : CovarianceMatrix
            The evaluation of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer___call__(self, *args)

    def computeAsScalar(self, *args):
        r"""
        Compute the covariance function for scalar model.

        Available usages:
            computeAsScalar(s, t)

            computeAsScalar(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        covariance : float
            Covariance.

        Notes
        -----
        The method makes sense only if the dimension of the process is :math:`d=1`.
        It evaluates :math:`C(\vect{s}, \vect{t})`.

        In the second usage, the covariance model must be stationary. Then we note
        :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})` as
        this quantity does not depend on :math:`\vect{s}`.
        """
        return _statistics.StationaryCovarianceModelPointer_computeAsScalar(self, *args)

    def computeStandardRepresentative(self, *args):
        r"""
        Compute the standard representative function of the covariance model.

        Available usages:
            computeStandardRepresentative(s, t)

            computeStandardRepresentative(tau)

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`
        tau : float or sequence of float
            Multivariate index :math:`\vect{\tau} \in \cD`

        Returns
        -------
        rho : float
            Correlation model :math:`\rho`


        Notes
        -----
        It evaluates the scalar function 
        :math:`\rho\left(\dfrac{\vect{s}}{\theta}, \dfrac{\vect{t}}{\theta}\right)` or 
        :math:`\rho\left(\dfrac{\vect{\tau}}{\theta}\right)` if the model is stationary.
        """
        return _statistics.StationaryCovarianceModelPointer_computeStandardRepresentative(self, *args)

    def discretize(self, *args):
        r"""
        Discretize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        covarianceMatrix : :class:`~openturns.CovarianceMatrix`
            Covariance matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` and returns the
        covariance matrix:

        .. math ::

            \mat{C}_{1,\dots,k} = \left(
                \begin{array}{cccc}
                C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \dots & 
                C(\vect{t}_1, \vect{t}_{k}) \\
                \dots & C(\vect{t}_2, \vect{t}_2)  & \dots & 
                C(\vect{t}_2, \vect{t}_{k}) \\
                \dots & \dots & \dots & \dots \\
                \dots & \dots & \dots & C(\vect{t}_{k}, \vect{t}_{k})
                \end{array} \right)
        """
        return _statistics.StationaryCovarianceModelPointer_discretize(self, *args)

    def isStationary(self):
        r"""
        Test whether the model is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the model is stationary.

        Notes
        -----
        The covariance function :math:`C` is stationary when it is invariant by
        translation:

        .. math::

            \forall(\vect{s},\vect{t},\vect{h}) \in \cD \times \cD, & \, \quad
            C(\vect{s}, \vect{s}+\vect{h}) = C(\vect{t}, \vect{t}+\vect{h})


        We note :math:`C^{stat}(\vect{\tau})` for :math:`C(\vect{s}, \vect{s}+\vect{\tau})`.
        """
        return _statistics.StationaryCovarianceModelPointer_isStationary(self)

    def __repr__(self):
        return _statistics.StationaryCovarianceModelPointer___repr__(self)

    def __str__(self, *args):
        return _statistics.StationaryCovarianceModelPointer___str__(self, *args)

    def getInputDimension(self):
        r"""
        Get the input dimension :math:`n` of the covariance function.

        Returns
        -------
        inputDimension : int
            Spatial dimension :math:`n` of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension :math:`d` of the covariance function.

        Returns
        -------
        d : int
            Dimension :math:`d` such that :math:`C : \cD \times \cD \mapsto \cS_d^+(\Rset).`
            This is the dimension of the process :math:`X`.
        """
        return _statistics.StationaryCovarianceModelPointer_getOutputDimension(self)

    def partialGradient(self, s, t):
        r"""
        Compute the gradient of the covariance function.

        Parameters
        ----------
        s, t : floats or sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_partialGradient(self, s, t)

    def parameterGradient(self, s, t):
        r"""
        Compute the gradient according to the parameters.

        Parameters
        ----------
        s, t : sequences of float
            Multivariate index :math:`(\vect{s}, \vect{t}) \in \cD \times \cD`.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of the function according to the parameters.
        """
        return _statistics.StationaryCovarianceModelPointer_parameterGradient(self, s, t)

    def discretizeRow(self, vertices, p):
        r"""**(TODO)**"""
        return _statistics.StationaryCovarianceModelPointer_discretizeRow(self, vertices, p)

    def discretizeAndFactorize(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.

        Returns
        -------
        CholeskyMatrix : :class:`~openturns.TriangularMatrix`
            Cholesky factor of the covariance matrix :math:`\in \cM_{nd\times nd}(\Rset)`
            (if the process is of dimension :math:`d`).

        Notes
        -----
        This method makes a discretization of the model on *meshOrGrid* composed of
        the vertices :math:`(\vect{t}_1, \dots, \vect{t}_{N-1})` thanks to the
        `discretize` method and returns its Cholesky factor.
        """
        return _statistics.StationaryCovarianceModelPointer_discretizeAndFactorize(self, *args)

    def discretizeHMatrix(self, *args):
        r"""
        Discretize the covariance function on a given mesh using HMatrix result.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Covariance matrix :math:`\in\cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretize* method. This method requires that 
        OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.StationaryCovarianceModelPointer_discretizeHMatrix(self, *args)

    def discretizeAndFactorizeHMatrix(self, *args):
        r"""
        Discretize and factorize the covariance function on a given mesh.

        This uses HMatrix.

        Parameters
        ----------
        meshOrGrid : :class:`~openturns.Mesh` or :class:`~openturns.RegularGrid`
            Mesh or time grid of size :math:`N` associated with the process.
        hmatParam : :class:`~openturns.HMatrixParameters`
            Parameter values for the HMatrix

        Returns
        -------
        HMatrix : :class:`~openturns.HMatrix`
            Cholesk matrix :math:`\in \cS_{nd}^+(\Rset)` (if the process is of
            dimension :math:`d`), stored in hierarchical format (H-Matrix)

        Notes
        -----
        This method si similar to the *discretizeAndFactorize* method. This method 
        requires that OpenTURNS has been compiled with the hmat library.
        The method is helpfull for very large parameters (Mesh, grid, Sample) 
        as its compress data.

        """
        return _statistics.StationaryCovarianceModelPointer_discretizeAndFactorizeHMatrix(self, *args)

    def isDiagonal(self):
        r"""
        Test whether the model is diagonal or not.

        Returns
        -------
        isDiagonal : bool
            *True* if the model is diagonal.
        """
        return _statistics.StationaryCovarianceModelPointer_isDiagonal(self)

    def getAmplitude(self):
        r"""
        Get the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Returns
        -------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance 
            function.
        """
        return _statistics.StationaryCovarianceModelPointer_getAmplitude(self)

    def setAmplitude(self, amplitude):
        r"""
        Set the amplitude parameter :math:`\vect{\sigma}` of the covariance function.

        Parameters
        ----------
        amplitude : :class:`~openturns.Point`
            The amplitude parameter :math:`\vect{\sigma} \in \Rset^d` to be used in the
            covariance function. 
            Its size must be equal to the dimension of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_setAmplitude(self, amplitude)

    def getScale(self):
        r"""
        Get the scale parameter :math:`\vect{\theta}` of the covariance function.

        Returns
        -------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` used in the 
            covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_getScale(self)

    def setScale(self, scale):
        r"""
        Set the scale parameter :math:`\vect{\theta}` of the covariance function.

        Parameters
        ----------
        scale : :class:`~openturns.Point`
            The scale parameter :math:`\vect{\theta} \in \Rset^n` to be used in the
            covariance function.
            Its size must be equal to the input dimension of the covariance function.
        """
        return _statistics.StationaryCovarianceModelPointer_setScale(self, scale)

    def getOutputCorrelation(self):
        r"""
        Get the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Returns
        -------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+(\Rset)`.
        """
        return _statistics.StationaryCovarianceModelPointer_getOutputCorrelation(self)

    def setOutputCorrelation(self, correlation):
        r"""
        Set the spatial correlation matrix :math:`\mat{R}` of the covariance function.

        Parameters
        ----------
        spatialCorrelation : :class:`~openturns.CorrelationMatrix`
            Correlation matrix :math:`\mat{R} \in \cS_d^+([-1,1])`.
        """
        return _statistics.StationaryCovarianceModelPointer_setOutputCorrelation(self, correlation)

    def setNuggetFactor(self, nuggetFactor):
        r"""
        Set the nugget factor for the variance of the observation error.

        Acts on the discretized covariance matrix.

        Parameters
        ----------
        nuggetFactor : float
            nugget factor to be used to model the variance of the observation error.
        """
        return _statistics.StationaryCovarianceModelPointer_setNuggetFactor(self, nuggetFactor)

    def getNuggetFactor(self):
        r"""
        Accessor to the nugget factor.

        This parameter allows smooth predictions from noisy data.
        The nugget is added to the diagonal of the assumed training covariance
        (thanks to discretize) and acts as a Tikhonov regularization in the
        problem.

        Returns
        -------
        nuggetFactor : float
            Nugget factor used to model the observation error variance.
        """
        return _statistics.StationaryCovarianceModelPointer_getNuggetFactor(self)

    def setParameter(self, parameter):
        r"""
        Set the parameters of the covariance function.

        Parameters
        ----------
        parameters : :class:`~openturns.Point`
            List of the scale parameter :math:`\vect{\theta} \in \Rset^n` and the
            amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance
            function.

            Must be of dimension :math:`n+d`.
        """
        return _statistics.StationaryCovarianceModelPointer_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Get the parameters of the covariance function.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            List of the scale parameter :math:`\vect{\theta} \in \Rset^n` and the
            amplitude parameter :math:`\vect{\sigma} \in \Rset^d` of the covariance
            function.

           The other specific parameters are not included.
        """
        return _statistics.StationaryCovarianceModelPointer_getParameter(self)

    def getParameterDescription(self):
        r"""
        Get the description of the covariance function parameters.

        Returns
        -------
        descriptionParam : :class:`~openturns.Description`
            Description of the components of the parameters obtained with the
            *getParameter* method..
        """
        return _statistics.StationaryCovarianceModelPointer_getParameterDescription(self)

    def setActiveParameter(self, active):
        r"""
        Accessor to the active parameter set.

        Parameters
        ----------
        active : sequence of int
            Indices of the active parameters.
        """
        return _statistics.StationaryCovarianceModelPointer_setActiveParameter(self, active)

    def getActiveParameter(self):
        r"""
        Accessor to the active parameter set.

        Returns
        -------
        active : :class:`~openturns.Indices`
            Indices of the active parameters.
        """
        return _statistics.StationaryCovarianceModelPointer_getActiveParameter(self)

    def setFullParameter(self, parameter):
        r"""
        Set the full parameters of the covariance function.

        Parameters
        ----------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

            Must be at least of dimension :math:`n+\frac{d(d+1)}{2}`.
        """
        return _statistics.StationaryCovarianceModelPointer_setFullParameter(self, parameter)

    def getFullParameter(self):
        r"""
        Get the full parameters of the covariance function.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            List the full parameter of the covariance function i.e.
            scale parameter :math:`\vect{\theta} \in \Rset^n`, the
            the amplitude parameter :math:`\vect{\sigma} \in \Rset^d`,
            the Spatial correlation parameter  :math:`\mat{R} \in \cS_d^+([-1,1])`;
            and potential other parameter depending on the model;

        """
        return _statistics.StationaryCovarianceModelPointer_getFullParameter(self)

    def getFullParameterDescription(self):
        r"""
        Get the description full parameters of the covariance function.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the full parameter of the covariance function.

        """
        return _statistics.StationaryCovarianceModelPointer_getFullParameterDescription(self)

    def getMarginal(self, *args):
        r"""
        Get the ith marginal of the model.

        Returns
        -------
        marginal : int or sequence of int
            index of marginal of the model.
        """
        return _statistics.StationaryCovarianceModelPointer_getMarginal(self, *args)

    def draw(self, *args):
        r"""
        Draw a specific component of the covariance model with input dimension 1.

        Parameters
        ----------
        rowIndex : int, :math:`0 \leq rowIndex < dimension`
            The row index of the component to draw. Default value is 0.
        columnIndex: int, :math:`0 \leq columnIndex < dimension`
            The column index of the component to draw. Default value is 0.
        tMin : float
            The lower bound of the range over which the model is plotted. Default value is *CovarianceModel-DefaultTMin* in :class:`~openturns.ResourceMap`.
        tMax : float
            The upper bound of the range over which the model is plotted. Default value is *CovarianceModel-DefaultTMax* in :class:`~openturns.ResourceMap`.
        pointNumber : int, :math:`pointNumber \geq 2`
            The discretization of the range :math:`[tMin,tMax]` over which the model is plotted. Default value is *CovarianceModel-DefaultPointNumber* in  class:`~openturns.ResourceMap`.
        asStationary : bool
            Flag to tell if the model has to be plotted as a stationary model, ie as a function of the lag :math:`\tau=t-s` if equals to *True*, or as a non-stationary model, ie as a function of :math:`(s,t)` if equals to *False*. Default value is *True*.
        correlationFlag : bool
            Flag to tell if the model has to be plotted as a correlation function if equals to *True* or as a covariance function if equals to *False*. Default value is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph containing a unique curve if *asStationary=True* and if the model is actually a stationary model, or containing the iso-values of the model if *asStationary=False* or if the model is nonstationary.


        """
        return _statistics.StationaryCovarianceModelPointer_draw(self, *args)

    def __eq__(self, arg2):
        return _statistics.StationaryCovarianceModelPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _statistics.StationaryCovarianceModelPointer___ne__(self, other)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _statistics.StationaryCovarianceModelPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _statistics.StationaryCovarianceModelPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _statistics.StationaryCovarianceModelPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _statistics.StationaryCovarianceModelPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _statistics.StationaryCovarianceModelPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _statistics.StationaryCovarianceModelPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _statistics.StationaryCovarianceModelPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _statistics.StationaryCovarianceModelPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _statistics.StationaryCovarianceModelPointer_setName(self, name)

# Register StationaryCovarianceModelPointer in _statistics:
_statistics.StationaryCovarianceModelPointer_swigregister(StationaryCovarianceModelPointer)



