# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""EventSimulation uncertainty propagation algorithms."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _simulation
else:
    import _simulation

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _simulation.delete_SwigPyIterator

    def value(self):
        return _simulation.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _simulation.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _simulation.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _simulation.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _simulation.SwigPyIterator_equal(self, x)

    def copy(self):
        return _simulation.SwigPyIterator_copy(self)

    def next(self):
        return _simulation.SwigPyIterator_next(self)

    def __next__(self):
        return _simulation.SwigPyIterator___next__(self)

    def previous(self):
        return _simulation.SwigPyIterator_previous(self)

    def advance(self, n):
        return _simulation.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _simulation.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _simulation.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _simulation.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _simulation.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _simulation.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _simulation.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _simulation:
_simulation.SwigPyIterator_swigregister(SwigPyIterator)


class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.transformation
import openturns.metamodel
import openturns.weightedexperiment
import openturns.orthogonalbasis
import openturns.randomvector
import openturns.analytical
class ANCOVA(object):
    r"""
    ANalysis of COVAriance method (ANCOVA).

    Refer to :ref:`sensitivity_ancova`.

    Available constructor:
        ANCOVA(*functionalChaosResult, correlatedInput*)

    Parameters
    ----------
    functionalChaosResult : :class:`~openturns.FunctionalChaosResult`
        Functional chaos result approximating the model response with
        uncorrelated inputs.
    correlatedInput : 2-d sequence of float
        Correlated inputs used to compute the real values of the output.
        Its dimension must be equal to the number of inputs of the model.

    Notes
    -----
    ANCOVA, a variance-based method described in [caniou2012]_, is a generalization
    of the ANOVA (ANalysis Of VAriance) decomposition for models with correlated
    input parameters.

    Let us consider a model :math:`Y = h(\vect{X})` without making any hypothesis
    on the dependence structure of :math:`\vect{X} = \{X^1, \ldots, X^{n_X} \}`, a
    n_X-dimensional random vector. The covariance decomposition requires a functional
    decomposition of the model. Thus the model response :math:`Y` is expanded as a
    sum of functions of increasing dimension as follows:

    .. math::
        :label: model

        h(\vect{X}) = h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u)

    :math:`h_0` is the mean of :math:`Y`. Each function :math:`h_u` represents,
    for any non empty set :math:`u\subseteq\{1, \dots, n_X\}`, the combined
    contribution of the variables :math:`X_u` to :math:`Y`.

    Using the properties of the covariance, the variance of :math:`Y` can be
    decomposed into a variance part and a covariance part as follows:

    .. math::

        Var[Y]&= Cov\left[h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u), h_0 + \sum_{u\subseteq\{1,\dots,n_X\}} h_u(X_u)\right] \\
              &= \sum_{u\subseteq\{1,\dots,n_X\}} \left[Var[h_u(X_u)] + Cov[h_u(X_u), \sum_{v\subseteq\{1,\dots,n_X\}, v\cap u=\varnothing} h_v(X_v)]\right]

    This variance formula enables to define each total part of variance of
    :math:`Y` due to :math:`X_u`, :math:`S_u`, as the sum of a *physical*
    (or *uncorrelated*) part and a *correlated* part such as:

    .. math::

        S_u = \frac{Cov[Y, h_u(X_u)]} {Var[Y]} = S_u^U + S_u^C

    where :math:`S_u^U` is the uncorrelated part of variance of Y due to :math:`X_u`:

    .. math::

        S_u^U = \frac{Var[h_u(X_u)]} {Var[Y]}

    and :math:`S_u^C` is the contribution of the correlation of :math:`X_u` with the
    other parameters:

    .. math::

        S_u^C = \frac{Cov\left[h_u(X_u), \displaystyle \sum_{v\subseteq\{1,\dots,n_X\}, v\cap u=\varnothing} h_v(X_v)\right]}
                     {Var[Y]}

    As the computational cost of the indices with the numerical model :math:`h`
    can be very high, [caniou2012]_ suggests to approximate the model response with
    a polynomial chaos expansion:

    .. math::

        Y \simeq \hat{h} = \sum_{j=0}^{P-1} \alpha_j \Psi_j(x)

    However, for the sake of computational simplicity, the latter is constructed
    considering *independent* components :math:`\{X^1,\dots,X^{n_X}\}`. Thus the
    chaos basis is not orthogonal with respect to the correlated inputs under
    consideration, and it is only used as a metamodel to generate approximated
    evaluations of the model response and its summands :eq:`model`.

    The next step consists in identifying the component functions. For instance, for
    :math:`u = \{1\}`:

    .. math::

        h_1(X_1) = \sum_{\alpha | \alpha_1 \neq 0, \alpha_{i \neq 1} = 0} y_{\alpha} \Psi_{\alpha}(\vect{X})

    where :math:`\alpha` is a set of degrees associated to the :math:`n_X` univariate
    polynomial :math:`\psi_i^{\alpha_i}(X_i)`.

    Then the model response :math:`Y` is evaluated using a sample
    :math:`X=\{x_k, k=1,\dots,N\}` of the correlated joint distribution. Finally,
    the several indices are computed using the model response and its component
    functions that have been identified on the polynomial chaos.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Model and distribution definition
    >>> model = ot.SymbolicFunction(['X1','X2'], ['4.*X1 + 5.*X2'])
    >>> distribution = ot.ComposedDistribution([ot.Normal()] * 2)
    >>> S = ot.CorrelationMatrix(2)
    >>> S[1, 0] = 0.3
    >>> R = ot.NormalCopula().GetCorrelationFromSpearmanCorrelation(S)
    >>> CorrelatedInputDistribution = ot.ComposedDistribution([ot.Normal()] * 2, ot.NormalCopula(R))
    >>> sample = CorrelatedInputDistribution.getSample(200)
    >>> # Functional chaos computation
    >>> productBasis = ot.OrthogonalProductPolynomialFactory([ot.HermiteFactory()] * 2, ot.LinearEnumerateFunction(2))
    >>> adaptiveStrategy = ot.FixedStrategy(productBasis, 15)
    >>> projectionStrategy = ot.LeastSquaresStrategy(ot.MonteCarloExperiment(100))
    >>> algo = ot.FunctionalChaosAlgorithm(model, distribution, adaptiveStrategy, projectionStrategy)
    >>> algo.run()
    >>> ancovaResult = ot.ANCOVA(algo.getResult(), sample)
    >>> indices = ancovaResult.getIndices()
    >>> print(indices)
    [0.408398,0.591602]
    >>> uncorrelatedIndices = ancovaResult.getUncorrelatedIndices()
    >>> print(uncorrelatedIndices)
    [0.284905,0.468108]
    >>> # Get indices measuring the correlated effects
    >>> print(indices - uncorrelatedIndices)
    [0.123494,0.123494]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getUncorrelatedIndices(self, marginalIndex=0):
        r"""
        Accessor to the ANCOVA indices measuring uncorrelated effects.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the ANCOVA indices measuring uncorrelated effects of the inputs.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _simulation.ANCOVA_getUncorrelatedIndices(self, marginalIndex)

    def getIndices(self, marginalIndex=0):
        r"""
        Accessor to the ANCOVA indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the ANCOVA indices measuring the contribution of the
            input variables to the variance of the model. These indices are made up
            of a *physical* part and a *correlated* part. The first one is obtained
            thanks to :meth:`getUncorrelatedIndices`.
            The effects of the correlation are represented by the indices resulting
            from the subtraction of the :meth:`getIndices` and
            :meth:`getUncorrelatedIndices` lists.
        """
        return _simulation.ANCOVA_getIndices(self, marginalIndex)

    def __init__(self, *args):
        _simulation.ANCOVA_swiginit(self, _simulation.new_ANCOVA(*args))
    __swig_destroy__ = _simulation.delete_ANCOVA

# Register ANCOVA in _simulation:
_simulation.ANCOVA_swigregister(ANCOVA)

class FAST(object):
    r"""
    Fourier Amplitude Sensitivity Testing (FAST).

    Refer to :ref:`sensitivity_fast`.

    Available constructor:
        FAST(*model, distribution, N, Nr=1, M=4*)

    Parameters
    ----------
    model : :class:`~openturns.Function`
        Definition of the model to analyse.
    distribution : :class:`~openturns.Distribution`
        Contains the distributions of each model's input.
        Its dimension must be equal to the number of inputs.
    N : int, :math:`N > Nr`
        Size of the sample from which the Fourier series are calculated.
        It represents the length of the discretization of the s-space.
    Nr : int, :math:`Nr \geq 1`
        Number of resamplings. The extended FAST method involves a part of
        randomness in the computation of the indices. So it can be asked to
        realize the procedure *Nr* times and then to calculate the
        arithmetic means of the results over the *Nr* estimates.
    M : int, :math:`0 < M < N`
        Interference factor usually equal to 4 or higher.
        It corresponds to the truncation level of the Fourier series, i.e. the
        number of harmonics that are retained in the decomposition.

    Notes
    -----
    FAST is a sensitivity analysis method which is based upon the ANOVA
    decomposition of the variance of the model response :math:`y = f(\vect{X})`,
    the latter being represented by its Fourier expansion.
    :math:`\vect{X}=\{X^1,\dots,X^{n_X}\}` is an input random vector of :math:`n_X`
    independent components.

    OpenTURNS implements the extended FAST method consisting in computing
    alternately the first order and the total-effect indices of each input.
    This approach, widely described in the paper by [saltelli1999]_, relies upon a
    Fourier decomposition of the model response. Its key idea is to recast this
    representation as a function of a *scalar* parameter :math:`s`, by defining
    parametric curves :math:`s \mapsto x_i(s), i=1, \dots, n_X` exploring the
    support of the input random vector :math:`\vect{X}`.

    Then the Fourier expansion of the model response is:

    .. math::

        f(s) = \sum_{k \in \Zset^N} A_k cos(ks) + B_k sin(ks)

    where :math:`A_k` and :math:`B_k` are Fourier coefficients whose estimates are:

    .. math::

        \hat{A}_k &= \frac{1}{N} \sum_{j=1}^N f(x_j^1,\dots,x_j^{N_X}) cos\left(\frac{2k\pi (j-1)}{N} \right) \quad , \quad -\frac{N}{2} \leq k \leq \frac{N}{2} \\
        \hat{B}_k &= \frac{1}{N} \sum_{j=1}^N f(x_j^1,\dots,x_j^{N_X}) sin\left(\frac{2k\pi (j-1)}{N} \right) \quad , \quad -\frac{N}{2} \leq k \leq \frac{N}{2}


    The first order indices are estimated by:

    .. math::

        \hat{S}_i = \frac{\hat{D}_i}{\hat{D}}
                  = \frac{\sum_{p=1}^M(\hat{A}_{p\omega_i}^2 + \hat{B}_{p\omega_i}^2)^2}
                          {\sum_{n=1}^{(N-1)/2}(\hat{A}_n^2 + \hat{B}_n^2)^2}

    and the total order indices by:

    .. math::

        \hat{T}_i = 1 - \frac{\hat{D}_{-i}}{\hat{D}}
                  = 1 - \frac{\sum_{k=1}^{\omega_i/2}(\hat{A}_k^2 + \hat{B}_k^2)^2}
                              {\sum_{n=1}^{(N-1)/2}(\hat{A}_n^2 + \hat{B}_n^2)^2}

    where :math:`\hat{D}` is the total variance, :math:`\hat{D}_i` the portion
    of :math:`D` arising from the uncertainty of the :math:`i^{th}` input and
    :math:`\hat{D}_{-i}` is the part of the variance due to all the inputs
    except the :math:`i^{th}` input.

    :math:`N` is the size of the sample using to compute the Fourier series and
    :math:`M` is the interference factor. *Saltelli et al.* (1999) recommanded to
    set :math:`M` to a value in the range :math:`[4, 6]`.
    :math:`\{\omega_i\}, \forall i=1, \dots, n_X` is a set of integer frequencies
    assigned to each input :math:`X^i`. The frequency associated with the input
    for which the sensitivity indices are computed, is set to the maximum admissible
    frequency satisfying the Nyquist criterion (which ensures to avoid aliasing effects):

    .. math::

        \omega_i = \frac{N - 1}{2M}

    In the paper by Saltelli et al. (1999), for high sample size, it is suggested
    that :math:`16 \leq \omega_i/N_r \leq 64`.


    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> sensitivityAnalysis = ot.FAST(model, distribution, 101)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.311097,0.441786,0.000396837]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Accessor to the first order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the first order indices of all the inputs.
        """
        return _simulation.FAST_getFirstOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Accessor to the total order indices.

        Parameters
        ----------
        marginalIndex : int, :math:`0 \leq i < n`, optional
            Index of the model's  marginal used to estimate the indices.
            By default, marginalIndex is equal to 0.

        Returns
        -------
        indices : :class:`~openturns.Point`
            List of the total-effect order indices of all the inputs.
        """
        return _simulation.FAST_getTotalOrderIndices(self, marginalIndex)

    def getFFTAlgorithm(self):
        r"""
        Accessor to the FFT algorithm implementation.

        Returns
        -------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _simulation.FAST_getFFTAlgorithm(self)

    def setFFTAlgorithm(self, fft):
        r"""
        Accessor to the FFT algorithm implementation.

        Parameters
        ----------
        fft : a :class:`~openturns.FFT`
            A FFT algorithm.
        """
        return _simulation.FAST_setFFTAlgorithm(self, fft)

    def setBlockSize(self, blockSize):
        r"""
        Set the block size.

        Parameters
        ----------
        k : positive int
            Size of each block the sample is splitted into, this allows to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to :math:`1`.
        """
        return _simulation.FAST_setBlockSize(self, blockSize)

    def getBlockSize(self):
        r"""
        Get the block size.

        Returns
        -------
        k : positive int
            Size of each block the sample is splitted into, this allows to save space
            while allowing multithreading, when available we recommend to use
            the number of available CPUs, set by default to 1.
        """
        return _simulation.FAST_getBlockSize(self)

    def __init__(self, *args):
        _simulation.FAST_swiginit(self, _simulation.new_FAST(*args))
    __swig_destroy__ = _simulation.delete_FAST

# Register FAST in _simulation:
_simulation.FAST_swigregister(FAST)

class SobolIndicesAlgorithmImplementation(openturns.common.PersistentObject):
    r"""

    Sensitivity analysis.

    Notes
    -----
    This method is concerned with analyzing the influence the random vector
    :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty (see also [sobol1993]_).

    Here we attempt to evaluate the part of variance of :math:`Y^k` due to the different components :math:`X^i`.

    We denote G the physical model such as :math:`\vect{Y}=G(\vect{X})`. Let us consider first the case where :math:`\vect{Y}` is of dimension 1.

    The objective here is to develop the variability of the random variable :math:`\vect{Y}` as function of :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)`. Using the Hoeffding decomposition, we got:

    .. math::

       \Var{\vect{Y}} = \sum_{i=1}^{n_X} V_i + \sum_{i<j} V_{i,j} + \sum_{i<k<j} V_{i,j,k} + \cdots + V_{1,2,..,n_X}

    where :

    :math:`V_i = \Var{\Expect{ Y \vert X_i}}` and :math:`V_{i,j} = \Var{\Expect{ Y \vert X_i, X_j}} - V_i - V_j`. Using the previous decomposition, it follows that sensitivity indices are defined as follow:


    .. math::

       \begin{array}{ccc}
        S_i & = & \frac{V_i}{\Var{\vect{Y}}} \\
        S_{i,j} & = & \frac{V_{i,j}}{\Var{\vect{Y}}}
       \end{array}

    :math:`(S_i)` are the first order sensitivity indices and measure the impact of :math:`X_i` in the variance :math:`\Var{\vect{Y}}`,
    :math:`(S_{i,j})` are the second order sensitivity indices and measure the impact of the interaction of :math:`X_i` and :math:`X_j` in the variance :math:`\Var{\vect{Y}}`.

    When :math:`n_X >> 1`, we use total sensitivity indices :math:`ST_i`, which is defined as the sum of all indices that count the i-th variable:

    .. math::

        ST_i =  1 - \frac{V_{-i}}{\Var{\vect{Y}}} = \frac{VT_i}{\Var{\vect{Y}}}, \forall\ i\in(1,2,...,n_X)

    where :math:`V_{-i}` is the part of variance of :math:`\Var{\vect{Y}}` that do not countain the i-th variable.

    |

    In practice, to estimate these quantities, Sobol proposes to use numerical methods that rely on the two independent realizations of the random vector :math:`\vect{X}`.
    If we consider `A` and `B` two independent samples (of size `n`) of the previous random vector:

    .. math::

       A = \left(
       \begin{array}{cccc}
       a_{1,1} & a_{1,2} & \cdots & a_{1, n_X} \\
       a_{2,1} & a_{2,2} & \cdots & a_{2, n_X} \\
       \vdots  & \vdots  & \ddots  & \vdots \\
       a_{n,1} & a_{1,2} & \cdots & a_{n, n_X}
       \end{array}
       \right), \  B = \left(
       \begin{array}{cccc}
       b_{1,1} & b_{1,2} & \cdots & b_{1, n_X} \\
       b_{2,1} & b_{2,2} & \cdots & b_{2, n_X} \\
       \vdots  & \vdots  & \vdots  & \vdots \\
       b_{n,1} & b_{1,2} & \cdots & b_{n, n_X}
       \end{array}
       \right)


    Each line is a realization of the random vector. The purpose is to mix these two samples to get an estimate of the sensitivities.

    `Sobol` method require respectively :math:`C^i` and :math:`D^{i,j}` sample designs for the evaluation of first order (respectively second order) sensitivity indices. These are defined as hereafter:

    .. math::

       C^i = \left(
       \begin{array}{cccccc}
       b_{1,1} & b_{1,2} & \cdots & a_{1,i} & \cdots & b_{1, n_X} \\
       b_{2,1} & b_{2,2} & \cdots & a_{2,i} & \cdots & b_{2, n_X} \\
       \vdots  & \vdots  &        & \vdots  & \ddots  & \vdots \\
       b_{n,1} & b_{1,2} & \cdots & a_{n,i} & \cdots & b_{n, n_X}
       \end{array}
       \right), \ D^{i,j} = \left(
       \begin{array}{cccccccc}
       b_{1,1} & b_{1,2} & \cdots & a_{1,i} & \cdots & a_{1,j} & \cdots & b_{1, n_X} \\
       b_{2,1} & b_{2,2} & \cdots & a_{2,i} & \cdots & a_{2,j} & \cdots & b_{2, n_X} \\
       \vdots  & \vdots  &        & \vdots  &        & \vdots  & \ddots & \vdots \\
       b_{n,1} & b_{n,2} & \cdots & a_{n,i} & \cdots & a_{n,j} & \cdots & b_{n, n_X} \\
       \end{array}
       \right)

    It follows that :math:`V_{i}` and :math:`V_{i,j}` terms are defined as follow:

    .. math::

       \begin{array}{ccc}
        V_i & = & \frac{1}{n} \sum_{k=1}^{n} G(A_k) G(C_k) - G_0^2 \\
        V_{i,j} & = & \frac{1}{n} \sum_{k=1}^{n} G(A_k) G(D_k) - V_i - V_j - G_0^2 \\
        G_0 & = & \frac{1}{n} \sum_{k=1}^{n} G(A_k)
       \end{array}

    The implemented second order indices use this formula.

    The major methods (`Saltelli`, `Jansen`, `Mauntz-Kucherenko`, `Martinez`) use the :math:`E^i` matrix to compute the indices (first order and total order). This matrix is defined as follows:

    .. math::

       E^i = \left(
       \begin{array}{cccccc}
       a_{1,1} & a_{1,2} & \cdots & b_{1,i} & \cdots & a_{1, n_X} \\
       a_{2,1} & a_{2,2} & \cdots & b_{2,i} & \cdots & a_{2, n_X} \\
       \vdots  & \vdots  &        & \vdots  & \ddots & \vdots \\
       a_{n,1} & a_{1,2} & \cdots & b_{n,i} & \cdots & a_{n, n_X}
       \end{array}
       \right)

    The formulas for the evaluation of the indices are given in each class documentation:
      - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
      - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
      - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
      - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method

    For multivariate outputs (see [gamboa2013]_), aggregate indices can be computed thanks to the `getAggregatedFirstOrderIndices` and `getAggregatedTotalOrderIndices`. Such indices write as follow:


    .. math::

       \begin{array}{ccc}
        S_i & = & \frac{ \sum_{k=1}^{q} V_{i}^{(k)} }{ \sum_{k=1}^{q} \Var{Y_k} }  \\
        S_{i,j} & = & \frac{ \sum_{k=1}^{q} V_{i,j}^{(k)} }{ \sum_{k=1}^{q} \Var{Y_k} }  \\
        ST_i & = & \frac{ \sum_{k=1}^{q} VT_{i}^{(k)} }{ \sum_{k=1}^{q} \Var{Y_k} }
       \end{array}

    Aggregated second order indices have not been implemented.

    |

    Note finally that the distribution of indices can be computed for first
    and total order thanks to the :meth:`getFirstOrderIndicesDistribution` and
    :meth:`getTotalOrderIndicesDistribution` methods.

    This can be done either by bootstrap or using an asymptotic estimator,
    this behavior can be changed using :meth:`setUseAsymptoticDistribution`.
    Its value in initialized by the
    `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` resourcemap key.

    For the bootstrap method the size is set by :meth:`setBootstrapSize`
    values and initialized by `SobolIndicesAlgorithm-DefaultBootstrapSize` resourcemap key.

    The asymptotic estimator of the variance are computed using the [janon2014]_
    delta method, in the technical report [pmfre01116]_.

    The corresponding confidence interval is also provided using
    :meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
    The confidence level is set by `setConfidenceLevel`
    and is initialized by the `SobolIndicesAlgorithm-DefaultConfidenceLevel` resourcemap key.

    Also note that for numerical stability reasons the outputs are centered before indices estimation:

    .. math::

        Y_k = Y_k - \Eset(Y_k)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""
        Get second order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get total order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing total order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        r"""
        Get the evaluation of aggregated first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated first order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        r"""
        Get the evaluation of aggregated total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated total order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        r"""
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootsrap sampling
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootsrap sampling
        """
        return _simulation.SobolIndicesAlgorithmImplementation_setBootstrapSize(self, bootstrapSize)

    def getConfidenceLevel(self):
        r"""
        Get the confidence interval level for confidence intervals.

        Returns
        -------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getConfidenceLevel(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Set the confidence interval level for confidence intervals.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _simulation.SobolIndicesAlgorithmImplementation_setConfidenceLevel(self, confidenceLevel)

    def setUseAsymptoticDistribution(self, useAsymptoticDistribution):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

        Parameters
        ----------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _simulation.SobolIndicesAlgorithmImplementation_setUseAsymptoticDistribution(self, useAsymptoticDistribution)

    def getUseAsymptoticDistribution(self):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Returns
        -------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getUseAsymptoticDistribution(self)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated first order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for first order Sobol indices for each component.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated total order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for total order Sobol indices for each component.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_getTotalOrderIndicesDistribution(self)

    def __repr__(self):
        return _simulation.SobolIndicesAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _simulation.SobolIndicesAlgorithmImplementation___str__(self, *args)

    @staticmethod
    def DrawImportanceFactors(*args):
        r"""
        Draw the importance factors.

        Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args)

    @staticmethod
    def DrawSobolIndices(inputDescription, firstOrderIndices, secondOrderIndices):
        r"""
        Draw the Sobol' indices.

        Parameters
        ----------
        inputDescription : sequence of str
            Variable names
        firstOrderIndices : sequence of float
            First order indices values
        totalOrderIndices : sequence of float
            Total order indices values

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            For each variable, draws first and total indices
        """
        return _simulation.SobolIndicesAlgorithmImplementation_DrawSobolIndices(inputDescription, firstOrderIndices, secondOrderIndices)

    @staticmethod
    def DrawCorrelationCoefficients(*args):
        r"""
        Draw the correlation coefficients. 
         As correlation coefficients are considered, values might be positive or negative.

        Available usages:
            DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

            DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

        Parameters
        ----------
        correlationCoefficients : :class:`~openturns.PointWithDescription`
            Sequence containing the correlation coefficients with a description for each
            component. The descriptions are used to build labels for the created graph.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Correlation coefficients.
        names : sequence of str
            Variables' names used to build labels for the created the graph.
        title : str
            Title of the graph.

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
            of the correlation coefficients.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_DrawCorrelationCoefficients(*args)

    def draw(self, *args):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _simulation.SobolIndicesAlgorithmImplementation_draw(self, *args)

    def setDesign(self, inputDesign, outputDesign, size):
        r"""
        Sample accessor.

        Parameters
        ----------
        inputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained
            thanks to the SobolIndicesAlgorithmImplementation.Generate method
        outputDesign : :class:`~openturns.Sample`
            Design for the evaluation of sensitivity indices, obtained as the evaluation
            of a Function (model) on the previous inputDesign
        N : int
            Size of samples to generate
        """
        return _simulation.SobolIndicesAlgorithmImplementation_setDesign(self, inputDesign, outputDesign, size)

    def __init__(self, *args):
        _simulation.SobolIndicesAlgorithmImplementation_swiginit(self, _simulation.new_SobolIndicesAlgorithmImplementation(*args))
    __swig_destroy__ = _simulation.delete_SobolIndicesAlgorithmImplementation

# Register SobolIndicesAlgorithmImplementation in _simulation:
_simulation.SobolIndicesAlgorithmImplementation_swigregister(SobolIndicesAlgorithmImplementation)

def SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args):
    r"""
    Draw the importance factors.

    Available usages:
        DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

        DrawImportanceFactors(*values, names, title='Importance Factors'*)

    Parameters
    ----------
    importanceFactors : :class:`~openturns.PointWithDescription`
        Sequence containing the importance factors with a description for each
        component. The descriptions are used to build labels for the created Pie.
        If they are not mentioned, default labels will be used.
    values : sequence of float
        Importance factors.
    names : sequence of str
        Variables' names used to build labels for the created Pie.
    title : str
        Title of the graph.

    Returns
    -------
    Graph : :class:`~openturns.Graph`
        A graph containing a :class:`~openturns.Pie` of the importance factors of
        the variables.
    """
    return _simulation.SobolIndicesAlgorithmImplementation_DrawImportanceFactors(*args)

def SobolIndicesAlgorithmImplementation_DrawSobolIndices(inputDescription, firstOrderIndices, secondOrderIndices):
    r"""
    Draw the Sobol' indices.

    Parameters
    ----------
    inputDescription : sequence of str
        Variable names
    firstOrderIndices : sequence of float
        First order indices values
    totalOrderIndices : sequence of float
        Total order indices values

    Returns
    -------
    Graph : :class:`~openturns.Graph`
        For each variable, draws first and total indices
    """
    return _simulation.SobolIndicesAlgorithmImplementation_DrawSobolIndices(inputDescription, firstOrderIndices, secondOrderIndices)

def SobolIndicesAlgorithmImplementation_DrawCorrelationCoefficients(*args):
    r"""
    Draw the correlation coefficients. 
     As correlation coefficients are considered, values might be positive or negative.

    Available usages:
        DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

        DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

    Parameters
    ----------
    correlationCoefficients : :class:`~openturns.PointWithDescription`
        Sequence containing the correlation coefficients with a description for each
        component. The descriptions are used to build labels for the created graph.
        If they are not mentioned, default labels will be used.
    values : sequence of float
        Correlation coefficients.
    names : sequence of str
        Variables' names used to build labels for the created the graph.
    title : str
        Title of the graph.

    Returns
    -------
    Graph : :class:`~openturns.Graph`
        A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
        of the correlation coefficients.
    """
    return _simulation.SobolIndicesAlgorithmImplementation_DrawCorrelationCoefficients(*args)

class SobolIndicesAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _simulation.SobolIndicesAlgorithmImplementationTypedInterfaceObject_swiginit(self, _simulation.new_SobolIndicesAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _simulation.SobolIndicesAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.SobolIndicesAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.SobolIndicesAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _simulation.SobolIndicesAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _simulation.SobolIndicesAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _simulation.delete_SobolIndicesAlgorithmImplementationTypedInterfaceObject

# Register SobolIndicesAlgorithmImplementationTypedInterfaceObject in _simulation:
_simulation.SobolIndicesAlgorithmImplementationTypedInterfaceObject_swigregister(SobolIndicesAlgorithmImplementationTypedInterfaceObject)

class SobolIndicesAlgorithm(SobolIndicesAlgorithmImplementationTypedInterfaceObject):
    r"""

    Sensitivity analysis.

    Notes
    -----
    This method is concerned with analyzing the influence the random vector
    :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty (see also [sobol1993]_).

    Here we attempt to evaluate the part of variance of :math:`Y^k` due to the different components :math:`X^i`.

    We denote G the physical model such as :math:`\vect{Y}=G(\vect{X})`. Let us consider first the case where :math:`\vect{Y}` is of dimension 1.

    The objective here is to develop the variability of the random variable :math:`\vect{Y}` as function of :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)`. Using the Hoeffding decomposition, we got:

    .. math::

       \Var{\vect{Y}} = \sum_{i=1}^{n_X} V_i + \sum_{i<j} V_{i,j} + \sum_{i<k<j} V_{i,j,k} + \cdots + V_{1,2,..,n_X}

    where :

    :math:`V_i = \Var{\Expect{ Y \vert X_i}}` and :math:`V_{i,j} = \Var{\Expect{ Y \vert X_i, X_j}} - V_i - V_j`. Using the previous decomposition, it follows that sensitivity indices are defined as follow:


    .. math::

       \begin{array}{ccc}
        S_i & = & \frac{V_i}{\Var{\vect{Y}}} \\
        S_{i,j} & = & \frac{V_{i,j}}{\Var{\vect{Y}}}
       \end{array}

    :math:`(S_i)` are the first order sensitivity indices and measure the impact of :math:`X_i` in the variance :math:`\Var{\vect{Y}}`,
    :math:`(S_{i,j})` are the second order sensitivity indices and measure the impact of the interaction of :math:`X_i` and :math:`X_j` in the variance :math:`\Var{\vect{Y}}`.

    When :math:`n_X >> 1`, we use total sensitivity indices :math:`ST_i`, which is defined as the sum of all indices that count the i-th variable:

    .. math::

        ST_i =  1 - \frac{V_{-i}}{\Var{\vect{Y}}} = \frac{VT_i}{\Var{\vect{Y}}}, \forall\ i\in(1,2,...,n_X)

    where :math:`V_{-i}` is the part of variance of :math:`\Var{\vect{Y}}` that do not countain the i-th variable.

    |

    In practice, to estimate these quantities, Sobol proposes to use numerical methods that rely on the two independent realizations of the random vector :math:`\vect{X}`.
    If we consider `A` and `B` two independent samples (of size `n`) of the previous random vector:

    .. math::

       A = \left(
       \begin{array}{cccc}
       a_{1,1} & a_{1,2} & \cdots & a_{1, n_X} \\
       a_{2,1} & a_{2,2} & \cdots & a_{2, n_X} \\
       \vdots  & \vdots  & \ddots  & \vdots \\
       a_{n,1} & a_{1,2} & \cdots & a_{n, n_X}
       \end{array}
       \right), \  B = \left(
       \begin{array}{cccc}
       b_{1,1} & b_{1,2} & \cdots & b_{1, n_X} \\
       b_{2,1} & b_{2,2} & \cdots & b_{2, n_X} \\
       \vdots  & \vdots  & \vdots  & \vdots \\
       b_{n,1} & b_{1,2} & \cdots & b_{n, n_X}
       \end{array}
       \right)


    Each line is a realization of the random vector. The purpose is to mix these two samples to get an estimate of the sensitivities.

    `Sobol` method require respectively :math:`C^i` and :math:`D^{i,j}` sample designs for the evaluation of first order (respectively second order) sensitivity indices. These are defined as hereafter:

    .. math::

       C^i = \left(
       \begin{array}{cccccc}
       b_{1,1} & b_{1,2} & \cdots & a_{1,i} & \cdots & b_{1, n_X} \\
       b_{2,1} & b_{2,2} & \cdots & a_{2,i} & \cdots & b_{2, n_X} \\
       \vdots  & \vdots  &        & \vdots  & \ddots  & \vdots \\
       b_{n,1} & b_{1,2} & \cdots & a_{n,i} & \cdots & b_{n, n_X}
       \end{array}
       \right), \ D^{i,j} = \left(
       \begin{array}{cccccccc}
       b_{1,1} & b_{1,2} & \cdots & a_{1,i} & \cdots & a_{1,j} & \cdots & b_{1, n_X} \\
       b_{2,1} & b_{2,2} & \cdots & a_{2,i} & \cdots & a_{2,j} & \cdots & b_{2, n_X} \\
       \vdots  & \vdots  &        & \vdots  &        & \vdots  & \ddots & \vdots \\
       b_{n,1} & b_{n,2} & \cdots & a_{n,i} & \cdots & a_{n,j} & \cdots & b_{n, n_X} \\
       \end{array}
       \right)

    It follows that :math:`V_{i}` and :math:`V_{i,j}` terms are defined as follow:

    .. math::

       \begin{array}{ccc}
        V_i & = & \frac{1}{n} \sum_{k=1}^{n} G(A_k) G(C_k) - G_0^2 \\
        V_{i,j} & = & \frac{1}{n} \sum_{k=1}^{n} G(A_k) G(D_k) - V_i - V_j - G_0^2 \\
        G_0 & = & \frac{1}{n} \sum_{k=1}^{n} G(A_k)
       \end{array}

    The implemented second order indices use this formula.

    The major methods (`Saltelli`, `Jansen`, `Mauntz-Kucherenko`, `Martinez`) use the :math:`E^i` matrix to compute the indices (first order and total order). This matrix is defined as follows:

    .. math::

       E^i = \left(
       \begin{array}{cccccc}
       a_{1,1} & a_{1,2} & \cdots & b_{1,i} & \cdots & a_{1, n_X} \\
       a_{2,1} & a_{2,2} & \cdots & b_{2,i} & \cdots & a_{2, n_X} \\
       \vdots  & \vdots  &        & \vdots  & \ddots & \vdots \\
       a_{n,1} & a_{1,2} & \cdots & b_{n,i} & \cdots & a_{n, n_X}
       \end{array}
       \right)

    The formulas for the evaluation of the indices are given in each class documentation:
      - :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
      - :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
      - :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
      - :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method

    For multivariate outputs (see [gamboa2013]_), aggregate indices can be computed thanks to the `getAggregatedFirstOrderIndices` and `getAggregatedTotalOrderIndices`. Such indices write as follow:


    .. math::

       \begin{array}{ccc}
        S_i & = & \frac{ \sum_{k=1}^{q} V_{i}^{(k)} }{ \sum_{k=1}^{q} \Var{Y_k} }  \\
        S_{i,j} & = & \frac{ \sum_{k=1}^{q} V_{i,j}^{(k)} }{ \sum_{k=1}^{q} \Var{Y_k} }  \\
        ST_i & = & \frac{ \sum_{k=1}^{q} VT_{i}^{(k)} }{ \sum_{k=1}^{q} \Var{Y_k} }
       \end{array}

    Aggregated second order indices have not been implemented.

    |

    Note finally that the distribution of indices can be computed for first
    and total order thanks to the :meth:`getFirstOrderIndicesDistribution` and
    :meth:`getTotalOrderIndicesDistribution` methods.

    This can be done either by bootstrap or using an asymptotic estimator,
    this behavior can be changed using :meth:`setUseAsymptoticDistribution`.
    Its value in initialized by the
    `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` resourcemap key.

    For the bootstrap method the size is set by :meth:`setBootstrapSize`
    values and initialized by `SobolIndicesAlgorithm-DefaultBootstrapSize` resourcemap key.

    The asymptotic estimator of the variance are computed using the [janon2014]_
    delta method, in the technical report [pmfre01116]_.

    The corresponding confidence interval is also provided using
    :meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
    The confidence level is set by `setConfidenceLevel`
    and is initialized by the `SobolIndicesAlgorithm-DefaultConfidenceLevel` resourcemap key.

    Also note that for numerical stability reasons the outputs are centered before indices estimation:

    .. math::

        Y_k = Y_k - \Eset(Y_k)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolIndicesAlgorithm_getClassName(self)

    def getFirstOrderIndices(self, marginalIndex=0):
        r"""
        Get first order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing first order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getFirstOrderIndices(self, marginalIndex)

    def getFirstOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated first order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for first order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _simulation.SobolIndicesAlgorithm_getFirstOrderIndicesInterval(self)

    def getSecondOrderIndices(self, marginalIndex=0):
        r"""
        Get second order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.SymmetricMatrix`
            Tensor containing second order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getSecondOrderIndices(self, marginalIndex)

    def getTotalOrderIndices(self, marginalIndex=0):
        r"""
        Get total order Sobol indices.

        Parameters
        ----------
        i : int, optional
            Index of the marginal of the function, equals to :math:`0` by default.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing total order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getTotalOrderIndices(self, marginalIndex)

    def getTotalOrderIndicesInterval(self):
        r"""
        Get interval for the aggregated total order Sobol indices.

        Returns
        -------
        interval : :class:`~openturns.Interval`
            Interval for total order Sobol indices for each component.
            Computed marginal by marginal (not from the joint distribution).
        """
        return _simulation.SobolIndicesAlgorithm_getTotalOrderIndicesInterval(self)

    def getAggregatedFirstOrderIndices(self):
        r"""
        Get the evaluation of aggregated first order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated first order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getAggregatedFirstOrderIndices(self)

    def getAggregatedTotalOrderIndices(self):
        r"""
        Get the evaluation of aggregated total order Sobol indices.

        Returns
        -------
        indices : :class:`~openturns.Point`
            Sequence containing aggregated total order Sobol indices.
        """
        return _simulation.SobolIndicesAlgorithm_getAggregatedTotalOrderIndices(self)

    def getBootstrapSize(self):
        r"""
        Get the number of bootstrap sampling size.

        Returns
        -------
        bootstrapSize : int
            Number of bootsrap sampling
        """
        return _simulation.SobolIndicesAlgorithm_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Set the number of bootstrap sampling size.

        Default value is 0.

        Parameters
        ----------
        bootstrapSize : int
            Number of bootsrap sampling
        """
        return _simulation.SobolIndicesAlgorithm_setBootstrapSize(self, bootstrapSize)

    def getConfidenceLevel(self):
        r"""
        Get the confidence interval level for confidence intervals.

        Returns
        -------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _simulation.SobolIndicesAlgorithm_getConfidenceLevel(self)

    def setConfidenceLevel(self, confidenceLevel):
        r"""
        Set the confidence interval level for confidence intervals.

        Parameters
        ----------
        confidenceLevel : float
            Confidence level for confidence intervals
        """
        return _simulation.SobolIndicesAlgorithm_setConfidenceLevel(self, confidenceLevel)

    def setUseAsymptoticDistribution(self, useAsymptoticDistribution):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

        Parameters
        ----------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _simulation.SobolIndicesAlgorithm_setUseAsymptoticDistribution(self, useAsymptoticDistribution)

    def getUseAsymptoticDistribution(self):
        r"""
        Select asymptotic or bootstrap confidence intervals.

        Returns
        -------
        useAsymptoticDistribution : bool
            Whether to use bootstrap or asymptotic intervals
        """
        return _simulation.SobolIndicesAlgorithm_getUseAsymptoticDistribution(self)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated first order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for first order Sobol indices for each component.
        """
        return _simulation.SobolIndicesAlgorithm_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Get the distribution of the aggregated total order Sobol indices.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution for total order Sobol indices for each component.
        """
        return _simulation.SobolIndicesAlgorithm_getTotalOrderIndicesDistribution(self)

    @staticmethod
    def DrawImportanceFactors(*args):
        r"""
        Draw the importance factors.

        Available usages:
            DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

            DrawImportanceFactors(*values, names, title='Importance Factors'*)

        Parameters
        ----------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component. The descriptions are used to build labels for the created Pie.
            If they are not mentioned, default labels will be used.
        values : sequence of float
            Importance factors.
        names : sequence of str
            Variables' names used to build labels for the created Pie.
        title : str
            Title of the graph.

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            A graph containing a :class:`~openturns.Pie` of the importance factors of
            the variables.
        """
        return _simulation.SobolIndicesAlgorithm_DrawImportanceFactors(*args)

    @staticmethod
    def DrawSobolIndices(inputDescription, firstOrderIndices, secondOrderIndices):
        r"""
        Draw the Sobol' indices.

        Parameters
        ----------
        inputDescription : sequence of str
            Variable names
        firstOrderIndices : sequence of float
            First order indices values
        totalOrderIndices : sequence of float
            Total order indices values

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            For each variable, draws first and total indices
        """
        return _simulation.SobolIndicesAlgorithm_DrawSobolIndices(inputDescription, firstOrderIndices, secondOrderIndices)

    @staticmethod
    def DrawCorrelationCoefficients(*args):
        return _simulation.SobolIndicesAlgorithm_DrawCorrelationCoefficients(*args)

    def draw(self, *args):
        r"""
        Draw sensitivity indices.

        Usage:
          draw()

          draw(*marginalIndex*)

        With the first usage, draw the aggregated first and total order indices.
        With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

        Parameters
        ----------
        marginalIndex: int
            marginal of interest (case of second usage)

        Returns
        -------
        Graph : :class:`~openturns.Graph`
            A graph containing the aggregated first and total order indices.

        Notes
        -----
        If number of bootstrap sampling is not 0, and confidence level associated > 0,
        the graph includes confidence interval plots in the first usage.
        """
        return _simulation.SobolIndicesAlgorithm_draw(self, *args)

    def setDesign(self, inputDesign, outputDesign, size):
        return _simulation.SobolIndicesAlgorithm_setDesign(self, inputDesign, outputDesign, size)

    def __repr__(self):
        return _simulation.SobolIndicesAlgorithm___repr__(self)

    def __str__(self, *args):
        return _simulation.SobolIndicesAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _simulation.SobolIndicesAlgorithm_swiginit(self, _simulation.new_SobolIndicesAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_SobolIndicesAlgorithm

# Register SobolIndicesAlgorithm in _simulation:
_simulation.SobolIndicesAlgorithm_swigregister(SobolIndicesAlgorithm)

def SobolIndicesAlgorithm_DrawImportanceFactors(*args):
    r"""
    Draw the importance factors.

    Available usages:
        DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

        DrawImportanceFactors(*values, names, title='Importance Factors'*)

    Parameters
    ----------
    importanceFactors : :class:`~openturns.PointWithDescription`
        Sequence containing the importance factors with a description for each
        component. The descriptions are used to build labels for the created Pie.
        If they are not mentioned, default labels will be used.
    values : sequence of float
        Importance factors.
    names : sequence of str
        Variables' names used to build labels for the created Pie.
    title : str
        Title of the graph.

    Returns
    -------
    Graph : :class:`~openturns.Graph`
        A graph containing a :class:`~openturns.Pie` of the importance factors of
        the variables.
    """
    return _simulation.SobolIndicesAlgorithm_DrawImportanceFactors(*args)

def SobolIndicesAlgorithm_DrawSobolIndices(inputDescription, firstOrderIndices, secondOrderIndices):
    r"""
    Draw the Sobol' indices.

    Parameters
    ----------
    inputDescription : sequence of str
        Variable names
    firstOrderIndices : sequence of float
        First order indices values
    totalOrderIndices : sequence of float
        Total order indices values

    Returns
    -------
    Graph : :class:`~openturns.Graph`
        For each variable, draws first and total indices
    """
    return _simulation.SobolIndicesAlgorithm_DrawSobolIndices(inputDescription, firstOrderIndices, secondOrderIndices)

def SobolIndicesAlgorithm_DrawCorrelationCoefficients(*args):
    return _simulation.SobolIndicesAlgorithm_DrawCorrelationCoefficients(*args)

class MartinezSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Martinez method.

    Available constructors:
        MartinezSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        MartinezSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MartinezSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained
        thanks to the SobolIndicesAlgorithmImplementation.Generate method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class is concerned with analyzing the influence the random vector
    :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty, by using the [martinez2011]_
    method for the evaluation of both first and total order indices.

    These last ones are respectively given as follows:

    .. math::

       \begin{array}{ccc}
       \hat{S_i} & = & \rho_n(G(B), G(E^i)) \\
       \hat{ST_i} & = & 1 - \rho_n(G(A), G(E^i)) \\
       \end{array}

    where :math:`\rho_n` is the empirical correlation defined by:

    .. math::

       \rho_n(X, Y) = \frac{\Cov{X,Y}}{\sqrt{\Var{X} \Var{Y}}}


    The variance of the estimator is computed using:

    .. math::

        \begin{array}{ccc}
        U_i = \left(\left(\textsuperscript{c}Y_i^B \textsuperscript{c}Y_i^E \right), \left(\textsuperscript{c}Y_i^B\right)^2, \left(\textsuperscript{c}Y_i^E \right)^2 \right)^T \\
        \Psi_i(x, y, z) = \frac{x}{\sqrt{y\times z}}
        \end{array}

    .. math::

        \begin{array}{ccc}
        U_{-i} = \left(\textsuperscript{c}Y_i^A \textsuperscript{c}Y_i^E, \left(\textsuperscript{c}Y_i^A\right)^2, \left(\textsuperscript{c}Y_i^E\right)^2 \right)^T \\
        \Psi_{-i}(x, y, z) = 1 - \frac{x}{\sqrt{y\times z}}
        \end{array}

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Estimate first and total order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MartinezSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.30449,0.448506,-0.0711394]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.543004,0.29501,0.304615]

    Estimate first, total and second order Sobol' indices:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> computeSecondOrderIndices = True
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size, computeSecondOrderIndices).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MartinezSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.30449,0.448506,-0.0711394]
    >>> print(sensitivityAnalysis.getTotalOrderIndices())
    [0.543004,0.29501,0.304615]
    >>> print(sensitivityAnalysis.getSecondOrderIndices())
    [[  0        -0.18008   0.169767 ]
     [ -0.18008   0        -0.198839 ]
     [  0.169767 -0.198839  0        ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.MartinezSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _simulation.MartinezSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _simulation.MartinezSensitivityAlgorithm_swiginit(self, _simulation.new_MartinezSensitivityAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_MartinezSensitivityAlgorithm

# Register MartinezSensitivityAlgorithm in _simulation:
_simulation.MartinezSensitivityAlgorithm_swigregister(MartinezSensitivityAlgorithm)

class SaltelliSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Saltelli method.

    Available constructors:
        SaltelliSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        SaltelliSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        SaltelliSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained
        thanks to the SobolIndicesAlgorithmImplementation.Generate method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class is concerned with analyzing the influence the random vector
    :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty, by using the [saltelli2002]_
    method for the evaluation of both first and total order indices.

    These last ones are respectively given as follows:

    .. math::

       \begin{array}{ccc}
       \hat{V_i} & = & \frac{1}{n}\sum_{k=1}^{n} G(B_k)  G(E_k) - (\frac{1}{n} \sum_{k=1}^{n} G(A_k)) (\frac{1}{n} \sum_{k=1}^{n} G(B_k)) \\
       \hat{V_{-i}} & = & \frac{1}{n}\sum_{k=1}^{n} G(A_k)  G(E_k) - G_0^2
       \end{array}

    The variance of the estimator is computed using:

    .. math::

        \begin{array}{ccc}
        U_i = \left(\textsuperscript{c}Y_i^B \textsuperscript{c}Y_i^E, \left(\textsuperscript{c}Y_i^{A}\right)^2 \right)^T \\
        \Psi_i(x, y) = \frac{x}{y}
        \end{array}

    .. math::

        \begin{array}{ccc}
        U_{-i} = \left(\textsuperscript{c}Y_i^A \textsuperscript{c}Y_i^E, \left(\textsuperscript{c}Y_i^{A}\right)^2 \right)^T \\
        \Psi_{-i}(x, y) = 1 - \frac{x}{y}
        \end{array}

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.SaltelliSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.249038,0.425106,-0.0623136]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SaltelliSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _simulation.SaltelliSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _simulation.SaltelliSensitivityAlgorithm_swiginit(self, _simulation.new_SaltelliSensitivityAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_SaltelliSensitivityAlgorithm

# Register SaltelliSensitivityAlgorithm in _simulation:
_simulation.SaltelliSensitivityAlgorithm_swigregister(SaltelliSensitivityAlgorithm)

class JansenSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using Jansen method.

    Available constructors:
        JansenSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        JansenSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        JansenSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained
        thanks to the SobolIndicesAlgorithmImplementation.Generate method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class is concerned with analyzing the influence the random vector
    :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty, by using the [jansen1999]_
    method for the evaluation of both first and total order indices.

    These last ones are respectively given as follows:

    .. math::

       \begin{array}{ccc}
       \hat{V_i} & = & \Var{G(A_k)} - \frac{1}{2n} \sum_{k=1}^{n} \left( G(E_k) - G(B_k) \right)^2 \\
       \hat{VT_{i}} & = & \frac{1}{2n} \sum_{k=1}^{n} \left( G(A_k) -  G(E_k) \right)^2
       \end{array}

    The variance of the estimator is computed using:

    .. math::

        \begin{array}{ccc}
        U_i = \left(\left(\textsuperscript{c}Y_i^E - \textsuperscript{c}Y_i^B\right)^2, \left(\textsuperscript{c}Y_i^{A}\right)^2 \right)^T \\
        \Psi_i(x, y) = 1 - \frac{0.5 x}{y}
        \end{array}

    .. math::

        \begin{array}{ccc}
        U_{-i} = \left(\left(\textsuperscript{c}Y_i^A - \textsuperscript{c}Y_i^E\right)^2, \left(\textsuperscript{c}Y_i^{A}\right)^2 \right)^T \\
        \Psi_{-i}(x, y) = \frac{0.5x}{y}
        \end{array}

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.JansenSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.403551,0.487879,0.140996]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.JansenSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _simulation.JansenSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _simulation.JansenSensitivityAlgorithm_swiginit(self, _simulation.new_JansenSensitivityAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_JansenSensitivityAlgorithm

# Register JansenSensitivityAlgorithm in _simulation:
_simulation.JansenSensitivityAlgorithm_swigregister(JansenSensitivityAlgorithm)

class MauntzKucherenkoSensitivityAlgorithm(SobolIndicesAlgorithmImplementation):
    r"""
    Sensitivity analysis using MauntzKucherenko method.

    Available constructors:
        MauntzKucherenkoSensitivityAlgorithm(*inputDesign, outputDesign, N*)

        MauntzKucherenkoSensitivityAlgorithm(*distribution, N, model, computeSecondOrder*)

        MauntzKucherenkoSensitivityAlgorithm(*experiment, model, computeSecondOrder*)

    Parameters
    ----------
    inputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained
        thanks to the SobolIndicesAlgorithmImplementation.Generate method
    outputDesign : :class:`~openturns.Sample`
        Design for the evaluation of sensitivity indices, obtained as the evaluation
        of a Function (model) on the previous inputDesign
    distribution : :class:`~openturns.Distribution`
        Input probabilistic model.
        Should have independent copula
    experiment : :class:`~openturns.WeightedExperiment`
        Experiment for the generation of two independent samples.
    N : int
        Size of samples to generate
    computeSecondOrder : bool
        If True, design that will be generated contains elements for the evaluation
        of second order indices.

    Notes
    -----
    This class is concerned with analyzing the influence the random vector
    :math:`\vect{X} = \left( X^1, \ldots, X^{n_X} \right)` has on a random variable
    :math:`Y^k` which is being studied for uncertainty, by using the [sobol2007]_
    method for the evaluation of both first and total order indices.

    These last ones are respectively given as follows:

    .. math::

       \begin{array}{ccc}
       \hat{V_i} & = & \frac{1}{n} \sum_{k=1}^{n} G(B_k) \left( G(E_k) - G(A_k) \right) \\
       \hat{V_{-i}} & = & \frac{1}{n} \sum_{k=1}^{n} G(A_k) \left( G(A_k) -  G(E_k) \right)
       \end{array}

    The variance of the estimator is computed using:

    .. math::

        \begin{array}{ccc}
        U_i = \left(\textsuperscript{c}Y_i^B \left(\textsuperscript{c}Y_i^E - \textsuperscript{c}Y_i^A \right), \left(\textsuperscript{c}Y_i^{A}\right)^2 \right)^T \\
        \Psi_i(x, y) = \frac{x}{y}
        \end{array}

    .. math::

        \begin{array}{ccc}
        U_{-i} = \left(\textsuperscript{c}Y_i^A \left(\textsuperscript{c}Y_i^A - \textsuperscript{c}Y_i^E \right), \left(\textsuperscript{c}Y_i^{A}\right)^2 \right)^T \\
        \Psi_{-i}(x, y) = 1 - \frac{x}{y}
        \end{array}

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> # Define designs to pre-compute
    >>> size = 100
    >>> inputDesign = ot.SobolIndicesExperiment(distribution, size).generate()
    >>> outputDesign = model(inputDesign)
    >>> # sensitivity analysis algorithm
    >>> sensitivityAnalysis = ot.MauntzKucherenkoSensitivityAlgorithm(inputDesign, outputDesign, size)
    >>> print(sensitivityAnalysis.getFirstOrderIndices())
    [0.18185,0.357918,-0.129502]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.MauntzKucherenkoSensitivityAlgorithm_getClassName(self)

    def __repr__(self):
        return _simulation.MauntzKucherenkoSensitivityAlgorithm___repr__(self)

    def __init__(self, *args):
        _simulation.MauntzKucherenkoSensitivityAlgorithm_swiginit(self, _simulation.new_MauntzKucherenkoSensitivityAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_MauntzKucherenkoSensitivityAlgorithm

# Register MauntzKucherenkoSensitivityAlgorithm in _simulation:
_simulation.MauntzKucherenkoSensitivityAlgorithm_swigregister(MauntzKucherenkoSensitivityAlgorithm)

class SobolIndicesExperiment(openturns.weightedexperiment.WeightedExperimentImplementation):
    r"""
    Experiment to computeSobol' indices.

    Available constructors:
        SobolIndicesExperiment(*distribution, size, computeSecondOrder=False*)

        SobolIndicesExperiment(*experiment, computeSecondOrder=False*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution :math:`\mu` with an independent copula used to generate the
        set of input data.
    size : positive int
        Size :math:`N` of each of the two independent initial samples.
        For the total size of the experiment see notes below.
    experiment : :class:`~openturns.WeightedExperiment`
        Design of experiment used to sample the distribution.
    computeSecondOrder : bool, defaults to False
        Whether to add points to compute second order indices

    Notes
    -----
    Sensitivity algorithms rely on the definition of specific designs.
    The method generates design for the Saltelli method.
    Such designs can be used for Jansen, Martinez and MauntzKucherenko methods.
    This precomputes such input designs using distribution or experiment by
    generating a sample of twice the dimension by duplicating the distribution
    into a :math:`2d` distribution with repeated marginals, in order to also work
    with non-iid samples such as those generated by :class:`~openturns.LHSExperiment`
    or :class:`~openturns.LowDiscrepancyExperiment`. The sampling is done according
    to the given experiment, then it is split into samples :math:`A` and :math:`B`
    and the columns of these ones are mixed to define the huge sample (design).
    If *computeSecondOrder* is set to *False*, the result design is of size
    :math:`N(d+2)` where :math:`d` is the dimension of the distribution.
    If *computeSecondOrder* is set to *True*, the design size is :math:`N(2d+2)`, see
    [saltelli2002]_, excepted in dimension 2.
    If the constructor based on the distribution is used, an experiment is built
    according to the value of 'SobolIndicesExperiment-SamplingMethod' in :class:`~openturns.ResourceMap`:

        - If it is equal to 'LHS', a :class:`~openturns.LHSExperiment` is used, with *AlwaysShuffle* and *RandomShift* set to *True*
        - If it is equal to 'QMC' and :math:`d\leq SobolSequence.MaximumNumberOfDimension`, a :class:`~openturns.LowDiscrepancyExperiment` is used in conjunction with :class:`~openturns.SobolSequence`, with *Randomize* set to *False*. If :math:`d` is too large, it falls back to the 'LHS' case.
        - Otherwise a :class:`~openturns.MonteCarloExperiment` is used. It is the default choice in order to allow :class:`~openturns.SobolIndicesAlgorithm` to use the asymptotic distribution of the indices estimates.

    The corresponding output values of a model can be evaluated outside of the
    platform.

    See also
    --------
    SobolIndicesAlgorithm

    Examples
    --------

    Create a sample suitable to estimate first and total order Sobol' indices:
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> size = 10
    >>> experiment = ot.SobolIndicesExperiment(distribution, size)
    >>> sample = experiment.generate()

    Create a sample suitable to estimate first, total order and second order Sobol' indices:
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> formula = ['sin(pi_*X1)+7*sin(pi_*X2)^2+0.1*(pi_*X3)^4*sin(pi_*X1)']
    >>> model = ot.SymbolicFunction(['X1', 'X2', 'X3'], formula)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> size = 10
    >>> computeSecondOrder = True
    >>> experiment = ot.SobolIndicesExperiment(distribution, size, computeSecondOrder)
    >>> sample = experiment.generate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolIndicesExperiment_getClassName(self)

    def __repr__(self):
        return _simulation.SobolIndicesExperiment___repr__(self)

    def setSize(self, size):
        r"""
        Accessor to the size of the generated sample.

        Parameters
        ----------
        size : positive int
            Number :math:`cardI` of points constituting the design of experiments.
        """
        return _simulation.SobolIndicesExperiment_setSize(self, size)

    def setDistribution(self, distribution):
        r"""
        Accessor to the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _simulation.SobolIndicesExperiment_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution used to generate the set of input data.
        """
        return _simulation.SobolIndicesExperiment_getDistribution(self)

    def hasUniformWeights(self):
        r"""
        Ask whether the experiment has uniform weights.

        Returns
        -------
        hasUniformWeights : bool
            Whether the experiment has uniform weights.
        """
        return _simulation.SobolIndicesExperiment_hasUniformWeights(self)

    def generateWithWeights(self, weights):
        r"""
        Generate points and their associated weight according to the type of the experiment.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The points which constitute the design of experiments. The sampling method
            is defined by the nature of the experiment.
        weights : :class:`~openturns.Point` of size :math:`cardI`
            Weights :math:`(\omega_i)_{i \in I}` associated with the points. By default,
            all the weights are equal to :math:`1/cardI`.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> myExperiment = ot.MonteCarloExperiment(ot.Normal(2), 5)
        >>> sample, weights = myExperiment.generateWithWeights()
        >>> print(sample)
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        3 : [ -0.355007  1.43725  ]
        4 : [  0.810668  0.793156 ]
        >>> print(weights)
        [0.2,0.2,0.2,0.2,0.2]
        """
        return _simulation.SobolIndicesExperiment_generateWithWeights(self, weights)

    def getWeightedExperiment(self):
        return _simulation.SobolIndicesExperiment_getWeightedExperiment(self)

    def __init__(self, *args):
        _simulation.SobolIndicesExperiment_swiginit(self, _simulation.new_SobolIndicesExperiment(*args))
    __swig_destroy__ = _simulation.delete_SobolIndicesExperiment

# Register SobolIndicesExperiment in _simulation:
_simulation.SobolIndicesExperiment_swigregister(SobolIndicesExperiment)

class SimulationResult(openturns.common.PersistentObject):
    r"""
    EventSimulation result base class.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.EventSimulation`,
    and obtained thanks to the method getResult().
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationResult_getClassName(self)

    def getOuterSampling(self):
        r"""
        Accessor to the outer sampling.

        Returns
        -------
        outerSampling : int
            Number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationResult_getOuterSampling(self)

    def setOuterSampling(self, outerSampling):
        r"""
        Accessor to the outer sampling.

        Parameters
        ----------
        outerSampling : int, :math:`outerSampling \geq 0`
            Number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationResult_setOuterSampling(self, outerSampling)

    def getBlockSize(self):
        r"""
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
        """
        return _simulation.SimulationResult_getBlockSize(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 0`
            Number of terms in the probability simulation estimator grouped together.
        """
        return _simulation.SimulationResult_setBlockSize(self, blockSize)

    def __repr__(self):
        return _simulation.SimulationResult___repr__(self)

    def __init__(self, *args):
        _simulation.SimulationResult_swiginit(self, _simulation.new_SimulationResult(*args))
    __swig_destroy__ = _simulation.delete_SimulationResult

# Register SimulationResult in _simulation:
_simulation.SimulationResult_swigregister(SimulationResult)

class ProbabilitySimulationResult(SimulationResult):
    r"""
    Probability simulation result.

    Notes
    -----
    Structure created by the method run() of a :class:`~openturns.EventSimulation`,
    and obtained thanks to the method getResult().

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> limitState = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3.*E*I)'])
    >>> # Enable the history mecanism in order to use the getImportanceFactors method
    >>> limitState = ot.MemoizeFunction(limitState)
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> output = ot.CompositeRandomVector(limitState, ot.RandomVector(myDistribution))
    >>> myEvent = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> myLHS = ot.LHS(myEvent)
    >>> myLHS.run()
    >>> SimulationLHSResult = myLHS.getResult()
    >>> print(SimulationLHSResult.getImportanceFactors())
    [X0 : 0.000722617, X1 : 0.635094, X2 : 0.275692, X3 : 0.0884917]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ProbabilitySimulationResult_getClassName(self)

    def getEvent(self):
        r"""
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _simulation.ProbabilitySimulationResult_getEvent(self)

    def setEvent(self, event):
        r"""
        Accessor to the event.

        Parameters
        ----------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _simulation.ProbabilitySimulationResult_setEvent(self, event)

    def getProbabilityEstimate(self):
        r"""
        Accessor to the probability estimate.

        Returns
        -------
        probaEstimate : float
            Estimate of the event probability.
        """
        return _simulation.ProbabilitySimulationResult_getProbabilityEstimate(self)

    def setProbabilityEstimate(self, probabilityEstimate):
        r"""
        Accessor to the probability estimate.

        Parameters
        ----------
        probaEstimate : float, :math:`0 \leq P_e \leq 1`
            Estimate of the event probability.
        """
        return _simulation.ProbabilitySimulationResult_setProbabilityEstimate(self, probabilityEstimate)

    def getVarianceEstimate(self):
        r"""
        Accessor to the variance estimate.

        Returns
        -------
        varianceEstimate : float
            Variance estimate.
        """
        return _simulation.ProbabilitySimulationResult_getVarianceEstimate(self)

    def setVarianceEstimate(self, varianceEstimate):
        r"""
        Accessor to the variance estimate.

        Parameters
        ----------
        varianceEstimate : float, :math:`Var_e \geq 0`
            Variance estimate.
        """
        return _simulation.ProbabilitySimulationResult_setVarianceEstimate(self, varianceEstimate)

    def getProbabilityDistribution(self):
        r"""
        Accessor to the asymptotic probability distribution.

        Returns
        -------
        probaDistribution : :class:`~openturns.Normal`
            Asymptotic normal distribution of the event probability estimate.
        """
        return _simulation.ProbabilitySimulationResult_getProbabilityDistribution(self)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.ProbabilitySimulationResult_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the standard deviation.

        Returns
        -------
        sigma : float
            Standard deviation of the estimator at the end of the simulation.
        """
        return _simulation.ProbabilitySimulationResult_getStandardDeviation(self)

    def getMeanPointInEventDomain(self):
        r"""
        Accessor to the mean point conditioned to the event realization.

        Returns
        -------
        meanPoint : :class:`~openturns.Point`
            Mean point in the physical space of all the simulations generated by the
            :class:`~openturns.EventSimulation` algorithm that failed into the event domain.

        Notes
        -----
        .. warning::
            This notion is only available if the history mecanism of the model is
            activated (see :class:`~openturns.MemoizeFunction`).
        """
        return _simulation.ProbabilitySimulationResult_getMeanPointInEventDomain(self)

    def getImportanceFactors(self):
        r"""
        Accessor to the importance factors.

        Returns
        -------
        importanceFactors : :class:`~openturns.PointWithDescription`
            Sequence containing the importance factors with a description for each
            component.

        Notes
        -----
        The importance factors :math:`\alpha_i` are evaluated from the coordinates of
        the mean point of event domain :math:`\vect{X}^*_{event}`, mapped into the
        standard space as follows:

        .. math::

          \alpha_i = \displaystyle \frac{\left(U_{i}^*\right)^2}{||\vect{U}^*||^2}

        where :math:`\vect{U}^* = T(\vect{X}^*_{event})`
        with :math:`T` the iso-probabilistic transformation and the mean point
        :math:`\vect{X}^*_{event} = \displaystyle \frac{1}{n} \sum_{i=1}^{n} \vect{X}_i 1_{event}(\vect{X}_i)`.

        .. warning::
            This notion is only available if the history mecanism of the model is
            activated (see :class:`~openturns.MemoizeFunction`).

        See also
        --------
        drawImportanceFactors
        """
        return _simulation.ProbabilitySimulationResult_getImportanceFactors(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        .. warning::
            It is necessary to enable the history of the model to perform this analysis
            (see :class:`~openturns.MemoizeFunction`).

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Importance factor graph.

        See also
        --------
        getImportanceFactors
        """
        return _simulation.ProbabilitySimulationResult_drawImportanceFactors(self)

    def getConfidenceLength(self, *args):
        r"""
        Accessor to the confidence length.

        Parameters
        ----------
        level : float, :math:`level \in ]0, 1[`
            Confidence level. By default, it is :math:`0.95`.

        Returns
        -------
        confidenceLength : float
            Length of the confidence interval at the confidence level *level*.
        """
        return _simulation.ProbabilitySimulationResult_getConfidenceLength(self, *args)

    def __repr__(self):
        return _simulation.ProbabilitySimulationResult___repr__(self)

    def __init__(self, *args):
        _simulation.ProbabilitySimulationResult_swiginit(self, _simulation.new_ProbabilitySimulationResult(*args))
    __swig_destroy__ = _simulation.delete_ProbabilitySimulationResult

# Register ProbabilitySimulationResult in _simulation:
_simulation.ProbabilitySimulationResult_swigregister(ProbabilitySimulationResult)

class SimulationAlgorithm(openturns.common.PersistentObject):
    r"""
    Base class for simulation algorithms.

    See also
    --------
    ProbabilitySimulationAlgorithm, ExpectationSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationAlgorithm_getClassName(self)

    def setMaximumOuterSampling(self, maximumOuterSampling):
        r"""
        Accessor to the maximum sample size.

        Parameters
        ----------
        outerSampling : int
            Maximum number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationAlgorithm_setMaximumOuterSampling(self, maximumOuterSampling)

    def getMaximumOuterSampling(self):
        r"""
        Accessor to the maximum sample size.

        Returns
        -------
        outerSampling : int
            Maximum number of groups of terms in the probability simulation estimator.
        """
        return _simulation.SimulationAlgorithm_getMaximumOuterSampling(self)

    def setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation):
        r"""
        Accessor to the maximum coefficient of variation.

        Parameters
        ----------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _simulation.SimulationAlgorithm_setMaximumCoefficientOfVariation(self, maximumCoefficientOfVariation)

    def getMaximumCoefficientOfVariation(self):
        r"""
        Accessor to the maximum coefficient of variation.

        Returns
        -------
        coefficient : float
            Maximum coefficient of variation of the simulated sample.
        """
        return _simulation.SimulationAlgorithm_getMaximumCoefficientOfVariation(self)

    def setMaximumStandardDeviation(self, maximumStandardDeviation):
        r"""
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigma : float, :math:`\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _simulation.SimulationAlgorithm_setMaximumStandardDeviation(self, maximumStandardDeviation)

    def getMaximumStandardDeviation(self):
        r"""
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigma : float, :math:`\sigma > 0`
            Maximum standard deviation of the estimator.
        """
        return _simulation.SimulationAlgorithm_getMaximumStandardDeviation(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 1`
            Number of terms in the probability simulation estimator grouped together.
            It is set by default to 1.

        Notes
        -----
        For Monte Carlo, LHS and Importance Sampling methods, this allows to save space
        while allowing multithreading, when available we recommend
        to use the number of available CPUs; for the Directional Sampling, we recommend
        to set it to 1.
        """
        return _simulation.SimulationAlgorithm_setBlockSize(self, blockSize)

    def getBlockSize(self):
        r"""
        Accessor to the block size.

        Returns
        -------
        blockSize : int
            Number of terms in the probability simulation estimator grouped together.
            It is set by default to 1.
        """
        return _simulation.SimulationAlgorithm_getBlockSize(self)

    def setVerbose(self, verbose):
        r"""
        Accessor to verbosity.

        Parameters
        ----------
        verbosity_enabled : bool
            If *True*, make the computation verbose. By default it is verbose.
        """
        return _simulation.SimulationAlgorithm_setVerbose(self, verbose)

    def getVerbose(self):
        r"""
        Accessor to verbosity.

        Returns
        -------
        verbosity_enabled : bool
            If *True*, the computation is verbose. By default it is verbose.
        """
        return _simulation.SimulationAlgorithm_getVerbose(self)

    def __repr__(self):
        return _simulation.SimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.SimulationAlgorithm_run(self)

    def setConvergenceStrategy(self, convergenceStrategy):
        r"""
        Accessor to the convergence strategy.

        Parameters
        ----------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _simulation.SimulationAlgorithm_setConvergenceStrategy(self, convergenceStrategy)

    def getConvergenceStrategy(self):
        r"""
        Accessor to the convergence strategy.

        Returns
        -------
        storage_strategy : :class:`~openturns.HistoryStrategy`
            Storage strategy used to store the values of the probability estimator
            and its variance during the simulation algorithm.
        """
        return _simulation.SimulationAlgorithm_getConvergenceStrategy(self)

    def __init__(self, *args):
        _simulation.SimulationAlgorithm_swiginit(self, _simulation.new_SimulationAlgorithm(*args))

    def setProgressCallback(self, *args):
        r"""
        Set up a progress callback.

        Can be used to programmatically report the progress of a simulation.

        Parameters
        ----------
        callback : callable
            Takes a float as argument as percentage of progress.

        Examples
        --------
        >>> import sys
        >>> import openturns as ot
        >>> experiment = ot.MonteCarloExperiment()
        >>> X = ot.RandomVector(ot.Normal())
        >>> Y = ot.CompositeRandomVector(ot.SymbolicFunction(['X'], ['1.1*X']), X)
        >>> event = ot.ThresholdEvent(Y, ot.Less(), -2.0)
        >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
        >>> algo.setMaximumOuterSampling(100)
        >>> algo.setMaximumCoefficientOfVariation(-1.0)
        >>> def report_progress(progress):
        ...     sys.stderr.write('-- progress=' + str(progress) + '%\n')
        >>> algo.setProgressCallback(report_progress)
        >>> algo.run()
        """
        return _simulation.SimulationAlgorithm_setProgressCallback(self, *args)

    def setStopCallback(self, *args):
        r"""
        Set up a stop callback.

        Can be used to programmatically stop a simulation.

        Parameters
        ----------
        callback : callable
            Returns an int deciding whether to stop or continue.

        Examples
        --------
        Stop a Monte Carlo simulation algorithm using a time limit

        >>> import openturns as ot
        >>> experiment = ot.MonteCarloExperiment()
        >>> X = ot.RandomVector(ot.Normal())
        >>> Y = ot.CompositeRandomVector(ot.SymbolicFunction(['X'], ['1.1*X']), X)
        >>> event = ot.ThresholdEvent(Y, ot.Less(), -2.0)
        >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
        >>> algo.setMaximumOuterSampling(10000000)
        >>> algo.setMaximumCoefficientOfVariation(-1.0)
        >>> timer = ot.TimerCallback(0.1)
        >>> algo.setStopCallback(timer)
        >>> algo.run()
        """
        return _simulation.SimulationAlgorithm_setStopCallback(self, *args)
    __swig_destroy__ = _simulation.delete_SimulationAlgorithm

# Register SimulationAlgorithm in _simulation:
_simulation.SimulationAlgorithm_swigregister(SimulationAlgorithm)


def TimerCallback(duration):
    """
    Time stopping criterion.

    Usable as stopping callback for simulation, optimization algorithms.

    Parameters
    ----------
    duration : float
        Maximum duration in seconds of the algorithm.

    Examples
    --------
    >>> import openturns as ot
    >>> model = ot.SymbolicFunction(['R', 'S'], ['R-S'])
    >>> distribution = ot.Normal(2)
    >>> vect = ot.RandomVector(distribution)
    >>> output = ot.CompositeRandomVector(model, vect)
    >>> event = ot.ThresholdEvent(output, ot.Less(), 0.0)
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(int(1e9))
    >>> algo.setMaximumCoefficientOfVariation(-1.0)
    >>> timer = TimerCallback(1.5)
    >>> algo.setStopCallback(timer)
    >>> algo.run()
    """
    from time import time
    try:
        float(duration)
    except ValueError:
        raise ValueError('duration must be a float')
    tmax = time() + duration
    def inner():
        if not hasattr(inner, 'tmax'):
            inner.tmax = tmax
        stop = time() > inner.tmax
        return stop
    return inner

class EventSimulation(SimulationAlgorithm):
    r"""
    Base class for sampling methods.

    Available constructor:
        EventSimulation(*event, verbose=True, convergenceStrategy=ot.Compact()*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        The event we are computing the probability of.
    verbose : bool
        If *True*, make the computation verbose.
    convergenceStrategy : :class:`~openturns.HistoryStrategy`
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Base class for sampling methods, using the probability distribution of a random
    vector :math:`\vect{X}` to evaluate the failure probability:

    .. math::

        P_f = \int_{\Rset^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \leq 0 \}}f_{\uX}(\ux)\di{\ux}
            = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\}`.
    :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise.

    The EventSimulation object provides a generic simulation service for non-composite
    events, and its derived classes provide dedicated algorithms:

    - :class:`~openturns.ProbabilitySimulationAlgorithm`

    - :class:`~openturns.DirectionalSampling`

    - :class:`~openturns.LHS`,

    - :class:`~openturns.PostAnalyticalControlledImportanceSampling`,

    - :class:`~openturns.PostAnalyticalImportanceSampling`,

    See also
    --------
    SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.EventSimulation_getClassName(self)

    def getEvent(self):
        r"""
        Accessor to the event.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Event we want to evaluate the probability.
        """
        return _simulation.EventSimulation_getEvent(self)

    def getResult(self):
        r"""
        Accessor to the results.

        Returns
        -------
        results : :class:`~openturns.SimulationResult`
            Structure containing all the results obtained after simulation and created
            by the method :py:meth:`run`.
        """
        return _simulation.EventSimulation_getResult(self)

    def __repr__(self):
        return _simulation.EventSimulation___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.EventSimulation_run(self)

    def drawProbabilityConvergence(self, *args):
        r"""
        Draw the probability convergence at a given level.

        Parameters
        ----------
        level : float, optional
            The probability convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            probability convergence graph
        """
        return _simulation.EventSimulation_drawProbabilityConvergence(self, *args)

    def __init__(self, *args):
        _simulation.EventSimulation_swiginit(self, _simulation.new_EventSimulation(*args))
    __swig_destroy__ = _simulation.delete_EventSimulation

# Register EventSimulation in _simulation:
_simulation.EventSimulation_swigregister(EventSimulation)

class ProbabilitySimulationAlgorithm(EventSimulation):
    r"""
    Iterative sampling methods.

    Refer to :ref:`monte_carlo_simulation`, :ref:`importance_simulation`, :ref:`lhs_simulation`, :ref:`qmc_simulation`.

    Available constructor:
        ProbabilitySimulationAlgorithm(*event, experiment, verbose=True, convergenceStrategy=ot.Compact()*)

        ProbabilitySimulationAlgorithm(*event, verbose=True, convergenceStrategy=ot.Compact()*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        The event we are computing the probability of, must be composite.
    experiment : :class:`~openturns.WeightedExperiment`
        Sequential experiment
    verbose : bool, optional
        If *True*, make the computation verbose.
    convergenceStrategy : :class:`~openturns.HistoryStrategy`, optional
        Storage strategy used to store the values of the probability estimator and
        its variance during the simulation algorithm.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event 

    .. math::

        \cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\} 

    If we have the set :math:`\left\{ \vect{x}_1,\ldots,\vect{x}_N \right\}` of
    :math:`N` independent samples of the random vector :math:`\vect{X}`, we can
    estimate :math:`\widehat{P}_f` as follows:

    .. math::

        \widehat{P}_{f,MC} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }

    where :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\vect{X}`, for which the event
    :math:`\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \lim_{N\rightarrow\infty}\Prob{P_f\in[\widehat{P}_{f,\inf},\widehat{P}_{f,\sup}]}=\alpha

    with :math:`\widehat{P}_{f,\inf}=\widehat{P}_f - q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`,
    :math:`\widehat{P}_{f,\sup}=\widehat{P}_f + q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`
    and :math:`q_\alpha` is the :math:`(1+\alpha)/2`-quantile of the standard
    normal distribution.


    A ProbabilitySimulationAlgorithm object makes sense with the following sequential experiments:

    - :class:`~openturns.MonteCarloExperiment`

    - :class:`~openturns.ImportanceSamplingExperiment`

    - :class:`~openturns.LowDiscrepancyExperiment`

    - :class:`~openturns.LHSExperiment` (for the non randomized version see :class:`~openturns.LHS`)

    The estimator built by Monte Carlo method is:

    .. math::

        \widehat{P}_{f,MC} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }

    where :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise;
    the idea here is in fact to estimate the required probability by the proportion
    of cases, among the :math:`N` samples of :math:`\vect{X}`, for which the event
    :math:`\cD_f` occurs.

    By the law of large numbers, we know that this estimation converges to the
    required value :math:`P_f` as the sample size :math:`N` tends to infinity.

    The Central Limit Theorem allows to build an asymptotic confidence interval
    using the normal limit distribution as follows:

    .. math::

        \lim_{N\rightarrow\infty}\Prob{P_f\in[\widehat{P}_{f,\inf},\widehat{P}_{f,\sup}]}=\alpha

    with :math:`\widehat{P}_{f,\inf}=\widehat{P}_f - q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`,
    :math:`\widehat{P}_{f,\sup}=\widehat{P}_f + q_{\alpha}\sqrt{\frac{\widehat{P}_f(1-\widehat{P}_f)}{N}}`
    and :math:`q_\alpha` is the :math:`(1+\alpha)/2`-quantile of the standard
    normal distribution.

    The estimator built by Importance Sampling method is:

    .. math::

        \widehat{P}_{f,IS} = \frac{1}{N}
                             \sum_{i=1}^N \mathbf{1}_{\{g(\vect{Y}_{\:i}),\vect{d}) \leq 0 \}}
                                          \frac{f_{\uX}(\vect{Y}_{\:i})}
                                               {f_{\vect{Y}}(\vect{Y}_{\:i})}


    where:

    - :math:`N` is the total number of computations,

    - the random vectors :math:`\{\vect{Y}_i, i=1\hdots N\}` are independent,
      identically distributed and following the probability density function
      :math:`f_{\uY}`.


    See also
    --------
    EventSimulation

    Examples
    --------
    Estimate a probability by Monte Carlo

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> event = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> # We create a Monte Carlo algorithm
    >>> experiment = ot.MonteCarloExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000

    Estimate a probability by Importance Sampling

    >>> ot.RandomGenerator.SetSeed(0)
    >>> # assume we obtained a design point from FORM
    >>> standardSpaceDesignPoint = [-0.0310363,0.841879,0.445462,-0.332318]
    >>> standardEvent = ot.StandardEvent(event)
    >>> importanceDensity = ot.Normal(standardSpaceDesignPoint, ot.CovarianceMatrix(4))
    >>> experiment = ot.ImportanceSamplingExperiment(importanceDensity)
    >>> algo = ot.ProbabilitySimulationAlgorithm(standardEvent, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.153315

    Estimate a probability by Quasi Monte Carlo

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LowDiscrepancyExperiment()
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.141667

    Estimate a probability by Randomized Quasi Monte Carlo

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LowDiscrepancyExperiment()
    >>> experiment.setRandomize(True)
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.160000

    Estimate a probability by Randomized LHS

    >>> ot.RandomGenerator.SetSeed(0)
    >>> experiment = ot.LHSExperiment()
    >>> experiment.setAlwaysShuffle(True)
    >>> algo = ot.ProbabilitySimulationAlgorithm(event, experiment)
    >>> algo.setMaximumOuterSampling(150)
    >>> algo.setBlockSize(4)
    >>> algo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> algo.run()
    >>> print('Probability estimate=%.6f' % algo.getResult().getProbabilityEstimate())
    Probability estimate=0.140000
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ProbabilitySimulationAlgorithm_getClassName(self)

    def getExperiment(self):
        r"""
        Accessor to the experiment.

        Returns
        -------
        experiment : :class:`~openturns.WeightedExperiment`
            The experiment that is sampled at each iteration.
        """
        return _simulation.ProbabilitySimulationAlgorithm_getExperiment(self)

    def setExperiment(self, experiment):
        r"""
        Accessor to the experiment.

        Parameters
        ----------
        experiment : :class:`~openturns.WeightedExperiment`
            The experiment that is sampled at each iteration.
        """
        return _simulation.ProbabilitySimulationAlgorithm_setExperiment(self, experiment)

    def __repr__(self):
        return _simulation.ProbabilitySimulationAlgorithm___repr__(self)

    def setBlockSize(self, blockSize):
        r"""
        Accessor to the block size.

        Parameters
        ----------
        blockSize : int, :math:`blockSize \geq 1`
            Number of terms in the probability simulation estimator grouped together.
            It is set by default to 1.

        Notes
        -----
        For Monte Carlo, LHS and Importance Sampling methods, this allows to save space
        while allowing multithreading, when available we recommend
        to use the number of available CPUs; for the Directional Sampling, we recommend
        to set it to 1.
        """
        return _simulation.ProbabilitySimulationAlgorithm_setBlockSize(self, blockSize)

    def __init__(self, *args):
        _simulation.ProbabilitySimulationAlgorithm_swiginit(self, _simulation.new_ProbabilitySimulationAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_ProbabilitySimulationAlgorithm

# Register ProbabilitySimulationAlgorithm in _simulation:
_simulation.ProbabilitySimulationAlgorithm_swigregister(ProbabilitySimulationAlgorithm)

class PostAnalyticalSimulation(EventSimulation):
    r"""
    Post analytical simulation.

    See also
    --------
    PostAnalyticalImportanceSampling, PostAnalyticalControlledImportanceSampling

    Notes
    -----
    This class inherits from EventSimulation.

    The principle is to perform a simulation study to evaluate the threshold
    exceedance probability according to an importance density centered around the
    design point, in the standard space. The importance distribution is the standard
    distribution of the standard space.

    A PostAnalyticalSimulation object can be created only through its derivative
    classes : :class:`~openturns.PostAnalyticalImportanceSampling` or
    :class:`~openturns.PostAnalyticalControlledImportanceSampling`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalSimulation_getClassName(self)

    def getAnalyticalResult(self):
        r"""
        Accessor to the analytical result.

        Returns
        -------
        result : :class:`~openturns.AnalyticalResult`
            Result of the analytical study which has been performed just before the 
            simulation study centered around the importance factor.
        """
        return _simulation.PostAnalyticalSimulation_getAnalyticalResult(self)

    def getControlProbability(self):
        return _simulation.PostAnalyticalSimulation_getControlProbability(self)

    def __repr__(self):
        return _simulation.PostAnalyticalSimulation___repr__(self)

    def __init__(self, *args):
        _simulation.PostAnalyticalSimulation_swiginit(self, _simulation.new_PostAnalyticalSimulation(*args))
    __swig_destroy__ = _simulation.delete_PostAnalyticalSimulation

# Register PostAnalyticalSimulation in _simulation:
_simulation.PostAnalyticalSimulation_swigregister(PostAnalyticalSimulation)

class Wilks(openturns.common.Object):
    r"""
    Class to evaluate the Wilks number.

    Refer to :ref:`quantile_estimation_wilks`.

    Parameters
    ----------
    randomVector : :class:`~openturns.RandomVector` of dimension 1
        Output variable of interest.

    Notes
    -----
    This class is a static class which enables the evaluation of the Wilks number:
    the minimal sample size :math:`N_{\alpha, \beta, i}` to perform in order to
    guarantee that the empirical quantile :math:`\alpha`, noted
    :math:`\tilde{q}_{\alpha} N_{\alpha, \beta, i}` evaluated with the
    :math:`(n - i)^{th}` maximum of the sample, noted :math:`X_{n - i}` be greater
    than the theoretical quantile :math:`q_{\alpha}` with a probability at least
    :math:`\beta`:

    .. math::

        \Pset (\tilde{q}_{\alpha} N_{\alpha, \beta, i} > q_{\alpha}) > \beta

    where :math:`\tilde{q}_{\alpha} N_{\alpha, \beta, i} = X_{n-i}`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex=0):
        r"""
        Evaluate the size of the sample.

        Parameters
        ----------
        alpha : positive float :math:`< 1`
            The order of the quantile we want to evaluate.
        beta : positive float :math:`< 1`
            Confidence on the evaluation of the empirical quantile.
        i : int
            Rank of the maximum which will evaluate the empirical quantile. Default
            :math:`i = 0` (maximum of the sample)

        Returns
        -------
        w : int
            the Wilks number.
        """
        return _simulation.Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex)

    def computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex=0):
        r"""
        Evaluate the bound of the quantile.

        Parameters
        ----------
        alpha : positive float :math:`< 1`
            The order of the quantile we want to evaluate.
        beta : positive float :math:`< 1`
            Confidence on the evaluation of the empirical quantile.
        i : int
            Rank of the maximum which will evaluate the empirical quantile. Default
            :math:`i = 0` (maximum of the sample)

        Returns
        -------
        q : :class:`~openturns.Point`
            The estimate of the quantile upper bound for the given quantile level, at
            the given confidence level and using the given upper statistics.
        """
        return _simulation.Wilks_computeQuantileBound(self, quantileLevel, confidenceLevel, marginIndex)

    def __init__(self, *args):
        _simulation.Wilks_swiginit(self, _simulation.new_Wilks(*args))
    __swig_destroy__ = _simulation.delete_Wilks

# Register Wilks in _simulation:
_simulation.Wilks_swigregister(Wilks)

def Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex=0):
    r"""
    Evaluate the size of the sample.

    Parameters
    ----------
    alpha : positive float :math:`< 1`
        The order of the quantile we want to evaluate.
    beta : positive float :math:`< 1`
        Confidence on the evaluation of the empirical quantile.
    i : int
        Rank of the maximum which will evaluate the empirical quantile. Default
        :math:`i = 0` (maximum of the sample)

    Returns
    -------
    w : int
        the Wilks number.
    """
    return _simulation.Wilks_ComputeSampleSize(quantileLevel, confidenceLevel, marginIndex)

class LHS(EventSimulation):
    r"""
    Latin Hypercube Sampling (LHS) method.

    Available constructors:
        LHS(*event=ot.Event()*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \int_{\Rset^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \leq 0 \}}f_{\uX}(\ux)\di{\ux}
            = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\}`.
    :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise.

    LHS or Latin Hypercube Sampling is a sampling method enabling to better cover
    the domain of variations of the input variables, thanks to a stratified
    sampling strategy. This method is applicable in the case of independent input
    variables. The sampling procedure is based on dividing the range of each
    variable into several intervals of equal probability. The sampling is
    undertaken as follows:

    - Step 1: The range of each input variable is stratified into isoprobabilistic
      cells,

    - Step 2: A cell is uniformly chosen among all the available cells,

    - Step 3: The random number is obtained by inverting the Cumulative Density
      Function locally in the chosen cell,

    - Step 4: All the cells having a common strate with the previous cell are put
      apart from the list of available cells.

    The estimator of the probability of failure with LHS is given by:

    .. math::

        \widehat{P}_{f,LHS} = \frac{1}{N}
                              \sum_{i=1}^N \mathbf{1}_{\{g(\uX^i,\vect{d}) \leq 0 \}}

    where the sample of :math:`\{ \uX^i,i=1 \hdots N \}` is obtained as described
    previously.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> myEvent = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> # We create a LHS algorithm
    >>> myAlgo = ot.LHS(myEvent)
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.151667
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.LHS_getClassName(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.LHS_run(self)

    def __repr__(self):
        return _simulation.LHS___repr__(self)

    def __init__(self, *args):
        _simulation.LHS_swiginit(self, _simulation.new_LHS(*args))
    __swig_destroy__ = _simulation.delete_LHS

# Register LHS in _simulation:
_simulation.LHS_swigregister(LHS)

class PostAnalyticalControlledImportanceSampling(PostAnalyticalSimulation):
    r"""
    Post analytical controlled importance sampling.

    Simulation method where the original distribution is replaced by the
    distribution in the standard space centered around the provided design point
    and is controlled by the value of the linearized limit state function.

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result which contains the whole information on the analytical study
        performed before the simulation study: in particular, the standard
        distribution of the standard space and the standard space design point.

    See also
    --------
    PostAnalyticalImportanceSampling

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> X = ot.RandomVector(distribution)
    >>> Y = ot.CompositeRandomVector(f, X)
    >>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)
    >>> solver = ot.AbdoRackwitz()
    >>> analytical = ot.FORM(solver, event, [50.0, 1.0, 10.0, 5.0])
    >>> analytical.run()
    >>> analyticalResult = analytical.getResult()
    >>> algo = ot.PostAnalyticalControlledImportanceSampling(analyticalResult)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> pf = result.getProbabilityEstimate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalControlledImportanceSampling_getClassName(self)

    def __repr__(self):
        return _simulation.PostAnalyticalControlledImportanceSampling___repr__(self)

    def computeBlockSample(self):
        return _simulation.PostAnalyticalControlledImportanceSampling_computeBlockSample(self)

    def __init__(self, *args):
        _simulation.PostAnalyticalControlledImportanceSampling_swiginit(self, _simulation.new_PostAnalyticalControlledImportanceSampling(*args))
    __swig_destroy__ = _simulation.delete_PostAnalyticalControlledImportanceSampling

# Register PostAnalyticalControlledImportanceSampling in _simulation:
_simulation.PostAnalyticalControlledImportanceSampling_swigregister(PostAnalyticalControlledImportanceSampling)

class PostAnalyticalImportanceSampling(PostAnalyticalSimulation):
    r"""
    Post analytical importance sampling.

    Simulation method where the original distribution is replaced by the
    distribution in the standard space centered around the provided design point.

    Parameters
    ----------
    analyticalResult : :class:`~openturns.AnalyticalResult`
        Result which contains the whole information on the analytical study
        performed before the simulation study: in particular, the standard
        distribution of the standard space and the standard space design point.

    See also
    --------
    PostAnalyticalControlledImportanceSampling

    Examples
    --------
    >>> import openturns as ot
    >>> f = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> X = ot.RandomVector(distribution)
    >>> Y = ot.CompositeRandomVector(f, X)
    >>> event = ot.ThresholdEvent(Y, ot.Less(), -3.0)
    >>> solver = ot.AbdoRackwitz()
    >>> analytical = ot.FORM(solver, event, [50.0, 1.0, 10.0, 5.0])
    >>> analytical.run()
    >>> analyticalResult = analytical.getResult()
    >>> algo = ot.PostAnalyticalImportanceSampling(analyticalResult)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> pf = result.getProbabilityEstimate()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.PostAnalyticalImportanceSampling_getClassName(self)

    def __repr__(self):
        return _simulation.PostAnalyticalImportanceSampling___repr__(self)

    def __init__(self, *args):
        _simulation.PostAnalyticalImportanceSampling_swiginit(self, _simulation.new_PostAnalyticalImportanceSampling(*args))
    __swig_destroy__ = _simulation.delete_PostAnalyticalImportanceSampling

# Register PostAnalyticalImportanceSampling in _simulation:
_simulation.PostAnalyticalImportanceSampling_swigregister(PostAnalyticalImportanceSampling)

class RootStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RootStrategyImplementation_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RootStrategyImplementation_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementation_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementation_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementation_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementation_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementation_getOriginValue(self)

    def __repr__(self):
        return _simulation.RootStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _simulation.RootStrategyImplementation_swiginit(self, _simulation.new_RootStrategyImplementation(*args))
    __swig_destroy__ = _simulation.delete_RootStrategyImplementation

# Register RootStrategyImplementation in _simulation:
_simulation.RootStrategyImplementation_swigregister(RootStrategyImplementation)

class RootStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _simulation.RootStrategyImplementationTypedInterfaceObject_swiginit(self, _simulation.new_RootStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _simulation.RootStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.RootStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.RootStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _simulation.RootStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _simulation.RootStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _simulation.delete_RootStrategyImplementationTypedInterfaceObject

# Register RootStrategyImplementationTypedInterfaceObject in _simulation:
_simulation.RootStrategyImplementationTypedInterfaceObject_swigregister(RootStrategyImplementationTypedInterfaceObject)

class RootStrategy(RootStrategyImplementationTypedInterfaceObject):
    r"""
    Base class for root strategies.

    *RootStrategy* is used through its derived classes:

    - :class:`~openturns.SafeAndSlow`

    - :class:`~openturns.RiskyAndFast`

    - :class:`~openturns.MediumSafe`

    See also
    --------
    DirectionalSampling
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RootStrategy_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RootStrategy_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategy_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategy_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategy_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategy_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategy_getOriginValue(self)

    def __repr__(self):
        return _simulation.RootStrategy___repr__(self)

    def __init__(self, *args):
        _simulation.RootStrategy_swiginit(self, _simulation.new_RootStrategy(*args))
    __swig_destroy__ = _simulation.delete_RootStrategy

# Register RootStrategy in _simulation:
_simulation.RootStrategy_swigregister(RootStrategy)

class SamplingStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Base class for sampling strategies.

    Available constructor:
        SamplingStrategyImplementation()

        SamplingStrategyImplementation(*samplingStratImp*)

        SamplingStrategyImplementation(*dimension*)

    Parameters
    ----------
    samplingStratImp : SamplingStrategyImplementationImplementation
        An implementation of the sampling strategy adopted, which is
        :class:`~openturns.RandomDirection` or :class:`~openturns.OrthogonalDirection`.
    dimension : int
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SamplingStrategyImplementation_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _simulation.SamplingStrategyImplementation_generate(self)

    def getUniformUnitVectorRealization(self, *args):
        r"""
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _simulation.SamplingStrategyImplementation_getUniformUnitVectorRealization(self, *args)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementation_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementation_getDimension(self)

    def __repr__(self):
        return _simulation.SamplingStrategyImplementation___repr__(self)

    def __init__(self, *args):
        _simulation.SamplingStrategyImplementation_swiginit(self, _simulation.new_SamplingStrategyImplementation(*args))
    __swig_destroy__ = _simulation.delete_SamplingStrategyImplementation

# Register SamplingStrategyImplementation in _simulation:
_simulation.SamplingStrategyImplementation_swigregister(SamplingStrategyImplementation)

class SamplingStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _simulation.SamplingStrategyImplementationTypedInterfaceObject_swiginit(self, _simulation.new_SamplingStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _simulation.SamplingStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _simulation.delete_SamplingStrategyImplementationTypedInterfaceObject

# Register SamplingStrategyImplementationTypedInterfaceObject in _simulation:
_simulation.SamplingStrategyImplementationTypedInterfaceObject_swigregister(SamplingStrategyImplementationTypedInterfaceObject)

class SamplingStrategy(SamplingStrategyImplementationTypedInterfaceObject):
    r"""
    Base class for sampling strategies.

    Available constructor:
        SamplingStrategyImplementation()

        SamplingStrategyImplementation(*samplingStratImp*)

        SamplingStrategyImplementation(*dimension*)

    Parameters
    ----------
    samplingStratImp : SamplingStrategyImplementationImplementation
        An implementation of the sampling strategy adopted, which is
        :class:`~openturns.RandomDirection` or :class:`~openturns.OrthogonalDirection`.
    dimension : int
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    RandomDirection, OrthogonalDirection
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SamplingStrategy_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _simulation.SamplingStrategy_generate(self)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategy_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategy_getDimension(self)

    def __repr__(self):
        return _simulation.SamplingStrategy___repr__(self)

    def __init__(self, *args):
        _simulation.SamplingStrategy_swiginit(self, _simulation.new_SamplingStrategy(*args))
    __swig_destroy__ = _simulation.delete_SamplingStrategy

# Register SamplingStrategy in _simulation:
_simulation.SamplingStrategy_swigregister(SamplingStrategy)

class DirectionalSampling(EventSimulation):
    r"""
    Directional simulation.

    Refer to :ref:`directional_simulation`.

    Available constructors:
        DirectionalSampling(*event=ot.Event()*)

        DirectionalSampling(*event, rootStrategy, samplingStrategy*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`
        Strategy adopted to evaluate the intersections of each direction with the
        limit state function and take into account the contribution of the
        direction to the event probability. By default,
        *rootStrategy = ot.RootStrategy(ot.SafeAndSlow())*.
    samplingStrategy : :class:`~openturns.SamplingStrategy`
        Strategy adopted to sample directions. By default,
        *samplingStrategy=ot.SamplingStrategy(ot.RandomDirection())*.

    Notes
    -----
    Using the probability distribution of a random vector :math:`\vect{X}`, we seek
    to evaluate the following probability:

    .. math::

        P_f = \int_{\Rset^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \leq 0 \}}f_{\uX}(\ux)\di{\ux}
            = \Prob{g\left( \vect{X},\vect{d} \right) \leq 0}

    Here, :math:`\vect{X}` is a random vector, :math:`\vect{d}` a deterministic
    vector, :math:`g(\vect{X},\vect{d})` the function known as *limit state function*
    which enables the definition of the event
    :math:`\cD_f = \{\vect{X} \in \Rset^n \, | \, g(\vect{X},\vect{d}) \le 0\}`.
    :math:`\mathbf{1}_{ \left\{ g(\vect{x}_i,\vect{d}) \leq 0 \right\} }`
    describes the indicator function equal to 1 if
    :math:`g(\vect{x}_i,\vect{d}) \leq 0` and equal to 0 otherwise.

    The directional simulation method is an accelerated sampling method. It implies
    a preliminary iso-probabilistic transformation, as for :class:`~openturns.FORM`
    and :class:`~openturns.SORM` methods; however, it remains based on sampling and
    is thus not an approximation method.
    In the transformed space, the (transformed) uncertain variables :math:`\vect{U}`
    are independent standard gaussian variables (mean equal to zero and standard
    deviation equal to 1).

    Roughly speaking, each simulation of the directional simulation algorithm is
    made of three steps. For the :math:`i^\textrm{th}` iteration, these steps are
    the following:

    - Let :math:`\cS = \big\{ \vect{u} \big| ||\vect{u}|| = 1 \big\}`. A point
      :math:`P_i` is drawn randomly on :math:`\cS` according to an uniform
      distribution.

    - In the direction starting from the origin and passing through :math:`P_i`,
      solutions of the equation :math:`g(\vect{X},\vect{d}) = 0` (i.e. limits of
      :math:`\cD_f`) are searched. The set of values of :math:`\vect{u}` that
      belong to :math:`\cD_f` is deduced for these solutions: it is a subset
      :math:`I_i \subset \Rset`.

    - Then, one calculates the probability :math:`q_i = \Prob{ ||\vect{U}|| \in I_i }`.
      By property of independent standard variable, :math:`||\vect{U}||^2` is a
      random variable distributed according to a chi-square distribution, which
      makes the computation effortless.

    Finally, the estimate of the probability :math:`P_f` after :math:`N` simulations
    is the following:

    .. math::

        \widehat{P}_{f,DS} = \frac{1}{N} \sum_{i=1}^N q_i

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunction = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> myDistribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> # We create a 'usual' RandomVector from the Distribution
    >>> vect = ot.RandomVector(myDistribution)
    >>> # We create a composite random vector
    >>> output = ot.CompositeRandomVector(myFunction, vect)
    >>> # We create an Event from this RandomVector
    >>> myEvent = ot.ThresholdEvent(output, ot.Less(), -3.0)
    >>> # We create a DirectionalSampling algorithm
    >>> myAlgo = ot.DirectionalSampling(myEvent, ot.MediumSafe(), ot.OrthogonalDirection())
    >>> myAlgo.setMaximumOuterSampling(150)
    >>> myAlgo.setBlockSize(4)
    >>> myAlgo.setMaximumCoefficientOfVariation(0.1)
    >>> # Perform the simulation
    >>> myAlgo.run()
    >>> print('Probability estimate=%.6f' % myAlgo.getResult().getProbabilityEstimate())
    Probability estimate=0.169716
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.DirectionalSampling_getClassName(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.DirectionalSampling_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.DirectionalSampling_getRootStrategy(self)

    def setSamplingStrategy(self, samplingStrategy):
        r"""
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.DirectionalSampling_setSamplingStrategy(self, samplingStrategy)

    def getSamplingStrategy(self):
        r"""
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.DirectionalSampling_getSamplingStrategy(self)

    def __repr__(self):
        return _simulation.DirectionalSampling___repr__(self)

    def __init__(self, *args):
        _simulation.DirectionalSampling_swiginit(self, _simulation.new_DirectionalSampling(*args))
    __swig_destroy__ = _simulation.delete_DirectionalSampling

# Register DirectionalSampling in _simulation:
_simulation.DirectionalSampling_swigregister(DirectionalSampling)

class OrthogonalDirection(SamplingStrategyImplementation):
    r"""
    Sampling following the orthogonal direction strategy.

    Available constructor:
        OrthogonalDirection()

        OrthogonalDirection(*dimension, k*)

    Parameters
    ----------
    dimension : integer
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.
    k : int
        The number of elements in the linear combinations. By default,
        :math:`k = 1` but automatically updated by the calling class.

    See also
    --------
    RandomDirection

    Notes
    -----
    This strategy is parameterized by :math:`k \in \{1, \ldots, n\}`, where :math:`n` is
    the dimension of the input random vector :math:`\vect{X}`. We generate one
    direct orthonormalized basis :math:`(\vect{e}_1, \ldots, \vect{e}_n)` uniformly distributed in
    the set of direct orthonormal bases. We consider all the normalized linear
    combinations of :math:`k` vectors chosen within the :math:`n` vectors of the basis, where
    the coefficients of the linear combinations are in :math:`\{+1, -1\}`. This
    generates :math:`\binom{k}{n} 2^k` new vectors :math:`\vect{v}_i`. We sample according
    to all the directions defined by the vectors :math:`\vect{v}_i`.

    If :math:`k = 1`, we consider all the axes of the standard space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.OrthogonalDirection_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the orthogonal direction strategy.
        """
        return _simulation.OrthogonalDirection_generate(self)

    def __repr__(self):
        return _simulation.OrthogonalDirection___repr__(self)

    def getUniformOrientationRealization(self):
        return _simulation.OrthogonalDirection_getUniformOrientationRealization(self)

    def __init__(self, *args):
        _simulation.OrthogonalDirection_swiginit(self, _simulation.new_OrthogonalDirection(*args))
    __swig_destroy__ = _simulation.delete_OrthogonalDirection

# Register OrthogonalDirection in _simulation:
_simulation.OrthogonalDirection_swigregister(OrthogonalDirection)

class RandomDirection(SamplingStrategyImplementation):
    r"""
    Sampling following the random direction strategy.

    Available constructor:
        RandomDirection()

        RandomDirection(*dimension*)

    Parameters
    ----------
    dimension : integer
        The dimension of the standard space. By default, :math:`dimension = 0` but
        automatically updated by the calling class.

    See also
    --------
    OrthogonalDirection

    Notes
    -----
    The RandomDirection strategy is the following : we generate some points on the
    sphere unity in the standard space according to the uniform distribution and we
    consider both opposite directions so built.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RandomDirection_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated in two opposite random directions.
        """
        return _simulation.RandomDirection_generate(self)

    def __repr__(self):
        return _simulation.RandomDirection___repr__(self)

    def __init__(self, *args):
        _simulation.RandomDirection_swiginit(self, _simulation.new_RandomDirection(*args))
    __swig_destroy__ = _simulation.delete_RandomDirection

# Register RandomDirection in _simulation:
_simulation.RandomDirection_swigregister(RandomDirection)

class MediumSafe(RootStrategyImplementation):
    r"""
    MediumSafe method.

    Available constructors:
        MediumSafe(*solver=ot.Brent()*)

        MediumSafe(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *MediumSafe* strategy is the following: for each direction, we go along the
    direction by step of length *stepSize* from the origin to the maximum distant
    point (at distance *maximumDistance* from the center of the standard space) and
    we check whether there is a sign changement on each segment so formed.

    At the first sign changement, we research one root in the concerned segment
    with the selected non linear solver. Then, the segment
    *[root, maximum distant point]* is considered within the failure space.

    If *stepSize* is small enough, this strategy guarantees us to find the root which
    is the nearest from the origin.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.MediumSafe_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.MediumSafe_solve(self, function, value)

    def __repr__(self):
        return _simulation.MediumSafe___repr__(self)

    def __init__(self, *args):
        _simulation.MediumSafe_swiginit(self, _simulation.new_MediumSafe(*args))
    __swig_destroy__ = _simulation.delete_MediumSafe

# Register MediumSafe in _simulation:
_simulation.MediumSafe_swigregister(MediumSafe)

class RiskyAndFast(RootStrategyImplementation):
    r"""
    RiskyAndFast method.

    Available constructors:
        RiskyAndFast(*solver=ot.Brent()*)

        RiskyAndFast(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *RiskyAndFast* strategy is the following: for each direction, we check
    whether there is a sign changement of the standard limit state function between
    the maximum distant point (at distance *maximumDistance* from the center of the
    standard space) and the center of the standard space.

    In case of sign changement, we search one root in the segment
    *[origin, maximum distant point]* with the selected non linear solver.

    As soon as founded, the segment *[root, infinity point]* is considered within
    the failure space.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RiskyAndFast_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RiskyAndFast_solve(self, function, value)

    def __repr__(self):
        return _simulation.RiskyAndFast___repr__(self)

    def __init__(self, *args):
        _simulation.RiskyAndFast_swiginit(self, _simulation.new_RiskyAndFast(*args))
    __swig_destroy__ = _simulation.delete_RiskyAndFast

# Register RiskyAndFast in _simulation:
_simulation.RiskyAndFast_swigregister(RiskyAndFast)

class SafeAndSlow(RootStrategyImplementation):
    r"""
    SafeAndSlow method.

    Available constructors:
        SafeAndSlow(*solver=ot.Brent()*)

        SafeAndSlow(*solver, maximumDistance, stepSize*)

    Parameters
    ----------
    solver : :class:`~openturns.Solver`
        Non linear solver used to research the intersection of the limit state
        function with the direction, on each segment of length *stepSize*, between
        the center of the space and *maximumDistance* (root research).
    maximumDistance : positive float
        Distance from the center of the standard space until which we research an
        intersection with the limit state function along each direction. By
        default, the maximum distance is equal to the value defined through the key
        RootStrategyImplementation-DefaultMaximumDistance of the
        :class:`~openturns.ResourceMap`.
    stepSize : float
        Length of each segment inside which the root research is performed. By
        default, the step size is equal to the value defined through the key
        RootStrategyImplementation-DefaultStepSize of the
        :class:`~openturns.ResourceMap`.

    See also
    --------
    DirectionalSampling

    Notes
    -----
    The *SafeAndSlow* strategy is the following: for each direction, we go along
    the direction by step of length *stepSize* from the origin to the maximum
    distant point(at distance *maximumDistance* from the center of the standard
    space) and we check whether there is a sign changement on each segment so
    formed.

    We go until the maximum distant point. Then, for all the segments where we
    detected the presence of a root, we research the root with the selected non
    linear solver. We evaluate the contribution to the failure probability of each
    segment.

    If *stepSize* is small enough, this strategy guarantees us to find all the roots
    in the direction and the contribution of this direction to the failure
    probability is precisely evaluated.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SafeAndSlow_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.SafeAndSlow_solve(self, function, value)

    def __repr__(self):
        return _simulation.SafeAndSlow___repr__(self)

    def __init__(self, *args):
        _simulation.SafeAndSlow_swiginit(self, _simulation.new_SafeAndSlow(*args))
    __swig_destroy__ = _simulation.delete_SafeAndSlow

# Register SafeAndSlow in _simulation:
_simulation.SafeAndSlow_swigregister(SafeAndSlow)

class SimulationSensitivityAnalysis(openturns.common.PersistentObject):
    r"""
    Class to perform a sensitivity analysis based on a reliability event.

    Available constructor:
        SimulationSensitivityAnalysis(*event, inputSample, outputSample*)

        SimulationSensitivityAnalysis(*event*)

        SimulationSensitivityAnalysis(*simulationRes*)

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        An event which it composite (test is with the method
        :meth:`isComposite <openturns.Event.isComposite>`).
    inputSample, outputSample : 2-d sequence of float
        Input sample and output sample of a model evaluated apart.
    simulationRes : :class:`~openturns.ProbabilitySimulationResult`
        A simulation result.

    Notes
    -----
    The simulation sensitivity analysis is based on:

    - in the first usage, the *inputSample* and *outputSample* given:
    - in the second usage, the samples which have been stored by the function
      defining the event. Care if the sample is not a statistical sample: post
      treatment proposed by the object might not be right.
    - in the third usage, the samples generated by the
      :class:`~openturns.EventSimulation` that produced *simulationRes*.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SimulationSensitivityAnalysis_getClassName(self)

    def computeMeanPointInEventDomain(self, *args):
        r"""
        Accessor to the mean point.

        Returns
        -------
        mean : :class:`~openturns.Point`
            The mean point in the failure domain.

        Notes
        -----
        This method computes the mean point in the physical space of all the simulations
        generated by the simulation that failed into the event domain.

        Be carefull: this notion is only valid for Monte Carlo or LHS sampling as the
        mean is evaluated from the equation :eq:`mean_point` (only uniform weights over
        the realizations :math:`\vect{X}_i`.
        """
        return _simulation.SimulationSensitivityAnalysis_computeMeanPointInEventDomain(self, *args)

    def computeImportanceFactors(self, *args):
        r"""
        Compute the importance factors.

        Returns
        -------
        impFactors : :class:`~openturns.PointWithDescription`
            The importance factors.

        Notes
        -----
        The importance factors, given in :eq:`importance_factor`, are evaluated from the
        coordinates of the mean point :eq:`mean_point` of the event domain, mapped into
        the standard space as follows:

        .. math::
            :label: mean_point

            \vect{X}^*_{event} = \frac{1}{n} \sum_{i=1}^n \vect{X}_i 1_{event} (\vect{X}_i)

        .. math::
            :label: importance_factor

            \alpha_i = \frac{ (U_i^*)^2 }{ \left\| \vect{U}^* \right\| }

        where

        .. math::

            \vect{U}^* = T(\vect{X}^*_{event})

        Be careful: this notion is only valid for :class:`~openturns.MonteCarlo` or
        :class:`~openturns.LHS` sampling as the mean is evaluated from the equation
        :eq:`importance_factor` (only uniform weights over the realizations
        :math:`\vect{X}_i`.
        """
        return _simulation.SimulationSensitivityAnalysis_computeImportanceFactors(self, *args)

    def computeEventProbabilitySensitivity(self):
        r"""
        Compute the sensitivity to the probability.

        The sensitivity of the probability Pf wrt the distribution parameters :math:`\theta` is written:

        .. math::

            \vect{sens_{Pf}}_j = \frac{1}{n} \sum_{i=1}^n \mathbf{1}_{event} \vect{\frac{\delta log(f_{\uX})(\vect{X}_i)}{\delta \theta_j}}

        Returns
        -------
        sensitivity_pf : :class:`~openturns.PointWithDescription`
            The probability sensitivity.
        """
        return _simulation.SimulationSensitivityAnalysis_computeEventProbabilitySensitivity(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Graph containing the pie corresponding to the importance factors of the probabilistic variables.
        """
        return _simulation.SimulationSensitivityAnalysis_drawImportanceFactors(self)

    def drawImportanceFactorsRange(self, *args):
        r"""
        Draw the importance factors evolution.

        Parameters
        ----------
        probabilityScale : boolean
            Set True if the limits are the probability levels; set False if the limits are
            the thresholds defining the event.
        lower, upper : floats
            Define the boundaries of the probability levels :math:`p_{min}` and
            :math:`p_{max}` or those of the thresholds :math:`s_{min}` and :math:`s_{max}`. 

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graph that draws the evolution of the importance factors of each direction
            with respect to :math:`p \in [p_{min}, p_{max}]` or
            :math:`s \in [s_{min}, s_{max}]`. The importance factors are evaluated from
            the definition :eq:`importance_factor` for each threshold *s* or probability
            *p*.
        """
        return _simulation.SimulationSensitivityAnalysis_drawImportanceFactorsRange(self, *args)

    def getInputSample(self):
        r"""
        Accessor to the input sample.

        Returns
        -------
        inputSample : :class:`~openturns.Sample`
            The input sample.
        """
        return _simulation.SimulationSensitivityAnalysis_getInputSample(self)

    def getOutputSample(self):
        r"""
        Accessor to the output sample.

        Returns
        -------
        outputSample : :class:`~openturns.Sample`
            The output sample.
        """
        return _simulation.SimulationSensitivityAnalysis_getOutputSample(self)

    def getThreshold(self):
        r"""
        Accessor to the threshold.

        Returns
        -------
        s : float
            The threshold.
        """
        return _simulation.SimulationSensitivityAnalysis_getThreshold(self)

    def getTransformation(self):
        r"""
        Accessor to the isoprobabilistic transformation function.

        Returns
        -------
        transformation : :class:`~openturns.Function`
            The isoprobabilistic transformation function.
        """
        return _simulation.SimulationSensitivityAnalysis_getTransformation(self)

    def getComparisonOperator(self):
        r"""
        Accessor to the comparison operator.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            The comparison operator.
        """
        return _simulation.SimulationSensitivityAnalysis_getComparisonOperator(self)

    def __repr__(self):
        return _simulation.SimulationSensitivityAnalysis___repr__(self)

    def __init__(self, *args):
        _simulation.SimulationSensitivityAnalysis_swiginit(self, _simulation.new_SimulationSensitivityAnalysis(*args))
    __swig_destroy__ = _simulation.delete_SimulationSensitivityAnalysis

# Register SimulationSensitivityAnalysis in _simulation:
_simulation.SimulationSensitivityAnalysis_swigregister(SimulationSensitivityAnalysis)

class SubsetSamplingResult(ProbabilitySimulationResult):
    r"""
    Subset sampling result.

    See also
    --------
    SubsetSampling, SimulationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SubsetSamplingResult_getClassName(self)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the coefficient of variation.

        Returns
        -------
        coefficient : float
            Coefficient of variation of the simulated sample which is equal to
            :math:`\sqrt{Var_e} / P_e` with :math:`Var_e` the variance estimate and
            :math:`P_e` the probability estimate.
        """
        return _simulation.SubsetSamplingResult_getCoefficientOfVariation(self)

    def __repr__(self):
        return _simulation.SubsetSamplingResult___repr__(self)

    def __init__(self, *args):
        _simulation.SubsetSamplingResult_swiginit(self, _simulation.new_SubsetSamplingResult(*args))
    __swig_destroy__ = _simulation.delete_SubsetSamplingResult

# Register SubsetSamplingResult in _simulation:
_simulation.SubsetSamplingResult_swigregister(SubsetSamplingResult)

class SubsetSampling(EventSimulation):
    r"""
    Subset simulation.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    proposalRange : float, optional
        Proposal range length
    targetProbability : float, optional
        Value of :math:`P(F_i|F_{i-1})` between successive steps

    Notes
    -----
    The goal is to estimate the following probability

    .. math::

        P_f = \int_{\mathcal D_f} f_{\uX}(\ux)\di{\ux}\\
            = \int_{\mathbb R^{n_X}} \mathbf{1}_{\{g(\ux,\underline{d}) \:\leq 0\: \}}f_{\uX}(\ux)\di{\ux}\\
            = \Prob {\{g(\uX,\underline{d}) \leq 0\}}


    The idea of the subset simulation method [au2001]_ is to replace simulating a
    rare failure event in the original probability space by a sequence of
    simulations of more frequent conditional events :math:`F_i`

    .. math::

        F_1 \supset F_2 \supset \dots \supset F_m = F


    The original probability estimate rewrites

    .. math::

        P_f = P(F_m) = P(\bigcap \limits_{i=1}^m F_i) = P(F_1) \prod_{i=2}^m P(F_i|F_{i-1})


    And each conditional subset failure region is chosen by setting the threshold
    :math:`g_i` so that :math:`P(F_i|F_{i-1})` leads to a conditional failure
    probability of order :math:`0.1`

    .. math::

        F_i =\Prob {\{g(\uX,\underline{d}) \leq g_i\}}


    The conditional samples are generated by the means of Markov Chains,
    using the Metropolis Hastings algorithm.

    :math:`N` being the number of simulations per subset, and :math:`p_{0i}` the
    conditional probability of each subset event, and :math:`\gamma_i` the
    autocorrelation between Markov chain samples.

    .. math::

        \delta^2 = \sum_{i=1}^m \delta^2_i = \sum_{i=1}^m (1+\gamma_i) \frac{1-p_{0i}}{p_{0i}N}


    The first event :math:`F_1` not being conditional, :math:`\delta^2_1`
    expresses as the classic Monte Carlo c.o.v.

    See also
    --------
    EventSimulation
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SubsetSampling_getClassName(self)

    def setProposalRange(self, proposalRange):
        r"""
        Proposal range length accessor.

        Parameters
        ----------
        range : float
            Range length.
        """
        return _simulation.SubsetSampling_setProposalRange(self, proposalRange)

    def getProposalRange(self):
        r"""
        Proposal range length accessor.

        Returns
        -------
        range : float
            Range length.
        """
        return _simulation.SubsetSampling_getProposalRange(self)

    def setConditionalProbability(self, conditionalProbability):
        r"""
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Parameters
        ----------
        prob : float
            Conditional probability value.
        """
        return _simulation.SubsetSampling_setConditionalProbability(self, conditionalProbability)

    def getConditionalProbability(self):
        r"""
        Conditional probability accessor.

        Value of :math:`P(F_i|F_{i-1})` between successive steps.

        Returns
        -------
        prob : float
            Conditional probability value.
        """
        return _simulation.SubsetSampling_getConditionalProbability(self)

    def setMinimumProbability(self, minimumProbability):
        r"""
        Minimum probability accessor.

        Allows to stop the algorithm if the probability becomes too small.

        Parameters
        ----------
        prob_min : float, defaults to the square root of SpecFunc.MinScalar
            Minimum probability.
        """
        return _simulation.SubsetSampling_setMinimumProbability(self, minimumProbability)

    def getMinimumProbability(self):
        r"""
        Minimum probability accessor.

        Returns
        -------
        prob_min : float
            Minimum probability.
        """
        return _simulation.SubsetSampling_getMinimumProbability(self)

    def getNumberOfSteps(self):
        r"""
        Subset steps number accessor.

        Returns
        -------
        n : int
            Number of subset steps.
        """
        return _simulation.SubsetSampling_getNumberOfSteps(self)

    def getThresholdPerStep(self):
        r"""
        Threshold accessor.

        Returns
        -------
        threshold : `~openturns.Point`
            Threshold values.
        """
        return _simulation.SubsetSampling_getThresholdPerStep(self)

    def getGammaPerStep(self):
        r"""
        Autocorrelation accessor.

        Returns
        -------
        prob : `~openturns.Point`
            Autocorrelation values.
        """
        return _simulation.SubsetSampling_getGammaPerStep(self)

    def getCoefficientOfVariationPerStep(self):
        r"""
        Coefficient of variation per step accessor.

        Returns
        -------
        coef : `~openturns.Point`
            Coefficient of variation at each subset step.
        """
        return _simulation.SubsetSampling_getCoefficientOfVariationPerStep(self)

    def getProbabilityEstimatePerStep(self):
        r"""
        Probability estimate accessor.

        Returns
        -------
        prob : `~openturns.Point`
            Probability estimate values.
        """
        return _simulation.SubsetSampling_getProbabilityEstimatePerStep(self)

    def setKeepEventSample(self, keepEventSample):
        r"""
        Sample storage accessor.

        Parameters
        ----------
        prob : bool
            Whether to keep the event samples.
        """
        return _simulation.SubsetSampling_setKeepEventSample(self, keepEventSample)

    def getEventInputSample(self):
        r"""
        Input sample accessor.

        Returns
        -------
        inputSample : `~openturns.Sample`
            Input sample.
        """
        return _simulation.SubsetSampling_getEventInputSample(self)

    def getEventOutputSample(self):
        r"""
        Output sample accessor.

        Returns
        -------
        outputSample : `~openturns.Sample`
            Ouput sample.
        """
        return _simulation.SubsetSampling_getEventOutputSample(self)

    def setISubset(self, iSubset):
        r"""
        Conditonal simulation flag accessor.

        Parameters
        ----------
        isubset : bool
            Whether to enable conditional simulation for the first step of the
            simulation.
        """
        return _simulation.SubsetSampling_setISubset(self, iSubset)

    def setBetaMin(self, betaMin):
        r"""
        Hypersphere radius accessor.

        Parameters
        ----------
        beta : float
            Radius value of the exclusion hypershere when the conditional simulation
            is enabled.
        """
        return _simulation.SubsetSampling_setBetaMin(self, betaMin)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.SubsetSampling_run(self)

    def __repr__(self):
        return _simulation.SubsetSampling___repr__(self)

    def __init__(self, *args):
        _simulation.SubsetSampling_swiginit(self, _simulation.new_SubsetSampling(*args))
    __swig_destroy__ = _simulation.delete_SubsetSampling

# Register SubsetSampling in _simulation:
_simulation.SubsetSampling_swigregister(SubsetSampling)

class AdaptiveDirectionalSampling(EventSimulation):
    r"""
    Adaptative directional simulation.

    Parameters
    ----------
    event : :class:`~openturns.RandomVector`
        Event we are computing the probability of.
    rootStrategy : :class:`~openturns.RootStrategy`, optional
        Strategy adopted to evaluate the intersections of each direction with the
        limit state function and take into account the contribution of the
        direction to the event probability.
        Set to :class:`~openturns.SafeAndSlow` by default.
    samplingStrategy : :class:`~openturns.SamplingStrategy`, optional
        Strategy adopted to sample directions.
        Set to :class:`~openturns.RandomDirection` by default.

    Notes
    -----
    Let :math:`\mathcal D_f` denote the failure domain defined as
    :math:`\mathcal D_f = \{\ux \in \mathbb R^{n_X} | g(\ux) \leq 0\}`, where
    :math:`\ux` are realization of the random vector :math:`\uX` and :math:`g` is the limit-state
    function as defined elsewhere in the documentation.

    The purpose of the ADS-2 algorithm and its variants is to estimate the
    following probability:

    .. math::

      P_f = \int_{\mathcal D_f} f_{\uX}(\ux)\di{\ux} \\
          = \int_{\mathbb R^{n_X}} \mathbf{1}_{\{g(\ux) \:\leq 0\: \}}\,f_{\uX}(\ux)\di{\ux} \\
          = \Prob{\{g(\uX) \leq 0\}}.

    Principles

    The ADS-2 method [munoz2011]_ combines the stratified and directional sampling concepts.
    Stratified sampling consists in splitting the support of the random vector
    :math:`\ux` into :math:`m` mutually exclusive and collectively exhaustive subsets.
    Here, ADS-2 splits the standard space into :math:`m = 2^d` quadrants, where
    :math:`d` is the dimension of the random vector :math:`\uX`.
    Stratified sampling is often run in two steps: (i) a learning step is used for
    polling the input space and detect the subsets that contribute most to the
    probability and (ii) an estimation step is used for estimating
    the probability by weighted sampling (some subsets are more sampled than the others).
    Directional sampling uses the spheric symmetry of the standard space for
    estimating the failure probability as the average of conditional probabilities
    calculated on directions drawn at random in the standard space.

    The learning step uses an a priori number of random directions that is
    uniformly distributed over the quadrants, meaning the weights are as follows:

    .. math::

        \omega^1_i = \frac{1}{m}, \quad i = 1, \ldots, m.


    Directional sampling is used for estimating the failure probability in each quadrant:

    .. math::

        \hat P_i^{DS} = \Prob{\{g(\uX) \leq 0\} \mid \uX \in \mathbb{Q}_i},\,i = 1, \ldots, m.


    and the corresponding estimation variances are denoted as :math:`\sigma_i^{DS\,2}`.
    These probabilities are estimated using the same number :math:`N^0_i` of random
    directions per quadrant as told by the uniform weights distribution.

    The probability of interest is then computed as a weighted average of the
    previously defined conditional probabilities:

    .. math::

        \hat P_f = \sum\limits_{i=1}^m \omega_i \hat P_i^{DS}


    where :math:`\hat P_i^{DS}` is the conditional probability estimator in the i-th quadrant. The corresponding variance of the stratified estimator reads:

    .. math::

        \sigma^2 = \frac{1}{N_l} \left( \sum\limits_{i=1}^m \omega_i \sigma_i^{DS} \right) ^2


    where :math:`\sigma_i^{DS\,2}` is the variance of the conditional probability
    estimator in the i-th quadrant.

    At the end of the learning step, the weights :math:`\omega_i` are updated so
    as to minimize the stratified estimator variance.
    Indeed, it can be shown that the updated weights:

    .. math::

        \omega^2_i = \frac{\omega^1_i \sigma_i^{DS}}{\sum\limits_{j=1}^m \omega^1_j \sigma_j^{DS}}, i = 1, \ldots, m,


    minimize the final estimation variance in \eqref{eq:pf_est_sda2_var}.
    Note that some weights might be zero (due to a somewhat arbitrary rounding of
    the conditional probabilities' estimation variance). The quadrants associated
    with a zero-weight will not be sampled in the estimation step.

    Eventually, the estimation step proceeds in essentially the same way as the
    learning step with different weights for the quadrants though.
    \eqref{eq:pf_est_sda2} and \eqref{eq:pf_est_sda2_var} are used for evaluating
    the final probability probability estimate and its variance.

    The computational budget per step is parametrized by a fraction
    :math:`\gamma_l, l = 1,\,2` of the total budget :math:`N`, such that :math:`\gamma_1 + \gamma_2 = 1`.
    The number of directions sampled in quadrant :math:`i` at step :math:`l` is then defined as follows:

    .. math::

        N^l_i = N * \gamma_l * \omega_i.


    The number of evaluation of the limit-state function :math:`g` is of course
    greater than the total budget :math:`N` since directional sampling is used.

    Variants

    The ADS-2+ variant performs a dimension reduction step after the learning step
    for reducing the number of stratified quadrants. The statistic :math:`\tilde T_k`
    aggregates the sensitivity of expectation along dimension :math:`k`.
    It is defined as follows:

    .. math::

        \tilde T_k = \sum\limits_{i_l \in \lbrace -1,1 \rbrace,l \neq k} \lvert \tilde I_{(i_1,\dots,i_{k-1},-1,i_{k+1},\dots,i_p)} - \tilde I_{(i_1,\dots,i_{k-1},1,i_{k+1},\dots,i_p)} \rvert.

    It is used for ranking the contributions of the quadrants.
    Then, only the :math:`d' < d` most influential variables according to
    :math:`\tilde T_k` are stratified, leaving the remaining variables simulated without
    stratification. The corresponding quadrants will not be sampled.

    The DP-ADS-2 variant combines the ADS method with a rotation of the quadrants.
    The idea is to get a possible design point (available e.g. after a
    preliminary FORM analysis) on the bisector of one of the quadrants to make the
    stratification even more efficient and thus save some evaluations of the model.

    This 2-step algorithm can be generalized to :math:`L > 2` steps by adding more
    than one learning step. For now, only ADS-2 is implemented.

    See also
    --------
    EventSimulation
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.AdaptiveDirectionalSampling_getClassName(self)

    def __repr__(self):
        return _simulation.AdaptiveDirectionalSampling___repr__(self)

    def setRootStrategy(self, rootStrategy):
        r"""
        Set the root strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.AdaptiveDirectionalSampling_setRootStrategy(self, rootStrategy)

    def getRootStrategy(self):
        r"""
        Get the root strategy.

        Returns
        -------
        strategy : :class:`~openturns.RootStrategy`
            Root strategy adopted.
        """
        return _simulation.AdaptiveDirectionalSampling_getRootStrategy(self)

    def setSamplingStrategy(self, samplingStrategy):
        r"""
        Set the direction sampling strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.AdaptiveDirectionalSampling_setSamplingStrategy(self, samplingStrategy)

    def getSamplingStrategy(self):
        r"""
        Get the direction sampling strategy.

        Returns
        -------
        strategy : :class:`~openturns.SamplingStrategy`
            Direction sampling strategy adopted.
        """
        return _simulation.AdaptiveDirectionalSampling_getSamplingStrategy(self)

    def setGamma(self, gamma):
        r"""
        Gamma accessor.

        The computational budget per step :math:`\gamma_l`.

        Parameters
        ----------
        gamma : sequence of float
            Gamma value.
        """
        return _simulation.AdaptiveDirectionalSampling_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Gamma accessor.

        The computational budget per step :math:`\gamma_l`.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            Gamma value.
        """
        return _simulation.AdaptiveDirectionalSampling_getGamma(self)

    def setQuadrantOrientation(self, quadrantOrientation):
        r"""
        Quadrant orientation accessor.

        Parameters
        ----------
        orientation : sequence of float
            Quadrant orientation.
        """
        return _simulation.AdaptiveDirectionalSampling_setQuadrantOrientation(self, quadrantOrientation)

    def getQuadrantOrientation(self):
        r"""
        Quadrant orientation accessor.

        Returns
        -------
        orientation : :class:`~openturns.Point`
            Quadrant orientation.
        """
        return _simulation.AdaptiveDirectionalSampling_getQuadrantOrientation(self)

    def setPartialStratification(self, partialStratification):
        r"""
        Partial stratification accessor.

        Parameters
        ----------
        partialStratification : bool
            Partial stratification.
        """
        return _simulation.AdaptiveDirectionalSampling_setPartialStratification(self, partialStratification)

    def getPartialStratification(self):
        r"""
        Partial stratification accessor.

        Returns
        -------
        partialStratification : bool
            Partial stratification.
        """
        return _simulation.AdaptiveDirectionalSampling_getPartialStratification(self)

    def setMaximumStratificationDimension(self, maximumStratificationDimension):
        r"""
        Maximum stratification dimension accessor.

        Parameters
        ----------
        max : int
            Maximum stratification dimension.
        """
        return _simulation.AdaptiveDirectionalSampling_setMaximumStratificationDimension(self, maximumStratificationDimension)

    def getMaximumStratificationDimension(self):
        r"""
        Maximum stratification dimension accessor.

        Returns
        -------
        max : int
            Maximum stratification dimension.
        """
        return _simulation.AdaptiveDirectionalSampling_getMaximumStratificationDimension(self)

    def getTStatistic(self):
        r"""
        T statistic accessor.

        The statistic :math:`\tilde T_k` aggregates the sensitivity of expectation.

        Returns
        -------
        gamma : :class:`~openturns.Point`
            T statistic value.
        """
        return _simulation.AdaptiveDirectionalSampling_getTStatistic(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation and creates a :class:`~openturns.SimulationResult`,
        structure containing all the results obtained after simulation.
        It computes the probability of occurence of the given event by computing the
        empirical mean of a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.AdaptiveDirectionalSampling_run(self)

    def __init__(self, *args):
        _simulation.AdaptiveDirectionalSampling_swiginit(self, _simulation.new_AdaptiveDirectionalSampling(*args))
    __swig_destroy__ = _simulation.delete_AdaptiveDirectionalSampling

# Register AdaptiveDirectionalSampling in _simulation:
_simulation.AdaptiveDirectionalSampling_swigregister(AdaptiveDirectionalSampling)

class ExpectationSimulationResult(SimulationResult):
    r"""
    Expectation simulation result.

    Gathers the results of a :class:`~openturns.ExpectationSimulationAlgorithm`
    algorithm.

    See also
    --------
    ExpectationSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ExpectationSimulationResult_getClassName(self)

    def getRandomVector(self):
        r"""
        Accessor to the random variable.

        Returns
        -------
        event : :class:`~openturns.RandomVector`
            Random variable we want to study.
        """
        return _simulation.ExpectationSimulationResult_getRandomVector(self)

    def setRandomVector(self, randomVector):
        r"""
        Accessor to the random variable.

        Parameters
        ----------
        event : :class:`~openturns.RandomVector`
            Random variable we want to study.
        """
        return _simulation.ExpectationSimulationResult_setRandomVector(self, randomVector)

    def getExpectationEstimate(self):
        r"""
        Accessor to the expectation estimate.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the expectation.
        """
        return _simulation.ExpectationSimulationResult_getExpectationEstimate(self)

    def setExpectationEstimate(self, expectationEstimate):
        r"""
        Accessor to the expectation estimate.

        Parameters
        ----------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the expectation.
        """
        return _simulation.ExpectationSimulationResult_setExpectationEstimate(self, expectationEstimate)

    def getVarianceEstimate(self):
        r"""
        Accessor to the variance estimate.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the variance.
        """
        return _simulation.ExpectationSimulationResult_getVarianceEstimate(self)

    def setVarianceEstimate(self, varianceEstimate):
        r"""
        Accessor to the variance estimate.

        Parameters
        ----------
        expectationEstimate : :class:`~openturns.Point`
            Estimate of the variance.
        """
        return _simulation.ExpectationSimulationResult_setVarianceEstimate(self, varianceEstimate)

    def getCoefficientOfVariation(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        coefficientOfVariation : :class:`~openturns.Point`
            Coefficient of variation.
        """
        return _simulation.ExpectationSimulationResult_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        standardDeviation : :class:`~openturns.Point`
            Standard deviation.
        """
        return _simulation.ExpectationSimulationResult_getStandardDeviation(self)

    def getExpectationDistribution(self):
        r"""
        Accessor to the expectation distribution.

        Returns
        -------
        expectationEstimate : :class:`~openturns.Distribution`
            Distribution of the expectation.
        """
        return _simulation.ExpectationSimulationResult_getExpectationDistribution(self)

    def __repr__(self):
        return _simulation.ExpectationSimulationResult___repr__(self)

    def __init__(self, *args):
        _simulation.ExpectationSimulationResult_swiginit(self, _simulation.new_ExpectationSimulationResult(*args))
    __swig_destroy__ = _simulation.delete_ExpectationSimulationResult

# Register ExpectationSimulationResult in _simulation:
_simulation.ExpectationSimulationResult_swigregister(ExpectationSimulationResult)

class ExpectationSimulationAlgorithm(SimulationAlgorithm):
    r"""
    Expectation computation using sampling.

    Incremental Monte Carlo sampling algorithm to estimate the mean :math:`\Expect{\vect{X}}` of a random vector
    :math:`\vect{X}`.

    Parameters
    ----------
    X : :class:`~openturns.RandomVector`
        The random vector to study.

    Notes
    -----
    The algorithm can operate on a multivariate random vector :math:`\vect{X}`.

    There are 3 mathematical stopping criteria available:

    - through an operator on the coefficient of variation
    - through an operator on the standard deviation
    - on the maximum standard deviation per component

    The criterion on the coefficient of variation is defined using either:

      - The maximum: :math:`\max_i \frac{\sigma_i}{|\mu_i|} \leq \max_{cov}`
      - The norm-1: :math:`\frac{1}{d} \sum_1^{d} \frac{\sigma_i}{|\mu_i|} \leq \max_{cov}`
      - The norm-2: :math:`\sqrt{\frac{1}{d} \sum_1^{d} \left(\frac{\sigma_i}{|\mu_i|}\right)^2} \leq \max_{cov}`

      The type of operator on the coefficient of variation is set using :meth:`setCoefficientOfVariationCriterionType`.

      The default type is set by the `ExpectationSimulationAlgorithm-DefaultCoefficientOfVariationCriterionType`
      :class:`~openturns.ResourceMap` key.

      The threshold :math:`\max_{cov}` can be set using :meth:`setMaximumCoefficientOfVariation`.

    The criterion on the standard deviation is defined using either:

      - The maximum: :math:`\max_i \sigma_i \leq \max_{\sigma}`
      - The norm-1: :math:`\frac{1}{d} \sum_1^{d} |\sigma_i| \leq \max_{\sigma}`
      - The norm-2: :math:`\sqrt{\frac{1}{d} \sum_1^{d} \sigma_i^2} \leq \max_{\sigma}`

      The type of operator on the coefficient of variation can be set using :meth:`setStandardDeviationCriterionType`.

      The default type is set by the `ExpectationSimulationAlgorithm-DefaultStandardDeviationCriterionType`
      :class:`~openturns.ResourceMap` key.

      The threshold :math:`\max_{\sigma}` can be set using :meth:`setMaximumStandardDeviation`.

    The criterion on the maximum deviation per component is defined by :math:`\sigma_i \leq \max_{\sigma_i}`

      The thresholds :math:`\max_{\sigma_i}` can be set using :meth:`setMaximumStandardDeviationPerComponent`.

      By default this criterion is disabled.


    See also
    --------
    ExpectationSimulationResult

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> # Create a composite random vector
    >>> model = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
    >>> distribution = ot.Normal([50.0, 1.0, 10.0, 5.0], [1.0]*4, ot.IdentityMatrix(4))
    >>> vect = ot.RandomVector(distribution)
    >>> X = ot.CompositeRandomVector(model, vect)
    >>> algo = ot.ExpectationSimulationAlgorithm(X)
    >>> algo.setMaximumOuterSampling(1000)
    >>> algo.setBlockSize(1)
    >>> algo.setCoefficientOfVariationCriterionType('NONE')
    >>> algo.run()
    >>> result = algo.getResult()
    >>> expectation = result.getExpectationEstimate()
    >>> print(expectation)
    [-1.39543]
    >>> expectationDistribution = result.getExpectationDistribution()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.ExpectationSimulationAlgorithm_getClassName(self)

    def getRandomVector(self):
        r"""
        Accessor to the random vector.

        Returns
        -------
        X : :class:`~openturns.RandomVector`
            Random vector we want to study.
        """
        return _simulation.ExpectationSimulationAlgorithm_getRandomVector(self)

    def getResult(self):
        r"""
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.ExpectationSimulationResult`
            The simulation result.
        """
        return _simulation.ExpectationSimulationAlgorithm_getResult(self)

    def setCoefficientOfVariationCriterionType(self, criterionType):
        r"""
        Accessor to the criterion operator.

        Parameters
        ----------
        result : str
            The criterion operator, either NONE, MAX, NORM1 or NORM2.
        """
        return _simulation.ExpectationSimulationAlgorithm_setCoefficientOfVariationCriterionType(self, criterionType)

    def getCoefficientOfVariationCriterionType(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        result : str
            The criterion operator.
        """
        return _simulation.ExpectationSimulationAlgorithm_getCoefficientOfVariationCriterionType(self)

    def setStandardDeviationCriterionType(self, criterionType):
        r"""
        Accessor to the criterion operator.

        Parameters
        ----------
        result : str
            The criterion operator, either NONE, MAX, NORM1 or NORM2
        """
        return _simulation.ExpectationSimulationAlgorithm_setStandardDeviationCriterionType(self, criterionType)

    def getStandardDeviationCriterionType(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        result : str
            The criterion operator.
        """
        return _simulation.ExpectationSimulationAlgorithm_getStandardDeviationCriterionType(self)

    def setMaximumStandardDeviationPerComponent(self, maximumStandardDeviation):
        r"""
        Accessor to the maximum standard deviation.

        Parameters
        ----------
        sigmaMax : sequence of float
            The maximum standard deviation on each component.

            If empty, the stopping criterion is not applied.
        """
        return _simulation.ExpectationSimulationAlgorithm_setMaximumStandardDeviationPerComponent(self, maximumStandardDeviation)

    def getMaximumStandardDeviationPerComponent(self):
        r"""
        Accessor to the maximum standard deviation.

        Returns
        -------
        sigmaMax : sequence of float
            The maximum standard deviation on each component.
        """
        return _simulation.ExpectationSimulationAlgorithm_getMaximumStandardDeviationPerComponent(self)

    def __repr__(self):
        return _simulation.ExpectationSimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.ExpectationSimulationAlgorithm_run(self)

    def drawExpectationConvergence(self, *args):
        r"""
        Draw the expectation convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _simulation.ExpectationSimulationAlgorithm_drawExpectationConvergence(self, *args)

    def __init__(self, *args):
        _simulation.ExpectationSimulationAlgorithm_swiginit(self, _simulation.new_ExpectationSimulationAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_ExpectationSimulationAlgorithm

# Register ExpectationSimulationAlgorithm in _simulation:
_simulation.ExpectationSimulationAlgorithm_swigregister(ExpectationSimulationAlgorithm)

class SobolSimulationResult(SimulationResult):
    r"""
    Sobol simulation result.

    Gathers the results of a :class:`~openturns.SobolSimulationAlgorithm`
    algorithm.

    See also
    --------
    SobolSimulationAlgorithm
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolSimulationResult_getClassName(self)

    def getFirstOrderIndicesEstimate(self):
        r"""
        Accessor to the first order indices estimate.

        Returns
        -------
        estimate : :class:`~openturns.Point`
            Estimate of the first order indices.
        """
        return _simulation.SobolSimulationResult_getFirstOrderIndicesEstimate(self)

    def getTotalOrderIndicesEstimate(self):
        r"""
        Accessor to the total order indices estimate.

        Returns
        -------
        estimate : :class:`~openturns.Point`
            Estimate of the total order indices.
        """
        return _simulation.SobolSimulationResult_getTotalOrderIndicesEstimate(self)

    def setFirstOrderIndicesDistribution(self, firstOrderIndicesDistribution):
        r"""
        Accessor to the first order indices distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the first order indices.
        """
        return _simulation.SobolSimulationResult_setFirstOrderIndicesDistribution(self, firstOrderIndicesDistribution)

    def setTotalOrderIndicesDistribution(self, totalOrderIndicesDistribution):
        r"""
        Accessor to the total order indices distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Distribution of the total order indices.
        """
        return _simulation.SobolSimulationResult_setTotalOrderIndicesDistribution(self, totalOrderIndicesDistribution)

    def getFirstOrderIndicesDistribution(self):
        r"""
        Accessor to the first order indices distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the first order indices.
        """
        return _simulation.SobolSimulationResult_getFirstOrderIndicesDistribution(self)

    def getTotalOrderIndicesDistribution(self):
        r"""
        Accessor to the total order indices distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the total order indices.
        """
        return _simulation.SobolSimulationResult_getTotalOrderIndicesDistribution(self)

    def __repr__(self):
        return _simulation.SobolSimulationResult___repr__(self)

    def __init__(self, *args):
        _simulation.SobolSimulationResult_swiginit(self, _simulation.new_SobolSimulationResult(*args))
    __swig_destroy__ = _simulation.delete_SobolSimulationResult

# Register SobolSimulationResult in _simulation:
_simulation.SobolSimulationResult_swigregister(SobolSimulationResult)

class SobolSimulationAlgorithm(SimulationAlgorithm):
    r"""
    Sobol indices computation using iterative sampling.

    The algorithm uses sampling of the distribution of the random vector :math:`\vect{X}` through the model :math:`f`
    to iteratively estimate the Sobol indices.

    At each iteration a fixed number :math:`N = blockSize * (d + 2)` of replications inputs is generated.
    These inputs are evaluated by blocks of size :math:`batchSize` through the model :math:`f`.
    Then the distribution of the indices (first and total order) is computed on this current replication sample.
    At the end of each iteration we update the global distribution of the indices.

    Parameters
    ----------
    X : :class:`~openturns.Distribution`
        The random vector to study.
    f : :class:`~openturns.Function`
        The function to study.
    estimator : :class:`~openturns.SobolIndicesAlgorithm`
        The estimator of the indices.

    Notes
    -----
    The algorithm can operate on a multivariate model :math:`f`, in this case it operates on aggregated indices.

    Several estimators are available (Saltelli, Jansen, ...).

    Let us denote by $n_X$ the number of input variables.
    For any $j=1,...,n_X$, let us denote by $\Phi_j^F$ (resp. $\Phi_j^T$) the cumulated distribution
    function of the gaussian asymptotic distribution of the estimator
    of the Sobol' first (resp. total) order indice.
    Let $\alpha\in[0,1]$ be the level of the confidence interval and $\epsilon\in(0,1]$ the
    length of this confidence interval.
    The algorithms stops when first and total order indices haved been estimated with enough precision for all components

    The precision is said to be sufficient if the length of the $\alpha$-level confidence interval
    is smaller than $\epsilon$:

    .. math::

        (\Phi_j^F)^{-1}(1-\alpha/2) - (\Phi_j^F)^{-1}(\alpha/2) \leq \epsilon \textrm{ and }
        (\Phi_j^T)^{-1}(1-\alpha/2) - (\Phi_j^T)^{-1}(\alpha/2) \leq \epsilon

    for all :math:`j=1,...,n_X`.

    See also
    --------
    SobolSimulationResult

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.ComposedDistribution([ot.Uniform(-1.0, 1.0)] * 3)
    >>> model = ot.SymbolicFunction(['x1', 'x2', 'x3'], ['x1*x2+x3'])
    >>> estimator = ot.SaltelliSensitivityAlgorithm()
    >>> estimator.setUseAsymptoticDistribution(True)
    >>> algo = ot.SobolSimulationAlgorithm(distribution, model, estimator)
    >>> algo.setMaximumOuterSampling(25) # number of iterations
    >>> algo.setBlockSize(100) # size of Sobol experiment at each iteration
    >>> algo.setBatchSize(4) # number of points evaluated simultaneously
    >>> algo.setIndexQuantileLevel(0.05) # alpha
    >>> algo.setIndexQuantileEpsilon(1e-2) # epsilon
    >>> algo.run()
    >>> result = algo.getResult()
    >>> fo = result.getFirstOrderIndicesEstimate()
    >>> foDist = result.getFirstOrderIndicesDistribution()
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SobolSimulationAlgorithm_getClassName(self)

    def getDistribution(self):
        r"""
        Accessor to the batch size.

        Returns
        -------
        distibution : :class:`~openturns.Distribution`
            Distribution of the random variable.
        """
        return _simulation.SobolSimulationAlgorithm_getDistribution(self)

    def getResult(self):
        r"""
        Accessor to the result.

        Returns
        -------
        result : :class:`~openturns.SobolSimulationResult`
            The simulation result.
        """
        return _simulation.SobolSimulationAlgorithm_getResult(self)

    def setIndexQuantileLevel(self, indexQuantileLevel):
        r"""
        Accessor to the quantile level.

        Parameters
        ----------
        alpha : float
            The quantile level.
        """
        return _simulation.SobolSimulationAlgorithm_setIndexQuantileLevel(self, indexQuantileLevel)

    def getIndexQuantileLevel(self):
        r"""
        Accessor to the quantile level.

        Returns
        -------
        alpha : float
            The quantile level.
        """
        return _simulation.SobolSimulationAlgorithm_getIndexQuantileLevel(self)

    def setIndexQuantileEpsilon(self, indexQuantileEpsilon):
        r"""
        Accessor to the quantile tolerance.

        Parameters
        ----------
        epsilon : float
            The quantile tolerance
        """
        return _simulation.SobolSimulationAlgorithm_setIndexQuantileEpsilon(self, indexQuantileEpsilon)

    def getIndexQuantileEpsilon(self):
        r"""
        Accessor to the criterion operator.

        Returns
        -------
        epsilon : float
            The quantile tolerance
        """
        return _simulation.SobolSimulationAlgorithm_getIndexQuantileEpsilon(self)

    def setEstimator(self, estimator):
        r"""
        Sobol estimator accessor.

        Parameters
        ----------
        estimator : :class:`~openturns.SobolIndicesAlgorithm`
            The estimator of the indices.
        """
        return _simulation.SobolSimulationAlgorithm_setEstimator(self, estimator)

    def getEstimator(self):
        r"""
        Sobol estimator accessor.

        Returns
        -------
        estimator : :class:`~openturns.SobolIndicesAlgorithm`
            The estimator of the indices.
        """
        return _simulation.SobolSimulationAlgorithm_getEstimator(self)

    def setBatchSize(self, replicationSize):
        r"""
        Accessor to the batch size.

        Parameters
        ----------
        batchSize : int
            Number of points evaluated simultaneously.
        """
        return _simulation.SobolSimulationAlgorithm_setBatchSize(self, replicationSize)

    def getBatchSize(self):
        r"""
        Accessor to the batch size.

        Returns
        -------
        batchSize : int
            Number of points evaluated simultaneously.
        """
        return _simulation.SobolSimulationAlgorithm_getBatchSize(self)

    def __repr__(self):
        return _simulation.SobolSimulationAlgorithm___repr__(self)

    def run(self):
        r"""
        Launch simulation.

        Notes
        -----
        It launches the simulation on a sample of size at most *outerSampling * blockSize*,
        this sample being built by blocks of size *blockSize*. It allows to use
        efficiently the distribution of the computation as well as it allows to deal
        with a sample size :math:`> 2^{32}` by a combination of *blockSize* and
        *outerSampling*.

        see also
        --------
        setBlockSize, setMaximumOuterSampling, ResourceMap, SimulationResult
        """
        return _simulation.SobolSimulationAlgorithm_run(self)

    def drawFirstOrderIndexConvergence(self, *args):
        r"""
        Draw the first order Sobol index convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _simulation.SobolSimulationAlgorithm_drawFirstOrderIndexConvergence(self, *args)

    def drawTotalOrderIndexConvergence(self, *args):
        r"""
        Draw the total order Sobol index convergence at a given level.

        Parameters
        ----------
        marginalIndex : int
            Index of the random vector component to consider
        level : float, optional
            The expectation convergence is drawn at this given confidence length
            *level*. By default *level* is 0.95.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            expectation convergence graph
        """
        return _simulation.SobolSimulationAlgorithm_drawTotalOrderIndexConvergence(self, *args)

    def __init__(self, *args):
        _simulation.SobolSimulationAlgorithm_swiginit(self, _simulation.new_SobolSimulationAlgorithm(*args))
    __swig_destroy__ = _simulation.delete_SobolSimulationAlgorithm

# Register SobolSimulationAlgorithm in _simulation:
_simulation.SobolSimulationAlgorithm_swigregister(SobolSimulationAlgorithm)

class RootStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_simulation.RootStrategyImplementationPointer_ptr__get, _simulation.RootStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _simulation.RootStrategyImplementationPointer_swiginit(self, _simulation.new_RootStrategyImplementationPointer(*args))
    __swig_destroy__ = _simulation.delete_RootStrategyImplementationPointer

    def reset(self):
        return _simulation.RootStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _simulation.RootStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _simulation.RootStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _simulation.RootStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _simulation.RootStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _simulation.RootStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _simulation.RootStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _simulation.RootStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _simulation.RootStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _simulation.RootStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.RootStrategyImplementationPointer_getClassName(self)

    def solve(self, function, value):
        r"""
        Give all the roots found applying the root strategy.

        Parameters
        ----------
        function : :class:`~openturns.Function`
            Function from :math:`\Rset` to :math:`\Rset` along the ray, a linear
            function along the direction.
        value : float

        Returns
        -------
        roots : :class:`~openturns.ScalarCollection`
            All the roots found applying the root strategy.

            - If :class:`~openturns.SafeAndSlow`:
              all the real values :math:`x` such as *function(x) = value* researched in
              each segment of length *stepSize*, within *[origin, maximumDistance]*.

            - If :class:`~openturns.RiskyAndFast`:
              the real value :math:`x` such as *function(x) = value* researched within
              *[origin, maximumDistance]*.

            - If :class:`~openturns.MediumSafe`:
              the real value :math:`x` such as *function(x) = value* researched the
              first segment of length *stepSize*, within *[origin, maximumDistance]*
              where a sign changement of function has been detected.
        """
        return _simulation.RootStrategyImplementationPointer_solve(self, function, value)

    def setSolver(self, solver):
        r"""
        Set the solver.

        Parameters
        ----------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementationPointer_setSolver(self, solver)

    def getSolver(self):
        r"""
        Get the solver.

        Returns
        -------
        solver : :class:`~openturns.Solver`
            Non linear solver which will research the root in a segment.
        """
        return _simulation.RootStrategyImplementationPointer_getSolver(self)

    def setMaximumDistance(self, maximumDistance):
        r"""
        Set the maximum distance.

        Parameters
        ----------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementationPointer_setMaximumDistance(self, maximumDistance)

    def getMaximumDistance(self):
        r"""
        Get the maximum distance.

        Returns
        -------
        maximumDistance : positive float
            Distance from the center of the standard space until which we research an
            intersection with the limit state function along each direction. By
            default, the maximum distance is equal to the value defined through the key
            RootStrategyImplementation-DefaultMaximumDistance of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementationPointer_getMaximumDistance(self)

    def setStepSize(self, stepSize):
        r"""
        Set the step size.

        Parameters
        ----------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementationPointer_setStepSize(self, stepSize)

    def getStepSize(self):
        r"""
        Get the step size.

        Returns
        -------
        stepSize : float
            Length of each segment inside which the root research is performed. By
            default, the step size is equal to the value defined through the key
            RootStrategyImplementation-DefaultStepSize of the
            :class:`~openturns.ResourceMap`.
        """
        return _simulation.RootStrategyImplementationPointer_getStepSize(self)

    def setOriginValue(self, originValue):
        r"""
        Set the origin value.

        Parameters
        ----------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementationPointer_setOriginValue(self, originValue)

    def getOriginValue(self):
        r"""
        Get the origin value.

        Returns
        -------
        origin : float
            Value of the limit state function at the center of the standard space.
        """
        return _simulation.RootStrategyImplementationPointer_getOriginValue(self)

    def __repr__(self):
        return _simulation.RootStrategyImplementationPointer___repr__(self)

    def __eq__(self, arg2):
        return _simulation.RootStrategyImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _simulation.RootStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _simulation.RootStrategyImplementationPointer___str__(self, *args)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _simulation.RootStrategyImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _simulation.RootStrategyImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _simulation.RootStrategyImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _simulation.RootStrategyImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _simulation.RootStrategyImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _simulation.RootStrategyImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _simulation.RootStrategyImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.RootStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.RootStrategyImplementationPointer_setName(self, name)

# Register RootStrategyImplementationPointer in _simulation:
_simulation.RootStrategyImplementationPointer_swigregister(RootStrategyImplementationPointer)

class SamplingStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_simulation.SamplingStrategyImplementationPointer_ptr__get, _simulation.SamplingStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _simulation.SamplingStrategyImplementationPointer_swiginit(self, _simulation.new_SamplingStrategyImplementationPointer(*args))
    __swig_destroy__ = _simulation.delete_SamplingStrategyImplementationPointer

    def reset(self):
        return _simulation.SamplingStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _simulation.SamplingStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _simulation.SamplingStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _simulation.SamplingStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _simulation.SamplingStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _simulation.SamplingStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _simulation.SamplingStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _simulation.SamplingStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _simulation.SamplingStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _simulation.SamplingStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _simulation.SamplingStrategyImplementationPointer_getClassName(self)

    def generate(self):
        r"""
        Generate the sample.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            The sample generated according to the sampling strategy.
        """
        return _simulation.SamplingStrategyImplementationPointer_generate(self)

    def getUniformUnitVectorRealization(self, *args):
        r"""
        Accessor to a realization according to the uniform distribution.

        Parameters
        ----------
        dimension : int
            The dimension of the sphere unity (which is the dimension of the standard
            space).

        Returns
        -------
        sample : :class:`~openturns.Point`
            The realization of a vector on the sphere unity, according to the uniform
            distribution.
        """
        return _simulation.SamplingStrategyImplementationPointer_getUniformUnitVectorRealization(self, *args)

    def setDimension(self, dimension):
        r"""
        Accessor to the dimension.

        Parameters
        ----------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementationPointer_setDimension(self, dimension)

    def getDimension(self):
        r"""
        Accessor to the dimension.

        Returns
        -------
        dimension : int
            Dimension of the standard space.
        """
        return _simulation.SamplingStrategyImplementationPointer_getDimension(self)

    def __repr__(self):
        return _simulation.SamplingStrategyImplementationPointer___repr__(self)

    def __eq__(self, arg2):
        return _simulation.SamplingStrategyImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _simulation.SamplingStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _simulation.SamplingStrategyImplementationPointer___str__(self, *args)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _simulation.SamplingStrategyImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _simulation.SamplingStrategyImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _simulation.SamplingStrategyImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _simulation.SamplingStrategyImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _simulation.SamplingStrategyImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _simulation.SamplingStrategyImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _simulation.SamplingStrategyImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _simulation.SamplingStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _simulation.SamplingStrategyImplementationPointer_setName(self, name)

# Register SamplingStrategyImplementationPointer in _simulation:
_simulation.SamplingStrategyImplementationPointer_swigregister(SamplingStrategyImplementationPointer)



