# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Random vectors."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _randomvector
else:
    import _randomvector

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _randomvector.delete_SwigPyIterator

    def value(self):
        return _randomvector.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _randomvector.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _randomvector.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _randomvector.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _randomvector.SwigPyIterator_equal(self, x)

    def copy(self):
        return _randomvector.SwigPyIterator_copy(self)

    def next(self):
        return _randomvector.SwigPyIterator_next(self)

    def __next__(self):
        return _randomvector.SwigPyIterator___next__(self)

    def previous(self):
        return _randomvector.SwigPyIterator_previous(self)

    def advance(self, n):
        return _randomvector.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _randomvector.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _randomvector.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _randomvector.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _randomvector.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _randomvector.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _randomvector.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _randomvector:
_randomvector.SwigPyIterator_swigregister(SwigPyIterator)


class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class ProcessImplementation(openturns.common.PersistentObject):
    r"""
    Base class for stochastic processes.

    Notes
    -----
    The Process class enables to model a stochastic process.

    A multivariate stochastic process :math:`X` of dimension :math:`d` is defined
    by:

    .. math::

        X: \Omega \times\cD \mapsto \Rset^d

    where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of
    :math:`\Rset^n` discretized on the mesh :math:`\cM`, :math:`\vect{t}\in \cD` is
    a multivariate index and :math:`X(\omega, \vect{t}) \in \Rset^d`.

    A realization of the process :math:`X`, for a given :math:`\omega \in \Omega`
    is :math:`X(\omega): \cD  \mapsto \Rset^d` defined by:

    .. math::

        X(\omega)(\vect{t}) = X(\omega, \vect{t})

    :math:`X_{\vect{t}}: \Omega \rightarrow \Rset^d` is the random variable at
    index :math:`\vect{t} \in \cD` defined by:

    .. math::

        X_{\vect{t}}(\omega) = X(\omega, \vect{t})


    A Process object can be created only through its derived classes:

    :class:`~openturns.SpectralGaussianProcess`,
    :class:`~openturns.GaussianProcess`,
    :class:`~openturns.CompositeProcess`, :class:`~openturns.ARMA`,
    :class:`~openturns.RandomWalk`, :class:`~openturns.FunctionalBasisProcess`
    and :class:`~openturns.WhiteNoise`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.ProcessImplementation_getClassName(self)

    def __repr__(self):
        return _randomvector.ProcessImplementation___repr__(self)

    def __str__(self, *args):
        return _randomvector.ProcessImplementation___str__(self, *args)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _randomvector.ProcessImplementation_isNormal(self)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _randomvector.ProcessImplementation_isStationary(self)

    def isComposite(self):
        r"""
        Test whether the process is composite or not.

        Returns
        -------
        isComposite : bool
            *True* if the process is composite (built upon a function and a process).
        """
        return _randomvector.ProcessImplementation_isComposite(self)

    def getCovarianceModel(self):
        r"""
        Accessor to the covariance model.

        Returns
        -------
        cov_model : :class:`~openturns.CovarianceModel`
            Covariance model, if any.
        """
        return _randomvector.ProcessImplementation_getCovarianceModel(self)

    def getTrend(self):
        r"""
        Accessor to the trend.

        Returns
        -------
        trend : :class:`~openturns.TrendTransform`
            Trend, if any.
        """
        return _randomvector.ProcessImplementation_getTrend(self)

    def getInputDimension(self):
        r"""
        Get the dimension of the domain :math:`\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\cD`: :math:`n`.
        """
        return _randomvector.ProcessImplementation_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the domain :math:`\cD`.

        Returns
        -------
        d : int
            Dimension of the domain :math:`\cD`.
        """
        return _randomvector.ProcessImplementation_getOutputDimension(self)

    def getTimeGrid(self):
        r"""
        Get the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of a process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.ProcessImplementation_getTimeGrid(self)

    def setTimeGrid(self, timeGrid):
        r"""
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.ProcessImplementation_setTimeGrid(self, timeGrid)

    def getMesh(self):
        r"""
        Get the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _randomvector.ProcessImplementation_getMesh(self)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _randomvector.ProcessImplementation_setMesh(self, mesh)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _randomvector.ProcessImplementation_getRealization(self)

    def getContinuousRealization(self):
        r"""
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.Function`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _randomvector.ProcessImplementation_getContinuousRealization(self)

    def getSample(self, size):
        r"""
        Get :math:`n` realizations of the process.

        Parameters
        ----------
        n : int, :math:`n \geq 0`
            Number of realizations of the process needed.

        Returns
        -------
        processSample : :class:`~openturns.ProcessSample`
            :math:`n` realizations of the random process. A process sample is a
            collection of fields which share the same mesh :math:`\cM \in \Rset^n`.
        """
        return _randomvector.ProcessImplementation_getSample(self, size)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _randomvector.ProcessImplementation_getFuture(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _randomvector.ProcessImplementation_getMarginal(self, *args)

    def setDescription(self, description):
        r"""
        Set the description of the process.

        Parameters
        ----------
        description : sequence of str
            Description of the process.
        """
        return _randomvector.ProcessImplementation_setDescription(self, description)

    def getDescription(self):
        r"""
        Get the description of the process.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the process.
        """
        return _randomvector.ProcessImplementation_getDescription(self)

    def __init__(self, *args):
        _randomvector.ProcessImplementation_swiginit(self, _randomvector.new_ProcessImplementation(*args))
    __swig_destroy__ = _randomvector.delete_ProcessImplementation

# Register ProcessImplementation in _randomvector:
_randomvector.ProcessImplementation_swigregister(ProcessImplementation)

class ProcessImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _randomvector.ProcessImplementationTypedInterfaceObject_swiginit(self, _randomvector.new_ProcessImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _randomvector.ProcessImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _randomvector.ProcessImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _randomvector.ProcessImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _randomvector.ProcessImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _randomvector.ProcessImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _randomvector.delete_ProcessImplementationTypedInterfaceObject

# Register ProcessImplementationTypedInterfaceObject in _randomvector:
_randomvector.ProcessImplementationTypedInterfaceObject_swigregister(ProcessImplementationTypedInterfaceObject)

class Process(ProcessImplementationTypedInterfaceObject):
    r"""
    Base class for stochastic processes.

    Notes
    -----
    The Process class enables to model a stochastic process.

    A multivariate stochastic process :math:`X` of dimension :math:`d` is defined
    by:

    .. math::

        X: \Omega \times\cD \mapsto \Rset^d

    where :math:`\omega \in \Omega` is an event, :math:`\cD` is a domain of
    :math:`\Rset^n` discretized on the mesh :math:`\cM`, :math:`\vect{t}\in \cD` is
    a multivariate index and :math:`X(\omega, \vect{t}) \in \Rset^d`.

    A realization of the process :math:`X`, for a given :math:`\omega \in \Omega`
    is :math:`X(\omega): \cD  \mapsto \Rset^d` defined by:

    .. math::

        X(\omega)(\vect{t}) = X(\omega, \vect{t})

    :math:`X_{\vect{t}}: \Omega \rightarrow \Rset^d` is the random variable at
    index :math:`\vect{t} \in \cD` defined by:

    .. math::

        X_{\vect{t}}(\omega) = X(\omega, \vect{t})


    A Process object can be created only through its derived classes:

    :class:`~openturns.SpectralGaussianProcess`,
    :class:`~openturns.GaussianProcess`,
    :class:`~openturns.CompositeProcess`, :class:`~openturns.ARMA`,
    :class:`~openturns.RandomWalk`, :class:`~openturns.FunctionalBasisProcess`
    and :class:`~openturns.WhiteNoise`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.Process_getClassName(self)

    def __repr__(self):
        return _randomvector.Process___repr__(self)

    def __str__(self, *args):
        return _randomvector.Process___str__(self, *args)

    def setDescription(self, description):
        r"""
        Set the description of the process.

        Parameters
        ----------
        description : sequence of str
            Description of the process.
        """
        return _randomvector.Process_setDescription(self, description)

    def getDescription(self):
        r"""
        Get the description of the process.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the process.
        """
        return _randomvector.Process_getDescription(self)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _randomvector.Process_isNormal(self)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _randomvector.Process_isStationary(self)

    def isComposite(self):
        r"""
        Test whether the process is composite or not.

        Returns
        -------
        isComposite : bool
            *True* if the process is composite (built upon a function and a process).
        """
        return _randomvector.Process_isComposite(self)

    def getCovarianceModel(self):
        r"""
        Accessor to the covariance model.

        Returns
        -------
        cov_model : :class:`~openturns.CovarianceModel`
            Covariance model, if any.
        """
        return _randomvector.Process_getCovarianceModel(self)

    def getTrend(self):
        r"""
        Accessor to the trend.

        Returns
        -------
        trend : :class:`~openturns.TrendTransform`
            Trend, if any.
        """
        return _randomvector.Process_getTrend(self)

    def getInputDimension(self):
        r"""
        Get the dimension of the domain :math:`\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\cD`: :math:`n`.
        """
        return _randomvector.Process_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the domain :math:`\cD`.

        Returns
        -------
        d : int
            Dimension of the domain :math:`\cD`.
        """
        return _randomvector.Process_getOutputDimension(self)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _randomvector.Process_getRealization(self)

    def getContinuousRealization(self):
        r"""
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.Function`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _randomvector.Process_getContinuousRealization(self)

    def getTimeGrid(self):
        r"""
        Get the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of a process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.Process_getTimeGrid(self)

    def setTimeGrid(self, timeGrid):
        r"""
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.Process_setTimeGrid(self, timeGrid)

    def getMesh(self):
        r"""
        Get the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _randomvector.Process_getMesh(self)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _randomvector.Process_setMesh(self, mesh)

    def getSample(self, size):
        r"""
        Get :math:`n` realizations of the process.

        Parameters
        ----------
        n : int, :math:`n \geq 0`
            Number of realizations of the process needed.

        Returns
        -------
        processSample : :class:`~openturns.ProcessSample`
            :math:`n` realizations of the random process. A process sample is a
            collection of fields which share the same mesh :math:`\cM \in \Rset^n`.
        """
        return _randomvector.Process_getSample(self, size)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _randomvector.Process_getFuture(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _randomvector.Process_getMarginal(self, *args)

    def __init__(self, *args):
        _randomvector.Process_swiginit(self, _randomvector.new_Process(*args))
    __swig_destroy__ = _randomvector.delete_Process

# Register Process in _randomvector:
_randomvector.Process_swigregister(Process)

class RandomVectorImplementation(openturns.common.PersistentObject):
    r"""
    Random vectors.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        Distribution of the :class:`~openturns.UsualRandomVector` to define.

    Notes
    -----
    A :class:`~openturns.RandomVector` provides at least a way to generate realizations.

    See also
    --------
    UsualRandomVector, CompositeRandomVector, ConditionalRandomVector,
    ConstantRandomVector, FunctionalChaosRandomVector, Event,
    PythonRandomVector
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.RandomVectorImplementation_getClassName(self)

    def __repr__(self):
        return _randomvector.RandomVectorImplementation___repr__(self)

    def isComposite(self):
        r"""
        Accessor to know if the RandomVector is a composite one.

        Returns
        -------
        isComposite : bool
            Indicates if the RandomVector is of type Composite or not.
        """
        return _randomvector.RandomVectorImplementation_isComposite(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _randomvector.RandomVectorImplementation_getDimension(self)

    def getRealization(self):
        r"""
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _randomvector.RandomVectorImplementation_getRealization(self)

    def getSample(self, size):
        r"""
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _randomvector.RandomVectorImplementation_getSample(self, size)

    def getMean(self):
        r"""
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _randomvector.RandomVectorImplementation_getMean(self)

    def getCovariance(self):
        r"""
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _randomvector.RandomVectorImplementation_getCovariance(self)

    def getMarginal(self, *args):
        r"""
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\vect{Y}=\Tr{(Y_1,\dots,Y_n)}` a random vector and
        :math:`I \in [1,n]` a set of indices. If :math:`\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\tilde{\vect{Y}}=\Tr{(Y_i)}_{i \in I}`. If :math:`\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\vect{Y}=f(\vect{X})` with :math:`f=(f_1,\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\tilde{\vect{Y}}=(f_i(\vect{X}))_{i \in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _randomvector.RandomVectorImplementation_getMarginal(self, *args)

    def getAntecedent(self):
        r"""
        Accessor to the antecedent RandomVector in case of a composite RandomVector.

        Returns
        -------
        antecedent : :class:`~openturns.RandomVector`
            Antecedent RandomVector :math:`\vect{X}` in case of a
            :class:`~openturns.CompositeRandomVector` such as:
            :math:`\vect{Y}=f(\vect{X})`.
        """
        return _randomvector.RandomVectorImplementation_getAntecedent(self)

    def getFunction(self):
        r"""
        Accessor to the Function in case of a composite RandomVector.

        Returns
        -------
        function : :class:`~openturns.Function`
            Function used to define a :class:`~openturns.CompositeRandomVector` as the
            image through this function of the antecedent :math:`\vect{X}`:
            :math:`\vect{Y}=f(\vect{X})`.
        """
        return _randomvector.RandomVectorImplementation_getFunction(self)

    def getDistribution(self):
        r"""
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _randomvector.RandomVectorImplementation_getDistribution(self)

    def getOperator(self):
        r"""
        Accessor to the comparaison operator of the Event.

        Returns
        -------
        operator : :class:`~openturns.ComparisonOperator`
            Comparaison operator used to define the :class:`~openturns.RandomVector`.
        """
        return _randomvector.RandomVectorImplementation_getOperator(self)

    def getDomain(self):
        r"""
        Accessor to the domain of the Event.

        Returns
        -------
        domain : :class:`~openturns.Domain`
            Describes the domain of an event.
        """
        return _randomvector.RandomVectorImplementation_getDomain(self)

    def getProcess(self):
        r"""
        Get the stochastic process.

        Returns
        -------
        process : :class:`~openturns.Process`
            Stochastic process used to define the :class:`~openturns.RandomVector`.
        """
        return _randomvector.RandomVectorImplementation_getProcess(self)

    def getThreshold(self):
        r"""
        Accessor to the threshold of the Event.

        Returns
        -------
        threshold : float
            Threshold of the :class:`~openturns.RandomVector`.
        """
        return _randomvector.RandomVectorImplementation_getThreshold(self)

    def setDescription(self, description):
        r"""
        Accessor to the description of the RandomVector.

        Parameters
        ----------
        description : str or sequence of str
            Describes the components of the RandomVector.
        """
        return _randomvector.RandomVectorImplementation_setDescription(self, description)

    def getDescription(self):
        r"""
        Accessor to the description of the RandomVector.

        Returns
        -------
        description : :class:`~openturns.Description`
            Describes the components of the RandomVector.
        """
        return _randomvector.RandomVectorImplementation_getDescription(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _randomvector.RandomVectorImplementation_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _randomvector.RandomVectorImplementation_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _randomvector.RandomVectorImplementation_getParameterDescription(self)

    def isEvent(self):
        r"""
        Whether the random vector is an event.

        Returns
        -------
        isEvent : bool
            Whether it takes it values in {0, 1}.
        """
        return _randomvector.RandomVectorImplementation_isEvent(self)

    def __init__(self, *args):
        _randomvector.RandomVectorImplementation_swiginit(self, _randomvector.new_RandomVectorImplementation(*args))
    __swig_destroy__ = _randomvector.delete_RandomVectorImplementation

# Register RandomVectorImplementation in _randomvector:
_randomvector.RandomVectorImplementation_swigregister(RandomVectorImplementation)

class ConstantRandomVector(RandomVectorImplementation):
    r"""
    Constant Random Vector.

    Allows to define a constant random variable.

    Parameters
    ----------
    point : sequence of float
        Constant value

    Examples
    --------
    >>> import openturns as ot
    >>> X = ot.ConstantRandomVector([5.0, 6.0])

    Draw a sample:

    >>> sample = X.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.ConstantRandomVector_getClassName(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _randomvector.ConstantRandomVector_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _randomvector.ConstantRandomVector_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _randomvector.ConstantRandomVector_getParameterDescription(self)

    def __repr__(self):
        return _randomvector.ConstantRandomVector___repr__(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _randomvector.ConstantRandomVector_getDimension(self)

    def getRealization(self):
        r"""
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _randomvector.ConstantRandomVector_getRealization(self)

    def getSample(self, size):
        r"""
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _randomvector.ConstantRandomVector_getSample(self, size)

    def getMean(self):
        r"""
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _randomvector.ConstantRandomVector_getMean(self)

    def getCovariance(self):
        r"""
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _randomvector.ConstantRandomVector_getCovariance(self)

    def getMarginal(self, *args):
        r"""
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\vect{Y}=\Tr{(Y_1,\dots,Y_n)}` a random vector and
        :math:`I \in [1,n]` a set of indices. If :math:`\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\tilde{\vect{Y}}=\Tr{(Y_i)}_{i \in I}`. If :math:`\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\vect{Y}=f(\vect{X})` with :math:`f=(f_1,\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\tilde{\vect{Y}}=(f_i(\vect{X}))_{i \in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _randomvector.ConstantRandomVector_getMarginal(self, *args)

    def getDistribution(self):
        r"""
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _randomvector.ConstantRandomVector_getDistribution(self)

    def __init__(self, *args):
        _randomvector.ConstantRandomVector_swiginit(self, _randomvector.new_ConstantRandomVector(*args))
    __swig_destroy__ = _randomvector.delete_ConstantRandomVector

# Register ConstantRandomVector in _randomvector:
_randomvector.ConstantRandomVector_swigregister(ConstantRandomVector)

class UsualRandomVector(RandomVectorImplementation):
    r"""
    Random Vector from a distribution.

    Parameters
    ----------
    X : :class:`~openturns.Distribution`
       Distribution of X.

    Examples
    --------
    >>> import openturns as ot
    >>> X = ot.RandomVector(ot.Normal())

    # Draw a sample
    >>> sample = X.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.UsualRandomVector_getClassName(self)

    def __repr__(self):
        return _randomvector.UsualRandomVector___repr__(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _randomvector.UsualRandomVector_getDimension(self)

    def getRealization(self):
        r"""
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _randomvector.UsualRandomVector_getRealization(self)

    def getSample(self, size):
        r"""
        Compute realizations of the RandomVector.

        Parameters
        ----------
        n : int, :math:`n \geq 0`
            Number of realizations needed.

        Returns
        -------
        realizations : :class:`~openturns.Sample`
            n sequences of values randomly determined from the RandomVector definition.
            In the case of an event: n realizations of the event (considered as a
            Bernoulli variable) which are boolean values (1 for the realization of the
            event and 0 else).

        See also
        --------
        getRealization

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getSample(3))
            [ X0        X1        ]
        0 : [  0.608202 -1.26617  ]
        1 : [ -0.438266  1.20548  ]
        2 : [ -2.18139   0.350042 ]
        """
        return _randomvector.UsualRandomVector_getSample(self, size)

    def getMean(self):
        r"""
        Accessor to the mean of the RandomVector.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Mean of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMean())
        [0,0.5]
        """
        return _randomvector.UsualRandomVector_getMean(self)

    def getCovariance(self):
        r"""
        Accessor to the covariance of the RandomVector.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Covariance of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.5], [1.0, 1.5], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getCovariance())
        [[ 1    0    ]
         [ 0    2.25 ]]
        """
        return _randomvector.UsualRandomVector_getCovariance(self)

    def getMarginal(self, *args):
        r"""
        Get the random vector corresponding to the :math:`i^{th}` marginal component(s).

        Parameters
        ----------
        i : int or list of ints, :math:`0\leq i < dim`
            Indicates the component(s) concerned. :math:`dim` is the dimension of the
            RandomVector.

        Returns
        -------
        vector :  :class:`~openturns.RandomVector`
            RandomVector restricted to the concerned components.

        Notes
        -----
        Let's note :math:`\vect{Y}=\Tr{(Y_1,\dots,Y_n)}` a random vector and
        :math:`I \in [1,n]` a set of indices. If :math:`\vect{Y}` is a
        :class:`~openturns.UsualRandomVector`, the subvector is defined by
        :math:`\tilde{\vect{Y}}=\Tr{(Y_i)}_{i \in I}`. If :math:`\vect{Y}` is a
        :class:`~openturns.CompositeRandomVector`, defined by
        :math:`\vect{Y}=f(\vect{X})` with :math:`f=(f_1,\dots,f_n)`,
        :math:`f_i` some scalar functions, the subvector is
        :math:`\tilde{\vect{Y}}=(f_i(\vect{X}))_{i \in I}`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getMarginal(1).getRealization())
        [0.608202]
        >>> print(randomVector.getMarginal(1).getDistribution())
        Normal(mu = 0, sigma = 1)
        """
        return _randomvector.UsualRandomVector_getMarginal(self, *args)

    def getDistribution(self):
        r"""
        Accessor to the distribution of the RandomVector.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution of the considered :class:`~openturns.UsualRandomVector`.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getDistribution())
        Normal(mu = [0,0], sigma = [1,1], R = [[ 1 0 ]
         [ 0 1 ]])
        """
        return _randomvector.UsualRandomVector_getDistribution(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _randomvector.UsualRandomVector_getParameter(self)

    def setParameter(self, parameters):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _randomvector.UsualRandomVector_setParameter(self, parameters)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _randomvector.UsualRandomVector_getParameterDescription(self)

    def __init__(self, *args):
        _randomvector.UsualRandomVector_swiginit(self, _randomvector.new_UsualRandomVector(*args))
    __swig_destroy__ = _randomvector.delete_UsualRandomVector

# Register UsualRandomVector in _randomvector:
_randomvector.UsualRandomVector_swigregister(UsualRandomVector)

class ProcessImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_randomvector.ProcessImplementationPointer_ptr__get, _randomvector.ProcessImplementationPointer_ptr__set)

    def __init__(self, *args):
        _randomvector.ProcessImplementationPointer_swiginit(self, _randomvector.new_ProcessImplementationPointer(*args))
    __swig_destroy__ = _randomvector.delete_ProcessImplementationPointer

    def reset(self):
        return _randomvector.ProcessImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _randomvector.ProcessImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _randomvector.ProcessImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _randomvector.ProcessImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _randomvector.ProcessImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _randomvector.ProcessImplementationPointer_get(self)

    def getImplementation(self):
        return _randomvector.ProcessImplementationPointer_getImplementation(self)

    def unique(self):
        return _randomvector.ProcessImplementationPointer_unique(self)

    def use_count(self):
        return _randomvector.ProcessImplementationPointer_use_count(self)

    def swap(self, other):
        return _randomvector.ProcessImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _randomvector.ProcessImplementationPointer_getClassName(self)

    def __repr__(self):
        return _randomvector.ProcessImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _randomvector.ProcessImplementationPointer___str__(self, *args)

    def isNormal(self):
        r"""
        Test whether the process is normal or not.

        Returns
        -------
        isNormal : bool
            *True* if the process is normal.

        Notes
        -----
        A stochastic process is normal if all its finite dimensional joint
        distributions are normal, which means that for all :math:`k \in \Nset` and
        :math:`I_k \in \Nset^*`, with :math:`cardI_k=k`, there is
        :math:`\vect{m}_1, \dots, \vect{m}_k \in \Rset^d` and
        :math:`\mat{C}_{1,\dots,k}\in\mathcal{M}_{kd,kd}(\Rset)` such that:

        .. math::

            \Expect{\exp\left\{i\Tr{\vect{X}}_{I_k} \vect{U}_{k}  \right\}} =
            \exp{\left\{i\Tr{\vect{U}}_{k}\vect{M}_{k}-\frac{1}{2}\Tr{\vect{U}}_{k}\mat{C}_{1,\dots,k}\vect{U}_{k}\right\}}

        where :math:`\Tr{\vect{X}}_{I_k} = (\Tr{X}_{\vect{t}_1}, \hdots, \Tr{X}_{\vect{t}_k})`,
        :math:`\\Tr{vect{U}}_{k} = (\Tr{\vect{u}}_{1}, \hdots, \Tr{\vect{u}}_{k})` and
        :math:`\Tr{\vect{M}}_{k} = (\Tr{\vect{m}}_{1}, \hdots, \Tr{\vect{m}}_{k})` and
        :math:`\mat{C}_{1,\dots,k}` is the symmetric matrix:

        .. math::

          \mat{C}_{1,\dots,k} = \left(
          \begin{array}{cccc}
            C(\vect{t}_1, \vect{t}_1) &C(\vect{t}_1, \vect{t}_2) & \hdots & C(\vect{t}_1, \vect{t}_{k}) \\
            \hdots & C(\vect{t}_2, \vect{t}_2)  & \hdots & C(\vect{t}_2, \vect{t}_{k}) \\
            \hdots & \hdots & \hdots & \hdots \\
            \hdots & \hdots & \hdots & C(\vect{t}_{k}, \vect{t}_{k})
          \end{array}
          \right)

        A Gaussian process is entirely defined by its mean function :math:`m` and its
        covariance function :math:`C` (or correlation function :math:`R`).
        """
        return _randomvector.ProcessImplementationPointer_isNormal(self)

    def isStationary(self):
        r"""
        Test whether the process is stationary or not.

        Returns
        -------
        isStationary : bool
            *True* if the process is stationary.

        Notes
        -----
        A process :math:`X` is stationary if its distribution is invariant by
        translation: :math:`\forall k \in \Nset`,
        :math:`\forall (\vect{t}_1, \dots, \vect{t}_k) \in \cD`,
        :math:`\forall \vect{h}\in \Rset^n`, we have:

        .. math::

            (X_{\vect{t}_1}, \dots, X_{\vect{t}_k})
            \stackrel{\mathcal{D}}{=} (X_{\vect{t}_1+\vect{h}}, \dots, X_{\vect{t}_k+\vect{h}})

        """
        return _randomvector.ProcessImplementationPointer_isStationary(self)

    def isComposite(self):
        r"""
        Test whether the process is composite or not.

        Returns
        -------
        isComposite : bool
            *True* if the process is composite (built upon a function and a process).
        """
        return _randomvector.ProcessImplementationPointer_isComposite(self)

    def getCovarianceModel(self):
        r"""
        Accessor to the covariance model.

        Returns
        -------
        cov_model : :class:`~openturns.CovarianceModel`
            Covariance model, if any.
        """
        return _randomvector.ProcessImplementationPointer_getCovarianceModel(self)

    def getTrend(self):
        r"""
        Accessor to the trend.

        Returns
        -------
        trend : :class:`~openturns.TrendTransform`
            Trend, if any.
        """
        return _randomvector.ProcessImplementationPointer_getTrend(self)

    def getInputDimension(self):
        r"""
        Get the dimension of the domain :math:`\cD`.

        Returns
        -------
        n : int
            Dimension of the domain :math:`\cD`: :math:`n`.
        """
        return _randomvector.ProcessImplementationPointer_getInputDimension(self)

    def getOutputDimension(self):
        r"""
        Get the dimension of the domain :math:`\cD`.

        Returns
        -------
        d : int
            Dimension of the domain :math:`\cD`.
        """
        return _randomvector.ProcessImplementationPointer_getOutputDimension(self)

    def getTimeGrid(self):
        r"""
        Get the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of a process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.ProcessImplementationPointer_getTimeGrid(self)

    def setTimeGrid(self, timeGrid):
        r"""
        Set the time grid of observation of the process.

        Returns
        -------
        timeGrid : :class:`~openturns.RegularGrid`
            Time grid of observation of the process when the mesh associated to the
            process can be interpreted as a :class:`~openturns.RegularGrid`. We check
            if the vertices of the mesh are scalar and are regularly spaced in
            :math:`\Rset` but we don't check if the connectivity of the mesh is conform
            to the one of a regular grid (without any hole and composed of ordered
            instants).
        """
        return _randomvector.ProcessImplementationPointer_setTimeGrid(self, timeGrid)

    def getMesh(self):
        r"""
        Get the mesh.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _randomvector.ProcessImplementationPointer_getMesh(self)

    def setMesh(self, mesh):
        r"""
        Set the mesh.

        Parameters
        ----------
        mesh : :class:`~openturns.Mesh`
            Mesh over which the domain :math:`\cD` is discretized.
        """
        return _randomvector.ProcessImplementationPointer_setMesh(self, mesh)

    def getRealization(self):
        r"""
        Get a realization of the process.

        Returns
        -------
        realization : :class:`~openturns.Field`
            Contains a mesh over which the process is discretized and the values of the
            process at the vertices of the mesh.
        """
        return _randomvector.ProcessImplementationPointer_getRealization(self)

    def getContinuousRealization(self):
        r"""
        Get a continuous realization.

        Returns
        -------
        realization : :class:`~openturns.Function`
            According to the process, the continuous realizations are built:

            - either using a dedicated functional model if it exists: e.g. a functional
              basis process.

            - or using an interpolation from a discrete realization of the process on
              :math:`\cM`: in dimension :math:`d=1`, a linear interpolation and in
              dimension :math:`d \geq 2`, a piecewise constant function (the value at a
              given position is equal to the value at the nearest vertex of the mesh of
              the process).
        """
        return _randomvector.ProcessImplementationPointer_getContinuousRealization(self)

    def getSample(self, size):
        r"""
        Get :math:`n` realizations of the process.

        Parameters
        ----------
        n : int, :math:`n \geq 0`
            Number of realizations of the process needed.

        Returns
        -------
        processSample : :class:`~openturns.ProcessSample`
            :math:`n` realizations of the random process. A process sample is a
            collection of fields which share the same mesh :math:`\cM \in \Rset^n`.
        """
        return _randomvector.ProcessImplementationPointer_getSample(self, size)

    def getFuture(self, *args):
        r"""
        Prediction of the :math:`N` future iterations of the process.

        Parameters
        ----------
        stepNumber : int, :math:`N \geq 0`
            Number of future steps.
        size : int, :math:`size \geq 0`, optional
            Number of futures needed. Default is 1.

        Returns
        -------
        prediction : :class:`~openturns.ProcessSample` or :class:`~openturns.TimeSeries`
            :math:`N` future iterations of the process.
            If :math:`size = 1`, *prediction* is a :class:`~openturns.TimeSeries`.
            Otherwise, it is a :class:`~openturns.ProcessSample`.
        """
        return _randomvector.ProcessImplementationPointer_getFuture(self, *args)

    def getMarginal(self, *args):
        r"""
        Get the :math:`k^{th}` marginal of the random process.

        Parameters
        ----------
        k : int or list of ints :math:`0 \leq k < d`
            Index of the marginal(s) needed.

        Returns
        -------
        marginals : :class:`~openturns.Process`
            Process defined with marginal(s) of the random process.
        """
        return _randomvector.ProcessImplementationPointer_getMarginal(self, *args)

    def setDescription(self, description):
        r"""
        Set the description of the process.

        Parameters
        ----------
        description : sequence of str
            Description of the process.
        """
        return _randomvector.ProcessImplementationPointer_setDescription(self, description)

    def getDescription(self):
        r"""
        Get the description of the process.

        Returns
        -------
        description : :class:`~openturns.Description`
            Description of the process.
        """
        return _randomvector.ProcessImplementationPointer_getDescription(self)

    def __eq__(self, arg2):
        return _randomvector.ProcessImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _randomvector.ProcessImplementationPointer___ne__(self, other)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _randomvector.ProcessImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _randomvector.ProcessImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _randomvector.ProcessImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _randomvector.ProcessImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _randomvector.ProcessImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _randomvector.ProcessImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _randomvector.ProcessImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _randomvector.ProcessImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _randomvector.ProcessImplementationPointer_setName(self, name)

# Register ProcessImplementationPointer in _randomvector:
_randomvector.ProcessImplementationPointer_swigregister(ProcessImplementationPointer)



