# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Geometrical classes."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _geom
else:
    import _geom

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _geom.delete_SwigPyIterator

    def value(self):
        return _geom.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _geom.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _geom.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _geom.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _geom.SwigPyIterator_equal(self, x)

    def copy(self):
        return _geom.SwigPyIterator_copy(self)

    def next(self):
        return _geom.SwigPyIterator_next(self)

    def __next__(self):
        return _geom.SwigPyIterator___next__(self)

    def previous(self):
        return _geom.SwigPyIterator_previous(self)

    def advance(self, n):
        return _geom.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _geom.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _geom.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _geom.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _geom.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _geom.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _geom.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _geom:
_geom.SwigPyIterator_swigregister(SwigPyIterator)


class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.common
import openturns.typ
class NearestNeighbourAlgorithmImplementation(openturns.common.PersistentObject):
    r"""
    Nearest neighbour lookup.

    Base class to define an algorithm to search for nearest neighbours of
    a list of points.

    Available constructors:
        NearestNeighbourAlgorithm(*sample*)

    Parameters
    ----------
    sample : :class:`~openturns.Sample`
        Input points.

    Notes
    -----

    Two algorithms can be selected in any dimension:

    * :class:`~openturns.NaiveNearestNeighbour` loops over all points
      of the sample to find the closest one.
    * :class:`~openturns.KDTree` builds a binary tree.

    Two algorithms are specific to 1D input dimension, and much more efficient:

    * :class:`~openturns.RegularGridNearestNeighbour` is the most efficient
      algorithm when points corresponds to a :class:`~openturns.RegularGrid`,
      :meth:`query` works in constant time.
    * :class:`~openturns.NearestNeighbour1D` looks for nearest neighbour by
      dichotomy in 1D.

    It is recommended to use derived classes in order to select the best algorithm
    according to your data.  If you create a generic :class:`NearestNeighbourAlgorithm`,
    here is how the derived class is selected:

    * If points correspond to a :class:`~openturns.RegularGrid`,
      :class:`~openturns.RegularGridNearestNeighbour` algorithm is selected.
    * If input dimension is 1, :class:`~openturns.NearestNeighbour1D` is selected.
    * Otherwise, :class:`~openturns.KDTree` is selected.

    See also
    --------
    KDTree, NearestNeighbour1D, RegularGridNearestNeighbour, NaiveNearestNeighbour

    Examples
    --------
    >>> import openturns as ot
    >>> sample = ot.Normal(2).getSample(10)
    >>> finder = ot.NearestNeighbourAlgorithm(sample)
    >>> neighbour = sample[finder.query([0.1, 0.2])]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.NearestNeighbourAlgorithmImplementation_getClassName(self)

    def getSample(self):
        r"""
        Get the points which have been used to build this nearest neighbour algorithm.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Input points.
        """
        return _geom.NearestNeighbourAlgorithmImplementation_getSample(self)

    def setSample(self, sample):
        r"""
        Build a NearestNeighbourAlgorithm from these points.

        Parameters
        ----------
        sample : :class:`~openturns.Sample`
            Input points.
        """
        return _geom.NearestNeighbourAlgorithmImplementation_setSample(self, sample)

    def query(self, *args):
        r"""
        Get the index of the nearest neighbour of the given point.

        Available usages:
            query(*point*)

            query(*sample*)

        Parameters
        ----------
        point : sequence of float
            Given point.
        sample : 2-d sequence of float
            Given points.

        Returns
        -------
        index : int
            Index of the nearest neighbour of the given point.
        indices : :class:`openturns.Indices`
            Index of the nearest neighbour of the given points.
        """
        return _geom.NearestNeighbourAlgorithmImplementation_query(self, *args)

    def queryK(self, x, k, sorted=False):
        r"""
        Get the indices of nearest neighbours of the given point.

        Parameters
        ----------
        x : sequence of float
            Given point.
        k : int
            Number of indices to return.
        sorted : bool, optional
            Boolean to tell whether returned indices are sorted according to
            the distance to the given point.

        Returns
        -------
        indices : sequence of int
            Indices of the `k` nearest neighbours of the given point.
        """
        return _geom.NearestNeighbourAlgorithmImplementation_queryK(self, x, k, sorted)

    def __repr__(self):
        return _geom.NearestNeighbourAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _geom.NearestNeighbourAlgorithmImplementation___str__(self, *args)

    def __init__(self, *args):
        _geom.NearestNeighbourAlgorithmImplementation_swiginit(self, _geom.new_NearestNeighbourAlgorithmImplementation(*args))
    __swig_destroy__ = _geom.delete_NearestNeighbourAlgorithmImplementation

# Register NearestNeighbourAlgorithmImplementation in _geom:
_geom.NearestNeighbourAlgorithmImplementation_swigregister(NearestNeighbourAlgorithmImplementation)

class NearestNeighbourAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _geom.NearestNeighbourAlgorithmImplementationTypedInterfaceObject_swiginit(self, _geom.new_NearestNeighbourAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _geom.NearestNeighbourAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _geom.NearestNeighbourAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _geom.NearestNeighbourAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _geom.NearestNeighbourAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _geom.NearestNeighbourAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _geom.delete_NearestNeighbourAlgorithmImplementationTypedInterfaceObject

# Register NearestNeighbourAlgorithmImplementationTypedInterfaceObject in _geom:
_geom.NearestNeighbourAlgorithmImplementationTypedInterfaceObject_swigregister(NearestNeighbourAlgorithmImplementationTypedInterfaceObject)

class NearestNeighbourAlgorithm(NearestNeighbourAlgorithmImplementationTypedInterfaceObject):
    r"""
    Nearest neighbour lookup.

    Base class to define an algorithm to search for nearest neighbours of
    a list of points.

    Available constructors:
        NearestNeighbourAlgorithm(*sample*)

    Parameters
    ----------
    sample : :class:`~openturns.Sample`
        Input points.

    Notes
    -----

    Two algorithms can be selected in any dimension:

    * :class:`~openturns.NaiveNearestNeighbour` loops over all points
      of the sample to find the closest one.
    * :class:`~openturns.KDTree` builds a binary tree.

    Two algorithms are specific to 1D input dimension, and much more efficient:

    * :class:`~openturns.RegularGridNearestNeighbour` is the most efficient
      algorithm when points corresponds to a :class:`~openturns.RegularGrid`,
      :meth:`query` works in constant time.
    * :class:`~openturns.NearestNeighbour1D` looks for nearest neighbour by
      dichotomy in 1D.

    It is recommended to use derived classes in order to select the best algorithm
    according to your data.  If you create a generic :class:`NearestNeighbourAlgorithm`,
    here is how the derived class is selected:

    * If points correspond to a :class:`~openturns.RegularGrid`,
      :class:`~openturns.RegularGridNearestNeighbour` algorithm is selected.
    * If input dimension is 1, :class:`~openturns.NearestNeighbour1D` is selected.
    * Otherwise, :class:`~openturns.KDTree` is selected.

    See also
    --------
    KDTree, NearestNeighbour1D, RegularGridNearestNeighbour, NaiveNearestNeighbour

    Examples
    --------
    >>> import openturns as ot
    >>> sample = ot.Normal(2).getSample(10)
    >>> finder = ot.NearestNeighbourAlgorithm(sample)
    >>> neighbour = sample[finder.query([0.1, 0.2])]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.NearestNeighbourAlgorithm_getClassName(self)

    def getSample(self):
        r"""
        Get the points which have been used to build this nearest neighbour algorithm.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            Input points.
        """
        return _geom.NearestNeighbourAlgorithm_getSample(self)

    def setSample(self, sample):
        r"""
        Build a NearestNeighbourAlgorithm from these points.

        Parameters
        ----------
        sample : :class:`~openturns.Sample`
            Input points.
        """
        return _geom.NearestNeighbourAlgorithm_setSample(self, sample)

    def query(self, *args):
        r"""
        Get the index of the nearest neighbour of the given point.

        Available usages:
            query(*point*)

            query(*sample*)

        Parameters
        ----------
        point : sequence of float
            Given point.
        sample : 2-d sequence of float
            Given points.

        Returns
        -------
        index : int
            Index of the nearest neighbour of the given point.
        indices : :class:`openturns.Indices`
            Index of the nearest neighbour of the given points.
        """
        return _geom.NearestNeighbourAlgorithm_query(self, *args)

    def queryK(self, x, k, sorted=False):
        r"""
        Get the indices of nearest neighbours of the given point.

        Parameters
        ----------
        x : sequence of float
            Given point.
        k : int
            Number of indices to return.
        sorted : bool, optional
            Boolean to tell whether returned indices are sorted according to
            the distance to the given point.

        Returns
        -------
        indices : sequence of int
            Indices of the `k` nearest neighbours of the given point.
        """
        return _geom.NearestNeighbourAlgorithm_queryK(self, x, k, sorted)

    def __repr__(self):
        return _geom.NearestNeighbourAlgorithm___repr__(self)

    def __str__(self, *args):
        return _geom.NearestNeighbourAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _geom.NearestNeighbourAlgorithm_swiginit(self, _geom.new_NearestNeighbourAlgorithm(*args))
    __swig_destroy__ = _geom.delete_NearestNeighbourAlgorithm

# Register NearestNeighbourAlgorithm in _geom:
_geom.NearestNeighbourAlgorithm_swigregister(NearestNeighbourAlgorithm)

class EnclosingSimplexAlgorithmImplementation(openturns.common.PersistentObject):
    r"""
    Point location algorithm.

    Base class to define an algorithm to find simplices containing
    a list of points.

    Available constructors:
        EnclosingSimplexAlgorithm(*vertices, simplices*)

    Parameters
    ----------
    vertices : :class:`~openturns.Sample`
        Vertices.

    simplices : :class:`~openturns.IndicesCollection`
        Simplices.

    Notes
    -----

    Two algorithms can be selected in any dimension:

    * :class:`~openturns.NaiveEnclosingSimplex` loops over all simplices
      and stops when the given point is inside.
    * :class:`~openturns.BoundingVolumeHierarchy` builds a binary tree based
      on bounding box of simplices.

    Two algorithms are specific to 1D meshes, and much more efficient:

    * :class:`~openturns.RegularGridEnclosingSimplex` is the most efficient
      algorithm when mesh corresponds to a :class:`~openturns.RegularGrid`,
      :meth:`query` works in constant time.
    * :class:`~openturns.EnclosingSimplexMonotonic1D` looks for enclosing
      simplex by dichotomy, it only works for sorted 1D meshes.

    It is recommended to use derived classes in order to select the best algorithm
    according to your data.  If you create a generic :class:`EnclosingSimplexAlgorithm`,
    here is how the derived class is selected:

    * If vertices and simplices correspond to a :class:`~openturns.RegularGrid`,
      :class:`~openturns.RegularGridEnclosingSimplex` algorithm is selected.
    * If vertices and simplices correspond to a simple 1D mesh with sorted vertices,
      :class:`~openturns.EnclosingSimplexMonotonic1D` algorithm is selected.
    * Otherwise, 'EnclosingSimplexAlgorithm-LargeDimension' :class:`~openturns.ResourceMap`
      entry is read.  If input dimension is lower than this value,
      :class:`~openturns.BoundingVolumeHierarchy` algorithm is chosen, otherwise
      it is :class:`~openturns.NaiveEnclosingSimplex`.

    See also
    --------
    NaiveEnclosingSimplex, BoundingVolumeHierarchy, RegularGridEnclosingSimplex,
    EnclosingSimplexMonotonic1D

    Examples
    --------
    >>> import openturns as ot
    >>> mesher = ot.IntervalMesher([5, 10])
    >>> lowerbound = [0.0, 0.0]
    >>> upperBound = [2.0, 4.0]
    >>> interval = ot.Interval(lowerbound, upperBound)
    >>> mesh = mesher.build(interval)
    >>> locator = ot.EnclosingSimplexAlgorithm(mesh.getVertices(), mesh.getSimplices())
    >>> simplex = locator.query([0.1, 0.2])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.EnclosingSimplexAlgorithmImplementation_getClassName(self)

    def getVertices(self):
        r"""
        Collection of vertices accessor.

        Returns
        -------
        vertices : :class:`~openturns.Sample`
            Collection of points.
        """
        return _geom.EnclosingSimplexAlgorithmImplementation_getVertices(self)

    def getSimplices(self):
        r"""
        Collection of simplex accessor.

        Returns
        -------
        simplices : :class:`~openturns.IndicesCollection`
            Collection of simplices.
        """
        return _geom.EnclosingSimplexAlgorithmImplementation_getSimplices(self)

    def setVerticesAndSimplices(self, vertices, simplices):
        r"""
        Rebuild a new data structure for these vertices and simplices.

        Parameters
        ----------
        vertices : :class:`~openturns.Sample`
            Vertices.

        simplices : :class:`~openturns.IndicesCollection`
            Simplices.
        """
        return _geom.EnclosingSimplexAlgorithmImplementation_setVerticesAndSimplices(self, vertices, simplices)

    def query(self, *args):
        r"""
        Get the index of the enclosing simplex of the given point.

        Available usages:
            query(*point*)

            query(*sample*)

        Parameters
        ----------
        point : sequence of float
            Given point.
        sample : 2-d sequence of float
            Given points.

        Returns
        -------
        index : int
            If point is enclosed in a simplex, return its index; otherwise return an
            int which is at least greater than the number of simplices.
        indices : :class:`openturns.Indices`
            Index of enclosing simplex of each point of the sample.  If there is no
            enclosing simplex, value is an int which is at least greater than the
            number of simplices.
        """
        return _geom.EnclosingSimplexAlgorithmImplementation_query(self, *args)

    def __repr__(self):
        return _geom.EnclosingSimplexAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _geom.EnclosingSimplexAlgorithmImplementation___str__(self, *args)

    def __init__(self, *args):
        _geom.EnclosingSimplexAlgorithmImplementation_swiginit(self, _geom.new_EnclosingSimplexAlgorithmImplementation(*args))
    __swig_destroy__ = _geom.delete_EnclosingSimplexAlgorithmImplementation

# Register EnclosingSimplexAlgorithmImplementation in _geom:
_geom.EnclosingSimplexAlgorithmImplementation_swigregister(EnclosingSimplexAlgorithmImplementation)

class EnclosingSimplexAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _geom.EnclosingSimplexAlgorithmImplementationTypedInterfaceObject_swiginit(self, _geom.new_EnclosingSimplexAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _geom.EnclosingSimplexAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _geom.EnclosingSimplexAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _geom.EnclosingSimplexAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _geom.EnclosingSimplexAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _geom.EnclosingSimplexAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _geom.delete_EnclosingSimplexAlgorithmImplementationTypedInterfaceObject

# Register EnclosingSimplexAlgorithmImplementationTypedInterfaceObject in _geom:
_geom.EnclosingSimplexAlgorithmImplementationTypedInterfaceObject_swigregister(EnclosingSimplexAlgorithmImplementationTypedInterfaceObject)

class EnclosingSimplexAlgorithm(EnclosingSimplexAlgorithmImplementationTypedInterfaceObject):
    r"""
    Point location algorithm.

    Base class to define an algorithm to find simplices containing
    a list of points.

    Available constructors:
        EnclosingSimplexAlgorithm(*vertices, simplices*)

    Parameters
    ----------
    vertices : :class:`~openturns.Sample`
        Vertices.

    simplices : :class:`~openturns.IndicesCollection`
        Simplices.

    Notes
    -----

    Two algorithms can be selected in any dimension:

    * :class:`~openturns.NaiveEnclosingSimplex` loops over all simplices
      and stops when the given point is inside.
    * :class:`~openturns.BoundingVolumeHierarchy` builds a binary tree based
      on bounding box of simplices.

    Two algorithms are specific to 1D meshes, and much more efficient:

    * :class:`~openturns.RegularGridEnclosingSimplex` is the most efficient
      algorithm when mesh corresponds to a :class:`~openturns.RegularGrid`,
      :meth:`query` works in constant time.
    * :class:`~openturns.EnclosingSimplexMonotonic1D` looks for enclosing
      simplex by dichotomy, it only works for sorted 1D meshes.

    It is recommended to use derived classes in order to select the best algorithm
    according to your data.  If you create a generic :class:`EnclosingSimplexAlgorithm`,
    here is how the derived class is selected:

    * If vertices and simplices correspond to a :class:`~openturns.RegularGrid`,
      :class:`~openturns.RegularGridEnclosingSimplex` algorithm is selected.
    * If vertices and simplices correspond to a simple 1D mesh with sorted vertices,
      :class:`~openturns.EnclosingSimplexMonotonic1D` algorithm is selected.
    * Otherwise, 'EnclosingSimplexAlgorithm-LargeDimension' :class:`~openturns.ResourceMap`
      entry is read.  If input dimension is lower than this value,
      :class:`~openturns.BoundingVolumeHierarchy` algorithm is chosen, otherwise
      it is :class:`~openturns.NaiveEnclosingSimplex`.

    See also
    --------
    NaiveEnclosingSimplex, BoundingVolumeHierarchy, RegularGridEnclosingSimplex,
    EnclosingSimplexMonotonic1D

    Examples
    --------
    >>> import openturns as ot
    >>> mesher = ot.IntervalMesher([5, 10])
    >>> lowerbound = [0.0, 0.0]
    >>> upperBound = [2.0, 4.0]
    >>> interval = ot.Interval(lowerbound, upperBound)
    >>> mesh = mesher.build(interval)
    >>> locator = ot.EnclosingSimplexAlgorithm(mesh.getVertices(), mesh.getSimplices())
    >>> simplex = locator.query([0.1, 0.2])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.EnclosingSimplexAlgorithm_getClassName(self)

    def getVertices(self):
        return _geom.EnclosingSimplexAlgorithm_getVertices(self)

    def getSimplices(self):
        return _geom.EnclosingSimplexAlgorithm_getSimplices(self)

    def setVerticesAndSimplices(self, vertices, simplices):
        r"""
        Rebuild a new data structure for these vertices and simplices.

        Parameters
        ----------
        vertices : :class:`~openturns.Sample`
            Vertices.

        simplices : :class:`~openturns.IndicesCollection`
            Simplices.
        """
        return _geom.EnclosingSimplexAlgorithm_setVerticesAndSimplices(self, vertices, simplices)

    def query(self, *args):
        r"""
        Get the index of the enclosing simplex of the given point.

        Available usages:
            query(*point*)

            query(*sample*)

        Parameters
        ----------
        point : sequence of float
            Given point.
        sample : 2-d sequence of float
            Given points.

        Returns
        -------
        index : int
            If point is enclosed in a simplex, return its index; otherwise return an
            int which is at least greater than the number of simplices.
        indices : :class:`openturns.Indices`
            Index of enclosing simplex of each point of the sample.  If there is no
            enclosing simplex, value is an int which is at least greater than the
            number of simplices.
        """
        return _geom.EnclosingSimplexAlgorithm_query(self, *args)

    def __repr__(self):
        return _geom.EnclosingSimplexAlgorithm___repr__(self)

    def __str__(self, *args):
        return _geom.EnclosingSimplexAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _geom.EnclosingSimplexAlgorithm_swiginit(self, _geom.new_EnclosingSimplexAlgorithm(*args))
    __swig_destroy__ = _geom.delete_EnclosingSimplexAlgorithm

# Register EnclosingSimplexAlgorithm in _geom:
_geom.EnclosingSimplexAlgorithm_swigregister(EnclosingSimplexAlgorithm)

import openturns.graph
class DomainImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _geom.DomainImplementationTypedInterfaceObject_swiginit(self, _geom.new_DomainImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _geom.DomainImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _geom.DomainImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _geom.DomainImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _geom.DomainImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _geom.DomainImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _geom.delete_DomainImplementationTypedInterfaceObject

# Register DomainImplementationTypedInterfaceObject in _geom:
_geom.DomainImplementationTypedInterfaceObject_swigregister(DomainImplementationTypedInterfaceObject)

class Domain(DomainImplementationTypedInterfaceObject):
    r"""
    Base class for domain objects.

    Notes
    -----
    A Domain object can be created through its derived classes:

    - :class:`~openturns.Interval`

    - :class:`~openturns.MeshDomain`

    - :class:`~openturns.LevelSet`

    - :class:`~openturns.DomainUnion`

    - :class:`~openturns.DomainDisjonctiveUnion`

    - :class:`~openturns.DomainIntersection`

    - :class:`~openturns.DomainComplement`

    - :class:`~openturns.DomainDifference`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.Domain_getClassName(self)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the given point is inside of the domain.
        """
        return _geom.Domain_contains(self, *args)

    def getDimension(self):
        r"""
        Get the dimension of the domain.

        Returns
        -------
        dim : int
            Dimension of the domain.
        """
        return _geom.Domain_getDimension(self)

    def __repr__(self):
        return _geom.Domain___repr__(self)

    def __init__(self, *args):
        _geom.Domain_swiginit(self, _geom.new_Domain(*args))
    __swig_destroy__ = _geom.delete_Domain

# Register Domain in _geom:
_geom.Domain_swigregister(Domain)


Domain.__contains__ = Domain.contains

class BipartiteGraph(openturns.typ.IndicesCollectionImplementation):
    r"""
    Bipartite red/black graph.

    Available constructors:
        BipartiteGraph(*sequence*)

    Parameters
    ----------
    sequence : sequence of :class:`~openturns.Indices`
        Cliques of the red nodes.

    Notes
    -----
    A bipartite graph is an undirected graph in which the nodes can be colored in two colors such that no edge has its two ends with the same colors. Here we force the :math:`n` red nodes to be numbered in consecutive order from 0 to :math:`n-1` and for each red node we give the list of black nodes that are the other end of the edges starting from this red node.

    Examples
    --------
    >>> import openturns as ot

    Create a bipartite graph:

    >>> graph = ot.BipartiteGraph([[1, 3], [2, 0], [5, 4]])
    >>> graph
    [[1,3],[2,0],[5,4]]

    Use some functionalities:

    >>> graph[1] = [3, 4]
    >>> graph
    [[1,3],[3,4],[5,4]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.BipartiteGraph_getClassName(self)

    def getRedNodes(self):
        r"""
        Accessor to the graph red nodes.

        Returns
        -------
        red : sequence of int, :class:`~openturns.Indices`
        """
        return _geom.BipartiteGraph_getRedNodes(self)

    def getBlackNodes(self):
        r"""
        Accessor to the graph black nodes.

        Returns
        -------
        black : sequence of int, :class:`~openturns.Indices`
        """
        return _geom.BipartiteGraph_getBlackNodes(self)

    def draw(self):
        r"""
        Draw the graph.

        Returns
        -------
        graph : a :class:`~openturns.Graph`
            View of the bipartite graph as a set of red nodes linked to black nodes.
        """
        return _geom.BipartiteGraph_draw(self)
    __swig_destroy__ = _geom.delete_BipartiteGraph

    def __repr__(self):
        return _geom.BipartiteGraph___repr__(self)

    def __str__(self, *args):
        return _geom.BipartiteGraph___str__(self, *args)

    def __getitem__(self, index):
        return _geom.BipartiteGraph___getitem__(self, index)

    def __setitem__(self, index, val):
        return _geom.BipartiteGraph___setitem__(self, index, val)

    def __len__(self):
        return _geom.BipartiteGraph___len__(self)

    def __init__(self, *args):
        _geom.BipartiteGraph_swiginit(self, _geom.new_BipartiteGraph(*args))

# Register BipartiteGraph in _geom:
_geom.BipartiteGraph_swigregister(BipartiteGraph)

class Mesh(openturns.common.PersistentObject):
    r"""
    Mesh.

    Available constructors:
        Mesh(*dim=1*)

        Mesh(*vertices*)

        Mesh(*vertices, simplices*)

    Parameters
    ----------
    dim : int, :math:`dim \geq 0`
        The dimension of the vertices. By default, it creates only one
        vertex of dimension :math:`dim` with components equal to 0.
    vertices : 2-d sequence of float
        Vertices' coordinates in :math:`\Rset^{dim}`.
    simplices : 2-d sequence of int
        List of simplices defining the topology of the mesh. The simplex
        :math:`[i_1, \dots, i_{dim+1}]` connects the vertices of indices
        :math:`(i_1, \dots, i_{dim+1})` in :math:`\Rset^{dim}`. In dimension 1, a
        simplex is an interval :math:`[i_1, i_2]`; in dimension 2, it is a
        triangle :math:`[i_1, i_2, i_3]`.

    See also
    --------
    RegularGrid

    Examples
    --------
    >>> import openturns as ot
    >>> # Define the vertices of the mesh
    >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
    >>> # Define the simplices of the mesh
    >>> simplices = [[0, 1, 2], [1, 2, 3]]
    >>> # Create the mesh of dimension 2
    >>> mesh2d = ot.Mesh(vertices, simplices)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.Mesh_getClassName(self)

    def getVolume(self):
        r"""
        Get the volume of the mesh.

        Returns
        -------
        volume : float
            Geometrical volume of the mesh which is the sum of its simplices' volumes.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> mesh2d.getVolume()
        0.75
        """
        return _geom.Mesh_getVolume(self)

    def isEmpty(self):
        r"""
        Check whether the mesh is empty.

        Returns
        -------
        empty : bool
            Tells if the mesh is empty, ie if its volume is null.
        """
        return _geom.Mesh_isEmpty(self)

    def isNumericallyEmpty(self):
        r"""
        Check if the mesh is numerically empty.

        Returns
        -------
        isEmpty : bool
            Flag telling whether the mesh is numerically empty, i.e. if its numerical
            volume is inferior or equal to :math:`\epsilon` (defined in the
            :class:`~openturns.ResourceMap`:
            :math:`\epsilon` = Domain-SmallVolume).

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplex = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplex)
        >>> print(mesh2d.isNumericallyEmpty())
        False
        """
        return _geom.Mesh_isNumericallyEmpty(self)

    def getDimension(self):
        r"""
        Dimension accessor.

        Returns
        -------
        dimension : int
            Dimension of the vertices.
        """
        return _geom.Mesh_getDimension(self)

    def getDescription(self):
        r"""
        Get the description of the vertices.

        Returns
        -------
        description : str
            Description of the vertices.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.Mesh()
        >>> vertices = ot.Sample([[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]])
        >>> vertices.setDescription(['X', 'Y'])
        >>> mesh.setVertices(vertices)
        >>> print(mesh.getDescription())
        [X,Y]
        """
        return _geom.Mesh_getDescription(self)

    def getVerticesNumber(self):
        r"""
        Get the number of vertices of the mesh.

        Returns
        -------
        number : int
            Number of vertices of the mesh.
        """
        return _geom.Mesh_getVerticesNumber(self)

    def getSimplicesNumber(self):
        r"""
        Get the number of simplices of the mesh.

        Returns
        -------
        number : int
            Number of simplices of the mesh.
        """
        return _geom.Mesh_getSimplicesNumber(self)

    def computeWeights(self):
        r"""
        Compute an approximation of an integral defined over the mesh.

        Returns
        -------
        weights : :class:`~openturns.Point`
            Weights such that an integral of a function over the mesh
            is a weighted sum of its values at the vertices.
        """
        return _geom.Mesh_computeWeights(self)

    def __eq__(self, rhs):
        return _geom.Mesh___eq__(self, rhs)

    def isValid(self):
        r"""
        Check the mesh validity.

        Returns
        -------
        validity : bool
            Tells if the mesh is valid i.e. if there is non-overlaping simplices,
            no unused vertex, no simplices with duplicate vertices and no coincident
            vertices.
        """
        return _geom.Mesh_isValid(self)

    def checkPointInSimplexWithCoordinates(self, point, index):
        r"""
        Check if a point is inside a simplex and returns its barycentric coordinates.

        Parameters
        ----------
        point : sequence of float
            Point of dimension :math:`dim`, the dimension of the vertices of the mesh.
        index : int
            Integer characterizes one simplex of the mesh.

        Returns
        -------
        isInside : bool
            Flag telling whether *point* is inside the simplex of index *index*.
        coordinates : :class:`~openturns.Point`
            The barycentric coordinates of the given point wrt the vertices of the simplex.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplex = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplex)
        >>> # Create a point A inside the simplex
        >>> pointA = [0.6, 0.3]
        >>> print(mesh2d.checkPointInSimplexWithCoordinates(pointA, 0))
        [True, class=Point name=Unnamed dimension=3 values=[0.4,0.3,0.3]]
        >>> # Create a point B outside the simplex
        >>> pointB = [1.1, 0.6]
        >>> print(mesh2d.checkPointInSimplexWithCoordinates(pointB, 0))
        [False, class=Point name=Unnamed dimension=3 values=[-0.1,0.5,0.6]]

        Notes
        -----
        The tolerance for the check on the barycentric coordinates can be tweaked
        using the key `Mesh-CoordinateEpsilon`.
        """
        return _geom.Mesh_checkPointInSimplexWithCoordinates(self, point, index)

    def getVertices(self):
        r"""
        Get the vertices of the mesh.

        Returns
        -------
        vertices : :class:`~openturns.Sample`
            Coordinates in :math:`\Rset^{dim}` of the vertices,
            where :math:`dim` is the dimension of the vertices of the mesh.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.getVertices())
        0 : [ 0 0 ]
        1 : [ 1 0 ]
        2 : [ 1 1 ]
        """
        return _geom.Mesh_getVertices(self)

    def setVertices(self, vertices):
        r"""
        Set the vertices of the mesh.

        Parameters
        ----------
        vertices : 2-d sequence of float
            Cordinates in :math:`\Rset^{dim}` of the vertices,
            where :math:`dim` is the dimension of the vertices of the mesh.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.Mesh()
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> mesh.setVertices(vertices)
        """
        return _geom.Mesh_setVertices(self, vertices)

    def getVertex(self, index):
        r"""
        Get the vertex of a given index.

        Parameters
        ----------
        index : int
            Index characterizing one vertex of the mesh.

        Returns
        -------
        vertex : :class:`~openturns.Point`
            Coordinates in :math:`\Rset^{dim}` of the vertex of index *index*,
            where :math:`dim` is the dimension of the vertices of the mesh.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.getVertex(1))
        [1,0]
        >>> print(mesh2d.getVertex(0))
        [0,0]
        """
        return _geom.Mesh_getVertex(self, index)

    def setVertex(self, index, vertex):
        r"""
        Set a vertex of a given index.

        Parameters
        ----------
        index : int
            Index of the vertex to set.
        vertex : sequence of float
            Cordinates in :math:`\Rset^{dim}` of the vertex of index *index*,
            where :math:`dim` is the dimension of the vertices of the mesh.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplices = [[0, 1, 2]]
        >>> mesh = ot.Mesh(vertices, simplices)
        >>> vertex = [0.0, 0.5]
        >>> mesh.setVertex(0, vertex)
        >>> print(mesh.getVertices())
        0 : [ 0   0.5 ]
        1 : [ 1   0   ]
        2 : [ 1   1   ]
        """
        return _geom.Mesh_setVertex(self, index, vertex)

    def getSimplices(self):
        r"""
        Get the simplices of the mesh.

        Returns
        -------
        indicesCollection : collection of :class:`~openturns.Indices`
            List of indices defining all the simplices. The simplex
            :math:`[i_1, \dots, i_{n+1}]` relies the vertices of index
            :math:`(i_1, \dots, i_{n+1})` in :math:`\Rset^{dim}`. In dimension 1, a
            simplex is an interval :math:`[i_1, i_2]`; in dimension 2, it is a
            triangle :math:`[i_1, i_2, i_3]`.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.getSimplices())
        [[0,1,2],[1,2,3]]
        """
        return _geom.Mesh_getSimplices(self)

    def setSimplices(self, simplices):
        r"""
        Set the simplices of the mesh.

        Parameters
        ----------
        indices : 2-d sequence of int
            List of indices defining all the simplices. The simplex
            :math:`[i_1, \dots, i_{n+1}]` relies the vertices of index
            :math:`(i_1, \dots, i_{n+1})` in :math:`\Rset^{dim}`. In dimension 1, a
            simplex is an interval :math:`[i_1, i_2]`; in dimension 2, it is a
            triangle :math:`[i_1, i_2, i_3]`.

        Examples
        --------
        >>> import openturns as ot
        >>> mesh = ot.Mesh()
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh.setSimplices(simplices)
        """
        return _geom.Mesh_setSimplices(self, simplices)

    def getSimplex(self, index):
        r"""
        Get the simplex of a given index.

        Parameters
        ----------
        index : int
            Index characterizing one simplex of the mesh.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices defining the simplex of index *index*. The simplex
            :math:`[i_1, \dots, i_{n+1}]` relies the vertices of index
            :math:`(i_1, \dots, i_{n+1})` in :math:`\Rset^{dim}`. In dimension 1, a
            simplex is an interval :math:`[i_1, i_2]`; in dimension 2, it is a
            triangle :math:`[i_1, i_2, i_3]`.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.getSimplex(0))
        [0,1,2]
        >>> print(mesh2d.getSimplex(1))
        [1,2,3]
        """
        return _geom.Mesh_getSimplex(self, index)

    def computeSimplicesVolume(self):
        r"""
        Compute the volume of all simplices.

        Returns
        -------
        volume : :class:`~openturns.Point`
            Volume of all simplices.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplex = [[0, 1, 2]]
        >>> mesh2d = ot.Mesh(vertices, simplex)
        >>> print(mesh2d.computeSimplicesVolume())
        [0.5]
        """
        return _geom.Mesh_computeSimplicesVolume(self)

    def computeP1Gram(self):
        r"""
        Compute the P1 Lagrange finite element gram matrix of the mesh.

        Returns
        -------
        gram : :class:`~openturns.CovarianceMatrix`
            P1 Lagrange finite element gram matrix of the mesh.

        Notes
        -----
        The P1 Lagrange finite element space associated to a mesh with vertices :math:`(\vect{x}_i)_{i=1,\hdots,n}` is the space of piecewise-linear functions generated by the functions :math:`(\phi_i)_{i=1,\hdots,n}`, where :math:`\phi_i(\vect{x_i})=1`, :math:`\phi_i(\vect{x_j})=0` for :math:`j\neq i` and the restriction of :math:`\phi_i` to any simplex is an affine function. The vertices that are not included into at least one simplex are not taken into account.

        The gram matrix of the mesh is defined as the symmetric positive definite matrix :math:`\mat{K}` whose generic element :math:`K_{i,j}` is given by:

        .. math::

            \forall i,j=1,\hdots,n,\quad K_{i,j}=\int_{\cD}\phi_i(\vect{x})\phi_j(\vect{x})\di{\vect{x}}

        This method is used in several algorithms related to stochastic process representation such as the Karhunen-Loeve decomposition.

        Examples
        --------
        >>> import openturns as ot
        >>> # Define the vertices of the mesh
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> # Define the simplices of the mesh
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> # Create the mesh of dimension 2
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> print(mesh2d.computeP1Gram())
        [[ 0.0416667 0.0208333 0.0208333 0         ]
         [ 0.0208333 0.0625    0.03125   0.0104167 ]
         [ 0.0208333 0.03125   0.0625    0.0104167 ]
         [ 0         0.0104167 0.0104167 0.0208333 ]]

        """
        return _geom.Mesh_computeP1Gram(self)

    def isRegular(self):
        r"""
        Check if the mesh is regular (only for 1-d meshes).

        Returns
        -------
        isRegular : bool
            Tells if the mesh is regular or not.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.5], [1.5], [2.4], [3.5]]
        >>> simplices = [[0, 1], [1, 2], [2, 3]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> print(mesh1d.isRegular())
        False
        >>> vertices = [[0.5], [1.5], [2.5], [3.5]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> print(mesh1d.isRegular())
        True
        """
        return _geom.Mesh_isRegular(self)

    def getLowerBound(self):
        return _geom.Mesh_getLowerBound(self)

    def getUpperBound(self):
        return _geom.Mesh_getUpperBound(self)

    def fixOrientation(self):
        r"""
        Make all the simplices positively oriented.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0]]
        >>> simplex = [[0, 2, 1]]
        >>> mesh2d = ot.Mesh(vertices, simplex)
        >>> print(mesh2d)
        class=Mesh name=Unnamed dimension=2 vertices=class=Sample name=Unnamed implementation=class=SampleImplementation name=Unnamed size=3 dimension=2 data=[[0,0],[1,0],[1,1]] simplices=[[0,2,1]]
        >>> mesh2d.fixOrientation()
        >>> print(mesh2d)
        class=Mesh name=Unnamed dimension=2 vertices=class=Sample name=Unnamed implementation=class=SampleImplementation name=Unnamed size=3 dimension=2 data=[[0,0],[1,0],[1,1]] simplices=[[2,0,1]]
        """
        return _geom.Mesh_fixOrientation(self)

    def draw(self):
        r"""
        Draw the mesh.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            If the dimension of the mesh is 1, it draws the corresponding interval,
            using the :meth:`draw1D` method; if the dimension is 2, it draws the
            triangular simplices, using the :meth:`draw2D` method; if the dimension is
            3, it projects the simplices on the plane of the two first components,
            using the :meth:`draw3D` method with its default parameters, superposing
            the simplices.
        """
        return _geom.Mesh_draw(self)

    def draw1D(self):
        r"""
        Draw the mesh of dimension 1.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Draws the line linking the vertices of the mesh when the mesh is of
            dimension 1.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> vertices = [[0.5], [1.5], [2.1], [2.7]]
        >>> simplices = [[0, 1], [1, 2], [2, 3]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> # Create a graph
        >>> aGraph = mesh1d.draw1D()
        >>> # Draw the mesh
        >>> View(aGraph).show()
        """
        return _geom.Mesh_draw1D(self)

    def draw2D(self):
        r"""
        Draw the mesh of dimension 2.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Draws the edges of each simplex, when the mesh is of dimension 2.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> # Create a graph
        >>> aGraph = mesh2d.draw2D()
        >>> # Draw the mesh
        >>> View(aGraph).show()
        """
        return _geom.Mesh_draw2D(self)

    def draw3D(self, *args):
        r"""
        Draw the bidimensional projection of the mesh.

        Available usages:
            draw3D(*drawEdge=True, thetaX=0.0, thetaY=0.0, thetaZ=0.0, shading=False, rho=1.0*)

            draw3D(*drawEdge, rotation, shading, rho*)

        Parameters
        ----------
        drawEdge : bool
            Tells if the edge of each simplex has to be drawn.
        thetaX : float
            Gives the value of the rotation along the X axis in radian.
        thetaY : float
            Gives the value of the rotation along the Y axis in radian.
        thetaZ : float
            Gives the value of the rotation along the Z axis in radian.
        rotation : :class:`~openturns.SquareMatrix`
            Operates a rotation on the mesh before its projection of the plane of the
            two first components.
        shading  : bool
            Enables to give a visual perception of depth and orientation.
        rho : float, :math:`0 \leq \rho \leq 1`
            Contraction factor of the simplices. If :math:`\rho < 1`, all the
            simplices are contracted and appear deconnected: some holes are created,
            which enables to see inside the mesh. If :math:`\rho = 1`, the simplices
            keep their initial size and appear connected. If :math:`\rho = 0`, each
            simplex is reduced to its gravity center.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Draws the bidimensional projection of the mesh on the :math:`(x,y)` plane.

        Examples
        --------
        >>> import openturns as ot
        >>> from openturns.viewer import View
        >>> from math import cos, sin, pi
        >>> vertices = [[0.0, 0.0, 0.0], [0.0, 0.0, 1.0], [0.0, 1.0, 0.0],
        ...             [0.0, 1.0, 1.0], [1.0, 0.0, 0.0], [1.0, 0.0, 1.0],
        ...             [1.0, 1.0, 0.0], [1.0, 1.0, 1.0]]
        >>> simplices = [[0, 1, 2, 4], [3, 5, 6, 7],[1, 2, 3, 6],
        ...              [1, 2, 4, 6], [1, 3, 5, 6], [1, 4, 5, 6]]
        >>> mesh3d = ot.Mesh(vertices, simplices)
        >>> # Create a graph
        >>> aGraph = mesh3d.draw3D()
        >>> # Draw the mesh
        >>> View(aGraph).show()
        >>> rotation = ot.SquareMatrix(3)
        >>> rotation[0, 0] = cos(pi / 3.0)
        >>> rotation[0, 1] = sin(pi / 3.0)
        >>> rotation[1, 0] = -sin(pi / 3.0)
        >>> rotation[1, 1] = cos(pi / 3.0)
        >>> rotation[2, 2] = 1.0
        >>> # Create a graph
        >>> aGraph = mesh3d.draw3D(True, rotation, True, 1.0)
        >>> # Draw the mesh
        >>> View(aGraph).show()
        """
        return _geom.Mesh_draw3D(self, *args)

    def __repr__(self):
        return _geom.Mesh___repr__(self)

    def __str__(self, *args):
        return _geom.Mesh___str__(self, *args)

    @staticmethod
    def ImportFromMSHFile(fileName):
        r"""
        Import mesh from FreeFem 2-d mesh files.

        Parameters
        ----------
        MSHFile : str
            A MSH ASCII file.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            Mesh defined in the file *MSHFile*.
        """
        return _geom.Mesh_ImportFromMSHFile(fileName)

    def streamToVTKFormat(self, *args):
        r"""
        Give a VTK representation of the mesh.

        Returns
        -------
        stream : str
            VTK representation of the mesh.
        """
        return _geom.Mesh_streamToVTKFormat(self, *args)

    def exportToVTKFile(self, *args):
        r"""
        Export the mesh to a VTK file.

        Parameters
        ----------
        myVTKFile.vtk : str
            Name of the created file which contains the mesh and the associated random
            values that can be visualized with the open source software
            `Paraview <http://www.paraview.org/>`_.
        """
        return _geom.Mesh_exportToVTKFile(self, *args)

    def __init__(self, *args):
        _geom.Mesh_swiginit(self, _geom.new_Mesh(*args))
    __swig_destroy__ = _geom.delete_Mesh

# Register Mesh in _geom:
_geom.Mesh_swigregister(Mesh)

def Mesh_ImportFromMSHFile(fileName):
    r"""
    Import mesh from FreeFem 2-d mesh files.

    Parameters
    ----------
    MSHFile : str
        A MSH ASCII file.

    Returns
    -------
    mesh : :class:`~openturns.Mesh`
        Mesh defined in the file *MSHFile*.
    """
    return _geom.Mesh_ImportFromMSHFile(fileName)

class RegularGrid(Mesh):
    r"""
    Regular Grid.

    Available constructors:
        RegularGrid(*start, step, n*)

        RegularGrid(*mesh*)

    Parameters
    ----------
    start : float
        The start time stamp of the grid.
    step : float, positive
        The step between to consecutive time stamps.
    n : int
        The number of time stamps in the grid, including the start and the end time stamps.
    mesh : :class:`~openturns.Mesh`
        The mesh must be in :math:`\Rset`, regular and sorted in the increasing order.

    Notes
    -----
    The time stamps of the regular grid are: :math:`(t_0, \dots, t_{n-1})` where :math:`t_{k} = t_0 + k \Delta` for :math:`0 \leq k \leq n-1` and :math:`\Delta >0` the step.

    See also
    --------
    Mesh

    Examples
    --------
    >>> import openturns as ot
    >>> myRegularGrid = ot.RegularGrid(0.0, 0.1, 100)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.RegularGrid_getClassName(self)

    def __eq__(self, rhs):
        return _geom.RegularGrid___eq__(self, rhs)

    def __ne__(self, rhs):
        return _geom.RegularGrid___ne__(self, rhs)

    def getStart(self):
        r"""
        Accessor to the start time stamp.

        Returns
        -------
        start : float
            The start point :math:`t_0` of the grid.
        """
        return _geom.RegularGrid_getStart(self)

    def getEnd(self):
        r"""
        Accessor to the first time stamp after the last time stamp of the grid.

        Returns
        -------
        endPoint : float
            The first point that follows the last point of the grid: :math:`t_{n-1} + \Delta`. The end point is not in the grid.
        """
        return _geom.RegularGrid_getEnd(self)

    def getStep(self):
        r"""
        Accessor to the step.

        Returns
        -------
        step : float
            The step :math:`\Delta` between two consecutive time stamps.
        """
        return _geom.RegularGrid_getStep(self)

    def getN(self):
        r"""
        Accessor to the number of time stamps in the grid.

        Returns
        -------
        n : int
            The number :math:`n` of time stamps in the grid.
        """
        return _geom.RegularGrid_getN(self)

    def getValue(self, i):
        r"""
        Accessor to the time stamps at a gien index.

        Parameters
        ----------
        k : int, :math:`0 \leq k \leq n-1`.
            Index of a time stamp. 

        Returns
        -------
        value : float
            The time stamp :math:`t_{k}`.
        """
        return _geom.RegularGrid_getValue(self, i)

    def getValues(self):
        r"""
        Accessor to all the time stamps.

        Returns
        -------
        values : :class:`~openturns.Point`
            The collection of the time stamps.
        """
        return _geom.RegularGrid_getValues(self)

    def follows(self, starter):
        r"""
        Check if the given grid follows the current one.

        Parameters
        ----------
        newGrid : :class:`~openturns.RegularGrid`
            A new regular grid.

        Returns
        -------
        answer : boolean
            The answer is *True* if the *newGrid* directly follows the current one.
        """
        return _geom.RegularGrid_follows(self, starter)

    def isRegular(self):
        r"""
        Check if the mesh is regular (only for 1-d meshes).

        Returns
        -------
        isRegular : bool
            Tells if the mesh is regular or not.

        Examples
        --------
        >>> import openturns as ot
        >>> vertices = [[0.5], [1.5], [2.4], [3.5]]
        >>> simplices = [[0, 1], [1, 2], [2, 3]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> print(mesh1d.isRegular())
        False
        >>> vertices = [[0.5], [1.5], [2.5], [3.5]]
        >>> mesh1d = ot.Mesh(vertices, simplices)
        >>> print(mesh1d.isRegular())
        True
        """
        return _geom.RegularGrid_isRegular(self)

    def __repr__(self):
        return _geom.RegularGrid___repr__(self)

    def __str__(self, *args):
        return _geom.RegularGrid___str__(self, *args)

    def __init__(self, *args):
        _geom.RegularGrid_swiginit(self, _geom.new_RegularGrid(*args))
    __swig_destroy__ = _geom.delete_RegularGrid

# Register RegularGrid in _geom:
_geom.RegularGrid_swigregister(RegularGrid)

class IntervalMesher(openturns.common.PersistentObject):
    r"""
    Creation of mesh of box type.

    Available constructor:
        IntervalMesher(*discretization*)

    Parameters
    ----------
    discretization : sequence of int, of dimension :math:`\leq 3`.
        Number of intervals in each direction of the box.

    Examples
    --------
    Create a mesh:

    >>> import openturns as ot
    >>> mesher = ot.IntervalMesher([5, 10])
    >>> lowerbound = [0.0, 0.0]
    >>> upperBound = [2.0, 4.0]
    >>> interval = ot.Interval(lowerbound, upperBound)
    >>> mesh = mesher.build(interval)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.IntervalMesher_getClassName(self)

    def setDiscretization(self, discretization):
        r"""
        Accessor to the discretization.

        Parameters
        ----------
        discretization : sequence of int
            Number of intervals in each direction of the box.
        """
        return _geom.IntervalMesher_setDiscretization(self, discretization)

    def getDiscretization(self):
        r"""
        Accessor to the discretization.

        Returns
        -------
        discretization : :class:`~openturns.Indices`
            Number of intervals in each direction of the box.
        """
        return _geom.IntervalMesher_getDiscretization(self)

    def __repr__(self):
        return _geom.IntervalMesher___repr__(self)

    def __str__(self, *args):
        return _geom.IntervalMesher___str__(self, *args)

    def build(self, *args):
        r"""
        Build the mesh of box type.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            The interval to mesh, of dimension equal to the dimension
            of `discretization`.
        diamond : bool
            A flag telling if one want the usual mesh (rectangular cells cut along a
            diagonal in dimension 2) or a diamond like mesh (rectangular cells cut
            into 4 triangles with the center of the cell as shared vertex).
            Default is *IntervalMesher-UseDiamond*, see :class:`~openturns.ResourceMap`.

        Returns
        -------
        mesh : :class:`~openturns.Mesh`
            The mesh built.
        """
        return _geom.IntervalMesher_build(self, *args)

    def __init__(self, *args):
        _geom.IntervalMesher_swiginit(self, _geom.new_IntervalMesher(*args))
    __swig_destroy__ = _geom.delete_IntervalMesher

# Register IntervalMesher in _geom:
_geom.IntervalMesher_swigregister(IntervalMesher)

class MeshDomain(openturns.typ.DomainImplementation):
    r"""
    Adaptor to convert a Mesh to a Domain.

    Available constructors:
        MeshDomain(*mesh*)

        MeshDomain(*mesh, enclosingSimplex*)

    Parameters
    ----------
    mesh : :class:`~openturns.Mesh`
        Underlying mesh.

    enclosingSimplex : :class:`~openturns.EnclosingSimplexAlgorithm`
        Algorithm to use for point location.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.MeshDomain_getClassName(self)

    def getMesh(self):
        return _geom.MeshDomain_getMesh(self)

    def getEnclosingSimplexAlgorithm(self):
        return _geom.MeshDomain_getEnclosingSimplexAlgorithm(self)

    def setEnclosingSimplexAlgorithm(self, enclosingSimplex):
        return _geom.MeshDomain_setEnclosingSimplexAlgorithm(self, enclosingSimplex)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the given point is inside of the domain.
        """
        return _geom.MeshDomain_contains(self, *args)

    def __repr__(self):
        return _geom.MeshDomain___repr__(self)

    def __str__(self, *args):
        return _geom.MeshDomain___str__(self, *args)

    def getLowerBound(self):
        r"""
        Get the lower bound.

        Returns
        -------
        lowerBound : :class:`~openturns.Point`
            Value of the lower bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getLowerBound())
        [2,3]
        """
        return _geom.MeshDomain_getLowerBound(self)

    def getUpperBound(self):
        r"""
        Get the upper bound.

        Returns
        -------
        upperBound : :class:`~openturns.Point`
            Value of the upper bound.

        Examples
        --------
        >>> import openturns as ot
        >>> interval = ot.Interval([2.0, 3.0], [4.0, 5.0], [True, False], [True, True])
        >>> print(interval.getUpperBound())
        [4,5]
        """
        return _geom.MeshDomain_getUpperBound(self)

    def __init__(self, *args):
        _geom.MeshDomain_swiginit(self, _geom.new_MeshDomain(*args))
    __swig_destroy__ = _geom.delete_MeshDomain

# Register MeshDomain in _geom:
_geom.MeshDomain_swigregister(MeshDomain)

class DomainComplement(openturns.typ.DomainImplementation):
    r"""
    Complement of a Domain.

    A point is inside this domain if it is not contained in domain
    passed as argument.

    Available constructors:
        DomainComplement(*domain*)

    Parameters
    ----------
    domain : :class:`~openturns.Domain`

    Examples
    --------
    >>> import openturns as ot
    >>> interval = (ot.Interval([1], [2], [False], [True]))
    >>> complement = ot.DomainComplement(interval)
    >>> [5] in complement
    True
    >>> [1.5] in complement
    False
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.DomainComplement_getClassName(self)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the complement of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside the complement of the
            domain.
        """
        return _geom.DomainComplement_contains(self, *args)

    def __eq__(self, *args):
        return _geom.DomainComplement___eq__(self, *args)

    def __ne__(self, *args):
        return _geom.DomainComplement___ne__(self, *args)

    def __repr__(self):
        return _geom.DomainComplement___repr__(self)

    def __str__(self, *args):
        return _geom.DomainComplement___str__(self, *args)

    def __init__(self, *args):
        _geom.DomainComplement_swiginit(self, _geom.new_DomainComplement(*args))
    __swig_destroy__ = _geom.delete_DomainComplement

# Register DomainComplement in _geom:
_geom.DomainComplement_swigregister(DomainComplement)

class DomainIntersection(openturns.typ.DomainImplementation):
    r"""
    A Domain representing the intersection of two Domain.

    A point is inside this domain if it is contained in both
    left and right domains.

    Available constructors:
        DomainIntersection(*left, right*)

    Parameters
    ----------
    left : :class:`~openturns.Domain`
        The first domain
    right : :class:`~openturns.Domain`
        The second domain
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.DomainIntersection_getClassName(self)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside this domain, which means
            that is is inside both left and right domains.

        Examples
        --------
        >>> import openturns as ot
        >>> # First domain
        >>> interval2d = ot.Interval([-1.0, -1.0], [0.5, 0.5])
        >>> # Second domain
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> intersection = ot.DomainIntersection(interval2d, mesh2d)
        >>> [0.2, 0.1] in intersection
        True
        >>> [0.1, 0.2] in intersection
        False
        """
        return _geom.DomainIntersection_contains(self, *args)

    def __eq__(self, *args):
        return _geom.DomainIntersection___eq__(self, *args)

    def __ne__(self, *args):
        return _geom.DomainIntersection___ne__(self, *args)

    def __repr__(self):
        return _geom.DomainIntersection___repr__(self)

    def __str__(self, *args):
        return _geom.DomainIntersection___str__(self, *args)

    def __init__(self, *args):
        _geom.DomainIntersection_swiginit(self, _geom.new_DomainIntersection(*args))
    __swig_destroy__ = _geom.delete_DomainIntersection

# Register DomainIntersection in _geom:
_geom.DomainIntersection_swigregister(DomainIntersection)

class DomainUnion(openturns.typ.DomainImplementation):
    r"""
    A Domain representing the union of two Domain.

    A point is inside this domain if it is contained in either
    left or right domains, or both.

    Available constructors:
        DomainUnion(*left, right*)

    Parameters
    ----------
    left : :class:`~openturns.Domain`
        The first domain
    right : :class:`~openturns.Domain`
        The second domain
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.DomainUnion_getClassName(self)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside this domain, which means
            that is is either inside left or right domains, or both.

        Examples
        --------
        >>> import openturns as ot
        >>> # First domain
        >>> interval2d = ot.Interval([-1.0, -1.0], [0.5, 0.5])
        >>> # Second domain
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> intersection = ot.DomainUnion(interval2d, mesh2d)
        >>> [0.2, 0.1] in intersection
        True
        >>> [0.1, 0.2] in intersection
        True
        """
        return _geom.DomainUnion_contains(self, *args)

    def __eq__(self, *args):
        return _geom.DomainUnion___eq__(self, *args)

    def __ne__(self, *args):
        return _geom.DomainUnion___ne__(self, *args)

    def __repr__(self):
        return _geom.DomainUnion___repr__(self)

    def __str__(self, *args):
        return _geom.DomainUnion___str__(self, *args)

    def __init__(self, *args):
        _geom.DomainUnion_swiginit(self, _geom.new_DomainUnion(*args))
    __swig_destroy__ = _geom.delete_DomainUnion

# Register DomainUnion in _geom:
_geom.DomainUnion_swigregister(DomainUnion)

class DomainDisjunctiveUnion(openturns.typ.DomainImplementation):
    r"""
    A Domain representing the disjunctive union of two Domain.

    A point is inside this domain if it is either in left or right
    domains, but not both.

    Available constructors:
        DomainDisjunctiveUnion(*left, right*)

    Parameters
    ----------
    left : :class:`~openturns.Domain`
        The first domain
    right : :class:`~openturns.Domain`
        The second domain
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.DomainDisjunctiveUnion_getClassName(self)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside this domain, which means
            that is is either inside left or right domains, but not both.

        Examples
        --------
        >>> import openturns as ot
        >>> # First domain
        >>> interval2d = ot.Interval([-1.0, -1.0], [0.5, 0.5])
        >>> # Second domain
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> disjunctive_union = ot.DomainDisjunctiveUnion(interval2d, mesh2d)
        >>> [0.2, 0.1] in disjunctive_union
        False
        >>> [0.1, 0.2] in disjunctive_union
        True
        """
        return _geom.DomainDisjunctiveUnion_contains(self, *args)

    def __eq__(self, *args):
        return _geom.DomainDisjunctiveUnion___eq__(self, *args)

    def __ne__(self, *args):
        return _geom.DomainDisjunctiveUnion___ne__(self, *args)

    def __repr__(self):
        return _geom.DomainDisjunctiveUnion___repr__(self)

    def __str__(self, *args):
        return _geom.DomainDisjunctiveUnion___str__(self, *args)

    def __init__(self, *args):
        _geom.DomainDisjunctiveUnion_swiginit(self, _geom.new_DomainDisjunctiveUnion(*args))
    __swig_destroy__ = _geom.delete_DomainDisjunctiveUnion

# Register DomainDisjunctiveUnion in _geom:
_geom.DomainDisjunctiveUnion_swigregister(DomainDisjunctiveUnion)

class DomainDifference(openturns.typ.DomainImplementation):
    r"""
    A Domain representing the difference of two Domain.

    A point is inside this domain if it is contained in
    left domain but not in right domain.

    Available constructors:
        DomainDifference(*left, right*)

    Parameters
    ----------
    left : :class:`~openturns.Domain`
        The first domain
    right : :class:`~openturns.Domain`
        The second domain
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _geom.DomainDifference_getClassName(self)

    def contains(self, *args):
        r"""
        Check if the given point is inside of the domain.

        Parameters
        ----------
        point : sequence of float
            Point with the same dimension as the current domain's dimension.

        Returns
        -------
        isInside : bool
            Flag telling whether the point is inside this domain, which means
            that is is inside left domain, but not inside right domain.

        Examples
        --------
        >>> import openturns as ot
        >>> # First domain
        >>> interval2d = ot.Interval([-1.0, -1.0], [0.5, 0.5])
        >>> # Second domain
        >>> vertices = [[0.0, 0.0], [1.0, 0.0], [1.0, 1.0], [1.5, 1.0]]
        >>> simplices = [[0, 1, 2], [1, 2, 3]]
        >>> mesh2d = ot.Mesh(vertices, simplices)
        >>> difference = ot.DomainDifference(interval2d, mesh2d)
        >>> [0.2, 0.1] in difference
        False
        >>> [0.1, 0.2] in difference
        True
        """
        return _geom.DomainDifference_contains(self, *args)

    def __eq__(self, *args):
        return _geom.DomainDifference___eq__(self, *args)

    def __ne__(self, *args):
        return _geom.DomainDifference___ne__(self, *args)

    def __repr__(self):
        return _geom.DomainDifference___repr__(self)

    def __str__(self, *args):
        return _geom.DomainDifference___str__(self, *args)

    def __init__(self, *args):
        _geom.DomainDifference_swiginit(self, _geom.new_DomainDifference(*args))
    __swig_destroy__ = _geom.delete_DomainDifference

# Register DomainDifference in _geom:
_geom.DomainDifference_swigregister(DomainDifference)



