# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Utility classes."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _common
else:
    import _common

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _common.delete_SwigPyIterator

    def value(self):
        return _common.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _common.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _common.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _common.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _common.SwigPyIterator_equal(self, x)

    def copy(self):
        return _common.SwigPyIterator_copy(self)

    def next(self):
        return _common.SwigPyIterator_next(self)

    def __next__(self):
        return _common.SwigPyIterator___next__(self)

    def previous(self):
        return _common.SwigPyIterator_previous(self)

    def advance(self, n):
        return _common.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _common.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _common.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _common.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _common.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _common.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _common.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _common:
_common.SwigPyIterator_swigregister(SwigPyIterator)


class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

class TBB(object):
    r"""
    Threading parameters.

    By default the number of threads is the value associated to the `parallel-threads` key
    in :class:`~openturns.ResourceMap`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def IsAvailable():
        r"""
        Ask whether threading support is available.

        Returns
        -------
        available : bool
            Whether threading support is available.
        """
        return _common.TBB_IsAvailable()

    @staticmethod
    def Enable():
        r"""Enable threading."""
        return _common.TBB_Enable()

    @staticmethod
    def Disable():
        r"""Disable threading."""
        return _common.TBB_Disable()

    @staticmethod
    def SetNumberOfThreads(numberOfThreads):
        r"""
        Accessor to the maximum number of TBB threads.

        Parameters
        ----------
        n_threads : int
            Maximum number of TBB threads.
        """
        return _common.TBB_SetNumberOfThreads(numberOfThreads)

    @staticmethod
    def GetNumberOfThreads():
        r"""
        Accessor to the maximum number of TBB threads.

        Returns
        -------
        n_threads : int
            Maximum number of TBB threads.
        """
        return _common.TBB_GetNumberOfThreads()
    __swig_destroy__ = _common.delete_TBB

# Register TBB in _common:
_common.TBB_swigregister(TBB)

def TBB_IsAvailable():
    r"""
    Ask whether threading support is available.

    Returns
    -------
    available : bool
        Whether threading support is available.
    """
    return _common.TBB_IsAvailable()

def TBB_Enable():
    r"""Enable threading."""
    return _common.TBB_Enable()

def TBB_Disable():
    r"""Disable threading."""
    return _common.TBB_Disable()

def TBB_SetNumberOfThreads(numberOfThreads):
    r"""
    Accessor to the maximum number of TBB threads.

    Parameters
    ----------
    n_threads : int
        Maximum number of TBB threads.
    """
    return _common.TBB_SetNumberOfThreads(numberOfThreads)

def TBB_GetNumberOfThreads():
    r"""
    Accessor to the maximum number of TBB threads.

    Returns
    -------
    n_threads : int
        Maximum number of TBB threads.
    """
    return _common.TBB_GetNumberOfThreads()

class Object(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Object_getClassName(self)
    __swig_destroy__ = _common.delete_Object

    def __repr__(self):
        return _common.Object___repr__(self)

    def __str__(self, *args):
        return _common.Object___str__(self, *args)

# Register Object in _common:
_common.Object_swigregister(Object)


import os

def Object___getstate__(self):

    state = dict()
    study = Study()
    filename = Path.BuildTemporaryFileName('xmlfileXXXXXX')

# assume xml support
# should use BinaryStorageManager
    with open(filename, 'rb+') as infile:
        study.setStorageManager(XMLStorageManager(filename)) 
        study.add('instance', self)
        study.save()
        infile.seek(0)
        state['xmldata'] = infile.read()

    os.remove(filename)
    return state

Object.__getstate__ = Object___getstate__

def Object___setstate__(self, state):

# call ctor to initialize underlying cxx obj
# as it is instanciated from object.__new__
    self.__init__()

    study = Study()
    filename = Path.BuildTemporaryFileName('xmlfileXXXXXX')
    with open(filename, 'rb+') as outfile:
        outfile.write(state['xmldata'])
        outfile.seek(0)
        study.setStorageManager(XMLStorageManager(filename)) 
        study.load()

    study.fillObject('instance', self)
    os.remove(filename)

Object.__setstate__ = Object___setstate__

def Object__repr_html_(self):
    lines = str(self).splitlines()
    return '<p>' + '<br>\n'.join(lines) + '</p>'
Object._repr_html_ = Object__repr_html_

class PersistentObject(Object):
    r"""PersistentObject saves and reloads the object's internal state."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.PersistentObject_getClassName(self)
    __swig_destroy__ = _common.delete_PersistentObject

    def __eq__(self, arg2):
        return _common.PersistentObject___eq__(self, arg2)

    def __ne__(self, other):
        return _common.PersistentObject___ne__(self, other)

    def __repr__(self):
        return _common.PersistentObject___repr__(self)

    def __str__(self, *args):
        return _common.PersistentObject___str__(self, *args)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.PersistentObject_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _common.PersistentObject_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _common.PersistentObject_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _common.PersistentObject_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _common.PersistentObject_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common.PersistentObject_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _common.PersistentObject_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.PersistentObject_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.PersistentObject_setName(self, name)

# Register PersistentObject in _common:
_common.PersistentObject_swigregister(PersistentObject)

class dynamic_cast_tag(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _common.dynamic_cast_tag_swiginit(self, _common.new_dynamic_cast_tag())
    __swig_destroy__ = _common.delete_dynamic_cast_tag

# Register dynamic_cast_tag in _common:
_common.dynamic_cast_tag_swigregister(dynamic_cast_tag)

class InterfaceObject(Object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.InterfaceObject_getClassName(self)

    def __repr__(self):
        return _common.InterfaceObject___repr__(self)

    def __str__(self, *args):
        return _common.InterfaceObject___str__(self, *args)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.InterfaceObject_getId(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.InterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.InterfaceObject_getName(self)
    __swig_destroy__ = _common.delete_InterfaceObject

# Register InterfaceObject in _common:
_common.InterfaceObject_swigregister(InterfaceObject)

class Study(Object):
    r"""
    Study.

    Available constructors:
        Study()

        Study(*fileName, compressionLevel*)

    Parameters
    ----------
    fileName : str
        Name of the file used by the underlying storage manager,
        a :class:`~openturns.XMLStorageManager` in this case.
    compressionLevel : int
        Compression level of the resulting XML file, in the range 0,...,9 (0=no compression, 9=best compression).
        The compression is done only if the XML lib has been compiled with zlib support.
        The default value is given by 'XMLStorageManager-DefaultCompressionLevel' in :class:`~openturns.ResourceMap`.

    Notes
    -----
    The study allows the user to save all its data to a structure looking like a
    map. The data are copied verbatim to the study. This is not a link, so future
    modification of the original won't affect the data saved in the study. To
    update the data saved in the study, the user has to explicitely save it again.
    Study allows the user to retrieve previously saved objects either by their name
    if a name was defined for the object or by their Id.

    Examples
    --------
    >>> import openturns as ot

    Create a Study object:

    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))
    >>> myStudy2 = ot.Study('myStudy2.xml')
    >>> myStudy3 = ot.Study('myStudy2.xml.gz', 5)

    Add PersistentObjects to the study:

    >>> # a Point:
    >>> point = ot.Point(3, 0.0)
    >>> point[0] = 10.0
    >>> point[1] = 11.0
    >>> point[2] = 12.0
    >>> myStudy.add('point', point)
    >>> # a simulation result:
    >>> simulationResult = ot.ProbabilitySimulationResult(ot.ThresholdEvent(), 0.5, 0.01, 150, 4)
    >>> myStudy.add('simulationResult', simulationResult)

    Get objects from the study:

    >>> print(myStudy.getObject('point'))
    [10,11,12]

    Save the Study:

    >>> myStudy.save()

    Create a new Study object:

    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))

    Load data from the study:

    >>> myStudy.load()

    Create data from the ones stored in the study:

    >>> # a Point:
    >>> otherPoint = ot.Point()
    >>> myStudy.fillObject('point', otherPoint)
    >>> # a simulation result:
    >>> otherSimulationResult = ot.ProbabilitySimulationResult()
    >>> myStudy.fillObject('simulationResult', otherSimulationResult)

    Get information from the study:

    >>> myStudy.printLabels()
    'point;simulationResult'

    Remove data:

    >>> myStudy.hasObject('simulationResult')
    True
    >>> myStudy.remove('simulationResult')
    >>> myStudy.hasObject('simulationResult')
    False
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Study_getClassName(self)

    def __repr__(self):
        return _common.Study___repr__(self)

    def __str__(self, *args):
        return _common.Study___str__(self, *args)

    def save(self):
        r"""Save the study through the storage manager."""
        return _common.Study_save(self)

    def load(self):
        r"""Reload the study from the storage manager."""
        return _common.Study_load(self)

    def setStorageManager(self, smgr):
        r"""
        Set the storage manager used by the study.

        Returns
        -------
        manager : :class:`~openturns.StorageManager`
            Storage manager used by the study to save and reload data.
        """
        return _common.Study_setStorageManager(self, smgr)

    def getStorageManager(self):
        r"""
        Get the storage manager used by the study.

        Parameters
        ----------
        manager : :class:`~openturns.StorageManager`
            Storage manager used by the study to save and reload data.
        """
        return _common.Study_getStorageManager(self)

    def add(self, *args):
        r"""
        Add an object to the study.

        :Available usages:
            add(*object*)

            add(*name, object, force=False*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            Object to add in the study.
        name : str
            Name to associate with the object.
        force : bool
            If *force=True* and *name* is already defined in the study, the previous
            object associated with this name is removed. A error message is emitted
            otherwise.
        """
        return _common.Study_add(self, *args)

    def remove(self, *args):
        r"""
        Remove an object from the study.

        :Available usages:
            remove(*object*)

            remove(*name*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`
            An object to be removed.
        name : str
            Name of the object to be removed.
        """
        return _common.Study_remove(self, *args)

    def hasObject(self, *args):
        r"""
        Query if object is stored in study.

        :Available usages:
            hasObject(*id*)

            hasObject(*name*)

        Parameters
        ----------
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.

        Returns
        -------
        hasObject : bool
            *True* if the object is stored in the study.
        """
        return _common.Study_hasObject(self, *args)

    def getObject(self, *args):
        r"""
        Get object from the study.

        :Available usages:
            getObject(*id*)

            getObject(*name*)

        Parameters
        ----------
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.

        Returns
        -------
        object : :class:`~openturns.PersistentObject`
            The object saved in the study.
        """
        return _common.Study_getObject(self, *args)

    def fillObjectByName(self, *args):
        r"""
        Fill an object with one got from study.

        :Available usages:
            fillObjectByName(*object, name*)

            fillObjectByName(*id, object*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            An object to be refilled (may be empty, i.e. default constructed).
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.
        """
        return _common.Study_fillObjectByName(self, *args)

    def fillObject(self, *args):
        r"""
        Fill an object with one got from study.

        :Available usages:
            fillObject(*name, object*)

            fillObject(*id, object*)

        Parameters
        ----------
        object : :class:`~openturns.InterfaceObject`, :class:`~openturns.PersistentObject`
            An object to be refilled (may be empty, i.e. default constructed).
        name : str
            Name of the object stored in the study.
        id : int
            Internal identifier of the object stored in the study.
        """
        return _common.Study_fillObject(self, *args)

    def printLabels(self):
        r"""
        Print all the names of the objects stored in the study.

        Returns
        -------
        names : str
            Names of the objects stored in the study.
        """
        return _common.Study_printLabels(self)

    def __init__(self, *args):
        _common.Study_swiginit(self, _common.new_Study(*args))
    __swig_destroy__ = _common.delete_Study

# Register Study in _common:
_common.Study_swigregister(Study)

class SaveAction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _common.SaveAction_swiginit(self, _common.new_SaveAction())
    __swig_destroy__ = _common.delete_SaveAction

# Register SaveAction in _common:
_common.SaveAction_swigregister(SaveAction)

class LoadAction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _common.LoadAction_swiginit(self, _common.new_LoadAction())
    __swig_destroy__ = _common.delete_LoadAction

# Register LoadAction in _common:
_common.LoadAction_swigregister(LoadAction)

class StorageManager(Object):
    r"""
    Define the way OpenTURNS' objects are saved and reloaded.

    Available constructors:
        StorageManager(*defaultVersion=1*)

    Parameters
    ----------
    defaultVersion : positive int
        Argument interpreted as the name of the object in a user point of view.
        This name is never used in another way than for user information. This name
        has no meaning to the platform.

    Notes
    -----
    A StorageManager object can be used only through its derived class
    :class:`~openturns.XMLStorageManager`.

    See also
    --------
    XMLStorageManager
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.StorageManager_getClassName(self)

    def __init__(self, defaultVersion=1):
        _common.StorageManager_swiginit(self, _common.new_StorageManager(defaultVersion))

    def __repr__(self):
        return _common.StorageManager___repr__(self)

    def save(self, obj, label, fromStudy=False):
        r"""
        Save the object onto the medium.

        Parameters
        ----------
        object : :class:`~openturns.PersistentObject`
            Object to be saved.
        label : str
            Name associate with the object to be saved.
        fromStudy : bool, optional
            Flag telling if the object was explicitely put in the study or not. By
            default, it is equal to *False*.
        """
        return _common.StorageManager_save(self, obj, label, fromStudy)

    def load(self, study):
        r"""
        Reload the whole study from the medium.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            The study to reload objects from.
        """
        return _common.StorageManager_load(self, study)

    def getStudy(self):
        r"""
        Get the study bound to the manager.

        Returns
        -------
        study : :class:`~openturns.Study`
            Study bound to the manager.
        """
        return _common.StorageManager_getStudy(self)

    def setStudy(self, p_study):
        r"""
        Set the study bound to the manager.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            Study bound to the manager.
        """
        return _common.StorageManager_setStudy(self, p_study)

    def getDefaultStudyVersion(self):
        r"""
        Return the version of the study that the manager can read/write.

        Returns
        -------
        version : positive int
            Version of the study that the manager can read/write.
        """
        return _common.StorageManager_getDefaultStudyVersion(self)

    def getStudyVersion(self):
        r"""
        Get the study version.

        Returns
        -------
        version : positive int
            Study version.
        """
        return _common.StorageManager_getStudyVersion(self)

    def setStudyVersion(self, version):
        r"""
        Set the study version.

        Parameters
        ----------
        version : positive int
            Study version.
        """
        return _common.StorageManager_setStudyVersion(self, version)

    def initialize(self, *args):
        r"""
        Do some administrative tasks before saving/reloading.

        :Available usages:
            initialize(*ot.SaveAction()*)

            initialize(*ot.LoadAction()*)
        """
        return _common.StorageManager_initialize(self, *args)

    def finalize(self, *args):
        r"""
        Do some administrative tasks after saving/reloading.

        :Available usages:
            finalize(*ot.SaveAction()*)

            finalize(*ot.LoadAction()*)
        """
        return _common.StorageManager_finalize(self, *args)

    def read(self):
        r"""Read and create the internal representation."""
        return _common.StorageManager_read(self)

    def write(self):
        r"""Write the internal representation."""
        return _common.StorageManager_write(self)

    def isSavedObject(self, id):
        r"""
        Tell if an object is already saved.

        Returns
        -------
        isSaved : bool
            *True* if an object is already saved.
        """
        return _common.StorageManager_isSavedObject(self, id)

    def markObjectAsSaved(self, id):
        r"""
        Tell that an object is saved.

        Parameters
        ----------
        Id : int
            Internal identifier of the object.
        """
        return _common.StorageManager_markObjectAsSaved(self, id)
    __swig_destroy__ = _common.delete_StorageManager

# Register StorageManager in _common:
_common.StorageManager_swigregister(StorageManager)

class VersionList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _common.VersionList_swiginit(self, _common.new_VersionList())

    def contains(self, v):
        return _common.VersionList_contains(self, v)
    __swig_destroy__ = _common.delete_VersionList

# Register VersionList in _common:
_common.VersionList_swigregister(VersionList)

class XMLStorageManager(StorageManager):
    r"""
    Storage manager that drives a XML file.

    Available constructors:
        XMLStorageManager(*filename*)

        XMLStorageManager(*filename, compressionLevel*)

    Parameters
    ----------
    fileName : str
        Name of the file containing the study.
    compressionLevel : int
        Compression level of the resulting XML file, in the range 0,...,9 (0=no compression, 9=best compression).
        The compression is done only if the XML lib has been compiled with zlib support.
        The default value is given by 'XMLStorageManager-DefaultCompressionLevel' in :class:`~openturns.ResourceMap`.

    Notes
    -----
    *XMLStorageManager* enables to read and write OPENTURNS' objects from a XML
    file.

    See also
    --------
    StorageManager

    Examples
    --------
    >>> import openturns as ot
    >>> # Create a study:
    >>> myStudy = ot.Study()
    >>> myStudy.setStorageManager(ot.XMLStorageManager('myStudy.xml'))  # doctest: +SKIP
    >>> myStudy2 = ot.Study()  # doctest: +SKIP
    >>> myStudy2.setStorageManager(ot.XMLStorageManager('myStudy2.xml.gz', 5))  # doctest: +SKIP
    >>> # Add an object in the study:
    >>> simulationResult = ot.ProbabilitySimulationResult(ot.ThresholdEvent(), 0.5, 0.01, 150, 4)  # doctest: +SKIP
    >>> myStudy.add('simulationResult', simulationResult)  # doctest: +SKIP
    >>> # Save the Study in the file myStudy.xml:
    >>> myStudy.save()  # doctest: +SKIP
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.XMLStorageManager_getClassName(self)

    def __init__(self, *args):
        _common.XMLStorageManager_swiginit(self, _common.new_XMLStorageManager(*args))

    def __repr__(self):
        return _common.XMLStorageManager___repr__(self)

    def getFileName(self):
        r"""
        Get the name of the file containing the study.

        Returns
        -------
        fileName : str
            Name of the file containing the study.
        """
        return _common.XMLStorageManager_getFileName(self)

    def setFileName(self, fileName):
        r"""
        Set the name of the file containing the study.

        Parameters
        ----------
        fileName : str
            Name of the file containing the study.
        """
        return _common.XMLStorageManager_setFileName(self, fileName)

    def save(self, obj, label, fromStudy=False):
        r"""
        Save the object onto the medium.

        Parameters
        ----------
        object : :class:`~openturns.PersistentObject`
            Object to be saved.
        label : str
            Name associate with the object to be saved.
        fromStudy : bool, optional
            Flag telling if the object was explicitely put in the study or not. By
            default, it is equal to *False*.
        """
        return _common.XMLStorageManager_save(self, obj, label, fromStudy)

    def load(self, study):
        r"""
        Reload the whole study from the medium.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            The study to reload objects from.
        """
        return _common.XMLStorageManager_load(self, study)

    def initialize(self, *args):
        r"""
        Do some administrative tasks before saving/reloading.

        :Available usages:
            initialize(*ot.SaveAction()*)

            initialize(*ot.LoadAction()*)
        """
        return _common.XMLStorageManager_initialize(self, *args)

    def finalize(self, *args):
        r"""
        Do some administrative tasks after saving/reloading.

        :Available usages:
            finalize(*ot.SaveAction()*)

            finalize(*ot.LoadAction()*)
        """
        return _common.XMLStorageManager_finalize(self, *args)

    def read(self):
        r"""Read and create the internal representation."""
        return _common.XMLStorageManager_read(self)

    def write(self):
        r"""Write the internal representation."""
        return _common.XMLStorageManager_write(self)
    __swig_destroy__ = _common.delete_XMLStorageManager

# Register XMLStorageManager in _common:
_common.XMLStorageManager_swigregister(XMLStorageManager)
cvar = _common.cvar
XMLStorageManager.SupportedVersions = _common.cvar.XMLStorageManager_SupportedVersions
XMLStorageManager.Precision_ = _common.cvar.XMLStorageManager_Precision_

class TTY(object):
    r"""
    Console utilities.

    No constructor, only static methods are available.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    DEFAULT = _common.TTY_DEFAULT
    BOLD = _common.TTY_BOLD
    UNDERLINE = _common.TTY_UNDERLINE
    BLINK = _common.TTY_BLINK
    BLACKFG = _common.TTY_BLACKFG
    REDFG = _common.TTY_REDFG
    GREENFG = _common.TTY_GREENFG
    YELLOWFG = _common.TTY_YELLOWFG
    BLUEFG = _common.TTY_BLUEFG
    PURPLEFG = _common.TTY_PURPLEFG
    CYANFG = _common.TTY_CYANFG
    WHITEFG = _common.TTY_WHITEFG
    BLACKBG = _common.TTY_BLACKBG
    REDBG = _common.TTY_REDBG
    GREENBG = _common.TTY_GREENBG
    YELLOWBG = _common.TTY_YELLOWBG
    BLUEBG = _common.TTY_BLUEBG
    PURPLEBG = _common.TTY_PURPLEBG
    CYANBG = _common.TTY_CYANBG
    WHITEBG = _common.TTY_WHITEBG
    LASTCOLOR = _common.TTY_LASTCOLOR

    @staticmethod
    def GetColor(c):
        return _common.TTY_GetColor(c)

    @staticmethod
    def ShowColors(flag):
        r"""
        Accessor to the color flag.

        Parameters
        ----------
        flag : bool
            Enable or disable colored output.
        """
        return _common.TTY_ShowColors(flag)

    @staticmethod
    def ColoredOutput():
        r"""
        Accessor to the color flag.

        Returns
        -------
        flag : bool
            Whether colored output is enabled or disabled.
        """
        return _common.TTY_ColoredOutput()

    def __init__(self):
        _common.TTY_swiginit(self, _common.new_TTY())
    __swig_destroy__ = _common.delete_TTY

# Register TTY in _common:
_common.TTY_swigregister(TTY)

def TTY_GetColor(c):
    return _common.TTY_GetColor(c)

def TTY_ShowColors(flag):
    r"""
    Accessor to the color flag.

    Parameters
    ----------
    flag : bool
        Enable or disable colored output.
    """
    return _common.TTY_ShowColors(flag)

def TTY_ColoredOutput():
    r"""
    Accessor to the color flag.

    Returns
    -------
    flag : bool
        Whether colored output is enabled or disabled.
    """
    return _common.TTY_ColoredOutput()

class Log(object):
    r"""
    Logging utilities.

    No constructor, only static methods are available.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def Debug(msg):
        r"""
        Log debug message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_Debug(msg)

    @staticmethod
    def HasDebug():
        r"""
        Test whether debug level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasDebug()

    @staticmethod
    def Info(msg):
        r"""
        Log information message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_Info(msg)

    @staticmethod
    def HasInfo():
        r"""
        Test whether information level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasInfo()

    @staticmethod
    def User(msg):
        r"""
        Log user message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_User(msg)

    @staticmethod
    def HasUser():
        r"""
        Test whether user level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasUser()

    @staticmethod
    def Warn(msg):
        r"""
        Log warning message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_Warn(msg)

    @staticmethod
    def HasWarn():
        r"""
        Test whether warning level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasWarn()

    @staticmethod
    def Error(msg):
        r"""
        Log error message.

        Parameters
        ----------
        message : str
            The message to log
        """
        return _common.Log_Error(msg)

    @staticmethod
    def HasError():
        r"""
        Test whether error level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasError()

    @staticmethod
    def Trace(msg):
        r"""
        Log execution trace message.

        Parameters
        ----------
        message : str
            The message to log.
        """
        return _common.Log_Trace(msg)

    @staticmethod
    def HasTrace():
        r"""
        Test whether execution trace level is enabled.

        Returns
        -------
        has_log : bool
            Whether the level is enabled
        """
        return _common.Log_HasTrace()

    @staticmethod
    def SetFile(file):
        r"""
        Redirect logs to a file.

        Parameters
        ----------
        file_name : str
            Log file name
        """
        return _common.Log_SetFile(file)

    @staticmethod
    def Show(flags):
        r"""
        Accessor to the log flags.

        Parameters
        ----------
        flags : int
            Log flags to enable.

            Available values to be ORed:

            - DBG
            - INFO
            - USER
            - WARN
            - ERROR
            - TRACE
            - DEFAULT
            - NONE
            - ALL

        Examples
        --------
        >>> import openturns as ot
        >>> ot.Log.Show(ot.Log.DEFAULT)
        """
        return _common.Log_Show(flags)

    @staticmethod
    def Flags():
        r"""
        Accessor to the log flags.

        Returns
        -------
        flags : int
            The enabled log flags.
        """
        return _common.Log_Flags()

    @staticmethod
    def Flush():
        r"""Flush pending messages."""
        return _common.Log_Flush()

    @staticmethod
    def Repeat(repeat):
        r"""
        Whether to report repeated messages.

        Parameters
        ----------
        repeat : bool
            Whether to report repeated messages
        """
        return _common.Log_Repeat(repeat)

    @staticmethod
    def SetColor(*args):
        r"""
        Color accessor.

        Parameters
        ----------
        severity : int
            Log level
        color : str or int
            Log color
        """
        return _common.Log_SetColor(*args)

    @staticmethod
    def GetColor(severity):
        r"""
        Color accessor.

        Parameters
        ----------
        severity : int
            Log level

        Returns
        -------
        color : str
            Log color
        """
        return _common.Log_GetColor(severity)
    __swig_destroy__ = _common.delete_Log

# Register Log in _common:
_common.Log_swigregister(Log)
Log.DBG = _common.cvar.Log_DBG
Log.INFO = _common.cvar.Log_INFO
Log.USER = _common.cvar.Log_USER
Log.WARN = _common.cvar.Log_WARN
Log.ERROR = _common.cvar.Log_ERROR
Log.TRACE = _common.cvar.Log_TRACE
Log.DEFAULT = _common.cvar.Log_DEFAULT
Log.NONE = _common.cvar.Log_NONE
Log.ALL = _common.cvar.Log_ALL

def Log_Debug(msg):
    r"""
    Log debug message.

    Parameters
    ----------
    message : str
        The message to log
    """
    return _common.Log_Debug(msg)

def Log_HasDebug():
    r"""
    Test whether debug level is enabled.

    Returns
    -------
    has_log : bool
        Whether the level is enabled
    """
    return _common.Log_HasDebug()

def Log_Info(msg):
    r"""
    Log information message.

    Parameters
    ----------
    message : str
        The message to log
    """
    return _common.Log_Info(msg)

def Log_HasInfo():
    r"""
    Test whether information level is enabled.

    Returns
    -------
    has_log : bool
        Whether the level is enabled
    """
    return _common.Log_HasInfo()

def Log_User(msg):
    r"""
    Log user message.

    Parameters
    ----------
    message : str
        The message to log
    """
    return _common.Log_User(msg)

def Log_HasUser():
    r"""
    Test whether user level is enabled.

    Returns
    -------
    has_log : bool
        Whether the level is enabled
    """
    return _common.Log_HasUser()

def Log_Warn(msg):
    r"""
    Log warning message.

    Parameters
    ----------
    message : str
        The message to log
    """
    return _common.Log_Warn(msg)

def Log_HasWarn():
    r"""
    Test whether warning level is enabled.

    Returns
    -------
    has_log : bool
        Whether the level is enabled
    """
    return _common.Log_HasWarn()

def Log_Error(msg):
    r"""
    Log error message.

    Parameters
    ----------
    message : str
        The message to log
    """
    return _common.Log_Error(msg)

def Log_HasError():
    r"""
    Test whether error level is enabled.

    Returns
    -------
    has_log : bool
        Whether the level is enabled
    """
    return _common.Log_HasError()

def Log_Trace(msg):
    r"""
    Log execution trace message.

    Parameters
    ----------
    message : str
        The message to log.
    """
    return _common.Log_Trace(msg)

def Log_HasTrace():
    r"""
    Test whether execution trace level is enabled.

    Returns
    -------
    has_log : bool
        Whether the level is enabled
    """
    return _common.Log_HasTrace()

def Log_SetFile(file):
    r"""
    Redirect logs to a file.

    Parameters
    ----------
    file_name : str
        Log file name
    """
    return _common.Log_SetFile(file)

def Log_Show(flags):
    r"""
    Accessor to the log flags.

    Parameters
    ----------
    flags : int
        Log flags to enable.

        Available values to be ORed:

        - DBG
        - INFO
        - USER
        - WARN
        - ERROR
        - TRACE
        - DEFAULT
        - NONE
        - ALL

    Examples
    --------
    >>> import openturns as ot
    >>> ot.Log.Show(ot.Log.DEFAULT)
    """
    return _common.Log_Show(flags)

def Log_Flags():
    r"""
    Accessor to the log flags.

    Returns
    -------
    flags : int
        The enabled log flags.
    """
    return _common.Log_Flags()

def Log_Flush():
    r"""Flush pending messages."""
    return _common.Log_Flush()

def Log_Repeat(repeat):
    r"""
    Whether to report repeated messages.

    Parameters
    ----------
    repeat : bool
        Whether to report repeated messages
    """
    return _common.Log_Repeat(repeat)

def Log_SetColor(*args):
    r"""
    Color accessor.

    Parameters
    ----------
    severity : int
        Log level
    color : str or int
        Log color
    """
    return _common.Log_SetColor(*args)

def Log_GetColor(severity):
    r"""
    Color accessor.

    Parameters
    ----------
    severity : int
        Log level

    Returns
    -------
    color : str
        Log color
    """
    return _common.Log_GetColor(severity)

class Log_init(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _common.Log_init_swiginit(self, _common.new_Log_init())
    __swig_destroy__ = _common.delete_Log_init

# Register Log_init in _common:
_common.Log_init_swigregister(Log_init)

class DirectoryList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _common.DirectoryList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _common.DirectoryList___nonzero__(self)

    def __bool__(self):
        return _common.DirectoryList___bool__(self)

    def __len__(self):
        return _common.DirectoryList___len__(self)

    def __getslice__(self, i, j):
        return _common.DirectoryList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _common.DirectoryList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _common.DirectoryList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _common.DirectoryList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _common.DirectoryList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _common.DirectoryList___setitem__(self, *args)

    def pop(self):
        return _common.DirectoryList_pop(self)

    def append(self, x):
        return _common.DirectoryList_append(self, x)

    def empty(self):
        return _common.DirectoryList_empty(self)

    def size(self):
        return _common.DirectoryList_size(self)

    def swap(self, v):
        return _common.DirectoryList_swap(self, v)

    def begin(self):
        return _common.DirectoryList_begin(self)

    def end(self):
        return _common.DirectoryList_end(self)

    def rbegin(self):
        return _common.DirectoryList_rbegin(self)

    def rend(self):
        return _common.DirectoryList_rend(self)

    def clear(self):
        return _common.DirectoryList_clear(self)

    def get_allocator(self):
        return _common.DirectoryList_get_allocator(self)

    def pop_back(self):
        return _common.DirectoryList_pop_back(self)

    def erase(self, *args):
        return _common.DirectoryList_erase(self, *args)

    def __init__(self, *args):
        _common.DirectoryList_swiginit(self, _common.new_DirectoryList(*args))

    def push_back(self, x):
        return _common.DirectoryList_push_back(self, x)

    def front(self):
        return _common.DirectoryList_front(self)

    def back(self):
        return _common.DirectoryList_back(self)

    def assign(self, n, x):
        return _common.DirectoryList_assign(self, n, x)

    def resize(self, *args):
        return _common.DirectoryList_resize(self, *args)

    def insert(self, *args):
        return _common.DirectoryList_insert(self, *args)

    def reserve(self, n):
        return _common.DirectoryList_reserve(self, n)

    def capacity(self):
        return _common.DirectoryList_capacity(self)
    __swig_destroy__ = _common.delete_DirectoryList

# Register DirectoryList in _common:
_common.DirectoryList_swigregister(DirectoryList)

class Path(object):
    r"""
    Path utilities.

    No constructor, only static methods are available.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def GetInstallationDirectory():
        r"""
        Accessor to the installation directory.

        Returns
        -------
        installDir : str
            The installation prefix.
        """
        return _common.Path_GetInstallationDirectory()

    @staticmethod
    def GetConfigDirectoryList():
        r"""
        Accessor to config directories.

        Returns
        -------
        dirList : list of str
            The list of directories searched for config files.
        """
        return _common.Path_GetConfigDirectoryList()

    @staticmethod
    def FindFileByNameInDirectoryList(name, dirList):
        r"""
        Find a file.

        Parameters
        ----------
        name : str
            Filename to be found.
        dirList : sequence of str
            The list of directories to search in.


        Returns
        -------
        dirList : list of str
            The list of directories searched for config files.
        """
        return _common.Path_FindFileByNameInDirectoryList(name, dirList)

    @staticmethod
    def GetTemporaryDirectory():
        r"""
        Accessor to the temporary directory.

        Returns
        -------
        tempDir : str
            The absolute temporary directory.
        """
        return _common.Path_GetTemporaryDirectory()

    @staticmethod
    def BuildTemporaryFileName(pattern):
        r"""
        Create a new temporary file.

        Parameters
        ----------
        pattern : str
            Filename pattern, eg 'tmpXXXXXX'.
            The 'XXXXXXX' part will be replaced by random chars.

        Returns
        -------
        fileName : str
            The unique newly created file.
        """
        return _common.Path_BuildTemporaryFileName(pattern)

    @staticmethod
    def CreateTemporaryDirectory(directoryPrefix):
        r"""
        Create a new temporary directory.

        Parameters
        ----------
        directoryPrefix : str
            A subdirectory name.

        Returns
        -------
        tempDir : str
            The newly created directory.
        """
        return _common.Path_CreateTemporaryDirectory(directoryPrefix)

    @staticmethod
    def DeleteTemporaryDirectory(directoryName):
        r"""
        Remove a temporary directory.

        Parameters
        ----------
        directoryName : str
            The directory to remove.
        """
        return _common.Path_DeleteTemporaryDirectory(directoryName)

    @staticmethod
    def GetLibraryDirectory():
        r"""
        Accessor to the library directory.

        Returns
        -------
        dir : str
            The directory containing the shared library.
        """
        return _common.Path_GetLibraryDirectory()
    __swig_destroy__ = _common.delete_Path

# Register Path in _common:
_common.Path_swigregister(Path)

def Path_GetInstallationDirectory():
    r"""
    Accessor to the installation directory.

    Returns
    -------
    installDir : str
        The installation prefix.
    """
    return _common.Path_GetInstallationDirectory()

def Path_GetConfigDirectoryList():
    r"""
    Accessor to config directories.

    Returns
    -------
    dirList : list of str
        The list of directories searched for config files.
    """
    return _common.Path_GetConfigDirectoryList()

def Path_FindFileByNameInDirectoryList(name, dirList):
    r"""
    Find a file.

    Parameters
    ----------
    name : str
        Filename to be found.
    dirList : sequence of str
        The list of directories to search in.


    Returns
    -------
    dirList : list of str
        The list of directories searched for config files.
    """
    return _common.Path_FindFileByNameInDirectoryList(name, dirList)

def Path_GetTemporaryDirectory():
    r"""
    Accessor to the temporary directory.

    Returns
    -------
    tempDir : str
        The absolute temporary directory.
    """
    return _common.Path_GetTemporaryDirectory()

def Path_BuildTemporaryFileName(pattern):
    r"""
    Create a new temporary file.

    Parameters
    ----------
    pattern : str
        Filename pattern, eg 'tmpXXXXXX'.
        The 'XXXXXXX' part will be replaced by random chars.

    Returns
    -------
    fileName : str
        The unique newly created file.
    """
    return _common.Path_BuildTemporaryFileName(pattern)

def Path_CreateTemporaryDirectory(directoryPrefix):
    r"""
    Create a new temporary directory.

    Parameters
    ----------
    directoryPrefix : str
        A subdirectory name.

    Returns
    -------
    tempDir : str
        The newly created directory.
    """
    return _common.Path_CreateTemporaryDirectory(directoryPrefix)

def Path_DeleteTemporaryDirectory(directoryName):
    r"""
    Remove a temporary directory.

    Parameters
    ----------
    directoryName : str
        The directory to remove.
    """
    return _common.Path_DeleteTemporaryDirectory(directoryName)

def Path_GetLibraryDirectory():
    r"""
    Accessor to the library directory.

    Returns
    -------
    dir : str
        The directory containing the shared library.
    """
    return _common.Path_GetLibraryDirectory()

class Catalog(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    @staticmethod
    def Add(factoryName, p_factory):
        return _common.Catalog_Add(factoryName, p_factory)

    @staticmethod
    def Get(factoryName):
        return _common.Catalog_Get(factoryName)

    @staticmethod
    def GetKeys():
        return _common.Catalog_GetKeys()
    __swig_destroy__ = _common.delete_Catalog

    def __repr__(self):
        return _common.Catalog___repr__(self)

    def __str__(self):
        return _common.Catalog___str__(self)

# Register Catalog in _common:
_common.Catalog_swigregister(Catalog)

def Catalog_Add(factoryName, p_factory):
    return _common.Catalog_Add(factoryName, p_factory)

def Catalog_Get(factoryName):
    return _common.Catalog_Get(factoryName)

def Catalog_GetKeys():
    return _common.Catalog_GetKeys()

class Catalog_init(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _common.Catalog_init_swiginit(self, _common.new_Catalog_init())
    __swig_destroy__ = _common.delete_Catalog_init

# Register Catalog_init in _common:
_common.Catalog_init_swigregister(Catalog_init)

class StringStringMap(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _common.StringStringMap_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _common.StringStringMap___nonzero__(self)

    def __bool__(self):
        return _common.StringStringMap___bool__(self)

    def __len__(self):
        return _common.StringStringMap___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _common.StringStringMap___getitem__(self, key)

    def __delitem__(self, key):
        return _common.StringStringMap___delitem__(self, key)

    def has_key(self, key):
        return _common.StringStringMap_has_key(self, key)

    def keys(self):
        return _common.StringStringMap_keys(self)

    def values(self):
        return _common.StringStringMap_values(self)

    def items(self):
        return _common.StringStringMap_items(self)

    def __contains__(self, key):
        return _common.StringStringMap___contains__(self, key)

    def key_iterator(self):
        return _common.StringStringMap_key_iterator(self)

    def value_iterator(self):
        return _common.StringStringMap_value_iterator(self)

    def __setitem__(self, *args):
        return _common.StringStringMap___setitem__(self, *args)

    def asdict(self):
        return _common.StringStringMap_asdict(self)

    def __init__(self, *args):
        _common.StringStringMap_swiginit(self, _common.new_StringStringMap(*args))

    def empty(self):
        return _common.StringStringMap_empty(self)

    def size(self):
        return _common.StringStringMap_size(self)

    def swap(self, v):
        return _common.StringStringMap_swap(self, v)

    def begin(self):
        return _common.StringStringMap_begin(self)

    def end(self):
        return _common.StringStringMap_end(self)

    def rbegin(self):
        return _common.StringStringMap_rbegin(self)

    def rend(self):
        return _common.StringStringMap_rend(self)

    def clear(self):
        return _common.StringStringMap_clear(self)

    def get_allocator(self):
        return _common.StringStringMap_get_allocator(self)

    def count(self, x):
        return _common.StringStringMap_count(self, x)

    def erase(self, *args):
        return _common.StringStringMap_erase(self, *args)

    def find(self, x):
        return _common.StringStringMap_find(self, x)

    def lower_bound(self, x):
        return _common.StringStringMap_lower_bound(self, x)

    def upper_bound(self, x):
        return _common.StringStringMap_upper_bound(self, x)
    __swig_destroy__ = _common.delete_StringStringMap

# Register StringStringMap in _common:
_common.StringStringMap_swigregister(StringStringMap)

class ResourceMap(object):
    r"""
    The ResourceMap allows to manage constants that are associated to key strings.

    Find below the ResourceMap's content:

    .. execforresourcemap::

    Examples
    --------
    Get some keys:

    >>> import openturns as ot
    >>> for key in ot.ResourceMap.GetKeys()[:4]:
    ...     print(key)
    ARMA-MeanEpsilon
    ARMALikelihoodFactory-DefaultMaxFun
    ARMALikelihoodFactory-DefaultRhoBeg
    ARMALikelihoodFactory-DefaultRhoEnd
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    @staticmethod
    def GetType(key):
        r"""
        Access the type of a parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        type : str
            The type associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetType('DiscreteDistribution-SupportEpsilon')
        'float'
        """
        return _common.ResourceMap_GetType(key)

    @staticmethod
    def Get(key):
        r"""
        Access a parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : str
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.Get('WeightedExperiment-DefaultSize')
        '100'
        """
        return _common.ResourceMap_Get(key)

    @staticmethod
    def GetAsString(key):
        r"""
        Access a string parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : str
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.Get('WeightedExperiment-DefaultSize')
        '100'
        """
        return _common.ResourceMap_GetAsString(key)

    @staticmethod
    def GetAsBool(key):
        r"""
        Access a boolean parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : bool
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals')
        True
        """
        return _common.ResourceMap_GetAsBool(key)

    @staticmethod
    def GetAsUnsignedInteger(key):
        r"""
        Access an integer parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : int
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsUnsignedInteger('MCMC-DefaultBurnIn')
        0...
        """
        return _common.ResourceMap_GetAsUnsignedInteger(key)

    @staticmethod
    def GetAsScalar(key):
        r"""
        Access a floating-point parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        value : float
            The value associated to that key.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.GetAsScalar('SQP-DefaultTau')
        0.5
        """
        return _common.ResourceMap_GetAsScalar(key)

    @staticmethod
    def Set(key, value):
        r"""
        Access an existing parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : str
            The value associated to that key. If the key already exists as a *float*,
            an *unsigned int* or a *bool*, the given string is converted into the
            corresponding type.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.Set('DiscreteDistribution-SupportEpsilon', '1.0e-14')
        """
        return _common.ResourceMap_Set(key, value)

    @staticmethod
    def SetAsString(key, value):
        r"""
        Set an existing string parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : str
            The value associated to that key. The key is added to the string map even if
            it already exists in another map (float, unsigned int or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsString('View-ImageFormat', 'png')
        """
        return _common.ResourceMap_SetAsString(key, value)

    @staticmethod
    def SetAsBool(key, value):
        r"""
        Set an existing boolean parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : bool
            The value associated to that key. The key is added to the bool map even if
            it already exists in another map (float, unsigned int or string).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals', True)
        """
        return _common.ResourceMap_SetAsBool(key, value)

    @staticmethod
    def SetAsUnsignedInteger(key, value):
        r"""
        Set an existing integer parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : int
            The value associated to that key. The key is added to the unsigned integer
            map even if it already exists in another map (float, string or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsUnsignedInteger('MCMC-DefaultBurnIn', 0)
        """
        return _common.ResourceMap_SetAsUnsignedInteger(key, value)

    @staticmethod
    def SetAsScalar(key, value):
        r"""
        Set an existing floating-point parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : float
            The value associated to that key. The key is added to the float map even if
            it already exists in another map (string, unsigned int or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.SetAsScalar('SQP-DefaultTau', 0.5)
        """
        return _common.ResourceMap_SetAsScalar(key, value)

    @staticmethod
    def AddAsString(key, value):
        r"""
        Add a new string parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : str
            The value associated to that key. The key is added to the string map even if
            it already exists in another map (float, unsigned int or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsString('View-ImageFormat2', 'png')
        >>> ot.ResourceMap.RemoveKey('View-ImageFormat2')
        """
        return _common.ResourceMap_AddAsString(key, value)

    @staticmethod
    def AddAsBool(key, value):
        r"""
        Add a new boolean parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : bool
            The value associated to that key. The key is added to the bool map even if
            it already exists in another map (float, unsigned int or string).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals2', True)
        >>> ot.ResourceMap.RemoveKey('MaximumEntropyOrderStatisticsDistribution-CheckMarginals2')
        """
        return _common.ResourceMap_AddAsBool(key, value)

    @staticmethod
    def AddAsUnsignedInteger(key, value):
        r"""
        Add a new integer parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : int
            The value associated to that key. The key is added to the unsigned integer
            map even if it already exists in another map (float, string or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsUnsignedInteger('MCMC-DefaultBurnIn2', 0)
        >>> ot.ResourceMap.RemoveKey('MCMC-DefaultBurnIn2')
        """
        return _common.ResourceMap_AddAsUnsignedInteger(key, value)

    @staticmethod
    def AddAsScalar(key, value):
        r"""
        Add a new floating-point parameter.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.
        value : float
            The value associated to that key. The key is added to the float map even if
            it already exists in another map (string, unsigned int or bool).

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsScalar('SQP-DefaultTau2', 0.5)
        >>> ot.ResourceMap.RemoveKey('SQP-DefaultTau2')
        """
        return _common.ResourceMap_AddAsScalar(key, value)

    @staticmethod
    def GetSize():
        r"""
        Get the size of the ResourceMap.

        Returns
        -------
        size : positive int
            The number of constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetSize()

    @staticmethod
    def GetStringSize():
        r"""
        Get the size of the string map in ResourceMap.

        Returns
        -------
        size : positive int
            The number of *string* constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetStringSize()

    @staticmethod
    def GetScalarSize():
        r"""
        Get the size of the float map in ResourceMap.

        Returns
        -------
        size : positive int
            The number of *float* constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetScalarSize()

    @staticmethod
    def GetUnsignedIntegerSize():
        r"""
        Get the size of the unsigned integer map in ResourceMap.

        Returns
        -------
        size : positive int
            The number of *unsigned integer* constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetUnsignedIntegerSize()

    @staticmethod
    def GetBoolSize():
        r"""
        Get the size of the bool map in ResourceMap.

        Returns
        -------
        size : positive int
            The number of *bool* constants defined in the ResourceMap.
        """
        return _common.ResourceMap_GetBoolSize()

    @staticmethod
    def GetKeys():
        r"""
        Get the keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of identifiers.
        """
        return _common.ResourceMap_GetKeys()

    @staticmethod
    def GetStringKeys():
        r"""
        Get the string keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of *string* identifiers.
        """
        return _common.ResourceMap_GetStringKeys()

    @staticmethod
    def GetScalarKeys():
        r"""
        Get the float keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of *float* identifiers.
        """
        return _common.ResourceMap_GetScalarKeys()

    @staticmethod
    def GetUnsignedIntegerKeys():
        r"""
        Get the unsigned integer keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of *unsigned integer* identifiers.
        """
        return _common.ResourceMap_GetUnsignedIntegerKeys()

    @staticmethod
    def GetBoolKeys():
        r"""
        Get the bool keys of the ResourceMap.

        Returns
        -------
        keys : tuple of str
            The list of *bool* identifiers.
        """
        return _common.ResourceMap_GetBoolKeys()

    @staticmethod
    def HasKey(key):
        r"""
        Check if an entry exists.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Returns
        -------
        has_key : bool
            Whether an entry with that key exists.
        """
        return _common.ResourceMap_HasKey(key)

    @staticmethod
    def RemoveKey(key):
        r"""
        Remove an entry.

        Parameters
        ----------
        key : str
            An identifier associated to the parameter.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.ResourceMap.AddAsString('dummy_key', 'key_to_be_removed')
        >>> ot.ResourceMap.RemoveKey('dummy_key')
        """
        return _common.ResourceMap_RemoveKey(key)

    @staticmethod
    def Reload():
        r"""
        Reload the configuration.

        Reverts the values of the default keys.
        Does not erase new keys.
        """
        return _common.ResourceMap_Reload()

    def __repr__(self):
        return _common.ResourceMap___repr__(self)

    @staticmethod
    def __len__():
        return _common.ResourceMap___len__()
    __swig_destroy__ = _common.delete_ResourceMap

# Register ResourceMap in _common:
_common.ResourceMap_swigregister(ResourceMap)

def ResourceMap_GetType(key):
    r"""
    Access the type of a parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    type : str
        The type associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.GetType('DiscreteDistribution-SupportEpsilon')
    'float'
    """
    return _common.ResourceMap_GetType(key)

def ResourceMap_Get(key):
    r"""
    Access a parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : str
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.Get('WeightedExperiment-DefaultSize')
    '100'
    """
    return _common.ResourceMap_Get(key)

def ResourceMap_GetAsString(key):
    r"""
    Access a string parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : str
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.Get('WeightedExperiment-DefaultSize')
    '100'
    """
    return _common.ResourceMap_GetAsString(key)

def ResourceMap_GetAsBool(key):
    r"""
    Access a boolean parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : bool
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.GetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals')
    True
    """
    return _common.ResourceMap_GetAsBool(key)

def ResourceMap_GetAsUnsignedInteger(key):
    r"""
    Access an integer parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : int
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.GetAsUnsignedInteger('MCMC-DefaultBurnIn')
    0...
    """
    return _common.ResourceMap_GetAsUnsignedInteger(key)

def ResourceMap_GetAsScalar(key):
    r"""
    Access a floating-point parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    value : float
        The value associated to that key.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.GetAsScalar('SQP-DefaultTau')
    0.5
    """
    return _common.ResourceMap_GetAsScalar(key)

def ResourceMap_Set(key, value):
    r"""
    Access an existing parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : str
        The value associated to that key. If the key already exists as a *float*,
        an *unsigned int* or a *bool*, the given string is converted into the
        corresponding type.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.Set('DiscreteDistribution-SupportEpsilon', '1.0e-14')
    """
    return _common.ResourceMap_Set(key, value)

def ResourceMap_SetAsString(key, value):
    r"""
    Set an existing string parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : str
        The value associated to that key. The key is added to the string map even if
        it already exists in another map (float, unsigned int or bool).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.SetAsString('View-ImageFormat', 'png')
    """
    return _common.ResourceMap_SetAsString(key, value)

def ResourceMap_SetAsBool(key, value):
    r"""
    Set an existing boolean parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : bool
        The value associated to that key. The key is added to the bool map even if
        it already exists in another map (float, unsigned int or string).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.SetAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals', True)
    """
    return _common.ResourceMap_SetAsBool(key, value)

def ResourceMap_SetAsUnsignedInteger(key, value):
    r"""
    Set an existing integer parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : int
        The value associated to that key. The key is added to the unsigned integer
        map even if it already exists in another map (float, string or bool).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.SetAsUnsignedInteger('MCMC-DefaultBurnIn', 0)
    """
    return _common.ResourceMap_SetAsUnsignedInteger(key, value)

def ResourceMap_SetAsScalar(key, value):
    r"""
    Set an existing floating-point parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : float
        The value associated to that key. The key is added to the float map even if
        it already exists in another map (string, unsigned int or bool).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.SetAsScalar('SQP-DefaultTau', 0.5)
    """
    return _common.ResourceMap_SetAsScalar(key, value)

def ResourceMap_AddAsString(key, value):
    r"""
    Add a new string parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : str
        The value associated to that key. The key is added to the string map even if
        it already exists in another map (float, unsigned int or bool).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.AddAsString('View-ImageFormat2', 'png')
    >>> ot.ResourceMap.RemoveKey('View-ImageFormat2')
    """
    return _common.ResourceMap_AddAsString(key, value)

def ResourceMap_AddAsBool(key, value):
    r"""
    Add a new boolean parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : bool
        The value associated to that key. The key is added to the bool map even if
        it already exists in another map (float, unsigned int or string).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.AddAsBool('MaximumEntropyOrderStatisticsDistribution-CheckMarginals2', True)
    >>> ot.ResourceMap.RemoveKey('MaximumEntropyOrderStatisticsDistribution-CheckMarginals2')
    """
    return _common.ResourceMap_AddAsBool(key, value)

def ResourceMap_AddAsUnsignedInteger(key, value):
    r"""
    Add a new integer parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : int
        The value associated to that key. The key is added to the unsigned integer
        map even if it already exists in another map (float, string or bool).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.AddAsUnsignedInteger('MCMC-DefaultBurnIn2', 0)
    >>> ot.ResourceMap.RemoveKey('MCMC-DefaultBurnIn2')
    """
    return _common.ResourceMap_AddAsUnsignedInteger(key, value)

def ResourceMap_AddAsScalar(key, value):
    r"""
    Add a new floating-point parameter.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.
    value : float
        The value associated to that key. The key is added to the float map even if
        it already exists in another map (string, unsigned int or bool).

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.AddAsScalar('SQP-DefaultTau2', 0.5)
    >>> ot.ResourceMap.RemoveKey('SQP-DefaultTau2')
    """
    return _common.ResourceMap_AddAsScalar(key, value)

def ResourceMap_GetSize():
    r"""
    Get the size of the ResourceMap.

    Returns
    -------
    size : positive int
        The number of constants defined in the ResourceMap.
    """
    return _common.ResourceMap_GetSize()

def ResourceMap_GetStringSize():
    r"""
    Get the size of the string map in ResourceMap.

    Returns
    -------
    size : positive int
        The number of *string* constants defined in the ResourceMap.
    """
    return _common.ResourceMap_GetStringSize()

def ResourceMap_GetScalarSize():
    r"""
    Get the size of the float map in ResourceMap.

    Returns
    -------
    size : positive int
        The number of *float* constants defined in the ResourceMap.
    """
    return _common.ResourceMap_GetScalarSize()

def ResourceMap_GetUnsignedIntegerSize():
    r"""
    Get the size of the unsigned integer map in ResourceMap.

    Returns
    -------
    size : positive int
        The number of *unsigned integer* constants defined in the ResourceMap.
    """
    return _common.ResourceMap_GetUnsignedIntegerSize()

def ResourceMap_GetBoolSize():
    r"""
    Get the size of the bool map in ResourceMap.

    Returns
    -------
    size : positive int
        The number of *bool* constants defined in the ResourceMap.
    """
    return _common.ResourceMap_GetBoolSize()

def ResourceMap_GetKeys():
    r"""
    Get the keys of the ResourceMap.

    Returns
    -------
    keys : tuple of str
        The list of identifiers.
    """
    return _common.ResourceMap_GetKeys()

def ResourceMap_GetStringKeys():
    r"""
    Get the string keys of the ResourceMap.

    Returns
    -------
    keys : tuple of str
        The list of *string* identifiers.
    """
    return _common.ResourceMap_GetStringKeys()

def ResourceMap_GetScalarKeys():
    r"""
    Get the float keys of the ResourceMap.

    Returns
    -------
    keys : tuple of str
        The list of *float* identifiers.
    """
    return _common.ResourceMap_GetScalarKeys()

def ResourceMap_GetUnsignedIntegerKeys():
    r"""
    Get the unsigned integer keys of the ResourceMap.

    Returns
    -------
    keys : tuple of str
        The list of *unsigned integer* identifiers.
    """
    return _common.ResourceMap_GetUnsignedIntegerKeys()

def ResourceMap_GetBoolKeys():
    r"""
    Get the bool keys of the ResourceMap.

    Returns
    -------
    keys : tuple of str
        The list of *bool* identifiers.
    """
    return _common.ResourceMap_GetBoolKeys()

def ResourceMap_HasKey(key):
    r"""
    Check if an entry exists.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Returns
    -------
    has_key : bool
        Whether an entry with that key exists.
    """
    return _common.ResourceMap_HasKey(key)

def ResourceMap_RemoveKey(key):
    r"""
    Remove an entry.

    Parameters
    ----------
    key : str
        An identifier associated to the parameter.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.ResourceMap.AddAsString('dummy_key', 'key_to_be_removed')
    >>> ot.ResourceMap.RemoveKey('dummy_key')
    """
    return _common.ResourceMap_RemoveKey(key)

def ResourceMap_Reload():
    r"""
    Reload the configuration.

    Reverts the values of the default keys.
    Does not erase new keys.
    """
    return _common.ResourceMap_Reload()

def ResourceMap___len__():
    return _common.ResourceMap___len__()

class ResourceMap_init(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _common.ResourceMap_init_swiginit(self, _common.new_ResourceMap_init())
    __swig_destroy__ = _common.delete_ResourceMap_init

# Register ResourceMap_init in _common:
_common.ResourceMap_init_swigregister(ResourceMap_init)

class ComparisonOperatorImplementation(PersistentObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.ComparisonOperatorImplementation_getClassName(self)

    def __repr__(self):
        return _common.ComparisonOperatorImplementation___repr__(self)

    def __call__(self, a, b):
        return _common.ComparisonOperatorImplementation___call__(self, a, b)

    def __init__(self, *args):
        _common.ComparisonOperatorImplementation_swiginit(self, _common.new_ComparisonOperatorImplementation(*args))
    __swig_destroy__ = _common.delete_ComparisonOperatorImplementation

# Register ComparisonOperatorImplementation in _common:
_common.ComparisonOperatorImplementation_swigregister(ComparisonOperatorImplementation)

class ComparisonOperatorImplementationTypedInterfaceObject(InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _common.ComparisonOperatorImplementationTypedInterfaceObject_swiginit(self, _common.new_ComparisonOperatorImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _common.ComparisonOperatorImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.ComparisonOperatorImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.ComparisonOperatorImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _common.ComparisonOperatorImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _common.ComparisonOperatorImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _common.delete_ComparisonOperatorImplementationTypedInterfaceObject

# Register ComparisonOperatorImplementationTypedInterfaceObject in _common:
_common.ComparisonOperatorImplementationTypedInterfaceObject_swigregister(ComparisonOperatorImplementationTypedInterfaceObject)

class ComparisonOperator(ComparisonOperatorImplementationTypedInterfaceObject):
    r"""
    Base class for comparison operators.

    Notes
    -----
    Comparison operators are defined through the following implementations : 
    :class:`~openturns.Equal`, :class:`~openturns.Greater`,
    :class:`~openturns.GreaterOrEqual`, :class:`~openturns.Less` or 
    :class:`~openturns.LessOrEqual`

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.ComparisonOperator_getClassName(self)

    def __call__(self, a, b):
        return _common.ComparisonOperator___call__(self, a, b)

    def compare(self, a, b):
        r"""
        Compare two values.

        Parameters
        ----------
        a : float
            First input to compare.
        b : float
            Second input to compare.
        """
        return _common.ComparisonOperator_compare(self, a, b)

    def __repr__(self):
        return _common.ComparisonOperator___repr__(self)

    def __init__(self, *args):
        _common.ComparisonOperator_swiginit(self, _common.new_ComparisonOperator(*args))
    __swig_destroy__ = _common.delete_ComparisonOperator

# Register ComparisonOperator in _common:
_common.ComparisonOperator_swigregister(ComparisonOperator)

class Equal(ComparisonOperatorImplementation):
    r"""
    Equal comparison operator.

    Available constructors:
        Equal()

    See also
    --------
    Greater, GreaterOrEqual, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Equal()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    True

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Equal_getClassName(self)

    def __repr__(self):
        return _common.Equal___repr__(self)

    def __str__(self, *args):
        return _common.Equal___str__(self, *args)

    def __call__(self, a, b):
        return _common.Equal___call__(self, a, b)

    def __init__(self, *args):
        _common.Equal_swiginit(self, _common.new_Equal(*args))
    __swig_destroy__ = _common.delete_Equal

# Register Equal in _common:
_common.Equal_swigregister(Equal)

class Greater(ComparisonOperatorImplementation):
    r"""
    Greater comparison operator.

    Available constructors:
        Greater()

    See also
    --------
    Equal, GreaterOrEqual, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Greater()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    True
    >>> print(operator(2, 2))
    False

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Greater_getClassName(self)

    def __repr__(self):
        return _common.Greater___repr__(self)

    def __str__(self, *args):
        return _common.Greater___str__(self, *args)

    def __call__(self, a, b):
        return _common.Greater___call__(self, a, b)

    def __init__(self, *args):
        _common.Greater_swiginit(self, _common.new_Greater(*args))
    __swig_destroy__ = _common.delete_Greater

# Register Greater in _common:
_common.Greater_swigregister(Greater)

class GreaterOrEqual(ComparisonOperatorImplementation):
    r"""
    Greater or equal comparison operator.

    Available constructors:
        GreaterOrEqual()

    See also
    --------
    Equal, Greater, Less, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.GreaterOrEqual()
    >>> print(operator(1, 2))
    False
    >>> print(operator(2, 1))
    True
    >>> print(operator(2, 2))
    True

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.GreaterOrEqual_getClassName(self)

    def __repr__(self):
        return _common.GreaterOrEqual___repr__(self)

    def __str__(self, *args):
        return _common.GreaterOrEqual___str__(self, *args)

    def __call__(self, a, b):
        return _common.GreaterOrEqual___call__(self, a, b)

    def __init__(self, *args):
        _common.GreaterOrEqual_swiginit(self, _common.new_GreaterOrEqual(*args))
    __swig_destroy__ = _common.delete_GreaterOrEqual

# Register GreaterOrEqual in _common:
_common.GreaterOrEqual_swigregister(GreaterOrEqual)

class Less(ComparisonOperatorImplementation):
    r"""
    Less comparison operator.

    Available constructors:
        Less()

    See also
    --------
    Equal, Greater, GreaterOrEqual, LessOrEqual

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.Less()
    >>> print(operator(1, 2))
    True
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    False

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.Less_getClassName(self)

    def __repr__(self):
        return _common.Less___repr__(self)

    def __str__(self, *args):
        return _common.Less___str__(self, *args)

    def __call__(self, a, b):
        return _common.Less___call__(self, a, b)

    def __init__(self, *args):
        _common.Less_swiginit(self, _common.new_Less(*args))
    __swig_destroy__ = _common.delete_Less

# Register Less in _common:
_common.Less_swigregister(Less)

class LessOrEqual(ComparisonOperatorImplementation):
    r"""
    Less or equal comparison operator.

    Available constructors:
        LessOrEqual()

    See also
    --------
    Equal, Greater, GreaterOrEqual, Less

    Examples
    --------
    >>> import openturns as ot
    >>> operator = ot.LessOrEqual()
    >>> print(operator(1, 2))
    True
    >>> print(operator(2, 1))
    False
    >>> print(operator(2, 2))
    True

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.LessOrEqual_getClassName(self)

    def __repr__(self):
        return _common.LessOrEqual___repr__(self)

    def __str__(self, *args):
        return _common.LessOrEqual___str__(self, *args)

    def __call__(self, a, b):
        return _common.LessOrEqual___call__(self, a, b)

    def __init__(self, *args):
        _common.LessOrEqual_swiginit(self, _common.new_LessOrEqual(*args))
    __swig_destroy__ = _common.delete_LessOrEqual

# Register LessOrEqual in _common:
_common.LessOrEqual_swigregister(LessOrEqual)

class PlatformInfo(object):
    r"""
    Informations about platform.

    No constructor, only static methods are available.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def GetVersion():
        r"""
        Accessor to the version string.

        Returns
        -------
        version : str
            Version string.
        """
        return _common.PlatformInfo_GetVersion()

    @staticmethod
    def GetName():
        return _common.PlatformInfo_GetName()

    @staticmethod
    def GetRevision():
        r"""
        Accessor to the revision string.

        Returns
        -------
        revision : str
            Git revision.
        """
        return _common.PlatformInfo_GetRevision()

    @staticmethod
    def GetDate():
        return _common.PlatformInfo_GetDate()

    @staticmethod
    def GetInstallationDirectory():
        return _common.PlatformInfo_GetInstallationDirectory()

    @staticmethod
    def GetNumericalPrecision():
        r"""
        Accessor to the output numerical precision.

        Returns
        -------
        precision : int
            String ouput numerical precision.
        """
        return _common.PlatformInfo_GetNumericalPrecision()

    @staticmethod
    def SetNumericalPrecision(precision):
        r"""
        Accessor to the output numerical precision.

        Parameters
        ----------
        precision : int
            String ouput numerical precision.
        """
        return _common.PlatformInfo_SetNumericalPrecision(precision)

    @staticmethod
    def SetTwoDigitExponent(enable=True):
        r"""
        Use two digits for exponent format.

        For testing purposes with pre 2015 MSVC compilers.

        Parameters
        ----------
        enable : bool, default=True
            Whether to switch to two digits exponent.
        """
        return _common.PlatformInfo_SetTwoDigitExponent(enable)
    __swig_destroy__ = _common.delete_PlatformInfo

# Register PlatformInfo in _common:
_common.PlatformInfo_swigregister(PlatformInfo)

def PlatformInfo_GetVersion():
    r"""
    Accessor to the version string.

    Returns
    -------
    version : str
        Version string.
    """
    return _common.PlatformInfo_GetVersion()

def PlatformInfo_GetName():
    return _common.PlatformInfo_GetName()

def PlatformInfo_GetRevision():
    r"""
    Accessor to the revision string.

    Returns
    -------
    revision : str
        Git revision.
    """
    return _common.PlatformInfo_GetRevision()

def PlatformInfo_GetDate():
    return _common.PlatformInfo_GetDate()

def PlatformInfo_GetInstallationDirectory():
    return _common.PlatformInfo_GetInstallationDirectory()

def PlatformInfo_GetNumericalPrecision():
    r"""
    Accessor to the output numerical precision.

    Returns
    -------
    precision : int
        String ouput numerical precision.
    """
    return _common.PlatformInfo_GetNumericalPrecision()

def PlatformInfo_SetNumericalPrecision(precision):
    r"""
    Accessor to the output numerical precision.

    Parameters
    ----------
    precision : int
        String ouput numerical precision.
    """
    return _common.PlatformInfo_SetNumericalPrecision(precision)

def PlatformInfo_SetTwoDigitExponent(enable=True):
    r"""
    Use two digits for exponent format.

    For testing purposes with pre 2015 MSVC compilers.

    Parameters
    ----------
    enable : bool, default=True
        Whether to switch to two digits exponent.
    """
    return _common.PlatformInfo_SetTwoDigitExponent(enable)

class ComparisonOperatorImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_common.ComparisonOperatorImplementationPointer_ptr__get, _common.ComparisonOperatorImplementationPointer_ptr__set)

    def __init__(self, *args):
        _common.ComparisonOperatorImplementationPointer_swiginit(self, _common.new_ComparisonOperatorImplementationPointer(*args))
    __swig_destroy__ = _common.delete_ComparisonOperatorImplementationPointer

    def reset(self):
        return _common.ComparisonOperatorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _common.ComparisonOperatorImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _common.ComparisonOperatorImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _common.ComparisonOperatorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _common.ComparisonOperatorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common.ComparisonOperatorImplementationPointer_get(self)

    def getImplementation(self):
        return _common.ComparisonOperatorImplementationPointer_getImplementation(self)

    def unique(self):
        return _common.ComparisonOperatorImplementationPointer_unique(self)

    def use_count(self):
        return _common.ComparisonOperatorImplementationPointer_use_count(self)

    def swap(self, other):
        return _common.ComparisonOperatorImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.ComparisonOperatorImplementationPointer_getClassName(self)

    def __repr__(self):
        return _common.ComparisonOperatorImplementationPointer___repr__(self)

    def __call__(self, a, b):
        return _common.ComparisonOperatorImplementationPointer___call__(self, a, b)

    def __eq__(self, arg2):
        return _common.ComparisonOperatorImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _common.ComparisonOperatorImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _common.ComparisonOperatorImplementationPointer___str__(self, *args)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.ComparisonOperatorImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _common.ComparisonOperatorImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _common.ComparisonOperatorImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _common.ComparisonOperatorImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _common.ComparisonOperatorImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common.ComparisonOperatorImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _common.ComparisonOperatorImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.ComparisonOperatorImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.ComparisonOperatorImplementationPointer_setName(self, name)

# Register ComparisonOperatorImplementationPointer in _common:
_common.ComparisonOperatorImplementationPointer_swigregister(ComparisonOperatorImplementationPointer)

class PersistentObjectPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_common.PersistentObjectPointer_ptr__get, _common.PersistentObjectPointer_ptr__set)

    def __init__(self, *args):
        _common.PersistentObjectPointer_swiginit(self, _common.new_PersistentObjectPointer(*args))
    __swig_destroy__ = _common.delete_PersistentObjectPointer

    def reset(self):
        return _common.PersistentObjectPointer_reset(self)

    def __ref__(self, *args):
        return _common.PersistentObjectPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _common.PersistentObjectPointer___deref__(self, *args)

    def isNull(self):
        return _common.PersistentObjectPointer_isNull(self)

    def __nonzero__(self):
        return _common.PersistentObjectPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common.PersistentObjectPointer_get(self)

    def getImplementation(self):
        return _common.PersistentObjectPointer_getImplementation(self)

    def unique(self):
        return _common.PersistentObjectPointer_unique(self)

    def use_count(self):
        return _common.PersistentObjectPointer_use_count(self)

    def swap(self, other):
        return _common.PersistentObjectPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.PersistentObjectPointer_getClassName(self)

    def __eq__(self, arg2):
        return _common.PersistentObjectPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _common.PersistentObjectPointer___ne__(self, other)

    def __repr__(self):
        return _common.PersistentObjectPointer___repr__(self)

    def __str__(self, *args):
        return _common.PersistentObjectPointer___str__(self, *args)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _common.PersistentObjectPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _common.PersistentObjectPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _common.PersistentObjectPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _common.PersistentObjectPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _common.PersistentObjectPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _common.PersistentObjectPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _common.PersistentObjectPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _common.PersistentObjectPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _common.PersistentObjectPointer_setName(self, name)

# Register PersistentObjectPointer in _common:
_common.PersistentObjectPointer_swigregister(PersistentObjectPointer)

class StorageManagerPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_common.StorageManagerPointer_ptr__get, _common.StorageManagerPointer_ptr__set)

    def __init__(self, *args):
        _common.StorageManagerPointer_swiginit(self, _common.new_StorageManagerPointer(*args))
    __swig_destroy__ = _common.delete_StorageManagerPointer

    def reset(self):
        return _common.StorageManagerPointer_reset(self)

    def __ref__(self, *args):
        return _common.StorageManagerPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _common.StorageManagerPointer___deref__(self, *args)

    def isNull(self):
        return _common.StorageManagerPointer_isNull(self)

    def __nonzero__(self):
        return _common.StorageManagerPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _common.StorageManagerPointer_get(self)

    def getImplementation(self):
        return _common.StorageManagerPointer_getImplementation(self)

    def unique(self):
        return _common.StorageManagerPointer_unique(self)

    def use_count(self):
        return _common.StorageManagerPointer_use_count(self)

    def swap(self, other):
        return _common.StorageManagerPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _common.StorageManagerPointer_getClassName(self)

    def __repr__(self):
        return _common.StorageManagerPointer___repr__(self)

    def save(self, obj, label, fromStudy=False):
        r"""
        Save the object onto the medium.

        Parameters
        ----------
        object : :class:`~openturns.PersistentObject`
            Object to be saved.
        label : str
            Name associate with the object to be saved.
        fromStudy : bool, optional
            Flag telling if the object was explicitely put in the study or not. By
            default, it is equal to *False*.
        """
        return _common.StorageManagerPointer_save(self, obj, label, fromStudy)

    def load(self, study):
        r"""
        Reload the whole study from the medium.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            The study to reload objects from.
        """
        return _common.StorageManagerPointer_load(self, study)

    def getStudy(self):
        r"""
        Get the study bound to the manager.

        Returns
        -------
        study : :class:`~openturns.Study`
            Study bound to the manager.
        """
        return _common.StorageManagerPointer_getStudy(self)

    def setStudy(self, p_study):
        r"""
        Set the study bound to the manager.

        Parameters
        ----------
        study : :class:`~openturns.Study`
            Study bound to the manager.
        """
        return _common.StorageManagerPointer_setStudy(self, p_study)

    def getDefaultStudyVersion(self):
        r"""
        Return the version of the study that the manager can read/write.

        Returns
        -------
        version : positive int
            Version of the study that the manager can read/write.
        """
        return _common.StorageManagerPointer_getDefaultStudyVersion(self)

    def getStudyVersion(self):
        r"""
        Get the study version.

        Returns
        -------
        version : positive int
            Study version.
        """
        return _common.StorageManagerPointer_getStudyVersion(self)

    def setStudyVersion(self, version):
        r"""
        Set the study version.

        Parameters
        ----------
        version : positive int
            Study version.
        """
        return _common.StorageManagerPointer_setStudyVersion(self, version)

    def initialize(self, *args):
        r"""
        Do some administrative tasks before saving/reloading.

        :Available usages:
            initialize(*ot.SaveAction()*)

            initialize(*ot.LoadAction()*)
        """
        return _common.StorageManagerPointer_initialize(self, *args)

    def finalize(self, *args):
        r"""
        Do some administrative tasks after saving/reloading.

        :Available usages:
            finalize(*ot.SaveAction()*)

            finalize(*ot.LoadAction()*)
        """
        return _common.StorageManagerPointer_finalize(self, *args)

    def read(self):
        r"""Read and create the internal representation."""
        return _common.StorageManagerPointer_read(self)

    def write(self):
        r"""Write the internal representation."""
        return _common.StorageManagerPointer_write(self)

    def isSavedObject(self, id):
        r"""
        Tell if an object is already saved.

        Returns
        -------
        isSaved : bool
            *True* if an object is already saved.
        """
        return _common.StorageManagerPointer_isSavedObject(self, id)

    def markObjectAsSaved(self, id):
        r"""
        Tell that an object is saved.

        Parameters
        ----------
        Id : int
            Internal identifier of the object.
        """
        return _common.StorageManagerPointer_markObjectAsSaved(self, id)

    def __str__(self, *args):
        return _common.StorageManagerPointer___str__(self, *args)

# Register StorageManagerPointer in _common:
_common.StorageManagerPointer_swigregister(StorageManagerPointer)



