# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""Bayesian algorithms."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _bayesian
else:
    import _bayesian

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _bayesian.delete_SwigPyIterator

    def value(self):
        return _bayesian.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _bayesian.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _bayesian.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _bayesian.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _bayesian.SwigPyIterator_equal(self, x)

    def copy(self):
        return _bayesian.SwigPyIterator_copy(self)

    def next(self):
        return _bayesian.SwigPyIterator_next(self)

    def __next__(self):
        return _bayesian.SwigPyIterator___next__(self)

    def previous(self):
        return _bayesian.SwigPyIterator_previous(self)

    def advance(self, n):
        return _bayesian.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _bayesian.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _bayesian.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _bayesian.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _bayesian.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _bayesian.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _bayesian.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _bayesian:
_bayesian.SwigPyIterator_swigregister(SwigPyIterator)


class TestFailed:
    """TestFailed is used to raise an uniform exception in tests."""

    __type = "TestFailed"

    def __init__(self, reason=""):
        self.reason = reason

    def type(self):
        return TestFailed.__type

    def what(self):
        return self.reason

    def __str__(self):
        return TestFailed.__type + ": " + self.reason

    def __lshift__(self, ch):
        self.reason += ch
        return self

import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.randomvector
class CalibrationResult(openturns.common.PersistentObject):
    r"""
    Calibration result.

    Returned by calibration algorithms, see :class:`~openturns.CalibrationAlgorithm`.

    Parameters
    ----------
    parameterPrior : :class:`~openturns.Distribution`
        The prior distribution of the parameter.
    parameterPosterior : :class:`~openturns.Distribution`
        The posterior distribution of the parameter.
    parameterMap : sequence of float
        The maximum a posteriori estimate of the parameter.
    observationsError : :class:`~openturns.Distribution`
        The distribution of the observations error.
    outputObservations : :class:`~openturns.Sample`
        The sample of output observations.
    residualFunction : :class:`~openturns.Function`
        The residual function.

    Notes
    -----

    The residual function returns `model(inputObservations) - outputObservations`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationResult_getClassName(self)

    def setParameterPrior(self, parameterPrior):
        r"""
        Accessor to the parameter prior distribution.

        Parameters
        ----------
        parameterPrior : : :class:`~openturns.Distribution`
            The prior distribution of the parameter.
        """
        return _bayesian.CalibrationResult_setParameterPrior(self, parameterPrior)

    def getParameterPrior(self):
        r"""
        Accessor to the parameter prior distribution.

        Returns
        -------
        parameterPrior : :class:`~openturns.Distribution`
            The prior distribution of the parameter.
        """
        return _bayesian.CalibrationResult_getParameterPrior(self)

    def setParameterPosterior(self, parameterPosterior):
        r"""
        Accessor to the parameter posterior distribution.

        Parameters
        ----------
        parameterPosterior : : :class:`~openturns.Distribution`
            The posterior distribution of the parameter.
        """
        return _bayesian.CalibrationResult_setParameterPosterior(self, parameterPosterior)

    def getParameterPosterior(self):
        r"""
        Accessor to the parameter posterior distribution.

        Returns
        -------
        parameterPosterior : :class:`~openturns.Distribution`
            The posterior distribution of the parameter.
        """
        return _bayesian.CalibrationResult_getParameterPosterior(self)

    def setObservationsError(self, observationsError):
        r"""
        Accessor to the observations error distribution.

        Parameters
        ----------
        observationsError : :class:`~openturns.Distribution`
            The observations error distribution.
        """
        return _bayesian.CalibrationResult_setObservationsError(self, observationsError)

    def getObservationsError(self):
        r"""
        Accessor to the observations error distribution.

        Returns
        -------
        observationsError : :class:`~openturns.Distribution`
            The observations error distribution.
        """
        return _bayesian.CalibrationResult_getObservationsError(self)

    def setParameterMAP(self, parameterMAP):
        r"""
        Accessor to the maximum a posteriori parameter estimate.

        Parameters
        ----------
        parameterPosterior : sequence of float
            The maximum a posteriori parameter estimate.
        """
        return _bayesian.CalibrationResult_setParameterMAP(self, parameterMAP)

    def getParameterMAP(self):
        r"""
        Accessor to the maximum a posteriori parameter estimate.

        Returns
        -------
        parameterPosterior : :class:`~openturns.Point`
            The maximum a posteriori parameter estimate.
        """
        return _bayesian.CalibrationResult_getParameterMAP(self)

    def setOutputObservations(self, outputObservations):
        r"""
        Accessor to the output observations.

        Parameters
        ----------
        outputObservations : :class:`~openturns.Sample`
            The sample of output observations.
        """
        return _bayesian.CalibrationResult_setOutputObservations(self, outputObservations)

    def getOutputObservations(self):
        r"""
        Accessor to the output observations.

        Returns
        -------
        outputObservations : :class:`~openturns.Sample`
            The sample of output observations.
        """
        return _bayesian.CalibrationResult_getOutputObservations(self)

    def setResidualFunction(self, residualFunction):
        r"""
        Accessor to the residual function.

        Parameters
        ----------
        residualFunction : :class:`~openturns.Function`
            The residual function.
        """
        return _bayesian.CalibrationResult_setResidualFunction(self, residualFunction)

    def getResidualFunction(self):
        r"""
        Accessor to the residual function.

        Returns
        -------
        residualFunction : :class:`~openturns.Function`
            The residual function.
        """
        return _bayesian.CalibrationResult_getResidualFunction(self)

    def __repr__(self):
        return _bayesian.CalibrationResult___repr__(self)

    def __init__(self, *args):
        _bayesian.CalibrationResult_swiginit(self, _bayesian.new_CalibrationResult(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationResult

# Register CalibrationResult in _bayesian:
_bayesian.CalibrationResult_swigregister(CalibrationResult)

class CalibrationAlgorithmImplementation(openturns.common.PersistentObject):
    r"""
    Base class for calibration algorithms.

    Parameters
    ----------
    outputObservations : 2-d sequence of float
        The output data to be fitted.
    prior : :class:`~openturns.Distribution`
        The prior distribution of the parameter

    See also
    --------
    CalibrationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationAlgorithmImplementation_getClassName(self)

    def __repr__(self):
        return _bayesian.CalibrationAlgorithmImplementation___repr__(self)

    def getOutputObservations(self):
        r"""
        Accessor to the output data to be fitted.

        Returns
        -------
        data : :class:`~openturns.Sample`
            The output data to be fitted.
        """
        return _bayesian.CalibrationAlgorithmImplementation_getOutputObservations(self)

    def getParameterPrior(self):
        r"""
        Accessor to the parameter prior distribution.

        Returns
        -------
        prior : :class:`~openturns.Distribution`
            The parameter prior distribution.
        """
        return _bayesian.CalibrationAlgorithmImplementation_getParameterPrior(self)

    def run(self):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.CalibrationAlgorithmImplementation_run(self)

    def getResult(self):
        r"""
        Get the result structure.

        Returns
        -------
        resCalibration: :class:`~openturns.CalibrationResult`
            The structure containing all the results of the calibration problem.

        Notes
        -----
        The structure contains all the results of the calibration problem.
        """
        return _bayesian.CalibrationAlgorithmImplementation_getResult(self)

    def setResult(self, result):
        r"""
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.CalibrationResult`
            Result class.
        """
        return _bayesian.CalibrationAlgorithmImplementation_setResult(self, result)

    def __init__(self, *args):
        _bayesian.CalibrationAlgorithmImplementation_swiginit(self, _bayesian.new_CalibrationAlgorithmImplementation(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationAlgorithmImplementation

# Register CalibrationAlgorithmImplementation in _bayesian:
_bayesian.CalibrationAlgorithmImplementation_swigregister(CalibrationAlgorithmImplementation)

class CalibrationAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _bayesian.CalibrationAlgorithmImplementationTypedInterfaceObject_swiginit(self, _bayesian.new_CalibrationAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _bayesian.CalibrationAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _bayesian.CalibrationAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _bayesian.CalibrationAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _bayesian.delete_CalibrationAlgorithmImplementationTypedInterfaceObject

# Register CalibrationAlgorithmImplementationTypedInterfaceObject in _bayesian:
_bayesian.CalibrationAlgorithmImplementationTypedInterfaceObject_swigregister(CalibrationAlgorithmImplementationTypedInterfaceObject)

class CalibrationAlgorithm(CalibrationAlgorithmImplementationTypedInterfaceObject):
    r"""
    Base class for calibration algorithms.

    Parameters
    ----------
    outputObservations : 2-d sequence of float
        The output data to be fitted.
    prior : :class:`~openturns.Distribution`
        The prior distribution of the parameter

    See also
    --------
    CalibrationResult
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationAlgorithm_getClassName(self)

    def run(self):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.CalibrationAlgorithm_run(self)

    def getOutputObservations(self):
        r"""
        Accessor to the output data to be fitted.

        Returns
        -------
        data : :class:`~openturns.Sample`
            The output data to be fitted.
        """
        return _bayesian.CalibrationAlgorithm_getOutputObservations(self)

    def getParameterPrior(self):
        r"""
        Accessor to the parameter prior distribution.

        Returns
        -------
        prior : :class:`~openturns.Distribution`
            The parameter prior distribution.
        """
        return _bayesian.CalibrationAlgorithm_getParameterPrior(self)

    def setResult(self, result):
        r"""
        Accessor to optimization result.

        Parameters
        ----------
        result : :class:`~openturns.CalibrationResult`
            Result class.
        """
        return _bayesian.CalibrationAlgorithm_setResult(self, result)

    def getResult(self):
        r"""
        Get the result structure.

        Returns
        -------
        resCalibration: :class:`~openturns.CalibrationResult`
            The structure containing all the results of the calibration problem.

        Notes
        -----
        The structure contains all the results of the calibration problem.
        """
        return _bayesian.CalibrationAlgorithm_getResult(self)

    def __init__(self, *args):
        _bayesian.CalibrationAlgorithm_swiginit(self, _bayesian.new_CalibrationAlgorithm(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationAlgorithm

# Register CalibrationAlgorithm in _bayesian:
_bayesian.CalibrationAlgorithm_swigregister(CalibrationAlgorithm)

class CalibrationStrategyImplementation(openturns.common.PersistentObject):
    r"""
    Calibration strategy.

    Available constructors:
        CalibrationStrategy(*range*)

        CalibrationStrategy(*range=[0.117, 0.468], expansionFactor=1.2, shrinkFactor=0.8, calibrationStep=100*)

    Parameters
    ----------
    range : :class:`~openturns.Interval` of dimension 1 :math:`[m,M]`
        Acceptance rate values for which no update of the *calibration* coefficient
        is performed.
    expansionFactor : float, :math:`e > 1`
        Expansion factor :math:`e` to use to rescale the *calibration* coefficient
        if the latter is too high (greater than the upper bound of range).
    shrinkFactor : float, :math:`0 < s < 1`
        Shrink factor :math:`s` to use to rescale the *calibration* coefficient if
        the latter is too low (smaller than the lower bound of range). If
        *expansionFactor* is specified, *shrinkFactor* must be mentioned too.
    calibrationStep : positive int
        Calibration step corresponding for example to :math:`q` in the description
        of the method
        :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
        of the RandomWalkMetropolisHastings class.

    Notes
    -----
    A CalibrationStrategy can be used by a
    :class:`~openturns.RandomWalkMetropolisHastings` for example (see the
    description of the method
    :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
    ).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationStrategyImplementation_getClassName(self)

    def __repr__(self):
        return _bayesian.CalibrationStrategyImplementation___repr__(self)

    def setRange(self, range):
        r"""
        Set the range.

        Parameters
        ----------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_setRange(self, range)

    def getRange(self):
        r"""
        Get the range.

        Returns
        -------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_getRange(self)

    def setExpansionFactor(self, expansionFactor):
        r"""
        Set the expansion factor.

        Parameters
        ----------
        expansionFactor : float, :math:`e > 1`
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_setExpansionFactor(self, expansionFactor)

    def getExpansionFactor(self):
        r"""
        Get the expansion factor.

        Returns
        -------
        expansionFactor : float
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_getExpansionFactor(self)

    def setShrinkFactor(self, shrinkFactor):
        r"""
        Set the shrink factor.

        Parameters
        ----------
        shrinkFactor : float, :math:`0 < s < 1`
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_setShrinkFactor(self, shrinkFactor)

    def getShrinkFactor(self):
        r"""
        Get the shrink factor.

        Returns
        -------
        shrinkFactor : float
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementation_getShrinkFactor(self)

    def setCalibrationStep(self, calibrationStep):
        r"""
        Set the calibration step.

        Parameters
        ----------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategyImplementation_setCalibrationStep(self, calibrationStep)

    def getCalibrationStep(self):
        r"""
        Get the calibration step.

        Returns
        -------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategyImplementation_getCalibrationStep(self)

    def computeUpdateFactor(self, rho):
        r"""
        Compute the update factor.

        Parameters
        ----------
        rho : float
            Acceptance rate :math:`\rho` to take into account.

        Returns
        -------
        lambda : float
            Let :math:`\lambda` be the *calibration* coefficient to update, it gives a
            factor :math:`\phi(\rho)` such that :math:`\phi(\rho) \lambda` is the
            updated *calibration* coefficient according to the strategy. The value is
            computed as follows:

            .. math::

                \phi(\rho) = \left\{
                         \begin{array}{l}
                             \displaystyle s  \quad if \; \rho < m \\
                             \displaystyle e  \quad if \; \rho > M \\
                             \displaystyle 1  \quad otherwise
                         \end{array}
                         \right.

            with :math:`s \in ]0, 1[, e > 1` and :math:`[m,M]` the values given,
            respectively, by the methods :meth:`getShrinkFactor`,
            :meth:`getExpansionFactor` and :meth:`getRange`.

        Examples
        --------
        >>> import openturns as ot
        >>> calibration = ot.CalibrationStrategy(ot.Interval(0.1, 0.4), 1.2, 0.8)
        >>> print(calibration.computeUpdateFactor(0.09))
        0.8
        >>> print(calibration.computeUpdateFactor(0.6))
        1.2
        >>> print(calibration.computeUpdateFactor(0.18))
        1.0
        """
        return _bayesian.CalibrationStrategyImplementation_computeUpdateFactor(self, rho)

    def __init__(self, *args):
        _bayesian.CalibrationStrategyImplementation_swiginit(self, _bayesian.new_CalibrationStrategyImplementation(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationStrategyImplementation

# Register CalibrationStrategyImplementation in _bayesian:
_bayesian.CalibrationStrategyImplementation_swigregister(CalibrationStrategyImplementation)

class CalibrationStrategyImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _bayesian.CalibrationStrategyImplementationTypedInterfaceObject_swiginit(self, _bayesian.new_CalibrationStrategyImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            The implementation class.
        """
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _bayesian.CalibrationStrategyImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _bayesian.delete_CalibrationStrategyImplementationTypedInterfaceObject

# Register CalibrationStrategyImplementationTypedInterfaceObject in _bayesian:
_bayesian.CalibrationStrategyImplementationTypedInterfaceObject_swigregister(CalibrationStrategyImplementationTypedInterfaceObject)

class CalibrationStrategyCollection(object):
    r"""
    Collection.

    Examples
    --------
    >>> import openturns as ot

    - Collection of **real values**:

    >>> ot.ScalarCollection(2)
    [0,0]
    >>> ot.ScalarCollection(2, 3.25)
    [3.25,3.25]
    >>> vector = ot.ScalarCollection([2.0, 1.5, 2.6])
    >>> vector
    [2,1.5,2.6]
    >>> vector[1] = 4.2
    >>> vector
    [2,4.2,2.6]
    >>> vector.add(3.8)
    >>> vector
    [2,4.2,2.6,3.8]

    - Collection of **complex values**:

    >>> ot.ComplexCollection(2)
    [(0,0),(0,0)]
    >>> ot.ComplexCollection(2, 3+4j)
    [(3,4),(3,4)]
    >>> vector = ot.ComplexCollection([2+3j, 1-4j, 3.0])
    >>> vector
    [(2,3),(1,-4),(3,0)]
    >>> vector[1] = 4+3j
    >>> vector
    [(2,3),(4,3),(3,0)]
    >>> vector.add(5+1j)
    >>> vector
    [(2,3),(4,3),(3,0),(5,1)]

    - Collection of **booleans**:

    >>> ot.BoolCollection(3)
    [0,0,0]
    >>> ot.BoolCollection(3, 1)
    [1,1,1]
    >>> vector = ot.BoolCollection([0, 1, 0])
    >>> vector
    [0,1,0]
    >>> vector[1] = 0
    >>> vector
    [0,0,0]
    >>> vector.add(1)
    >>> vector
    [0,0,0,1]

    - Collection of **distributions**:

    >>> print(ot.DistributionCollection(2))
    [Uniform(a = -1, b = 1),Uniform(a = -1, b = 1)]
    >>> print(ot.DistributionCollection(2, ot.Gamma(2.75, 1.0)))
    [Gamma(k = 2.75, lambda = 1, gamma = 0),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    >>> vector = ot.DistributionCollection([ot.Normal(), ot.Uniform()])
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -1, b = 1)]
    >>> vector[1] = ot.Uniform(-0.5, 1)
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1)]
    >>> vector.add(ot.Gamma(2.75, 1.0))
    >>> print(vector)
    [Normal(mu = 0, sigma = 1),Uniform(a = -0.5, b = 1),Gamma(k = 2.75, lambda = 1, gamma = 0)]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __swig_destroy__ = _bayesian.delete_CalibrationStrategyCollection

    def clear(self):
        r"""
        Reset the collection to zero dimension.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.clear()
        >>> x
        class=Point name=Unnamed dimension=0 values=[]
        """
        return _bayesian.CalibrationStrategyCollection_clear(self)

    def __len__(self):
        return _bayesian.CalibrationStrategyCollection___len__(self)

    def __eq__(self, rhs):
        return _bayesian.CalibrationStrategyCollection___eq__(self, rhs)

    def __contains__(self, val):
        return _bayesian.CalibrationStrategyCollection___contains__(self, val)

    def __getitem__(self, i):
        return _bayesian.CalibrationStrategyCollection___getitem__(self, i)

    def __setitem__(self, i, val):
        return _bayesian.CalibrationStrategyCollection___setitem__(self, i, val)

    def __delitem__(self, i):
        return _bayesian.CalibrationStrategyCollection___delitem__(self, i)

    def at(self, *args):
        r"""
        Access to an element of the collection.

        Parameters
        ----------
        index : positive int
            Position of the element to access.

        Returns
        -------
        element : type depends on the type of the collection
            Element of the collection at the position *index*.
        """
        return _bayesian.CalibrationStrategyCollection_at(self, *args)

    def add(self, *args):
        r"""
        Append a component (in-place).

        Parameters
        ----------
        value : type depends on the type of the collection.
            The component to append.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.add(1.)
        >>> print(x)
        [0,0,1]
        """
        return _bayesian.CalibrationStrategyCollection_add(self, *args)

    def getSize(self):
        r"""
        Get the collection's dimension (or size).

        Returns
        -------
        n : int
            The number of components in the collection.
        """
        return _bayesian.CalibrationStrategyCollection_getSize(self)

    def resize(self, newSize):
        r"""
        Change the size of the collection.

        Parameters
        ----------
        newSize : positive int
            New size of the collection.

        Notes
        -----
        If the new size is smaller than the older one, the last elements are thrown
        away, else the new elements are set to the default value of the element type.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2, 4)
        >>> print(x)
        [4,4]
        >>> x.resize(1)
        >>> print(x)
        [4]
        >>> x.resize(4)
        >>> print(x)
        [4,0,0,0]
        """
        return _bayesian.CalibrationStrategyCollection_resize(self, newSize)

    def isEmpty(self):
        r"""
        Tell if the collection is empty.

        Returns
        -------
        isEmpty : bool
            *True* if there is no element in the collection.

        Examples
        --------
        >>> import openturns as ot
        >>> x = ot.Point(2)
        >>> x.isEmpty()
        False
        >>> x.clear()
        >>> x.isEmpty()
        True
        """
        return _bayesian.CalibrationStrategyCollection_isEmpty(self)

    def find(self, val):
        r"""
        Find the index of a given value.

        Parameters
        ----------
        val : collection value type
            The value to find

        Returns
        -------
        index : int
            The index of the first occurence of the value,
            or the size of the container if not found.
            When several values match, only the first index is returned.
        """
        return _bayesian.CalibrationStrategyCollection_find(self, val)

    def __repr__(self):
        return _bayesian.CalibrationStrategyCollection___repr__(self)

    def __str__(self, *args):
        return _bayesian.CalibrationStrategyCollection___str__(self, *args)

    def __init__(self, *args):
        _bayesian.CalibrationStrategyCollection_swiginit(self, _bayesian.new_CalibrationStrategyCollection(*args))

# Register CalibrationStrategyCollection in _bayesian:
_bayesian.CalibrationStrategyCollection_swigregister(CalibrationStrategyCollection)

class CalibrationStrategy(CalibrationStrategyImplementationTypedInterfaceObject):
    r"""
    Calibration strategy.

    Available constructors:
        CalibrationStrategy(*range*)

        CalibrationStrategy(*range=[0.117, 0.468], expansionFactor=1.2, shrinkFactor=0.8, calibrationStep=100*)

    Parameters
    ----------
    range : :class:`~openturns.Interval` of dimension 1 :math:`[m,M]`
        Acceptance rate values for which no update of the *calibration* coefficient
        is performed.
    expansionFactor : float, :math:`e > 1`
        Expansion factor :math:`e` to use to rescale the *calibration* coefficient
        if the latter is too high (greater than the upper bound of range).
    shrinkFactor : float, :math:`0 < s < 1`
        Shrink factor :math:`s` to use to rescale the *calibration* coefficient if
        the latter is too low (smaller than the lower bound of range). If
        *expansionFactor* is specified, *shrinkFactor* must be mentioned too.
    calibrationStep : positive int
        Calibration step corresponding for example to :math:`q` in the description
        of the method
        :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
        of the RandomWalkMetropolisHastings class.

    Notes
    -----
    A CalibrationStrategy can be used by a
    :class:`~openturns.RandomWalkMetropolisHastings` for example (see the
    description of the method
    :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
    ).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationStrategy_getClassName(self)

    def setRange(self, range):
        r"""
        Set the range.

        Parameters
        ----------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_setRange(self, range)

    def getRange(self):
        r"""
        Get the range.

        Returns
        -------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_getRange(self)

    def setExpansionFactor(self, expansionFactor):
        r"""
        Set the expansion factor.

        Parameters
        ----------
        expansionFactor : float, :math:`e > 1`
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_setExpansionFactor(self, expansionFactor)

    def getExpansionFactor(self):
        r"""
        Get the expansion factor.

        Returns
        -------
        expansionFactor : float
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_getExpansionFactor(self)

    def setShrinkFactor(self, shrinkFactor):
        r"""
        Set the shrink factor.

        Parameters
        ----------
        shrinkFactor : float, :math:`0 < s < 1`
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_setShrinkFactor(self, shrinkFactor)

    def getShrinkFactor(self):
        r"""
        Get the shrink factor.

        Returns
        -------
        shrinkFactor : float
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategy_getShrinkFactor(self)

    def setCalibrationStep(self, calibrationStep):
        r"""
        Set the calibration step.

        Parameters
        ----------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategy_setCalibrationStep(self, calibrationStep)

    def getCalibrationStep(self):
        r"""
        Get the calibration step.

        Returns
        -------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategy_getCalibrationStep(self)

    def computeUpdateFactor(self, rho):
        r"""
        Compute the update factor.

        Parameters
        ----------
        rho : float
            Acceptance rate :math:`\rho` to take into account.

        Returns
        -------
        lambda : float
            Let :math:`\lambda` be the *calibration* coefficient to update, it gives a
            factor :math:`\phi(\rho)` such that :math:`\phi(\rho) \lambda` is the
            updated *calibration* coefficient according to the strategy. The value is
            computed as follows:

            .. math::

                \phi(\rho) = \left\{
                         \begin{array}{l}
                             \displaystyle s  \quad if \; \rho < m \\
                             \displaystyle e  \quad if \; \rho > M \\
                             \displaystyle 1  \quad otherwise
                         \end{array}
                         \right.

            with :math:`s \in ]0, 1[, e > 1` and :math:`[m,M]` the values given,
            respectively, by the methods :meth:`getShrinkFactor`,
            :meth:`getExpansionFactor` and :meth:`getRange`.

        Examples
        --------
        >>> import openturns as ot
        >>> calibration = ot.CalibrationStrategy(ot.Interval(0.1, 0.4), 1.2, 0.8)
        >>> print(calibration.computeUpdateFactor(0.09))
        0.8
        >>> print(calibration.computeUpdateFactor(0.6))
        1.2
        >>> print(calibration.computeUpdateFactor(0.18))
        1.0
        """
        return _bayesian.CalibrationStrategy_computeUpdateFactor(self, rho)

    def __str__(self):
        return _bayesian.CalibrationStrategy___str__(self)

    def __init__(self, *args):
        _bayesian.CalibrationStrategy_swiginit(self, _bayesian.new_CalibrationStrategy(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationStrategy

# Register CalibrationStrategy in _bayesian:
_bayesian.CalibrationStrategy_swigregister(CalibrationStrategy)

class GaussianLinearCalibration(CalibrationAlgorithmImplementation):
    r"""
    Gaussian linear calibration algorithm (Best Linear Unbiased Estimator or BLUE).

    Available constructors:
        GaussianLinearCalibration(*model, inputObservations, outputObservations, candidate, parameterCovariance, errorCovariance, methodName*)

        GaussianLinearCalibration(*modelObservations, gradientObservations, outputObservations, candidate, parameterCovariance, errorCovariance, methodName*)

    Parameters
    ----------
    model : :class:`~openturns.Function`
        The parametric function to be calibrated.
    inputObservations : 2-d sequence of float
        The sample of input observations.
    outputObservations : 2-d sequence of float
        The sample of output observations.
    candidate : sequence of float
        The mean of the gaussian prior distribution of the parameter.
    parameterCovariance : 2-d sequence of float
        The covariance matrix of the gaussian prior distribution of the parameter.
    errorCovariance : 2-d sequence of float
        The covariance matrix of the gaussian distribution of the observations error.
    methodName : str
        The name of the least-squares method to use for the calibration. By default, equal to *QR*. Possible values are *SVD*, *QR*, *Cholesky*.
    modelObservations : 2-d sequence of float
        The sample of output values of the model.
    gradientObservations : 2-d sequence of float
        The Jacobian matrix of the model with respect to the parameter.

    Notes
    -----
    GaussianLinearCalibration is known as the *Best Linear Unbiased Estimator* or *BLUE*. 
    It is the minimum variance estimator of the parameter of a given model under 
    the assumption that this parameter acts linearly in the model.

    The given observation error covariance can be either *local*, ie the same matrix applies for each observation and is of
    dimension the output dimension of the model, or *global*, ie the matrix describes
    the full set of observation errors, in which case its dimension is the product of
    the output dimension of the model and the number of observations.

    The prior distribution of the parameter is a :class:`~openturns.Normal`.  

    The posterior distribution of the parameter is :class:`~openturns.Normal`. 

    The resulting error distribution is :class:`~openturns.Normal` and is based on the 
    `errorCovariance` input argument. 

    See also
    --------
    LinearLeastSquaresCalibration, NonLinearLeastSquaresCalibration, GaussianNonLinearCalibration

    Examples
    --------
    Calibrate a nonlinear model using GaussianLinearCalibration:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> m = 10
    >>> x = [[0.5 + i] for i in range(m)]
    >>> inVars = ['a', 'b', 'c', 'x']
    >>> formulas = ['a + b * exp(c * x)']
    >>> model = ot.SymbolicFunction(inVars, formulas)
    >>> p_ref = [2.8, 1.2, 0.5]
    >>> params = [0, 1, 2]
    >>> modelX = ot.ParametricFunction(model, params, p_ref)
    >>> y = modelX(x)
    >>> y += ot.Normal(0.0, 0.05).getSample(m)
    >>> candidate = [1.0]*3
    >>> priorCovariance = ot.CovarianceMatrix(3)
    >>> errorCovariance = ot.CovarianceMatrix(1, [0.1])
    >>> method = 'SVD'
    >>> algo = ot.GaussianLinearCalibration(modelX, x, y, candidate, priorCovariance, errorCovariance, method)
    >>> algo.run()
    >>> print(algo.getResult().getParameterMAP())
    [8.11483,0.0770992,0.992927]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.GaussianLinearCalibration_getClassName(self)

    def __repr__(self):
        return _bayesian.GaussianLinearCalibration___repr__(self)

    def run(self):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.GaussianLinearCalibration_run(self)

    def getModelObservations(self):
        r"""
        Accessor to the model evaluation at the candidate.

        Returns
        -------
        modelObservation : :class:`~openturns.Sample`
            Evaluation of the model at the candidate point.
        """
        return _bayesian.GaussianLinearCalibration_getModelObservations(self)

    def getGradientObservations(self):
        r"""
        Accessor to the model gradient at the candidate.

        Returns
        -------
        gradientObservation : :class:`~openturns.Matrix`
            Gradient of the model at the candidate point.
        """
        return _bayesian.GaussianLinearCalibration_getGradientObservations(self)

    def getCandidate(self):
        r"""
        Accessor to the parameter candidate.

        Returns
        -------
        candidate : :class:`~openturns.Point`
            Parameter candidate.
        """
        return _bayesian.GaussianLinearCalibration_getCandidate(self)

    def getParameterCovariance(self):
        r"""
        Accessor to the parameter prior covariance.

        Returns
        -------
        prior : :class:`~openturns.CovarianceMatrix`
            Parameter prior covariance.
        """
        return _bayesian.GaussianLinearCalibration_getParameterCovariance(self)

    def getErrorCovariance(self):
        r"""
        Accessor to the observation error covariance.

        Returns
        -------
        error : :class:`~openturns.CovarianceMatrix`
            Observation error covariance.
        """
        return _bayesian.GaussianLinearCalibration_getErrorCovariance(self)

    def getGlobalErrorCovariance(self):
        r"""
        Accessor to the flag for a global observation error covariance.

        Returns
        -------
        flag : bool
            Flag telling if the given observation error covariance is global or not.
        """
        return _bayesian.GaussianLinearCalibration_getGlobalErrorCovariance(self)

    def getMethodName(self):
        r"""
        Accessor to the name of least-squares method used for the resolution.

        Returns
        -------
        name : :class:`~openturns.String`
            Name of least-squares method used for the resolution.
        """
        return _bayesian.GaussianLinearCalibration_getMethodName(self)

    def __init__(self, *args):
        _bayesian.GaussianLinearCalibration_swiginit(self, _bayesian.new_GaussianLinearCalibration(*args))
    __swig_destroy__ = _bayesian.delete_GaussianLinearCalibration

# Register GaussianLinearCalibration in _bayesian:
_bayesian.GaussianLinearCalibration_swigregister(GaussianLinearCalibration)

class LinearLeastSquaresCalibration(CalibrationAlgorithmImplementation):
    r"""
    Linear least squares calibration algorithm.

    Available constructors:
        LinearLeastSquaresCalibration(*model, inputObservations, outputObservations, candidate, methodName*)

        LinearLeastSquaresCalibration(*modelObservations, gradientObservations, outputObservations, candidate, methodName*)

    Parameters
    ----------
    model : :class:`~openturns.Function`
        The parametric function to be calibrated.
    inputObservations : 2-d sequence of float
        The sample of input observations.
    outputObservations : 2-d sequence of float
        The sample of output observations.
    candidate : sequence of float
        The reference value of the parameter.
    methodName : str
        The name of the least-squares method to use for the calibration. By default, equal to *QR*. Possible values are *SVD*, *QR*, *Cholesky*.

    Notes
    -----
    LinearLeastSquaresCalibration is the minimum variance estimator of the parameter of a given model under the assumption that this parameter acts linearly in the model.

    The prior distribution of the parameter is a :class:`~openturns.Dirac`. 

    The posterior distribution of the parameter is :class:`~openturns.Normal` and reflects the 
    variability of the optimum parameter depending on the observation sample. 
    The associated covariance matrix may be regularized depending on the value of the 
    key `LinearLeastSquaresCalibration-Regularization` in the :class:`~openturns.ResourceMap`. 
    Let us denote by :math:`s_1` the smallest singular value of the covariance matrix. 
    The default value of the `LinearLeastSquaresCalibration-Regularization`, zero, 
    ensures that the singular values of the covariance matrix are left unmodified.  
    If this parameter is set to a nonzero, relatively small, value denoted by :math:`\epsilon`, 
    then all singular values of the covariance matrix are increased by :math:`\epsilon s_1`. 

    The resulting distribution of the output error is :class:`~openturns.Normal` with a zero mean 
    and a diagonal covariance matrix computed from the residuals. 
    The residuals are computed based on the linearization of the model, 
    where the Jacobian matrix is evaluated at the candidate point. 
    The diagonal of the diagonal covariance matrix of the output error 
    is contant and is estimated with the unbiased variance estimator. 

    See also
    --------
    GaussianLinearCalibration, NonLinearLeastSquaresCalibration, GaussianNonLinearCalibration

    Examples
    --------
    Calibrate a nonlinear model using linear least-squares:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> m = 10
    >>> x = [[0.5 + i] for i in range(m)]
    >>> inVars = ['a', 'b', 'c', 'x']
    >>> formulas = ['a + b * exp(c * x)']
    >>> model = ot.SymbolicFunction(inVars, formulas)
    >>> p_ref = [2.8, 1.2, 0.5]
    >>> params = [0, 1, 2]
    >>> modelX = ot.ParametricFunction(model, params, p_ref)
    >>> y = modelX(x)
    >>> y += ot.Normal(0.0, 0.05).getSample(m)
    >>> candidate = [1.0]*3
    >>> method = 'SVD'
    >>> algo = ot.LinearLeastSquaresCalibration(modelX, x, y, candidate, method)
    >>> algo.run()
    >>> print(algo.getResult().getParameterMAP())
    [8.24019,0.0768046,0.992957]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.LinearLeastSquaresCalibration_getClassName(self)

    def __repr__(self):
        return _bayesian.LinearLeastSquaresCalibration___repr__(self)

    def run(self):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.LinearLeastSquaresCalibration_run(self)

    def getModelObservations(self):
        r"""
        Accessor to the model evaluation at the candidate.

        Returns
        -------
        modelObservation : :class:`~openturns.Sample`
            Evaluation of the model at the candidate point.
        """
        return _bayesian.LinearLeastSquaresCalibration_getModelObservations(self)

    def getGradientObservations(self):
        r"""
        Accessor to the model gradient at the candidate.

        Returns
        -------
        gradientObservation : :class:`~openturns.Matrix`
            Gradient of the model at the candidate point.
        """
        return _bayesian.LinearLeastSquaresCalibration_getGradientObservations(self)

    def getCandidate(self):
        r"""
        Accessor to the parameter candidate.

        Returns
        -------
        candidate : :class:`~openturns.Point`
            Parameter candidate.
        """
        return _bayesian.LinearLeastSquaresCalibration_getCandidate(self)

    def getMethodName(self):
        r"""
        Accessor to the name of least-squares method used for the resolution.

        Returns
        -------
        name : :class:`~openturns.String`
            Name of least-squares method used for the resolution.
        """
        return _bayesian.LinearLeastSquaresCalibration_getMethodName(self)

    def __init__(self, *args):
        _bayesian.LinearLeastSquaresCalibration_swiginit(self, _bayesian.new_LinearLeastSquaresCalibration(*args))
    __swig_destroy__ = _bayesian.delete_LinearLeastSquaresCalibration

# Register LinearLeastSquaresCalibration in _bayesian:
_bayesian.LinearLeastSquaresCalibration_swigregister(LinearLeastSquaresCalibration)

class MCMC(openturns.randomvector.RandomVectorImplementation):
    r"""
    Monte-Carlo Markov Chain.

    Available constructor:
        MCMC(*prior, conditional, observations, initialState*)

        MCMC(*prior, conditional, model, parameters, observations, initialState*)

    Parameters
    ----------
    prior : :class:`~openturns.Distribution`
        Prior distribution of the parameters of the underlying Bayesian statistical
        model.
    conditional : :class:`~openturns.Distribution`
        Required distribution to define the likelihood of the underlying Bayesian
        statistical model.
    model : :class:`~openturns.Function`
        Function required to define the likelihood.
    observations : 2-d sequence of float
        Observations required to define the likelihood.
    initialState : sequence of float
        Initial state of the Monte-Carlo Markov chain on which the Sampler is
        based.
    parameters : 2-d sequence of float
        Parameters of the model to be fixed.

    Notes
    -----
    MCMC provides a implementation of the concept of sampler, using a Monte-Carlo
    Markov Chain (MCMC) algorithm starting from *initialState*. More precisely,
    let :math:`t(.)` be the PDF of its target distribution and :math:`d_{\theta}`
    its dimension, :math:`\pi(.)` be the PDF of the *prior* distribution,
    :math:`f(.|\vect{w})` be the PDF of the *conditional* distribution
    when its parameters are set to :math:`\vect{w}`, :math:`d_w` be the number of
    scalar parameters of *conditional* distribution (which corresponds to the
    dimension of the above :math:`\vect{w}`), :math:`g(.)` be the function
    corresponding to model and :math:`(\vect{y}^1, \dots, \vect{y}^n)` be the
    sample *observations* (of size :math:`n`):

    In the first usage, it creates a sampler based on a MCMC algorithm whose target
    distribution is defined by:

    .. _PDF_target_formula:

    .. math::

        t(\vect{\theta})
        \quad \propto \quad
        \underbrace{~\pi(\vect{\theta})~}_{\mbox{prior}} \quad
        \underbrace{~\prod_{i=1}^n f(\vect{y}^i|\vect{\theta})~}_{\mbox{likelihood}}


    In the second usage, it creates a sampler based on a MCMC algorithm whose target
    distribution is defined by:

    .. _second_PDF_target_formula:

    .. math::

        t(\vect{\theta})
        \quad \propto \quad
        \underbrace{~\pi(\vect{\theta})~}_{\mbox{prior}} \quad
        \underbrace{~\prod_{i=1}^n f(\vect{y}^i|g^i(\vect{\theta}))~}_{\mbox{likelihood}}

    where the :math:`g^i: \Rset^{d_{\theta}} \rightarrow\Rset^{d_w}`
    (:math:`1\leq{}i\leq{}n`) are such that:

    .. math::

        \begin{array}{rcl}
            g:\Rset^{d_\theta} & \longrightarrow & \Rset^{n\,d_w}\\
            \vect{\theta} & \longmapsto &
            g(\vect{\theta}) = \Tr{(\Tr{g^1(\vect{\theta})}, \cdots, \Tr{g^n(\vect{\theta})})}
            \end{array}

    In fact, the first usage is a particular case of the second.


    The MCMC method implemented is the Random Walk Metropolis-Hastings
    algorithm. A sample can be generated only through the MCMC's derived class:
    :class:`~openturns.RandomWalkMetropolisHastings`.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.MCMC_getClassName(self)

    def __repr__(self):
        return _bayesian.MCMC___repr__(self)

    def computeLogLikelihood(self, currentState):
        r"""
        Compute the logarithm of the likelihood w.r.t. observations.

        Parameters
        ----------
        currentState : sequence of float
            Current state.

        Returns
        -------
        logLikelihood : float
            Logarithm of the likelihood w.r.t. observations
            :math:`(\vect{y}^1, \dots, \vect{y}^n)`.
        """
        return _bayesian.MCMC_computeLogLikelihood(self, currentState)

    def setPrior(self, prior):
        r"""
        Set the *prior* distribution.

        Parameters
        ----------
        prior : :class:`~openturns.Distribution`
            The prior distribution of the parameter of the underlying Bayesian
            statistical model, whose PDF corresponds to :math:`\pi` in the equations of
            the :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_setPrior(self, prior)

    def getPrior(self):
        r"""
        Get the *prior* distribution.

        Returns
        -------
        prior : :class:`~openturns.Distribution`
            The prior distribution of the parameter of the underlying Bayesian
            statistical model, whose PDF corresponds to :math:`\pi` in the equations of
            the :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_getPrior(self)

    def getConditional(self):
        r"""
        Get the *conditional* distribution.

        Returns
        -------
        conditional : :class:`~openturns.Distribution`
            Distribution taken into account in the definition of the likelihood, whose
            PDF with parameters :math:`\vect{w}` corresponds to :math:`f(.|\vect{w})`
            in the equations of the
            :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_getConditional(self)

    def getModel(self):
        r"""
        Get the model.

        Returns
        -------
        model : :class:`~openturns.Function`
            Model take into account in the definition of the likelihood, which
            corresponds to :math:`g`, that is the functions :math:`g^i`
            (:math:`1\leq i \leq n`) in the equation of the
            :ref:`target distribution's PDF <second_PDF_target_formula>`.
        """
        return _bayesian.MCMC_getModel(self)

    def setObservations(self, observations):
        r"""
        Set the observations.

        Parameters
        ----------
        observations : 2-d sequence of float
            Sample taken into account in the definition of the likelihood, which
            corresponds to the :math:`n`-tuple of the :math:`\vect{y}^i`
            (:math:`1\leq i \leq n`) in the equations of the
            :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_setObservations(self, observations)

    def getObservations(self):
        r"""
        Get the observations.

        Returns
        -------
        observations : :class:`~openturns.Sample`
            Sample taken into account in the definition of the likelihood, which
            corresponds to the :math:`n`-tuple of the :math:`\vect{y}^i`
            (:math:`1\leq i \leq n`) in equations of the
            :ref:`target distribution's PDF <PDF_target_formula>`.
        """
        return _bayesian.MCMC_getObservations(self)

    def setParameters(self, parameters):
        r"""
        Set the parameters.

        Parameters
        ----------
        parameters : sequence of float
            Fixed parameters of the model :math:`g` required to define the likelihood.
        """
        return _bayesian.MCMC_setParameters(self, parameters)

    def getParameters(self):
        r"""
        Get the parameters.

        Returns
        -------
        parameters : :class:`~openturns.Point`
            Fixed parameters of the model :math:`g` required to define the likelihood.
        """
        return _bayesian.MCMC_getParameters(self)

    def setBurnIn(self, burnIn):
        r"""
        Set the length of the burn-in period.

        Parameters
        ----------
        lenght : int
            Length of the burn-in period, that is the number of first iterates of the
            MCMC chain which will be thrown away when generating the sample.
        """
        return _bayesian.MCMC_setBurnIn(self, burnIn)

    def getBurnIn(self):
        r"""
        Get the length of the burn-in period.

        Returns
        -------
        lenght : int
            Length of the burn-in period, that is the number of first iterates of the
            MCMC chain which will be thrown away when generating the sample.
        """
        return _bayesian.MCMC_getBurnIn(self)

    def setThinning(self, thinning):
        r"""
        Set the thinning parameter.

        Parameters
        ----------
        thinning : int, :math:`k \geq 0`
            Thinning parameter: storing only every :math:`k^{th}` point after the
            burn-in period.

        Notes
        -----
        When generating a sample of size :math:`q`, the number of MCMC iterations
        performed is :math:`l+1+(q-1)k` where :math:`l` is the burn-in period length
        and :math:`k` the thinning parameter.
        """
        return _bayesian.MCMC_setThinning(self, thinning)

    def getThinning(self):
        r"""
        Get the thinning parameter.

        Returns
        -------
        thinning : int
            Thinning parameter: storing only every :math:`k^{th}` point after the
            burn-in period.

        Notes
        -----
        When generating a sample of size :math:`q`, the number of MCMC iterations
        performed is :math:`l+1+(q-1)k` where :math:`l` is the burn-in period length
        and :math:`k` the thinning parameter.
        """
        return _bayesian.MCMC_getThinning(self)

    def setHistory(self, strategy):
        r"""
        Set the history storage.

        Parameters
        ----------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.MCMC_setHistory(self, strategy)

    def getHistory(self):
        r"""
        Get the history storage.

        Returns
        -------
        history : :class:`~openturns.HistoryStrategy`
            Used to record the chain.
        """
        return _bayesian.MCMC_getHistory(self)

    def setNonRejectedComponents(self, nonRejectedComponents):
        r"""
        Set the components to be always accepted.

        Parameters
        ----------
        nonRejectedComponents : sequence of int 
            The indices of the components that are not tuned, and sampled according to
            the prior distribution in order to take into account the intrinsic
            uncertainty, as opposed to the epistemic uncertainty corresponding to the
            tuned variables.
        """
        return _bayesian.MCMC_setNonRejectedComponents(self, nonRejectedComponents)

    def getNonRejectedComponents(self):
        r"""
        Get the components to be always accepted.

        Returns
        -------
        nonRejectedComponents : :class:`~openturns.Indices`
            The indices of the components that are not tuned, and sampled according to
            the prior distribution in order to take into account the intrinsic
            uncertainty, as opposed to the epistemic uncertainty corresponding to the
            tuned variables.
        """
        return _bayesian.MCMC_getNonRejectedComponents(self)

    def getDimension(self):
        r"""
        Accessor to the dimension of the RandomVector.

        Returns
        -------
        dimension : positive int
            Dimension of the RandomVector.
        """
        return _bayesian.MCMC_getDimension(self)

    def setVerbose(self, verbose):
        r"""
        Set the verbose mode.

        Parameters
        ----------
        isVerbose : bool
            The verbose mode is activated if it is *True*, desactivated otherwise.
        """
        return _bayesian.MCMC_setVerbose(self, verbose)

    def getVerbose(self):
        r"""
        Tell whether the verbose mode is activated or not.

        Returns
        -------
        isVerbose : bool
            The verbose mode is activated if it is *True*, desactivated otherwise.
        """
        return _bayesian.MCMC_getVerbose(self)

    def __init__(self, *args):
        _bayesian.MCMC_swiginit(self, _bayesian.new_MCMC(*args))
    __swig_destroy__ = _bayesian.delete_MCMC

# Register MCMC in _bayesian:
_bayesian.MCMC_swigregister(MCMC)

class NonLinearLeastSquaresCalibration(CalibrationAlgorithmImplementation):
    r"""
    Non-linear least-squares calibration algorithm.

    Parameters
    ----------
    model : :class:`~openturns.Function`
        The parametric function to be calibrated.
    inputObservations : 2-d sequence of float
        The sample of input observations.
    outputObservations : 2-d sequence of float
        The sample of output observations.
    candidate : sequence of float
        The reference value of the parameter.

    Notes
    -----
    NonLinearLeastSquaresCalibration is the minimum variance estimator of the parameter of a given model with no assumption on the dependence of the model wrt the parameter.

    The prior distribution of the parameter is a :class:`~openturns.Dirac`.  

    The posterior distribution of the parameter is :class:`~openturns.Normal` and reflects the 
    variability of the optimum parameter depending on the observation sample. 
    By default, the posterior distribution is evaluated based on a linear approximation 
    of the model at the optimum. 
    This corresponds to using the :class:`~openturns.LinearLeastSquaresCalibration` at the optimum, 
    and is named *Laplace approximation* in the bayesian context. 
    However, if the key `NonLinearLeastSquaresCalibration-BootstrapSize` in the :class:`~openturns.ResourceMap` 
    is set to a nonzero positive integer, then a bootstrap resampling of the observations 
    is performed and the posterior distribution is based on a :class:`~openturns.KernelSmoothing` 
    of the sample of boostrap optimum parameters. 

    The resulting distribution of the output error is a :class:`~openturns.Normal` and is 
    computed from the residuals. 

    If least squares optimization algorithms are enabled, then the algorithm used is the
    first found by `Build` of :class:`~openturns.OptimizationAlgorithm`.
    Otherwise, the algorithm :class:`~openturns.TNC` is used combined with
    a multistart algorithm which makes use of the `NonLinearLeastSquaresCalibration-MultiStartSize`
    key in the :class:`~openturns.ResourceMap`.

    See also
    --------
    GaussianLinearCalibration, LinearLeastSquaresCalibration, GaussianNonLinearCalibration

    Examples
    --------
    Calibrate a nonlinear model using non-linear least-squares:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> m = 10
    >>> x = [[0.5 + i] for i in range(m)]
    >>> inVars = ['a', 'b', 'c', 'x']
    >>> formulas = ['a + b * exp(c * x)']
    >>> model = ot.SymbolicFunction(inVars, formulas)
    >>> p_ref = [2.8, 1.2, 0.5]
    >>> params = [0, 1, 2]
    >>> modelX = ot.ParametricFunction(model, params, p_ref)
    >>> y = modelX(x)
    >>> y += ot.Normal(0.0, 0.05).getSample(m)
    >>> candidate = [1.0]*3
    >>> algo = ot.NonLinearLeastSquaresCalibration(modelX, x, y, candidate)
    >>> algo.run()
    >>> print(algo.getResult().getParameterMAP())
    [2.773...,1.203...,0.499...]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.NonLinearLeastSquaresCalibration_getClassName(self)

    def __repr__(self):
        return _bayesian.NonLinearLeastSquaresCalibration___repr__(self)

    def run(self, *args):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_run(self, *args)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization algorithm used for the computation.

        Returns
        -------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm used for the computation.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, algorithm):
        r"""
        Accessor to the optimization algorithm used for the computation.

        Parameters
        ----------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm to use for the computation.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_setOptimizationAlgorithm(self, algorithm)

    def getCandidate(self):
        r"""
        Accessor to the parameter candidate.

        Returns
        -------
        candidate : :class:`~openturns.Point`
            Parameter candidate.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_getCandidate(self)

    def getBootstrapSize(self):
        r"""
        Accessor to the bootstrap size used to sample the posterior distribution.

        Returns
        -------
        size : int
            Bootstrap size used to sample the posterior distribution. A value of 0
            means that no bootstrap has been done but a linear approximation has
            been used to get the posterior distribution, using the :class:`~openturns.GaussianLinearCalibration`
            algorithm at the maximum a posteriori estimate.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Accessor to the bootstrap size used to sample the posterior distribution.

        Parameters
        ----------
        size : int
            Bootstrap size used to sample the posterior distribution. A value of 0
            means that no bootstrap has to be done but a linear approximation has
            been used to get the posterior distribution, using the :class:`~openturns.GaussianLinearCalibration`
            algorithm at the maximum a posteriori estimate.
        """
        return _bayesian.NonLinearLeastSquaresCalibration_setBootstrapSize(self, bootstrapSize)

    @staticmethod
    def BuildResidualFunction(model, inputObservations, outputObservations):
        r"""
        Build a residual function given a parametric model, input and output observations.

        Parameters
        ----------
        model : :class:`~openturns.Function`
            Parametric model.
        inputObservations : 2-d sequence of float
            Input observations associated to the output observations.
        outputObservations : :class:`~openturns.Function`
            Output observations.

        Returns
        -------
        residual : :class:`~openturns.Function`
        Residual function.

        Notes
        -----
        Given a parametric model :math:`F_{\theta}:\Rset^n\rightarrow\Rset^p` with
        parameter :math:`\theta\in\Rset^m`, a sample of input points
        :math:`(x_i)_{i=1,\dots,N}` and the associated output
        :math:`(y_i)_{i=1,\dots,N}`, the residual function :math:`f` is defined by:

        .. math::

            \forall \theta\in\Rset^m, f(\theta)=\left(\begin{array}{c}
            F_{\theta}(x_1)-y_1 \\
            \vdots \\
            F_{\theta}(x_N)-y_N
            \end{array}
            \right)


        """
        return _bayesian.NonLinearLeastSquaresCalibration_BuildResidualFunction(model, inputObservations, outputObservations)

    def __init__(self, *args):
        _bayesian.NonLinearLeastSquaresCalibration_swiginit(self, _bayesian.new_NonLinearLeastSquaresCalibration(*args))
    __swig_destroy__ = _bayesian.delete_NonLinearLeastSquaresCalibration

# Register NonLinearLeastSquaresCalibration in _bayesian:
_bayesian.NonLinearLeastSquaresCalibration_swigregister(NonLinearLeastSquaresCalibration)

def NonLinearLeastSquaresCalibration_BuildResidualFunction(model, inputObservations, outputObservations):
    r"""
    Build a residual function given a parametric model, input and output observations.

    Parameters
    ----------
    model : :class:`~openturns.Function`
        Parametric model.
    inputObservations : 2-d sequence of float
        Input observations associated to the output observations.
    outputObservations : :class:`~openturns.Function`
        Output observations.

    Returns
    -------
    residual : :class:`~openturns.Function`
    Residual function.

    Notes
    -----
    Given a parametric model :math:`F_{\theta}:\Rset^n\rightarrow\Rset^p` with
    parameter :math:`\theta\in\Rset^m`, a sample of input points
    :math:`(x_i)_{i=1,\dots,N}` and the associated output
    :math:`(y_i)_{i=1,\dots,N}`, the residual function :math:`f` is defined by:

    .. math::

        \forall \theta\in\Rset^m, f(\theta)=\left(\begin{array}{c}
        F_{\theta}(x_1)-y_1 \\
        \vdots \\
        F_{\theta}(x_N)-y_N
        \end{array}
        \right)


    """
    return _bayesian.NonLinearLeastSquaresCalibration_BuildResidualFunction(model, inputObservations, outputObservations)

class GaussianNonLinearCalibration(CalibrationAlgorithmImplementation):
    r"""
    Gaussian non linear calibration algorithm (3DVAR).

    Parameters
    ----------
    model : :class:`~openturns.Function`
        The parametric function to be calibrated.
    inputObservations : 2-d sequence of float
        The sample of input observations.
    outputObservations : 2-d sequence of float
        The sample of output observations.
    candidate : sequence of float
        The mean of the gaussian prior distribution of the parameter.
    parameterCovariance : 2-d sequence of float
        The covariance matrix of the gaussian prior distribution of the parameter.
    errorCovariance : 2-d sequence of float
        The covariance matrix of the gaussian distribution of the observations error.

    Notes
    -----
    GaussianNonLinearCalibration is the minimum variance estimator of the parameter of a given model
    under the assumption that this parameter is dispersed according to a known
    covariance matrix. 
    This algorithm is also known as *3DVAR*. 

    The given observation error covariance can be either *local*,
    ie the same matrix applies for each observation and is of dimension the output
    dimension of the model, or *global*, ie the matrix describes the full set of
    observation errors, in which case its dimension is the product of the output
    dimension of the model and the number of observations.

    The prior distribution of the parameter is a :class:`~openturns.Normal`.  

    The posterior distribution of the parameter is :class:`~openturns.Normal`. 
    By default, the posterior distribution is evaluated based on a linear approximation 
    of the model at the optimum. 
    This corresponds to using the :class:`~openturns.GaussianLinearCalibration` at the optimum,
    and is named *Laplace approximation* in the bayesian context. 
    However, if the key `GaussianNonLinearCalibration-BootstrapSize` in the :class:`~openturns.ResourceMap` 
    is set to a nonzero positive integer, then a bootstrap resampling of the observations 
    is performed and the posterior distribution is based on a :class:`~openturns.KernelSmoothing` 
    of the sample of boostrap optimum parameters. 

    The resulting error distribution is :class:`~openturns.Normal` and is based on the 
    `errorCovariance` input argument. 

    See also
    --------
    GaussianLinearCalibration, LinearLeastSquaresCalibration, NonLinearLeastSquaresCalibration

    Examples
    --------
    Calibrate a nonlinear model using 3DVAR:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> m = 10
    >>> x = [[0.5 + i] for i in range(m)]
    >>> inVars = ['a', 'b', 'c', 'x']
    >>> formulas = ['a + b * exp(c * x)']
    >>> model = ot.SymbolicFunction(inVars, formulas)
    >>> p_ref = [2.8, 1.2, 0.5]
    >>> params = [0, 1, 2]
    >>> modelX = ot.ParametricFunction(model, params, p_ref)
    >>> y = modelX(x)
    >>> y += ot.Normal(0.0, 0.05).getSample(m)
    >>> candidate = [1.0]*3
    >>> priorCovariance = ot.CovarianceMatrix(3)
    >>> errorCovariance = ot.CovarianceMatrix(1, [0.1])
    >>> algo = ot.GaussianNonLinearCalibration(modelX, x, y, candidate, priorCovariance, errorCovariance)
    >>> algo.run()
    >>> print(algo.getResult().getParameterMAP())
    [2.705...,1.212...,0.499...]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.GaussianNonLinearCalibration_getClassName(self)

    def __repr__(self):
        return _bayesian.GaussianNonLinearCalibration___repr__(self)

    def run(self, *args):
        r"""
        Launch the algorithm.

        Notes
        -----
        It launches the algorithm and creates a :class:`~openturns.CalibrationResult`,
        structure containing all the results.
        """
        return _bayesian.GaussianNonLinearCalibration_run(self, *args)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization algorithm used for the computation.

        Returns
        -------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm used for the computation.
        """
        return _bayesian.GaussianNonLinearCalibration_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, algorithm):
        r"""
        Accessor to the optimization algorithm used for the computation.

        Parameters
        ----------
        algo : :class:`~openturns.OptimizationAlgorithm`
            Optimization algorithm to use for the computation.
        """
        return _bayesian.GaussianNonLinearCalibration_setOptimizationAlgorithm(self, algorithm)

    def getCandidate(self):
        r"""
        Accessor to the parameter candidate.

        Returns
        -------
        candidate : :class:`~openturns.Point`
            Parameter candidate.
        """
        return _bayesian.GaussianNonLinearCalibration_getCandidate(self)

    def getParameterCovariance(self):
        r"""
        Accessor to the parameter prior covariance.

        Returns
        -------
        prior : :class:`~openturns.CovarianceMatrix`
            Parameter prior covariance.
        """
        return _bayesian.GaussianNonLinearCalibration_getParameterCovariance(self)

    def getErrorCovariance(self):
        r"""
        Accessor to the observation error covariance.

        Returns
        -------
        error : :class:`~openturns.CovarianceMatrix`
            Observation error covariance.
        """
        return _bayesian.GaussianNonLinearCalibration_getErrorCovariance(self)

    def getGlobalErrorCovariance(self):
        r"""
        Accessor to the flag for a global observation error covariance.

        Returns
        -------
        flag : bool
            Flag telling if the given observation error covariance is global or not.
        """
        return _bayesian.GaussianNonLinearCalibration_getGlobalErrorCovariance(self)

    def getBootstrapSize(self):
        r"""
        Accessor to the bootstrap size used to sample the posterior distribution.

        Returns
        -------
        size : int
            Bootstrap size used to sample the posterior distribution. A value of 0
            means that no bootstrap has been done but a linear approximation has
            been used to get the posterior distribution, using the :class:`~openturns.GaussianLinearCalibration`
            algorithm at the maximum a posteriori estimate.
        """
        return _bayesian.GaussianNonLinearCalibration_getBootstrapSize(self)

    def setBootstrapSize(self, bootstrapSize):
        r"""
        Accessor to the bootstrap size used to sample the posterior distribution.

        Parameters
        ----------
        size : int
            Bootstrap size used to sample the posterior distribution. A value of 0
            means that no bootstrap has to be done but a linear approximation has
            been used to get the posterior distribution, using the :class:`~openturns.GaussianLinearCalibration`
            algorithm at the maximum a posteriori estimate.
        """
        return _bayesian.GaussianNonLinearCalibration_setBootstrapSize(self, bootstrapSize)

    def __init__(self, *args):
        _bayesian.GaussianNonLinearCalibration_swiginit(self, _bayesian.new_GaussianNonLinearCalibration(*args))
    __swig_destroy__ = _bayesian.delete_GaussianNonLinearCalibration

# Register GaussianNonLinearCalibration in _bayesian:
_bayesian.GaussianNonLinearCalibration_swigregister(GaussianNonLinearCalibration)

class RandomWalkMetropolisHastings(MCMC):
    r"""
    Random Walk Metropolis-Hastings method.

    Refer to :ref:`bayesian_calibration`, :ref:`metropolis_hastings`.

    Available constructor:
        RandomWalkMetropolisHastings(*prior, conditional, observations, initialState, proposal*)

        RandomWalkMetropolisHastings(*prior, conditional, model, modelParameters, observations, initialState, proposal*)

    Parameters
    ----------
    prior : :class:`~openturns.Distribution`
        Prior distribution of the parameters of the underlying Bayesian statistical
        model.
    conditional : :class:`~openturns.Distribution`
        Required distribution to define the likelihood of the underlying Bayesian
        statistical model.
    model : :class:`~openturns.Function`
        Function required to define the likelihood. 
        The dimension of the output of the `model` argument must be equal 
        to the dimension of the `setParameter` method of the `conditional` argument. 
    observations : 2-d sequence of float
        Observations required to define the likelihood. 
        If a `model` argument is specified, the `observations` correspond 
        to the output of the `model`.
    initialState : sequence of float
        Initial state of the Monte-Carlo Markov chain on which the Sampler is
        based.
        The dimension of the `initialState` must be equal to the dimension of the `prior`. 
    modelParameters : 2-d sequence of float
        Parameters of the model to be fixed. 
        The dimension of the `modelParameters` argument must 
        be equal to the dimension of the `setParameter` method of the `model` argument. 
        The size of the `modelParameters` variable must 
        be equal to the size of the `observations` argument. 
    proposal : list of :class:`~openturns.Distribution`
        Distributions from which the transition kernels of the
        :class:`~openturns.MCMC` are defined, as explained hereafter. In the
        following of this paragraph, :math:`\delta \sim p_j` means that the
        realization :math:`\delta` is obtained according to the :math:`j^{th}`
        Distribution of the list *proposal* of size :math:`d`. The underlying
        MCMC algorithm is a Metropolis-Hastings one which draws candidates (for the
        next state of the chain) using a random walk: from the current state
        :math:`\vect{\theta}^k`, the candidate :math:`\vect{c}^k` for
        :math:`\vect{\theta}^{k+1}` can be expressed as
        :math:`\vect{c}^k = \vect{\theta}^k +\vect{\delta}^k` where the
        distribution of :math:`\vect{\delta}^k` does not depend on
        :math:`\vect{\theta}^k`. More precisely, here, during the :math:`k^{th}`
        Metropolis-Hastings iteration, only the :math:`j^{th}` component
        :math:`\delta_j^k` of :math:`\vect{\delta}^k` , with :math:`j=k \mod d`, is
        not zero and :math:`\delta_j^k = \lambda_j^k \delta^k` where
        :math:`\lambda_j^k` is a deterministic scalar *calibration* coefficient and
        where :math:`\delta^k \sim p_j`. Moreover, :math:`\lambda_j^k = 1` by default,
        but adaptive strategy based on the acceptance rate of each component can be
        defined using the method :meth:`setCalibrationStrategyPerComponent`.

    Notes
    -----
    A RandomWalkMetropolisHastings enables to carry out :class:`~openturns.MCMC`
    sampling according to the preceding statements. It is important to note that
    sampling one new realization comes to carrying out :math:`d` Metropolis-
    Hastings iterations (such as described above): all of the components of the new
    realization can differ from the corresponding components of the previous
    realization. Besides, the burn-in and thinning parameters do not take into
    consideration the number of MCMC iterations indeed, but the number of sampled
    realizations.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> chainDim = 3
    >>> # Observations
    >>> obsDim = 1
    >>> obsSize = 10
    >>> y = [-9.50794871493506, -3.83296694500105, -2.44545713047953,
    ...      0.0803625289211318, 1.01898069723583, 0.661725805623086,
    ...      -1.57581204592385, -2.95308465670895, -8.8878164296758,
    ...      -13.0812290405651]
    >>> y_obs = ot.Sample(y, obsDim)
    >>> # Parameters
    >>> modelParameters = ot.Sample(obsSize, chainDim)
    >>> for i in range(obsSize):
    ...     for j in range(chainDim):
    ...         modelParameters[i, j] = (-2 + 5.0 * i / 9.0) ** j
    >>> # Model
    >>> fullModel = ot.SymbolicFunction(
    ...          ['p1', 'p2', 'p3', 'x1', 'x2', 'x3'],
    ...          ['p1*x1+p2*x2+p3*x3', '1.0'])
    >>> parametersSet = range(chainDim)
    >>> parametersValue = [0.0] * len(parametersSet)
    >>> model = ot.ParametricFunction(fullModel, parametersSet, parametersValue)
    >>> # Calibration parameters
    >>> calibrationColl = [ot.CalibrationStrategy()]*chainDim
    >>> # Proposal distribution
    >>> proposalColl = [ot.Uniform(-1.0, 1.0)]*chainDim
    >>> # Prior distribution
    >>> sigma0 = [10.0]*chainDim
    >>> #  Covariance matrix
    >>> Q0_inv = ot.CorrelationMatrix(chainDim)
    >>> for i in range(chainDim): 
    ...     Q0_inv[i, i] = sigma0[i] * sigma0[i]
    >>> mu0 = [0.0]*chainDim
    >>> #  x0 ~ N(mu0, sigma0)
    >>> prior = ot.Normal(mu0, Q0_inv)
    >>> # Conditional distribution y~N(z, 1.0)
    >>> conditional = ot.Normal()
    >>> # Create a metropolis-hastings sampler
    >>> sampler = ot.RandomWalkMetropolisHastings(
    ...     prior, conditional, model, modelParameters, y_obs, mu0, proposalColl)
    >>> sampler.setCalibrationStrategyPerComponent(calibrationColl)
    >>> sampler.setBurnIn(200)
    >>> sampler.setThinning(10)
    >>> # Get a realization
    >>> print(sampler.getRealization())
    [1.22816,1.0049,-1.99008]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.RandomWalkMetropolisHastings_getClassName(self)

    def __repr__(self):
        return _bayesian.RandomWalkMetropolisHastings___repr__(self)

    def getRealization(self):
        r"""
        Compute one realization of the RandomVector.

        Returns
        -------
        aRealization : :class:`~openturns.Point`
            Sequence of values randomly determined from the RandomVector definition.
            In the case of an event: one realization of the event (considered as a
            Bernoulli variable) which is a boolean value (1 for the realization of the
            event and 0 else).

        See also
        --------
        getSample

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Normal([0.0, 0.0], [1.0, 1.0], ot.CorrelationMatrix(2))
        >>> randomVector = ot.RandomVector(distribution)
        >>> ot.RandomGenerator.SetSeed(0)
        >>> print(randomVector.getRealization())
        [0.608202,-1.26617]
        >>> print(randomVector.getRealization())
        [-0.438266,1.20548]
        """
        return _bayesian.RandomWalkMetropolisHastings_getRealization(self)

    def setCalibrationStrategy(self, calibrationStrategy):
        r"""
        Set the calibration strategy.

        Parameters
        ----------
        strategy : :class:`~openturns.CalibrationStrategy`
            Same strategy applied for each component :math:`\lambda_j^k`.

        See also
        --------
        setCalibrationStrategyPerComponent
        """
        return _bayesian.RandomWalkMetropolisHastings_setCalibrationStrategy(self, calibrationStrategy)

    def setCalibrationStrategyPerComponent(self, calibrationStrategy):
        r"""
        Set the calibration strategy per component.

        Parameters
        ----------
        strategy : list of :class:`~openturns.CalibrationStrategy`
            A list of CalibrationStrategy *strategy*, whose :math:`j^{th}` component
            :math:`strategy[j]` defines whether and how the :math:`\lambda_j^k` (see the
            paragraph dedicated to the constructors of the class above) are rescaled,
            on the basis of the last :math:`j^{th}` component acceptance rate
            :math:`\rho_j^k` . The *calibration* coefficients are rescaled every
            :math:`q\times d` MCMC iterations with
            :math:`q = strategy[j].getCalibrationStep()`, thus on the basis of the
            acceptances or refusals of the last :math:`q` candidates obtained by only
            changing the :math:`j^{th}` component of the current state:
            :math:`\lambda_j^k = \Phi_j (\rho_j^k)\lambda_j^{k-qd}` where
            :math:`\Phi_j(.)` is defined by :math:`strategy[j].computeUpdateFactor()`.
        """
        return _bayesian.RandomWalkMetropolisHastings_setCalibrationStrategyPerComponent(self, calibrationStrategy)

    def getCalibrationStrategyPerComponent(self):
        r"""
        Get the calibration strategy per component.

        Returns
        -------
        strategy : list of :class:`~openturns.CalibrationStrategy`
            A list of CalibrationStrategy *strategy*, whose :math:`j^{th}` component
            :math:`strategy[j]` defines whether and how the :math:`\lambda_j^k` (see the
            paragraph dedicated to the constructors of the class above) are rescaled,
            on the basis of the last :math:`j^{th}` component acceptance rate
            :math:`\rho_j^k` . The *calibration* coefficients are rescaled every
            :math:`q\times d` MCMC iterations with
            :math:`q = strategy[j].getCalibrationStep()`, thus on the basis of the
            acceptances or refusals of the last :math:`q` candidates obtained by only
            changing the :math:`j^{th}` component of the current state:
            :math:`\lambda_j^k = \Phi_j (\rho_j^k)\lambda_j^{k-qd}` where
            :math:`\Phi_j(.)` is defined by :math:`strategy[j].computeUpdateFactor()`.
        """
        return _bayesian.RandomWalkMetropolisHastings_getCalibrationStrategyPerComponent(self)

    def setProposal(self, proposal):
        r"""
        Set the proposal.

        Parameters
        ----------
        proposal : list of :class:`~openturns.Distribution`
            The :math:`d`-tuple of Distributions :math:`p_j (1 \leq j \leq d)` from
            which the transition kernels of the random walk Metropolis-Hastings
            algorithm are defined; look at the paragraph dedicated to the constructors
            of the class above.
        """
        return _bayesian.RandomWalkMetropolisHastings_setProposal(self, proposal)

    def getProposal(self):
        r"""
        Get the proposal.

        Returns
        -------
        proposal : list of :class:`~openturns.Distribution`
            The :math:`d`-tuple of Distributions :math:`p_j (1 \leq j \leq d)` from
            which the transition kernels of the random walk Metropolis-Hastings
            algorithm are defined; look at the paragraph dedicated to the constructors
            of the class above.
        """
        return _bayesian.RandomWalkMetropolisHastings_getProposal(self)

    def getAcceptanceRate(self):
        r"""
        Get acceptance rate.

        Returns
        -------
        acceptanceRate : :class:`~openturns.Point` of dimension :math:`d`
            Sequence whose the :math:`j^{th}` component corresponds to the acceptance
            rate of the candidates :math:`\vect{c}^k` obtained from a state
            :math:`\vect{\theta}^k` by only changing its :math:`j^{th}` component, that
            is to the acceptance rate only relative to the :math:`k^{th}` MCMC
            iterations such that :math:`k \mod d=j` (see the paragraph dedicated to the
            constructors of the class above). These are global acceptance rates over
            all the MCMC iterations performed.
        """
        return _bayesian.RandomWalkMetropolisHastings_getAcceptanceRate(self)

    def __init__(self, *args):
        _bayesian.RandomWalkMetropolisHastings_swiginit(self, _bayesian.new_RandomWalkMetropolisHastings(*args))
    __swig_destroy__ = _bayesian.delete_RandomWalkMetropolisHastings

# Register RandomWalkMetropolisHastings in _bayesian:
_bayesian.RandomWalkMetropolisHastings_swigregister(RandomWalkMetropolisHastings)

class CalibrationStrategyImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_bayesian.CalibrationStrategyImplementationPointer_ptr__get, _bayesian.CalibrationStrategyImplementationPointer_ptr__set)

    def __init__(self, *args):
        _bayesian.CalibrationStrategyImplementationPointer_swiginit(self, _bayesian.new_CalibrationStrategyImplementationPointer(*args))
    __swig_destroy__ = _bayesian.delete_CalibrationStrategyImplementationPointer

    def reset(self):
        return _bayesian.CalibrationStrategyImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _bayesian.CalibrationStrategyImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _bayesian.CalibrationStrategyImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _bayesian.CalibrationStrategyImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _bayesian.CalibrationStrategyImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _bayesian.CalibrationStrategyImplementationPointer_get(self)

    def getImplementation(self):
        return _bayesian.CalibrationStrategyImplementationPointer_getImplementation(self)

    def unique(self):
        return _bayesian.CalibrationStrategyImplementationPointer_unique(self)

    def use_count(self):
        return _bayesian.CalibrationStrategyImplementationPointer_use_count(self)

    def swap(self, other):
        return _bayesian.CalibrationStrategyImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getClassName(self)

    def __repr__(self):
        return _bayesian.CalibrationStrategyImplementationPointer___repr__(self)

    def setRange(self, range):
        r"""
        Set the range.

        Parameters
        ----------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setRange(self, range)

    def getRange(self):
        r"""
        Get the range.

        Returns
        -------
        range : :class:`~openturns.Interval` of dimension 1
            Range :math:`[m,M]` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getRange(self)

    def setExpansionFactor(self, expansionFactor):
        r"""
        Set the expansion factor.

        Parameters
        ----------
        expansionFactor : float, :math:`e > 1`
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setExpansionFactor(self, expansionFactor)

    def getExpansionFactor(self):
        r"""
        Get the expansion factor.

        Returns
        -------
        expansionFactor : float
            Expansion factor :math:`e`. See the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getExpansionFactor(self)

    def setShrinkFactor(self, shrinkFactor):
        r"""
        Set the shrink factor.

        Parameters
        ----------
        shrinkFactor : float, :math:`0 < s < 1`
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setShrinkFactor(self, shrinkFactor)

    def getShrinkFactor(self):
        r"""
        Get the shrink factor.

        Returns
        -------
        shrinkFactor : float
            Shrink factor :math:`s` in the description of the method
            :meth:`computeUpdateFactor`.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getShrinkFactor(self)

    def setCalibrationStep(self, calibrationStep):
        r"""
        Set the calibration step.

        Parameters
        ----------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setCalibrationStep(self, calibrationStep)

    def getCalibrationStep(self):
        r"""
        Get the calibration step.

        Returns
        -------
        step : positive int
            Calibration step corresponding for example to :math:`q` in the description
            of the method
            :meth:`~openturns.RandomWalkMetropolisHastings.getCalibrationStrategyPerComponent`
            of the RandomWalkMetropolisHastings class.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getCalibrationStep(self)

    def computeUpdateFactor(self, rho):
        r"""
        Compute the update factor.

        Parameters
        ----------
        rho : float
            Acceptance rate :math:`\rho` to take into account.

        Returns
        -------
        lambda : float
            Let :math:`\lambda` be the *calibration* coefficient to update, it gives a
            factor :math:`\phi(\rho)` such that :math:`\phi(\rho) \lambda` is the
            updated *calibration* coefficient according to the strategy. The value is
            computed as follows:

            .. math::

                \phi(\rho) = \left\{
                         \begin{array}{l}
                             \displaystyle s  \quad if \; \rho < m \\
                             \displaystyle e  \quad if \; \rho > M \\
                             \displaystyle 1  \quad otherwise
                         \end{array}
                         \right.

            with :math:`s \in ]0, 1[, e > 1` and :math:`[m,M]` the values given,
            respectively, by the methods :meth:`getShrinkFactor`,
            :meth:`getExpansionFactor` and :meth:`getRange`.

        Examples
        --------
        >>> import openturns as ot
        >>> calibration = ot.CalibrationStrategy(ot.Interval(0.1, 0.4), 1.2, 0.8)
        >>> print(calibration.computeUpdateFactor(0.09))
        0.8
        >>> print(calibration.computeUpdateFactor(0.6))
        1.2
        >>> print(calibration.computeUpdateFactor(0.18))
        1.0
        """
        return _bayesian.CalibrationStrategyImplementationPointer_computeUpdateFactor(self, rho)

    def __eq__(self, arg2):
        return _bayesian.CalibrationStrategyImplementationPointer___eq__(self, arg2)

    def __ne__(self, other):
        return _bayesian.CalibrationStrategyImplementationPointer___ne__(self, other)

    def __str__(self, *args):
        return _bayesian.CalibrationStrategyImplementationPointer___str__(self, *args)

    def getId(self):
        r"""
        Accessor to the object's id.

        Returns
        -------
        id : int
           Internal unique identifier.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getId(self)

    def setShadowedId(self, id):
        r"""
        Accessor to the object's shadowed id.

        Parameters
        ----------
        id : int
            Internal unique identifier.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setShadowedId(self, id)

    def getShadowedId(self):
        r"""
        Accessor to the object's shadowed id.

        Returns
        -------
        id : int
            Internal unique identifier.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getShadowedId(self)

    def setVisibility(self, visible):
        r"""
        Accessor to the object's visibility state.

        Parameters
        ----------
        visible : bool
            Visibility flag.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setVisibility(self, visible)

    def getVisibility(self):
        r"""
        Accessor to the object's visibility state.

        Returns
        -------
        visible : bool
            Visibility flag.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getVisibility(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_hasName(self)

    def hasVisibleName(self):
        r"""
        Test if the object has a distinguishable name.

        Returns
        -------
        hasVisibleName : bool
            True if the name is not empty and not the default one.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_hasVisibleName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _bayesian.CalibrationStrategyImplementationPointer_setName(self, name)

# Register CalibrationStrategyImplementationPointer in _bayesian:
_bayesian.CalibrationStrategyImplementationPointer_swigregister(CalibrationStrategyImplementationPointer)



