/*
 * Decompiled with CFR 0.152.
 */
package tdb2.cmdline;

import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import tdb2.cmdline.CmdTDB;

public abstract class CmdTDBGraph
extends CmdTDB {
    private static final ArgDecl argNamedGraph = new ArgDecl(true, "graph");
    protected String graphName = null;

    protected CmdTDBGraph(String[] argv) {
        super(argv);
        super.add(argNamedGraph, "--graph=IRI", "Act on a named graph");
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(argNamedGraph)) {
            this.graphName = this.getValue(argNamedGraph);
        }
    }

    protected Model getModel() {
        Dataset ds = this.getDataset();
        if (this.graphName != null) {
            Model m = ds.getNamedModel(this.graphName);
            if (m == null) {
                throw new CmdException("No such named graph (is this a TDB dataset?)");
            }
            return m;
        }
        return ds.getDefaultModel();
    }

    public Node getGraphName() {
        return this.graphName == null ? null : NodeFactory.createURI((String)this.graphName);
    }

    protected Graph getGraph() {
        if (this.graphName != null) {
            return this.getDataset().getNamedModel(this.graphName).getGraph();
        }
        return this.getDataset().getDefaultModel().getGraph();
    }

    @Override
    protected String getCommandName() {
        return Lib.className((Object)this);
    }
}

