/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmdline.CmdARQ;
import org.apache.jena.Jena;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.setup.DatasetBuilderStd;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.sys.TDBInternal;
import tdb.cmdline.ModTDBDataset;

public abstract class CmdTDB
extends CmdARQ {
    protected final ModTDBDataset tdbDatasetAssembler = new ModTDBDataset();
    private static boolean initialized = false;

    protected CmdTDB(String[] argv) {
        super(argv);
        CmdTDB.init();
        super.addModule(this.tdbDatasetAssembler);
        this.modVersion.addClass(Jena.class);
        this.modVersion.addClass(ARQ.class);
        this.modVersion.addClass(TDB.class);
    }

    public static synchronized void init() {
        JenaSystem.init();
        if (initialized) {
            return;
        }
        initialized = true;
        DatasetBuilderStd.setOptimizerWarningFlag((boolean)false);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    protected Location getLocation() {
        return this.tdbDatasetAssembler.getLocation();
    }

    protected DatasetGraph getDatasetGraph() {
        return this.getDataset().asDatasetGraph();
    }

    protected DatasetGraphTDB getDatasetGraphTDB() {
        DatasetGraph dsg = this.getDatasetGraph();
        return TDBInternal.getBaseDatasetGraphTDB((DatasetGraph)dsg);
    }

    protected Dataset getDataset() {
        return this.tdbDatasetAssembler.getDataset();
    }

    @Override
    protected String getCommandName() {
        return Lib.className((Object)this);
    }
}

