/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokens;

import com.metaweb.lessen.tokens.OneTokenColor;
import com.metaweb.lessen.tokens.Token;

public abstract class Color
extends Token {
    protected Color(int start, int end, String text) {
        super(Token.Type.Color, start, end, text);
    }

    public abstract int getR();

    public abstract int getG();

    public abstract int getB();

    public abstract int getA();

    public Color performOperation(String op, Color color) {
        int mult = op.equals("+") ? 1 : -1;
        StringBuffer sb = new StringBuffer();
        sb.append('#');
        int r = this.limitComponent(this.getR() + mult * color.getR());
        sb.append(this.numberToHex(r));
        int g = this.limitComponent(this.getG() + mult * color.getG());
        sb.append(this.numberToHex(g));
        int b = this.limitComponent(this.getB() + mult * color.getB());
        sb.append(this.numberToHex(b));
        int a = -1;
        if (this.getA() >= 0) {
            a = color.getA() >= 0 ? this.limitComponent(this.getA() + mult * color.getA()) : this.getA();
            sb.append(this.numberToHex(a));
        } else if (color.getA() >= 0 && mult > 0) {
            a = color.getA();
            sb.append(this.numberToHex(a));
        }
        return new OneTokenColor(this.start, this.end, sb.toString(), r, g, b, a);
    }

    public Color performOperation(String op, Number n) {
        double mult = op.equals("*") ? n.doubleValue() : 1.0 / n.doubleValue();
        StringBuffer sb = new StringBuffer();
        sb.append('#');
        int r = this.limitComponent((int)((double)this.getR() * mult));
        sb.append(this.numberToHex(r));
        int g = this.limitComponent((int)((double)this.getG() * mult));
        sb.append(this.numberToHex(g));
        int b = this.limitComponent((int)((double)this.getB() * mult));
        sb.append(this.numberToHex(b));
        int a = -1;
        if (this.getA() >= 0) {
            a = this.limitComponent((int)((double)this.getA() * mult));
            sb.append(this.numberToHex(a));
        }
        return new OneTokenColor(this.start, this.end, sb.toString(), r, g, b, a);
    }

    protected String numberToHex(int n) {
        String s = Integer.toHexString(n);
        return s.length() > 1 ? s : "0" + s;
    }

    protected int limitComponent(int n) {
        return Math.max(0, Math.min(255, n));
    }
}

