/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokenizers;

import com.metaweb.lessen.tokenizers.BufferedTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.Token;
import java.util.LinkedList;
import java.util.List;

public class IndentingTokenizer
implements Tokenizer {
    protected final BufferedTokenizer _tokenizer;
    protected final String _indent;
    protected final List<Token> _tokens = new LinkedList<Token>();
    protected final List<String> _indents = new LinkedList<String>();

    public IndentingTokenizer(Tokenizer tokenizer) {
        this(tokenizer, "  ");
    }

    public IndentingTokenizer(Tokenizer tokenizer, String indent) {
        this._tokenizer = new BufferedTokenizer(tokenizer);
        this._indent = indent;
        this._indents.add("");
        this.getMore();
    }

    public Token getToken() {
        return this._tokens.size() == 0 ? null : this._tokens.get(0);
    }

    public void next() {
        if (this._tokens.size() > 0) {
            this._tokens.remove(0);
        }
        if (this._tokens.size() == 0) {
            this.getMore();
        }
    }

    protected void getMore() {
        Token t;
        while ((t = this._tokenizer.getToken()) != null) {
            if (t.type == Token.Type.Comment || t.type == Token.Type.CDataOpen || t.type == Token.Type.CDataClose) {
                this._tokenizer.next();
                this._tokens.add(t);
                continue;
            }
            if (t.type == Token.Type.Whitespace) {
                Token t2;
                this._tokenizer.next();
                while ((t2 = this._tokenizer.getToken()) != null && t2.type == Token.Type.Whitespace) {
                    this._tokenizer.next();
                }
                this._tokens.add(new Token(Token.Type.Whitespace, t.start, t.end, "\n"));
                continue;
            }
            this.processStatement(0);
            break;
        }
    }

    protected void processStatement(int level) {
        Token t;
        boolean wroteNewLine = false;
        while ((t = this._tokenizer.getToken()) != null) {
            if (t.type == Token.Type.Delimiter) {
                if (t.text.equals(";")) {
                    this._tokenizer.next();
                    this._tokens.add(t);
                    this.processTrailingComments();
                    break;
                }
                if (t.text.equals("}")) break;
                if (t.text.equals("{")) {
                    this._tokenizer.next();
                    this._tokens.add(t);
                    this.processBlock(level + 1);
                    t = this._tokenizer.getToken();
                    if (t != null && t.type == Token.Type.Delimiter && t.text.equals("}")) {
                        this._tokenizer.next();
                        this.breakLine(t);
                        this.indent(t, level);
                        this._tokens.add(t);
                    }
                    this.processTrailingComments();
                    break;
                }
            }
            this._tokenizer.next();
            if (!wroteNewLine) {
                if (t.type == Token.Type.Whitespace) continue;
                this.breakLine(t);
                this.indent(t, level);
                wroteNewLine = true;
            }
            if (t.type == Token.Type.Whitespace) {
                String text = t.text;
                if (text.indexOf(10) >= 0) {
                    this.breakLine(t);
                    this.indent(t, level);
                    continue;
                }
                this._tokens.add(new Token(Token.Type.Whitespace, t.start, t.start, " "));
                continue;
            }
            this._tokens.add(t);
        }
    }

    protected void processBlock(int level) {
        Token t;
        while ((t = this._tokenizer.getToken()) != null) {
            this.processStatement(level);
            t = this._tokenizer.getToken();
            if (t == null || t.type != Token.Type.Delimiter || !t.text.equals("}")) continue;
            break;
        }
    }

    protected void processTrailingComments() {
        Token t;
        boolean hasSpace = false;
        while ((t = this._tokenizer.getToken()) != null) {
            if (t.type == Token.Type.Whitespace) {
                if (t.text.indexOf(10) >= 0) {
                    return;
                }
                this._tokenizer.next();
                hasSpace = true;
                continue;
            }
            if (t.type != Token.Type.Comment) break;
            if (hasSpace) {
                this._tokens.add(new Token(Token.Type.Whitespace, t.start, t.start, " "));
                hasSpace = false;
            }
            this._tokenizer.next();
            this._tokens.add(t);
        }
    }

    protected void breakLine(Token t) {
        this._tokens.add(new Token(Token.Type.Whitespace, t.start, t.start, "\n"));
    }

    protected void indent(Token t, int level) {
        this._tokens.add(new Token(Token.Type.Whitespace, t.start, t.start, this.makeIndent(level)));
    }

    protected String makeIndent(int level) {
        while (level >= this._indents.size()) {
            this._indents.add(this._indents.get(this._indents.size() - 1) + this._indent);
        }
        return this._indents.get(level);
    }
}

