/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.lang;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.sparql.lang.ParserBase;
import org.apache.jena.sparql.sse.SSEParseException;
import org.apache.jena.sparql.sse.lang.ParseHandler;

public class ParserSSEBase
extends ParserBase {
    private ParseHandler handler = null;

    public void setHandler(ParseHandler handler) {
        this.handler = handler;
    }

    protected void parseStart() {
        this.handler.parseStart();
    }

    protected void parseFinish() {
        this.handler.parseFinish();
    }

    protected void listStart(int line, int column) {
        this.handler.listStart(line, column);
    }

    protected void listFinish(int line, int column) {
        this.handler.listFinish(line, column);
    }

    protected void emitBNode(int line, int column, String label) {
        this.handler.emitBNode(line, column, label);
    }

    protected void emitIRI(int line, int column, String iriStr) {
        this.handler.emitIRI(line, column, iriStr);
    }

    protected void emitPName(int line, int column, String pname) {
        this.handler.emitPName(line, column, pname);
    }

    protected void emitSymbol(int line, int column, String pname) {
        this.handler.emitSymbol(line, column, pname);
    }

    protected void emitVar(int line, int column, String varName) {
        this.handler.emitVar(line, column, varName);
    }

    protected void emitLiteral(int currLine, int currColumn, String lex, String lang, String dt_iri, String dt_pname) {
        if (lang != null) {
            if (dt_iri != null || dt_pname != null) {
                ParserSSEBase.throwParseException("Internal error (lang and datatype)", currLine, currColumn);
            }
        } else if (dt_iri != null && dt_pname != null) {
            ParserSSEBase.throwParseException("Internal error (datatype from IRI and pname)", currLine, currColumn);
        }
        this.handler.emitLiteral(currLine, currColumn, lex, lang, dt_iri, dt_pname);
    }

    protected void emitLiteralInteger(int beginLine, int beginColumn, String image) {
        this.emitLiteral(beginLine, beginColumn, image, null, XSDDatatype.XSDinteger.getURI(), null);
    }

    protected void emitLiteralDecimal(int beginLine, int beginColumn, String image) {
        this.emitLiteral(beginLine, beginColumn, image, null, XSDDatatype.XSDdecimal.getURI(), null);
    }

    protected void emitLiteralDouble(int beginLine, int beginColumn, String image) {
        this.emitLiteral(beginLine, beginColumn, image, null, XSDDatatype.XSDdouble.getURI(), null);
    }

    protected void tripleTermStart(int line, int column) {
        this.handler.tripleTermStart(line, column);
    }

    protected void tripleTermFinish(int line, int column) {
        this.handler.tripleTermFinish(line, column);
    }

    public static void throwParseException(String msg, int line, int column) {
        throw new SSEParseException("Line " + line + ", column " + column + ": " + msg, line, column);
    }
}

