/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.util.Named;
import org.apache.jena.tdb.TDBException;

public enum NodeType implements Named
{
    BNODE{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 1;
        }

        @Override
        public String getName() {
            return "BNode";
        }
    }
    ,
    URI{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 2;
        }

        @Override
        public String getName() {
            return "URI";
        }
    }
    ,
    LITERAL{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 3;
        }

        @Override
        public String getName() {
            return "Literal";
        }
    }
    ,
    TRIPLETERM{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 4;
        }

        @Override
        public String getName() {
            return "TripleTerm";
        }
    }
    ,
    OTHER{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 50;
        }

        @Override
        public String getName() {
            return "Other";
        }
    };


    public abstract int getTypeId();

    public abstract XSDDatatype getDatatype();

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public static NodeType lookup(Node n) {
        if (n.isURI()) {
            return URI;
        }
        if (n.isBlank()) {
            return BNODE;
        }
        if (n.isLiteral()) {
            return LITERAL;
        }
        if (n.isNodeTriple()) {
            return TRIPLETERM;
        }
        return OTHER;
    }

    public static NodeType lookup(int type) {
        if (type == BNODE.getTypeId()) {
            return BNODE;
        }
        if (type == URI.getTypeId()) {
            return URI;
        }
        if (type == LITERAL.getTypeId()) {
            return LITERAL;
        }
        if (type == TRIPLETERM.getTypeId()) {
            return TRIPLETERM;
        }
        throw new TDBException("Unknown type (" + type + ")");
    }
}

