/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.index;

import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockMgrFactory;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.Index;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.index.bplustree.BPlusTree;
import org.apache.jena.tdb.index.bplustree.BPlusTreeParams;
import org.apache.jena.tdb.sys.SystemTDB;

public class SetupIndex {
    public static RangeIndex createBPTree(FileSet fileset, RecordFactory factory) {
        int readCacheSize = SystemTDB.BlockReadCacheSize;
        int writeCacheSize = SystemTDB.BlockWriteCacheSize;
        int blockSize = 8192;
        if (fileset.isMem()) {
            readCacheSize = 0;
            writeCacheSize = 0;
            blockSize = 1024;
        }
        return SetupIndex.createBPTreeByBlockSize(fileset, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static RangeIndex createBPTreeByBlockSize(FileSet fileset, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupIndex.createBPTree(fileset, -1, blockSize, readCacheSize, writeCacheSize, factory);
    }

    public static RangeIndex createBPTreeByOrder(FileSet fileset, int order, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        return SetupIndex.createBPTree(fileset, order, -1, readCacheSize, writeCacheSize, factory);
    }

    public static BPlusTree createBPTree(FileSet fileset, int order, int blockSize, int readCacheSize, int writeCacheSize, RecordFactory factory) {
        int order2;
        if (blockSize < 0 && order < 0) {
            throw new IllegalArgumentException("Neither blocksize nor order specified");
        }
        if (blockSize >= 0 && order < 0) {
            order = BPlusTreeParams.calcOrder(blockSize, factory.recordLength());
        }
        if (blockSize >= 0 && order >= 0 && order != (order2 = BPlusTreeParams.calcOrder(blockSize, factory.recordLength()))) {
            throw new IllegalArgumentException("Wrong order (" + order + "), calculated = " + order2);
        }
        if (blockSize < 0 && order >= 0) {
            blockSize = BPlusTreeParams.calcBlockSize(order, factory);
        }
        BPlusTreeParams params = new BPlusTreeParams(order, factory);
        BlockMgr blkMgrNodes = BlockMgrFactory.create(fileset, "idn", blockSize, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(fileset, "dat", blockSize, readCacheSize, writeCacheSize);
        return BPlusTree.create(params, blkMgrNodes, blkMgrRecords);
    }

    public static Index makeIndex(Location location, String indexName, int blkSize, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        return SetupIndex.makeRangeIndex(location, indexName, blkSize, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
    }

    public static RangeIndex makeRangeIndex(Location location, String indexName, int blkSize, int dftKeyLength, int dftValueLength, int readCacheSize, int writeCacheSize) {
        FileSet fs = new FileSet(location, indexName);
        RangeIndex rIndex = SetupIndex.makeBPlusTree(fs, blkSize, readCacheSize, writeCacheSize, dftKeyLength, dftValueLength);
        return rIndex;
    }

    public static RangeIndex makeBPlusTree(FileSet fs, int blkSize, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        RecordFactory recordFactory = SetupIndex.makeRecordFactory(dftKeyLength, dftValueLength);
        int order = BPlusTreeParams.calcOrder(blkSize, recordFactory.recordLength());
        BPlusTree rIndex = SetupIndex.createBPTree(fs, order, blkSize, readCacheSize, writeCacheSize, recordFactory);
        return rIndex;
    }

    public static RecordFactory makeRecordFactory(int keyLen, int valueLen) {
        return new RecordFactory(keyLen, valueLen);
    }
}

