/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.zip;

public final class ZipLong
implements Cloneable {
    private long m_value;

    public ZipLong(long value) {
        this.m_value = value;
    }

    public ZipLong(byte[] buffer) {
        this(buffer, 0);
    }

    public ZipLong(byte[] buffer, int offset) {
        this.m_value = (long)(buffer[offset + 3] << 24) & 0xFF000000L;
        this.m_value += (long)(buffer[offset + 2] << 16 & 0xFF0000);
        this.m_value += (long)(buffer[offset + 1] << 8 & 0xFF00);
        this.m_value += (long)(buffer[offset] & 0xFF);
    }

    public byte[] getBytes() {
        byte[] result = new byte[]{(byte)(this.m_value & 0xFFL), (byte)((this.m_value & 0xFF00L) >> 8), (byte)((this.m_value & 0xFF0000L) >> 16), (byte)((this.m_value & 0xFF000000L) >> 24)};
        return result;
    }

    public long getValue() {
        return this.m_value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ZipLong)) {
            return false;
        }
        return this.m_value == ((ZipLong)o).getValue();
    }

    public int hashCode() {
        return (int)this.m_value;
    }
}

