/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.vicino.vptree;

import edu.mit.simile.vicino.distances.Distance;
import edu.mit.simile.vicino.vptree.TNode;
import edu.mit.simile.vicino.vptree.VPTree;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPTreeSeeker {
    private static final boolean DEBUG = false;
    VPTree tree;
    Distance distance;

    public VPTreeSeeker(Distance distance, VPTree tree) {
        this.distance = distance;
        this.tree = tree;
    }

    public Set<Serializable> range(Serializable query, double range) {
        return this.rangeTraversal(query, range, this.tree.getRoot(), new HashSet<Serializable>());
    }

    private Set<Serializable> rangeTraversal(Serializable query, double range, TNode tNode, Set<Serializable> results) {
        if (tNode != null) {
            double distance = this.distance.d(query.toString(), tNode.get().toString());
            if (distance <= range) {
                results.add(tNode.get());
            }
            if (distance + range < tNode.getMedian()) {
                this.rangeTraversal(query, range, tNode.getLeft(), results);
            } else if (distance - range > tNode.getMedian()) {
                this.rangeTraversal(query, range, tNode.getRight(), results);
            } else {
                this.rangeTraversal(query, range, tNode.getLeft(), results);
                this.rangeTraversal(query, range, tNode.getRight(), results);
            }
        }
        return results;
    }
}

