/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.vicino.clustering;

import edu.mit.simile.vicino.clustering.Clusterer;
import edu.mit.simile.vicino.distances.Distance;
import edu.mit.simile.vicino.vptree.Node;
import edu.mit.simile.vicino.vptree.VPTree;
import edu.mit.simile.vicino.vptree.VPTreeBuilder;
import edu.mit.simile.vicino.vptree.VPTreeSeeker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPTreeClusterer
extends Clusterer {
    VPTreeBuilder _treeBuilder;
    Distance _distance;

    public VPTreeClusterer(Distance d) {
        this._distance = d;
        this._treeBuilder = new VPTreeBuilder(d);
    }

    @Override
    public void populate(String s) {
        this._treeBuilder.populate((Serializable)((Object)s));
    }

    @Override
    public List<Set<Serializable>> getClusters(double radius) {
        VPTree tree = this._treeBuilder.buildVPTree();
        System.out.println("distances after the tree: " + this._distance.getCount());
        Set<Node> nodes = this._treeBuilder.getNodes();
        VPTreeSeeker seeker = new VPTreeSeeker(this._distance, tree);
        HashMap<Serializable, Boolean> flags = new HashMap<Serializable, Boolean>();
        for (Node node : nodes) {
            flags.put(node.get(), true);
        }
        HashMap<Serializable, Set<Serializable>> map = new HashMap<Serializable, Set<Serializable>>();
        for (Node n : nodes) {
            Serializable s = n.get();
            if (!((Boolean)flags.get(s)).booleanValue()) continue;
            Set<Serializable> results = seeker.range(s, radius);
            for (Serializable ss : results) {
                flags.put(ss, false);
            }
            if (results.size() <= 1) continue;
            map.put(s, results);
        }
        ArrayList<Set<Serializable>> arrayList = new ArrayList<Set<Serializable>>(map.values());
        Collections.sort(arrayList, new Clusterer.SizeComparator());
        return arrayList;
    }
}

