/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.prefixes.PrefixLib;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.dboe.storage.prefixes.PrefixMapIOverStorage;
import org.apache.jena.dboe.storage.prefixes.PrefixesFactory;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixesView;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphViewSwitchable
extends GraphView {
    private final DatasetGraphSwitchable dsgx;

    public static GraphViewSwitchable createDefaultGraphSwitchable(DatasetGraphSwitchable dsg) {
        return new GraphViewSwitchable(dsg, Quad.defaultGraphNodeGenerated);
    }

    public static GraphView createNamedGraphSwitchable(DatasetGraphSwitchable dsg, Node graphIRI) {
        return new GraphViewSwitchable(dsg, graphIRI);
    }

    public static GraphViewSwitchable createUnionGraphSwitchable(DatasetGraphSwitchable dsg) {
        return new GraphViewSwitchable(dsg, Quad.unionGraph);
    }

    protected DatasetGraphSwitchable getx() {
        return this.dsgx;
    }

    protected GraphViewSwitchable(DatasetGraphSwitchable dsg, Node gn) {
        super((DatasetGraph)dsg, gn);
        this.dsgx = dsg;
    }

    protected PrefixMapping createPrefixMapping() {
        Node gn = super.getGraphName();
        if (gn == Quad.defaultGraphNodeGenerated) {
            gn = null;
        }
        if (Quad.isUnionGraph((Node)gn)) {
            PrefixMappingImpl pmap = new PrefixMappingImpl();
            pmap.setNsPrefixes(this.prefixMapping(null));
            return pmap;
        }
        return this.prefixMapping(gn);
    }

    public DatasetGraphSwitchable getDataset() {
        return this.getx();
    }

    public Graph getBaseGraph() {
        if (this.getGraphName() == null) {
            return this.getDSG().getDefaultGraph();
        }
        return this.getDSG().getGraph(this.getGraphName());
    }

    protected int graphBaseSize() {
        return this.getBaseGraph().size();
    }

    public void clear() {
        this.getBaseGraph().clear();
    }

    public void sync() {
    }

    protected ExtendedIterator<Triple> graphBaseFind(Node s, Node p, Node o) {
        return this.getBaseGraph().find(s, p, o);
    }

    private DatasetGraphTDB getDSG() {
        return (DatasetGraphTDB)this.getx().get();
    }

    private PrefixMapping prefixMapping(Node graphName) {
        PrefixMapTDB2 pmap = new PrefixMapTDB2(graphName);
        return PrefixesFactory.newPrefixMappingOverPrefixMapI((PrefixMapI)pmap);
    }

    class PrefixMapTDB2
    extends PrefixMapIOverStorage {
        private final Node graphName;

        PrefixMapTDB2(Node graphName) {
            super(null);
            this.graphName = graphName = PrefixLib.canonicalGraphName((Node)graphName);
        }

        protected StoragePrefixMap spm() {
            StoragePrefixes prefixes = GraphViewSwitchable.this.getDSG().getPrefixes();
            StoragePrefixMap view = PrefixLib.isNodeDefaultGraph((Node)this.graphName) ? StoragePrefixesView.viewDefaultGraph((StoragePrefixes)prefixes) : StoragePrefixesView.viewGraph((StoragePrefixes)prefixes, (Node)this.graphName);
            return view;
        }
    }
}

