/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.system.GraphViewStorage;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.G;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphTDB
extends GraphViewStorage {
    private final DatasetGraphTDB datasetTDB;
    private static Function<Tuple<NodeId>, Tuple<NodeId>> project4TupleTo3Tuple = item -> {
        if (item.len() != 4) {
            throw new TDBException("Expected a Tuple of 4, got: " + item);
        }
        return TupleFactory.tuple((Object[])new NodeId[]{(NodeId)item.get(1), (NodeId)item.get(2), (NodeId)item.get(3)});
    };

    public static GraphTDB tdb_createDefaultGraph(DatasetGraphTDB dsg, StoragePrefixes prefixes) {
        return new GraphTDB(dsg, Quad.defaultGraphNodeGenerated, prefixes);
    }

    public static GraphTDB tdb_createNamedGraph(DatasetGraphTDB dsg, Node graphIRI, StoragePrefixes prefixes) {
        return new GraphTDB(dsg, graphIRI, prefixes);
    }

    public static GraphTDB tdb_createUnionGraph(DatasetGraphTDB dsg, StoragePrefixes prefixes) {
        return new GraphTDB(dsg, Quad.unionGraph, prefixes);
    }

    private GraphTDB(DatasetGraphTDB dataset, Node graphName, StoragePrefixes prefixes) {
        super((DatasetGraph)dataset, graphName, prefixes);
        this.datasetTDB = dataset;
    }

    public DatasetGraphTDB getDSG() {
        return this.datasetTDB;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.getDSG().chooseNodeTupleTable(this.getGraphName());
    }

    protected final int graphBaseSize() {
        if (this.isDefaultGraph()) {
            return (int)this.getNodeTupleTable().size();
        }
        Node gn = this.getGraphName();
        boolean unionGraph = GraphTDB.isUnionGraph((Node)gn);
        gn = unionGraph ? Node.ANY : gn;
        Iterator iter = this.getDSG().getQuadTable().getNodeTupleTable().findAsNodeIds(gn, null, null, null);
        if (unionGraph) {
            iter = Iter.map(iter, project4TupleTo3Tuple);
            iter = Iter.distinctAdjacent((Iterator)iter);
        }
        return (int)Iter.count(iter);
    }

    private static Iterator<Triple> projectQuadsToTriples(Node graphNode, Iterator<Quad> iter) {
        Function<Quad, Triple> f = q -> {
            if (graphNode != null && !q.getGraph().equals((Object)graphNode)) {
                throw new DBOpEnvException("projectQuadsToTriples: Quads from unexpected graph (expected=" + graphNode + ", got=" + q.getGraph() + ")");
            }
            return q.asTriple();
        };
        return Iter.map(iter, f);
    }

    protected ExtendedIterator<Triple> graphUnionFind(Node s, Node p, Node o) {
        Node g = Quad.unionGraph;
        Iterator iterQuads = this.getDSG().find(g, s, p, o);
        Object iter = G.quads2triples((Iterator)iterQuads);
        iter = Iter.distinctAdjacent((Iterator)iter);
        return WrappedIterator.createNoRemove((Iterator)iter);
    }

    public final void sync() {
    }

    public final void close() {
        this.sync();
    }
}

