/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.lib;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Pool;
import org.apache.jena.atlas.lib.PoolBase;
import org.apache.jena.atlas.lib.PoolSync;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.Hash;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.nodetable.NodeTable;

public class NodeLib {
    private static String BNODE = "bnode";
    private static String URI = "uri";
    private static String LITERAL = "literal";
    private static String TRIPLE_TERM = "tripleTerm";
    private static int InitialPoolSize = 5;
    private static Pool<MessageDigest> digesters = PoolSync.create((Pool)new PoolBase());

    public static Hash hash(Node n) {
        Hash h = new Hash(16);
        NodeLib.setHash(h, n);
        return h;
    }

    public static void setHash(Hash h, Node n) {
        if (n.isURI()) {
            NodeLib.hash(h, n.getURI(), null, null, URI);
        } else if (n.isBlank()) {
            NodeLib.hash(h, n.getBlankNodeLabel(), null, null, BNODE);
        } else if (n.isLiteral()) {
            String dt = n.getLiteralDatatypeURI();
            if (NodeUtils.isSimpleString((Node)n) || NodeUtils.isLangString((Node)n)) {
                dt = null;
            }
            NodeLib.hash(h, n.getLiteralLexicalForm(), n.getLiteralLanguage(), dt, LITERAL);
        } else {
            if (n.isNodeTriple()) {
                String lex = NodeFmtLib.str((Node)n);
                NodeLib.hash(h, lex, null, null, TRIPLE_TERM);
                return;
            }
            throw new TDBException("Attempt to hash something strange: " + n);
        }
    }

    private static MessageDigest allocDigest() {
        try {
            MessageDigest disgest = (MessageDigest)digesters.get();
            if (disgest == null) {
                disgest = MessageDigest.getInstance("MD5");
            }
            return disgest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static void deallocDigest(MessageDigest digest) {
        digest.reset();
        digesters.put((Object)digest);
    }

    private static void hash(Hash h, String lex, String lang, String datatype, String nodeName) {
        if (datatype == null) {
            datatype = "";
        }
        if (lang == null) {
            lang = "";
        }
        String toHash = lex + "|" + lang + "|" + datatype + "|" + nodeName;
        try {
            MessageDigest digest = NodeLib.allocDigest();
            digest.update(Bytes.string2bytes((String)toHash));
            if (h.getLen() == 16) {
                digest.digest(h.getBytes(), 0, 16);
            } else {
                byte[] b = digest.digest();
                System.arraycopy(b, 0, h.getBytes(), 0, h.getLen());
            }
            NodeLib.deallocDigest(digest);
            return;
        }
        catch (DigestException ex) {
            Log.error(NodeLib.class, (String)"DigestException", (Throwable)ex);
            return;
        }
    }

    public static NodeId getNodeId(Record r, int idx) {
        return NodeIdFactory.get(r.getKey(), idx);
    }

    public static Node termOrAny(Node node) {
        if (node == null || node.isVariable()) {
            return Node.ANY;
        }
        return node;
    }

    public static Iterator<Node> nodes(NodeTable nodeTable, Iterator<NodeId> iter) {
        return Iter.map(iter, nodeTable::getNodeForNodeId);
    }

    static {
        try {
            for (int i = 0; i < InitialPoolSize; ++i) {
                digesters.put((Object)MessageDigest.getInstance("MD5"));
            }
        }
        catch (NoSuchAlgorithmException e) {
            Log.warn(NodeLib.class, (String)"NoSuchAlgorithmException", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

