/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.tracer;

import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class Tracer
extends Layout {
    protected static final int CONTEXT_SIZE = 25;
    protected static final long MAX_DELTA = 10000L;
    protected final StringBuffer buf = new StringBuffer(256);
    protected Calendar calendar = Calendar.getInstance();
    protected long previousTime = 0L;
    protected int indentation = 0;

    public void activateOptions() {
    }

    public String format(LoggingEvent event) {
        String message = event.getRenderedMessage();
        if (message == null) {
            return "";
        }
        if (message.length() < 2) {
            return message;
        }
        char leader = message.charAt(0);
        char secondLeader = message.charAt(1);
        if (leader == '<' && secondLeader == ' ' && this.indentation > 0) {
            --this.indentation;
        }
        this.buf.setLength(0);
        Date date = new Date();
        long now = date.getTime();
        this.calendar.setTime(date);
        long delta = 0L;
        if (this.previousTime > 0L) {
            delta = now - this.previousTime;
        }
        this.previousTime = now;
        int hour = this.calendar.get(11);
        if (hour < 10) {
            this.buf.append('0');
        }
        this.buf.append(hour);
        this.buf.append(':');
        int mins = this.calendar.get(12);
        if (mins < 10) {
            this.buf.append('0');
        }
        this.buf.append(mins);
        this.buf.append(':');
        int secs = this.calendar.get(13);
        if (secs < 10) {
            this.buf.append('0');
        }
        this.buf.append(secs);
        this.buf.append('.');
        int millis = (int)(now % 1000L);
        if (millis < 100) {
            this.buf.append('0');
        }
        if (millis < 10) {
            this.buf.append('0');
        }
        this.buf.append(millis);
        this.buf.append(" [");
        String context = event.getLoggerName();
        if (context.length() < 25) {
            this.buf.append(context);
            this.pad(this.buf, 25 - context.length(), ' ');
        } else {
            this.buf.append("..");
            this.buf.append(context.substring(context.length() - 25 + 2));
        }
        this.buf.append("] ");
        this.pad(this.buf, this.indentation, ' ');
        this.buf.append(message);
        this.buf.append(" (");
        this.buf.append(delta);
        this.buf.append("ms)\n");
        if (leader == '>' && secondLeader == ' ') {
            ++this.indentation;
        }
        return this.buf.toString();
    }

    private void pad(StringBuffer buffer, int pads, char padchar) {
        for (int i = 0; i < pads; ++i) {
            this.buf.append(padchar);
        }
    }

    public boolean ignoresThrowable() {
        return true;
    }
}

