/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.utils.WrappedException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import xtc.tree.Location;

public class AstLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String file;
    private final int line;
    private final int column;

    public AstLocation() {
        this.file = "";
        this.line = -1;
        this.column = -1;
    }

    public AstLocation(String file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public AstLocation(AstLocation location) {
        this.file = location.file;
        this.line = location.line;
        this.column = location.column;
    }

    public AstLocation(Location location) {
        this.file = location.file;
        this.line = location.line;
        this.column = location.column;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + this.line;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AstLocation other = (AstLocation)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return this.line == other.line;
    }

    public String toString() {
        String file = this.getFile();
        if (file == null) {
            return this.getLine() + ":" + this.getColumn();
        }
        try {
            return URLEncoder.encode(file, "UTF-8") + ":" + this.getLine() + ":" + this.getColumn();
        }
        catch (UnsupportedEncodingException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    public static AstLocation valueOf(String s) {
        int column;
        int line;
        String file = null;
        int i = s.indexOf(58);
        if (i == -1) {
            return null;
        }
        int j = s.indexOf(58, i + 1);
        if (j == -1) {
            line = Integer.parseInt(s.substring(0, i));
            column = Integer.parseInt(s.substring(i + 1));
        } else {
            try {
                file = URLDecoder.decode(s.substring(0, i), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WrappedException((Throwable)e);
            }
            line = Integer.parseInt(s.substring(i + 1, j));
            column = Integer.parseInt(s.substring(j + 1));
        }
        return new AstLocation(file, line, column);
    }

    public boolean isValid() {
        return this.line != -1;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public Location toXtcLocation() {
        return new Location(this.file, this.line, this.column);
    }
}

