/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.postprocessor;

import org.sweble.wikitext.parser.nodes.WikitextNodeFactory;
import org.sweble.wikitext.parser.nodes.WtImEndTag;
import org.sweble.wikitext.parser.nodes.WtImStartTag;
import org.sweble.wikitext.parser.nodes.WtNode;

public enum IntermediateTags {
    ITALICS{

        @Override
        public String getElementName() {
            return "@i";
        }

        @Override
        public WtNode createOpen(WikitextNodeFactory nf, boolean repair) {
            WtNode tag = super.createOpen(nf, repair);
            if (!repair) {
                tag.setRtd("''");
            }
            return tag;
        }

        @Override
        public WtNode createClose(WikitextNodeFactory nf, boolean repair) {
            WtNode tag = super.createClose(nf, repair);
            if (!repair) {
                tag.setRtd("''");
            }
            return tag;
        }
    }
    ,
    BOLD{

        @Override
        public String getElementName() {
            return "@b";
        }

        @Override
        public WtNode createOpen(WikitextNodeFactory nf, boolean repair) {
            WtNode tag = super.createOpen(nf, repair);
            if (!repair) {
                tag.setRtd("'''");
            }
            return tag;
        }

        @Override
        public WtNode createClose(WikitextNodeFactory nf, boolean repair) {
            WtNode tag = super.createClose(nf, repair);
            if (!repair) {
                tag.setRtd("'''");
            }
            return tag;
        }
    }
    ,
    PARAGRAPH{

        @Override
        public String getElementName() {
            return "@p";
        }
    };


    public abstract String getElementName();

    public WtNode createOpen(WikitextNodeFactory nf, boolean repair) {
        WtImStartTag tag = nf.imStartTag(this);
        return tag;
    }

    public WtNode createClose(WikitextNodeFactory nf, boolean repair) {
        WtImEndTag tag = nf.imEndTag(this);
        return tag;
    }
}

