/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.postprocessor;

import de.fau.cs.osr.ptk.common.ast.RtData;
import org.sweble.wikitext.parser.WtRtData;
import org.sweble.wikitext.parser.nodes.WikitextNodeFactory;
import org.sweble.wikitext.parser.nodes.WtBody;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtEmptyImmutableNode;
import org.sweble.wikitext.parser.nodes.WtExternalLink;
import org.sweble.wikitext.parser.nodes.WtHeading;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtIntermediate;
import org.sweble.wikitext.parser.nodes.WtInternalLink;
import org.sweble.wikitext.parser.nodes.WtLctFlags;
import org.sweble.wikitext.parser.nodes.WtLctVarConv;
import org.sweble.wikitext.parser.nodes.WtLinkOptions;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtNamedXmlElement;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtPageName;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.nodes.WtSection;
import org.sweble.wikitext.parser.nodes.WtSemiPreLine;
import org.sweble.wikitext.parser.nodes.WtTable;
import org.sweble.wikitext.parser.nodes.WtTableCaption;
import org.sweble.wikitext.parser.nodes.WtTableCell;
import org.sweble.wikitext.parser.nodes.WtTableHeader;
import org.sweble.wikitext.parser.nodes.WtTableRow;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtUrl;
import org.sweble.wikitext.parser.nodes.WtXmlAttributes;
import org.sweble.wikitext.parser.nodes.WtXmlElement;
import org.sweble.wikitext.parser.nodes.WtXmlEmptyTag;
import org.sweble.wikitext.parser.nodes.WtXmlEndTag;
import org.sweble.wikitext.parser.nodes.WtXmlStartTag;
import org.sweble.wikitext.parser.postprocessor.ElementType;
import org.sweble.wikitext.parser.postprocessor.TreeBuilder;
import org.sweble.wikitext.parser.postprocessor.WtNodeFlags;

public class ElementFactory {
    private final TreeBuilder tb;
    private final WikitextNodeFactory nf;

    public ElementFactory(TreeBuilder treeBuilder) {
        this.tb = treeBuilder;
        this.nf = treeBuilder.getConfig().getNodeFactory();
    }

    public WtText text(String content) {
        return this.nf.text(content);
    }

    public WtNode createMissingRepairStartTag(ElementType type) {
        return WtNodeFlags.setRepairNode(this.createStartTag(type));
    }

    public WtNode createSyntheticEndTag(WtNode node) {
        return this.createSyntheticEndTag(node, ElementType.getType(node));
    }

    public WtNode createSyntheticEndTag(WtNode node, ElementType type) {
        WtXmlEndTag endTag = this.createEndTag(type);
        WtRtData rtd = node.getRtd();
        if (rtd != null && rtd.size() >= 2) {
            endTag.setRtd(rtd.getField(rtd.size() - 1));
        }
        return endTag;
    }

    public WtNode createMissingRepairEndTag(ElementType type) {
        return WtNodeFlags.setRepairNode(this.createEndTag(type));
    }

    private WtXmlStartTag createStartTag(ElementType type) {
        return this.nf.startTag(this.getTagNameOrFail(type), this.nf.emptyAttrs());
    }

    private WtXmlEndTag createEndTag(ElementType type) {
        return this.nf.endTag(this.getTagNameOrFail(type));
    }

    public WtNode createRepairFormattingElement(WtNode template) {
        return this.create(template, true);
    }

    public WtNode createElementRepair(WtNode template) {
        WtXmlEndTag tag = (WtXmlEndTag)template;
        WtXmlElement newElement = this.createEmptyElement(tag.getName());
        ElementFactory.copyNodeAttributes(tag, newElement);
        WtRtData rtd = tag.getRtd();
        if (rtd != null) {
            newElement.setRtd(rtd.getField(0));
        }
        return newElement;
    }

    public WtNode createAdopterElement(WtNode template) {
        WtNode newElement = this.createNewElement(template);
        return newElement;
    }

    public WtNode createNewElement(WtNode template) {
        return this.create(template, false);
    }

    private WtNode create(WtNode template, boolean suppressRtd) {
        ElementType elementType = TreeBuilder.getNodeType(template);
        switch (template.getNodeType()) {
            case 720944: {
                return this.createFromIntermediate(elementType, (WtIntermediate)template, suppressRtd);
            }
            case 720936: {
                switch (elementType) {
                    case TR: {
                        if (!WtNodeFlags.isImplicit(template)) break;
                        return this.createImplicitTableRow();
                    }
                    case TBODY: {
                        if (!WtNodeFlags.isImplicit(template)) break;
                        return this.createImplicitTableBody();
                    }
                }
            }
            case 720932: 
            case 720935: {
                return this.createFromTag(elementType, (WtNamedXmlElement)template, suppressRtd);
            }
            case 720934: 
            case 720945: {
                throw new AssertionError();
            }
        }
        return this.createFromNative(elementType, template, suppressRtd);
    }

    private WtNode createFromIntermediate(ElementType elementType, WtIntermediate template, boolean suppressRtd) {
        WtContentNode.WtContentNodeImpl newElement;
        switch (TreeBuilder.getNodeType(template)) {
            case B: {
                newElement = this.nf.b(this.nf.list());
                this.copyIntermediateRtd(template, suppressRtd, newElement);
                break;
            }
            case I: {
                newElement = this.nf.i(this.nf.list());
                this.copyIntermediateRtd(template, suppressRtd, newElement);
                break;
            }
            case P: {
                newElement = this.nf.p(this.nf.list());
                break;
            }
            default: {
                throw new AssertionError((Object)("Don't know how to create intermediate element: " + (Object)((Object)elementType)));
            }
        }
        ElementFactory.copyNodeAttributes(template, newElement);
        return newElement;
    }

    private WtNode createFromTag(ElementType elementType, WtNamedXmlElement template, boolean suppressRtd) {
        WtXmlAttributes attribs;
        WtXmlElement newElement = this.createEmptyElement(template.getName());
        WtRtData rtd = template.getRtd();
        int nodeType = template.getNodeType();
        switch (nodeType) {
            case 720936: {
                attribs = ((WtXmlStartTag)template).getXmlAttributes();
                this.copyStartTagRtd(suppressRtd, newElement, rtd);
                break;
            }
            case 720935: {
                attribs = ((WtXmlEmptyTag)template).getXmlAttributes();
                this.copyStartTagRtd(suppressRtd, newElement, rtd);
                break;
            }
            case 720932: {
                attribs = ((WtXmlElement)template).getXmlAttributes();
                this.copyElementRtd(suppressRtd, newElement, rtd);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (suppressRtd) {
            attribs = this.suppressRtdOnChildren(attribs);
        }
        newElement.setXmlAttributes(attribs);
        this.setElementBody(elementType, nodeType, template, newElement);
        ElementFactory.copyNodeAttributes(template, newElement);
        return newElement;
    }

    private WtXmlElement createEmptyElement(String name) {
        return this.nf.elem(name, this.nf.emptyAttrs());
    }

    private void copyIntermediateRtd(WtIntermediate template, boolean suppressRtd, WtNode newElement) {
        if (!suppressRtd) {
            this.copyAllExceptLastRtd(template, newElement, false);
        }
    }

    private void copyElementRtd(boolean suppressRtd, WtXmlElement newElement, WtRtData rtd) {
        this.copyStartTagRtd(suppressRtd, newElement, rtd);
    }

    private void copyStartTagRtd(boolean suppressRtd, WtXmlElement newElement, WtRtData rtd) {
        if (!suppressRtd && rtd != null) {
            newElement.setRtd(rtd.getField(0), RtData.SEP, rtd.getField(1), RtData.SEP);
        }
    }

    private void setElementBody(ElementType elementType, int nodeType, WtNamedXmlElement template, WtXmlElement element) {
        switch (elementType) {
            case AREA: 
            case BR: 
            case IMG: 
            case HR: 
            case COL: {
                if (nodeType == 720935) break;
                this.tb.error(template, "12.2.4 Element should be an empty tag!");
                break;
            }
            default: {
                if (nodeType == 720935 || nodeType == 720932 && !((WtXmlElement)template).hasBody()) {
                    this.tb.error(template, "12.2.4 Element should not be an empty tag!");
                }
                if (nodeType == 720935) break;
                element.setBody(this.createEmptyBody());
            }
        }
    }

    private WtNode createFromNative(ElementType elementType, WtNode template, boolean suppressRtd) {
        WtNode newElement;
        boolean copyAllRtd = false;
        switch (elementType) {
            case PAGE: {
                newElement = this.createPage((WtParsedWikitextPage)template);
                break;
            }
            case DL: {
                newElement = this.nf.dl(this.nf.list());
                break;
            }
            case OL: {
                newElement = this.nf.ol(this.nf.list());
                break;
            }
            case UL: {
                newElement = this.nf.ul(this.nf.list());
                break;
            }
            case LI: {
                newElement = this.nf.li(this.nf.list());
                break;
            }
            case DD: {
                newElement = this.nf.dd(this.nf.list());
                break;
            }
            case DT: {
                newElement = this.nf.dt(this.nf.list());
                break;
            }
            case P: {
                newElement = this.nf.p(this.nf.list());
                break;
            }
            case INT_LINK: {
                newElement = this.createIntLink((WtInternalLink)template, suppressRtd);
                break;
            }
            case EXT_LINK: {
                newElement = this.createExtLink((WtExternalLink)template, suppressRtd);
                break;
            }
            case URL: {
                newElement = this.createUrl((WtUrl)template);
                break;
            }
            case B: {
                newElement = this.nf.b(this.nf.list());
                break;
            }
            case I: {
                newElement = this.nf.i(this.nf.list());
                break;
            }
            case SEMIPRE: {
                newElement = this.nf.semiPre(this.nf.list());
                break;
            }
            case HR: {
                newElement = this.nf.hr();
                break;
            }
            case SECTION: {
                newElement = this.createSection((WtSection)template, suppressRtd);
                break;
            }
            case SECTION_HEADING: {
                newElement = this.nf.heading(this.nf.list());
                copyAllRtd = true;
                break;
            }
            case SECTION_BODY: {
                newElement = this.createEmptyBody();
                break;
            }
            case TABLE: {
                newElement = this.createTable((WtTable)template, suppressRtd);
                break;
            }
            case TBODY: {
                newElement = this.nf.itbody(this.createEmptyBody());
                break;
            }
            case CAPTION: {
                newElement = this.createCaption((WtTableCaption)template, suppressRtd);
                break;
            }
            case TR: {
                newElement = this.createTr((WtTableRow)template, suppressRtd);
                break;
            }
            case TD: {
                newElement = this.createTd((WtTableCell)template, suppressRtd);
                break;
            }
            case TH: {
                newElement = this.createTh((WtTableHeader)template, suppressRtd);
                break;
            }
            case FRAMED_IMG: 
            case INLINE_IMG: {
                newElement = this.createImage((WtImageLink)template, suppressRtd);
                break;
            }
            case LCT_VAR_CONV: {
                newElement = this.createLctVarConv((WtLctVarConv)template, suppressRtd);
                break;
            }
            default: {
                throw new AssertionError((Object)("Don't know how to create element for: " + (Object)((Object)elementType)));
            }
        }
        if (!suppressRtd) {
            this.copyAllExceptLastRtd(template, newElement, copyAllRtd);
        }
        ElementFactory.copyNodeAttributes(template, newElement);
        return newElement;
    }

    private void copyAllExceptLastRtd(WtNode template, WtNode newElement, boolean copyAllRtd) {
        WtRtData rtd = template.getRtd();
        if (rtd != null) {
            if (copyAllRtd || rtd.size() == 1) {
                newElement.setRtd(rtd);
            } else {
                int size = rtd.size() - 1;
                WtRtData newRtd = new WtRtData(size + 1);
                for (int i = 0; i < size; ++i) {
                    newRtd.setField(i, template.getRtd().getField(i));
                }
                newElement.setRtd(newRtd);
            }
        }
    }

    private WtNode createLctVarConv(WtLctVarConv template, boolean suppressRtd) {
        WtLctFlags flags = template.getFlags();
        if (suppressRtd && !(flags instanceof WtEmptyImmutableNode)) {
            flags = (WtLctFlags)template.getFlags().deepCloneWrapException();
            flags.suppressRtd();
        }
        return this.nf.lctVarConv(flags, this.createBody(template.getText(), suppressRtd));
    }

    private WtNode createTh(WtTableHeader template, boolean suppressRtd) {
        return this.nf.th(this.suppressRtdOnChildren(template.getXmlAttributes(), suppressRtd), this.createBody(template.getBody(), suppressRtd));
    }

    private WtNode createTd(WtTableCell template, boolean suppressRtd) {
        return this.nf.td(this.suppressRtdOnChildren(template.getXmlAttributes(), suppressRtd), this.createBody(template.getBody(), suppressRtd));
    }

    private WtNode createTr(WtTableRow template, boolean suppressRtd) {
        return this.nf.tr(this.suppressRtdOnChildren(template.getXmlAttributes(), suppressRtd), this.createBody(template.getBody(), suppressRtd));
    }

    private WtNode createCaption(WtTableCaption template, boolean suppressRtd) {
        return this.nf.caption(this.suppressRtdOnChildren(template.getXmlAttributes(), suppressRtd), this.createBody(template.getBody(), suppressRtd));
    }

    private WtNode createImage(WtImageLink template, boolean suppressRtd) {
        WtLinkTitle title = null;
        if (template.hasTitle()) {
            title = this.createLinkTitle(template.getTitle(), suppressRtd);
        }
        WtLinkOptions options = template.getOptions();
        if (suppressRtd) {
            options = this.suppressRtdOnChildren(options);
        } else if (title != null && !(options instanceof WtEmptyImmutableNode)) {
            options = (WtLinkOptions)options.deepCloneWrapException();
        }
        WtImageLink newElement = this.nf.img(template.getTarget(), options);
        if (title != null) {
            newElement.setTitle(title);
        }
        return newElement;
    }

    private WtNode createExtLink(WtExternalLink template, boolean suppressRtd) {
        WtUrl target = template.getTarget();
        if (suppressRtd) {
            target = (WtUrl)target.deepCloneWrapException();
            target.suppressRtd();
        }
        WtExternalLink newElement = this.nf.extLink(target);
        if (template.hasTitle()) {
            newElement.setTitle(this.createLinkTitle(template.getTitle(), suppressRtd));
        }
        return newElement;
    }

    private WtNode createIntLink(WtInternalLink template, boolean suppressRtd) {
        WtPageName target = template.getTarget();
        if (suppressRtd) {
            target = (WtPageName)target.deepCloneWrapException();
            target.suppressRtd();
        }
        WtInternalLink newElement = this.nf.intLink(template.getPrefix(), target, template.getPostfix());
        if (template.hasTitle()) {
            newElement.setTitle(this.createLinkTitle(template.getTitle(), suppressRtd));
        }
        return newElement;
    }

    private WtLinkTitle createLinkTitle(WtLinkTitle template, boolean suppressRtd) {
        WtLinkTitle newElement = this.createEmptyLinkTitle();
        if (!suppressRtd) {
            newElement.setRtd(template.getRtd());
        }
        return newElement;
    }

    private WtNode createUrl(WtUrl template) {
        return this.nf.url(template.getProtocol(), template.getPath());
    }

    private WtNode createTable(WtTable template, boolean suppressRtd) {
        WtBody body = this.createBody(template.hasBody() ? template.getBody() : null, suppressRtd);
        return this.nf.table(this.suppressRtdOnChildren(template.getXmlAttributes(), suppressRtd), body);
    }

    private WtNode createSection(WtSection template, boolean suppressRtd) {
        WtBody body = this.createBody(template.hasBody() ? template.getBody() : null, suppressRtd);
        WtHeading heading = this.nf.heading(this.nf.list());
        if (!suppressRtd) {
            heading.setRtd(template.getHeading().getRtd());
        } else {
            heading.suppressRtd();
        }
        return this.nf.section(template.getLevel(), heading, body);
    }

    private WtNode createPage(WtParsedWikitextPage template) {
        WtParsedWikitextPage newElement = this.nf.parsedPage(this.nf.list());
        newElement.setEntityMap(template.getEntityMap());
        newElement.setWarnings(template.getWarnings());
        return newElement;
    }

    private WtNode createImplicitTableRow() {
        WtTableRow tr = this.nf.tr(this.nf.emptyAttrs(), this.createEmptyBody());
        tr.setImplicit(true);
        return tr;
    }

    private WtNode createImplicitTableBody() {
        return this.nf.itbody(this.createEmptyBody());
    }

    private WtBody createEmptyBody() {
        return this.nf.body(this.nf.list());
    }

    private WtLinkTitle createEmptyLinkTitle() {
        return this.nf.linkTitle(this.nf.list());
    }

    private WtBody createBody(WtBody template, boolean suppressRtd) {
        WtBody newBody;
        if (template != null) {
            newBody = this.createEmptyBody();
            if (!suppressRtd) {
                newBody.setRtd(template.getRtd());
            }
        } else {
            newBody = this.nf.noBody();
        }
        return newBody;
    }

    private String getTagNameOrFail(ElementType type) {
        String tagName = type.getXmlTagName();
        if (tagName == null) {
            throw new IllegalArgumentException("Don't know tag name for given node type: " + (Object)((Object)type));
        }
        return tagName;
    }

    private static void copyNodeAttributes(WtNode from, WtNode to) {
        if (from.hasAttributes()) {
            to.setAttributes(from.getAttributes());
        }
    }

    private <T extends WtContentNode> T suppressRtdOnChildren(T container, boolean suppressRtd) {
        return suppressRtd ? this.suppressRtdOnChildren(container) : container;
    }

    private <T extends WtContentNode> T suppressRtdOnChildren(T container) {
        if (container instanceof WtEmptyImmutableNode) {
            return container;
        }
        WtContentNode clone = (WtContentNode)container.deepCloneWrapException();
        clone.suppressRtd();
        return (T)clone;
    }

    public WtNode createSemiPreRtdNode() {
        WtSemiPreLine semiPreLine = this.nf.semiPreLine(this.nf.emptyList());
        semiPreLine.setRtd(" ", WtRtData.SEP);
        return semiPreLine;
    }
}

