/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.parser;

import de.fau.cs.osr.ptk.common.ParserState;
import java.util.regex.Pattern;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WtEntityMap;
import org.sweble.wikitext.parser.WtEntityMapImpl;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtPageName;
import org.sweble.wikitext.parser.parser.LinkBuilder;
import org.sweble.wikitext.parser.parser.ParserAtoms;
import org.sweble.wikitext.parser.parser.ParserScopes;
import org.sweble.wikitext.parser.parser.WikitextParserContext;

public class WikitextParserState
extends ParserState<WikitextParserContext> {
    private WtEntityMap entityMap = new WtEntityMapImpl();
    private ParserConfig config;
    private Pattern postfixPattern;
    private Pattern prefixPattern;
    private boolean autoCorrect;
    private boolean warningsEnabled;
    private boolean gatherRtData;
    private boolean langConvTagsEnabled;

    protected WikitextParserContext instantiateContext() {
        return new WikitextParserContext();
    }

    public WtEntityMap getEntityMap() {
        return this.entityMap;
    }

    public WtNode getEntity(int id) {
        return (WtNode)this.entityMap.getEntity(id);
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public void init(ParserConfig config, WtEntityMap entityMap) {
        this.config = config;
        this.entityMap = entityMap;
        this.autoCorrect = config.isAutoCorrect();
        this.warningsEnabled = config.isWarningsEnabled();
        this.gatherRtData = config.isGatherRtData();
        this.langConvTagsEnabled = config.isLangConvTagsEnabled();
        this.prefixPattern = Pattern.compile("(" + config.getInternalLinkPrefixPattern() + ")$");
        this.postfixPattern = Pattern.compile(config.getInternalLinkPostfixPattern());
    }

    public boolean isAutoCorrect() {
        return this.autoCorrect;
    }

    public boolean isWarnignsEnabled() {
        return this.warningsEnabled;
    }

    public boolean isGatherRtData() {
        return this.gatherRtData;
    }

    public Pattern getInternalLinkPrefixPattern() {
        return this.prefixPattern;
    }

    public Pattern getInternalLinkPostfixPattern() {
        return this.postfixPattern;
    }

    public LinkBuilder getLinkBuilder() {
        return ((WikitextParserContext)this.getTop()).getLinkBuilder();
    }

    public void initLinkBuilder(WtPageName target) {
        ((WikitextParserContext)this.getTop()).initLinkBuilder(this.config, target);
    }

    public ParserScopes getScope() {
        return ((WikitextParserContext)this.getTop()).getScope();
    }

    public void setScope(ParserScopes scope) {
        WikitextParserContext c = (WikitextParserContext)this.getTop();
        c.setScope(scope);
        if (scope.isSticky()) {
            c.addStickingScope(scope);
        }
    }

    public boolean accepts(ParserAtoms atom) {
        WikitextParserContext c = (WikitextParserContext)this.getTop();
        if (c.getScope().accepts(atom)) {
            int i = 0;
            for (int sticking = c.getStickingScopes(); sticking != 0; sticking >>= 1) {
                if ((sticking & 1) != 0 && !ParserScopes.values()[i].accepts(atom)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean inScope(ParserScopes scope) {
        WikitextParserContext c = (WikitextParserContext)this.getTop();
        if (c.getScope() == scope) {
            return true;
        }
        int bit = 1 << scope.ordinal();
        return 0 != (c.getStickingScopes() & bit);
    }

    public boolean isLangConvTagsEnabled() {
        return this.langConvTagsEnabled;
    }
}

