/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.nodes;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import java.util.Collections;
import java.util.List;
import org.sweble.wikitext.parser.WtEntityMap;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;

public abstract class WtPage
extends WtContentNode.WtContentNodeImpl {
    private static final long serialVersionUID = 1L;
    public static final List<Warning> NO_WARNINGS = Collections.EMPTY_LIST;
    public static final WtEntityMap NO_ENTITIES = WtEntityMap.EMPTY_ENTITY_MAP;
    private List<Warning> warnings;
    private WtEntityMap entityMap;

    protected WtPage() {
        this.setWarnings(NO_WARNINGS);
        this.setEntityMap(NO_ENTITIES);
    }

    protected WtPage(WtNodeList content) {
        super(content);
        this.setWarnings(NO_WARNINGS);
        this.setEntityMap(NO_ENTITIES);
    }

    protected WtPage(WtNodeList content, WtEntityMap entityMap) {
        super(content);
        this.setWarnings(NO_WARNINGS);
        this.setEntityMap(entityMap);
    }

    public int getNodeType() {
        return 720897;
    }

    public final boolean hasWarnings() {
        return this.warnings != NO_WARNINGS || !this.warnings.isEmpty();
    }

    public final List<Warning> getWarnings() {
        return this.warnings;
    }

    public final void setWarnings(List<Warning> warnings) {
        if (warnings == null) {
            throw new NullPointerException();
        }
        this.warnings = warnings;
    }

    public final boolean hasEntities() {
        return this.entityMap != NO_ENTITIES || !this.entityMap.isEmpty();
    }

    public final WtEntityMap getEntityMap() {
        return this.entityMap;
    }

    public final void setEntityMap(WtEntityMap entityMap) {
        if (entityMap == null) {
            throw new NullPointerException();
        }
        this.entityMap = entityMap;
    }

    @Override
    public final int getPropertyCount() {
        return 2 + this.getSuperPropertyCount();
    }

    public int getSuperPropertyCount() {
        return super.getPropertyCount();
    }

    @Override
    public final AstNodePropertyIterator propertyIterator() {
        return new WtContentNode.WtContentNodeImpl.WtContentNodePropertyIterator(){

            @Override
            protected int getPropertyCount() {
                return WtPage.this.getPropertyCount();
            }

            @Override
            protected String getName(int index) {
                switch (index - WtPage.this.getSuperPropertyCount()) {
                    case 0: {
                        return "warnings";
                    }
                    case 1: {
                        return "entityMap";
                    }
                }
                return super.getName(index);
            }

            @Override
            protected Object getValue(int index) {
                switch (index - WtPage.this.getSuperPropertyCount()) {
                    case 0: {
                        return WtPage.this.getWarnings();
                    }
                    case 1: {
                        return WtPage.this.getEntityMap();
                    }
                }
                return super.getValue(index);
            }

            @Override
            protected Object setValue(int index, Object value) {
                switch (index - WtPage.this.getSuperPropertyCount()) {
                    case 0: {
                        List list = (List)value;
                        List<Warning> old = WtPage.this.getWarnings();
                        WtPage.this.setWarnings(list);
                        return old;
                    }
                    case 1: {
                        WtEntityMap old = WtPage.this.getEntityMap();
                        WtPage.this.setEntityMap((WtEntityMap)value);
                        return old;
                    }
                }
                return super.setValue(index, value);
            }
        };
    }
}

