/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser;

import de.fau.cs.osr.ptk.common.ParserCommon;
import java.io.IOException;
import java.io.StringReader;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.WtEntityMapImpl;
import org.sweble.wikitext.parser.encval.ValidatedWikitext;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtPreproWikitextPage;
import org.sweble.wikitext.parser.preprocessor.RatsWikitextPreprocessor;
import xtc.parser.ParseError;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.parser.SemanticValue;

public class WikitextPreprocessor
extends ParserCommon<WtNode> {
    private RatsWikitextPreprocessor preprocessor = null;
    private final ParserConfig config;

    public WikitextPreprocessor(ParserConfig config) {
        this.config = config;
    }

    public Object getConfig() {
        return this.config;
    }

    public WtNode parseArticle(String src, String title) throws IOException, ParseException {
        return this.parseArticle(new ValidatedWikitext(src, new WtEntityMapImpl(), false), title, false);
    }

    public WtNode parseArticle(ValidatedWikitext wikitext, String title, boolean forInclusion) throws IOException, ParseException {
        StringReader in = new StringReader(wikitext.getWikitext());
        int inputSize = wikitext.getWikitext().getBytes().length;
        this.preprocessor = new RatsWikitextPreprocessor(in, title, inputSize);
        this.preprocessor.getState().init(this.config, wikitext.getEntityMap(), forInclusion);
        this.preprocessor.setNodeFactory(this.config.getNodeFactory());
        Result r = this.preprocessor.pArticle(0);
        if (r.hasValue()) {
            SemanticValue v = (SemanticValue)r;
            if (v.value instanceof WtPreproWikitextPage) {
                return (WtNode)this.process((WtPreproWikitextPage)v.value);
            }
            throw new ParseException("Internal preprocessor error: Unexpected preprocessor result type!");
        }
        ParseError err = (ParseError)r;
        if (err.index == -1) {
            throw new ParseException("Parse error: No information available");
        }
        throw new ParseException(String.format("%s: %s", this.preprocessor.location(err.index), err.msg));
    }
}

