/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.SenseIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class SenseDocumentImpl
extends StatementDocumentImpl
implements SenseDocument {
    private final Map<String, MonolingualTextValue> glosses;

    SenseDocumentImpl(SenseIdValue id, List<MonolingualTextValue> glosses, List<StatementGroup> statements, long revisionId) {
        super((EntityIdValue)id, statements, revisionId);
        this.glosses = glosses == null || glosses.isEmpty() ? Collections.emptyMap() : SenseDocumentImpl.constructTermMap(glosses);
    }

    @JsonCreator
    SenseDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="glosses") @JsonDeserialize(contentAs=TermImpl.class) Map<String, MonolingualTextValue> glosses, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, claims, revisionId, siteIri);
        this.glosses = glosses == null ? Collections.emptyMap() : glosses;
    }

    private SenseDocumentImpl(SenseIdValue subject, Map<String, MonolingualTextValue> glosses, Map<String, List<Statement>> claims, long revisionId) {
        super((EntityIdValue)subject, claims, revisionId);
        this.glosses = glosses;
    }

    private static Map<String, MonolingualTextValue> constructTermMap(List<MonolingualTextValue> terms) {
        HashMap<String, MonolingualTextValue> map = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue term : terms) {
            String language = term.getLanguageCode();
            if (map.containsKey(language)) {
                throw new IllegalArgumentException("Multiple terms provided for the same language.");
            }
            map.put(language, SenseDocumentImpl.toTerm(term));
        }
        return map;
    }

    private static MonolingualTextValue toTerm(MonolingualTextValue term) {
        return term instanceof TermImpl ? term : new TermImpl(term.getLanguageCode(), term.getText());
    }

    @Override
    @JsonIgnore
    public SenseIdValue getEntityId() {
        return new SenseIdValueImpl(this.entityId, this.siteIri);
    }

    @JsonProperty(value="type")
    String getType() {
        return "sense";
    }

    @Override
    @JsonProperty(value="glosses")
    public Map<String, MonolingualTextValue> getGlosses() {
        return this.glosses;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsSenseDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public SenseDocument withRevisionId(long newRevisionId) {
        return new SenseDocumentImpl(this.getEntityId(), this.glosses, this.claims, newRevisionId);
    }

    @Override
    public SenseDocument withGloss(MonolingualTextValue gloss) {
        HashMap<String, MonolingualTextValue> newGlosses = new HashMap<String, MonolingualTextValue>(this.glosses);
        newGlosses.put(gloss.getLanguageCode(), SenseDocumentImpl.toTerm(gloss));
        return new SenseDocumentImpl(this.getEntityId(), newGlosses, this.claims, this.revisionId);
    }

    @Override
    public SenseDocument withStatement(Statement statement) {
        return new SenseDocumentImpl(this.getEntityId(), this.glosses, SenseDocumentImpl.addStatementToGroups(statement, this.claims), this.revisionId);
    }

    @Override
    public SenseDocument withoutStatementIds(Set<String> statementIds) {
        return new SenseDocumentImpl(this.getEntityId(), this.glosses, SenseDocumentImpl.removeStatements(statementIds, this.claims), this.revisionId);
    }
}

