/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.DatatypeIdImpl;
import org.wikidata.wdtk.datamodel.implementation.PropertyIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.implementation.TermedStatementDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PropertyDocumentImpl
extends TermedStatementDocumentImpl
implements PropertyDocument {
    private final DatatypeIdImpl datatype;

    public PropertyDocumentImpl(PropertyIdValue id, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statements, DatatypeIdValue datatype, long revisionId) {
        super((EntityIdValue)id, labels, descriptions, aliases, statements, revisionId);
        this.datatype = new DatatypeIdImpl(datatype);
    }

    @JsonCreator
    public PropertyDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="labels") @JsonDeserialize(contentAs=TermImpl.class) Map<String, MonolingualTextValue> labels, @JsonProperty(value="descriptions") @JsonDeserialize(contentAs=TermImpl.class) Map<String, MonolingualTextValue> descriptions, @JsonProperty(value="aliases") @JsonDeserialize(using=TermedStatementDocumentImpl.AliasesDeserializer.class) Map<String, List<MonolingualTextValue>> aliases, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="datatype") String datatype, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, labels, descriptions, aliases, claims, revisionId, siteIri);
        this.datatype = new DatatypeIdImpl(DatatypeIdImpl.getDatatypeIriFromJsonDatatype(datatype));
    }

    private PropertyDocumentImpl(PropertyIdValue id, Map<String, MonolingualTextValue> labels, Map<String, MonolingualTextValue> descriptions, Map<String, List<MonolingualTextValue>> aliases, Map<String, List<Statement>> claims, DatatypeIdValue datatypeId, long revisionId) {
        super((EntityIdValue)id, labels, descriptions, aliases, claims, revisionId);
        this.datatype = new DatatypeIdImpl(datatypeId);
    }

    @JsonProperty(value="datatype")
    public String getJsonDatatype() {
        return this.datatype.getJsonString();
    }

    @Override
    @JsonIgnore
    public PropertyIdValue getEntityId() {
        return new PropertyIdValueImpl(this.entityId, this.siteIri);
    }

    @Override
    @JsonIgnore
    public DatatypeIdValue getDatatype() {
        return new DatatypeIdImpl(this.datatype);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsPropertyDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public PropertyDocument withRevisionId(long newRevisionId) {
        return new PropertyDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, this.claims, (DatatypeIdValue)this.datatype, newRevisionId);
    }

    @Override
    public PropertyDocument withLabel(MonolingualTextValue newLabel) {
        return new PropertyDocumentImpl(this.getEntityId(), PropertyDocumentImpl.withTerm(this.labels, newLabel), (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, this.claims, (DatatypeIdValue)this.datatype, this.revisionId);
    }

    @Override
    public PropertyDocument withDescription(MonolingualTextValue newDescription) {
        return new PropertyDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, PropertyDocumentImpl.withTerm(this.descriptions, newDescription), (Map<String, List<MonolingualTextValue>>)this.aliases, this.claims, (DatatypeIdValue)this.datatype, this.revisionId);
    }

    @Override
    public PropertyDocument withAliases(String language, List<MonolingualTextValue> aliases) {
        return new PropertyDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, PropertyDocumentImpl.withAliases(this.aliases, language, aliases), this.claims, (DatatypeIdValue)this.datatype, this.revisionId);
    }

    @Override
    public PropertyDocument withStatement(Statement statement) {
        Map<String, List<Statement>> newGroups = PropertyDocumentImpl.addStatementToGroups(statement, this.claims);
        return new PropertyDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, newGroups, (DatatypeIdValue)this.datatype, this.revisionId);
    }

    @Override
    public PropertyDocument withoutStatementIds(Set<String> statementIds) {
        Map<String, List<Statement>> newGroups = PropertyDocumentImpl.removeStatements(statementIds, this.claims);
        return new PropertyDocumentImpl(this.getEntityId(), (Map<String, MonolingualTextValue>)this.labels, (Map<String, MonolingualTextValue>)this.descriptions, (Map<String, List<MonolingualTextValue>>)this.aliases, newGroups, (DatatypeIdValue)this.datatype, this.revisionId);
    }
}

