/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Objects;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityRedirectDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;

public class Equality {
    public static boolean equalsEntityIdValue(EntityIdValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof EntityIdValue)) {
            return false;
        }
        EntityIdValue other = (EntityIdValue)o2;
        return o1.getId().equals(other.getId()) && o1.getSiteIri().equals(other.getSiteIri()) && o1.getEntityType().equals(other.getEntityType());
    }

    public static boolean equalsDatatypeIdValue(DatatypeIdValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof DatatypeIdValue && o1.getIri().equals(((DatatypeIdValue)o2).getIri());
    }

    public static boolean equalsTimeValue(TimeValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof TimeValue)) {
            return false;
        }
        TimeValue other = (TimeValue)o2;
        return o1.getYear() == other.getYear() && o1.getMonth() == other.getMonth() && o1.getDay() == other.getDay() && o1.getHour() == other.getHour() && o1.getMinute() == other.getMinute() && o1.getSecond() == other.getSecond() && o1.getPrecision() == other.getPrecision() && o1.getBeforeTolerance() == other.getBeforeTolerance() && o1.getAfterTolerance() == other.getAfterTolerance() && o1.getTimezoneOffset() == other.getTimezoneOffset() && o1.getPreferredCalendarModel().equals(other.getPreferredCalendarModel());
    }

    public static boolean equalsGlobeCoordinatesValue(GlobeCoordinatesValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof GlobeCoordinatesValue)) {
            return false;
        }
        GlobeCoordinatesValue other = (GlobeCoordinatesValue)o2;
        return o1.getLatitude() == other.getLatitude() && o1.getLongitude() == other.getLongitude() && o1.getPrecision() == other.getPrecision() && o1.getGlobe().equals(other.getGlobe());
    }

    public static boolean equalsStringValue(StringValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof StringValue && o1.getString().equals(((StringValue)o2).getString());
    }

    public static boolean equalsMonolingualTextValue(MonolingualTextValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof MonolingualTextValue)) {
            return false;
        }
        MonolingualTextValue other = (MonolingualTextValue)o2;
        return o1.getText().equals(other.getText()) && o1.getLanguageCode().equals(other.getLanguageCode());
    }

    public static boolean equalsQuantityValue(QuantityValue o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof QuantityValue)) {
            return false;
        }
        QuantityValue other = (QuantityValue)o2;
        return o1.getNumericValue().equals(other.getNumericValue()) && Objects.equals(o1.getLowerBound(), other.getLowerBound()) && Objects.equals(o1.getUpperBound(), other.getUpperBound()) && o1.getUnit().equals(other.getUnit());
    }

    public static boolean equalsValueSnak(ValueSnak o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof ValueSnak && o1.getPropertyId().equals(((ValueSnak)o2).getPropertyId()) && o1.getValue().equals(((ValueSnak)o2).getValue());
    }

    public static boolean equalsSomeValueSnak(SomeValueSnak o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof SomeValueSnak && o1.getPropertyId().equals(((SomeValueSnak)o2).getPropertyId());
    }

    public static boolean equalsNoValueSnak(NoValueSnak o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof NoValueSnak && o1.getPropertyId().equals(((NoValueSnak)o2).getPropertyId());
    }

    public static boolean equalsSnakGroup(SnakGroup o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof SnakGroup && o1.getSnaks().equals(((SnakGroup)o2).getSnaks());
    }

    public static boolean equalsClaim(Claim o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof Claim)) {
            return false;
        }
        Claim other = (Claim)o2;
        return o1.getSubject().equals(other.getSubject()) && o1.getMainSnak().equals(other.getMainSnak()) && o1.getQualifiers().equals(other.getQualifiers());
    }

    public static boolean equalsReference(Reference o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof Reference && o1.getSnakGroups().equals(((Reference)o2).getSnakGroups());
    }

    public static boolean equalsStatement(Statement o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)o2;
        return o1.getSubject().equals(other.getSubject()) && o1.getMainSnak().equals(other.getMainSnak()) && o1.getQualifiers().equals(other.getQualifiers()) && o1.getReferences().equals(other.getReferences()) && o1.getRank() == other.getRank() && o1.getStatementId().equals(other.getStatementId());
    }

    public static boolean equalsStatementGroup(StatementGroup o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        return o2 instanceof StatementGroup && o1.getStatements().equals(((StatementGroup)o2).getStatements());
    }

    public static boolean equalsSiteLink(SiteLink o1, Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof SiteLink)) {
            return false;
        }
        SiteLink other = (SiteLink)o2;
        return o1.getPageTitle().equals(other.getPageTitle()) && o1.getSiteKey().equals(other.getSiteKey()) && o1.getBadges().equals(other.getBadges());
    }

    public static boolean equalsPropertyDocument(PropertyDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof PropertyDocument)) {
            return false;
        }
        PropertyDocument other = (PropertyDocument)o2;
        return Equality.equalsTermedDocument(o1, other) && o1.getDatatype().equals(other.getDatatype()) && o1.getStatementGroups().equals(other.getStatementGroups());
    }

    public static boolean equalsItemDocument(ItemDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof ItemDocument)) {
            return false;
        }
        ItemDocument other = (ItemDocument)o2;
        return Equality.equalsTermedDocument(o1, other) && o1.getSiteLinks().equals(other.getSiteLinks()) && o1.getStatementGroups().equals(other.getStatementGroups());
    }

    public static boolean equalsLexemeDocument(LexemeDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof LexemeDocument)) {
            return false;
        }
        LexemeDocument other = (LexemeDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getLanguage().equals(other.getLanguage()) && o1.getLexicalCategory().equals(other.getLexicalCategory()) && o1.getLemmas().equals(other.getLemmas()) && o1.getStatementGroups().equals(other.getStatementGroups()) && o1.getForms().equals(other.getForms()) && o1.getSenses().equals(other.getSenses()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsFormDocument(FormDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof FormDocument)) {
            return false;
        }
        FormDocument other = (FormDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getGrammaticalFeatures().equals(other.getGrammaticalFeatures()) && o1.getRepresentations().equals(other.getRepresentations()) && o1.getStatementGroups().equals(other.getStatementGroups()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsSenseDocument(SenseDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof SenseDocument)) {
            return false;
        }
        SenseDocument other = (SenseDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getGlosses().equals(other.getGlosses()) && o1.getStatementGroups().equals(other.getStatementGroups()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsMediaInfoDocument(MediaInfoDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof MediaInfoDocument)) {
            return false;
        }
        MediaInfoDocument other = (MediaInfoDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getLabels().equals(other.getLabels()) && o1.getStatementGroups().equals(other.getStatementGroups()) && o1.getRevisionId() == other.getRevisionId();
    }

    private static boolean equalsTermedDocument(TermedDocument o1, TermedDocument other) {
        return o1.getEntityId().equals(other.getEntityId()) && o1.getAliases().equals(other.getAliases()) && o1.getDescriptions().equals(other.getDescriptions()) && o1.getLabels().equals(other.getLabels()) && o1.getRevisionId() == other.getRevisionId();
    }

    public static boolean equalsEntityRedirectDocument(EntityRedirectDocument o1, Object o2) {
        if (o2 == o1) {
            return true;
        }
        if (!(o2 instanceof EntityRedirectDocument)) {
            return false;
        }
        EntityRedirectDocument other = (EntityRedirectDocument)o2;
        return o1.getEntityId().equals(other.getEntityId()) && o1.getTargetId().equals(other.getTargetId()) && o1.getRevisionId() == other.getRevisionId();
    }
}

