/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;

public class DataFormatter {
    static final String FORMAT_YEAR = "00000000000";
    static final String FORMAT_OTHER = "00";

    public static String formatTimeISO8601(TimeValue value) {
        StringBuilder builder = new StringBuilder();
        DecimalFormat yearForm = new DecimalFormat(FORMAT_YEAR);
        DecimalFormat timeForm = new DecimalFormat(FORMAT_OTHER);
        if (value.getYear() > 0L) {
            builder.append("+");
        }
        builder.append(yearForm.format(value.getYear()));
        builder.append("-");
        builder.append(timeForm.format(value.getMonth()));
        builder.append("-");
        builder.append(timeForm.format(value.getDay()));
        builder.append("T");
        builder.append(timeForm.format(value.getHour()));
        builder.append(":");
        builder.append(timeForm.format(value.getMinute()));
        builder.append(":");
        builder.append(timeForm.format(value.getSecond()));
        builder.append("Z");
        return builder.toString();
    }

    public static String formatBigDecimal(BigDecimal number) {
        if (number.signum() != -1) {
            return "+" + number.toString();
        }
        return number.toString();
    }
}

