/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode.ppm;

import com.colloquial.arithcode.ArithEncoder;
import com.colloquial.arithcode.ppm.ByteSet;
import com.colloquial.arithcode.ppm.Converter;
import com.colloquial.arithcode.ppm.PPMModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class TokenStreamEncoder {
    private final ArithEncoder _encoder;
    private final int[] _interval = new int[3];
    private int _nextTokenIndex = 0;
    private final PPMModel _tokenBytesModel;
    private final PPMModel _tokenSequenceModel;
    private final Map<String, Integer> _tokenToSymbolMap;
    private static final String LATIN1 = "ISO-8859-1";
    private static final ByteSet LATIN1_UNUSED_BYTES;

    public TokenStreamEncoder(ArithEncoder encoder, int tokenSequenceOrder, PPMModel tokenBytesModel) {
        this._encoder = encoder;
        this._tokenBytesModel = tokenBytesModel;
        this._tokenSequenceModel = new PPMModel(tokenSequenceOrder);
        this._tokenToSymbolMap = new HashMap<String, Integer>();
    }

    public void encode(String token) throws IOException {
        if (this._tokenToSymbolMap.containsKey(token)) {
            this.encodeToken(this._tokenToSymbolMap.get(token));
        } else {
            this._tokenToSymbolMap.put(token, new Integer(this._nextTokenIndex++));
            this.encodeToken(this._nextTokenIndex);
            ++this._nextTokenIndex;
            this.encodeBytes(token.getBytes(LATIN1));
        }
    }

    private void encodeToken(int symbol) throws IOException {
        for (int i = this._nextTokenIndex + 1; i < 256; ++i) {
            this._tokenSequenceModel.exclude(i);
        }
        this.encode(this._tokenSequenceModel, symbol);
    }

    private void encodeBytes(byte[] bytes) throws IOException {
        for (int i = 0; i < bytes.length; ++i) {
            this._tokenBytesModel.exclude(LATIN1_UNUSED_BYTES);
            this.encode(this._tokenBytesModel, Converter.byteToInteger(bytes[i]));
        }
        this._tokenBytesModel.exclude(LATIN1_UNUSED_BYTES);
        this.encode(this._tokenBytesModel, 0);
    }

    private void encode(PPMModel model, int symbol) throws IOException {
        while (model.escaped(symbol)) {
            model.interval(-2, this._interval);
            this._encoder.encode(this._interval);
        }
        model.interval(symbol, this._interval);
        this._encoder.encode(this._interval);
    }

    static {
        int i;
        LATIN1_UNUSED_BYTES = new ByteSet();
        for (i = 1; i <= 8; ++i) {
            LATIN1_UNUSED_BYTES.add(i);
        }
        for (i = 11; i <= 12; ++i) {
            LATIN1_UNUSED_BYTES.add(i);
        }
        for (i = 14; i <= 31; ++i) {
            LATIN1_UNUSED_BYTES.add(i);
        }
        for (i = 127; i <= 159; ++i) {
            LATIN1_UNUSED_BYTES.add(i);
        }
    }
}

