/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.util.Arrays;
import java.util.EmptyStackException;

public class ArrayStack<T> {
    private Object[] stack;
    private final int capacityIncrease;
    private int size = 0;

    public ArrayStack() {
        this.stack = new Object[10];
        this.capacityIncrease = 10;
    }

    public ArrayStack(int initialCapacity, int capacityIncrease) {
        if (initialCapacity < 0 || capacityIncrease < 1) {
            throw new IllegalArgumentException();
        }
        this.stack = new Object[initialCapacity];
        this.capacityIncrease = capacityIncrease;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T peek() {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        return (T)this.stack[this.size - 1];
    }

    public T pop() {
        T top = this.peek();
        --this.size;
        return top;
    }

    public T push(T item) {
        if (this.size == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length + this.capacityIncrease);
        }
        this.stack[this.size++] = item;
        return item;
    }

    public void clear() {
        this.size = 0;
    }
}

