/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marc4j.MarcException;
import org.marc4j.MarcJsonReader;
import org.marc4j.MarcStreamReader;
import org.marc4j.MarcStreamWriter;
import org.marc4j.MarcXmlReader;
import org.marc4j.marc.Record;

public class RemoteSolrSearcher {
    static boolean verbose = false;
    static boolean veryverbose = false;
    Object solrSearcher = null;
    String solrBaseURL;
    String solrFieldContainingEncodedMarcRecord;
    MarcStreamWriter output;
    String query;
    static BufferedWriter errOut = null;

    public RemoteSolrSearcher(String solrBaseURL, String query, String solrFieldContainingEncodedMarcRecord) {
        this.solrBaseURL = solrBaseURL;
        this.solrFieldContainingEncodedMarcRecord = solrFieldContainingEncodedMarcRecord;
        this.query = query;
        if (verbose) {
            System.err.println("URL = " + solrBaseURL + "  query = " + query);
        }
    }

    public int handleAll() {
        String encQuery;
        this.output = new MarcStreamWriter(System.out, "UTF8", true);
        if (this.solrFieldContainingEncodedMarcRecord == null) {
            this.solrFieldContainingEncodedMarcRecord = "marc_display";
        }
        try {
            encQuery = URLEncoder.encode(this.query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            encQuery = this.query;
        }
        if (verbose) {
            System.err.println("encoded query = " + encQuery);
        }
        String[] resultSet = this.getIdSet(encQuery);
        String recordStr = null;
        for (String id : resultSet) {
            recordStr = this.getFieldFromDocumentGivenDocID(id, this.solrFieldContainingEncodedMarcRecord);
            Record record = null;
            if (recordStr.startsWith("<?xml version")) {
                record = this.getRecordFromXMLString(recordStr);
            } else if (recordStr.startsWith("{\"")) {
                record = this.getRecordFromJsonString(recordStr);
            } else {
                int byte_len = 0;
                try {
                    byte_len = recordStr.getBytes("UTF8").length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (byte_len != Integer.parseInt(recordStr.substring(0, 5))) {
                    String recid = this.getFieldVal(recordStr, "001");
                    if (verbose) {
                        System.err.println("Error: Binary Marc record is the wrong length: " + recid);
                    }
                } else {
                    record = this.getRecordFromRawMarcUTF8(recordStr);
                }
            }
            if (record == null) continue;
            this.output.write(record);
            System.out.flush();
        }
        this.output.close();
        return 0;
    }

    public String getFieldVal(String recordStr, String idField) {
        int offset = Integer.parseInt(recordStr.substring(12, 17));
        int dirOffset = 24;
        String fieldNum = recordStr.substring(dirOffset, dirOffset + 3);
        while (dirOffset < offset) {
            if (fieldNum.equals(idField)) {
                int length = Integer.parseInt(recordStr.substring(dirOffset + 3, dirOffset + 7));
                int offset2 = Integer.parseInt(recordStr.substring(dirOffset + 7, dirOffset + 12));
                String id = recordStr.substring(offset + offset2, offset + offset2 + length - 1).trim();
                return id;
            }
            fieldNum = recordStr.substring(dirOffset += 12, dirOffset + 3);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFieldFromDocumentGivenDocID(String id, String solrFieldContainingEncodedMarcRecord2) {
        String fullURLStr = this.solrBaseURL + "/select/?q=id%3A" + id + "&wt=json&indent=on&qt=standard&fl=" + solrFieldContainingEncodedMarcRecord2;
        if (verbose) {
            System.err.println("encoded document retrieval url = " + fullURLStr);
        }
        URL fullURL = null;
        try {
            fullURL = new URL(fullURLStr);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        BufferedReader sIn = null;
        try {
            sIn = new BufferedReader(new InputStreamReader(fullURL.openStream(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean numFound = false;
        String result = null;
        boolean count = false;
        try {
            String line;
            while ((line = sIn.readLine()) != null) {
                if (!line.contains(solrFieldContainingEncodedMarcRecord2 + "\":")) continue;
                if (line.contains("\"<?xml version")) {
                    result = line.replaceFirst(".*<\\?xml", "<?xml");
                    result = result.replaceFirst("</collection>.*", "</collection>");
                    result = result.replaceAll("\\\\\"", "\"");
                    continue;
                }
                if (line.contains(solrFieldContainingEncodedMarcRecord2 + "\":[\"{")) {
                    result = line.replaceFirst("[^:]*:\\[\"[{]", "{");
                    result = result.replaceFirst("\\\\n\"][}]]", "");
                    result = result.replaceAll("\\\\\"", "\"");
                    result = result.replace("\\\\", "\\");
                    continue;
                }
                result = line.replaceFirst("[^:]*:\"", "");
                result = result.replaceFirst("\"}]$", "");
                result = result.replaceAll("\\\\\"", "\"");
                result = result.replaceAll("\\\\t", "\t");
                result = result.replaceAll("\\\\\\\\", "\\\\");
                if ((result = this.normalizeUnicode(result)).getBytes("UTF-8").length == Integer.parseInt(result.substring(0, 5))) continue;
                result = result.replaceAll("\u001e\\P{InBasic_Latin}\\P{InBasic_Latin}\u001f", "\u001e  \u001f");
                result = result.replaceAll("\u001e\\P{InBasic_Latin}(\\p{InBasic_Latin})\u001f", "\u001e $1\u001f");
                result = result.replaceAll("\u001e(\\p{InBasic_Latin})\\P{InBasic_Latin}\u001f", "\u001e$1 \u001f");
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String normalizeUnicode(String string) {
        Pattern pattern = Pattern.compile("(\\\\u([0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]))|(#(29|30|31);)");
        Matcher matcher = pattern.matcher(string);
        StringBuffer result = new StringBuffer();
        int prevEnd = 0;
        while (matcher.find()) {
            result.append(string.substring(prevEnd, matcher.start()));
            result.append(this.getChar(matcher.group()));
            prevEnd = matcher.end();
        }
        result.append(string.substring(prevEnd));
        string = result.toString();
        return string;
    }

    private String getChar(String charCodePoint) {
        int charNum = charCodePoint.startsWith("\\u") ? Integer.parseInt(charCodePoint.substring(2), 16) : Integer.parseInt(charCodePoint.substring(1, 3));
        String result = "" + (char)charNum;
        return result;
    }

    public String[] getIdSet(String query) {
        int setSize = this.getIdSetSize(query);
        String[] resultSet = new String[setSize];
        String fullURLStr = this.solrBaseURL + "/select/?q=" + query + "&wt=json&qt=standard&indent=on&fl=id&start=0&rows=" + setSize;
        if (verbose) {
            System.err.println("Full URL for search = " + fullURLStr);
        }
        URL fullURL = null;
        try {
            fullURL = new URL(fullURLStr);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        BufferedReader sIn = null;
        try {
            sIn = new BufferedReader(new InputStreamReader(fullURL.openStream(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean numFound = false;
        int count = 0;
        try {
            String line;
            while ((line = sIn.readLine()) != null) {
                if (!line.contains("\"id\":")) continue;
                String id = line.replaceFirst(".*:[^\"]?\"([-A-Za-z0-9_]*).*", "$1");
                if (veryverbose) {
                    System.err.println("record num = " + count + "  id = " + id);
                }
                resultSet[count++] = id;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    public int getIdSetSize(String query) {
        String fullURLStr = this.solrBaseURL + "/select/?q=" + query + "&wt=json&qt=standard&indent=on&start=0&rows=0";
        if (verbose) {
            System.err.println("Full URL for search = " + fullURLStr);
        }
        URL fullURL = null;
        try {
            fullURL = new URL(fullURLStr);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        BufferedReader sIn = null;
        try {
            sIn = new BufferedReader(new InputStreamReader(fullURL.openStream(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int numFound = 0;
        try {
            String line;
            while ((line = sIn.readLine()) != null) {
                if (!line.contains("\"numFound\"")) continue;
                String numFoundStr = line.replaceFirst(".*numFound[^0-9]*([0-9]*).*", "$1");
                numFound = Integer.parseInt(numFoundStr);
                if (!verbose) continue;
                System.err.println("numFound = " + numFound);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return numFound;
    }

    private Record getRecordFromRawMarcUTF8(String marcRecordStr) {
        boolean tryAgain = false;
        do {
            try {
                tryAgain = false;
                MarcStreamReader reader = new MarcStreamReader(new ByteArrayInputStream(marcRecordStr.getBytes("UTF8")));
                if (reader.hasNext()) {
                    Record record = reader.next();
                    return record;
                }
            }
            catch (MarcException me) {
                me.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } while (tryAgain);
        return null;
    }

    private Record getRecordFromJsonString(String marcRecordStr) {
        boolean tryAgain = false;
        do {
            try {
                tryAgain = false;
                MarcJsonReader reader = new MarcJsonReader(new ByteArrayInputStream(marcRecordStr.getBytes("UTF8")));
                if (reader.hasNext()) {
                    Record record = reader.next();
                    return record;
                }
            }
            catch (MarcException me) {
                me.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } while (tryAgain);
        return null;
    }

    public Record getRecordFromXMLString(String marcRecordStr) {
        boolean tryAgain = false;
        do {
            try {
                tryAgain = false;
                MarcXmlReader reader = new MarcXmlReader(new ByteArrayInputStream(marcRecordStr.getBytes("UTF8")));
                if (reader.hasNext()) {
                    Record record = reader.next();
                    return record;
                }
            }
            catch (MarcException me) {
                try {
                    errOut = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File("badRecs.xml"))));
                    errOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><collection xmlns=\"http://www.loc.gov/MARC21/slim\">");
                }
                catch (FileNotFoundException e) {
                    System.err.println(e.getMessage());
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
                String trimmed = marcRecordStr.substring(marcRecordStr.indexOf("<record>"));
                trimmed = trimmed.replaceFirst("</collection>", "");
                trimmed = trimmed.replaceAll("><", ">\n<");
                try {
                    errOut.write(trimmed);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
                if (marcRecordStr.contains("<subfield code=\"&#31;\">")) {
                    marcRecordStr = marcRecordStr.replaceAll("<subfield code=\"&#31;\">(.)", "<subfield code=\"$1\">");
                    tryAgain = true;
                    continue;
                }
                if (this.extractLeader(marcRecordStr).contains("&#")) {
                    String leader = this.extractLeader(marcRecordStr).replaceAll("&#[0-9]+;", "0");
                    marcRecordStr = marcRecordStr.replaceAll("<leader>[^<]*</leader>", leader);
                    tryAgain = true;
                    continue;
                }
                me.printStackTrace();
                System.err.println("The bad record is: " + marcRecordStr);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e.getMessage());
            }
        } while (tryAgain);
        return null;
    }

    private String extractLeader(String marcRecordStr) {
        String leadertag1 = "<leader>";
        String leadertag2 = "</leader>";
        String leader = null;
        try {
            leader = marcRecordStr.substring(marcRecordStr.indexOf("<leader>"), marcRecordStr.indexOf("</leader>") + "</leader>".length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return leader;
    }

    public static void main(String[] args) {
        String baseURLStr = "http://localhost:8983/solr";
        String query = null;
        String maxRows = "20000";
        String field = "marc_display";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-vv")) {
                verbose = true;
                veryverbose = true;
                continue;
            }
            if (args[i].startsWith("http")) {
                baseURLStr = args[i];
                continue;
            }
            if (args[i].contains(":")) {
                query = args[i];
                continue;
            }
            field = args[i];
        }
        RemoteSolrSearcher searcher = new RemoteSolrSearcher(baseURLStr, query, field);
        searcher.handleAll();
        System.exit(0);
    }
}

