/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.marc4j.util.RawRecord;
import org.marc4j.util.RawRecordReader;
import org.marc4j.util.StringNaturalCompare;

public class MarcMerger {
    public static final String minRecordID = "0";
    public static final String maxRecordID = "zzzzzzzzzzzzzzzz";
    public static boolean verbose = false;
    public static boolean veryverbose = false;

    public static void main(String[] args) {
        RawRecordReader input0 = null;
        DataInputStream input1 = null;
        DataInputStream input3 = null;
        String segmentMinRecordID = minRecordID;
        String segmentMaxRecordID = maxRecordID;
        String newRecordsOut = null;
        int argoffset = 0;
        boolean mergeRecords = true;
        if (args[0].equals("-v")) {
            verbose = true;
            argoffset = 1;
        }
        if (args[0].equals("-vv")) {
            verbose = true;
            veryverbose = true;
            argoffset = 1;
        }
        if (args[0 + argoffset].equals("-min")) {
            segmentMinRecordID = args[1 + argoffset];
            argoffset += 2;
        }
        if (args[0 + argoffset].equals("-max")) {
            segmentMaxRecordID = args[1 + argoffset];
            argoffset += 2;
        }
        if (args[0 + argoffset].equals("-new")) {
            newRecordsOut = args[1 + argoffset];
            argoffset += 2;
        }
        if (args[0 + argoffset].endsWith(".del")) {
            mergeRecords = false;
            try {
                input1 = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(args[0 + argoffset]))));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            try {
                input0 = new RawRecordReader(new FileInputStream(new File(args[0 + argoffset])));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        try {
            RawRecordReader input2;
            String modfile = args[1 + argoffset];
            String delfile = null;
            boolean use_stdin = false;
            FileOutputStream newRecordsOutStream = null;
            if (modfile.equals("-")) {
                use_stdin = true;
            } else if (modfile.endsWith(".mrc")) {
                delfile = modfile.substring(0, modfile.length() - 4) + ".del";
            } else if (!modfile.substring(Math.max(modfile.lastIndexOf(92), modfile.lastIndexOf(47))).contains(".")) {
                delfile = modfile + ".del";
                modfile = modfile + ".mrc";
            }
            if (use_stdin) {
                input2 = new RawRecordReader(new BufferedInputStream(System.in));
            } else {
                input2 = new RawRecordReader(new FileInputStream(new File(modfile)));
                try {
                    input3 = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(delfile))));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (newRecordsOut != null) {
                try {
                    newRecordsOutStream = new FileOutputStream(new File(newRecordsOut));
                }
                catch (FileNotFoundException e) {
                    newRecordsOutStream = null;
                }
            }
            if (mergeRecords) {
                MarcMerger.processMergeRecords(input0, segmentMinRecordID, segmentMaxRecordID, input2, input3, System.out, newRecordsOutStream);
            } else {
                MarcMerger.processMergeDeletes(input1, input2, input3, System.out);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    static void processMergeRecords(RawRecordReader mainFile, String minID, String maxID, RawRecordReader newOrModified, DataInputStream deleted, OutputStream out, OutputStream newRecsOut) {
        StringNaturalCompare compare = new StringNaturalCompare();
        try {
            RawRecord mainrec = mainFile.hasNext() ? mainFile.next() : null;
            String segmentMinRecordID = minID;
            RawRecord newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
            String deletedId = maxRecordID;
            BufferedReader delReader = null;
            if (deleted != null) {
                delReader = new BufferedReader(new InputStreamReader(deleted));
                deletedId = MarcMerger.getNextDelId(delReader);
            }
            while (newOrModrec != null && compare.compare(newOrModrec.getRecordId(), segmentMinRecordID) < 0) {
                newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
            }
            while (compare.compare(deletedId, segmentMinRecordID) < 0) {
                deletedId = MarcMerger.getNextDelId(delReader);
            }
            while (mainrec != null && compare.compare(mainrec.getRecordId(), maxRecordID) < 0) {
                if ((newOrModrec == null || compare.compare(mainrec.getRecordId(), newOrModrec.getRecordId()) < 0) && compare.compare(mainrec.getRecordId(), deletedId) < 0) {
                    if (veryverbose) {
                        System.err.println("\nWriting original record " + mainrec.getRecordId() + " from input file");
                    }
                    out.write(mainrec.getRecordBytes());
                    out.flush();
                    mainrec = mainFile.hasNext() ? mainFile.next() : null;
                    continue;
                }
                if (newOrModrec != null && compare.compare(mainrec.getRecordId(), newOrModrec.getRecordId()) == 0 && compare.compare(mainrec.getRecordId(), deletedId) == 0) {
                    if (verbose) {
                        System.err.println("\nDeleting record " + deletedId);
                    }
                    deletedId = MarcMerger.getNextDelId(delReader);
                    newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
                    mainrec = mainFile.hasNext() ? mainFile.next() : null;
                    continue;
                }
                if ((newOrModrec == null || compare.compare(mainrec.getRecordId(), newOrModrec.getRecordId()) < 0) && compare.compare(mainrec.getRecordId(), deletedId) == 0) {
                    if (verbose) {
                        System.err.println("\nDeleting record " + deletedId);
                    }
                    deletedId = MarcMerger.getNextDelId(delReader);
                    mainrec = mainFile.hasNext() ? mainFile.next() : null;
                    continue;
                }
                if (newOrModrec != null && compare.compare(mainrec.getRecordId(), newOrModrec.getRecordId()) == 0 && compare.compare(mainrec.getRecordId(), deletedId) < 0) {
                    if (verbose) {
                        System.err.println("\nWriting changed record " + newOrModrec.getRecordId() + " from Mod file");
                    }
                    out.write(newOrModrec.getRecordBytes());
                    out.flush();
                    newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
                    mainrec = mainFile.hasNext() ? mainFile.next() : null;
                    continue;
                }
                if (newOrModrec != null && compare.compare(mainrec.getRecordId(), newOrModrec.getRecordId()) > 0 && compare.compare(newOrModrec.getRecordId(), deletedId) == 0) {
                    newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
                    deletedId = MarcMerger.getNextDelId(delReader);
                    continue;
                }
                if (newOrModrec != null && compare.compare(mainrec.getRecordId(), newOrModrec.getRecordId()) > 0) {
                    if (verbose) {
                        System.err.println("\nWriting new record " + newOrModrec.getRecordId() + " from mod file");
                    }
                    out.write(newOrModrec.getRecordBytes());
                    out.flush();
                    if (newRecsOut != null) {
                        newRecsOut.write(newOrModrec.getRecordBytes());
                        newRecsOut.flush();
                    }
                    RawRecord rawRecord = newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
                }
                if (compare.compare(mainrec.getRecordId(), deletedId) <= 0) continue;
                deletedId = MarcMerger.getNextDelId(delReader);
            }
            while (newOrModrec != null && compare.compare(newOrModrec.getRecordId(), maxRecordID) < 0 && compare.compare(newOrModrec.getRecordId(), maxID) < 0) {
                if (compare.compare(newOrModrec.getRecordId(), deletedId) == 0) {
                    newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
                    deletedId = MarcMerger.getNextDelId(delReader);
                    continue;
                }
                if (verbose) {
                    System.err.println("\nWriting record " + newOrModrec.getRecordId() + " from mod file");
                }
                out.write(newOrModrec.getRecordBytes());
                out.flush();
                newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void processMergeDeletes(DataInputStream mainFile, RawRecordReader newOrModified, DataInputStream deleted, PrintStream out) {
        StringNaturalCompare compare = new StringNaturalCompare();
        BufferedReader mainReader = new BufferedReader(new InputStreamReader(mainFile));
        String mainDelete = MarcMerger.getNextDelId(mainReader);
        RawRecord newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
        String deletedId = maxRecordID;
        BufferedReader delReader = null;
        if (deleted != null) {
            delReader = new BufferedReader(new InputStreamReader(deleted));
            deletedId = MarcMerger.getNextDelId(delReader);
        }
        while (compare.compare(mainDelete, maxRecordID) < 0) {
            if ((newOrModrec == null || compare.compare(mainDelete, newOrModrec.getRecordId()) < 0) && compare.compare(mainDelete, deletedId) < 0) {
                out.println(mainDelete);
                mainDelete = MarcMerger.getNextDelId(mainReader);
                continue;
            }
            if (newOrModrec != null && compare.compare(mainDelete, newOrModrec.getRecordId()) == 0 && compare.compare(mainDelete, deletedId) == 0) {
                if (verbose) {
                    System.err.println("Deleting record " + deletedId);
                }
                deletedId = MarcMerger.getNextDelId(delReader);
                newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
                out.println(mainDelete);
                mainDelete = MarcMerger.getNextDelId(mainReader);
                continue;
            }
            if ((newOrModrec == null || compare.compare(mainDelete, newOrModrec.getRecordId()) < 0) && compare.compare(mainDelete, deletedId) == 0) {
                if (verbose) {
                    System.err.println("Deleting record " + deletedId);
                }
                deletedId = MarcMerger.getNextDelId(delReader);
                out.println(mainDelete);
                mainDelete = MarcMerger.getNextDelId(mainReader);
                continue;
            }
            if (newOrModrec != null && compare.compare(mainDelete, newOrModrec.getRecordId()) == 0 && compare.compare(mainDelete, deletedId) < 0) {
                if (verbose) {
                    System.err.println("Record added, removing id from  " + newOrModrec.getRecordId() + " from Mod file");
                }
                newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
                mainDelete = MarcMerger.getNextDelId(mainReader);
                continue;
            }
            if (newOrModrec != null && compare.compare(mainDelete, newOrModrec.getRecordId()) > 0 && compare.compare(newOrModrec.getRecordId(), deletedId) == 0) {
                out.println(mainDelete);
                continue;
            }
            if (newOrModrec != null && compare.compare(mainDelete, newOrModrec.getRecordId()) > 0) {
                if (verbose) {
                    System.err.println("New record in mod file " + newOrModrec.getRecordId() + " skipping it.");
                }
                RawRecord rawRecord = newOrModrec = newOrModified.hasNext() ? newOrModified.next() : null;
            }
            if (compare.compare(mainDelete, deletedId) <= 0) continue;
            out.println(deletedId);
            deletedId = MarcMerger.getNextDelId(delReader);
        }
        while (compare.compare(deletedId, maxRecordID) < 0) {
            if (verbose) {
                System.err.println("Writing record " + newOrModrec.getRecordId() + " from mod file");
            }
            out.println(deletedId);
            deletedId = MarcMerger.getNextDelId(delReader);
        }
    }

    private static String getNextDelId(BufferedReader delReader) {
        if (delReader == null) {
            return maxRecordID;
        }
        String id = maxRecordID;
        try {
            String line = delReader.readLine();
            if (line != null) {
                id = line.replaceFirst("([-A-Za-z:._0-9]*).*", "$1");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return id;
    }
}

