/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

public class DiffColorize {
    public static ReturnStructure stringSimilarity(String s1, String s2, String h1s, String h1e, String h2s, String h2e, int maxOffset) {
        int c = 0;
        int offset1 = 0;
        int offset2 = 0;
        int lcs = 0;
        StringBuffer _s1 = new StringBuffer(s1.length() * 3);
        StringBuffer _s2 = new StringBuffer(s2.length() * 3);
        ReturnStructure return_struct = new ReturnStructure();
        if (s1.trim().length() == 0 && s2.trim().length() == 0) {
            return_struct.lcs = 0;
            return_struct.similarity = 1.0;
            return_struct.distance = 0;
            return_struct.s1 = "";
            return_struct.s2 = "";
            return return_struct;
        }
        if (s1.trim().length() > 0 && s2.trim().length() == 0) {
            return_struct.lcs = 0;
            return_struct.similarity = 0.0;
            return_struct.distance = s1.length();
            return_struct.s1 = h1s + s1 + h1e;
            return_struct.s2 = "";
            return return_struct;
        }
        if (s1.trim().length() == 0 && s2.trim().length() > 0) {
            return_struct.lcs = 0;
            return_struct.similarity = 0.0;
            return_struct.distance = s2.length();
            return_struct.s1 = "";
            return_struct.s2 = h2s + s2 + h2e;
            return return_struct;
        }
        while (c + offset1 < s1.length() && c + offset2 < s2.length()) {
            String next_s2;
            String next_s1 = DiffColorize.substring(s1, c + offset1, c == 0 ? 3 : 1);
            if (next_s1.compareTo(next_s2 = DiffColorize.substring(s2, c + offset2, c == 0 ? 3 : 1)) == 0) {
                ++lcs;
                _s1.append(DiffColorize.substring(next_s1, 0, 1));
                _s2.append(DiffColorize.substring(next_s2, 0, 1));
            } else {
                int old_offset1 = offset1;
                int old_offset2 = offset2;
                String _s1_deviation = "";
                String _s2_deviation = "";
                for (int i = 0; i < maxOffset; ++i) {
                    next_s1 = DiffColorize.substring(s1, c + offset1 + i, 3);
                    int len_next_s1 = next_s1.length();
                    String bookmarked_s1 = DiffColorize.substring(s1, c + offset1, 3);
                    next_s2 = DiffColorize.substring(s2, c + offset2 + i, 3);
                    int len_next_s2 = next_s2.length();
                    String bookmarked_s2 = DiffColorize.substring(s2, c + offset2, 3);
                    if (next_s1.length() == 0 && next_s2.length() == 0) break;
                    _s1_deviation = _s1_deviation + DiffColorize.substring(next_s1, 0, 1);
                    _s2_deviation = _s2_deviation + DiffColorize.substring(next_s2, 0, 1);
                    if (next_s1.equals(bookmarked_s2)) {
                        offset1 += i;
                        ++lcs;
                        break;
                    }
                    if (!next_s2.equals(bookmarked_s1)) continue;
                    offset2 += i;
                    ++lcs;
                    break;
                }
                int added_offset1 = offset1 - old_offset1;
                int added_offset2 = offset2 - old_offset2;
                if (added_offset1 == 0 && added_offset2 == 0) {
                    _s1.append(h1s).append(DiffColorize.substring(_s1_deviation, 0, added_offset1 + 1)).append(h1e);
                    _s2.append(h2s).append(DiffColorize.substring(_s2_deviation, 0, added_offset2 + 1)).append(h2e);
                } else if (added_offset1 == 0 && added_offset2 > 0) {
                    _s1.append(DiffColorize.substring(_s1_deviation, 0, 1));
                    _s2.append(h2s).append(DiffColorize.substring(_s2_deviation, 0, added_offset2)).append(h2e).append(DiffColorize.substring(_s2_deviation, _s2_deviation.length() - 1, _s2_deviation.length()));
                } else if (added_offset1 > 0 && added_offset2 == 0) {
                    _s1.append(h1s).append(DiffColorize.substring(_s1_deviation, 0, added_offset1)).append(h1e).append(DiffColorize.substring(_s1_deviation, _s1_deviation.length() - 1, _s1_deviation.length()));
                    _s2.append(DiffColorize.substring(_s2_deviation, 0, 1));
                }
            }
            ++c;
        }
        if (c + offset1 < s1.length()) {
            _s1.append(h1s).append(DiffColorize.substring(s1, s1.length() - (s1.length() - (c + offset1)), s1.length())).append(h1e);
        }
        if (c + offset2 < s2.length()) {
            _s2.append(h2s).append(DiffColorize.substring(s2, s2.length() - (s2.length() - (c + offset2)), s2.length())).append(h2e);
        }
        int distance = (s1.length() + s2.length()) / 2 - lcs;
        int maxLen = s1.length() > s2.length() ? s1.length() : s2.length();
        double similarity = maxLen == 0 ? 1.0 : (double)(1 - distance / maxLen);
        return_struct.lcs = lcs;
        return_struct.similarity = similarity;
        return_struct.distance = distance;
        return_struct.s1 = _s1.toString().replace(h1e + h1s, "").replace("[ESC]", "\u001b");
        return_struct.s2 = _s2.toString().replace(h2e + h2s, "").replace("[ESC]", "\u001b");
        return return_struct;
    }

    private static String substring(String str, int offset, int length) {
        if (offset >= str.length()) {
            return "";
        }
        if (offset + length >= str.length()) {
            return str.substring(offset);
        }
        return str.substring(offset, offset + length);
    }

    public static void main(String[] args) {
        ReturnStructure rs = DiffColorize.stringSimilarity("The rain in Spain stays mainly on the plains", "The rain in Madrid stays totally on the plains", "<<", ">>", "<<", ">>", 10);
        System.out.println(rs.s1);
        System.out.println(rs.s2);
    }

    static class ReturnStructure {
        int lcs = 0;
        double similarity = 0.0;
        int distance = 0;
        String s1;
        String s2;

        ReturnStructure() {
        }
    }
}

