/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.lang.reflect.Constructor;
import java.text.Normalizer;
import java.util.Hashtable;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.CodeTableTracker;
import org.marc4j.converter.impl.FixDoubleWidth;
import org.marc4j.converter.impl.ReverseCodeTable;
import org.marc4j.converter.impl.UnicodeUtils;
import org.marc4j.converter.impl.UnimarcCommon;
import org.marc4j.converter.impl.UnimarcConstants;
import org.marc4j.converter.impl.UnimarcReverseCodeTableHash;

public class UnicodeToUnimarc
extends CharConverter
implements UnimarcConstants {
    protected ReverseCodeTable rct;
    private CodeTableTracker defaultCodeTableTracker = new CodeTableTracker();
    private int workingG0;
    private int workingG1;
    protected boolean decomposeUnicode = false;

    public boolean shouldDecomposeUnicode() {
        return this.decomposeUnicode;
    }

    public void setDecomposeUnicode(boolean decomposeUnicode) {
        this.decomposeUnicode = decomposeUnicode;
    }

    public UnicodeToUnimarc() {
        this.rct = this.loadGeneratedTable();
        this.resetDefaultGX();
    }

    private ReverseCodeTable loadGeneratedTable() {
        try {
            Class<?> generated = Class.forName("org.marc4j.converter.impl.UnimarcReverseCodeTableGenerated");
            Constructor<?> cons = generated.getConstructor(new Class[0]);
            Object rct = cons.newInstance(new Object[0]);
            return (UnimarcReverseCodeTableHash)rct;
        }
        catch (Exception e) {
            return new UnimarcReverseCodeTableHash(this.getClass().getResourceAsStream("resources/unimarc.xml"));
        }
    }

    public void resetDefaultGX() {
        this.defaultCodeTableTracker.setPrevious((byte)0, 64);
        this.defaultCodeTableTracker.setPrevious((byte)1, 80);
        this.defaultCodeTableTracker.setPrevious((byte)2, 0);
        this.defaultCodeTableTracker.setPrevious((byte)3, 0);
    }

    public void setDefaultGX(String altG0Code, String altG1Code, String altG2Code, String altG3Code) {
        int iso = UnimarcCommon.determineCharSet(altG0Code);
        if (iso > 0) {
            this.defaultCodeTableTracker.setPrevious((byte)0, iso);
        }
        if ((iso = UnimarcCommon.determineCharSet(altG1Code)) > 0) {
            this.defaultCodeTableTracker.setPrevious((byte)1, iso);
        }
        if ((iso = UnimarcCommon.determineCharSet(altG2Code)) > 0) {
            this.defaultCodeTableTracker.setPrevious((byte)2, iso);
        }
        if ((iso = UnimarcCommon.determineCharSet(altG3Code)) > 0) {
            this.defaultCodeTableTracker.setPrevious((byte)3, iso);
        }
    }

    @Override
    public String convert(char[] dataElement) {
        char[] data;
        if (this.shouldDecomposeUnicode()) {
            data = Normalizer.normalize(new String(dataElement), Normalizer.Form.NFD).toCharArray();
            data = FixDoubleWidth.decomposeCombinedDoubleChar(data);
        } else {
            data = dataElement;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder marc = new StringBuilder();
        CodeTableTracker ctt = new CodeTableTracker(this.defaultCodeTableTracker);
        this.workingG0 = ctt.getPrevious((byte)0);
        this.workingG1 = ctt.getPrevious((byte)1);
        for (int i = 0; i < data.length; ++i) {
            char[] ch;
            Character c = Character.valueOf(data[i]);
            marc.setLength(0);
            Hashtable<Integer, char[]> h = this.rct.codeTableHash(c);
            if (h == null) {
                marc.append(this.unicodeToNCR(c, ctt));
            } else if (h.keySet().contains(this.workingG0)) {
                ch = h.get(this.workingG0);
                if (ch.length == 1 && ch[0] >= '\u0080') {
                    ch[0] = (char)(ch[0] - 128);
                }
                marc.append(ch);
            } else if (h.keySet().contains(this.workingG1)) {
                ch = h.get(this.workingG1);
                if (ch.length == 1 && ch[0] < '\u0080') {
                    ch[0] = (char)(ch[0] + 128);
                }
                marc.append(ch);
            } else if (h.keySet().contains(ctt.getPrevious((byte)0))) {
                ctt.makePreviousCurrent();
                marc.append('\u000f');
                this.workingG0 = ctt.getPrevious((byte)0);
                ch = h.get(this.workingG0);
                if (ch.length == 1 && ch[0] >= '\u0080') {
                    ch[0] = (char)(ch[0] - 128);
                }
                marc.append(ch);
            } else if (h.keySet().contains(ctt.getPrevious((byte)1))) {
                ctt.makePreviousCurrent();
                marc.append('\u001b');
                marc.append('~');
                this.workingG1 = ctt.getPrevious((byte)1);
                ch = h.get(ctt.getPrevious((byte)1));
                if (ch.length == 1 && ch[0] < '\u0080') {
                    ch[0] = (char)(ch[0] + 128);
                }
                marc.append(ch);
            } else if (ctt.getPrevious((byte)2) != null && h.keySet().contains(ctt.getPrevious((byte)2))) {
                ctt.makePreviousCurrent();
                marc.append('\u001b');
                marc.append('}');
                this.workingG1 = ctt.getPrevious((byte)2);
                ch = h.get(this.workingG1);
                if (ch.length == 1 && ch[0] < '\u0080') {
                    ch[0] = (char)(ch[0] + 128);
                }
                marc.append(ch);
            } else if (ctt.getPrevious((byte)3) != null && h.keySet().contains(ctt.getPrevious((byte)3))) {
                ctt.makePreviousCurrent();
                marc.append('\u001b');
                marc.append('|');
                this.workingG1 = ctt.getPrevious((byte)3);
                ch = h.get(this.workingG0);
                if (ch.length == 1 && ch[0] < '\u0080') {
                    ch[0] = (char)(ch[0] + 128);
                }
                marc.append(ch);
            } else {
                Integer table = h.keySet().iterator().next();
                char[] marc8 = h.get(table);
                if (marc8.length == 3) {
                    marc.append('\u001b');
                    marc.append('$');
                    marc.append(')');
                    marc.append((char)table.intValue());
                    marc.append('\u001b');
                    marc.append('~');
                    this.workingG1 = table;
                    ctt.setPrevious((byte)1, table);
                } else {
                    marc.append('\u001b');
                    marc.append(')');
                    marc.append((char)table.intValue());
                    marc.append('\u001b');
                    marc.append('~');
                    this.workingG1 = table;
                    ctt.setPrevious((byte)1, table);
                    if (marc8[0] < '\u0080') {
                        marc8[0] = (char)(marc8[0] + 128);
                    }
                }
                marc.append(marc8);
            }
            if (this.rct.isCombining(c) && sb.length() > 0) {
                sb.insert(sb.length() - 1, marc);
                continue;
            }
            sb.append((CharSequence)marc);
        }
        if (this.defaultCodeTableTracker.getPrevious((byte)3) != null && !this.defaultCodeTableTracker.getPrevious((byte)3).equals(ctt.getPrevious((byte)3))) {
            sb.append('\u001b');
            sb.append('/');
            sb.append((char)this.defaultCodeTableTracker.getPrevious((byte)3).intValue());
        }
        if (this.defaultCodeTableTracker.getPrevious((byte)2) != null && !this.defaultCodeTableTracker.getPrevious((byte)2).equals(ctt.getPrevious((byte)2))) {
            sb.append('\u001b');
            sb.append('.');
            sb.append((char)this.defaultCodeTableTracker.getPrevious((byte)2).intValue());
        }
        if (!this.defaultCodeTableTracker.getPrevious((byte)1).equals(ctt.getPrevious((byte)1))) {
            sb.append('\u001b');
            sb.append('-');
            sb.append((char)this.defaultCodeTableTracker.getPrevious((byte)1).intValue());
        }
        if (!this.defaultCodeTableTracker.getPrevious((byte)0).equals(ctt.getPrevious((byte)0))) {
            sb.append('\u001b');
            sb.append(',');
            sb.append((char)this.defaultCodeTableTracker.getPrevious((byte)0).intValue());
        }
        if (this.workingG1 != this.defaultCodeTableTracker.getPrevious((byte)1)) {
            sb.append('\u001b');
            sb.append('~');
        }
        if (this.workingG0 != this.defaultCodeTableTracker.getPrevious((byte)0)) {
            sb.append('\u000f');
        }
        return sb.toString();
    }

    private String unicodeToNCR(Character ch, CodeTableTracker currentTracker) {
        String ncr = UnicodeUtils.convertUnicodeToNCR(ch);
        UnicodeToUnimarc converter = new UnicodeToUnimarc();
        converter.defaultCodeTableTracker.setPrevious((byte)0, currentTracker.getPrevious((byte)0));
        converter.defaultCodeTableTracker.setPrevious((byte)1, currentTracker.getPrevious((byte)1));
        converter.defaultCodeTableTracker.setPrevious((byte)2, currentTracker.getPrevious((byte)2));
        converter.defaultCodeTableTracker.setPrevious((byte)3, currentTracker.getPrevious((byte)3));
        StringBuilder sb = new StringBuilder();
        if (this.workingG0 != currentTracker.getPrevious((byte)0)) {
            sb.append('\u000f');
        }
        if (this.workingG1 != currentTracker.getPrevious((byte)1)) {
            sb.append('\u001b');
            sb.append('~');
        }
        sb.append(converter.convert(ncr));
        this.workingG0 = converter.workingG0;
        this.workingG1 = converter.workingG1;
        return sb.toString();
    }
}

