/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.Normalizer;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.converter.impl.CodeTableTracker;
import org.marc4j.converter.impl.FixDoubleWidth;
import org.marc4j.converter.impl.ReverseCodeTable;
import org.marc4j.converter.impl.ReverseCodeTableHash;
import org.marc4j.converter.impl.UnicodeUtils;

public class UnicodeToAnsel
extends CharConverter {
    protected ReverseCodeTable rct;
    static final char ESC = '\u001b';
    static final char G0 = '(';
    static final char G0multibyte = '$';
    static final char G1 = ')';
    static final int ASCII = 66;
    static final int ANSEL = 69;
    private CodeTableTracker defaultCodeTableTracker = new CodeTableTracker();
    boolean dontChangeCharset = false;
    protected boolean decomposeUnicode = false;

    public boolean shouldDecomposeUnicode() {
        return this.decomposeUnicode;
    }

    public void setDecomposeUnicode(boolean decomposeUnicode) {
        this.decomposeUnicode = decomposeUnicode;
    }

    public UnicodeToAnsel() {
        this.rct = this.loadGeneratedTable();
    }

    public UnicodeToAnsel(boolean defaultCharsetOnlyPlusNCR) {
        this.dontChangeCharset = true;
        this.rct = this.loadGeneratedTable();
    }

    public UnicodeToAnsel(String pathname) {
        this.rct = new ReverseCodeTableHash(pathname);
    }

    public UnicodeToAnsel(InputStream in) {
        this.rct = new ReverseCodeTableHash(in);
    }

    private ReverseCodeTable loadGeneratedTable() {
        try {
            Class<?> generated = Class.forName("org.marc4j.converter.impl.ReverseCodeTableGenerated");
            Constructor<?> cons = generated.getConstructor(new Class[0]);
            Object rct = cons.newInstance(new Object[0]);
            return (ReverseCodeTable)rct;
        }
        catch (Exception e) {
            ReverseCodeTableHash rct = new ReverseCodeTableHash(AnselToUnicode.class.getResourceAsStream("resources/codetables.xml"));
            return rct;
        }
    }

    public void resetDefaultG0AndG1() {
        this.defaultCodeTableTracker.setPrevious((byte)0, 66);
        this.defaultCodeTableTracker.setPrevious((byte)1, 69);
    }

    public void setDefaultG0AndG1(String altG0Code, String altG1Code) {
        char ch;
        if (altG0Code != null && altG0Code.length() > 0) {
            ch = altG0Code.charAt(altG0Code.length() - 1);
            this.defaultCodeTableTracker.setPrevious((byte)0, Integer.valueOf(ch));
        }
        if (altG1Code != null && altG1Code.length() > 0) {
            ch = altG1Code.charAt(altG1Code.length() - 1);
            this.defaultCodeTableTracker.setPrevious((byte)1, Integer.valueOf(ch));
        }
    }

    @Override
    public String convert(char[] dataElement) {
        char[] data;
        if (this.shouldDecomposeUnicode()) {
            data = Normalizer.normalize(new String(dataElement), Normalizer.Form.NFD).toCharArray();
            data = FixDoubleWidth.decomposeCombinedDoubleChar(data);
        } else {
            data = dataElement;
        }
        StringBuilder sb = new StringBuilder();
        this.rct.init();
        this.convertPortion(data, sb);
        if (this.rct.getPreviousG0() != 66) {
            sb.append('\u001b');
            sb.append('(');
            sb.append('B');
        }
        return sb.toString();
    }

    private void convertPortion(char[] data, StringBuilder sb) {
        int prev_len = 1;
        StringBuilder marc = new StringBuilder();
        CodeTableTracker ctt = new CodeTableTracker(this.defaultCodeTableTracker);
        for (int i = 0; i < data.length; ++i) {
            Character c = Character.valueOf(data[i]);
            marc.setLength(0);
            char charValue = c.charValue();
            if (charValue == ' ' && this.rct.getPreviousG0() != 49) {
                if (this.rct.getPreviousG0() == 49) {
                    sb.append('\u001b');
                    sb.append('(');
                    sb.append('B');
                    this.rct.setPreviousG0(66);
                }
                marc.append(" ");
            } else if (!this.rct.charHasMatch(c)) {
                String tmpnorm = c.toString();
                String tmpNormed = Normalizer.normalize(tmpnorm, Normalizer.Form.NFD);
                if (!tmpNormed.equals(tmpnorm)) {
                    String firstTwo;
                    String partialNormed;
                    if (UnicodeToAnsel.allCharsHaveMatch(this.rct, tmpNormed)) {
                        this.convertPortion(tmpNormed.toCharArray(), sb);
                        continue;
                    }
                    if (tmpNormed.length() > 2 && !(partialNormed = Normalizer.normalize(firstTwo = tmpNormed.substring(0, 2), Normalizer.Form.NFC)).equals(firstTwo) && UnicodeToAnsel.allCharsHaveMatch(this.rct, partialNormed) && UnicodeToAnsel.allCharsHaveMatch(this.rct, tmpNormed.substring(2))) {
                        this.convertPortion((partialNormed + tmpNormed.substring(2)).toCharArray(), sb);
                        continue;
                    }
                }
                if (this.rct.getPreviousG0() != 66) {
                    sb.append('\u001b');
                    sb.append('(');
                    sb.append('B');
                    this.rct.setPreviousG0(66);
                }
                marc.append(this.unicodeToNCR(c, ctt));
            } else if (this.rct.inPreviousG0CharEntry(c)) {
                marc.append(this.rct.getCurrentG0CharEntry(c));
                ctt.makePreviousCurrent();
            } else if (this.rct.inPreviousG1CharEntry(c)) {
                marc.append(this.rct.getCurrentG1CharEntry(c));
                ctt.makePreviousCurrent();
            } else if (this.dontChangeCharset) {
                marc.append(UnicodeUtils.convertUnicodeToNCR(c));
            } else if (this.rct.codeTableHash(c).keySet().contains(ctt.getPrevious((byte)1))) {
                ctt.makePreviousCurrent();
                char[] ch = this.rct.getCharEntry(c, ctt.getPrevious((byte)1));
                if (ch.length == 1 && ch[0] < '\u0080') {
                    ch[0] = (char)(ch[0] + 128);
                }
                marc.append(ch);
            } else {
                char charset = this.rct.getBestCharSet(c);
                char[] marc8 = this.rct.getCharEntry(c, charset);
                if (marc8.length == 3) {
                    marc.append('\u001b');
                    marc.append('$');
                    this.rct.setPreviousG0(charset);
                    ctt.setPrevious((byte)0, Integer.valueOf(charset));
                } else if (marc8[0] < '\u0080') {
                    marc.append('\u001b');
                    if (charset != 'b' && charset != 'p') {
                        marc.append('(');
                    }
                    this.rct.setPreviousG0(charset);
                    ctt.setPrevious((byte)0, Integer.valueOf(charset));
                } else {
                    marc.append('\u001b');
                    marc.append(')');
                    this.rct.setPreviousG1(charset);
                    ctt.setPrevious((byte)1, Integer.valueOf(charset));
                }
                marc.append(charset);
                marc.append(marc8);
            }
            if (this.rct.isCombining(c) && sb.length() > 0) {
                sb.insert(sb.length() - prev_len, marc);
                if (c.charValue() == '\u0360') {
                    sb.append('\u00fb');
                }
                if (c.charValue() == '\u0361') {
                    sb.append('\u00ec');
                }
            } else {
                sb.append((CharSequence)marc);
            }
            prev_len = marc.length();
        }
        if (ctt.getPrevious((byte)1).intValue() != this.defaultCodeTableTracker.getPrevious((byte)1).intValue()) {
            sb.append('\u001b');
            sb.append(')');
            sb.append((char)this.defaultCodeTableTracker.getPrevious((byte)1).intValue());
        }
        if (ctt.getPrevious((byte)0).intValue() != this.defaultCodeTableTracker.getPrevious((byte)0).intValue()) {
            sb.append('\u001b');
            sb.append('(');
            sb.append((char)this.defaultCodeTableTracker.getPrevious((byte)0).intValue());
        }
    }

    private static boolean allCharsHaveMatch(ReverseCodeTable rct, String str) {
        for (char c : str.toCharArray()) {
            if (rct.charHasMatch(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    private String unicodeToNCR(Character ch, CodeTableTracker currentTracker) {
        String ncr = UnicodeUtils.convertUnicodeToNCR(ch);
        UnicodeToAnsel converter = new UnicodeToAnsel();
        converter.defaultCodeTableTracker.setPrevious((byte)0, currentTracker.getPrevious((byte)0));
        converter.defaultCodeTableTracker.setPrevious((byte)1, currentTracker.getPrevious((byte)1));
        return converter.convert(ncr);
    }
}

