/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.callnum;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marc4j.callnum.AbstractCallNumber;
import org.marc4j.callnum.Utils;

public class LCCallNumber
extends AbstractCallNumber {
    protected String classification;
    protected String classLetters;
    protected String classDigits;
    protected String classDecimal;
    protected String classSuffix;
    protected String cutter;
    protected String shelfKey;
    protected String paddedShelfKey;
    public static final String CLASS_REGEX = "^([a-zA-Z]+) *(?:(\\d+)(\\.\\d+)?)?";
    public static final String CUTTER_REGEX = "[A-Za-z]\\d+";
    protected static Pattern classPattern = Pattern.compile("(^([a-zA-Z]+) *(?:(\\d+)(\\.\\d+)?)?)(.*)$");
    protected static Pattern cutterPat = Pattern.compile("([A-Za-z]\\d+)");
    protected static Pattern cutterAfterSuffixPat = Pattern.compile("(\\.?[A-Za-z]\\d+|^\\.[A-Za-z]| \\.[A-Za-z])");

    public LCCallNumber(String rawCallNumber) {
        this.parse(rawCallNumber);
    }

    public LCCallNumber() {
    }

    public String getClassification() {
        return this.classification;
    }

    public String getClassLetters() {
        return this.classLetters;
    }

    public String getClassDigits() {
        return this.classDigits;
    }

    public String getClassDecimal() {
        return this.classDecimal;
    }

    public String getClassNumber() {
        String digits = this.classDigits == null ? "" : this.classDigits;
        String decimal = this.classDecimal == null ? "" : this.classDecimal;
        return digits + decimal;
    }

    public String getClassSuffix() {
        return this.classSuffix;
    }

    public String getCutter() {
        return this.cutter;
    }

    protected void init() {
        this.rawCallNum = null;
        this.classification = null;
        this.classLetters = null;
        this.classDigits = null;
        this.classDecimal = null;
        this.classSuffix = null;
        this.cutter = null;
        this.shelfKey = null;
        this.paddedShelfKey = null;
    }

    @Override
    public void parse(String call) {
        this.init();
        this.rawCallNum = call == null ? null : call.trim();
        this.parse();
    }

    protected void parse() {
        if (this.rawCallNum != null) {
            this.parseCallNumber();
        }
    }

    protected void parseCallNumber() {
        String everythingElse = null;
        Matcher mClass = classPattern.matcher(this.rawCallNum);
        if (mClass.matches()) {
            this.classification = mClass.group(1) == null ? null : mClass.group(1).trim();
            this.classLetters = mClass.group(2) == null ? null : mClass.group(2).trim();
            this.classDigits = mClass.group(3) == null ? null : mClass.group(3).trim();
            this.classDecimal = mClass.group(4) == null ? null : mClass.group(4).trim();
            everythingElse = mClass.group(5) == null ? null : mClass.group(5).trim();
            everythingElse = mClass.group(5).length() < 1 ? null : everythingElse;
        } else {
            everythingElse = this.rawCallNum;
        }
        this.cutter = null;
        if (everythingElse != null) {
            Matcher mCut = cutterAfterSuffixPat.matcher(everythingElse);
            if (mCut.find()) {
                int start = mCut.start(1);
                this.classSuffix = start > 0 ? everythingElse.substring(0, start).trim() : null;
                this.cutter = everythingElse.substring(mCut.start(1)).trim();
            } else {
                this.classSuffix = everythingElse.trim();
            }
            if (this.classSuffix != null && this.classSuffix.length() == 0) {
                this.classSuffix = null;
            }
            if (this.classSuffix != null) {
                this.classification = this.classification != null ? this.classification + " " + this.classSuffix : this.classSuffix;
            }
        }
    }

    protected void buildShelfKey() {
        int i;
        char last;
        StringBuilder key = new StringBuilder();
        if (this.classLetters != null) {
            key.append(this.classLetters.toUpperCase());
        }
        if (this.classDigits != null) {
            if (key.length() > 0) {
                key.append(' ');
            }
            key.append(this.classDigits.length());
            key.append(this.classDigits);
        }
        if (this.classDecimal != null) {
            key.append(this.classDecimal);
        }
        if (this.classSuffix != null) {
            if (key.length() > 0) {
                key.append(' ');
                if (Character.isAlphabetic(this.classSuffix.charAt(0))) {
                    key.append('_');
                }
            }
            Utils.appendNumericallySortable(key, this.classSuffix.toUpperCase());
        }
        if (this.cutter != null) {
            LCCallNumber.appendCutterShelfKey(key, this.cutter.toUpperCase());
        }
        if (key.length() > 0 && (last = key.charAt(i = key.length() - 1)) == ' ') {
            key.deleteCharAt(i);
        }
        this.shelfKey = key.toString();
    }

    protected void buildPaddedShelfKey() {
        int i;
        char last;
        StringBuilder key = new StringBuilder();
        if (this.classLetters != null) {
            key.append(this.classLetters.toUpperCase());
            key.append("   ".substring(this.classLetters.length()));
        }
        if (this.classDigits != null) {
            if (key.length() > 0) {
                key.append(' ');
            }
            key.append(this.classDigits.length() < 4 ? "0000".substring(this.classDigits.length()) : "");
            key.append(this.classDigits);
        }
        if (this.classDecimal != null) {
            key.append(this.classDecimal);
            key.append(this.classDecimal.length() < 7 ? "000000".substring(this.classDecimal.length() - 1) : "");
        } else {
            key.append(".000000");
        }
        if (this.classSuffix != null) {
            if (key.length() > 0) {
                key.append(' ');
                if (Character.isAlphabetic(this.classSuffix.charAt(0))) {
                    key.append('_');
                }
            }
            Utils.appendNumericallySortable(key, this.classSuffix.toUpperCase());
        }
        if (this.cutter != null) {
            LCCallNumber.appendPaddedCutterShelfKey(key, this.cutter.toUpperCase());
        }
        if (key.length() > 0 && (last = key.charAt(i = key.length() - 1)) == ' ') {
            key.deleteCharAt(i);
        }
        this.paddedShelfKey = key.toString();
    }

    protected static void appendCutterShelfKey(StringBuilder keyBuf, CharSequence cutter) {
        Matcher m = cutterPat.matcher(cutter);
        LCCallNumber.appendCutterShelfKeyLoop(keyBuf, cutter, m, 0);
    }

    protected static void appendPaddedCutterShelfKey(StringBuilder keyBuf, CharSequence cutter) {
        Matcher m = cutterPat.matcher(cutter);
        LCCallNumber.appendPaddedCutterShelfKeyLoop(keyBuf, cutter, m, 0);
    }

    protected static void appendCutterShelfKeyLoop(StringBuilder keyBuf, CharSequence cutter, Matcher m, int offset) {
        if (offset >= cutter.length()) {
            return;
        }
        if (m.find(offset)) {
            CharSequence previousCutterSuffix = cutter.subSequence(offset, m.start());
            CharSequence matchSeq = cutter.subSequence(m.start(), m.end());
            if (keyBuf.length() > 0 && keyBuf.charAt(keyBuf.length() - 1) != ' ') {
                keyBuf.append(' ');
            }
            Utils.appendNumericallySortable(keyBuf, previousCutterSuffix);
            if (keyBuf.length() > 0 && keyBuf.charAt(keyBuf.length() - 1) != ' ') {
                keyBuf.append(' ');
            }
            keyBuf.append(matchSeq);
            LCCallNumber.appendCutterShelfKeyLoop(keyBuf, cutter, m, m.end());
        } else {
            if (keyBuf.length() > 0 && keyBuf.charAt(keyBuf.length() - 1) != ' ') {
                keyBuf.append(' ');
            }
            Utils.appendNumericallySortable(keyBuf, cutter.subSequence(offset, cutter.length()));
        }
    }

    protected static void appendPaddedCutterShelfKeyLoop(StringBuilder keyBuf, CharSequence cutter, Matcher m, int offset) {
        if (offset >= cutter.length()) {
            return;
        }
        if (m.find(offset)) {
            CharSequence previousCutterSuffix = cutter.subSequence(offset, m.start());
            CharSequence matchSeq = cutter.subSequence(m.start(), m.end());
            if (keyBuf.length() > 0 && keyBuf.charAt(keyBuf.length() - 1) != ' ') {
                keyBuf.append(' ');
            }
            Utils.appendNumericallySortable(keyBuf, previousCutterSuffix);
            if (keyBuf.length() > 0 && keyBuf.charAt(keyBuf.length() - 1) != ' ') {
                keyBuf.append(' ');
            }
            LCCallNumber.appendCutterPadded(keyBuf, matchSeq);
            LCCallNumber.appendPaddedCutterShelfKeyLoop(keyBuf, cutter, m, m.end());
        } else {
            if (keyBuf.length() > 0 && keyBuf.charAt(keyBuf.length() - 1) != ' ') {
                keyBuf.append(' ');
            }
            Utils.appendNumericallySortable(keyBuf, cutter.subSequence(offset, cutter.length()));
        }
    }

    private static void appendCutterPadded(StringBuilder keyBuf, CharSequence cutter) {
        int offset = 0;
        while (Character.isAlphabetic(cutter.charAt(offset))) {
            keyBuf.append(cutter.charAt(offset));
            ++offset;
        }
        CharSequence number = cutter.subSequence(offset, cutter.length());
        keyBuf.append("0.").append(number).append(number.length() < 6 ? "000000".substring(number.length()) : "");
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.classLetters == null) {
            valid = false;
        } else {
            char firstChar = this.classLetters.charAt(0);
            if (firstChar == 'I' || firstChar == 'O' || firstChar == 'W' || firstChar == 'X' || firstChar == 'Y') {
                valid = false;
            }
        }
        if (this.classDigits == null) {
            valid = false;
        }
        return valid;
    }

    @Override
    public String getShelfKey() {
        if (this.shelfKey == null) {
            this.buildShelfKey();
        }
        return this.shelfKey;
    }

    public String getPaddedShelfKey() {
        if (this.paddedShelfKey == null) {
            this.buildPaddedShelfKey();
        }
        return this.paddedShelfKey;
    }

    public String toString() {
        StringBuilder formatted = new StringBuilder();
        if (this.classLetters != null) {
            formatted.append(this.classLetters);
        }
        if (this.classDigits != null) {
            formatted.append(this.classDigits);
        }
        if (this.classDecimal != null) {
            formatted.append(this.classDecimal);
        }
        if (this.classSuffix != null) {
            if (formatted.length() > 0) {
                formatted.append(' ');
            }
            formatted.append(this.classSuffix);
        }
        if (this.cutter != null) {
            formatted.append(" ");
            if (this.isValid() && this.cutter.charAt(0) != '.') {
                formatted.append('.');
            }
            formatted.append(this.cutter);
        }
        return formatted.toString();
    }
}

