/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.marc4j.MarcException;
import org.marc4j.RecordStack;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MarcXmlHandler
implements ContentHandler {
    private final RecordStack queue;
    private StringBuffer sb;
    private Subfield subfield;
    private ControlField controlField;
    private DataField dataField;
    private Record record;
    private String tag;
    private String prev_tag = "n/a";
    private static final int COLLECTION_ID = 1;
    private static final int LEADER_ID = 2;
    private static final int RECORD_ID = 3;
    private static final int CONTROLFIELD_ID = 4;
    private static final int DATAFIELD_ID = 5;
    private static final int SUBFIELD_ID = 6;
    private static final String TAG_ATTR = "tag";
    private static final String CODE_ATTR = "code";
    private static final String IND_1_ATTR = "ind1";
    private static final String IND_2_ATTR = "ind2";
    private static final String TYPE_ATTR = "type";
    private static final Set<String> RECORD_TYPES;
    private static final Map<String, Integer> ELEMENTS;
    private MarcFactory factory = null;

    public MarcXmlHandler(RecordStack queue) {
        this.queue = queue;
        this.factory = MarcFactory.newInstance();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        String realname = name.length() == 0 ? qName : name;
        Integer elementType = ELEMENTS.get(this.stripNsPrefix(realname));
        if (elementType == null) {
            if (this.record != null) {
                this.record.addError("n/a", "n/a", 2, "Unexpected XML element: " + realname);
                return;
            }
            throw new MarcException("Unexpected XML element: " + realname);
        }
        switch (elementType) {
            case 1: {
                break;
            }
            case 3: {
                String typeAttr = atts.getValue(TYPE_ATTR);
                this.record = this.factory.newRecord();
                if (typeAttr != null && RECORD_TYPES.contains(typeAttr)) {
                    this.record.setType(typeAttr);
                }
                this.prev_tag = "n/a";
                break;
            }
            case 2: {
                this.sb = new StringBuffer();
                break;
            }
            case 4: {
                this.tag = atts.getValue(TAG_ATTR);
                if (this.tag == null) {
                    if (this.record != null) {
                        this.record.addError("n/a", "n/a", 2, "Missing tag element in ControlField after tag: " + this.prev_tag);
                        break;
                    }
                    throw new MarcException("ControlField missing tag value, found outside a record element");
                }
                this.controlField = this.factory.newControlField(this.tag);
                this.sb = new StringBuffer();
                break;
            }
            case 5: {
                this.tag = atts.getValue(TAG_ATTR);
                if (this.tag == null) {
                    if (this.record != null) {
                        this.record.addError("n/a", "n/a", 2, "Missing tag element in datafield after tag: " + this.prev_tag);
                        break;
                    }
                    throw new MarcException("DataField missing tag value, found outside a record element");
                }
                String ind1 = atts.getValue(IND_1_ATTR);
                String ind2 = atts.getValue(IND_2_ATTR);
                if (ind1 == null) {
                    if (this.record != null) {
                        this.record.addError(this.tag, "n/a", 2, "DataField (" + this.tag + ") missing first indicator");
                        break;
                    }
                    throw new MarcException("DataField (" + this.tag + ") missing first indicator, found outside a record element");
                }
                if (ind2 == null) {
                    if (this.record != null) {
                        this.record.addError(this.tag, "n/a", 2, "DataField (" + this.tag + ") missing second indicator");
                        break;
                    }
                    throw new MarcException("DataField (" + this.tag + ") missing second indicator, found outside a record element");
                }
                if (ind1.length() == 0) {
                    ind1 = " ";
                }
                if (ind2.length() == 0) {
                    ind2 = " ";
                }
                this.dataField = this.factory.newDataField(this.tag, ind1.charAt(0), ind2.charAt(0));
                break;
            }
            case 6: {
                String code = atts.getValue(CODE_ATTR);
                if (code == null) {
                    if (this.record != null) {
                        this.record.addError(this.tag, "n/a", 2, "Subfield (" + this.tag + ") missing code attribute");
                        break;
                    }
                    throw new MarcException("Subfield in DataField (" + this.tag + ") missing code attribute");
                }
                if (code.length() == 0) {
                    code = " ";
                }
                this.subfield = this.factory.newSubfield(code.charAt(0));
                this.sb = new StringBuffer();
            }
        }
        this.prev_tag = this.tag;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.sb != null) {
            this.sb.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        String realname = name.length() == 0 ? qName : name;
        Integer elementType = ELEMENTS.get(this.stripNsPrefix(realname));
        if (elementType == null) {
            if (this.record != null) {
                return;
            }
            throw new MarcException("Unexpected XML element: " + realname);
        }
        switch (elementType) {
            case 1: {
                break;
            }
            case 3: {
                this.queue.push(this.record);
                break;
            }
            case 2: {
                Leader leader = this.factory.newLeader(this.sb.toString());
                this.record.setLeader(leader);
                break;
            }
            case 4: {
                if (this.controlField == null) break;
                this.controlField.setData(this.sb.toString());
                this.record.addVariableField(this.controlField);
                this.controlField = null;
                break;
            }
            case 5: {
                if (this.dataField == null) break;
                this.record.addVariableField(this.dataField);
                this.dataField = null;
                break;
            }
            case 6: {
                if (this.dataField == null || this.subfield == null) break;
                this.subfield.setData(this.sb.toString());
                this.dataField.addSubfield(this.subfield);
                this.subfield = null;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.queue.end();
    }

    @Override
    public void ignorableWhitespace(char[] data, int offset, int length) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private String stripNsPrefix(String aName) {
        int index = aName.indexOf(":");
        if (index == -1 || index + 1 == aName.length()) {
            return aName;
        }
        return aName.substring(index + 1);
    }

    static {
        ELEMENTS = new HashMap<String, Integer>();
        ELEMENTS.put("collection", new Integer(1));
        ELEMENTS.put("leader", new Integer(2));
        ELEMENTS.put("record", new Integer(3));
        ELEMENTS.put("controlfield", new Integer(4));
        ELEMENTS.put("datafield", new Integer(5));
        ELEMENTS.put("subfield", new Integer(6));
        RECORD_TYPES = new HashSet<String>();
        RECORD_TYPES.add("Bibliographic");
        RECORD_TYPES.add("Authority");
        RECORD_TYPES.add("Holdings");
        RECORD_TYPES.add("Classification");
        RECORD_TYPES.add("Community");
    }
}

