/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import org.marc4j.MarcException;
import org.marc4j.MarcWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.util.CustomDecimalFormat;

public class MarcStreamWriter
implements MarcWriter {
    protected OutputStream out = null;
    public static final String ENCODING_FOR_DIR_ENTRIES = "ISO8859_1";
    public static final String ENCODING_BY_CHAR_CODE = "per_record";
    protected String encoding = "ISO8859_1";
    protected String encodingCurrent;
    private CharConverter converter = null;
    protected boolean allowOversizeEntry = false;
    protected boolean hasOversizeOffset = false;
    protected boolean hasOversizeLength = false;
    protected static DecimalFormat format4Use = new CustomDecimalFormat(4);
    protected static DecimalFormat format5Use = new CustomDecimalFormat(5);

    public MarcStreamWriter(OutputStream out) {
        this.out = out;
    }

    public MarcStreamWriter(OutputStream out, String encoding) {
        this.encoding = encoding;
        this.out = out;
    }

    public MarcStreamWriter(OutputStream out, boolean allowOversizeRecord) {
        this.out = out;
        this.allowOversizeEntry = allowOversizeRecord;
    }

    public MarcStreamWriter(OutputStream out, String encoding, boolean allowOversizeRecord) {
        this.encoding = encoding;
        this.out = out;
        this.allowOversizeEntry = allowOversizeRecord;
    }

    @Override
    public CharConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(CharConverter converter) {
        this.converter = converter;
    }

    protected void setEncodingCurrent(Record record, CharConverter converter) {
        Leader ldr = record.getLeader();
        if (converter != null) {
            ldr.setCharCodingScheme(converter.outputsUnicode() ? (char)'a' : ' ');
        }
        this.encodingCurrent = this.encoding.equals(ENCODING_BY_CHAR_CODE) ? (ldr.getCharCodingScheme() == 'a' ? "UTF-8" : ENCODING_FOR_DIR_ENTRIES) : this.encoding;
    }

    @Override
    public void write(Record record) {
        this.setEncodingCurrent(record, this.converter);
        int previous = 0;
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            ByteArrayOutputStream dir = new ByteArrayOutputStream();
            this.hasOversizeOffset = false;
            this.hasOversizeLength = false;
            for (ControlField cf : record.getControlFields()) {
                data.write(this.getDataElement(cf.getData()));
                data.write(30);
                dir.write(this.getEntry(cf.getTag(), data.size() - previous, previous));
                previous = data.size();
            }
            for (DataField df : record.getDataFields()) {
                data.write(df.getIndicator1());
                data.write(df.getIndicator2());
                for (Subfield sf : df.getSubfields()) {
                    data.write(31);
                    data.write(sf.getCode());
                    data.write(this.getDataElement(sf.getData()));
                }
                data.write(30);
                dir.write(this.getEntry(df.getTag(), data.size() - previous, previous));
                previous = data.size();
            }
            dir.write(30);
            Leader ldr = record.getLeader();
            int baseAddress = 24 + dir.size();
            ldr.setBaseAddressOfData(baseAddress);
            int recordLength = ldr.getBaseAddressOfData() + data.size() + 1;
            ldr.setRecordLength(recordLength);
            dir.close();
            data.close();
            if (!this.allowOversizeEntry && (baseAddress > 99999 || recordLength > 99999 || this.hasOversizeOffset)) {
                throw new MarcException("Record is too long to be a valid MARC binary record, it's length would be " + recordLength + " which is more thatn 99999 bytes");
            }
            if (!this.allowOversizeEntry && this.hasOversizeLength) {
                throw new MarcException("Record has field that is too long to be a valid MARC binary record. The maximum length for a field counting all of the sub-fields is 9999 bytes.");
            }
            this.writeLeader(ldr);
            this.out.write(dir.toByteArray());
            this.out.write(data.toByteArray());
            this.out.write(29);
        }
        catch (IOException e) {
            throw new MarcException("IO Error occured while writing record", e);
        }
        catch (MarcException e) {
            throw e;
        }
    }

    protected void writeLeader(Leader ldr) throws IOException {
        String leaderEncoding = ENCODING_FOR_DIR_ENTRIES;
        this.out.write(format5Use.format(ldr.getRecordLength()).getBytes(leaderEncoding));
        this.out.write(ldr.getRecordStatus());
        this.out.write(ldr.getTypeOfRecord());
        this.out.write(new String(ldr.getImplDefined1()).getBytes(leaderEncoding));
        this.out.write(ldr.getCharCodingScheme());
        this.out.write(Integer.toString(ldr.getIndicatorCount()).getBytes(leaderEncoding));
        this.out.write(Integer.toString(ldr.getSubfieldCodeLength()).getBytes(leaderEncoding));
        this.out.write(format5Use.format(ldr.getBaseAddressOfData()).getBytes(leaderEncoding));
        this.out.write(new String(ldr.getImplDefined2()).getBytes(leaderEncoding));
        this.out.write(new String(ldr.getEntryMap()).getBytes(leaderEncoding));
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new MarcException("IO Error occured on close", e);
        }
    }

    protected byte[] getDataElement(String data) throws IOException {
        if (this.converter != null) {
            return this.converter.convert(data).getBytes(this.encodingCurrent);
        }
        return data.getBytes(this.encodingCurrent);
    }

    protected byte[] getEntry(String tag, int length, int start) throws IOException {
        String entryUse = tag + format4Use.format(length) + format5Use.format(start);
        if (length > 99999) {
            this.hasOversizeLength = true;
        }
        if (start > 99999) {
            this.hasOversizeOffset = true;
        }
        return entryUse.getBytes(ENCODING_FOR_DIR_ENTRIES);
    }

    public boolean allowsOversizeEntry() {
        return this.allowOversizeEntry;
    }

    public void setAllowOversizeEntry(boolean allowOversizeEntry) {
        this.allowOversizeEntry = allowOversizeEntry;
    }
}

