/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.marc4j.MarcCombiningReader;
import org.marc4j.MarcFilteredReader;
import org.marc4j.MarcJsonReader;
import org.marc4j.MarcMultiplexReader;
import org.marc4j.MarcPermissiveStreamReader;
import org.marc4j.MarcReader;
import org.marc4j.MarcReaderConfig;
import org.marc4j.MarcScriptedRecordEditReader;
import org.marc4j.MarcTranslatedReader;
import org.marc4j.MarcUnprettyXmlReader;
import org.marc4j.Mrk8StreamReader;
import org.marc4j.util.FileFinderUtil;

public class MarcReaderFactory {
    private MarcReaderFactory() {
    }

    public static MarcReader makeReader(MarcReaderConfig config, String[] searchDirectories, String ... inputFilenames) throws IOException {
        if (inputFilenames.length == 0) {
            return MarcReaderFactory.makeReader(config, searchDirectories, "stdin");
        }
        if (inputFilenames.length == 1) {
            return MarcReaderFactory.makeReader(config, searchDirectories, inputFilenames[0]);
        }
        ArrayList<MarcReader> readers = new ArrayList<MarcReader>();
        for (String inputFilename : inputFilenames) {
            MarcReader reader = MarcReaderFactory.makeReaderPart(config, inputFilename);
            readers.add(reader);
        }
        MarcReader result = new MarcMultiplexReader(readers, Arrays.asList(inputFilenames));
        result = MarcReaderFactory.decorateMarcReader(result, config, searchDirectories);
        return result;
    }

    public static MarcReader makeReader(MarcReaderConfig config, String[] searchDirectories, List<String> inputFilenames) throws IOException {
        if (inputFilenames.size() == 0) {
            return MarcReaderFactory.makeReader(config, searchDirectories, "stdin");
        }
        if (inputFilenames.size() == 1) {
            return MarcReaderFactory.makeReader(config, searchDirectories, inputFilenames.iterator().next());
        }
        ArrayList<MarcReader> readers = new ArrayList<MarcReader>();
        for (String inputFilename : inputFilenames) {
            MarcReader reader = MarcReaderFactory.makeReaderPart(config, inputFilename);
            readers.add(reader);
        }
        MarcReader result = new MarcMultiplexReader(readers, inputFilenames);
        result = MarcReaderFactory.decorateMarcReader(result, config, searchDirectories);
        return result;
    }

    public static MarcReader makeReader(MarcReaderConfig config, String[] searchDirectories, String inputFilename) throws IOException {
        BufferedInputStream is = inputFilename.equals("-") || inputFilename.equals("stdin") ? new BufferedInputStream(System.in) : new BufferedInputStream(new FileInputStream(inputFilename));
        MarcReader reader = MarcReaderFactory.makeReaderInternal(config, is);
        reader = MarcReaderFactory.decorateMarcReader(reader, config, searchDirectories);
        return reader;
    }

    private static MarcReader makeReaderPart(MarcReaderConfig config, String inputFilename) throws IOException {
        FileInputStream is = new FileInputStream(inputFilename);
        MarcReader reader = MarcReaderFactory.makeReaderInternal(config, is);
        return reader;
    }

    public static MarcReader makeReader(MarcReaderConfig config, InputStream input) throws IOException {
        MarcReader reader = MarcReaderFactory.makeReaderInternal(config, input);
        reader = MarcReaderFactory.decorateMarcReader(reader, config, new String[]{"."});
        return reader;
    }

    private static MarcReader makeReaderInternal(MarcReaderConfig config, InputStream input) throws IOException {
        MarcReader reader;
        int numRead;
        boolean inputTypeXML = false;
        boolean inputTypeBinary = false;
        boolean inputTypeJSON = false;
        boolean inputTypeMrk8 = false;
        InputStream is = input.markSupported() ? input : new BufferedInputStream(input);
        is.mark(30);
        byte[] buffer = new byte[25];
        try {
            numRead = is.read(buffer);
            is.reset();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Fatal error: Exception reading from InputStream");
        }
        String filestart = new String(buffer);
        inputTypeXML = false;
        inputTypeBinary = false;
        inputTypeJSON = false;
        if (numRead == -1 || filestart.length() == 0) {
            inputTypeBinary = true;
        } else if (filestart.substring(0, 5).equalsIgnoreCase("<?xml")) {
            inputTypeXML = true;
        } else if (filestart.startsWith("{")) {
            inputTypeJSON = true;
        } else if (filestart.substring(0, 5).matches("\\d\\d\\d\\d\\d")) {
            inputTypeBinary = true;
        } else if (filestart.contains("<?xml") || filestart.contains("<?XML")) {
            inputTypeXML = true;
        } else if (filestart.contains("<collection")) {
            inputTypeXML = true;
        } else if (filestart.matches("[^<]*<[^:>]+:collection[ >].*")) {
            inputTypeXML = true;
        } else if (filestart.contains("<record")) {
            inputTypeXML = true;
        } else if (filestart.matches("[^<]*<[^:>]+:record[ >].*")) {
            inputTypeXML = true;
        } else if (filestart.contains("<!--")) {
            inputTypeXML = true;
        } else if (filestart.contains("=LDR  ")) {
            inputTypeMrk8 = true;
        }
        if (inputTypeXML) {
            reader = new MarcUnprettyXmlReader(is);
        } else if (inputTypeJSON) {
            reader = new MarcJsonReader(is);
        } else if (inputTypeMrk8) {
            reader = new Mrk8StreamReader(is, config.toUtf8());
        } else if (inputTypeBinary) {
            reader = new MarcPermissiveStreamReader(is, config.isPermissiveReader(), config.toUtf8(), config.getDefaultEncoding());
        } else {
            throw new IllegalArgumentException("Fatal error: Unable to determine type of inputfile.  File starts with: " + filestart);
        }
        return reader;
    }

    public static MarcReader decorateMarcReader(MarcReader r, MarcReaderConfig config, String[] searchDirectories) throws IOException {
        MarcReader reader = r;
        if (reader != null && config.getCombineConsecutiveRecordsFields() != null) {
            reader = new MarcCombiningReader(reader, config.getCombineConsecutiveRecordsFields(), config.getCombineRecordsLeftField(), config.getCombineRecordsRightField());
        }
        if (reader != null && config.shouldFilter()) {
            reader = new MarcFilteredReader(reader, config.getIncludeIfPresent(), config.getIncludeIfMissing());
        }
        String marcDeleteSubfields = config.getDeleteSubfieldSpec();
        String marcRemapRecord = config.getMarcRemapFilename();
        if (reader != null && (marcDeleteSubfields != null || marcRemapRecord != null)) {
            if (marcRemapRecord != null) {
                InputStream remapInputStream = FileFinderUtil.getFileInputStream(searchDirectories, marcRemapRecord);
                Properties remapProps = new Properties();
                remapProps.load(remapInputStream);
                reader = new MarcScriptedRecordEditReader(reader, marcDeleteSubfields, remapProps);
            } else if (marcDeleteSubfields != null) {
                reader = new MarcScriptedRecordEditReader(reader, marcDeleteSubfields, null);
            }
        }
        if (reader != null && config.toUtf8() && config.getUnicodeNormalize() != null) {
            reader = new MarcTranslatedReader(reader, config.getUnicodeNormalize());
        }
        return reader;
    }
}

