/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.ArrayList;
import java.util.List;
import org.marc4j.ErrorHandler;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;

public class MarcCombiningReader
implements MarcReader {
    Record currentRecord = null;
    Record nextRecord = null;
    MarcReader reader;
    String idsToMerge = null;
    String leftControlField = null;
    String rightControlField = null;

    public MarcCombiningReader(MarcReader reader, String idsToMerge, String leftControlField, String rightControlField) {
        this.reader = reader;
        this.idsToMerge = idsToMerge;
        this.leftControlField = leftControlField;
        this.rightControlField = rightControlField;
    }

    @Deprecated
    public MarcCombiningReader(MarcReader reader, ErrorHandler currentErrors, ErrorHandler nextErrors, String idsToMerge, String leftControlField, String rightControlField) {
        this.reader = reader;
        this.idsToMerge = idsToMerge;
        this.leftControlField = leftControlField;
        this.rightControlField = rightControlField;
    }

    @Override
    public boolean hasNext() {
        if (this.currentRecord == null) {
            this.currentRecord = this.next();
        }
        return this.currentRecord != null;
    }

    @Override
    public Record next() {
        if (this.currentRecord != null) {
            Record tmp = this.currentRecord;
            this.currentRecord = null;
            return tmp;
        }
        if (this.currentRecord == null) {
            if (this.nextRecord != null) {
                this.currentRecord = this.nextRecord;
                this.nextRecord = null;
            }
            if (!this.reader.hasNext()) {
                return this.currentRecord != null ? this.next() : null;
            }
            try {
                this.nextRecord = this.reader.next();
            }
            catch (Exception e) {
                if (this.currentRecord != null) {
                    String recCntlNum = this.currentRecord.getControlNumber();
                    throw new MarcException("Couldn't get next record after " + (recCntlNum != null ? recCntlNum : "") + " -- " + e.toString());
                }
                throw new MarcException("Marc record couldn't be read -- " + e.toString());
            }
            while (this.recordsMatch(this.currentRecord, this.nextRecord)) {
                this.currentRecord = MarcCombiningReader.combineRecords(this.currentRecord, this.nextRecord, this.idsToMerge);
                if (this.reader.hasNext()) {
                    try {
                        this.nextRecord = this.reader.next();
                        continue;
                    }
                    catch (Exception e) {
                        String recCntlNum = this.currentRecord.getControlNumber();
                        throw new MarcException("Couldn't get next record after " + (recCntlNum != null ? recCntlNum : "") + " -- " + e.toString());
                    }
                }
                this.nextRecord = null;
            }
            return this.next();
        }
        return null;
    }

    private String findControlField(Record record, String tag) {
        String tagstart = tag.substring(0, 3);
        List<VariableField> fields = record.getVariableFields(tagstart);
        for (VariableField field : fields) {
            Subfield sf;
            DataField df;
            if (field instanceof ControlField) {
                ControlField cf = (ControlField)field;
                if (!cf.getTag().matches(tagstart)) continue;
                return cf.getData();
            }
            if (!(field instanceof DataField) || !(df = (DataField)field).getTag().matches(tagstart)) continue;
            char subfieldtag = 'a';
            if (tag.length() > 3) {
                subfieldtag = tag.charAt(4);
            }
            if ((sf = df.getSubfield(subfieldtag)) == null) continue;
            return sf.getData();
        }
        return null;
    }

    private boolean recordsMatch(Record left, Record right) {
        if (left == null || right == null) {
            return false;
        }
        String leftStr = null;
        String rightStr = null;
        leftStr = this.leftControlField == null ? left.getControlNumber() : this.findControlField(left, this.leftControlField);
        rightStr = this.rightControlField == null ? right.getControlNumber() : this.findControlField(right, this.rightControlField);
        return leftStr != null && rightStr != null && leftStr.equals(rightStr);
    }

    public static Record combineRecords(Record currentRecord, Record nextRecord, String idsToMerge) {
        List<VariableField> fields = nextRecord.getVariableFields();
        boolean unique = false;
        if (idsToMerge.startsWith("unique")) {
            unique = true;
        }
        for (VariableField field : fields) {
            if (!field.getTag().matches(idsToMerge)) continue;
            boolean add = true;
            if (unique) {
                List<VariableField> existingFields = currentRecord.getVariableFields();
                for (VariableField evf : existingFields) {
                    if (!evf.getTag().equals(field.getTag()) || !evf.toString().equals(field.toString())) continue;
                    add = false;
                }
            }
            if (!add) continue;
            currentRecord.addVariableField(field);
        }
        if (nextRecord.hasErrors()) {
            currentRecord.addErrors(nextRecord.getErrors());
        }
        return currentRecord;
    }

    public static Record combineRecords(Record currentRecord, Record nextRecord, String idsToMerge, String fieldInsertBefore) {
        List<VariableField> existingFields = currentRecord.getVariableFields();
        ArrayList<VariableField> fieldsToMove = new ArrayList<VariableField>();
        for (VariableField field : existingFields) {
            if (!field.getTag().matches(fieldInsertBefore)) continue;
            fieldsToMove.add(field);
            currentRecord.removeVariableField(field);
        }
        List<VariableField> fields = nextRecord.getVariableFields();
        for (VariableField field : fields) {
            if (!field.getTag().matches(idsToMerge)) continue;
            currentRecord.addVariableField(field);
        }
        for (VariableField field : fieldsToMove) {
            currentRecord.addVariableField(field);
        }
        if (nextRecord.hasErrors()) {
            currentRecord.addErrors(nextRecord.getErrors());
        }
        return currentRecord;
    }
}

