/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen.tokenizers;

import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.Token;
import java.util.LinkedList;
import java.util.List;

public class BufferedTokenizer
implements Tokenizer {
    protected final Tokenizer _tokenizer;
    protected final List<Token> _tokens = new LinkedList<Token>();

    public BufferedTokenizer(Tokenizer tokenizer) {
        this._tokenizer = tokenizer;
        Token t = this._tokenizer.getToken();
        if (t != null) {
            this._tokens.add(t);
        }
    }

    public Token getToken(int lookahead) {
        while (lookahead >= this._tokens.size() && this.getMore()) {
        }
        return lookahead < this._tokens.size() ? this._tokens.get(lookahead) : null;
    }

    public Token getToken() {
        return this.getToken(0);
    }

    public void next(int count) {
        while (count > 0 && (this._tokens.size() > 0 || this.getMore())) {
            this._tokens.remove(0);
            --count;
        }
    }

    public void next() {
        this.next(1);
    }

    public int lookOverWhitespaceAndComment(int lookahead) {
        Token t;
        while ((t = this.getToken(lookahead)) != null && (t.type == Token.Type.Whitespace || t.type == Token.Type.Comment)) {
            ++lookahead;
        }
        return lookahead;
    }

    protected boolean getMore() {
        this._tokenizer.next();
        Token t = this._tokenizer.getToken();
        if (t != null) {
            this._tokens.add(t);
            return true;
        }
        return false;
    }
}

