/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.tupletable;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.base.record.RecordMapper;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.lib.TupleLib;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdFactory;
import org.apache.jena.tdb2.store.tupletable.TupleIndexBase;

public class TupleIndexRecord
extends TupleIndexBase {
    private static final boolean Check = false;
    private final RangeIndex index;
    private final RecordFactory factory;
    private final RecordMapper<Tuple<NodeId>> recordMapper;

    public TupleIndexRecord(int N, TupleMap tupleMapping, String name, RecordFactory factory, RangeIndex index) {
        super(N, tupleMapping, name);
        this.factory = factory;
        this.index = index;
        if (factory.keyLength() != N * 8) {
            throw new TDBException(String.format("Mismatch: TupleIndex of length %d is not comparative with a factory for key length %d", N, factory.keyLength()));
        }
        int keyLen = factory.keyLength();
        int numNodeIds = factory.keyLength() / 8;
        this.recordMapper = (bb, entryIdx, key, recFactory) -> {
            int bbStart = entryIdx * recFactory.recordLength();
            if (key != null) {
                bb.position(bbStart);
                bb.get(key, 0, keyLen);
            }
            Object[] nodeIds = new NodeId[numNodeIds];
            for (int i = 0; i < numNodeIds; ++i) {
                int j = i;
                if (this.tupleMap != null) {
                    j = this.tupleMap.unmapIdx(i);
                }
                NodeId id = NodeIdFactory.get(bb, bbStart + j * 8);
                nodeIds[i] = id;
            }
            return TupleFactory.create((Object[])nodeIds);
        };
    }

    @Override
    protected void performAdd(Tuple<NodeId> tuple) {
        Record r = TupleLib.record(this.factory, tuple, this.tupleMap);
        this.index.insert(r);
    }

    @Override
    protected void performDelete(Tuple<NodeId> tuple) {
        Record r = TupleLib.record(this.factory, tuple, this.tupleMap);
        this.index.delete(r);
    }

    @Override
    public void addAll(Collection<Tuple<NodeId>> tuples) {
        for (Tuple<NodeId> t : tuples) {
            this.add(t);
        }
    }

    @Override
    public void deleteAll(Collection<Tuple<NodeId>> tuples) {
        for (Tuple<NodeId> t : tuples) {
            this.delete(t);
        }
    }

    @Override
    protected Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> pattern) {
        return this.findOrScan(pattern);
    }

    final Iterator<Tuple<NodeId>> findOrScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, true);
    }

    final Iterator<Tuple<NodeId>> findOrPartialScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, false);
    }

    final Iterator<Tuple<NodeId>> findByIndex(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, false, false);
    }

    private Iterator<Tuple<NodeId>> findWorker(Tuple<NodeId> patternNaturalOrder, boolean partialScanAllowed, boolean fullScanAllowed) {
        Iterator<Tuple<NodeId>> tuples;
        NodeId X;
        Tuple pattern = this.tupleMap.map(patternNaturalOrder);
        int numSlots = 0;
        int leadingIdx = -2;
        boolean leading = true;
        Record minRec = this.factory.createKeyOnly();
        Record maxRec = this.factory.createKeyOnly();
        for (int i = 0; i < pattern.len(); ++i) {
            X = (NodeId)pattern.get(i);
            if (NodeId.isAny(X)) {
                X = null;
                leading = false;
                continue;
            }
            ++numSlots;
            if (!leading) continue;
            leadingIdx = i;
            NodeIdFactory.set(X, minRec.getKey(), i * 8);
            NodeIdFactory.set(X, maxRec.getKey(), i * 8);
        }
        if (numSlots == pattern.len()) {
            if (this.index.contains(minRec)) {
                return new SingletonIterator((Object)pattern);
            }
            return new NullIterator();
        }
        if (leadingIdx < 0) {
            if (!fullScanAllowed) {
                return null;
            }
            tuples = this.index.iterator(null, null, this.recordMapper);
        } else {
            X = (NodeId)pattern.get(leadingIdx);
            NodeIdFactory.setNext(X, maxRec.getKey(), leadingIdx * 8);
            tuples = this.index.iterator(minRec, maxRec, this.recordMapper);
        }
        if (leadingIdx < numSlots - 1) {
            if (!partialScanAllowed) {
                return null;
            }
            tuples = this.scan(tuples, patternNaturalOrder);
        }
        return tuples;
    }

    @Override
    public Iterator<Tuple<NodeId>> all() {
        return this.index.iterator(null, null, this.recordMapper);
    }

    private Iterator<Tuple<NodeId>> scan(Iterator<Tuple<NodeId>> iter, Tuple<NodeId> pattern) {
        Predicate<Tuple> filter = item -> {
            for (int i = 0; i < this.tupleLength; ++i) {
                NodeId n = (NodeId)pattern.get(i);
                if (NodeId.isAny(n) || ((NodeId)item.get(i)).equals(n)) continue;
                return false;
            }
            return true;
        };
        return Iter.filter(iter, filter);
    }

    public void close() {
        this.index.close();
    }

    public void sync() {
        this.index.sync();
    }

    public final RangeIndex getRangeIndex() {
        return this.index;
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    @Override
    public long size() {
        return this.index.size();
    }

    private /* synthetic */ Tuple lambda$all$2(Record item) {
        return TupleLib.tuple(item, this.tupleMap);
    }

    private /* synthetic */ Tuple lambda$findWorker$1(Record item) {
        return TupleLib.tuple(item, this.tupleMap);
    }
}

