/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.CharMatchScore;
import com.wcohen.ss.MemoMatrix;
import com.wcohen.ss.api.StringWrapper;

public class AffineGap
extends AbstractStringDistance {
    private CharMatchScore charMatchScore;
    private double openGapScore;
    private double extendGapScore;
    private double lowerBound;

    public AffineGap() {
        this(CharMatchScore.DIST_21, 2.0, 1.0, -1.7976931348623157E308);
    }

    public AffineGap(CharMatchScore charMatchScore, double openGapScore, double extendGapScore, double lowerBound) {
        this.charMatchScore = charMatchScore;
        this.openGapScore = openGapScore;
        this.extendGapScore = extendGapScore;
        this.lowerBound = lowerBound;
    }

    @Override
    public double score(StringWrapper s, StringWrapper t) {
        MatrixTrio mat = new MatrixTrio(s, t);
        return this.score(s, t, mat);
    }

    private double score(StringWrapper s, StringWrapper t, MatrixTrio mat) {
        double best = -1.7976931348623157E308;
        for (int i = 0; i <= s.length(); ++i) {
            for (int j = 0; j <= t.length(); ++j) {
                best = Math.max(best, mat.get(i, j));
            }
        }
        return best;
    }

    @Override
    public String explainScore(StringWrapper s, StringWrapper t) {
        MatrixTrio mat = new MatrixTrio(s, t);
        double d = this.score(s, t, mat);
        return mat.toString() + "\nScore = " + d;
    }

    public static void main(String[] argv) {
        AffineGap.doMain(new AffineGap(), argv);
    }

    protected class MatrixTrio
    extends MemoMatrix {
        protected MemoMatrix m;
        protected InsertSMatrix is;
        protected InsertTMatrix it;

        public MatrixTrio(StringWrapper s, StringWrapper t) {
            super(s, t);
            this.is = new InsertSMatrix(s, t);
            this.it = new InsertTMatrix(s, t);
            this.m = this;
        }

        @Override
        public double compute(int i, int j) {
            if (i == 0 || j == 0) {
                return 0.0;
            }
            double matchScore = AffineGap.this.charMatchScore.matchScore(this.sAt(i), this.tAt(j));
            double d = this.m.get(i - 1, j - 1) + matchScore;
            double d2 = this.is.get(i - 1, j - 1) + matchScore;
            i = 1;
            return MatrixTrio.max4(AffineGap.this.lowerBound, d, d2, this.it.get(1, j - 1) + matchScore);
        }

        protected class InsertTMatrix
        extends MemoMatrix {
            public InsertTMatrix(StringWrapper s, StringWrapper t) {
                super(s, t);
            }

            @Override
            public double compute(int i, int j) {
                if (i == 0 || j == 0) {
                    return 0.0;
                }
                return InsertTMatrix.max3(AffineGap.this.lowerBound, MatrixTrio.this.m.get(i, j - 1) + AffineGap.this.openGapScore, MatrixTrio.this.it.get(i, j - 1) + AffineGap.this.extendGapScore);
            }
        }

        protected class InsertSMatrix
        extends MemoMatrix {
            public InsertSMatrix(StringWrapper s, StringWrapper t) {
                super(s, t);
            }

            @Override
            public double compute(int i, int j) {
                if (i == 0 || j == 0) {
                    return 0.0;
                }
                return InsertSMatrix.max3(AffineGap.this.lowerBound, MatrixTrio.this.m.get(i - 1, j) + AffineGap.this.openGapScore, MatrixTrio.this.is.get(i - 1, j) + AffineGap.this.extendGapScore);
            }
        }
    }
}

