/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class GitRepositoryState {
    public final String tags;
    public final String branch;
    public final String dirty;
    public final String remoteOriginUrl;
    public final String commitId;
    public final String commitIdAbbrev;
    public final String describe;
    public final String describeShort;
    public final String commitUserName;
    public final String commitUserEmail;
    public final String commitMessageFull;
    public final String commitMessageShort;
    public final String commitTime;
    public final String closestTagName;
    public final String closestTagCommitCount;
    public final String buildUserName;
    public final String buildUserEmail;
    public final String buildTime;
    public final String buildHost;
    public final String buildVersion;

    public static GitRepositoryState getGitRepositoryState(String resourceName) throws IOException {
        InputStream resourceAsStream = GitRepositoryState.class.getClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            throw new IOException("Resource not found: " + resourceName);
        }
        return GitRepositoryState.getGitRepositoryState(resourceAsStream);
    }

    private static GitRepositoryState getGitRepositoryState(InputStream resource) throws IOException {
        if (resource == null) {
            throw new NullPointerException();
        }
        Properties properties = new Properties();
        properties.load(resource);
        return new GitRepositoryState(properties);
    }

    public GitRepositoryState(Properties properties) {
        this.tags = GitRepositoryState.valueToString(properties.get("git.tags"));
        this.branch = GitRepositoryState.valueToString(properties.get("git.branch"));
        this.dirty = GitRepositoryState.valueToString(properties.get("git.dirty"));
        this.remoteOriginUrl = GitRepositoryState.valueToString(properties.get("git.remote.origin.url"));
        String commitId = GitRepositoryState.valueToString(properties.get("git.commit.id.full"));
        if (commitId == null) {
            commitId = GitRepositoryState.valueToString(properties.get("git.commit.id"));
        }
        this.commitId = commitId;
        this.commitIdAbbrev = GitRepositoryState.valueToString(properties.get("git.commit.id.abbrev"));
        this.describe = GitRepositoryState.valueToString(properties.get("git.commit.id.describe"));
        this.describeShort = GitRepositoryState.valueToString(properties.get("git.commit.id.describe-short"));
        this.commitUserName = GitRepositoryState.valueToString(properties.get("git.commit.user.name"));
        this.commitUserEmail = GitRepositoryState.valueToString(properties.get("git.commit.user.email"));
        this.commitMessageFull = GitRepositoryState.valueToString(properties.get("git.commit.message.full"));
        this.commitMessageShort = GitRepositoryState.valueToString(properties.get("git.commit.message.short"));
        this.commitTime = GitRepositoryState.valueToString(properties.get("git.commit.time"));
        this.closestTagName = GitRepositoryState.valueToString(properties.get("git.closest.tag.name"));
        this.closestTagCommitCount = GitRepositoryState.valueToString(properties.get("git.closest.tag.commit.count"));
        this.buildUserName = GitRepositoryState.valueToString(properties.get("git.build.user.name"));
        this.buildUserEmail = GitRepositoryState.valueToString(properties.get("git.build.user.email"));
        this.buildTime = GitRepositoryState.valueToString(properties.get("git.build.time"));
        this.buildHost = GitRepositoryState.valueToString(properties.get("git.build.host"));
        this.buildVersion = GitRepositoryState.valueToString(properties.get("git.build.version"));
    }

    private static String valueToString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public String getTags() {
        return this.tags;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getDirty() {
        return this.dirty;
    }

    public String getRemoteOriginUrl() {
        return this.remoteOriginUrl;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getCommitIdAbbrev() {
        return this.commitIdAbbrev;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getDescribeShort() {
        return this.describeShort;
    }

    public String getCommitUserName() {
        return this.commitUserName;
    }

    public String getCommitUserEmail() {
        return this.commitUserEmail;
    }

    public String getCommitMessageFull() {
        return this.commitMessageFull;
    }

    public String getCommitMessageShort() {
        return this.commitMessageShort;
    }

    public String getCommitTime() {
        return this.commitTime;
    }

    public String getClosestTagName() {
        return this.closestTagName;
    }

    public String getClosestTagCommitCount() {
        return this.closestTagCommitCount;
    }

    public String getBuildUserName() {
        return this.buildUserName;
    }

    public String getBuildUserEmail() {
        return this.buildUserEmail;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public String getBuildHost() {
        return this.buildHost;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }
}

