/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.ComparisonException;
import de.fau.cs.osr.utils.DeepComparerDelegate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class DeepComparer {
    private static final MapComparerDelegate MAP_DELEGATE = new MapComparerDelegate();
    private static final CollectionComparerDelegate COLLECTION_DELEGATE = new CollectionComparerDelegate();
    private static final ArrayComparerDelegate ARRAY_DELEGATE = new ArrayComparerDelegate();
    private final ArrayList<DeepComparerDelegate> delegates = new ArrayList();

    public static void compareAndThrow(Object rootA, Object rootB) throws ComparisonException {
        new DeepComparer().compare(rootA, rootB);
    }

    public static boolean compareNoThrow(Object rootA, Object rootB) {
        try {
            new DeepComparer().compare(rootA, rootB);
            return true;
        }
        catch (ComparisonException e) {
            return false;
        }
    }

    public DeepComparer() {
        this.addDefaultCollectionComparer();
        this.addDefaultMapComparer();
        this.addDefaultArrayComparer();
    }

    public DeepComparer(DeepComparerDelegate comparer0, DeepComparerDelegate ... comparersN) {
        this();
        this.delegates.add(comparer0);
        for (DeepComparerDelegate c : comparersN) {
            this.delegates.add(c);
        }
    }

    public void dropAllComparers() {
        this.delegates.clear();
    }

    public void addComparer(DeepComparerDelegate comparer) {
        this.delegates.add(0, comparer);
    }

    public void addDefaultMapComparer() {
        this.addComparer(MAP_DELEGATE);
    }

    public void addDefaultCollectionComparer() {
        this.addComparer(COLLECTION_DELEGATE);
    }

    public void addDefaultArrayComparer() {
        this.addComparer(ARRAY_DELEGATE);
    }

    public void compare(Object a, Object b) throws ComparisonException {
        if (a == b) {
            return;
        }
        if (a == null != (b == null)) {
            throw new ComparisonException(a, b);
        }
        int size = this.delegates.size();
        for (int i = 0; i < size; ++i) {
            DeepComparerDelegate delegate = this.delegates.get(i);
            if (!delegate.compare(a, b, this)) continue;
            return;
        }
        if (!a.equals(b)) {
            a.equals(b);
            throw new ComparisonException(a, b);
        }
    }

    public static class MapComparerDelegate
    implements DeepComparerDelegate {
        @Override
        public boolean compare(Object _a, Object _b, DeepComparer comparer) throws ComparisonException {
            if (!(_a instanceof Map) || !(_b instanceof Map)) {
                return false;
            }
            Map a = (Map)_a;
            Map b = (Map)_b;
            if (b.size() != a.size()) {
                throw new ComparisonException(a, b);
            }
            for (Map.Entry e : a.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null) {
                    if (b.get(key) == null && b.containsKey(key)) continue;
                    throw new ComparisonException(a, b);
                }
                comparer.compare(value, b.get(key));
            }
            return true;
        }
    }

    public static class CollectionComparerDelegate
    implements DeepComparerDelegate {
        @Override
        public boolean compare(Object _a, Object _b, DeepComparer comparer) throws ComparisonException {
            if (!(_a instanceof Collection) || !(_b instanceof Collection)) {
                return false;
            }
            Collection a = (Collection)_a;
            Collection b = (Collection)_b;
            Iterator e1 = a.iterator();
            Iterator e2 = b.iterator();
            while (e1.hasNext() && e2.hasNext()) {
                Object o2;
                Object o1 = e1.next();
                if (o1 == null != ((o2 = e2.next()) == null)) {
                    throw new ComparisonException(a, b);
                }
                comparer.compare(o1, o2);
            }
            if (e1.hasNext() || e2.hasNext()) {
                throw new ComparisonException(a, b);
            }
            return true;
        }
    }

    public static class ArrayComparerDelegate
    implements DeepComparerDelegate {
        @Override
        public boolean compare(Object a, Object b, DeepComparer comparer) throws ComparisonException {
            if (!a.getClass().isArray() || !b.getClass().isArray()) {
                return false;
            }
            Class<?> clazz = a.getClass();
            if (!clazz.getComponentType().isPrimitive()) {
                Object[] aObjB = (Object[])b;
                Object[] aObjA = (Object[])a;
                int length = aObjA.length;
                if (aObjB.length != length) {
                    throw new ComparisonException(a, b);
                }
                for (int i = 0; i < length; ++i) {
                    Object ac = aObjA[i];
                    Object bc = aObjB[i];
                    comparer.compare(ac, bc);
                }
            } else {
                boolean eq;
                try {
                    Method cmp = Arrays.class.getMethod("equals", clazz, clazz);
                    eq = (Boolean)cmp.invoke(null, a, b);
                }
                catch (Exception e) {
                    throw new RuntimeException("Internal error!", e);
                }
                if (!eq) {
                    throw new ComparisonException(a, b);
                }
            }
            return true;
        }
    }
}

