/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import arq.cmdline.ModLangOutput;
import java.io.OutputStream;
import jena.cmd.CmdException;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import tdb.cmdline.CmdTDB;

public class tdbdump
extends CmdTDB {
    static ModLangOutput modLangOutput = new ModLangOutput();

    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbdump(argv).mainRun();
    }

    protected tdbdump(String[] argv) {
        super(argv);
        this.addModule(modLangOutput);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " : Write a dataset to stdout (defaults to N-Quads)";
    }

    @Override
    protected void exec() {
        DatasetGraphTDB dsg = super.getDatasetGraphTDB();
        RDFFormat fmt = modLangOutput.getOutputStreamFormat();
        if (fmt == null) {
            fmt = modLangOutput.getOutputFormatted();
        }
        if (fmt == null) {
            fmt = RDFFormat.NQUADS;
        }
        if (!RDFLanguages.isQuads((Lang)fmt.getLang())) {
            throw new CmdException("Databases can be dumped only in quad formats (e.g. Trig, N-Quads), not " + fmt.getLang());
        }
        RDFDataMgr.write((OutputStream)System.out, (DatasetGraph)dsg, (RDFFormat)fmt);
    }
}

