/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Vector;

public class PowerMockUtils {
    public static Iterator<Class<?>> getClassIterator(ClassLoader classLoader) throws NoSuchFieldException, IllegalAccessException {
        Class<?> classLoaderClass;
        for (classLoaderClass = classLoader.getClass(); classLoaderClass != ClassLoader.class; classLoaderClass = classLoaderClass.getSuperclass()) {
        }
        Field classesField = classLoaderClass.getDeclaredField("classes");
        classesField.setAccessible(true);
        Vector classes = (Vector)classesField.get(classLoader);
        return classes.iterator();
    }

    public static void printClassesLoadedByClassloader(ClassLoader classLoader, boolean includeParent) throws NoSuchFieldException, IllegalAccessException {
        while (classLoader != null) {
            System.out.println("ClassLoader: " + classLoader);
            Iterator<Class<?>> iter = PowerMockUtils.getClassIterator(classLoader);
            while (iter.hasNext()) {
                System.out.println("\t" + iter.next());
            }
            if (includeParent) {
                classLoader = classLoader.getParent();
                continue;
            }
            classLoader = null;
        }
    }
}

