/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.test.nodes;

import de.fau.cs.osr.ptk.common.test.nodes.CtnBody;
import de.fau.cs.osr.ptk.common.test.nodes.CtnDocument;
import de.fau.cs.osr.ptk.common.test.nodes.CtnIdNode;
import de.fau.cs.osr.ptk.common.test.nodes.CtnNode;
import de.fau.cs.osr.ptk.common.test.nodes.CtnNodeList;
import de.fau.cs.osr.ptk.common.test.nodes.CtnNodeWithObjProp;
import de.fau.cs.osr.ptk.common.test.nodes.CtnNodeWithPropAndContent;
import de.fau.cs.osr.ptk.common.test.nodes.CtnSection;
import de.fau.cs.osr.ptk.common.test.nodes.CtnText;
import de.fau.cs.osr.ptk.common.test.nodes.CtnTitle;
import de.fau.cs.osr.ptk.common.test.nodes.CtnUrl;

public class CtnBuilder {
    public static CtnText ctnText() {
        return new CtnText("Default text");
    }

    public static CtnText ctnText(String text) {
        return new CtnText(text);
    }

    public static CtnNodeList ctnList() {
        return new CtnNodeList();
    }

    public static CtnNodeList ctnList(CtnNode ... children) {
        return new CtnNodeList(children);
    }

    public static SectionBuilder ctnSection() {
        return new SectionBuilder();
    }

    public static CtnTitle ctnTitle(CtnNode ... children) {
        return new CtnTitle.CtnTitleImpl(children);
    }

    public static CtnBody ctnBody(CtnNode ... children) {
        return new CtnBody.CtnBodyImpl(children);
    }

    public static CtnDocument ctnDoc(CtnNode ... children) {
        return new CtnDocument(children);
    }

    public static CtnIdNode ctnId(int i) {
        return new CtnIdNode(i);
    }

    public static UrlBuilder ctnUrl() {
        return new UrlBuilder();
    }

    public static CtnNodeWithObjProp ctnObjProp(Object prop) {
        return new CtnNodeWithObjProp(prop);
    }

    public static CtnNodeWithPropAndContent ctnPropContent(Object prop, String content) {
        return new CtnNodeWithPropAndContent(prop, content);
    }

    public static final class UrlBuilder {
        private String protocol = "http";
        private String path = "example.org";

        public UrlBuilder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public UrlBuilder withPath(String path) {
            this.path = path;
            return this;
        }

        public CtnUrl build() {
            return new CtnUrl(this.protocol, this.path);
        }
    }

    public static final class SectionBuilder {
        private int level = 0;
        private CtnTitle title = new CtnTitle.CtnTitleImpl(new CtnNode[]{CtnBuilder.ctnText("Default section title")});
        private CtnBody body = new CtnBody.CtnBodyImpl(new CtnNode[]{CtnBuilder.ctnText("Default section body")});

        public SectionBuilder withLevel(int level) {
            this.level = level;
            return this;
        }

        public SectionBuilder withTitle(CtnTitle title) {
            this.title = title;
            return this;
        }

        public SectionBuilder withTitle(CtnNode ... children) {
            this.title = new CtnTitle.CtnTitleImpl(children);
            return this;
        }

        public SectionBuilder withBody(CtnBody body) {
            this.body = body;
            return this;
        }

        public SectionBuilder withBody(CtnNode ... children) {
            this.body = new CtnBody.CtnBodyImpl(children);
            return this;
        }

        public CtnSection build() {
            return new CtnSection(this.level, this.title, this.body);
        }
    }
}

